"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateToV13 = exports.updateToV12 = exports.updateToV11 = exports.updateToV10 = exports.updateToV9 = exports.updateToV8 = exports.updateToV7 = exports.updateToV6 = void 0;
const target_version_1 = require("../update-tool/target-version");
const upgrade_data_1 = require("./upgrade-data");
const devkit_migration_rule_1 = require("./devkit-migration-rule");
const tilde_import_migration_1 = require("./migrations/tilde-import-v13/tilde-import-migration");
const cdkMigrations = [tilde_import_migration_1.TildeImportMigration];
/** Entry point for the migration schematics with target of Angular CDK 6.0.0 */
function updateToV6() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V6, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV6 = updateToV6;
/** Entry point for the migration schematics with target of Angular CDK 7.0.0 */
function updateToV7() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V7, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV7 = updateToV7;
/** Entry point for the migration schematics with target of Angular CDK 8.0.0 */
function updateToV8() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V8, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV8 = updateToV8;
/** Entry point for the migration schematics with target of Angular CDK 9.0.0 */
function updateToV9() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V9, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV9 = updateToV9;
/** Entry point for the migration schematics with target of Angular CDK 10.0.0 */
function updateToV10() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V10, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV10 = updateToV10;
/** Entry point for the migration schematics with target of Angular CDK 11.0.0 */
function updateToV11() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V11, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV11 = updateToV11;
/** Entry point for the migration schematics with target of Angular CDK 12.0.0 */
function updateToV12() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V12, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV12 = updateToV12;
/** Entry point for the migration schematics with target of Angular CDK 13.0.0 */
function updateToV13() {
    return (0, devkit_migration_rule_1.createMigrationSchematicRule)(target_version_1.TargetVersion.V13, cdkMigrations, upgrade_data_1.cdkUpgradeData, onMigrationComplete);
}
exports.updateToV13 = updateToV13;
/** Function that will be called when the migration completed. */
function onMigrationComplete(context, targetVersion, hasFailures) {
    context.logger.info('');
    context.logger.info(`  ✓  Updated Angular CDK to ${targetVersion}`);
    context.logger.info('');
    if (hasFailures) {
        context.logger.warn('  ⚠  Some issues were detected but could not be fixed automatically. Please check the ' +
            'output above and fix these issues manually.');
    }
}
//# sourceMappingURL=data:application/json;base64,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