/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/cdk/a11y"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/common"),require("@angular/forms"),require("rxjs"),require("rxjs/operators")):"function"==typeof define&&define.amd?define("@angular/cdk/stepper",["exports","@angular/core","@angular/cdk/a11y","@angular/cdk/bidi","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/common","@angular/forms","rxjs","rxjs/operators"],t):t((e.ng=e.ng||{},e.ng.cdk=e.ng.cdk||{},e.ng.cdk.stepper={}),e.ng.core,e.ng.cdk.a11y,e.ng.cdk.bidi,e.ng.cdk.coercion,e.ng.cdk.keycodes,e.ng.common,e.ng.forms,e.rxjs,e.rxjs.operators)}(this,function(e,t,r,n,o,i,s,p,a,c){"use strict";var u=function(){function e(e){this.template=e}return e.decorators=[{type:t.Directive,args:[{selector:"[cdkStepLabel]"}]}],e.ctorParameters=function(){return[{type:t.TemplateRef}]},e}(),d=0,l=function(){function e(){}return e}(),h={NUMBER:"number",EDIT:"edit",DONE:"done",ERROR:"error"},y=new t.InjectionToken("mat-stepper-global-options"),_=function(){function e(e,t){this._stepper=e,this.interacted=!1,this._editable=!0,this._optional=!1,this._customCompleted=null,this._customError=null,this._stepperOptions=t||{},this._displayDefaultIndicatorType=!1!==this._stepperOptions.displayDefaultIndicatorType,this._showError=!!this._stepperOptions.showError}return Object.defineProperty(e.prototype,"editable",{get:function(){return this._editable},set:function(e){this._editable=o.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"optional",{get:function(){return this._optional},set:function(e){this._optional=o.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"completed",{get:function(){return null==this._customCompleted?this._getDefaultCompleted():this._customCompleted},set:function(e){this._customCompleted=o.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),e.prototype._getDefaultCompleted=function(){return this.stepControl?this.stepControl.valid&&this.interacted:this.interacted},Object.defineProperty(e.prototype,"hasError",{get:function(){return this._customError||this._getDefaultError()},set:function(e){this._customError=o.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),e.prototype._getDefaultError=function(){return this.stepControl&&this.stepControl.invalid&&this.interacted},e.prototype.select=function(){this._stepper.selected=this},e.prototype.reset=function(){this.interacted=!1,null!=this._customCompleted&&(this._customCompleted=!1),null!=this._customError&&(this._customError=!1),this.stepControl&&this.stepControl.reset()},e.prototype.ngOnChanges=function(){this._stepper._stateChanged()},e.decorators=[{type:t.Component,args:[{selector:"cdk-step",exportAs:"cdkStep",template:"<ng-template><ng-content></ng-content></ng-template>",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:f,decorators:[{type:t.Inject,args:[t.forwardRef(function(){return f})]}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[y]}]}]},e.propDecorators={stepLabel:[{type:t.ContentChild,args:[u]}],content:[{type:t.ViewChild,args:[t.TemplateRef]}],stepControl:[{type:t.Input}],label:[{type:t.Input}],errorMessage:[{type:t.Input}],ariaLabel:[{type:t.Input,args:["aria-label"]}],ariaLabelledby:[{type:t.Input,args:["aria-labelledby"]}],state:[{type:t.Input}],editable:[{type:t.Input}],optional:[{type:t.Input}],completed:[{type:t.Input}],hasError:[{type:t.Input}]},e}(),f=function(){function e(e,r,n,o){this._dir=e,this._changeDetectorRef=r,this._elementRef=n,this._destroyed=new a.Subject,this._linear=!1,this._selectedIndex=0,this.selectionChange=new t.EventEmitter,this._orientation="horizontal",this._groupId=d++,this._document=o}return Object.defineProperty(e.prototype,"linear",{get:function(){return this._linear},set:function(e){this._linear=o.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selectedIndex",{get:function(){return this._selectedIndex},set:function(e){if(this._steps){if(e<0||e>this._steps.length-1)throw Error("cdkStepper: Cannot assign out-of-bounds value to `selectedIndex`.");this._selectedIndex!=e&&!this._anyControlsInvalidOrPending(e)&&(e>=this._selectedIndex||this._steps.toArray()[e].editable)&&this._updateSelectedItemIndex(e)}else this._selectedIndex=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){return this._steps?this._steps.toArray()[this.selectedIndex]:void 0},set:function(e){this.selectedIndex=this._steps?this._steps.toArray().indexOf(e):-1},enumerable:!0,configurable:!0}),e.prototype.ngAfterViewInit=function(){var e=this;this._keyManager=new r.FocusKeyManager(this._stepHeader).withWrap().withVerticalOrientation("vertical"===this._orientation),(this._dir?this._dir.change:a.of()).pipe(c.startWith(this._layoutDirection()),c.takeUntil(this._destroyed)).subscribe(function(t){return e._keyManager.withHorizontalOrientation(t)}),this._keyManager.updateActiveItemIndex(this._selectedIndex),this._steps.changes.pipe(c.takeUntil(this._destroyed)).subscribe(function(){e.selected||(e._selectedIndex=Math.max(e._selectedIndex-1,0))})},e.prototype.ngOnDestroy=function(){this._destroyed.next(),this._destroyed.complete()},e.prototype.next=function(){this.selectedIndex=Math.min(this._selectedIndex+1,this._steps.length-1)},e.prototype.previous=function(){this.selectedIndex=Math.max(this._selectedIndex-1,0)},e.prototype.reset=function(){this._updateSelectedItemIndex(0),this._steps.forEach(function(e){return e.reset()}),this._stateChanged()},e.prototype._getStepLabelId=function(e){return"cdk-step-label-"+this._groupId+"-"+e},e.prototype._getStepContentId=function(e){return"cdk-step-content-"+this._groupId+"-"+e},e.prototype._stateChanged=function(){this._changeDetectorRef.markForCheck()},e.prototype._getAnimationDirection=function(e){var t=e-this._selectedIndex;return t<0?"rtl"===this._layoutDirection()?"next":"previous":t>0?"rtl"===this._layoutDirection()?"previous":"next":"current"},e.prototype._getIndicatorType=function(e,t){void 0===t&&(t=h.NUMBER);var r=this._steps.toArray()[e],n=this._isCurrentStep(e);return r._displayDefaultIndicatorType?this._getDefaultIndicatorLogic(r,n):this._getGuidelineLogic(r,n,t)},e.prototype._getDefaultIndicatorLogic=function(e,t){return e._showError&&e.hasError&&!t?h.ERROR:!e.completed||t?h.NUMBER:e.editable?h.EDIT:h.DONE},e.prototype._getGuidelineLogic=function(e,t,r){return void 0===r&&(r=h.NUMBER),e._showError&&e.hasError&&!t?h.ERROR:e.completed&&!t?h.DONE:e.completed&&t?r:e.editable&&t?h.EDIT:r},e.prototype._isCurrentStep=function(e){return this._selectedIndex===e},e.prototype._getFocusIndex=function(){return this._keyManager?this._keyManager.activeItemIndex:this._selectedIndex},e.prototype._updateSelectedItemIndex=function(e){var t=this._steps.toArray();this.selectionChange.emit({selectedIndex:e,previouslySelectedIndex:this._selectedIndex,selectedStep:t[e],previouslySelectedStep:t[this._selectedIndex]}),this._containsFocus()?this._keyManager.setActiveItem(e):this._keyManager.updateActiveItemIndex(e),this._selectedIndex=e,this._stateChanged()},e.prototype._onKeydown=function(e){var t=e.keyCode;null==this._keyManager.activeItemIndex||t!==i.SPACE&&t!==i.ENTER?t===i.HOME?(this._keyManager.setFirstItemActive(),e.preventDefault()):t===i.END?(this._keyManager.setLastItemActive(),e.preventDefault()):this._keyManager.onKeydown(e):(this.selectedIndex=this._keyManager.activeItemIndex,e.preventDefault())},e.prototype._anyControlsInvalidOrPending=function(e){var t=this._steps.toArray();return t[this._selectedIndex].interacted=!0,!!(this._linear&&e>=0)&&t.slice(0,e).some(function(e){var t=e.stepControl;return(t?t.invalid||t.pending||!e.interacted:!e.completed)&&!e.optional})},e.prototype._layoutDirection=function(){return this._dir&&"rtl"===this._dir.value?"rtl":"ltr"},e.prototype._containsFocus=function(){if(!this._document||!this._elementRef)return!1;var e=this._elementRef.nativeElement,t=this._document.activeElement;return e===t||e.contains(t)},e.decorators=[{type:t.Directive,args:[{selector:"[cdkStepper]",exportAs:"cdkStepper"}]}],e.ctorParameters=function(){return[{type:n.Directionality,decorators:[{type:t.Optional}]},{type:t.ChangeDetectorRef},{type:t.ElementRef},{type:void 0,decorators:[{type:t.Inject,args:[s.DOCUMENT]}]}]},e.propDecorators={_steps:[{type:t.ContentChildren,args:[_]}],linear:[{type:t.Input}],selectedIndex:[{type:t.Input}],selected:[{type:t.Input}],selectionChange:[{type:t.Output}]},e}(),g=function(){function e(e){this._stepper=e,this.type="submit"}return e.decorators=[{type:t.Directive,args:[{selector:"button[cdkStepperNext]",host:{"(click)":"_stepper.next()","[type]":"type"}}]}],e.ctorParameters=function(){return[{type:f}]},e.propDecorators={type:[{type:t.Input}]},e}(),m=function(){function e(e){this._stepper=e,this.type="button"}return e.decorators=[{type:t.Directive,args:[{selector:"button[cdkStepperPrevious]",host:{"(click)":"_stepper.previous()","[type]":"type"}}]}],e.ctorParameters=function(){return[{type:f}]},e.propDecorators={type:[{type:t.Input}]},e}(),I=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[n.BidiModule,s.CommonModule],exports:[_,f,u,g,m],declarations:[_,f,u,g,m]}]}],e}();e.StepperSelectionEvent=l,e.STEP_STATE=h,e.MAT_STEPPER_GLOBAL_OPTIONS=y,e.CdkStep=_,e.CdkStepper=f,e.CdkStepLabel=u,e.CdkStepperNext=g,e.CdkStepperPrevious=m,e.CdkStepperModule=I,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=cdk-stepper.umd.min.js.map
