/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/cdk/coercion"),require("rxjs"),require("rxjs/operators"),require("@angular/cdk/platform"),require("@angular/cdk/bidi"),require("@angular/cdk/collections")):"function"==typeof define&&define.amd?define("@angular/cdk/scrolling",["exports","@angular/core","@angular/cdk/coercion","rxjs","rxjs/operators","@angular/cdk/platform","@angular/cdk/bidi","@angular/cdk/collections"],e):e((t.ng=t.ng||{},t.ng.cdk=t.ng.cdk||{},t.ng.cdk.scrolling={}),t.ng.core,t.ng.cdk.coercion,t.rxjs,t.rxjs.operators,t.ng.cdk.platform,t.ng.cdk.bidi,t.ng.cdk.collections)}(this,function(t,e,r,n,o,i,a,s){"use strict";function l(t,e){function r(){this.constructor=t}f(t,e),t.prototype=null===e?Object.create(e):(r.prototype=e.prototype,new r)}function c(t){return t._scrollStrategy}function d(t,e,r){return t||new v(e,r)}function u(t,e){return t.start==e.start&&t.end==e.end}function p(t,e){var r=e;if(!r.getBoundingClientRect)return 0;var n=r.getBoundingClientRect();return"horizontal"==t?n.width:n.height}function h(t,e,r){return t||new x(e,r)}var f=function(t,e){return(f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])})(t,e)},g=new e.InjectionToken("VIRTUAL_SCROLL_STRATEGY"),_=function(){function t(t,e,r){this._scrolledIndexChange=new n.Subject,this.scrolledIndexChange=this._scrolledIndexChange.pipe(o.distinctUntilChanged()),this._viewport=null,this._itemSize=t,this._minBufferPx=e,this._maxBufferPx=r}return t.prototype.attach=function(t){this._viewport=t,this._updateTotalContentSize(),this._updateRenderedRange()},t.prototype.detach=function(){this._scrolledIndexChange.complete(),this._viewport=null},t.prototype.updateItemAndBufferSize=function(t,e,r){if(r<e)throw Error("CDK virtual scroll: maxBufferPx must be greater than or equal to minBufferPx");this._itemSize=t,this._minBufferPx=e,this._maxBufferPx=r,this._updateTotalContentSize(),this._updateRenderedRange()},t.prototype.onContentScrolled=function(){this._updateRenderedRange()},t.prototype.onDataLengthChanged=function(){this._updateTotalContentSize(),this._updateRenderedRange()},t.prototype.onContentRendered=function(){},t.prototype.onRenderedOffsetChanged=function(){},t.prototype.scrollToIndex=function(t,e){this._viewport&&this._viewport.scrollToOffset(t*this._itemSize,e)},t.prototype._updateTotalContentSize=function(){this._viewport&&this._viewport.setTotalContentSize(this._viewport.getDataLength()*this._itemSize)},t.prototype._updateRenderedRange=function(){if(this._viewport){var t=this._viewport.measureScrollOffset(),e=t/this._itemSize,r=this._viewport.getRenderedRange(),n={start:r.start,end:r.end},o=this._viewport.getViewportSize(),i=this._viewport.getDataLength(),a=t-n.start*this._itemSize;if(a<this._minBufferPx&&0!=n.start){var s=Math.ceil((this._maxBufferPx-a)/this._itemSize);n.start=Math.max(0,n.start-s),n.end=Math.min(i,Math.ceil(e+(o+this._minBufferPx)/this._itemSize))}else{var l=n.end*this._itemSize-(t+o);if(l<this._minBufferPx&&n.end!=i){var c=Math.ceil((this._maxBufferPx-l)/this._itemSize);c>0&&(n.end=Math.min(i,n.end+c),n.start=Math.max(0,Math.floor(e-this._minBufferPx/this._itemSize)))}}this._viewport.setRenderedRange(n),this._viewport.setRenderedContentOffset(this._itemSize*n.start),this._scrolledIndexChange.next(Math.floor(e))}},t}(),m=function(){function t(){this._itemSize=20,this._minBufferPx=100,this._maxBufferPx=200,this._scrollStrategy=new _(this.itemSize,this.minBufferPx,this.maxBufferPx)}return Object.defineProperty(t.prototype,"itemSize",{get:function(){return this._itemSize},set:function(t){this._itemSize=r.coerceNumberProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"minBufferPx",{get:function(){return this._minBufferPx},set:function(t){this._minBufferPx=r.coerceNumberProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"maxBufferPx",{get:function(){return this._maxBufferPx},set:function(t){this._maxBufferPx=r.coerceNumberProperty(t)},enumerable:!0,configurable:!0}),t.prototype.ngOnChanges=function(){this._scrollStrategy.updateItemAndBufferSize(this.itemSize,this.minBufferPx,this.maxBufferPx)},t.decorators=[{type:e.Directive,args:[{selector:"cdk-virtual-scroll-viewport[itemSize]",providers:[{provide:g,useFactory:c,deps:[e.forwardRef(function(){return t})]}]}]}],t.propDecorators={itemSize:[{type:e.Input}],minBufferPx:[{type:e.Input}],maxBufferPx:[{type:e.Input}]},t}(),v=function(){function t(t,e){this._ngZone=t,this._platform=e,this._scrolled=new n.Subject,this._globalSubscription=null,this._scrolledCount=0,this.scrollContainers=new Map}return t.prototype.register=function(t){var e=this,r=t.elementScrolled().subscribe(function(){return e._scrolled.next(t)});this.scrollContainers.set(t,r)},t.prototype.deregister=function(t){var e=this.scrollContainers.get(t);e&&(e.unsubscribe(),this.scrollContainers.delete(t))},t.prototype.scrolled=function(t){var e=this;return void 0===t&&(t=20),this._platform.isBrowser?n.Observable.create(function(r){e._globalSubscription||e._addGlobalListener();var n=t>0?e._scrolled.pipe(o.auditTime(t)).subscribe(r):e._scrolled.subscribe(r);return e._scrolledCount++,function(){n.unsubscribe(),--e._scrolledCount||e._removeGlobalListener()}}):n.of()},t.prototype.ngOnDestroy=function(){var t=this;this._removeGlobalListener(),this.scrollContainers.forEach(function(e,r){return t.deregister(r)}),this._scrolled.complete()},t.prototype.ancestorScrolled=function(t,e){var r=this.getAncestorScrollContainers(t);return this.scrolled(e).pipe(o.filter(function(t){return!t||r.indexOf(t)>-1}))},t.prototype.getAncestorScrollContainers=function(t){var e=this,r=[];return this.scrollContainers.forEach(function(n,o){e._scrollableContainsElement(o,t)&&r.push(o)}),r},t.prototype._scrollableContainsElement=function(t,e){var r=e.nativeElement,n=t.getElementRef().nativeElement;do{if(r==n)return!0}while(r=r.parentElement);return!1},t.prototype._addGlobalListener=function(){var t=this;this._globalSubscription=this._ngZone.runOutsideAngular(function(){return n.fromEvent(window.document,"scroll").subscribe(function(){return t._scrolled.next()})})},t.prototype._removeGlobalListener=function(){this._globalSubscription&&(this._globalSubscription.unsubscribe(),this._globalSubscription=null)},t.decorators=[{type:e.Injectable,args:[{providedIn:"root"}]}],t.ctorParameters=function(){return[{type:e.NgZone},{type:i.Platform}]},t.ngInjectableDef=e.defineInjectable({factory:function(){return new t(e.inject(e.NgZone),e.inject(i.Platform))},token:t,providedIn:"root"}),t}(),y={provide:v,deps:[[new e.Optional,new e.SkipSelf,v],e.NgZone,i.Platform],useFactory:d},S=function(){function t(t,e,r,i){var a=this;this.elementRef=t,this.scrollDispatcher=e,this.ngZone=r,this.dir=i,this._destroyed=new n.Subject,this._elementScrolled=n.Observable.create(function(t){return a.ngZone.runOutsideAngular(function(){return n.fromEvent(a.elementRef.nativeElement,"scroll").pipe(o.takeUntil(a._destroyed)).subscribe(t)})})}return t.prototype.ngOnInit=function(){this.scrollDispatcher.register(this)},t.prototype.ngOnDestroy=function(){this.scrollDispatcher.deregister(this),this._destroyed.next(),this._destroyed.complete()},t.prototype.elementScrolled=function(){return this._elementScrolled},t.prototype.getElementRef=function(){return this.elementRef},t.prototype.scrollTo=function(t){var e=this.elementRef.nativeElement,r=this.dir&&"rtl"==this.dir.value;t.left=null==t.left?r?t.end:t.start:t.left,t.right=null==t.right?r?t.start:t.end:t.right,null!=t.bottom&&(t.top=e.scrollHeight-e.clientHeight-t.bottom),r&&i.getRtlScrollAxisType()!=i.RtlScrollAxisType.NORMAL?(null!=t.left&&(t.right=e.scrollWidth-e.clientWidth-t.left),i.getRtlScrollAxisType()==i.RtlScrollAxisType.INVERTED?t.left=t.right:i.getRtlScrollAxisType()==i.RtlScrollAxisType.NEGATED&&(t.left=t.right?-t.right:t.right)):null!=t.right&&(t.left=e.scrollWidth-e.clientWidth-t.right),this._applyScrollToOptions(t)},t.prototype._applyScrollToOptions=function(t){var e=this.elementRef.nativeElement;i.supportsScrollBehavior()?e.scrollTo(t):(null!=t.top&&(e.scrollTop=t.top),null!=t.left&&(e.scrollLeft=t.left))},t.prototype.measureScrollOffset=function(t){var e=this.elementRef.nativeElement;if("top"==t)return e.scrollTop;if("bottom"==t)return e.scrollHeight-e.clientHeight-e.scrollTop;var r=this.dir&&"rtl"==this.dir.value;return"start"==t?t=r?"right":"left":"end"==t&&(t=r?"left":"right"),r&&i.getRtlScrollAxisType()==i.RtlScrollAxisType.INVERTED?"left"==t?e.scrollWidth-e.clientWidth-e.scrollLeft:e.scrollLeft:r&&i.getRtlScrollAxisType()==i.RtlScrollAxisType.NEGATED?"left"==t?e.scrollLeft+e.scrollWidth-e.clientWidth:-e.scrollLeft:"left"==t?e.scrollLeft:e.scrollWidth-e.clientWidth-e.scrollLeft},t.decorators=[{type:e.Directive,args:[{selector:"[cdk-scrollable], [cdkScrollable]"}]}],t.ctorParameters=function(){return[{type:e.ElementRef},{type:v},{type:e.NgZone},{type:a.Directionality,decorators:[{type:e.Optional}]}]},t}(),w=function(t){function r(e,r,o,i,a,s){var l=t.call(this,e,s,o,a)||this;if(l.elementRef=e,l._changeDetectorRef=r,l._scrollStrategy=i,l._detachedSubject=new n.Subject,l._renderedRangeSubject=new n.Subject,l.orientation="vertical",l.scrolledIndexChange=n.Observable.create(function(t){return l._scrollStrategy.scrolledIndexChange.subscribe(function(e){return Promise.resolve().then(function(){return l.ngZone.run(function(){return t.next(e)})})})}),l.renderedRangeStream=l._renderedRangeSubject.asObservable(),l._totalContentSizeTransform="",l._totalContentSize=0,l._renderedRange={start:0,end:0},l._dataLength=0,l._viewportSize=0,l._renderedContentOffset=0,l._renderedContentOffsetNeedsRewrite=!1,l._isChangeDetectionPending=!1,l._runAfterChangeDetection=[],!i)throw Error('Error: cdk-virtual-scroll-viewport requires the "itemSize" property to be set.');return l}return l(r,t),r.prototype.ngOnInit=function(){var e=this;t.prototype.ngOnInit.call(this),this.ngZone.runOutsideAngular(function(){return Promise.resolve().then(function(){e._measureViewportSize(),e._scrollStrategy.attach(e),e.elementScrolled().pipe(o.startWith(null),o.auditTime(0,n.animationFrameScheduler)).subscribe(function(){return e._scrollStrategy.onContentScrolled()}),e._markChangeDetectionNeeded()})})},r.prototype.ngOnDestroy=function(){this.detach(),this._scrollStrategy.detach(),this._renderedRangeSubject.complete(),this._detachedSubject.complete(),t.prototype.ngOnDestroy.call(this)},r.prototype.attach=function(t){var e=this;if(this._forOf)throw Error("CdkVirtualScrollViewport is already attached.");this.ngZone.runOutsideAngular(function(){e._forOf=t,e._forOf.dataStream.pipe(o.takeUntil(e._detachedSubject)).subscribe(function(t){var r=t.length;r!==e._dataLength&&(e._dataLength=r,e._scrollStrategy.onDataLengthChanged()),e._doChangeDetection()})})},r.prototype.detach=function(){this._forOf=null,this._detachedSubject.next()},r.prototype.getDataLength=function(){return this._dataLength},r.prototype.getViewportSize=function(){return this._viewportSize},r.prototype.getRenderedRange=function(){return this._renderedRange},r.prototype.setTotalContentSize=function(t){if(this._totalContentSize!==t){this._totalContentSize=t;var e="horizontal"==this.orientation?"X":"Y";this._totalContentSizeTransform="scale"+e+"("+this._totalContentSize+")",this._markChangeDetectionNeeded()}},r.prototype.setRenderedRange=function(t){var e=this;u(this._renderedRange,t)||(this._renderedRangeSubject.next(this._renderedRange=t),this._markChangeDetectionNeeded(function(){return e._scrollStrategy.onContentRendered()}))},r.prototype.getOffsetToRenderedContentStart=function(){return this._renderedContentOffsetNeedsRewrite?null:this._renderedContentOffset},r.prototype.setRenderedContentOffset=function(t,e){var r=this;void 0===e&&(e="to-start");var n=this.dir&&"rtl"==this.dir.value,o="horizontal"==this.orientation,i=o?"X":"Y",a=o&&n?-1:1,s="translate"+i+"("+Number(a*t)+"px)";this._renderedContentOffset=t,"to-end"===e&&(s+=" translate"+i+"(-100%)",this._renderedContentOffsetNeedsRewrite=!0),this._renderedContentTransform!=s&&(this._renderedContentTransform=s,this._markChangeDetectionNeeded(function(){r._renderedContentOffsetNeedsRewrite?(r._renderedContentOffset-=r.measureRenderedContentSize(),r._renderedContentOffsetNeedsRewrite=!1,r.setRenderedContentOffset(r._renderedContentOffset)):r._scrollStrategy.onRenderedOffsetChanged()}))},r.prototype.scrollToOffset=function(t,e){void 0===e&&(e="auto");var r={behavior:e};"horizontal"===this.orientation?r.start=t:r.top=t,this.scrollTo(r)},r.prototype.scrollToIndex=function(t,e){void 0===e&&(e="auto"),this._scrollStrategy.scrollToIndex(t,e)},r.prototype.measureScrollOffset=function(e){return t.prototype.measureScrollOffset.call(this,e||("horizontal"===this.orientation?"start":"top"))},r.prototype.measureRenderedContentSize=function(){var t=this._contentWrapper.nativeElement;return"horizontal"===this.orientation?t.offsetWidth:t.offsetHeight},r.prototype.measureRangeSize=function(t){return this._forOf?this._forOf.measureRangeSize(t,this.orientation):0},r.prototype.checkViewportSize=function(){this._measureViewportSize(),this._scrollStrategy.onDataLengthChanged()},r.prototype._measureViewportSize=function(){var t=this.elementRef.nativeElement;this._viewportSize="horizontal"===this.orientation?t.clientWidth:t.clientHeight},r.prototype._markChangeDetectionNeeded=function(t){var e=this;t&&this._runAfterChangeDetection.push(t),this._isChangeDetectionPending||(this._isChangeDetectionPending=!0,this.ngZone.runOutsideAngular(function(){return Promise.resolve().then(function(){e._doChangeDetection()})}))},r.prototype._doChangeDetection=function(){var t=this;this._isChangeDetectionPending=!1,this.ngZone.run(function(){return t._changeDetectorRef.markForCheck()}),this._contentWrapper.nativeElement.style.transform=this._renderedContentTransform;var e=this._runAfterChangeDetection;this._runAfterChangeDetection=[];for(var r=0,n=e;r<n.length;r++){(0,n[r])()}},r.decorators=[{type:e.Component,args:[{selector:"cdk-virtual-scroll-viewport",template:'<div #contentWrapper class="cdk-virtual-scroll-content-wrapper"><ng-content></ng-content></div><div class="cdk-virtual-scroll-spacer" [style.transform]="_totalContentSizeTransform"></div>',styles:["cdk-virtual-scroll-viewport{display:block;position:relative;overflow:auto;contain:strict;transform:translateZ(0);will-change:scroll-position;-webkit-overflow-scrolling:touch}.cdk-virtual-scroll-content-wrapper{position:absolute;top:0;left:0;contain:content}[dir=rtl] .cdk-virtual-scroll-content-wrapper{right:0;left:auto}.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper{min-height:100%}.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>dl:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>ol:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>table:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-horizontal .cdk-virtual-scroll-content-wrapper>ul:not([cdkVirtualFor]){padding-left:0;padding-right:0;margin-left:0;margin-right:0;border-left-width:0;border-right-width:0;outline:0}.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper{min-width:100%}.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>dl:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>ol:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>table:not([cdkVirtualFor]),.cdk-virtual-scroll-orientation-vertical .cdk-virtual-scroll-content-wrapper>ul:not([cdkVirtualFor]){padding-top:0;padding-bottom:0;margin-top:0;margin-bottom:0;border-top-width:0;border-bottom-width:0;outline:0}.cdk-virtual-scroll-spacer{position:absolute;top:0;left:0;height:1px;width:1px;transform-origin:0 0}[dir=rtl] .cdk-virtual-scroll-spacer{right:0;left:auto;transform-origin:100% 0}"],host:{class:"cdk-virtual-scroll-viewport","[class.cdk-virtual-scroll-orientation-horizontal]":'orientation === "horizontal"',"[class.cdk-virtual-scroll-orientation-vertical]":'orientation === "vertical"'},encapsulation:e.ViewEncapsulation.None,changeDetection:e.ChangeDetectionStrategy.OnPush}]}],r.ctorParameters=function(){return[{type:e.ElementRef},{type:e.ChangeDetectorRef},{type:e.NgZone},{type:void 0,decorators:[{type:e.Optional},{type:e.Inject,args:[g]}]},{type:a.Directionality,decorators:[{type:e.Optional}]},{type:v}]},r.propDecorators={orientation:[{type:e.Input}],scrolledIndexChange:[{type:e.Output}],_contentWrapper:[{type:e.ViewChild,args:["contentWrapper"]}]},r}(S),C=function(){function t(t,e,r,i,a){var s=this;this._viewContainerRef=t,this._template=e,this._differs=r,this._viewport=i,this.viewChange=new n.Subject,this._dataSourceChanges=new n.Subject,this.cdkVirtualForTemplateCacheSize=20,this.dataStream=this._dataSourceChanges.pipe(o.startWith(null),o.pairwise(),o.switchMap(function(t){var e=t[0],r=t[1];return s._changeDataSource(e,r)}),o.shareReplay(1)),this._differ=null,this._templateCache=[],this._needsUpdate=!1,this._destroyed=new n.Subject,this.dataStream.subscribe(function(t){s._data=t,s._onRenderedDataChange()}),this._viewport.renderedRangeStream.pipe(o.takeUntil(this._destroyed)).subscribe(function(t){s._renderedRange=t,a.run(function(){return s.viewChange.next(s._renderedRange)}),s._onRenderedDataChange()}),this._viewport.attach(this)}return Object.defineProperty(t.prototype,"cdkVirtualForOf",{get:function(){return this._cdkVirtualForOf},set:function(t){this._cdkVirtualForOf=t;var e=t instanceof s.DataSource?t:new s.ArrayDataSource(t instanceof n.Observable?t:Array.prototype.slice.call(t||[]));this._dataSourceChanges.next(e)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cdkVirtualForTrackBy",{get:function(){return this._cdkVirtualForTrackBy},set:function(t){var e=this;this._needsUpdate=!0,this._cdkVirtualForTrackBy=t?function(r,n){return t(r+(e._renderedRange?e._renderedRange.start:0),n)}:void 0},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"cdkVirtualForTemplate",{set:function(t){t&&(this._needsUpdate=!0,this._template=t)},enumerable:!0,configurable:!0}),t.prototype.measureRangeSize=function(t,e){if(t.start>=t.end)return 0;if(t.start<this._renderedRange.start||t.end>this._renderedRange.end)throw Error("Error: attempted to measure an item that isn't rendered.");for(var r=t.start-this._renderedRange.start,n=t.end-t.start,o=0,i=n;i--;)for(var a=this._viewContainerRef.get(i+r),s=a?a.rootNodes.length:0;s--;)o+=p(e,a.rootNodes[s]);return o},t.prototype.ngDoCheck=function(){if(this._differ&&this._needsUpdate){var t=this._differ.diff(this._renderedItems);t?this._applyChanges(t):this._updateContext(),this._needsUpdate=!1}},t.prototype.ngOnDestroy=function(){this._viewport.detach(),this._dataSourceChanges.complete(),this.viewChange.complete(),this._destroyed.next(),this._destroyed.complete();for(var t=0,e=this._templateCache;t<e.length;t++){e[t].destroy()}},t.prototype._onRenderedDataChange=function(){this._renderedRange&&(this._renderedItems=this._data.slice(this._renderedRange.start,this._renderedRange.end),this._differ||(this._differ=this._differs.find(this._renderedItems).create(this.cdkVirtualForTrackBy)),this._needsUpdate=!0)},t.prototype._changeDataSource=function(t,e){return t&&t.disconnect(this),this._needsUpdate=!0,e.connect(this)},t.prototype._updateContext=function(){for(var t=this._data.length,e=this._viewContainerRef.length;e--;){var r=this._viewContainerRef.get(e);r.context.index=this._renderedRange.start+e,r.context.count=t,this._updateComputedContextProperties(r.context),r.detectChanges()}},t.prototype._applyChanges=function(t){var e=this;t.forEachOperation(function(t,r,n){if(null==t.previousIndex){var o=e._getViewForNewItem();e._viewContainerRef.insert(o,n),o.context.$implicit=t.item}else if(null==n)e._cacheView(e._viewContainerRef.detach(r));else{var o=e._viewContainerRef.get(r);e._viewContainerRef.move(o,n),o.context.$implicit=t.item}}),t.forEachIdentityChange(function(t){e._viewContainerRef.get(t.currentIndex).context.$implicit=t.item});for(var r=this._data.length,n=this._viewContainerRef.length;n--;){var o=this._viewContainerRef.get(n);o.context.index=this._renderedRange.start+n,o.context.count=r,this._updateComputedContextProperties(o.context)}},t.prototype._cacheView=function(t){this._templateCache.length<this.cdkVirtualForTemplateCacheSize?this._templateCache.push(t):t.destroy()},t.prototype._getViewForNewItem=function(){return this._templateCache.pop()||this._viewContainerRef.createEmbeddedView(this._template,{$implicit:null,cdkVirtualForOf:this._cdkVirtualForOf,index:-1,count:-1,first:!1,last:!1,odd:!1,even:!1})},t.prototype._updateComputedContextProperties=function(t){t.first=0===t.index,t.last=t.index===t.count-1,t.even=t.index%2==0,t.odd=!t.even},t.decorators=[{type:e.Directive,args:[{selector:"[cdkVirtualFor][cdkVirtualForOf]"}]}],t.ctorParameters=function(){return[{type:e.ViewContainerRef},{type:e.TemplateRef},{type:e.IterableDiffers},{type:w,decorators:[{type:e.SkipSelf}]},{type:e.NgZone}]},t.propDecorators={cdkVirtualForOf:[{type:e.Input}],cdkVirtualForTrackBy:[{type:e.Input}],cdkVirtualForTemplate:[{type:e.Input}],cdkVirtualForTemplateCacheSize:[{type:e.Input}]},t}(),R=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{imports:[a.BidiModule,i.PlatformModule],exports:[a.BidiModule,m,S,C,w],declarations:[m,S,C,w]}]}],t}(),b=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{imports:[R],exports:[R]}]}],t}(),x=function(){function t(t,e){var r=this;this._platform=t,e.runOutsideAngular(function(){r._change=t.isBrowser?n.merge(n.fromEvent(window,"resize"),n.fromEvent(window,"orientationchange")):n.of(),r._invalidateCache=r.change().subscribe(function(){return r._updateViewportSize()})})}return t.prototype.ngOnDestroy=function(){this._invalidateCache.unsubscribe()},t.prototype.getViewportSize=function(){this._viewportSize||this._updateViewportSize();var t={width:this._viewportSize.width,height:this._viewportSize.height};return this._platform.isBrowser||(this._viewportSize=null),t},t.prototype.getViewportRect=function(){var t=this.getViewportScrollPosition(),e=this.getViewportSize(),r=e.width,n=e.height;return{top:t.top,left:t.left,bottom:t.top+n,right:t.left+r,height:n,width:r}},t.prototype.getViewportScrollPosition=function(){if(!this._platform.isBrowser)return{top:0,left:0};var t=document.documentElement,e=t.getBoundingClientRect();return{top:-e.top||document.body.scrollTop||window.scrollY||t.scrollTop||0,left:-e.left||document.body.scrollLeft||window.scrollX||t.scrollLeft||0}},t.prototype.change=function(t){return void 0===t&&(t=20),t>0?this._change.pipe(o.auditTime(t)):this._change},t.prototype._updateViewportSize=function(){this._viewportSize=this._platform.isBrowser?{width:window.innerWidth,height:window.innerHeight}:{width:0,height:0}},t.decorators=[{type:e.Injectable,args:[{providedIn:"root"}]}],t.ctorParameters=function(){return[{type:i.Platform},{type:e.NgZone}]},t.ngInjectableDef=e.defineInjectable({factory:function(){return new t(e.inject(i.Platform),e.inject(e.NgZone))},token:t,providedIn:"root"}),t}(),k={provide:x,deps:[[new e.Optional,new e.SkipSelf,x],i.Platform,e.NgZone],useFactory:h};t._fixedSizeVirtualScrollStrategyFactory=c,t.FixedSizeVirtualScrollStrategy=_,t.CdkFixedSizeVirtualScroll=m,t.SCROLL_DISPATCHER_PROVIDER_FACTORY=d,t.DEFAULT_SCROLL_TIME=20,t.ScrollDispatcher=v,t.SCROLL_DISPATCHER_PROVIDER=y,t.CdkScrollable=S,t.ScrollingModule=R,t.ScrollDispatchModule=b,t.VIEWPORT_RULER_PROVIDER_FACTORY=h,t.DEFAULT_RESIZE_TIME=20,t.ViewportRuler=x,t.VIEWPORT_RULER_PROVIDER=k,t.CdkVirtualForOf=C,t.VIRTUAL_SCROLL_STRATEGY=g,t.CdkVirtualScrollViewport=w,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=cdk-scrolling.umd.min.js.map
