/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/common"),require("@angular/cdk/platform"),require("rxjs"),require("@angular/cdk/bidi"),require("@angular/cdk/scrolling"),require("rxjs/operators"),require("@angular/cdk/coercion")):"function"==typeof define&&define.amd?define("@angular/cdk/dragDrop",["exports","@angular/core","@angular/common","@angular/cdk/platform","rxjs","@angular/cdk/bidi","@angular/cdk/scrolling","rxjs/operators","@angular/cdk/coercion"],e):e((t.ng=t.ng||{},t.ng.cdk=t.ng.cdk||{},t.ng.cdk.dragDrop={}),t.ng.core,t.ng.common,t.ng.cdk.platform,t.rxjs,t.ng.cdk.bidi,t.ng.cdk.scrolling,t.rxjs.operators,t.ng.cdk.coercion)}(this,function(t,e,i,r,n,o,s,a,p){"use strict";function c(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i]);return t}function h(t,e){var i=e?"":"none";c(t.style,{touchAction:e?"":"none",webkitUserDrag:e?"":"none",webkitTapHighlightColor:e?"":"transparent",userSelect:i,msUserSelect:i,webkitUserSelect:i,MozUserSelect:i})}function l(t){var e=t.toLowerCase().indexOf("ms")>-1?1:1e3;return parseFloat(t)*e}function d(t){var e=getComputedStyle(t),i=g(e,"transition-property"),r=i.find(function(t){return"transform"===t||"all"===t});if(!r)return 0;var n=i.indexOf(r),o=g(e,"transition-duration"),s=g(e,"transition-delay");return l(o[n])+l(s[n])}function g(t,e){return t.getPropertyValue(e).split(",").map(function(t){return t.trim()})}function u(){return{dragStartThreshold:5,pointerDirectionChangeThreshold:5}}function _(t,e){return"translate3d("+t+"px, "+e+"px, 0)"}function f(t,e,i){var r=y(e,t.length-1),n=y(i,t.length-1);if(r!==n){for(var o=t[r],s=n<r?-1:1,a=r;a!==n;a+=s)t[a]=t[a+s];t[n]=o}}function m(t,e,i,r){var n=y(i,t.length-1),o=y(r,e.length);t.length&&e.splice(o,0,t.splice(n,1)[0])}function v(t,e,i,r){var n=y(r,e.length);t.length&&e.splice(n,0,t[i])}function y(t,e){return Math.max(0,Math.min(e,t))}function D(t,e){for(var i=0;i<t.length;i++)if(e(t[i],i,t))return i;return-1}function E(t,e,i){var r=t.top,n=t.bottom,o=t.left,s=t.right;return i>=r&&i<=n&&e>=o&&e<=s}var C=r.normalizePassiveListenerOptions({passive:!1}),P=function(){function t(t,e){var i=this;this._ngZone=t,this._dropInstances=new Set,this._dragInstances=new Set,this._activeDragInstances=new Set,this._globalListeners=new Map,this.pointerMove=new n.Subject,this.pointerUp=new n.Subject,this._preventScrollListener=function(t){i._activeDragInstances.size&&t.preventDefault()},this._document=e}return t.prototype.registerDropContainer=function(t){if(!this._dropInstances.has(t)){if(this.getDropContainer(t.id))throw Error('Drop instance with id "'+t.id+'" has already been registered.');this._dropInstances.add(t)}},t.prototype.registerDragItem=function(t){var e=this;this._dragInstances.add(t),1===this._dragInstances.size&&this._ngZone.runOutsideAngular(function(){e._document.addEventListener("touchmove",e._preventScrollListener,C)})},t.prototype.removeDropContainer=function(t){this._dropInstances.delete(t)},t.prototype.removeDragItem=function(t){this._dragInstances.delete(t),this.stopDragging(t),0===this._dragInstances.size&&this._document.removeEventListener("touchmove",this._preventScrollListener,C)},t.prototype.startDragging=function(t,e){var i=this;if(this._activeDragInstances.add(t),1===this._activeDragInstances.size){var r=e.type.startsWith("touch"),n=r?"touchmove":"mousemove",o=r?"touchend":"mouseup";h(this._document.body,!1),this._globalListeners.set(n,{handler:function(t){return i.pointerMove.next(t)},options:C}).set(o,{handler:function(t){return i.pointerUp.next(t)}}).forEach(function(t,e){i._ngZone.runOutsideAngular(function(){i._document.addEventListener(e,t.handler,t.options)})})}},t.prototype.stopDragging=function(t){this._activeDragInstances.delete(t),0===this._activeDragInstances.size&&(this._clearGlobalListeners(),h(this._document.body,!0))},t.prototype.isDragging=function(t){return this._activeDragInstances.has(t)},t.prototype.getDropContainer=function(t){return Array.from(this._dropInstances).find(function(e){return e.id===t})},t.prototype.ngOnDestroy=function(){var t=this;this._dragInstances.forEach(function(e){return t.removeDragItem(e)}),this._dropInstances.forEach(function(e){return t.removeDropContainer(e)}),this._clearGlobalListeners(),this.pointerMove.complete(),this.pointerUp.complete()},t.prototype._clearGlobalListeners=function(){var t=this;this._globalListeners.forEach(function(e,i){t._document.removeEventListener(i,e.handler,e.options)}),this._globalListeners.clear()},t.decorators=[{type:e.Injectable,args:[{providedIn:"root"}]}],t.ctorParameters=function(){return[{type:e.NgZone},{type:void 0,decorators:[{type:e.Inject,args:[i.DOCUMENT]}]}]},t.ngInjectableDef=e.defineInjectable({factory:function(){return new t(e.inject(e.NgZone),e.inject(i.DOCUMENT))},token:t,providedIn:"root"}),t}(),b=new e.InjectionToken("CDK_DRAG_PARENT"),x=function(){function t(t,e){this.element=t,this._parentDrag=e,h(t.nativeElement,!1)}return t.decorators=[{type:e.Directive,args:[{selector:"[cdkDragHandle]",host:{class:"cdk-drag-handle"}}]}],t.ctorParameters=function(){return[{type:e.ElementRef},{type:void 0,decorators:[{type:e.Inject,args:[b]},{type:e.Optional}]}]},t}(),w=function(){function t(t){this.templateRef=t}return t.decorators=[{type:e.Directive,args:[{selector:"ng-template[cdkDragPlaceholder]"}]}],t.ctorParameters=function(){return[{type:e.TemplateRef}]},t.propDecorators={data:[{type:e.Input}]},t}(),I=function(){function t(t){this.templateRef=t}return t.decorators=[{type:e.Directive,args:[{selector:"ng-template[cdkDragPreview]"}]}],t.ctorParameters=function(){return[{type:e.TemplateRef}]},t.propDecorators={data:[{type:e.Input}]},t}(),R=new e.InjectionToken("CDK_DROP_LIST_CONTAINER"),k=new e.InjectionToken("CDK_DRAG_CONFIG",{providedIn:"root",factory:u}),S=r.normalizePassiveListenerOptions({passive:!0}),O=function(){function t(t,i,r,o,s,a,p,c,h){var l=this;this.element=t,this.dropContainer=i,this._ngZone=o,this._viewContainerRef=s,this._viewportRuler=a,this._dragDropRegistry=p,this._config=c,this._dir=h,this._passiveTransform={x:0,y:0},this._activeTransform={x:0,y:0},this._moveEvents=new n.Subject,this._moveEventSubscriptions=0,this._pointerMoveSubscription=n.Subscription.EMPTY,this._pointerUpSubscription=n.Subscription.EMPTY,this.started=new e.EventEmitter,this.ended=new e.EventEmitter,this.entered=new e.EventEmitter,this.exited=new e.EventEmitter,this.dropped=new e.EventEmitter,this.moved=n.Observable.create(function(t){var e=l._moveEvents.subscribe(t);return l._moveEventSubscriptions++,function(){e.unsubscribe(),l._moveEventSubscriptions--}}),this._pointerDown=function(t){var e=l._handles.filter(function(t){return t._parentDrag===l});if(e.length){var i=e.find(function(e){var i=e.element.nativeElement,r=t.target;return!!r&&(r===i||i.contains(r))});i&&l._initializeDragSequence(i.element.nativeElement,t)}else l._initializeDragSequence(l._rootElement,t)},this._pointerMove=function(t){var e=l._getConstrainedPointerPosition(t);if(!l._hasStartedDragging){return void(Math.abs(e.x-l._pickupPositionOnPage.x)+Math.abs(e.y-l._pickupPositionOnPage.y)>=l._config.dragStartThreshold&&(l._hasStartedDragging=!0,l._ngZone.run(function(){return l._startDragSequence()})))}if(l._hasMoved=!0,t.preventDefault(),l._updatePointerDirectionDelta(e),l.dropContainer)l._updateActiveDropContainer(e);else{var i=l._activeTransform;i.x=e.x-l._pickupPositionOnPage.x+l._passiveTransform.x,i.y=e.y-l._pickupPositionOnPage.y+l._passiveTransform.y;var r=_(i.x,i.y);l._rootElement.style.transform=l._initialTransform?l._initialTransform+" "+r:r}l._moveEventSubscriptions>0&&l._ngZone.run(function(){l._moveEvents.next({source:l,pointerPosition:e,event:t,delta:l._pointerDirectionDelta})})},this._pointerUp=function(){if(l._isDragging()&&(l._removeSubscriptions(),l._dragDropRegistry.stopDragging(l),l._hasStartedDragging))return l.dropContainer?void l._animatePreviewToPlaceholder().then(function(){return l._cleanupDragArtifacts()}):(l._passiveTransform.x=l._activeTransform.x,l._passiveTransform.y=l._activeTransform.y,void l._ngZone.run(function(){return l.ended.emit({source:l})}))},this._document=r,p.registerDragItem(this)}return t.prototype.getPlaceholderElement=function(){return this._placeholder},t.prototype.getRootElement=function(){return this._rootElement},t.prototype.ngAfterViewInit=function(){var t=this;this._ngZone.onStable.asObservable().pipe(a.take(1)).subscribe(function(){var e=t._rootElement=t._getRootElement();e.addEventListener("mousedown",t._pointerDown,S),e.addEventListener("touchstart",t._pointerDown,S),h(e,!1)})},t.prototype.ngOnDestroy=function(){this._rootElement.removeEventListener("mousedown",this._pointerDown,S),this._rootElement.removeEventListener("touchstart",this._pointerDown,S),this._destroyPreview(),this._destroyPlaceholder(),this._isDragging()&&this._removeElement(this._rootElement),this._nextSibling=null,this._dragDropRegistry.removeDragItem(this),this._removeSubscriptions(),this._moveEvents.complete()},t.prototype._isDragging=function(){return this._dragDropRegistry.isDragging(this)},t.prototype._initializeDragSequence=function(t,e){if(e.stopPropagation(),!this._isDragging()&&(this._isTouchEvent(e)||0===e.button)){null==this._initialTransform&&(this._initialTransform=this._rootElement.style.transform||""),this._hasStartedDragging=this._hasMoved=!1,this._initialContainer=this.dropContainer,this._pointerMoveSubscription=this._dragDropRegistry.pointerMove.subscribe(this._pointerMove),this._pointerUpSubscription=this._dragDropRegistry.pointerUp.subscribe(this._pointerUp),this._scrollPosition=this._viewportRuler.getViewportScrollPosition(),this._pickupPositionInElement=this._previewTemplate?{x:0,y:0}:this._getPointerPositionInElement(t,e);var i=this._pickupPositionOnPage=this._getPointerPositionOnPage(e);this._pointerDirectionDelta={x:0,y:0},this._pointerPositionAtLastDirectionChange={x:i.x,y:i.y},this._dragDropRegistry.startDragging(this,e)}},t.prototype._startDragSequence=function(){if(this.started.emit({source:this}),this.dropContainer){var t=this._rootElement;this._nextSibling=t.nextSibling;var e=this._preview=this._createPreviewElement(),i=this._placeholder=this._createPlaceholderElement();t.style.display="none",this._document.body.appendChild(t.parentNode.replaceChild(i,t)),this._document.body.appendChild(e),this.dropContainer.start()}},t.prototype._cleanupDragArtifacts=function(){var t=this;this._rootElement.style.display="",this._nextSibling?this._nextSibling.parentNode.insertBefore(this._rootElement,this._nextSibling):this._initialContainer.element.nativeElement.appendChild(this._rootElement),this._destroyPreview(),this._destroyPlaceholder(),this._ngZone.run(function(){var e=t.dropContainer.getItemIndex(t);t.ended.emit({source:t}),t.dropped.emit({item:t,currentIndex:e,previousIndex:t._initialContainer.getItemIndex(t),container:t.dropContainer,previousContainer:t._initialContainer}),t.dropContainer.drop(t,e,t._initialContainer),t.dropContainer=t._initialContainer})},t.prototype._updateActiveDropContainer=function(t){var e=this,i=t.x,r=t.y,n=this.dropContainer._getSiblingContainerFromPosition(this,i,r);!n&&this.dropContainer!==this._initialContainer&&this._initialContainer._canReturnItem(this,i,r)&&(n=this._initialContainer),n&&this._ngZone.run(function(){e.exited.emit({item:e,container:e.dropContainer}),e.dropContainer.exit(e),e.entered.emit({item:e,container:n}),e.dropContainer=n,e.dropContainer.enter(e,i,r)}),this.dropContainer._sortItem(this,i,r,this._pointerDirectionDelta),this._preview.style.transform=_(i-this._pickupPositionInElement.x,r-this._pickupPositionInElement.y)},t.prototype._createPreviewElement=function(){var t;if(this._previewTemplate){var e=this._viewContainerRef.createEmbeddedView(this._previewTemplate.templateRef,this._previewTemplate.data);t=e.rootNodes[0],this._previewRef=e,t.style.transform=_(this._pickupPositionOnPage.x,this._pickupPositionOnPage.y)}else{var i=this._rootElement,r=i.getBoundingClientRect();t=i.cloneNode(!0),t.style.width=r.width+"px",t.style.height=r.height+"px",t.style.transform=_(r.left,r.top)}return c(t.style,{position:"fixed",top:"0",left:"0",zIndex:"1000"}),t.classList.add("cdk-drag-preview"),t.setAttribute("dir",this._dir?this._dir.value:"ltr"),t},t.prototype._createPlaceholderElement=function(){var t;return this._placeholderTemplate?(this._placeholderRef=this._viewContainerRef.createEmbeddedView(this._placeholderTemplate.templateRef,this._placeholderTemplate.data),t=this._placeholderRef.rootNodes[0]):t=this._rootElement.cloneNode(!0),t.classList.add("cdk-drag-placeholder"),t},t.prototype._getPointerPositionInElement=function(t,e){var i=this._rootElement.getBoundingClientRect(),r=t===this._rootElement?null:t,n=r?r.getBoundingClientRect():i,o=this._isTouchEvent(e)?e.targetTouches[0]:e,s=o.pageX-n.left-this._scrollPosition.left,a=o.pageY-n.top-this._scrollPosition.top;return{x:n.left-i.left+s,y:n.top-i.top+a}},t.prototype._animatePreviewToPlaceholder=function(){var t=this;if(!this._hasMoved)return Promise.resolve();var e=this._placeholder.getBoundingClientRect();this._preview.classList.add("cdk-drag-animating"),this._preview.style.transform=_(e.left,e.top);var i=d(this._preview);return 0===i?Promise.resolve():this._ngZone.runOutsideAngular(function(){return new Promise(function(e){var r=function(i){(!i||i.target===t._preview&&"transform"===i.propertyName)&&(t._preview.removeEventListener("transitionend",r),e(),clearTimeout(n))},n=setTimeout(r,1.5*i);t._preview.addEventListener("transitionend",r)})})},t.prototype._removeElement=function(t){t&&t.parentNode&&t.parentNode.removeChild(t)},t.prototype._getPointerPositionOnPage=function(t){var e=this._isTouchEvent(t)?t.touches[0]:t;return{x:e.pageX-this._scrollPosition.left,y:e.pageY-this._scrollPosition.top}},t.prototype._getConstrainedPointerPosition=function(t){var e=this._getPointerPositionOnPage(t),i=this.dropContainer?this.dropContainer.lockAxis:null;return"x"===this.lockAxis||"x"===i?e.y=this._pickupPositionOnPage.y:"y"!==this.lockAxis&&"y"!==i||(e.x=this._pickupPositionOnPage.x),e},t.prototype._isTouchEvent=function(t){return t.type.startsWith("touch")},t.prototype._destroyPreview=function(){this._preview&&this._removeElement(this._preview),this._previewRef&&this._previewRef.destroy(),this._preview=this._previewRef=null},t.prototype._destroyPlaceholder=function(){this._placeholder&&this._removeElement(this._placeholder),this._placeholderRef&&this._placeholderRef.destroy(),this._placeholder=this._placeholderRef=null},t.prototype._updatePointerDirectionDelta=function(t){var e=t.x,i=t.y,r=this._pointerDirectionDelta,n=this._pointerPositionAtLastDirectionChange,o=Math.abs(e-n.x),s=Math.abs(i-n.y);return o>this._config.pointerDirectionChangeThreshold&&(r.x=e>n.x?1:-1,n.x=e),s>this._config.pointerDirectionChangeThreshold&&(r.y=i>n.y?1:-1,n.y=i),r},t.prototype._getRootElement=function(){if(this.rootElementSelector)for(var t=this.rootElementSelector,e=this.element.nativeElement.parentElement;e;){if(e.matches?e.matches(t):e.msMatchesSelector(t))return e;e=e.parentElement}return this.element.nativeElement},t.prototype._removeSubscriptions=function(){this._pointerMoveSubscription.unsubscribe(),this._pointerUpSubscription.unsubscribe()},t.decorators=[{type:e.Directive,args:[{selector:"[cdkDrag]",exportAs:"cdkDrag",host:{class:"cdk-drag","[class.cdk-drag-dragging]":"_hasStartedDragging && _isDragging()"},providers:[{provide:b,useExisting:t}]}]}],t.ctorParameters=function(){return[{type:e.ElementRef},{type:void 0,decorators:[{type:e.Inject,args:[R]},{type:e.Optional},{type:e.SkipSelf}]},{type:void 0,decorators:[{type:e.Inject,args:[i.DOCUMENT]}]},{type:e.NgZone},{type:e.ViewContainerRef},{type:s.ViewportRuler},{type:P},{type:void 0,decorators:[{type:e.Inject,args:[k]}]},{type:o.Directionality,decorators:[{type:e.Optional}]}]},t.propDecorators={_handles:[{type:e.ContentChildren,args:[x,{descendants:!0}]}],_previewTemplate:[{type:e.ContentChild,args:[I]}],_placeholderTemplate:[{type:e.ContentChild,args:[w]}],data:[{type:e.Input,args:["cdkDragData"]}],lockAxis:[{type:e.Input,args:["cdkDragLockAxis"]}],rootElementSelector:[{type:e.Input,args:["cdkDragRootElement"]}],started:[{type:e.Output,args:["cdkDragStarted"]}],ended:[{type:e.Output,args:["cdkDragEnded"]}],entered:[{type:e.Output,args:["cdkDragEntered"]}],exited:[{type:e.Output,args:["cdkDragExited"]}],dropped:[{type:e.Output,args:["cdkDragDropped"]}],moved:[{type:e.Output,args:["cdkDragMoved"]}]},t}(),T=0,L=function(){function t(t,i,r,n){this.element=t,this._dragDropRegistry=i,this._changeDetectorRef=r,this._dir=n,this.connectedTo=[],this.orientation="vertical",this.id="cdk-drop-list-"+T++,this.enterPredicate=function(){return!0},this.dropped=new e.EventEmitter,this.entered=new e.EventEmitter,this.exited=new e.EventEmitter,this._dragging=!1,this._positionCache={items:[],siblings:[],self:{}},this._previousSwap={drag:null,delta:0}}return t.prototype.ngOnInit=function(){this._dragDropRegistry.registerDropContainer(this)},t.prototype.ngOnDestroy=function(){this._dragDropRegistry.removeDropContainer(this)},t.prototype.start=function(){this._dragging=!0,this._activeDraggables=this._draggables.toArray(),this._cachePositions(),this._changeDetectorRef.markForCheck()},t.prototype.drop=function(t,e,i){this._reset(),this.dropped.emit({item:t,currentIndex:e,previousIndex:i.getItemIndex(t),container:this,previousContainer:i})},t.prototype.enter=function(t,e,i){this.entered.emit({item:t,container:this}),this.start();var r=this._getItemIndexFromPointerPosition(t,e,i),n=this._activeDraggables.indexOf(t),o=this._activeDraggables[r],s=t.getPlaceholderElement();if(n>-1&&this._activeDraggables.splice(n,1),o&&!this._dragDropRegistry.isDragging(o)){var a=o.getRootElement();a.parentElement.insertBefore(s,a),this._activeDraggables.splice(r,0,t)}else this.element.nativeElement.appendChild(s),this._activeDraggables.push(t);s.style.transform="",this._cachePositions()},t.prototype.exit=function(t){this._reset(),this.exited.emit({item:t,container:this})},t.prototype.getItemIndex=function(t){return this._dragging?D("horizontal"===this.orientation&&this._dir&&"rtl"===this._dir.value?this._positionCache.items.slice().reverse():this._positionCache.items,function(e){return e.drag===t}):this._draggables.toArray().indexOf(t)},t.prototype._sortItem=function(t,e,i,r){var n=this;if(this._isPointerNearDropContainer(e,i)){var o=this._positionCache.items,s=this._getItemIndexFromPointerPosition(t,e,i,r);if(!(-1===s&&o.length>0)){var a="horizontal"===this.orientation,p=D(o,function(e){return e.drag===t}),c=o[s],h=o[p].clientRect,l=c.clientRect,d=p>s?1:-1;this._previousSwap.drag=c.drag,this._previousSwap.delta=a?r.x:r.y;var g=this._getItemOffsetPx(h,l,d),u=this._getSiblingOffsetPx(p,o,d),_=o.slice();f(o,p,s),o.forEach(function(e,i){if(_[i]!==e){var r=e.drag===t,o=r?g:u,s=r?t.getPlaceholderElement():e.drag.getRootElement();e.offset+=o,a?(s.style.transform="translate3d("+e.offset+"px, 0, 0)",n._adjustClientRect(e.clientRect,0,o)):(s.style.transform="translate3d(0, "+e.offset+"px, 0)",n._adjustClientRect(e.clientRect,o,0))}})}}},t.prototype._getSiblingContainerFromPosition=function(t,e,i){var r=this._positionCache.siblings.find(function(t){return E(t.clientRect,e,i)});return r&&r.drop.enterPredicate(t,r.drop)?r.drop:null},t.prototype._canReturnItem=function(t,e,i){return E(this._positionCache.self,e,i)&&this.enterPredicate(t,this)},t.prototype._cachePositions=function(){var t=this,e="horizontal"===this.orientation;this._positionCache.items=this._activeDraggables.map(function(e){var i=t._dragDropRegistry.isDragging(e)?e.getPlaceholderElement():e.getRootElement(),r=i.getBoundingClientRect();return{drag:e,offset:0,clientRect:{top:r.top,right:r.right,bottom:r.bottom,left:r.left,width:r.width,height:r.height}}}).sort(function(t,i){return e?t.clientRect.left-i.clientRect.left:t.clientRect.top-i.clientRect.top}),this._positionCache.siblings=p.coerceArray(this.connectedTo).map(function(e){return"string"==typeof e?t._dragDropRegistry.getDropContainer(e):e}).filter(function(e){return e&&e!==t}).map(function(t){return{drop:t,clientRect:t.element.nativeElement.getBoundingClientRect()}}),this._positionCache.self=this.element.nativeElement.getBoundingClientRect()},t.prototype._reset=function(){this._dragging=!1,this._activeDraggables.forEach(function(t){return t.getRootElement().style.transform=""}),this._activeDraggables=[],this._positionCache.items=[],this._positionCache.siblings=[],this._previousSwap.drag=null,this._previousSwap.delta=0},t.prototype._adjustClientRect=function(t,e,i){t.top+=e,t.bottom=t.top+t.height,t.left+=i,t.right=t.left+t.width},t.prototype._getItemIndexFromPointerPosition=function(t,e,i,r){var n=this,o="horizontal"===this.orientation;return D(this._positionCache.items,function(s,a,p){var c=s.drag,h=s.clientRect;if(c===t)return p.length<2;if(r){var l=o?r.x:r.y;if(c===n._previousSwap.drag&&l===n._previousSwap.delta)return!1}return o?e>=Math.floor(h.left)&&e<=Math.floor(h.right):i>=Math.floor(h.top)&&i<=Math.floor(h.bottom)})},t.prototype._isPointerNearDropContainer=function(t,e){var i=this._positionCache.self,r=i.top,n=i.right,o=i.bottom,s=i.left,a=i.width,p=i.height,c=.05*a,h=.05*p;return e>r-h&&e<o+h&&t>s-c&&t<n+c},t.prototype._getItemOffsetPx=function(t,e,i){var r="horizontal"===this.orientation,n=r?e.left-t.left:e.top-t.top;return-1===i&&(n+=r?e.width-t.width:e.height-t.height),n},t.prototype._getSiblingOffsetPx=function(t,e,i){var r="horizontal"===this.orientation,n=e[t].clientRect,o=e[t+-1*i],s=n[r?"width":"height"]*i;if(o){var a=r?"left":"top",p=r?"right":"bottom";-1===i?s-=o.clientRect[a]-n[p]:s+=n[a]-o.clientRect[p]}return s},t.decorators=[{type:e.Directive,args:[{selector:"[cdkDropList], cdk-drop-list",exportAs:"cdkDropList",providers:[{provide:R,useExisting:t}],host:{class:"cdk-drop-list","[id]":"id","[class.cdk-drop-list-dragging]":"_dragging"}}]}],t.ctorParameters=function(){return[{type:e.ElementRef},{type:P},{type:e.ChangeDetectorRef},{type:o.Directionality,decorators:[{type:e.Optional}]}]},t.propDecorators={_draggables:[{type:e.ContentChildren,args:[e.forwardRef(function(){return O})]}],connectedTo:[{type:e.Input,args:["cdkDropListConnectedTo"]}],data:[{type:e.Input,args:["cdkDropListData"]}],orientation:[{type:e.Input,args:["cdkDropListOrientation"]}],id:[{type:e.Input}],lockAxis:[{type:e.Input,args:["cdkDropListLockAxis"]}],enterPredicate:[{type:e.Input,args:["cdkDropListEnterPredicate"]}],dropped:[{type:e.Output,args:["cdkDropListDropped"]}],entered:[{type:e.Output,args:["cdkDropListEntered"]}],exited:[{type:e.Output,args:["cdkDropListExited"]}]},t}(),A=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{declarations:[L,O,x,I,w],exports:[L,O,x,I,w]}]}],t}();t.CdkDropList=L,t.CDK_DROP_LIST_CONTAINER=R,t.CDK_DRAG_CONFIG_FACTORY=u,t.CDK_DRAG_CONFIG=k,t.CdkDrag=O,t.CdkDragHandle=x,t.moveItemInArray=f,t.transferArrayItem=m,t.copyArrayItem=v,t.CdkDragPreview=I,t.CdkDragPlaceholder=w,t.DragDropModule=A,t.DragDropRegistry=P,t.ɵa=b,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=cdk-drag-drop.umd.min.js.map
