/**
 * @license Angular v2.0.0-rc.6
 * (c) 2010-2016 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/core")):"function"==typeof define&&define.amd?define(["exports","@angular/core"],factory):factory((global.ng=global.ng||{},global.ng.common=global.ng.common||{}),global.ng.core)}(this,function(exports,_angular_core){"use strict";function getTypeNameForDebugging(type){return type.name?type.name:typeof type}function isPresent(obj){return void 0!==obj&&null!==obj}function isBlank(obj){return void 0===obj||null===obj}function isNumber(obj){return"number"==typeof obj}function isString(obj){return"string"==typeof obj}function isFunction(obj){return"function"==typeof obj}function isStringMap(obj){return"object"==typeof obj&&null!==obj}function isPromise(obj){return isPresent(obj)&&isFunction(obj.then)}function isArray(obj){return Array.isArray(obj)}function isDate(obj){return obj instanceof Date&&!isNaN(obj.valueOf())}function stringify(token){if("string"==typeof token)return token;if(void 0===token||null===token)return""+token;if(token.overriddenName)return token.overriddenName;if(token.name)return token.name;var res=token.toString(),newLineIndex=res.indexOf("\n");return newLineIndex===-1?res:res.substring(0,newLineIndex)}function normalizeBlank(obj){return isBlank(obj)?null:obj}function isJsObject(o){return null!==o&&("function"==typeof o||"object"==typeof o)}function getSymbolIterator(){if(isBlank(_symbolIterator))if(isPresent(globalScope.Symbol)&&isPresent(Symbol.iterator))_symbolIterator=Symbol.iterator;else for(var keys=Object.getOwnPropertyNames(Map.prototype),i=0;i<keys.length;++i){var key=keys[i];"entries"!==key&&"size"!==key&&Map.prototype[key]===Map.prototype.entries&&(_symbolIterator=key)}return _symbolIterator}function _flattenArray(source,target){if(isPresent(source))for(var i=0;i<source.length;i++){var item=source[i];isArray(item)?_flattenArray(item,target):target.push(item)}return target}function isListLikeIterable(obj){return!!isJsObject(obj)&&(isArray(obj)||!(obj instanceof Map$1)&&getSymbolIterator()in obj)}function digitModifier(inner){return function(date,locale){var result=inner(date,locale);return 1==result.length?"0"+result:result}}function hourClockExtracter(inner){return function(date,locale){var result=inner(date,locale);return result.split(" ")[1]}}function hourExtracter(inner){return function(date,locale){var result=inner(date,locale);return result.split(" ")[0]}}function intlDateFormat(date,locale,options){return new Intl.DateTimeFormat(locale,options).format(date).replace(/[\u200e\u200f]/g,"")}function timeZoneGetter(timezone){var options={hour:"2-digit",hour12:!1,timeZoneName:timezone};return function(date,locale){var result=intlDateFormat(date,locale,options);return result?result.substring(3):""}}function hour12Modify(options,value){return options.hour12=value,options}function digitCondition(prop,len){var result={};return result[prop]=2==len?"2-digit":"numeric",result}function nameCondition(prop,len){var result={};return result[prop]=len<4?"short":"long",result}function combine(options){var result={};return options.forEach(function(option){Object.assign(result,option)}),result}function datePartGetterFactory(ret){return function(date,locale){return intlDateFormat(date,locale,ret)}}function dateFormatter(format,date,locale){var match,fn,text="",parts=[];if(PATTERN_ALIASES[format])return PATTERN_ALIASES[format](date,locale);if(datePartsFormatterCache.has(format))parts=datePartsFormatterCache.get(format);else{for(DATE_FORMATS_SPLIT.exec(format);format;)match=DATE_FORMATS_SPLIT.exec(format),match?(parts=concat(parts,match,1),format=parts.pop()):(parts.push(format),format=null);datePartsFormatterCache.set(format,parts)}return parts.forEach(function(part){fn=DATE_FORMATS[part],text+=fn?fn(date,locale):"''"===part?"'":part.replace(/(^'|'$)/g,"").replace(/''/g,"'")}),text}function concat(array1,array2,index){return array1.concat(slice.call(array2,index))}function getPluralCategory(value,cases,ngLocalization){var nbCase="="+value;return cases.indexOf(nbCase)>-1?nbCase:ngLocalization.getPluralCategory(value)}function getPluralCase(locale,nLike){"string"==typeof nLike&&(nLike=parseInt(nLike,10));var n=nLike,nDecimal=n.toString().replace(/^[^.]*\.?/,""),i=Math.floor(Math.abs(n)),v=nDecimal.length,f=parseInt(nDecimal,10),t=parseInt(n.toString().replace(/^[^.]*\.?|0+$/g,""),10)||0,lang=locale.split("_")[0].toLowerCase();switch(lang){case"af":case"asa":case"az":case"bem":case"bez":case"bg":case"brx":case"ce":case"cgg":case"chr":case"ckb":case"ee":case"el":case"eo":case"es":case"eu":case"fo":case"fur":case"gsw":case"ha":case"haw":case"hu":case"jgo":case"jmc":case"ka":case"kk":case"kkj":case"kl":case"ks":case"ksb":case"ky":case"lb":case"lg":case"mas":case"mgo":case"ml":case"mn":case"nb":case"nd":case"ne":case"nn":case"nnh":case"nyn":case"om":case"or":case"os":case"ps":case"rm":case"rof":case"rwk":case"saq":case"seh":case"sn":case"so":case"sq":case"ta":case"te":case"teo":case"tk":case"tr":case"ug":case"uz":case"vo":case"vun":case"wae":case"xog":return 1===n?Plural.One:Plural.Other;case"agq":case"bas":case"cu":case"dav":case"dje":case"dua":case"dyo":case"ebu":case"ewo":case"guz":case"kam":case"khq":case"ki":case"kln":case"kok":case"ksf":case"lrc":case"lu":case"luo":case"luy":case"mer":case"mfe":case"mgh":case"mua":case"mzn":case"nmg":case"nus":case"qu":case"rn":case"rw":case"sbp":case"twq":case"vai":case"yav":case"yue":case"zgh":case"ak":case"ln":case"mg":case"pa":case"ti":return n===Math.floor(n)&&n>=0&&n<=1?Plural.One:Plural.Other;case"am":case"as":case"bn":case"fa":case"gu":case"hi":case"kn":case"mr":case"zu":return 0===i||1===n?Plural.One:Plural.Other;case"ar":return 0===n?Plural.Zero:1===n?Plural.One:2===n?Plural.Two:n%100===Math.floor(n%100)&&n%100>=3&&n%100<=10?Plural.Few:n%100===Math.floor(n%100)&&n%100>=11&&n%100<=99?Plural.Many:Plural.Other;case"ast":case"ca":case"de":case"en":case"et":case"fi":case"fy":case"gl":case"it":case"nl":case"sv":case"sw":case"ur":case"yi":return 1===i&&0===v?Plural.One:Plural.Other;case"be":return n%10===1&&n%100!==11?Plural.One:n%10===Math.floor(n%10)&&n%10>=2&&n%10<=4&&!(n%100>=12&&n%100<=14)?Plural.Few:n%10===0||n%10===Math.floor(n%10)&&n%10>=5&&n%10<=9||n%100===Math.floor(n%100)&&n%100>=11&&n%100<=14?Plural.Many:Plural.Other;case"br":return n%10===1&&n%100!==11&&n%100!==71&&n%100!==91?Plural.One:n%10===2&&n%100!==12&&n%100!==72&&n%100!==92?Plural.Two:n%10===Math.floor(n%10)&&(n%10>=3&&n%10<=4||n%10===9)&&!(n%100>=10&&n%100<=19||n%100>=70&&n%100<=79||n%100>=90&&n%100<=99)?Plural.Few:0!==n&&n%1e6===0?Plural.Many:Plural.Other;case"bs":case"hr":case"sr":return 0===v&&i%10===1&&i%100!==11||f%10===1&&f%100!==11?Plural.One:0===v&&i%10===Math.floor(i%10)&&i%10>=2&&i%10<=4&&!(i%100>=12&&i%100<=14)||f%10===Math.floor(f%10)&&f%10>=2&&f%10<=4&&!(f%100>=12&&f%100<=14)?Plural.Few:Plural.Other;case"cs":case"sk":return 1===i&&0===v?Plural.One:i===Math.floor(i)&&i>=2&&i<=4&&0===v?Plural.Few:0!==v?Plural.Many:Plural.Other;case"cy":return 0===n?Plural.Zero:1===n?Plural.One:2===n?Plural.Two:3===n?Plural.Few:6===n?Plural.Many:Plural.Other;case"da":return 1===n||0!==t&&(0===i||1===i)?Plural.One:Plural.Other;case"dsb":case"hsb":return 0===v&&i%100===1||f%100===1?Plural.One:0===v&&i%100===2||f%100===2?Plural.Two:0===v&&i%100===Math.floor(i%100)&&i%100>=3&&i%100<=4||f%100===Math.floor(f%100)&&f%100>=3&&f%100<=4?Plural.Few:Plural.Other;case"ff":case"fr":case"hy":case"kab":return 0===i||1===i?Plural.One:Plural.Other;case"fil":return 0===v&&(1===i||2===i||3===i)||0===v&&i%10!==4&&i%10!==6&&i%10!==9||0!==v&&f%10!==4&&f%10!==6&&f%10!==9?Plural.One:Plural.Other;case"ga":return 1===n?Plural.One:2===n?Plural.Two:n===Math.floor(n)&&n>=3&&n<=6?Plural.Few:n===Math.floor(n)&&n>=7&&n<=10?Plural.Many:Plural.Other;case"gd":return 1===n||11===n?Plural.One:2===n||12===n?Plural.Two:n===Math.floor(n)&&(n>=3&&n<=10||n>=13&&n<=19)?Plural.Few:Plural.Other;case"gv":return 0===v&&i%10===1?Plural.One:0===v&&i%10===2?Plural.Two:0!==v||i%100!==0&&i%100!==20&&i%100!==40&&i%100!==60&&i%100!==80?0!==v?Plural.Many:Plural.Other:Plural.Few;case"he":return 1===i&&0===v?Plural.One:2===i&&0===v?Plural.Two:0!==v||n>=0&&n<=10||n%10!==0?Plural.Other:Plural.Many;case"is":return 0===t&&i%10===1&&i%100!==11||0!==t?Plural.One:Plural.Other;case"ksh":return 0===n?Plural.Zero:1===n?Plural.One:Plural.Other;case"kw":case"naq":case"se":case"smn":return 1===n?Plural.One:2===n?Plural.Two:Plural.Other;case"lag":return 0===n?Plural.Zero:0!==i&&1!==i||0===n?Plural.Other:Plural.One;case"lt":return n%10!==1||n%100>=11&&n%100<=19?n%10===Math.floor(n%10)&&n%10>=2&&n%10<=9&&!(n%100>=11&&n%100<=19)?Plural.Few:0!==f?Plural.Many:Plural.Other:Plural.One;case"lv":case"prg":return n%10===0||n%100===Math.floor(n%100)&&n%100>=11&&n%100<=19||2===v&&f%100===Math.floor(f%100)&&f%100>=11&&f%100<=19?Plural.Zero:n%10===1&&n%100!==11||2===v&&f%10===1&&f%100!==11||2!==v&&f%10===1?Plural.One:Plural.Other;case"mk":return 0===v&&i%10===1||f%10===1?Plural.One:Plural.Other;case"mt":return 1===n?Plural.One:0===n||n%100===Math.floor(n%100)&&n%100>=2&&n%100<=10?Plural.Few:n%100===Math.floor(n%100)&&n%100>=11&&n%100<=19?Plural.Many:Plural.Other;case"pl":return 1===i&&0===v?Plural.One:0===v&&i%10===Math.floor(i%10)&&i%10>=2&&i%10<=4&&!(i%100>=12&&i%100<=14)?Plural.Few:0===v&&1!==i&&i%10===Math.floor(i%10)&&i%10>=0&&i%10<=1||0===v&&i%10===Math.floor(i%10)&&i%10>=5&&i%10<=9||0===v&&i%100===Math.floor(i%100)&&i%100>=12&&i%100<=14?Plural.Many:Plural.Other;case"pt":return n===Math.floor(n)&&n>=0&&n<=2&&2!==n?Plural.One:Plural.Other;case"ro":return 1===i&&0===v?Plural.One:0!==v||0===n||1!==n&&n%100===Math.floor(n%100)&&n%100>=1&&n%100<=19?Plural.Few:Plural.Other;case"ru":case"uk":return 0===v&&i%10===1&&i%100!==11?Plural.One:0===v&&i%10===Math.floor(i%10)&&i%10>=2&&i%10<=4&&!(i%100>=12&&i%100<=14)?Plural.Few:0===v&&i%10===0||0===v&&i%10===Math.floor(i%10)&&i%10>=5&&i%10<=9||0===v&&i%100===Math.floor(i%100)&&i%100>=11&&i%100<=14?Plural.Many:Plural.Other;case"shi":return 0===i||1===n?Plural.One:n===Math.floor(n)&&n>=2&&n<=10?Plural.Few:Plural.Other;case"si":return 0===n||1===n||0===i&&1===f?Plural.One:Plural.Other;case"sl":return 0===v&&i%100===1?Plural.One:0===v&&i%100===2?Plural.Two:0===v&&i%100===Math.floor(i%100)&&i%100>=3&&i%100<=4||0!==v?Plural.Few:Plural.Other;case"tzm":return n===Math.floor(n)&&n>=0&&n<=1||n===Math.floor(n)&&n>=11&&n<=99?Plural.One:Plural.Other;default:return Plural.Other}}function formatNumber(pipe,locale,value,style,digits,currency,currencyAsSymbol){if(void 0===currency&&(currency=null),void 0===currencyAsSymbol&&(currencyAsSymbol=!1),isBlank(value))return null;if(value=isString(value)&&NumberWrapper.isNumeric(value)?+value:value,!isNumber(value))throw new InvalidPipeArgumentError(pipe,value);var minInt,minFraction,maxFraction;if(style!==NumberFormatStyle.Currency&&(minInt=1,minFraction=0,maxFraction=3),isPresent(digits)){var parts=digits.match(_NUMBER_FORMAT_REGEXP);if(null===parts)throw new Error(digits+" is not a valid digit info for number pipes");isPresent(parts[1])&&(minInt=NumberWrapper.parseIntAutoRadix(parts[1])),isPresent(parts[3])&&(minFraction=NumberWrapper.parseIntAutoRadix(parts[3])),isPresent(parts[5])&&(maxFraction=NumberWrapper.parseIntAutoRadix(parts[5]))}return NumberFormatter.format(value,locale,style,{minimumIntegerDigits:minInt,minimumFractionDigits:minFraction,maximumFractionDigits:maxFraction,currency:currency,currencyAsSymbol:currencyAsSymbol})}function _stripBaseHref(baseHref,url){return baseHref.length>0&&url.startsWith(baseHref)?url.substring(baseHref.length):url}function _stripIndexHtml(url){return/\/index.html$/g.test(url)?url.substring(0,url.length-11):url}/**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
var globalScope;globalScope="undefined"==typeof window?"undefined"!=typeof WorkerGlobalScope&&self instanceof WorkerGlobalScope?self:global:window;var global$1=globalScope,Date=global$1.Date;global$1.assert=function(condition){};var NumberFormatStyle,StringWrapper=function(){function StringWrapper(){}return StringWrapper.fromCharCode=function(code){return String.fromCharCode(code)},StringWrapper.charCodeAt=function(s,index){return s.charCodeAt(index)},StringWrapper.split=function(s,regExp){return s.split(regExp)},StringWrapper.equals=function(s,s2){return s===s2},StringWrapper.stripLeft=function(s,charVal){if(s&&s.length){for(var pos=0,i=0;i<s.length&&s[i]==charVal;i++)pos++;s=s.substring(pos)}return s},StringWrapper.stripRight=function(s,charVal){if(s&&s.length){for(var pos=s.length,i=s.length-1;i>=0&&s[i]==charVal;i--)pos--;s=s.substring(0,pos)}return s},StringWrapper.replace=function(s,from,replace){return s.replace(from,replace)},StringWrapper.replaceAll=function(s,from,replace){return s.replace(from,replace)},StringWrapper.slice=function(s,from,to){return void 0===from&&(from=0),void 0===to&&(to=null),s.slice(from,null===to?void 0:to)},StringWrapper.replaceAllMapped=function(s,from,cb){return s.replace(from,function(){for(var matches=[],_i=0;_i<arguments.length;_i++)matches[_i-0]=arguments[_i];return matches.splice(-2,2),cb(matches)})},StringWrapper.contains=function(s,substr){return s.indexOf(substr)!=-1},StringWrapper.compare=function(a,b){return a<b?-1:a>b?1:0},StringWrapper}(),NumberWrapper=function(){function NumberWrapper(){}return NumberWrapper.toFixed=function(n,fractionDigits){return n.toFixed(fractionDigits)},NumberWrapper.equal=function(a,b){return a===b},NumberWrapper.parseIntAutoRadix=function(text){var result=parseInt(text);if(isNaN(result))throw new Error("Invalid integer literal when parsing "+text);return result},NumberWrapper.parseInt=function(text,radix){if(10==radix){if(/^(\-|\+)?[0-9]+$/.test(text))return parseInt(text,radix)}else if(16==radix){if(/^(\-|\+)?[0-9ABCDEFabcdef]+$/.test(text))return parseInt(text,radix)}else{var result=parseInt(text,radix);if(!isNaN(result))return result}throw new Error("Invalid integer literal when parsing "+text+" in base "+radix)},NumberWrapper.parseFloat=function(text){return parseFloat(text)},Object.defineProperty(NumberWrapper,"NaN",{get:function(){return NaN},enumerable:!0,configurable:!0}),NumberWrapper.isNumeric=function(value){return!isNaN(value-parseFloat(value))},NumberWrapper.isNaN=function(value){return isNaN(value)},NumberWrapper.isInteger=function(value){return Number.isInteger(value)},NumberWrapper}(),Json=function(){function Json(){}return Json.parse=function(s){return global$1.JSON.parse(s)},Json.stringify=function(data){return global$1.JSON.stringify(data,null,2)},Json}(),DateWrapper=function(){function DateWrapper(){}return DateWrapper.create=function(year,month,day,hour,minutes,seconds,milliseconds){return void 0===month&&(month=1),void 0===day&&(day=1),void 0===hour&&(hour=0),void 0===minutes&&(minutes=0),void 0===seconds&&(seconds=0),void 0===milliseconds&&(milliseconds=0),new Date(year,month-1,day,hour,minutes,seconds,milliseconds)},DateWrapper.fromISOString=function(str){return new Date(str)},DateWrapper.fromMillis=function(ms){return new Date(ms)},DateWrapper.toMillis=function(date){return date.getTime()},DateWrapper.now=function(){return new Date},DateWrapper.toJson=function(date){return date.toJSON()},DateWrapper}(),_symbolIterator=null,__extends$1=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},BaseError=function(_super){function BaseError(message){var nativeError=_super.call(this,message);this._nativeError=nativeError}return __extends$1(BaseError,_super),Object.defineProperty(BaseError.prototype,"message",{get:function(){return this._nativeError.message},set:function(message){this._nativeError.message=message},enumerable:!0,configurable:!0}),Object.defineProperty(BaseError.prototype,"name",{get:function(){return this._nativeError.name},enumerable:!0,configurable:!0}),Object.defineProperty(BaseError.prototype,"stack",{get:function(){return this._nativeError.stack},set:function(value){this._nativeError.stack=value},enumerable:!0,configurable:!0}),BaseError.prototype.toString=function(){return this._nativeError.toString()},BaseError}(Error),__extends=(function(_super){function WrappedError(message,error){_super.call(this,message+" caused by: "+(error instanceof Error?error.message:error)),this.originalError=error}return __extends$1(WrappedError,_super),Object.defineProperty(WrappedError.prototype,"stack",{get:function(){return(this.originalError instanceof Error?this.originalError:this._nativeError).stack},enumerable:!0,configurable:!0}),WrappedError}(BaseError),this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}),InvalidPipeArgumentError=function(_super){function InvalidPipeArgumentError(type,value){_super.call(this,"Invalid argument '"+value+"' for pipe '"+stringify(type)+"'")}return __extends(InvalidPipeArgumentError,_super),InvalidPipeArgumentError}(BaseError),ObservableStrategy=function(){function ObservableStrategy(){}return ObservableStrategy.prototype.createSubscription=function(async,updateLatestValue){return async.subscribe({next:updateLatestValue,error:function(e){throw e}})},ObservableStrategy.prototype.dispose=function(subscription){subscription.unsubscribe()},ObservableStrategy.prototype.onDestroy=function(subscription){subscription.unsubscribe()},ObservableStrategy}(),PromiseStrategy=function(){function PromiseStrategy(){}return PromiseStrategy.prototype.createSubscription=function(async,updateLatestValue){return async.then(updateLatestValue,function(e){throw e})},PromiseStrategy.prototype.dispose=function(subscription){},PromiseStrategy.prototype.onDestroy=function(subscription){},PromiseStrategy}(),_promiseStrategy=new PromiseStrategy,_observableStrategy=new ObservableStrategy,AsyncPipe=function(){function AsyncPipe(_ref){this._latestValue=null,this._latestReturnedValue=null,this._subscription=null,this._obj=null,this._strategy=null,this._ref=_ref}return AsyncPipe.prototype.ngOnDestroy=function(){isPresent(this._subscription)&&this._dispose()},AsyncPipe.prototype.transform=function(obj){return isBlank(this._obj)?(isPresent(obj)&&this._subscribe(obj),this._latestReturnedValue=this._latestValue,this._latestValue):obj!==this._obj?(this._dispose(),this.transform(obj)):this._latestValue===this._latestReturnedValue?this._latestReturnedValue:(this._latestReturnedValue=this._latestValue,_angular_core.WrappedValue.wrap(this._latestValue))},AsyncPipe.prototype._subscribe=function(obj){var _this=this;this._obj=obj,this._strategy=this._selectStrategy(obj),this._subscription=this._strategy.createSubscription(obj,function(value){return _this._updateLatestValue(obj,value)})},AsyncPipe.prototype._selectStrategy=function(obj){if(isPromise(obj))return _promiseStrategy;if(obj.subscribe)return _observableStrategy;throw new InvalidPipeArgumentError(AsyncPipe,obj)},AsyncPipe.prototype._dispose=function(){this._strategy.dispose(this._subscription),this._latestValue=null,this._latestReturnedValue=null,this._subscription=null,this._obj=null},AsyncPipe.prototype._updateLatestValue=function(async,value){async===this._obj&&(this._latestValue=value,this._ref.markForCheck())},AsyncPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"async",pure:!1}]}],AsyncPipe.ctorParameters=[{type:_angular_core.ChangeDetectorRef}],AsyncPipe}(),Map$1=global$1.Map,Set$1=global$1.Set,StringMapWrapper=(function(){try{if(1===new Map$1([[1,2]]).size)return function(pairs){return new Map$1(pairs)}}catch(e){}return function(pairs){for(var map=new Map$1,i=0;i<pairs.length;i++){var pair=pairs[i];map.set(pair[0],pair[1])}return map}}(),function(){try{if(new Map$1(new Map$1))return function(m){return new Map$1(m)}}catch(e){}return function(m){var map=new Map$1;return m.forEach(function(v,k){map.set(k,v)}),map}}(),function(){return(new Map$1).keys().next?function(m){for(var k,keyIterator=m.keys();!(k=keyIterator.next()).done;)m.set(k.value,null)}:function(m){m.forEach(function(v,k){m.set(k,null)})}}(),function(){try{if((new Map$1).values().next)return function(m,getValues){return getValues?Array.from(m.values()):Array.from(m.keys())}}catch(e){}return function(m,getValues){var res=ListWrapper.createFixedSize(m.size),i=0;return m.forEach(function(v,k){res[i]=getValues?v:k,i++}),res}}(),function(){function StringMapWrapper(){}return StringMapWrapper.create=function(){return{}},StringMapWrapper.contains=function(map,key){return map.hasOwnProperty(key)},StringMapWrapper.get=function(map,key){return map.hasOwnProperty(key)?map[key]:void 0},StringMapWrapper.set=function(map,key,value){map[key]=value},StringMapWrapper.keys=function(map){return Object.keys(map)},StringMapWrapper.values=function(map){return Object.keys(map).map(function(k){return map[k]})},StringMapWrapper.isEmpty=function(map){for(var prop in map)return!1;return!0},StringMapWrapper.delete=function(map,key){delete map[key]},StringMapWrapper.forEach=function(map,callback){for(var _i=0,_a=Object.keys(map);_i<_a.length;_i++){var k=_a[_i];callback(map[k],k)}},StringMapWrapper.merge=function(m1,m2){for(var m={},_i=0,_a=Object.keys(m1);_i<_a.length;_i++){var k=_a[_i];m[k]=m1[k]}for(var _b=0,_c=Object.keys(m2);_b<_c.length;_b++){var k=_c[_b];m[k]=m2[k]}return m},StringMapWrapper.equals=function(m1,m2){var k1=Object.keys(m1),k2=Object.keys(m2);if(k1.length!=k2.length)return!1;for(var key,i=0;i<k1.length;i++)if(key=k1[i],m1[key]!==m2[key])return!1;return!0},StringMapWrapper}()),ListWrapper=function(){function ListWrapper(){}return ListWrapper.createFixedSize=function(size){return new Array(size)},ListWrapper.createGrowableSize=function(size){return new Array(size)},ListWrapper.clone=function(array){return array.slice(0)},ListWrapper.forEachWithIndex=function(array,fn){for(var i=0;i<array.length;i++)fn(array[i],i)},ListWrapper.first=function(array){return array?array[0]:null},ListWrapper.last=function(array){return array&&0!=array.length?array[array.length-1]:null},ListWrapper.indexOf=function(array,value,startIndex){return void 0===startIndex&&(startIndex=0),array.indexOf(value,startIndex)},ListWrapper.contains=function(list,el){return list.indexOf(el)!==-1},ListWrapper.reversed=function(array){var a=ListWrapper.clone(array);return a.reverse()},ListWrapper.concat=function(a,b){return a.concat(b)},ListWrapper.insert=function(list,index,value){list.splice(index,0,value)},ListWrapper.removeAt=function(list,index){var res=list[index];return list.splice(index,1),res},ListWrapper.removeAll=function(list,items){for(var i=0;i<items.length;++i){var index=list.indexOf(items[i]);list.splice(index,1)}},ListWrapper.remove=function(list,el){var index=list.indexOf(el);return index>-1&&(list.splice(index,1),!0)},ListWrapper.clear=function(list){list.length=0},ListWrapper.isEmpty=function(list){return 0==list.length},ListWrapper.fill=function(list,value,start,end){void 0===start&&(start=0),void 0===end&&(end=null),list.fill(value,start,null===end?list.length:end)},ListWrapper.equals=function(a,b){if(a.length!=b.length)return!1;for(var i=0;i<a.length;++i)if(a[i]!==b[i])return!1;return!0},ListWrapper.slice=function(l,from,to){return void 0===from&&(from=0),void 0===to&&(to=null),l.slice(from,null===to?void 0:to)},ListWrapper.splice=function(l,from,length){return l.splice(from,length)},ListWrapper.sort=function(l,compareFn){isPresent(compareFn)?l.sort(compareFn):l.sort()},ListWrapper.toString=function(l){return l.toString()},ListWrapper.toJSON=function(l){return JSON.stringify(l)},ListWrapper.maximum=function(list,predicate){if(0==list.length)return null;for(var solution=null,maxValue=-(1/0),index=0;index<list.length;index++){var candidate=list[index];if(!isBlank(candidate)){var candidateValue=predicate(candidate);candidateValue>maxValue&&(solution=candidate,maxValue=candidateValue)}}return solution},ListWrapper.flatten=function(list){var target=[];return _flattenArray(list,target),target},ListWrapper.addAll=function(list,source){for(var i=0;i<source.length;i++)list.push(source[i])},ListWrapper}();(function(){var test=new Set$1([1,2,3]);return 3===test.size?function(lst){return new Set$1(lst)}:function(lst){var res=new Set$1(lst);if(res.size!==lst.length)for(var i=0;i<lst.length;i++)res.add(lst[i]);return res}})();!function(NumberFormatStyle){NumberFormatStyle[NumberFormatStyle.Decimal=0]="Decimal",NumberFormatStyle[NumberFormatStyle.Percent=1]="Percent",NumberFormatStyle[NumberFormatStyle.Currency=2]="Currency"}(NumberFormatStyle||(NumberFormatStyle={}));var Plural,NumberFormatter=function(){function NumberFormatter(){}return NumberFormatter.format=function(num,locale,style,_a){var _b=void 0===_a?{}:_a,minimumIntegerDigits=_b.minimumIntegerDigits,minimumFractionDigits=_b.minimumFractionDigits,maximumFractionDigits=_b.maximumFractionDigits,currency=_b.currency,_c=_b.currencyAsSymbol,currencyAsSymbol=void 0!==_c&&_c,options={minimumIntegerDigits:minimumIntegerDigits,minimumFractionDigits:minimumFractionDigits,maximumFractionDigits:maximumFractionDigits,style:NumberFormatStyle[style].toLowerCase()};return style==NumberFormatStyle.Currency&&(options.currency=currency,options.currencyDisplay=currencyAsSymbol?"symbol":"code"),new Intl.NumberFormat(locale,options).format(num)},NumberFormatter}(),DATE_FORMATS_SPLIT=/((?:[^yMLdHhmsazZEwGjJ']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|L+|d+|H+|h+|J+|j+|m+|s+|a|z|Z|G+|w+))(.*)/,PATTERN_ALIASES={yMMMdjms:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",3),digitCondition("day",1),digitCondition("hour",1),digitCondition("minute",1),digitCondition("second",1)])),yMdjm:datePartGetterFactory(combine([digitCondition("year",1),digitCondition("month",1),digitCondition("day",1),digitCondition("hour",1),digitCondition("minute",1)])),yMMMMEEEEd:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",4),nameCondition("weekday",4),digitCondition("day",1)])),yMMMMd:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",4),digitCondition("day",1)])),yMMMd:datePartGetterFactory(combine([digitCondition("year",1),nameCondition("month",3),digitCondition("day",1)])),yMd:datePartGetterFactory(combine([digitCondition("year",1),digitCondition("month",1),digitCondition("day",1)])),jms:datePartGetterFactory(combine([digitCondition("hour",1),digitCondition("second",1),digitCondition("minute",1)])),jm:datePartGetterFactory(combine([digitCondition("hour",1),digitCondition("minute",1)]))},DATE_FORMATS={yyyy:datePartGetterFactory(digitCondition("year",4)),yy:datePartGetterFactory(digitCondition("year",2)),y:datePartGetterFactory(digitCondition("year",1)),MMMM:datePartGetterFactory(nameCondition("month",4)),MMM:datePartGetterFactory(nameCondition("month",3)),MM:datePartGetterFactory(digitCondition("month",2)),M:datePartGetterFactory(digitCondition("month",1)),LLLL:datePartGetterFactory(nameCondition("month",4)),dd:datePartGetterFactory(digitCondition("day",2)),d:datePartGetterFactory(digitCondition("day",1)),HH:digitModifier(hourExtracter(datePartGetterFactory(hour12Modify(digitCondition("hour",2),!1)))),H:hourExtracter(datePartGetterFactory(hour12Modify(digitCondition("hour",1),!1))),hh:digitModifier(hourExtracter(datePartGetterFactory(hour12Modify(digitCondition("hour",2),!0)))),h:hourExtracter(datePartGetterFactory(hour12Modify(digitCondition("hour",1),!0))),jj:datePartGetterFactory(digitCondition("hour",2)),j:datePartGetterFactory(digitCondition("hour",1)),mm:digitModifier(datePartGetterFactory(digitCondition("minute",2))),m:datePartGetterFactory(digitCondition("minute",1)),ss:digitModifier(datePartGetterFactory(digitCondition("second",2))),s:datePartGetterFactory(digitCondition("second",1)),sss:datePartGetterFactory(digitCondition("second",3)),EEEE:datePartGetterFactory(nameCondition("weekday",4)),EEE:datePartGetterFactory(nameCondition("weekday",3)),EE:datePartGetterFactory(nameCondition("weekday",2)),E:datePartGetterFactory(nameCondition("weekday",1)),a:hourClockExtracter(datePartGetterFactory(hour12Modify(digitCondition("hour",1),!0))),Z:timeZoneGetter("short"),z:timeZoneGetter("long"),ww:datePartGetterFactory({}),w:datePartGetterFactory({}),G:datePartGetterFactory(nameCondition("era",1)),GG:datePartGetterFactory(nameCondition("era",2)),GGG:datePartGetterFactory(nameCondition("era",3)),GGGG:datePartGetterFactory(nameCondition("era",4))},datePartsFormatterCache=new Map,slice=[].slice,DateFormatter=function(){function DateFormatter(){}return DateFormatter.format=function(date,locale,pattern){return dateFormatter(pattern,date,locale)},DateFormatter}(),DatePipe=function(){function DatePipe(_locale){this._locale=_locale}return DatePipe.prototype.transform=function(value,pattern){if(void 0===pattern&&(pattern="mediumDate"),isBlank(value))return null;if(!this.supports(value))throw new InvalidPipeArgumentError(DatePipe,value);return NumberWrapper.isNumeric(value)?value=DateWrapper.fromMillis(parseFloat(value)):isString(value)&&(value=DateWrapper.fromISOString(value)),StringMapWrapper.contains(DatePipe._ALIASES,pattern)&&(pattern=StringMapWrapper.get(DatePipe._ALIASES,pattern)),DateFormatter.format(value,this._locale,pattern)},DatePipe.prototype.supports=function(obj){return!(!isDate(obj)&&!NumberWrapper.isNumeric(obj))||!(!isString(obj)||!isDate(DateWrapper.fromISOString(obj)))},DatePipe._ALIASES={medium:"yMMMdjms",short:"yMdjm",fullDate:"yMMMMEEEEd",longDate:"yMMMMd",mediumDate:"yMMMd",shortDate:"yMd",mediumTime:"jms",shortTime:"jm"},DatePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"date",pure:!0}]}],DatePipe.ctorParameters=[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}],DatePipe}(),__extends$2=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},NgLocalization=function(){function NgLocalization(){}return NgLocalization}(),NgLocaleLocalization=function(_super){function NgLocaleLocalization(_locale){_super.call(this),this._locale=_locale}return __extends$2(NgLocaleLocalization,_super),NgLocaleLocalization.prototype.getPluralCategory=function(value){var plural=getPluralCase(this._locale,value);switch(plural){case Plural.Zero:return"zero";case Plural.One:return"one";case Plural.Two:return"two";case Plural.Few:return"few";case Plural.Many:return"many";default:return"other"}},NgLocaleLocalization.decorators=[{type:_angular_core.Injectable}],NgLocaleLocalization.ctorParameters=[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}],NgLocaleLocalization}(NgLocalization);!function(Plural){Plural[Plural.Zero=0]="Zero",Plural[Plural.One=1]="One",Plural[Plural.Two=2]="Two",Plural[Plural.Few=3]="Few",Plural[Plural.Many=4]="Many",Plural[Plural.Other=5]="Other"}(Plural||(Plural={}));var _INTERPOLATION_REGEXP=/#/g,I18nPluralPipe=function(){function I18nPluralPipe(_localization){this._localization=_localization}return I18nPluralPipe.prototype.transform=function(value,pluralMap){if(isBlank(value))return"";if(!isStringMap(pluralMap))throw new InvalidPipeArgumentError(I18nPluralPipe,pluralMap);var key=getPluralCategory(value,Object.keys(pluralMap),this._localization);return StringWrapper.replaceAll(pluralMap[key],_INTERPOLATION_REGEXP,value.toString())},I18nPluralPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"i18nPlural",pure:!0}]}],I18nPluralPipe.ctorParameters=[{type:NgLocalization}],I18nPluralPipe}(),I18nSelectPipe=function(){function I18nSelectPipe(){}return I18nSelectPipe.prototype.transform=function(value,mapping){if(isBlank(value))return"";if(!isStringMap(mapping))throw new InvalidPipeArgumentError(I18nSelectPipe,mapping);return mapping.hasOwnProperty(value)?mapping[value]:""},I18nSelectPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"i18nSelect",pure:!0}]}],I18nSelectPipe.ctorParameters=[],I18nSelectPipe}(),JsonPipe=function(){function JsonPipe(){}return JsonPipe.prototype.transform=function(value){return Json.stringify(value)},JsonPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"json",pure:!1}]}],JsonPipe.ctorParameters=[],JsonPipe}(),LowerCasePipe=function(){function LowerCasePipe(){}return LowerCasePipe.prototype.transform=function(value){if(isBlank(value))return value;if(!isString(value))throw new InvalidPipeArgumentError(LowerCasePipe,value);return value.toLowerCase()},LowerCasePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"lowercase"}]}],LowerCasePipe.ctorParameters=[],LowerCasePipe}(),_NUMBER_FORMAT_REGEXP=/^(\d+)?\.((\d+)(\-(\d+))?)?$/,DecimalPipe=function(){function DecimalPipe(_locale){this._locale=_locale}return DecimalPipe.prototype.transform=function(value,digits){return void 0===digits&&(digits=null),formatNumber(DecimalPipe,this._locale,value,NumberFormatStyle.Decimal,digits)},DecimalPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"number"}]}],DecimalPipe.ctorParameters=[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}],DecimalPipe}(),PercentPipe=function(){function PercentPipe(_locale){this._locale=_locale}return PercentPipe.prototype.transform=function(value,digits){return void 0===digits&&(digits=null),formatNumber(PercentPipe,this._locale,value,NumberFormatStyle.Percent,digits)},PercentPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"percent"}]}],PercentPipe.ctorParameters=[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}],PercentPipe}(),CurrencyPipe=function(){function CurrencyPipe(_locale){this._locale=_locale}return CurrencyPipe.prototype.transform=function(value,currencyCode,symbolDisplay,digits){return void 0===currencyCode&&(currencyCode="USD"),void 0===symbolDisplay&&(symbolDisplay=!1),void 0===digits&&(digits=null),formatNumber(CurrencyPipe,this._locale,value,NumberFormatStyle.Currency,digits,currencyCode,symbolDisplay)},CurrencyPipe.decorators=[{type:_angular_core.Pipe,args:[{name:"currency"}]}],CurrencyPipe.ctorParameters=[{type:void 0,decorators:[{type:_angular_core.Inject,args:[_angular_core.LOCALE_ID]}]}],CurrencyPipe}(),SlicePipe=function(){function SlicePipe(){}return SlicePipe.prototype.transform=function(value,start,end){if(void 0===end&&(end=null),isBlank(value))return value;if(!this.supports(value))throw new InvalidPipeArgumentError(SlicePipe,value);return isString(value)?StringWrapper.slice(value,start,end):ListWrapper.slice(value,start,end)},SlicePipe.prototype.supports=function(obj){return isString(obj)||isArray(obj)},SlicePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"slice",pure:!1}]}],SlicePipe.ctorParameters=[],SlicePipe}(),UpperCasePipe=function(){function UpperCasePipe(){}return UpperCasePipe.prototype.transform=function(value){if(isBlank(value))return value;if(!isString(value))throw new InvalidPipeArgumentError(UpperCasePipe,value);return value.toUpperCase()},UpperCasePipe.decorators=[{type:_angular_core.Pipe,args:[{name:"uppercase"}]}],UpperCasePipe.ctorParameters=[],UpperCasePipe}(),NgClass=function(){function NgClass(_iterableDiffers,_keyValueDiffers,_ngEl,_renderer){this._iterableDiffers=_iterableDiffers,this._keyValueDiffers=_keyValueDiffers,this._ngEl=_ngEl,this._renderer=_renderer,this._initialClasses=[]}return Object.defineProperty(NgClass.prototype,"initialClasses",{set:function(v){this._applyInitialClasses(!0),this._initialClasses=isPresent(v)&&isString(v)?v.split(" "):[],this._applyInitialClasses(!1),this._applyClasses(this._rawClass,!1)},enumerable:!0,configurable:!0}),Object.defineProperty(NgClass.prototype,"ngClass",{set:function(v){this._cleanupClasses(this._rawClass),isString(v)&&(v=v.split(" ")),this._rawClass=v,this._iterableDiffer=null,this._keyValueDiffer=null,isPresent(v)&&(isListLikeIterable(v)?this._iterableDiffer=this._iterableDiffers.find(v).create(null):this._keyValueDiffer=this._keyValueDiffers.find(v).create(null))},enumerable:!0,configurable:!0}),NgClass.prototype.ngDoCheck=function(){if(isPresent(this._iterableDiffer)){var changes=this._iterableDiffer.diff(this._rawClass);isPresent(changes)&&this._applyIterableChanges(changes)}if(isPresent(this._keyValueDiffer)){var changes=this._keyValueDiffer.diff(this._rawClass);isPresent(changes)&&this._applyKeyValueChanges(changes)}},NgClass.prototype._cleanupClasses=function(rawClassVal){this._applyClasses(rawClassVal,!0),this._applyInitialClasses(!1)},NgClass.prototype._applyKeyValueChanges=function(changes){var _this=this;changes.forEachAddedItem(function(record){_this._toggleClass(record.key,record.currentValue)}),changes.forEachChangedItem(function(record){_this._toggleClass(record.key,record.currentValue)}),changes.forEachRemovedItem(function(record){record.previousValue&&_this._toggleClass(record.key,!1)})},NgClass.prototype._applyIterableChanges=function(changes){var _this=this;changes.forEachAddedItem(function(record){_this._toggleClass(record.item,!0)}),changes.forEachRemovedItem(function(record){_this._toggleClass(record.item,!1)})},NgClass.prototype._applyInitialClasses=function(isCleanup){var _this=this;this._initialClasses.forEach(function(className){return _this._toggleClass(className,!isCleanup)})},NgClass.prototype._applyClasses=function(rawClassVal,isCleanup){var _this=this;isPresent(rawClassVal)&&(isArray(rawClassVal)?rawClassVal.forEach(function(className){return _this._toggleClass(className,!isCleanup)}):rawClassVal instanceof Set?rawClassVal.forEach(function(className){return _this._toggleClass(className,!isCleanup)}):StringMapWrapper.forEach(rawClassVal,function(expVal,className){isPresent(expVal)&&_this._toggleClass(className,!isCleanup)}))},NgClass.prototype._toggleClass=function(className,enabled){if(className=className.trim(),className.length>0)if(className.indexOf(" ")>-1)for(var classes=className.split(/\s+/g),i=0,len=classes.length;i<len;i++)this._renderer.setElementClass(this._ngEl.nativeElement,classes[i],enabled);else this._renderer.setElementClass(this._ngEl.nativeElement,className,enabled)},NgClass.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngClass]"}]}],NgClass.ctorParameters=[{type:_angular_core.IterableDiffers},{type:_angular_core.KeyValueDiffers},{type:_angular_core.ElementRef},{type:_angular_core.Renderer}],NgClass.propDecorators={initialClasses:[{type:_angular_core.Input,args:["class"]}],ngClass:[{type:_angular_core.Input}]},NgClass}(),NgForRow=function(){function NgForRow($implicit,index,count){this.$implicit=$implicit,this.index=index,this.count=count}return Object.defineProperty(NgForRow.prototype,"first",{get:function(){return 0===this.index},enumerable:!0,configurable:!0}),Object.defineProperty(NgForRow.prototype,"last",{get:function(){return this.index===this.count-1},enumerable:!0,configurable:!0}),Object.defineProperty(NgForRow.prototype,"even",{get:function(){return this.index%2===0},enumerable:!0,configurable:!0}),Object.defineProperty(NgForRow.prototype,"odd",{get:function(){return!this.even},enumerable:!0,configurable:!0}),NgForRow}(),NgFor=function(){function NgFor(_viewContainer,_templateRef,_iterableDiffers,_cdr){this._viewContainer=_viewContainer,this._templateRef=_templateRef,this._iterableDiffers=_iterableDiffers,this._cdr=_cdr}return Object.defineProperty(NgFor.prototype,"ngForTemplate",{set:function(value){isPresent(value)&&(this._templateRef=value)},enumerable:!0,configurable:!0}),NgFor.prototype.ngOnChanges=function(changes){if("ngForOf"in changes){var value=changes.ngForOf.currentValue;if(isBlank(this._differ)&&isPresent(value))try{this._differ=this._iterableDiffers.find(value).create(this._cdr,this.ngForTrackBy)}catch(e){throw new Error("Cannot find a differ supporting object '"+value+"' of type '"+getTypeNameForDebugging(value)+"'. NgFor only supports binding to Iterables such as Arrays.")}}},NgFor.prototype.ngDoCheck=function(){if(isPresent(this._differ)){var changes=this._differ.diff(this.ngForOf);isPresent(changes)&&this._applyChanges(changes)}},NgFor.prototype._applyChanges=function(changes){var _this=this,insertTuples=[];changes.forEachOperation(function(item,adjustedPreviousIndex,currentIndex){if(null==item.previousIndex){var view=_this._viewContainer.createEmbeddedView(_this._templateRef,new NgForRow(null,null,null),currentIndex),tuple=new RecordViewTuple(item,view);insertTuples.push(tuple)}else if(null==currentIndex)_this._viewContainer.remove(adjustedPreviousIndex);else{var view=_this._viewContainer.get(adjustedPreviousIndex);_this._viewContainer.move(view,currentIndex);var tuple=new RecordViewTuple(item,view);insertTuples.push(tuple)}});for(var i=0;i<insertTuples.length;i++)this._perViewChange(insertTuples[i].view,insertTuples[i].record);for(var i=0,ilen=this._viewContainer.length;i<ilen;i++){var viewRef=this._viewContainer.get(i);viewRef.context.index=i,viewRef.context.count=ilen}changes.forEachIdentityChange(function(record){var viewRef=_this._viewContainer.get(record.currentIndex);viewRef.context.$implicit=record.item})},NgFor.prototype._perViewChange=function(view,record){view.context.$implicit=record.item},NgFor.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngFor][ngForOf]"}]}],NgFor.ctorParameters=[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef},{type:_angular_core.IterableDiffers},{type:_angular_core.ChangeDetectorRef}],NgFor.propDecorators={ngForOf:[{type:_angular_core.Input}],ngForTrackBy:[{type:_angular_core.Input}],ngForTemplate:[{type:_angular_core.Input}]},NgFor}(),RecordViewTuple=function(){function RecordViewTuple(record,view){this.record=record,this.view=view}return RecordViewTuple}(),NgIf=function(){function NgIf(_viewContainer,_templateRef){this._viewContainer=_viewContainer,this._templateRef=_templateRef,this._prevCondition=null}return Object.defineProperty(NgIf.prototype,"ngIf",{set:function(newCondition){!newCondition||!isBlank(this._prevCondition)&&this._prevCondition?newCondition||!isBlank(this._prevCondition)&&!this._prevCondition||(this._prevCondition=!1,this._viewContainer.clear()):(this._prevCondition=!0,this._viewContainer.createEmbeddedView(this._templateRef))},enumerable:!0,configurable:!0}),NgIf.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngIf]"}]}],NgIf.ctorParameters=[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef}],NgIf.propDecorators={ngIf:[{type:_angular_core.Input}]},NgIf}(),_CASE_DEFAULT=new Object,SwitchView=function(){function SwitchView(_viewContainerRef,_templateRef){this._viewContainerRef=_viewContainerRef,this._templateRef=_templateRef}return SwitchView.prototype.create=function(){this._viewContainerRef.createEmbeddedView(this._templateRef)},SwitchView.prototype.destroy=function(){this._viewContainerRef.clear()},SwitchView}(),NgSwitch=function(){function NgSwitch(){this._useDefault=!1,this._valueViews=new Map,this._activeViews=[]}return Object.defineProperty(NgSwitch.prototype,"ngSwitch",{set:function(value){this._emptyAllActiveViews(),this._useDefault=!1;var views=this._valueViews.get(value);isBlank(views)&&(this._useDefault=!0,views=normalizeBlank(this._valueViews.get(_CASE_DEFAULT))),this._activateViews(views),this._switchValue=value},enumerable:!0,configurable:!0}),NgSwitch.prototype._onCaseValueChanged=function(oldCase,newCase,view){this._deregisterView(oldCase,view),this._registerView(newCase,view),oldCase===this._switchValue?(view.destroy(),ListWrapper.remove(this._activeViews,view)):newCase===this._switchValue&&(this._useDefault&&(this._useDefault=!1,this._emptyAllActiveViews()),view.create(),this._activeViews.push(view)),0!==this._activeViews.length||this._useDefault||(this._useDefault=!0,this._activateViews(this._valueViews.get(_CASE_DEFAULT)))},NgSwitch.prototype._emptyAllActiveViews=function(){for(var activeContainers=this._activeViews,i=0;i<activeContainers.length;i++)activeContainers[i].destroy();
this._activeViews=[]},NgSwitch.prototype._activateViews=function(views){if(isPresent(views)){for(var i=0;i<views.length;i++)views[i].create();this._activeViews=views}},NgSwitch.prototype._registerView=function(value,view){var views=this._valueViews.get(value);isBlank(views)&&(views=[],this._valueViews.set(value,views)),views.push(view)},NgSwitch.prototype._deregisterView=function(value,view){if(value!==_CASE_DEFAULT){var views=this._valueViews.get(value);1==views.length?this._valueViews.delete(value):ListWrapper.remove(views,view)}},NgSwitch.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngSwitch]"}]}],NgSwitch.ctorParameters=[],NgSwitch.propDecorators={ngSwitch:[{type:_angular_core.Input}]},NgSwitch}(),NgSwitchCase=function(){function NgSwitchCase(viewContainer,templateRef,ngSwitch){this._value=_CASE_DEFAULT,this._switch=ngSwitch,this._view=new SwitchView(viewContainer,templateRef)}return Object.defineProperty(NgSwitchCase.prototype,"ngSwitchCase",{set:function(value){this._switch._onCaseValueChanged(this._value,value,this._view),this._value=value},enumerable:!0,configurable:!0}),NgSwitchCase.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngSwitchCase]"}]}],NgSwitchCase.ctorParameters=[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef},{type:NgSwitch,decorators:[{type:_angular_core.Host}]}],NgSwitchCase.propDecorators={ngSwitchCase:[{type:_angular_core.Input}]},NgSwitchCase}(),NgSwitchDefault=function(){function NgSwitchDefault(viewContainer,templateRef,sswitch){sswitch._registerView(_CASE_DEFAULT,new SwitchView(viewContainer,templateRef))}return NgSwitchDefault.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngSwitchDefault]"}]}],NgSwitchDefault.ctorParameters=[{type:_angular_core.ViewContainerRef},{type:_angular_core.TemplateRef},{type:NgSwitch,decorators:[{type:_angular_core.Host}]}],NgSwitchDefault}(),NgPlural=function(){function NgPlural(_localization){this._localization=_localization,this._caseViews={}}return Object.defineProperty(NgPlural.prototype,"ngPlural",{set:function(value){this._switchValue=value,this._updateView()},enumerable:!0,configurable:!0}),NgPlural.prototype.addCase=function(value,switchView){this._caseViews[value]=switchView},NgPlural.prototype._updateView=function(){this._clearViews();var key=getPluralCategory(this._switchValue,Object.keys(this._caseViews),this._localization);this._activateView(this._caseViews[key])},NgPlural.prototype._clearViews=function(){isPresent(this._activeView)&&this._activeView.destroy()},NgPlural.prototype._activateView=function(view){isPresent(view)&&(this._activeView=view,this._activeView.create())},NgPlural.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngPlural]"}]}],NgPlural.ctorParameters=[{type:NgLocalization}],NgPlural.propDecorators={ngPlural:[{type:_angular_core.Input}]},NgPlural}(),NgPluralCase=function(){function NgPluralCase(value,template,viewContainer,ngPlural){this.value=value,ngPlural.addCase(value,new SwitchView(viewContainer,template))}return NgPluralCase.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngPluralCase]"}]}],NgPluralCase.ctorParameters=[{type:void 0,decorators:[{type:_angular_core.Attribute,args:["ngPluralCase"]}]},{type:_angular_core.TemplateRef},{type:_angular_core.ViewContainerRef},{type:NgPlural,decorators:[{type:_angular_core.Host}]}],NgPluralCase}(),NgStyle=function(){function NgStyle(_differs,_ngEl,_renderer){this._differs=_differs,this._ngEl=_ngEl,this._renderer=_renderer}return Object.defineProperty(NgStyle.prototype,"ngStyle",{set:function(v){this._ngStyle=v,isBlank(this._differ)&&isPresent(v)&&(this._differ=this._differs.find(this._ngStyle).create(null))},enumerable:!0,configurable:!0}),NgStyle.prototype.ngDoCheck=function(){if(isPresent(this._differ)){var changes=this._differ.diff(this._ngStyle);isPresent(changes)&&this._applyChanges(changes)}},NgStyle.prototype._applyChanges=function(changes){var _this=this;changes.forEachRemovedItem(function(record){_this._setStyle(record.key,null)}),changes.forEachAddedItem(function(record){_this._setStyle(record.key,record.currentValue)}),changes.forEachChangedItem(function(record){_this._setStyle(record.key,record.currentValue)})},NgStyle.prototype._setStyle=function(name,val){var nameParts=name.split("."),nameToSet=nameParts[0],valToSet=isPresent(val)&&2===nameParts.length?""+val+nameParts[1]:val;this._renderer.setElementStyle(this._ngEl.nativeElement,nameToSet,valToSet)},NgStyle.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngStyle]"}]}],NgStyle.ctorParameters=[{type:_angular_core.KeyValueDiffers},{type:_angular_core.ElementRef},{type:_angular_core.Renderer}],NgStyle.propDecorators={ngStyle:[{type:_angular_core.Input}]},NgStyle}(),NgTemplateOutlet=function(){function NgTemplateOutlet(_viewContainerRef){this._viewContainerRef=_viewContainerRef}return Object.defineProperty(NgTemplateOutlet.prototype,"ngOutletContext",{set:function(context){this._context=context},enumerable:!0,configurable:!0}),Object.defineProperty(NgTemplateOutlet.prototype,"ngTemplateOutlet",{set:function(templateRef){this._templateRef=templateRef},enumerable:!0,configurable:!0}),NgTemplateOutlet.prototype.ngOnChanges=function(){this._viewRef&&this._viewContainerRef.remove(this._viewContainerRef.indexOf(this._viewRef)),this._templateRef&&(this._viewRef=this._viewContainerRef.createEmbeddedView(this._templateRef,this._context))},NgTemplateOutlet.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngTemplateOutlet]"}]}],NgTemplateOutlet.ctorParameters=[{type:_angular_core.ViewContainerRef}],NgTemplateOutlet.propDecorators={ngOutletContext:[{type:_angular_core.Input}],ngTemplateOutlet:[{type:_angular_core.Input}]},NgTemplateOutlet}(),PlatformLocation=function(){function PlatformLocation(){}return Object.defineProperty(PlatformLocation.prototype,"pathname",{get:function(){return null},enumerable:!0,configurable:!0}),Object.defineProperty(PlatformLocation.prototype,"search",{get:function(){return null},enumerable:!0,configurable:!0}),Object.defineProperty(PlatformLocation.prototype,"hash",{get:function(){return null},enumerable:!0,configurable:!0}),PlatformLocation}(),LocationStrategy=function(){function LocationStrategy(){}return LocationStrategy}(),APP_BASE_HREF=new _angular_core.OpaqueToken("appBaseHref"),Location=function(){function Location(platformStrategy){var _this=this;this._subject=new _angular_core.EventEmitter,this._platformStrategy=platformStrategy;var browserBaseHref=this._platformStrategy.getBaseHref();this._baseHref=Location.stripTrailingSlash(_stripIndexHtml(browserBaseHref)),this._platformStrategy.onPopState(function(ev){_this._subject.emit({url:_this.path(!0),pop:!0,type:ev.type})})}return Location.prototype.path=function(includeHash){return void 0===includeHash&&(includeHash=!1),this.normalize(this._platformStrategy.path(includeHash))},Location.prototype.isCurrentPathEqualTo=function(path,query){return void 0===query&&(query=""),this.path()==this.normalize(path+Location.normalizeQueryParams(query))},Location.prototype.normalize=function(url){return Location.stripTrailingSlash(_stripBaseHref(this._baseHref,_stripIndexHtml(url)))},Location.prototype.prepareExternalUrl=function(url){return url.length>0&&!url.startsWith("/")&&(url="/"+url),this._platformStrategy.prepareExternalUrl(url)},Location.prototype.go=function(path,query){void 0===query&&(query=""),this._platformStrategy.pushState(null,"",path,query)},Location.prototype.replaceState=function(path,query){void 0===query&&(query=""),this._platformStrategy.replaceState(null,"",path,query)},Location.prototype.forward=function(){this._platformStrategy.forward()},Location.prototype.back=function(){this._platformStrategy.back()},Location.prototype.subscribe=function(onNext,onThrow,onReturn){return void 0===onThrow&&(onThrow=null),void 0===onReturn&&(onReturn=null),this._subject.subscribe({next:onNext,error:onThrow,complete:onReturn})},Location.normalizeQueryParams=function(params){return params.length>0&&"?"!=params.substring(0,1)?"?"+params:params},Location.joinWithSlash=function(start,end){if(0==start.length)return end;if(0==end.length)return start;var slashes=0;return start.endsWith("/")&&slashes++,end.startsWith("/")&&slashes++,2==slashes?start+end.substring(1):1==slashes?start+end:start+"/"+end},Location.stripTrailingSlash=function(url){return/\/$/g.test(url)&&(url=url.substring(0,url.length-1)),url},Location.decorators=[{type:_angular_core.Injectable}],Location.ctorParameters=[{type:LocationStrategy}],Location}(),__extends$3=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},HashLocationStrategy=function(_super){function HashLocationStrategy(_platformLocation,_baseHref){_super.call(this),this._platformLocation=_platformLocation,this._baseHref="",isPresent(_baseHref)&&(this._baseHref=_baseHref)}return __extends$3(HashLocationStrategy,_super),HashLocationStrategy.prototype.onPopState=function(fn){this._platformLocation.onPopState(fn),this._platformLocation.onHashChange(fn)},HashLocationStrategy.prototype.getBaseHref=function(){return this._baseHref},HashLocationStrategy.prototype.path=function(includeHash){void 0===includeHash&&(includeHash=!1);var path=this._platformLocation.hash;return isPresent(path)||(path="#"),path.length>0?path.substring(1):path},HashLocationStrategy.prototype.prepareExternalUrl=function(internal){var url=Location.joinWithSlash(this._baseHref,internal);return url.length>0?"#"+url:url},HashLocationStrategy.prototype.pushState=function(state,title,path,queryParams){var url=this.prepareExternalUrl(path+Location.normalizeQueryParams(queryParams));0==url.length&&(url=this._platformLocation.pathname),this._platformLocation.pushState(state,title,url)},HashLocationStrategy.prototype.replaceState=function(state,title,path,queryParams){var url=this.prepareExternalUrl(path+Location.normalizeQueryParams(queryParams));0==url.length&&(url=this._platformLocation.pathname),this._platformLocation.replaceState(state,title,url)},HashLocationStrategy.prototype.forward=function(){this._platformLocation.forward()},HashLocationStrategy.prototype.back=function(){this._platformLocation.back()},HashLocationStrategy.decorators=[{type:_angular_core.Injectable}],HashLocationStrategy.ctorParameters=[{type:PlatformLocation},{type:void 0,decorators:[{type:_angular_core.Optional},{type:_angular_core.Inject,args:[APP_BASE_HREF]}]}],HashLocationStrategy}(LocationStrategy),__extends$4=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},PathLocationStrategy=function(_super){function PathLocationStrategy(_platformLocation,href){if(_super.call(this),this._platformLocation=_platformLocation,isBlank(href)&&(href=this._platformLocation.getBaseHrefFromDOM()),isBlank(href))throw new Error("No base href set. Please provide a value for the APP_BASE_HREF token or add a base element to the document.");this._baseHref=href}return __extends$4(PathLocationStrategy,_super),PathLocationStrategy.prototype.onPopState=function(fn){this._platformLocation.onPopState(fn),this._platformLocation.onHashChange(fn)},PathLocationStrategy.prototype.getBaseHref=function(){return this._baseHref},PathLocationStrategy.prototype.prepareExternalUrl=function(internal){return Location.joinWithSlash(this._baseHref,internal)},PathLocationStrategy.prototype.path=function(includeHash){void 0===includeHash&&(includeHash=!1);var pathname=this._platformLocation.pathname+Location.normalizeQueryParams(this._platformLocation.search),hash=this._platformLocation.hash;return hash&&includeHash?""+pathname+hash:pathname},PathLocationStrategy.prototype.pushState=function(state,title,url,queryParams){var externalUrl=this.prepareExternalUrl(url+Location.normalizeQueryParams(queryParams));this._platformLocation.pushState(state,title,externalUrl)},PathLocationStrategy.prototype.replaceState=function(state,title,url,queryParams){var externalUrl=this.prepareExternalUrl(url+Location.normalizeQueryParams(queryParams));this._platformLocation.replaceState(state,title,externalUrl)},PathLocationStrategy.prototype.forward=function(){this._platformLocation.forward()},PathLocationStrategy.prototype.back=function(){this._platformLocation.back()},PathLocationStrategy.decorators=[{type:_angular_core.Injectable}],PathLocationStrategy.ctorParameters=[{type:PlatformLocation},{type:void 0,decorators:[{type:_angular_core.Optional},{type:_angular_core.Inject,args:[APP_BASE_HREF]}]}],PathLocationStrategy}(LocationStrategy),CORE_DIRECTIVES=[NgClass,NgFor,NgIf,NgTemplateOutlet,NgStyle,NgSwitch,NgSwitchCase,NgSwitchDefault,NgPlural,NgPluralCase],COMMON_DIRECTIVES=CORE_DIRECTIVES,COMMON_PIPES=[AsyncPipe,UpperCasePipe,LowerCasePipe,JsonPipe,SlicePipe,DecimalPipe,PercentPipe,CurrencyPipe,DatePipe,I18nPluralPipe,I18nSelectPipe],CommonModule=function(){function CommonModule(){}return CommonModule.decorators=[{type:_angular_core.NgModule,args:[{declarations:[COMMON_DIRECTIVES,COMMON_PIPES],exports:[COMMON_DIRECTIVES,COMMON_PIPES],providers:[{provide:NgLocalization,useClass:NgLocaleLocalization}]}]}],CommonModule.ctorParameters=[],CommonModule}();exports.NgLocalization=NgLocalization,exports.CommonModule=CommonModule,exports.AsyncPipe=AsyncPipe,exports.DatePipe=DatePipe,exports.I18nPluralPipe=I18nPluralPipe,exports.I18nSelectPipe=I18nSelectPipe,exports.JsonPipe=JsonPipe,exports.LowerCasePipe=LowerCasePipe,exports.CurrencyPipe=CurrencyPipe,exports.DecimalPipe=DecimalPipe,exports.PercentPipe=PercentPipe,exports.SlicePipe=SlicePipe,exports.UpperCasePipe=UpperCasePipe,exports.NgClass=NgClass,exports.NgFor=NgFor,exports.NgIf=NgIf,exports.NgPlural=NgPlural,exports.NgPluralCase=NgPluralCase,exports.NgStyle=NgStyle,exports.NgSwitch=NgSwitch,exports.NgSwitchCase=NgSwitchCase,exports.NgSwitchDefault=NgSwitchDefault,exports.NgTemplateOutlet=NgTemplateOutlet,exports.PlatformLocation=PlatformLocation,exports.LocationStrategy=LocationStrategy,exports.APP_BASE_HREF=APP_BASE_HREF,exports.HashLocationStrategy=HashLocationStrategy,exports.PathLocationStrategy=PathLocationStrategy,exports.Location=Location});
