/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * This module provides a set of common Pipes.
 */
export { AsyncPipe } from './pipes/async_pipe';
export { DatePipe } from './pipes/date_pipe';
export { I18nPluralPipe } from './pipes/i18n_plural_pipe';
export { I18nSelectPipe } from './pipes/i18n_select_pipe';
export { JsonPipe } from './pipes/json_pipe';
export { LowerCasePipe } from './pipes/lowercase_pipe';
export { CurrencyPipe, DecimalPipe, PercentPipe } from './pipes/number_pipe';
export { SlicePipe } from './pipes/slice_pipe';
export { UpperCasePipe } from './pipes/uppercase_pipe';
//# sourceMappingURL=pipes.js.map