/**
 * @license Angular v5.0.3
 * (c) 2010-2017 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/common/http"),require("@angular/core"),require("rxjs/Observable")):"function"==typeof define&&define.amd?define("@angular/common/http/testing",["exports","@angular/common/http","@angular/core","rxjs/Observable"],factory):factory((global.ng=global.ng||{},global.ng.common=global.ng.common||{},global.ng.common.http=global.ng.common.http||{},global.ng.common.http.testing={}),global.ng.common.http,global.ng.core,global.Rx)}(this,function(exports,_angular_common_http,_angular_core,rxjs_Observable){"use strict";function _toArrayBufferBody(body){if("undefined"==typeof ArrayBuffer)throw new Error("ArrayBuffer responses are not supported on this platform.");if(body instanceof ArrayBuffer)return body;throw new Error("Automatic conversion to ArrayBuffer is not supported for response type.")}function _toBlob(body){if("undefined"==typeof Blob)throw new Error("Blob responses are not supported on this platform.");if(body instanceof Blob)return body;if(ArrayBuffer&&body instanceof ArrayBuffer)return new Blob([body]);throw new Error("Automatic conversion to Blob is not supported for response type.")}function _toJsonBody(body,format){if(void 0===format&&(format="JSON"),"undefined"!=typeof ArrayBuffer&&body instanceof ArrayBuffer)throw new Error("Automatic conversion to "+format+" is not supported for ArrayBuffers.");if("undefined"!=typeof Blob&&body instanceof Blob)throw new Error("Automatic conversion to "+format+" is not supported for Blobs.");if("string"==typeof body||"number"==typeof body||"object"==typeof body||Array.isArray(body))return body;throw new Error("Automatic conversion to "+format+" is not supported for response type.")}function _toTextBody(body){if("string"==typeof body)return body;if("undefined"!=typeof ArrayBuffer&&body instanceof ArrayBuffer)throw new Error("Automatic conversion to text is not supported for ArrayBuffers.");if("undefined"!=typeof Blob&&body instanceof Blob)throw new Error("Automatic conversion to text is not supported for Blobs.");return JSON.stringify(_toJsonBody(body,"text"))}function _maybeConvertBody(responseType,body){switch(responseType){case"arraybuffer":return null===body?null:_toArrayBufferBody(body);case"blob":return null===body?null:_toBlob(body);case"json":return null===body?"null":_toJsonBody(body);case"text":return null===body?null:_toTextBody(body);default:throw new Error("Unsupported responseType: "+responseType)}}/**
 * @license Angular v5.0.3
 * (c) 2010-2017 Google, Inc. https://angular.io/
 * License: MIT
 */
var HttpTestingController=function(){function HttpTestingController(){}return HttpTestingController}(),TestRequest=function(){function TestRequest(request,observer){this.request=request,this.observer=observer,this._cancelled=!1}return Object.defineProperty(TestRequest.prototype,"cancelled",{get:function(){return this._cancelled},enumerable:!0,configurable:!0}),TestRequest.prototype.flush=function(body,opts){if(void 0===opts&&(opts={}),this.cancelled)throw new Error("Cannot flush a cancelled request.");var url=this.request.urlWithParams,headers=opts.headers instanceof _angular_common_http.HttpHeaders?opts.headers:new _angular_common_http.HttpHeaders(opts.headers);body=_maybeConvertBody(this.request.responseType,body);var statusText=opts.statusText,status=void 0!==opts.status?opts.status:200;if(void 0===opts.status&&(null===body?(status=204,statusText=statusText||"No Content"):statusText=statusText||"OK"),void 0===statusText)throw new Error("statusText is required when setting a custom status.");status>=200&&status<300?(this.observer.next(new _angular_common_http.HttpResponse({body:body,headers:headers,status:status,statusText:statusText,url:url})),this.observer.complete()):this.observer.error(new _angular_common_http.HttpErrorResponse({error:body,headers:headers,status:status,statusText:statusText,url:url}))},TestRequest.prototype.error=function(error,opts){if(void 0===opts&&(opts={}),this.cancelled)throw new Error("Cannot return an error for a cancelled request.");if(opts.status&&opts.status>=200&&opts.status<300)throw new Error("error() called with a successful status.");var headers=opts.headers instanceof _angular_common_http.HttpHeaders?opts.headers:new _angular_common_http.HttpHeaders(opts.headers);this.observer.error(new _angular_common_http.HttpErrorResponse({error:error,headers:headers,status:opts.status||0,statusText:opts.statusText||"",url:this.request.urlWithParams}))},TestRequest.prototype.event=function(event){if(this.cancelled)throw new Error("Cannot send events to a cancelled request.");this.observer.next(event)},TestRequest}(),HttpClientTestingBackend=function(){function HttpClientTestingBackend(){this.open=[]}return HttpClientTestingBackend.prototype.handle=function(req){var _this=this;return new rxjs_Observable.Observable(function(observer){var testReq=new TestRequest(req,observer);return _this.open.push(testReq),observer.next({type:_angular_common_http.HttpEventType.Sent}),function(){testReq._cancelled=!0}})},HttpClientTestingBackend.prototype._match=function(match){return"string"==typeof match?this.open.filter(function(testReq){return testReq.request.urlWithParams===match}):"function"==typeof match?this.open.filter(function(testReq){return match(testReq.request)}):this.open.filter(function(testReq){return!(match.method&&testReq.request.method!==match.method.toUpperCase()||match.url&&testReq.request.urlWithParams!==match.url)})},HttpClientTestingBackend.prototype.match=function(match){var _this=this,results=this._match(match);return results.forEach(function(result){var index=_this.open.indexOf(result);-1!==index&&_this.open.splice(index,1)}),results},HttpClientTestingBackend.prototype.expectOne=function(match,description){description=description||this.descriptionFromMatcher(match);var matches=this.match(match);if(matches.length>1)throw new Error('Expected one matching request for criteria "'+description+'", found '+matches.length+" requests.");if(0===matches.length)throw new Error('Expected one matching request for criteria "'+description+'", found none.');return matches[0]},HttpClientTestingBackend.prototype.expectNone=function(match,description){description=description||this.descriptionFromMatcher(match);var matches=this.match(match);if(matches.length>0)throw new Error('Expected zero matching requests for criteria "'+description+'", found '+matches.length+".")},HttpClientTestingBackend.prototype.verify=function(opts){void 0===opts&&(opts={});var open=this.open;if(opts.ignoreCancelled&&(open=open.filter(function(testReq){return!testReq.cancelled})),open.length>0){var requests=open.map(function(testReq){var url=testReq.request.urlWithParams.split("?")[0];return testReq.request.method+" "+url}).join(", ");throw new Error("Expected no open requests, found "+open.length+": "+requests)}},HttpClientTestingBackend.prototype.descriptionFromMatcher=function(matcher){if("string"==typeof matcher)return"Match URL: "+matcher;if("object"==typeof matcher){return"Match method: "+(matcher.method||"(any)")+", URL: "+(matcher.url||"(any)")}return"Match by function: "+matcher.name},HttpClientTestingBackend.decorators=[{type:_angular_core.Injectable}],HttpClientTestingBackend.ctorParameters=function(){return[]},HttpClientTestingBackend}(),HttpClientTestingModule=function(){function HttpClientTestingModule(){}return HttpClientTestingModule.decorators=[{type:_angular_core.NgModule,args:[{imports:[_angular_common_http.HttpClientModule],providers:[HttpClientTestingBackend,{provide:_angular_common_http.HttpBackend,useExisting:HttpClientTestingBackend},{provide:HttpTestingController,useExisting:HttpClientTestingBackend}]}]}],HttpClientTestingModule.ctorParameters=function(){return[]},HttpClientTestingModule}();exports.HttpTestingController=HttpTestingController,exports.HttpClientTestingModule=HttpClientTestingModule,exports.TestRequest=TestRequest,exports.ɵa=HttpClientTestingBackend,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=/Users/misko/work/angular/dist/packages-dist/common/bundles/common-http-testing.umd.min.js.map