/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler-cli/src/transformers/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DEFAULT_ERROR_CODE = 100;
    exports.UNKNOWN_ERROR_CODE = 500;
    exports.SOURCE = 'angular';
    function isTsDiagnostic(diagnostic) {
        return diagnostic != null && diagnostic.source !== 'angular';
    }
    exports.isTsDiagnostic = isTsDiagnostic;
    function isNgDiagnostic(diagnostic) {
        return diagnostic != null && diagnostic.source === 'angular';
    }
    exports.isNgDiagnostic = isNgDiagnostic;
    var EmitFlags;
    (function (EmitFlags) {
        EmitFlags[EmitFlags["DTS"] = 1] = "DTS";
        EmitFlags[EmitFlags["JS"] = 2] = "JS";
        EmitFlags[EmitFlags["Metadata"] = 4] = "Metadata";
        EmitFlags[EmitFlags["I18nBundle"] = 8] = "I18nBundle";
        EmitFlags[EmitFlags["Codegen"] = 16] = "Codegen";
        EmitFlags[EmitFlags["Default"] = 19] = "Default";
        EmitFlags[EmitFlags["All"] = 31] = "All";
    })(EmitFlags = exports.EmitFlags || (exports.EmitFlags = {}));
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvY29tcGlsZXItY2xpL3NyYy90cmFuc2Zvcm1lcnMvYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRzs7Ozs7Ozs7Ozs7O0lBS1UsUUFBQSxrQkFBa0IsR0FBRyxHQUFHLENBQUM7SUFDekIsUUFBQSxrQkFBa0IsR0FBRyxHQUFHLENBQUM7SUFDekIsUUFBQSxNQUFNLEdBQUcsU0FBc0IsQ0FBQztJQWtCN0Msd0JBQStCLFVBQWU7UUFDNUMsTUFBTSxDQUFDLFVBQVUsSUFBSSxJQUFJLElBQUksVUFBVSxDQUFDLE1BQU0sS0FBSyxTQUFTLENBQUM7SUFDL0QsQ0FBQztJQUZELHdDQUVDO0lBRUQsd0JBQStCLFVBQWU7UUFDNUMsTUFBTSxDQUFDLFVBQVUsSUFBSSxJQUFJLElBQUksVUFBVSxDQUFDLE1BQU0sS0FBSyxTQUFTLENBQUM7SUFDL0QsQ0FBQztJQUZELHdDQUVDO0lBeU1ELElBQVksU0FTWDtJQVRELFdBQVksU0FBUztRQUNuQix1Q0FBWSxDQUFBO1FBQ1oscUNBQVcsQ0FBQTtRQUNYLGlEQUFpQixDQUFBO1FBQ2pCLHFEQUFtQixDQUFBO1FBQ25CLGdEQUFnQixDQUFBO1FBRWhCLGdEQUE0QixDQUFBO1FBQzVCLHdDQUFnRCxDQUFBO0lBQ2xELENBQUMsRUFUVyxTQUFTLEdBQVQsaUJBQVMsS0FBVCxpQkFBUyxRQVNwQiIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICpcbiAqIFVzZSBvZiB0aGlzIHNvdXJjZSBjb2RlIGlzIGdvdmVybmVkIGJ5IGFuIE1JVC1zdHlsZSBsaWNlbnNlIHRoYXQgY2FuIGJlXG4gKiBmb3VuZCBpbiB0aGUgTElDRU5TRSBmaWxlIGF0IGh0dHBzOi8vYW5ndWxhci5pby9saWNlbnNlXG4gKi9cblxuaW1wb3J0IHtHZW5lcmF0ZWRGaWxlLCBQYXJzZVNvdXJjZVNwYW4sIFBvc2l0aW9ufSBmcm9tICdAYW5ndWxhci9jb21waWxlcic7XG5pbXBvcnQgKiBhcyB0cyBmcm9tICd0eXBlc2NyaXB0JztcblxuZXhwb3J0IGNvbnN0IERFRkFVTFRfRVJST1JfQ09ERSA9IDEwMDtcbmV4cG9ydCBjb25zdCBVTktOT1dOX0VSUk9SX0NPREUgPSA1MDA7XG5leHBvcnQgY29uc3QgU09VUkNFID0gJ2FuZ3VsYXInIGFzICdhbmd1bGFyJztcblxuZXhwb3J0IGludGVyZmFjZSBEaWFnbm9zdGljTWVzc2FnZUNoYWluIHtcbiAgbWVzc2FnZVRleHQ6IHN0cmluZztcbiAgcG9zaXRpb24/OiBQb3NpdGlvbjtcbiAgbmV4dD86IERpYWdub3N0aWNNZXNzYWdlQ2hhaW47XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGlhZ25vc3RpYyB7XG4gIG1lc3NhZ2VUZXh0OiBzdHJpbmc7XG4gIHNwYW4/OiBQYXJzZVNvdXJjZVNwYW47XG4gIHBvc2l0aW9uPzogUG9zaXRpb247XG4gIGNoYWluPzogRGlhZ25vc3RpY01lc3NhZ2VDaGFpbjtcbiAgY2F0ZWdvcnk6IHRzLkRpYWdub3N0aWNDYXRlZ29yeTtcbiAgY29kZTogbnVtYmVyO1xuICBzb3VyY2U6ICdhbmd1bGFyJztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzVHNEaWFnbm9zdGljKGRpYWdub3N0aWM6IGFueSk6IGRpYWdub3N0aWMgaXMgdHMuRGlhZ25vc3RpYyB7XG4gIHJldHVybiBkaWFnbm9zdGljICE9IG51bGwgJiYgZGlhZ25vc3RpYy5zb3VyY2UgIT09ICdhbmd1bGFyJztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzTmdEaWFnbm9zdGljKGRpYWdub3N0aWM6IGFueSk6IGRpYWdub3N0aWMgaXMgRGlhZ25vc3RpYyB7XG4gIHJldHVybiBkaWFnbm9zdGljICE9IG51bGwgJiYgZGlhZ25vc3RpYy5zb3VyY2UgPT09ICdhbmd1bGFyJztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBDb21waWxlck9wdGlvbnMgZXh0ZW5kcyB0cy5Db21waWxlck9wdGlvbnMge1xuICAvLyBOT1RFOiBUaGVzZSBjb21tZW50cyBhbmQgYWlvL2NvbnRlbnQvZ3VpZGVzL2FvdC1jb21waWxlci5tZCBzaG91bGQgYmUga2VwdCBpbiBzeW5jLlxuXG4gIC8vIFdyaXRlIHN0YXRpc3RpY3MgYWJvdXQgY29tcGlsYXRpb24gKGUuZy4gdG90YWwgdGltZSwgLi4uKVxuICAvLyBOb3RlOiB0aGlzIGlzIHRoZSAtLWRpYWdub3N0aWNzIGNvbW1hbmQgbGluZSBvcHRpb24gZnJvbSBUUyAod2hpY2ggaXMgQGludGVybmFsXG4gIC8vIG9uIHRzLkNvbXBpbGVyT3B0aW9ucyBpbnRlcmZhY2UpLlxuICBkaWFnbm9zdGljcz86IGJvb2xlYW47XG5cbiAgLy8gQWJzb2x1dGUgcGF0aCB0byBhIGRpcmVjdG9yeSB3aGVyZSBnZW5lcmF0ZWQgZmlsZSBzdHJ1Y3R1cmUgaXMgd3JpdHRlbi5cbiAgLy8gSWYgdW5zcGVjaWZpZWQsIGdlbmVyYXRlZCBmaWxlcyB3aWxsIGJlIHdyaXR0ZW4gYWxvbmdzaWRlIHNvdXJjZXMuXG4gIC8vIEBkZXByZWNhdGVkIC0gbm8gZWZmZWN0XG4gIGdlbkRpcj86IHN0cmluZztcblxuICAvLyBQYXRoIHRvIHRoZSBkaXJlY3RvcnkgY29udGFpbmluZyB0aGUgdHNjb25maWcuanNvbiBmaWxlLlxuICBiYXNlUGF0aD86IHN0cmluZztcblxuICAvLyBEb24ndCBwcm9kdWNlIC5tZXRhZGF0YS5qc29uIGZpbGVzICh0aGV5IGRvbid0IHdvcmsgZm9yIGJ1bmRsZWQgZW1pdCB3aXRoIC0tb3V0KVxuICBza2lwTWV0YWRhdGFFbWl0PzogYm9vbGVhbjtcblxuICAvLyBQcm9kdWNlIGFuIGVycm9yIGlmIHRoZSBtZXRhZGF0YSB3cml0dGVuIGZvciBhIGNsYXNzIHdvdWxkIHByb2R1Y2UgYW4gZXJyb3IgaWYgdXNlZC5cbiAgc3RyaWN0TWV0YWRhdGFFbWl0PzogYm9vbGVhbjtcblxuICAvLyBEb24ndCBwcm9kdWNlIC5uZ2ZhY3RvcnkuanMgb3IgLm5nc3R5bGUuanMgZmlsZXNcbiAgc2tpcFRlbXBsYXRlQ29kZWdlbj86IGJvb2xlYW47XG5cbiAgLy8gQWx3YXlzIHJlcG9ydCBlcnJvcnMgd2hlbiB0aGUgdHlwZSBvZiBhIHBhcmFtZXRlciBzdXBwbGllZCB3aG9zZSBpbmplY3Rpb24gdHlwZSBjYW5ub3RcbiAgLy8gYmUgZGV0ZXJtaW5lZC4gV2hlbiB0aGlzIHZhbHVlIG9wdGlvbiBpcyBub3QgcHJvdmlkZWQgb3IgaXMgYGZhbHNlYCwgY29uc3RydWN0b3JcbiAgLy8gcGFyYW1ldGVycyBvZiBjbGFzc2VzIG1hcmtlZCB3aXRoIGBASW5qZWN0YWJsZWAgd2hvc2UgdHlwZSBjYW5ub3QgYmUgcmVzb2x2ZWQgd2lsbFxuICAvLyBwcm9kdWNlIGEgd2FybmluZy4gV2l0aCB0aGlzIG9wdGlvbiBgdHJ1ZWAsIHRoZXkgcHJvZHVjZSBhbiBlcnJvci4gV2hlbiB0aGlzIG9wdGlvbiBpc1xuICAvLyBub3QgcHJvdmlkZWQgaXMgdHJlYXRlZCBhcyBpZiBpdCB3ZXJlIGBmYWxzZWAuIEluIEFuZ3VsYXIgNi4wLCBpZiB0aGlzIG9wdGlvbiBpcyBub3RcbiAgLy8gcHJvdmlkZWQsIGl0IHdpbGwgYmUgdHJlYXRlZCBhcyBgdHJ1ZWAuXG4gIHN0cmljdEluamVjdGlvblBhcmFtZXRlcnM/OiBib29sZWFuO1xuXG4gIC8vIFdoZXRoZXIgdG8gZ2VuZXJhdGUgYSBmbGF0IG1vZHVsZSBpbmRleCBvZiB0aGUgZ2l2ZW4gbmFtZSBhbmQgdGhlIGNvcnJlc3BvbmRpbmdcbiAgLy8gZmxhdCBtb2R1bGUgbWV0YWRhdGEuIFRoaXMgb3B0aW9uIGlzIGludGVuZGVkIHRvIGJlIHVzZWQgd2hlbiBjcmVhdGluZyBmbGF0XG4gIC8vIG1vZHVsZXMgc2ltaWxhciB0byBob3cgYEBhbmd1bGFyL2NvcmVgIGFuZCBgQGFuZ3VsYXIvY29tbW9uYCBhcmUgcGFja2FnZWQuXG4gIC8vIFdoZW4gdGhpcyBvcHRpb24gaXMgdXNlZCB0aGUgYHBhY2thZ2UuanNvbmAgZm9yIHRoZSBsaWJyYXJ5IHNob3VsZCByZWZlcnJlZCB0byB0aGVcbiAgLy8gZ2VuZXJhdGVkIGZsYXQgbW9kdWxlIGluZGV4IGluc3RlYWQgb2YgdGhlIGxpYnJhcnkgaW5kZXggZmlsZS4gV2hlbiB1c2luZyB0aGlzXG4gIC8vIG9wdGlvbiBvbmx5IG9uZSAubWV0YWRhdGEuanNvbiBmaWxlIGlzIHByb2R1Y2VkIHRoYXQgY29udGFpbnMgYWxsIHRoZSBtZXRhZGF0YVxuICAvLyBuZWNlc3NhcnkgZm9yIHN5bWJvbHMgZXhwb3J0ZWQgZnJvbSB0aGUgbGlicmFyeSBpbmRleC5cbiAgLy8gSW4gdGhlIGdlbmVyYXRlZCAubmdmYWN0b3J5LnRzIGZpbGVzIGZsYXQgbW9kdWxlIGluZGV4IGlzIHVzZWQgdG8gaW1wb3J0IHN5bWJvbHNcbiAgLy8gaW5jbHVkZXMgYm90aCB0aGUgcHVibGljIEFQSSBmcm9tIHRoZSBsaWJyYXJ5IGluZGV4IGFzIHdlbGwgYXMgc2hyb3dkZWQgaW50ZXJuYWxcbiAgLy8gc3ltYm9scy5cbiAgLy8gQnkgZGVmYXVsdCB0aGUgLnRzIGZpbGUgc3VwcGxpZWQgaW4gdGhlIGBmaWxlc2AgZmlsZXMgZmllbGQgaXMgYXNzdW1lZCB0byBiZVxuICAvLyBsaWJyYXJ5IGluZGV4LiBJZiBtb3JlIHRoYW4gb25lIGlzIHNwZWNpZmllZCwgdXNlcyBgbGlicmFyeUluZGV4YCB0byBzZWxlY3QgdGhlXG4gIC8vIGZpbGUgdG8gdXNlLiBJZiBtb3JlIHRoYW4gb24gLnRzIGZpbGUgaXMgc3VwcGxpZWQgYW5kIG5vIGBsaWJyYXJ5SW5kZXhgIGlzIHN1cHBsaWVkXG4gIC8vIGFuIGVycm9yIGlzIHByb2R1Y2VkLlxuICAvLyBBIGZsYXQgbW9kdWxlIGluZGV4IC5kLnRzIGFuZCAuanMgd2lsbCBiZSBjcmVhdGVkIHdpdGggdGhlIGdpdmVuIGBmbGF0TW9kdWxlT3V0RmlsZWBcbiAgLy8gbmFtZSBpbiB0aGUgc2FtZSBsb2NhdGlvbiBhcyB0aGUgbGlicmFyeSBpbmRleCAuZC50cyBmaWxlIGlzIGVtaXR0ZWQuXG4gIC8vIEZvciBleGFtcGxlLCBpZiBhIGxpYnJhcnkgdXNlcyBgcHVibGljX2FwaS50c2AgZmlsZSBhcyB0aGUgbGlicmFyeSBpbmRleCBvZiB0aGVcbiAgLy8gbW9kdWxlIHRoZSBgdHNjb25maWcuanNvbmAgYGZpbGVzYCBmaWVsZCB3b3VsZCBiZSBgW1wicHVibGljX2FwaS50c1wiXWAuIFRoZVxuICAvLyBgZmxhdE1vZHVsZU91dEZpbGVgIG9wdGlvbnMgY291bGQgdGhlbiBiZSBzZXQgdG8sIGZvciBleGFtcGxlIGBcImluZGV4LmpzXCJgLCB3aGljaFxuICAvLyBwcm9kdWNlcyBgaW5kZXguZC50c2AgYW5kICBgaW5kZXgubWV0YWRhdGEuanNvbmAgZmlsZXMuIFRoZSBsaWJyYXJ5J3NcbiAgLy8gYHBhY2thZ2UuanNvbmAncyBgbW9kdWxlYCBmaWVsZCB3b3VsZCBiZSBgXCJpbmRleC5qc1wiYCBhbmQgdGhlIGB0eXBpbmdzYCBmaWVsZCB3b3VsZFxuICAvLyBiZSBgXCJpbmRleC5kLnRzXCJgLlxuICBmbGF0TW9kdWxlT3V0RmlsZT86IHN0cmluZztcblxuICAvLyBQcmVmZXJyZWQgbW9kdWxlIGlkIHRvIHVzZSBmb3IgaW1wb3J0aW5nIGZsYXQgbW9kdWxlLiBSZWZlcmVuY2VzIGdlbmVyYXRlZCBieSBgbmdjYFxuICAvLyB3aWxsIHVzZSB0aGlzIG1vZHVsZSBuYW1lIHdoZW4gaW1wb3J0aW5nIHN5bWJvbHMgZnJvbSB0aGUgZmxhdCBtb2R1bGUuIFRoaXMgaXMgb25seVxuICAvLyBtZWFuaW5nZnVsIHdoZW4gYGZsYXRNb2R1bGVPdXRGaWxlYCBpcyBhbHNvIHN1cHBsaWVkLiBJdCBpcyBvdGhlcndpc2UgaWdub3JlZC5cbiAgZmxhdE1vZHVsZUlkPzogc3RyaW5nO1xuXG4gIC8vIEEgcHJlZml4IHRvIGluc2VydCBpbiBnZW5lcmF0ZWQgcHJpdmF0ZSBzeW1ib2xzLCBlLmcuIGZvciBcIm15X3ByZWZpeF9cIiB3ZVxuICAvLyB3b3VsZCBnZW5lcmF0ZSBwcml2YXRlIHN5bWJvbHMgbmFtZWQgbGlrZSBgybVteV9wcmVmaXhfYWAuXG4gIGZsYXRNb2R1bGVQcml2YXRlU3ltYm9sUHJlZml4Pzogc3RyaW5nO1xuXG4gIC8vIFdoZXRoZXIgdG8gZ2VuZXJhdGUgY29kZSBmb3IgbGlicmFyeSBjb2RlLlxuICAvLyBJZiB0cnVlLCBwcm9kdWNlIC5uZ2ZhY3RvcnkudHMgYW5kIC5uZ3N0eWxlLnRzIGZpbGVzIGZvciAuZC50cyBpbnB1dHMuXG4gIC8vIERlZmF1bHQgaXMgdHJ1ZS5cbiAgZ2VuZXJhdGVDb2RlRm9yTGlicmFyaWVzPzogYm9vbGVhbjtcblxuICAvLyBXaGV0aGVyIHRvIGVuYWJsZSBhbGwgdHlwZSBjaGVja3MgZm9yIHRlbXBsYXRlcy5cbiAgLy8gVGhpcyB3aWxsIGJlIHRydWUgYmUgZGVmYXVsdCBpbiBBbmd1bGFyIDYuXG4gIGZ1bGxUZW1wbGF0ZVR5cGVDaGVjaz86IGJvb2xlYW47XG5cbiAgLy8gSW5zZXJ0IEpTRG9jIHR5cGUgYW5ub3RhdGlvbnMgbmVlZGVkIGJ5IENsb3N1cmUgQ29tcGlsZXJcbiAgYW5ub3RhdGVGb3JDbG9zdXJlQ29tcGlsZXI/OiBib29sZWFuO1xuXG4gIC8vIE1vZGlmeSBob3cgYW5ndWxhciBhbm5vdGF0aW9ucyBhcmUgZW1pdHRlZCB0byBpbXByb3ZlIHRyZWUtc2hha2luZy5cbiAgLy8gRGVmYXVsdCBpcyBzdGF0aWMgZmllbGRzLlxuICAvLyBkZWNvcmF0b3JzOiBMZWF2ZSB0aGUgRGVjb3JhdG9ycyBpbi1wbGFjZS4gVGhpcyBtYWtlcyBjb21waWxhdGlvbiBmYXN0ZXIuXG4gIC8vICAgICAgICAgICAgIFR5cGVTY3JpcHQgd2lsbCBlbWl0IGNhbGxzIHRvIHRoZSBfX2RlY29yYXRlIGhlbHBlci5cbiAgLy8gICAgICAgICAgICAgYC0tZW1pdERlY29yYXRvck1ldGFkYXRhYCBjYW4gYmUgdXNlZCBmb3IgcnVudGltZSByZWZsZWN0aW9uLlxuICAvLyAgICAgICAgICAgICBIb3dldmVyLCB0aGUgcmVzdWx0aW5nIGNvZGUgd2lsbCBub3QgcHJvcGVybHkgdHJlZS1zaGFrZS5cbiAgLy8gc3RhdGljIGZpZWxkczogUmVwbGFjZSBkZWNvcmF0b3JzIHdpdGggYSBzdGF0aWMgZmllbGQgaW4gdGhlIGNsYXNzLlxuICAvLyAgICAgICAgICAgICAgICBBbGxvd3MgYWR2YW5jZWQgdHJlZS1zaGFrZXJzIGxpa2UgQ2xvc3VyZSBDb21waWxlciB0byByZW1vdmVcbiAgLy8gICAgICAgICAgICAgICAgdW51c2VkIGNsYXNzZXMuXG4gIGFubm90YXRpb25zQXM/OiAnZGVjb3JhdG9ycyd8J3N0YXRpYyBmaWVsZHMnO1xuXG4gIC8vIFByaW50IGV4dHJhIGluZm9ybWF0aW9uIHdoaWxlIHJ1bm5pbmcgdGhlIGNvbXBpbGVyXG4gIHRyYWNlPzogYm9vbGVhbjtcblxuICAvLyBXaGV0aGVyIHRvIGVuYWJsZSBsb3dlcmluZyBleHByZXNzaW9ucyBsYW1iZGFzIGFuZCBleHByZXNzaW9ucyBpbiBhIHJlZmVyZW5jZSB2YWx1ZVxuICAvLyBwb3NpdGlvbi5cbiAgZGlzYWJsZUV4cHJlc3Npb25Mb3dlcmluZz86IGJvb2xlYW47XG5cbiAgLy8gRGlzYWJsZSBUeXBlU2NyaXB0IFZlcnNpb24gQ2hlY2suXG4gIGRpc2FibGVUeXBlU2NyaXB0VmVyc2lvbkNoZWNrPzogYm9vbGVhbjtcblxuICAvLyBMb2NhbGUgb2YgdGhlIGFwcGxpY2F0aW9uXG4gIGkxOG5PdXRMb2NhbGU/OiBzdHJpbmc7XG4gIC8vIEV4cG9ydCBmb3JtYXQgKHhsZiwgeGxmMiBvciB4bWIpXG4gIGkxOG5PdXRGb3JtYXQ/OiBzdHJpbmc7XG4gIC8vIFBhdGggdG8gdGhlIGV4dHJhY3RlZCBtZXNzYWdlIGZpbGVcbiAgaTE4bk91dEZpbGU/OiBzdHJpbmc7XG5cbiAgLy8gSW1wb3J0IGZvcm1hdCBpZiBkaWZmZXJlbnQgZnJvbSBgaTE4bkZvcm1hdGBcbiAgaTE4bkluRm9ybWF0Pzogc3RyaW5nO1xuICAvLyBMb2NhbGUgb2YgdGhlIGltcG9ydGVkIHRyYW5zbGF0aW9uc1xuICBpMThuSW5Mb2NhbGU/OiBzdHJpbmc7XG4gIC8vIFBhdGggdG8gdGhlIHRyYW5zbGF0aW9uIGZpbGVcbiAgaTE4bkluRmlsZT86IHN0cmluZztcbiAgLy8gSG93IHRvIGhhbmRsZSBtaXNzaW5nIG1lc3NhZ2VzXG4gIGkxOG5Jbk1pc3NpbmdUcmFuc2xhdGlvbnM/OiAnZXJyb3InfCd3YXJuaW5nJ3wnaWdub3JlJztcblxuICAvLyBXaGV0aGVyIHRvIHJlbW92ZSBibGFuayB0ZXh0IG5vZGVzIGZyb20gY29tcGlsZWQgdGVtcGxhdGVzLiBJdCBpcyBgZmFsc2VgIGJ5IGRlZmF1bHQgc3RhcnRpbmdcbiAgLy8gZnJvbSBBbmd1bGFyIDYuXG4gIHByZXNlcnZlV2hpdGVzcGFjZXM/OiBib29sZWFuO1xuXG4gIC8qKiBnZW5lcmF0ZSBhbGwgcG9zc2libGUgZ2VuZXJhdGVkIGZpbGVzICAqL1xuICBhbGxvd0VtcHR5Q29kZWdlbkZpbGVzPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogV2hldGhlciB0byBnZW5lcmF0ZSAubmdzdW1tYXJ5LnRzIGZpbGVzIHRoYXQgYWxsb3cgdG8gdXNlIEFPVGVkIGFydGlmYWN0c1xuICAgKiBpbiBKSVQgbW9kZS4gVGhpcyBpcyBvZmYgYnkgZGVmYXVsdC5cbiAgICovXG4gIGVuYWJsZVN1bW1hcmllc0ZvckppdD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgdG8gcmVwbGFjZSB0aGUgYHRlbXBsYXRlVXJsYCBhbmQgYHN0eWxlVXJsc2AgcHJvcGVydHkgaW4gYWxsXG4gICAqIEBDb21wb25lbnQgZGVjb3JhdG9ycyB3aXRoIGlubGluZWQgY29udGVudHMgaW4gYHRlbXBsYXRlYCBhbmQgYHN0eWxlc2BcbiAgICogcHJvcGVydGllcy5cbiAgICogV2hlbiBlbmFibGVkLCB0aGUgLmpzIG91dHB1dCBvZiBuZ2Mgd2lsbCBoYXZlIG5vIGxhenktbG9hZGVkIGB0ZW1wbGF0ZVVybGBcbiAgICogb3IgYHN0eWxlVXJsYHMuIE5vdGUgdGhhdCB0aGlzIHJlcXVpcmVzIHRoYXQgcmVzb3VyY2VzIGJlIGF2YWlsYWJsZSB0b1xuICAgKiBsb2FkIHN0YXRpY2FsbHkgYXQgY29tcGlsZS10aW1lLlxuICAgKi9cbiAgZW5hYmxlUmVzb3VyY2VJbmxpbmluZz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRlbGxzIHRoZSBjb21waWxlciB0byBnZW5lcmF0ZSBkZWZpbml0aW9ucyB1c2luZyB0aGUgUmVuZGVyMyBzdHlsZSBjb2RlIGdlbmVyYXRpb24uXG4gICAqIFRoaXMgb3B0aW9uIGRlZmF1bHRzIHRvIGBmYWxzZWAuXG4gICAqXG4gICAqIE5vdCBhbGwgZmVhdHVyZXMgYXJlIHN1cHBvcnRlZCB3aXRoIHRoaXMgb3B0aW9uIGVuYWJsZWQuIEl0IGlzIG9ubHkgc3VwcG9ydGVkXG4gICAqIGZvciBleHBlcmltZW50YXRpb24gYW5kIHRlc3Rpbmcgb2YgUmVuZGVyMyBzdHlsZSBjb2RlIGdlbmVyYXRpb24uXG4gICAqXG4gICAqIEBleHBlcmltZW50YWxcbiAgICovXG4gIGVuYWJsZUl2eT86IGJvb2xlYW47XG5cbiAgLyoqIEBpbnRlcm5hbCAqL1xuICBjb2xsZWN0QWxsRXJyb3JzPzogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBDb21waWxlckhvc3QgZXh0ZW5kcyB0cy5Db21waWxlckhvc3Qge1xuICAvKipcbiAgICogQ29udmVydHMgYSBtb2R1bGUgbmFtZSB0aGF0IGlzIHVzZWQgaW4gYW4gYGltcG9ydGAgdG8gYSBmaWxlIHBhdGguXG4gICAqIEkuZS4gYHBhdGgvdG8vY29udGFpbmluZ0ZpbGUudHNgIGNvbnRhaW5pbmcgYGltcG9ydCB7Li4ufSBmcm9tICdtb2R1bGUtbmFtZSdgLlxuICAgKi9cbiAgbW9kdWxlTmFtZVRvRmlsZU5hbWU/KG1vZHVsZU5hbWU6IHN0cmluZywgY29udGFpbmluZ0ZpbGU6IHN0cmluZyk6IHN0cmluZ3xudWxsO1xuICAvKipcbiAgICogQ29udmVydHMgYSBmaWxlIHBhdGggdG8gYSBtb2R1bGUgbmFtZSB0aGF0IGNhbiBiZSB1c2VkIGFzIGFuIGBpbXBvcnQgLi4uYFxuICAgKiBJLmUuIGBwYXRoL3RvL2ltcG9ydGVkRmlsZS50c2Agc2hvdWxkIGJlIGltcG9ydGVkIGJ5IGBwYXRoL3RvL2NvbnRhaW5pbmdGaWxlLnRzYC5cbiAgICovXG4gIGZpbGVOYW1lVG9Nb2R1bGVOYW1lPyhpbXBvcnRlZEZpbGVQYXRoOiBzdHJpbmcsIGNvbnRhaW5pbmdGaWxlUGF0aDogc3RyaW5nKTogc3RyaW5nO1xuICAvKipcbiAgICogQ29udmVydHMgYSBmaWxlIHBhdGggZm9yIGEgcmVzb3VyY2UgdGhhdCBpcyB1c2VkIGluIGEgc291cmNlIGZpbGUgb3IgYW5vdGhlciByZXNvdXJjZVxuICAgKiBpbnRvIGEgZmlsZXBhdGguXG4gICAqL1xuICByZXNvdXJjZU5hbWVUb0ZpbGVOYW1lPyhyZXNvdXJjZU5hbWU6IHN0cmluZywgY29udGFpbmluZ0ZpbGVQYXRoOiBzdHJpbmcpOiBzdHJpbmd8bnVsbDtcbiAgLyoqXG4gICAqIENvbnZlcnRzIGEgZmlsZSBuYW1lIGludG8gYSByZXByZXNlbnRhdGlvbiB0aGF0IHNob3VsZCBiZSBzdG9yZWQgaW4gYSBzdW1tYXJ5IGZpbGUuXG4gICAqIFRoaXMgaGFzIHRvIGluY2x1ZGUgY2hhbmdpbmcgdGhlIHN1ZmZpeCBhcyB3ZWxsLlxuICAgKiBFLmcuXG4gICAqIGBzb21lX2ZpbGUudHNgIC0+IGBzb21lX2ZpbGUuZC50c2BcbiAgICpcbiAgICogQHBhcmFtIHJlZmVycmluZ1NyY0ZpbGVOYW1lIHRoZSBzb3VyZSBmaWxlIHRoYXQgcmVmZXJzIHRvIGZpbGVOYW1lXG4gICAqL1xuICB0b1N1bW1hcnlGaWxlTmFtZT8oZmlsZU5hbWU6IHN0cmluZywgcmVmZXJyaW5nU3JjRmlsZU5hbWU6IHN0cmluZyk6IHN0cmluZztcbiAgLyoqXG4gICAqIENvbnZlcnRzIGEgZmlsZU5hbWUgdGhhdCB3YXMgcHJvY2Vzc2VkIGJ5IGB0b1N1bW1hcnlGaWxlTmFtZWAgYmFjayBpbnRvIGEgcmVhbCBmaWxlTmFtZVxuICAgKiBnaXZlbiB0aGUgZmlsZU5hbWUgb2YgdGhlIGxpYnJhcnkgdGhhdCBpcyByZWZlcnJpZyB0byBpdC5cbiAgICovXG4gIGZyb21TdW1tYXJ5RmlsZU5hbWU/KGZpbGVOYW1lOiBzdHJpbmcsIHJlZmVycmluZ0xpYkZpbGVOYW1lOiBzdHJpbmcpOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBMb2FkIGEgcmVmZXJlbmNlZCByZXNvdXJjZSBlaXRoZXIgc3RhdGljYWxseSBvciBhc3luY2hyb25vdXNseS4gSWYgdGhlIGhvc3QgcmV0dXJucyBhXG4gICAqIGBQcm9taXNlPHN0cmluZz5gIGl0IGlzIGFzc3VtZWQgdGhlIHVzZXIgb2YgdGhlIGNvcnJlc3BvbmRpbmcgYFByb2dyYW1gIHdpbGwgY2FsbFxuICAgKiBgbG9hZE5nU3RydWN0dXJlQXN5bmMoKWAuIFJldHVybmluZyAgYFByb21pc2U8c3RyaW5nPmAgb3V0c2lkZSBgbG9hZE5nU3RydWN0dXJlQXN5bmMoKWAgd2lsbFxuICAgKiBjYXVzZSBhIGRpYWdub3N0aWNzIGRpYWdub3N0aWMgZXJyb3Igb3IgYW4gZXhjZXB0aW9uIHRvIGJlIHRocm93bi5cbiAgICovXG4gIHJlYWRSZXNvdXJjZT8oZmlsZU5hbWU6IHN0cmluZyk6IFByb21pc2U8c3RyaW5nPnxzdHJpbmc7XG4gIC8qKlxuICAgKiBQcm9kdWNlIGFuIEFNRCBtb2R1bGUgbmFtZSBmb3IgdGhlIHNvdXJjZSBmaWxlLiBVc2VkIGluIEJhemVsLlxuICAgKlxuICAgKiBBbiBBTUQgbW9kdWxlIGNhbiBoYXZlIGFuIGFyYml0cmFyeSBuYW1lLCBzbyB0aGF0IGl0IGlzIHJlcXVpcmUnZCBieSBuYW1lXG4gICAqIHJhdGhlciB0aGFuIGJ5IHBhdGguIFNlZSBodHRwOi8vcmVxdWlyZWpzLm9yZy9kb2NzL3doeWFtZC5odG1sI25hbWVkbW9kdWxlc1xuICAgKi9cbiAgYW1kTW9kdWxlTmFtZT8oc2Y6IHRzLlNvdXJjZUZpbGUpOiBzdHJpbmd8dW5kZWZpbmVkO1xufVxuXG5leHBvcnQgZW51bSBFbWl0RmxhZ3Mge1xuICBEVFMgPSAxIDw8IDAsXG4gIEpTID0gMSA8PCAxLFxuICBNZXRhZGF0YSA9IDEgPDwgMixcbiAgSTE4bkJ1bmRsZSA9IDEgPDwgMyxcbiAgQ29kZWdlbiA9IDEgPDwgNCxcblxuICBEZWZhdWx0ID0gRFRTIHwgSlMgfCBDb2RlZ2VuLFxuICBBbGwgPSBEVFMgfCBKUyB8IE1ldGFkYXRhIHwgSTE4bkJ1bmRsZSB8IENvZGVnZW4sXG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ3VzdG9tVHJhbnNmb3JtZXJzIHtcbiAgYmVmb3JlVHM/OiB0cy5UcmFuc2Zvcm1lckZhY3Rvcnk8dHMuU291cmNlRmlsZT5bXTtcbiAgYWZ0ZXJUcz86IHRzLlRyYW5zZm9ybWVyRmFjdG9yeTx0cy5Tb3VyY2VGaWxlPltdO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFRzRW1pdEFyZ3VtZW50cyB7XG4gIHByb2dyYW06IHRzLlByb2dyYW07XG4gIGhvc3Q6IENvbXBpbGVySG9zdDtcbiAgb3B0aW9uczogQ29tcGlsZXJPcHRpb25zO1xuICB0YXJnZXRTb3VyY2VGaWxlPzogdHMuU291cmNlRmlsZTtcbiAgd3JpdGVGaWxlPzogdHMuV3JpdGVGaWxlQ2FsbGJhY2s7XG4gIGNhbmNlbGxhdGlvblRva2VuPzogdHMuQ2FuY2VsbGF0aW9uVG9rZW47XG4gIGVtaXRPbmx5RHRzRmlsZXM/OiBib29sZWFuO1xuICBjdXN0b21UcmFuc2Zvcm1lcnM/OiB0cy5DdXN0b21UcmFuc2Zvcm1lcnM7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgVHNFbWl0Q2FsbGJhY2sgeyAoYXJnczogVHNFbWl0QXJndW1lbnRzKTogdHMuRW1pdFJlc3VsdDsgfVxuZXhwb3J0IGludGVyZmFjZSBUc01lcmdlRW1pdFJlc3VsdHNDYWxsYmFjayB7IChyZXN1bHRzOiB0cy5FbWl0UmVzdWx0W10pOiB0cy5FbWl0UmVzdWx0OyB9XG5cbmV4cG9ydCBpbnRlcmZhY2UgTGlicmFyeVN1bW1hcnkge1xuICBmaWxlTmFtZTogc3RyaW5nO1xuICB0ZXh0OiBzdHJpbmc7XG4gIHNvdXJjZUZpbGU/OiB0cy5Tb3VyY2VGaWxlO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIExhenlSb3V0ZSB7XG4gIHJvdXRlOiBzdHJpbmc7XG4gIG1vZHVsZToge25hbWU6IHN0cmluZywgZmlsZVBhdGg6IHN0cmluZ307XG4gIHJlZmVyZW5jZWRNb2R1bGU6IHtuYW1lOiBzdHJpbmcsIGZpbGVQYXRoOiBzdHJpbmd9O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFByb2dyYW0ge1xuICAvKipcbiAgICogUmV0cmlldmUgdGhlIFR5cGVTY3JpcHQgcHJvZ3JhbSB1c2VkIHRvIHByb2R1Y2Ugc2VtYW50aWMgZGlhZ25vc3RpY3MgYW5kIGVtaXQgdGhlIHNvdXJjZXMuXG4gICAqXG4gICAqIEFuZ3VsYXIgc3RydWN0dXJhbCBpbmZvcm1hdGlvbiBpcyByZXF1aXJlZCB0byBwcm9kdWNlIHRoZSBwcm9ncmFtLlxuICAgKi9cbiAgZ2V0VHNQcm9ncmFtKCk6IHRzLlByb2dyYW07XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlIG9wdGlvbnMgZGlhZ25vc3RpY3MgZm9yIHRoZSBUeXBlU2NyaXB0IG9wdGlvbnMgdXNlZCB0byBjcmVhdGUgdGhlIHByb2dyYW0uIFRoaXMgaXNcbiAgICogZmFzdGVyIHRoYW4gY2FsbGluZyBgZ2V0VHNQcm9ncmFtKCkuZ2V0T3B0aW9uc0RpYWdub3N0aWNzKClgIHNpbmNlIGl0IGRvZXMgbm90IG5lZWQgdG9cbiAgICogY29sbGVjdCBBbmd1bGFyIHN0cnVjdHVyYWwgaW5mb3JtYXRpb24gdG8gcHJvZHVjZSB0aGUgZXJyb3JzLlxuICAgKi9cbiAgZ2V0VHNPcHRpb25EaWFnbm9zdGljcyhjYW5jZWxsYXRpb25Ub2tlbj86IHRzLkNhbmNlbGxhdGlvblRva2VuKTogUmVhZG9ubHlBcnJheTx0cy5EaWFnbm9zdGljPjtcblxuICAvKipcbiAgICogUmV0cmlldmUgb3B0aW9ucyBkaWFnbm9zdGljcyBmb3IgdGhlIEFuZ3VsYXIgb3B0aW9ucyB1c2VkIHRvIGNyZWF0ZSB0aGUgcHJvZ3JhbS5cbiAgICovXG4gIGdldE5nT3B0aW9uRGlhZ25vc3RpY3MoY2FuY2VsbGF0aW9uVG9rZW4/OiB0cy5DYW5jZWxsYXRpb25Ub2tlbik6IFJlYWRvbmx5QXJyYXk8RGlhZ25vc3RpYz47XG5cbiAgLyoqXG4gICAqIFJldHJpZXZlIHRoZSBzeW50YXggZGlhZ25vc3RpY3MgZnJvbSBUeXBlU2NyaXB0LiBUaGlzIGlzIGZhc3RlciB0aGFuIGNhbGxpbmdcbiAgICogYGdldFRzUHJvZ3JhbSgpLmdldFN5bnRhY3RpY0RpYWdub3N0aWNzKClgIHNpbmNlIGl0IGRvZXMgbm90IG5lZWQgdG8gY29sbGVjdCBBbmd1bGFyIHN0cnVjdHVyYWxcbiAgICogaW5mb3JtYXRpb24gdG8gcHJvZHVjZSB0aGUgZXJyb3JzLlxuICAgKi9cbiAgZ2V0VHNTeW50YWN0aWNEaWFnbm9zdGljcyhzb3VyY2VGaWxlPzogdHMuU291cmNlRmlsZSwgY2FuY2VsbGF0aW9uVG9rZW4/OiB0cy5DYW5jZWxsYXRpb25Ub2tlbik6XG4gICAgICBSZWFkb25seUFycmF5PHRzLkRpYWdub3N0aWM+O1xuXG4gIC8qKlxuICAgKiBSZXRyaWV2ZSB0aGUgZGlhZ25vc3RpY3MgZm9yIHRoZSBzdHJ1Y3R1cmUgb2YgYW4gQW5ndWxhciBhcHBsaWNhdGlvbiBpcyBjb3JyZWN0bHkgZm9ybWVkLlxuICAgKiBUaGlzIGluY2x1ZGVzIHZhbGlkYXRpbmcgQW5ndWxhciBhbm5vdGF0aW9ucyBhbmQgdGhlIHN5bnRheCBvZiByZWZlcmVuY2VkIGFuZCBpbWJlZGRlZCBIVE1MXG4gICAqIGFuZCBDU1MuXG4gICAqXG4gICAqIE5vdGUgaXQgaXMgaW1wb3J0YW50IHRvIGRpc3BsYXlpbmcgVHlwZVNjcmlwdCBzZW1hbnRpYyBkaWFnbm9zdGljcyBhbG9uZyB3aXRoIEFuZ3VsYXJcbiAgICogc3RydWN0dXJhbCBkaWFnbm9zdGljcyBhcyBhbiBlcnJvciBpbiB0aGUgcHJvZ3JhbSBzdHJ1Y3R1cmUgbWlnaHQgY2F1c2UgZXJyb3JzIGRldGVjdGVkIGluXG4gICAqIHNlbWFudGljIGFuYWx5c2lzIGFuZCBhIHNlbWFudGljIGVycm9yIG1pZ2h0IGNhdXNlIGVycm9ycyBpbiBzcGVjaWZ5aW5nIHRoZSBwcm9ncmFtIHN0cnVjdHVyZS5cbiAgICpcbiAgICogQW5ndWxhciBzdHJ1Y3R1cmFsIGluZm9ybWF0aW9uIGlzIHJlcXVpcmVkIHRvIHByb2R1Y2UgdGhlc2UgZGlhZ25vc3RpY3MuXG4gICAqL1xuICBnZXROZ1N0cnVjdHVyYWxEaWFnbm9zdGljcyhjYW5jZWxsYXRpb25Ub2tlbj86IHRzLkNhbmNlbGxhdGlvblRva2VuKTogUmVhZG9ubHlBcnJheTxEaWFnbm9zdGljPjtcblxuICAvKipcbiAgICogUmV0cmlldmUgdGhlIHNlbWFudGljIGRpYWdub3N0aWNzIGZyb20gVHlwZVNjcmlwdC4gVGhpcyBpcyBlcXVpdmFsZW50IHRvIGNhbGxpbmdcbiAgICogYGdldFRzUHJvZ3JhbSgpLmdldFNlbWFudGljRGlhZ25vc3RpY3MoKWAgZGlyZWN0bHkgYW5kIGlzIGluY2x1ZGVkIGZvciBjb21wbGV0ZW5lc3MuXG4gICAqL1xuICBnZXRUc1NlbWFudGljRGlhZ25vc3RpY3Moc291cmNlRmlsZT86IHRzLlNvdXJjZUZpbGUsIGNhbmNlbGxhdGlvblRva2VuPzogdHMuQ2FuY2VsbGF0aW9uVG9rZW4pOlxuICAgICAgUmVhZG9ubHlBcnJheTx0cy5EaWFnbm9zdGljPjtcblxuICAvKipcbiAgICogUmV0cmlldmUgdGhlIEFuZ3VsYXIgc2VtYW50aWMgZGlhZ25vc3RpY3MuXG4gICAqXG4gICAqIEFuZ3VsYXIgc3RydWN0dXJhbCBpbmZvcm1hdGlvbiBpcyByZXF1aXJlZCB0byBwcm9kdWNlIHRoZXNlIGRpYWdub3N0aWNzLlxuICAgKi9cbiAgZ2V0TmdTZW1hbnRpY0RpYWdub3N0aWNzKGZpbGVOYW1lPzogc3RyaW5nLCBjYW5jZWxsYXRpb25Ub2tlbj86IHRzLkNhbmNlbGxhdGlvblRva2VuKTpcbiAgICAgIFJlYWRvbmx5QXJyYXk8RGlhZ25vc3RpYz47XG5cbiAgLyoqXG4gICAqIExvYWQgQW5ndWxhciBzdHJ1Y3R1cmFsIGluZm9ybWF0aW9uIGFzeW5jaHJvbm91c2x5LiBJZiB0aGlzIG1ldGhvZCBpcyBub3QgY2FsbGVkIHRoZW4gdGhlXG4gICAqIEFuZ3VsYXIgc3RydWN0dXJhbCBpbmZvcm1hdGlvbiwgaW5jbHVkaW5nIHJlZmVyZW5jZWQgSFRNTCBhbmQgQ1NTIGZpbGVzLCBhcmUgbG9hZGVkXG4gICAqIHN5bmNocm9ub3VzbHkuIElmIHRoZSBzdXBwbGllZCBBbmd1bGFyIGNvbXBpbGVyIGhvc3QgcmV0dXJucyBhIHByb21pc2UgZnJvbSBgbG9hZFJlc291cmNlKClgXG4gICAqIHdpbGwgcHJvZHVjZSBhIGRpYWdub3N0aWMgZXJyb3IgbWVzc2FnZSBvciwgYGdldFRzUHJvZ3JhbSgpYCBvciBgZW1pdGAgdG8gdGhyb3cuXG4gICAqL1xuICBsb2FkTmdTdHJ1Y3R1cmVBc3luYygpOiBQcm9taXNlPHZvaWQ+O1xuXG4gIC8qKlxuICAgKiBSZXR1cm5zIHRoZSBsYXp5IHJvdXRlcyBpbiB0aGUgcHJvZ3JhbS5cbiAgICogQHBhcmFtIGVudHJ5Um91dGUgQSByZWZlcmVuY2UgdG8gYW4gTmdNb2R1bGUgbGlrZSBgc29tZU1vZHVsZSNuYW1lYC4gSWYgZ2l2ZW4sXG4gICAqICAgICAgICAgICAgICB3aWxsIHJlY3Vyc2l2ZWx5IGFuYWx5emUgcm91dGVzIHN0YXJ0aW5nIGZyb20gdGhpcyBzeW1ib2wgb25seS5cbiAgICogICAgICAgICAgICAgIE90aGVyd2lzZSB3aWxsIGxpc3QgYWxsIHJvdXRlcyBmb3IgYWxsIE5nTW9kdWxlcyBpbiB0aGUgcHJvZ3JhbS9cbiAgICovXG4gIGxpc3RMYXp5Um91dGVzKGVudHJ5Um91dGU/OiBzdHJpbmcpOiBMYXp5Um91dGVbXTtcblxuICAvKipcbiAgICogRW1pdCB0aGUgZmlsZXMgcmVxdWVzdGVkIGJ5IGVtaXRGbGFncyBpbXBsaWVkIGJ5IHRoZSBwcm9ncmFtLlxuICAgKlxuICAgKiBBbmd1bGFyIHN0cnVjdHVyYWwgaW5mb3JtYXRpb24gaXMgcmVxdWlyZWQgdG8gZW1pdCBmaWxlcy5cbiAgICovXG4gIGVtaXQoe2VtaXRGbGFncywgY2FuY2VsbGF0aW9uVG9rZW4sIGN1c3RvbVRyYW5zZm9ybWVycywgZW1pdENhbGxiYWNrLFxuICAgICAgICBtZXJnZUVtaXRSZXN1bHRzQ2FsbGJhY2t9Pzoge1xuICAgIGVtaXRGbGFncz86IEVtaXRGbGFncyxcbiAgICBjYW5jZWxsYXRpb25Ub2tlbj86IHRzLkNhbmNlbGxhdGlvblRva2VuLFxuICAgIGN1c3RvbVRyYW5zZm9ybWVycz86IEN1c3RvbVRyYW5zZm9ybWVycyxcbiAgICBlbWl0Q2FsbGJhY2s/OiBUc0VtaXRDYWxsYmFjayxcbiAgICBtZXJnZUVtaXRSZXN1bHRzQ2FsbGJhY2s/OiBUc01lcmdlRW1pdFJlc3VsdHNDYWxsYmFja1xuICB9KTogdHMuRW1pdFJlc3VsdDtcblxuICAvKipcbiAgICogUmV0dXJucyB0aGUgLmQudHMgLyAubmdzdW1tYXJ5Lmpzb24gLyAubmdmYWN0b3J5LmQudHMgZmlsZXMgb2YgbGlicmFyaWVzIHRoYXQgaGF2ZSBiZWVuIGVtaXR0ZWRcbiAgICogaW4gdGhpcyBwcm9ncmFtIG9yIHByZXZpb3VzIHByb2dyYW1zIHdpdGggcGF0aHMgdGhhdCBlbXVsYXRlIHRoZSBmYWN0IHRoYXQgdGhlc2UgbGlicmFyaWVzXG4gICAqIGhhdmUgYmVlbiBjb21waWxlZCBiZWZvcmUgd2l0aCBubyBvdXREaXIuXG4gICAqL1xuICBnZXRMaWJyYXJ5U3VtbWFyaWVzKCk6IE1hcDxzdHJpbmcsIExpYnJhcnlTdW1tYXJ5PjtcblxuICAvKipcbiAgICogQGludGVybmFsXG4gICAqL1xuICBnZXRFbWl0dGVkR2VuZXJhdGVkRmlsZXMoKTogTWFwPHN0cmluZywgR2VuZXJhdGVkRmlsZT47XG5cbiAgLyoqXG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgZ2V0RW1pdHRlZFNvdXJjZUZpbGVzKCk6IE1hcDxzdHJpbmcsIHRzLlNvdXJjZUZpbGU+O1xufVxuIl19