/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler/src/chars", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isQuote = exports.isOctalDigit = exports.isNewLine = exports.isAsciiHexDigit = exports.isAsciiLetter = exports.isDigit = exports.isWhitespace = exports.$BT = exports.$AT = exports.$TILDA = exports.$PIPE = exports.$NBSP = exports.$RBRACE = exports.$BAR = exports.$LBRACE = exports.$z = exports.$x = exports.$v = exports.$u = exports.$t = exports.$r = exports.$n = exports.$f = exports.$e = exports.$b = exports.$a = exports.$_ = exports.$CARET = exports.$RBRACKET = exports.$BACKSLASH = exports.$LBRACKET = exports.$Z = exports.$X = exports.$F = exports.$E = exports.$A = exports.$9 = exports.$7 = exports.$0 = exports.$QUESTION = exports.$GT = exports.$EQ = exports.$LT = exports.$SEMICOLON = exports.$COLON = exports.$SLASH = exports.$PERIOD = exports.$MINUS = exports.$COMMA = exports.$PLUS = exports.$STAR = exports.$RPAREN = exports.$LPAREN = exports.$SQ = exports.$AMPERSAND = exports.$PERCENT = exports.$$ = exports.$HASH = exports.$DQ = exports.$BANG = exports.$SPACE = exports.$CR = exports.$FF = exports.$VTAB = exports.$LF = exports.$TAB = exports.$BSPACE = exports.$EOF = void 0;
    exports.$EOF = 0;
    exports.$BSPACE = 8;
    exports.$TAB = 9;
    exports.$LF = 10;
    exports.$VTAB = 11;
    exports.$FF = 12;
    exports.$CR = 13;
    exports.$SPACE = 32;
    exports.$BANG = 33;
    exports.$DQ = 34;
    exports.$HASH = 35;
    exports.$$ = 36;
    exports.$PERCENT = 37;
    exports.$AMPERSAND = 38;
    exports.$SQ = 39;
    exports.$LPAREN = 40;
    exports.$RPAREN = 41;
    exports.$STAR = 42;
    exports.$PLUS = 43;
    exports.$COMMA = 44;
    exports.$MINUS = 45;
    exports.$PERIOD = 46;
    exports.$SLASH = 47;
    exports.$COLON = 58;
    exports.$SEMICOLON = 59;
    exports.$LT = 60;
    exports.$EQ = 61;
    exports.$GT = 62;
    exports.$QUESTION = 63;
    exports.$0 = 48;
    exports.$7 = 55;
    exports.$9 = 57;
    exports.$A = 65;
    exports.$E = 69;
    exports.$F = 70;
    exports.$X = 88;
    exports.$Z = 90;
    exports.$LBRACKET = 91;
    exports.$BACKSLASH = 92;
    exports.$RBRACKET = 93;
    exports.$CARET = 94;
    exports.$_ = 95;
    exports.$a = 97;
    exports.$b = 98;
    exports.$e = 101;
    exports.$f = 102;
    exports.$n = 110;
    exports.$r = 114;
    exports.$t = 116;
    exports.$u = 117;
    exports.$v = 118;
    exports.$x = 120;
    exports.$z = 122;
    exports.$LBRACE = 123;
    exports.$BAR = 124;
    exports.$RBRACE = 125;
    exports.$NBSP = 160;
    exports.$PIPE = 124;
    exports.$TILDA = 126;
    exports.$AT = 64;
    exports.$BT = 96;
    function isWhitespace(code) {
        return (code >= exports.$TAB && code <= exports.$SPACE) || (code == exports.$NBSP);
    }
    exports.isWhitespace = isWhitespace;
    function isDigit(code) {
        return exports.$0 <= code && code <= exports.$9;
    }
    exports.isDigit = isDigit;
    function isAsciiLetter(code) {
        return code >= exports.$a && code <= exports.$z || code >= exports.$A && code <= exports.$Z;
    }
    exports.isAsciiLetter = isAsciiLetter;
    function isAsciiHexDigit(code) {
        return code >= exports.$a && code <= exports.$f || code >= exports.$A && code <= exports.$F || isDigit(code);
    }
    exports.isAsciiHexDigit = isAsciiHexDigit;
    function isNewLine(code) {
        return code === exports.$LF || code === exports.$CR;
    }
    exports.isNewLine = isNewLine;
    function isOctalDigit(code) {
        return exports.$0 <= code && code <= exports.$7;
    }
    exports.isOctalDigit = isOctalDigit;
    function isQuote(code) {
        return code === exports.$SQ || code === exports.$DQ || code === exports.$BT;
    }
    exports.isQuote = isQuote;
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hhcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9wYWNrYWdlcy9jb21waWxlci9zcmMvY2hhcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HOzs7Ozs7Ozs7Ozs7O0lBRVUsUUFBQSxJQUFJLEdBQUcsQ0FBQyxDQUFDO0lBQ1QsUUFBQSxPQUFPLEdBQUcsQ0FBQyxDQUFDO0lBQ1osUUFBQSxJQUFJLEdBQUcsQ0FBQyxDQUFDO0lBQ1QsUUFBQSxHQUFHLEdBQUcsRUFBRSxDQUFDO0lBQ1QsUUFBQSxLQUFLLEdBQUcsRUFBRSxDQUFDO0lBQ1gsUUFBQSxHQUFHLEdBQUcsRUFBRSxDQUFDO0lBQ1QsUUFBQSxHQUFHLEdBQUcsRUFBRSxDQUFDO0lBQ1QsUUFBQSxNQUFNLEdBQUcsRUFBRSxDQUFDO0lBQ1osUUFBQSxLQUFLLEdBQUcsRUFBRSxDQUFDO0lBQ1gsUUFBQSxHQUFHLEdBQUcsRUFBRSxDQUFDO0lBQ1QsUUFBQSxLQUFLLEdBQUcsRUFBRSxDQUFDO0lBQ1gsUUFBQSxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBQ1IsUUFBQSxRQUFRLEdBQUcsRUFBRSxDQUFDO0lBQ2QsUUFBQSxVQUFVLEdBQUcsRUFBRSxDQUFDO0lBQ2hCLFFBQUEsR0FBRyxHQUFHLEVBQUUsQ0FBQztJQUNULFFBQUEsT0FBTyxHQUFHLEVBQUUsQ0FBQztJQUNiLFFBQUEsT0FBTyxHQUFHLEVBQUUsQ0FBQztJQUNiLFFBQUEsS0FBSyxHQUFHLEVBQUUsQ0FBQztJQUNYLFFBQUEsS0FBSyxHQUFHLEVBQUUsQ0FBQztJQUNYLFFBQUEsTUFBTSxHQUFHLEVBQUUsQ0FBQztJQUNaLFFBQUEsTUFBTSxHQUFHLEVBQUUsQ0FBQztJQUNaLFFBQUEsT0FBTyxHQUFHLEVBQUUsQ0FBQztJQUNiLFFBQUEsTUFBTSxHQUFHLEVBQUUsQ0FBQztJQUNaLFFBQUEsTUFBTSxHQUFHLEVBQUUsQ0FBQztJQUNaLFFBQUEsVUFBVSxHQUFHLEVBQUUsQ0FBQztJQUNoQixRQUFBLEdBQUcsR0FBRyxFQUFFLENBQUM7SUFDVCxRQUFBLEdBQUcsR0FBRyxFQUFFLENBQUM7SUFDVCxRQUFBLEdBQUcsR0FBRyxFQUFFLENBQUM7SUFDVCxRQUFBLFNBQVMsR0FBRyxFQUFFLENBQUM7SUFFZixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFDUixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFDUixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFFUixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFDUixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFDUixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFDUixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFDUixRQUFBLEVBQUUsR0FBRyxFQUFFLENBQUM7SUFFUixRQUFBLFNBQVMsR0FBRyxFQUFFLENBQUM7SUFDZixRQUFBLFVBQVUsR0FBRyxFQUFFLENBQUM7SUFDaEIsUUFBQSxTQUFTLEdBQUcsRUFBRSxDQUFDO0lBQ2YsUUFBQSxNQUFNLEdBQUcsRUFBRSxDQUFDO0lBQ1osUUFBQSxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBRVIsUUFBQSxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBQ1IsUUFBQSxFQUFFLEdBQUcsRUFBRSxDQUFDO0lBQ1IsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBQ1QsUUFBQSxFQUFFLEdBQUcsR0FBRyxDQUFDO0lBRVQsUUFBQSxPQUFPLEdBQUcsR0FBRyxDQUFDO0lBQ2QsUUFBQSxJQUFJLEdBQUcsR0FBRyxDQUFDO0lBQ1gsUUFBQSxPQUFPLEdBQUcsR0FBRyxDQUFDO0lBQ2QsUUFBQSxLQUFLLEdBQUcsR0FBRyxDQUFDO0lBRVosUUFBQSxLQUFLLEdBQUcsR0FBRyxDQUFDO0lBQ1osUUFBQSxNQUFNLEdBQUcsR0FBRyxDQUFDO0lBQ2IsUUFBQSxHQUFHLEdBQUcsRUFBRSxDQUFDO0lBRVQsUUFBQSxHQUFHLEdBQUcsRUFBRSxDQUFDO0lBRXRCLFNBQWdCLFlBQVksQ0FBQyxJQUFZO1FBQ3ZDLE9BQU8sQ0FBQyxJQUFJLElBQUksWUFBSSxJQUFJLElBQUksSUFBSSxjQUFNLENBQUMsSUFBSSxDQUFDLElBQUksSUFBSSxhQUFLLENBQUMsQ0FBQztJQUM3RCxDQUFDO0lBRkQsb0NBRUM7SUFFRCxTQUFnQixPQUFPLENBQUMsSUFBWTtRQUNsQyxPQUFPLFVBQUUsSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLFVBQUUsQ0FBQztJQUNsQyxDQUFDO0lBRkQsMEJBRUM7SUFFRCxTQUFnQixhQUFhLENBQUMsSUFBWTtRQUN4QyxPQUFPLElBQUksSUFBSSxVQUFFLElBQUksSUFBSSxJQUFJLFVBQUUsSUFBSSxJQUFJLElBQUksVUFBRSxJQUFJLElBQUksSUFBSSxVQUFFLENBQUM7SUFDOUQsQ0FBQztJQUZELHNDQUVDO0lBRUQsU0FBZ0IsZUFBZSxDQUFDLElBQVk7UUFDMUMsT0FBTyxJQUFJLElBQUksVUFBRSxJQUFJLElBQUksSUFBSSxVQUFFLElBQUksSUFBSSxJQUFJLFVBQUUsSUFBSSxJQUFJLElBQUksVUFBRSxJQUFJLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztJQUMvRSxDQUFDO0lBRkQsMENBRUM7SUFFRCxTQUFnQixTQUFTLENBQUMsSUFBWTtRQUNwQyxPQUFPLElBQUksS0FBSyxXQUFHLElBQUksSUFBSSxLQUFLLFdBQUcsQ0FBQztJQUN0QyxDQUFDO0lBRkQsOEJBRUM7SUFFRCxTQUFnQixZQUFZLENBQUMsSUFBWTtRQUN2QyxPQUFPLFVBQUUsSUFBSSxJQUFJLElBQUksSUFBSSxJQUFJLFVBQUUsQ0FBQztJQUNsQyxDQUFDO0lBRkQsb0NBRUM7SUFFRCxTQUFnQixPQUFPLENBQUMsSUFBWTtRQUNsQyxPQUFPLElBQUksS0FBSyxXQUFHLElBQUksSUFBSSxLQUFLLFdBQUcsSUFBSSxJQUFJLEtBQUssV0FBRyxDQUFDO0lBQ3RELENBQUM7SUFGRCwwQkFFQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQGxpY2Vuc2VcbiAqIENvcHlyaWdodCBHb29nbGUgTExDIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogVXNlIG9mIHRoaXMgc291cmNlIGNvZGUgaXMgZ292ZXJuZWQgYnkgYW4gTUlULXN0eWxlIGxpY2Vuc2UgdGhhdCBjYW4gYmVcbiAqIGZvdW5kIGluIHRoZSBMSUNFTlNFIGZpbGUgYXQgaHR0cHM6Ly9hbmd1bGFyLmlvL2xpY2Vuc2VcbiAqL1xuXG5leHBvcnQgY29uc3QgJEVPRiA9IDA7XG5leHBvcnQgY29uc3QgJEJTUEFDRSA9IDg7XG5leHBvcnQgY29uc3QgJFRBQiA9IDk7XG5leHBvcnQgY29uc3QgJExGID0gMTA7XG5leHBvcnQgY29uc3QgJFZUQUIgPSAxMTtcbmV4cG9ydCBjb25zdCAkRkYgPSAxMjtcbmV4cG9ydCBjb25zdCAkQ1IgPSAxMztcbmV4cG9ydCBjb25zdCAkU1BBQ0UgPSAzMjtcbmV4cG9ydCBjb25zdCAkQkFORyA9IDMzO1xuZXhwb3J0IGNvbnN0ICREUSA9IDM0O1xuZXhwb3J0IGNvbnN0ICRIQVNIID0gMzU7XG5leHBvcnQgY29uc3QgJCQgPSAzNjtcbmV4cG9ydCBjb25zdCAkUEVSQ0VOVCA9IDM3O1xuZXhwb3J0IGNvbnN0ICRBTVBFUlNBTkQgPSAzODtcbmV4cG9ydCBjb25zdCAkU1EgPSAzOTtcbmV4cG9ydCBjb25zdCAkTFBBUkVOID0gNDA7XG5leHBvcnQgY29uc3QgJFJQQVJFTiA9IDQxO1xuZXhwb3J0IGNvbnN0ICRTVEFSID0gNDI7XG5leHBvcnQgY29uc3QgJFBMVVMgPSA0MztcbmV4cG9ydCBjb25zdCAkQ09NTUEgPSA0NDtcbmV4cG9ydCBjb25zdCAkTUlOVVMgPSA0NTtcbmV4cG9ydCBjb25zdCAkUEVSSU9EID0gNDY7XG5leHBvcnQgY29uc3QgJFNMQVNIID0gNDc7XG5leHBvcnQgY29uc3QgJENPTE9OID0gNTg7XG5leHBvcnQgY29uc3QgJFNFTUlDT0xPTiA9IDU5O1xuZXhwb3J0IGNvbnN0ICRMVCA9IDYwO1xuZXhwb3J0IGNvbnN0ICRFUSA9IDYxO1xuZXhwb3J0IGNvbnN0ICRHVCA9IDYyO1xuZXhwb3J0IGNvbnN0ICRRVUVTVElPTiA9IDYzO1xuXG5leHBvcnQgY29uc3QgJDAgPSA0ODtcbmV4cG9ydCBjb25zdCAkNyA9IDU1O1xuZXhwb3J0IGNvbnN0ICQ5ID0gNTc7XG5cbmV4cG9ydCBjb25zdCAkQSA9IDY1O1xuZXhwb3J0IGNvbnN0ICRFID0gNjk7XG5leHBvcnQgY29uc3QgJEYgPSA3MDtcbmV4cG9ydCBjb25zdCAkWCA9IDg4O1xuZXhwb3J0IGNvbnN0ICRaID0gOTA7XG5cbmV4cG9ydCBjb25zdCAkTEJSQUNLRVQgPSA5MTtcbmV4cG9ydCBjb25zdCAkQkFDS1NMQVNIID0gOTI7XG5leHBvcnQgY29uc3QgJFJCUkFDS0VUID0gOTM7XG5leHBvcnQgY29uc3QgJENBUkVUID0gOTQ7XG5leHBvcnQgY29uc3QgJF8gPSA5NTtcblxuZXhwb3J0IGNvbnN0ICRhID0gOTc7XG5leHBvcnQgY29uc3QgJGIgPSA5ODtcbmV4cG9ydCBjb25zdCAkZSA9IDEwMTtcbmV4cG9ydCBjb25zdCAkZiA9IDEwMjtcbmV4cG9ydCBjb25zdCAkbiA9IDExMDtcbmV4cG9ydCBjb25zdCAkciA9IDExNDtcbmV4cG9ydCBjb25zdCAkdCA9IDExNjtcbmV4cG9ydCBjb25zdCAkdSA9IDExNztcbmV4cG9ydCBjb25zdCAkdiA9IDExODtcbmV4cG9ydCBjb25zdCAkeCA9IDEyMDtcbmV4cG9ydCBjb25zdCAkeiA9IDEyMjtcblxuZXhwb3J0IGNvbnN0ICRMQlJBQ0UgPSAxMjM7XG5leHBvcnQgY29uc3QgJEJBUiA9IDEyNDtcbmV4cG9ydCBjb25zdCAkUkJSQUNFID0gMTI1O1xuZXhwb3J0IGNvbnN0ICROQlNQID0gMTYwO1xuXG5leHBvcnQgY29uc3QgJFBJUEUgPSAxMjQ7XG5leHBvcnQgY29uc3QgJFRJTERBID0gMTI2O1xuZXhwb3J0IGNvbnN0ICRBVCA9IDY0O1xuXG5leHBvcnQgY29uc3QgJEJUID0gOTY7XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1doaXRlc3BhY2UoY29kZTogbnVtYmVyKTogYm9vbGVhbiB7XG4gIHJldHVybiAoY29kZSA+PSAkVEFCICYmIGNvZGUgPD0gJFNQQUNFKSB8fCAoY29kZSA9PSAkTkJTUCk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0RpZ2l0KGNvZGU6IG51bWJlcik6IGJvb2xlYW4ge1xuICByZXR1cm4gJDAgPD0gY29kZSAmJiBjb2RlIDw9ICQ5O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNBc2NpaUxldHRlcihjb2RlOiBudW1iZXIpOiBib29sZWFuIHtcbiAgcmV0dXJuIGNvZGUgPj0gJGEgJiYgY29kZSA8PSAkeiB8fCBjb2RlID49ICRBICYmIGNvZGUgPD0gJFo7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0FzY2lpSGV4RGlnaXQoY29kZTogbnVtYmVyKTogYm9vbGVhbiB7XG4gIHJldHVybiBjb2RlID49ICRhICYmIGNvZGUgPD0gJGYgfHwgY29kZSA+PSAkQSAmJiBjb2RlIDw9ICRGIHx8IGlzRGlnaXQoY29kZSk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc05ld0xpbmUoY29kZTogbnVtYmVyKTogYm9vbGVhbiB7XG4gIHJldHVybiBjb2RlID09PSAkTEYgfHwgY29kZSA9PT0gJENSO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNPY3RhbERpZ2l0KGNvZGU6IG51bWJlcik6IGJvb2xlYW4ge1xuICByZXR1cm4gJDAgPD0gY29kZSAmJiBjb2RlIDw9ICQ3O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNRdW90ZShjb2RlOiBudW1iZXIpOiBib29sZWFuIHtcbiAgcmV0dXJuIGNvZGUgPT09ICRTUSB8fCBjb2RlID09PSAkRFEgfHwgY29kZSA9PT0gJEJUO1xufVxuIl19