/**
 * @license Angular v2.3.0-beta.1
 * (c) 2010-2016 Google, Inc. https://angular.io/
 * License: MIT
 */
(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core')) :
  typeof define === 'function' && define.amd ? define(['exports', '@angular/core'], factory) :
  (factory((global.ng = global.ng || {}, global.ng.compiler = global.ng.compiler || {}),global.ng.core));
}(this, function (exports,_angular_core) { 'use strict';

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  /**
   *  A segment of text within the template.
   */
  var TextAst = (function () {
      /**
       * @param {?} value
       * @param {?} ngContentIndex
       * @param {?} sourceSpan
       */
      function TextAst(value, ngContentIndex, sourceSpan) {
          this.value = value;
          this.ngContentIndex = ngContentIndex;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      TextAst.prototype.visit = function (visitor, context) { return visitor.visitText(this, context); };
      return TextAst;
  }());
  /**
   *  A bound expression within the text of a template.
   */
  var BoundTextAst = (function () {
      /**
       * @param {?} value
       * @param {?} ngContentIndex
       * @param {?} sourceSpan
       */
      function BoundTextAst(value, ngContentIndex, sourceSpan) {
          this.value = value;
          this.ngContentIndex = ngContentIndex;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      BoundTextAst.prototype.visit = function (visitor, context) {
          return visitor.visitBoundText(this, context);
      };
      return BoundTextAst;
  }());
  /**
   *  A plain attribute on an element.
   */
  var AttrAst = (function () {
      /**
       * @param {?} name
       * @param {?} value
       * @param {?} sourceSpan
       */
      function AttrAst(name, value, sourceSpan) {
          this.name = name;
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AttrAst.prototype.visit = function (visitor, context) { return visitor.visitAttr(this, context); };
      return AttrAst;
  }());
  /**
   *  A binding for an element property (e.g. `[property]="expression"`) or an animation trigger (e.g.
    * `[@trigger]="stateExp"`)
   */
  var BoundElementPropertyAst = (function () {
      /**
       * @param {?} name
       * @param {?} type
       * @param {?} securityContext
       * @param {?} needsRuntimeSecurityContext
       * @param {?} value
       * @param {?} unit
       * @param {?} sourceSpan
       */
      function BoundElementPropertyAst(name, type, securityContext, needsRuntimeSecurityContext, value, unit, sourceSpan) {
          this.name = name;
          this.type = type;
          this.securityContext = securityContext;
          this.needsRuntimeSecurityContext = needsRuntimeSecurityContext;
          this.value = value;
          this.unit = unit;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      BoundElementPropertyAst.prototype.visit = function (visitor, context) {
          return visitor.visitElementProperty(this, context);
      };
      Object.defineProperty(BoundElementPropertyAst.prototype, "isAnimation", {
          /**
           * @return {?}
           */
          get: function () { return this.type === PropertyBindingType.Animation; },
          enumerable: true,
          configurable: true
      });
      return BoundElementPropertyAst;
  }());
  /**
   *  A binding for an element event (e.g. `(event)="handler()"`) or an animation trigger event (e.g.
    * `(@trigger.phase)="callback($event)"`).
   */
  var BoundEventAst = (function () {
      /**
       * @param {?} name
       * @param {?} target
       * @param {?} phase
       * @param {?} handler
       * @param {?} sourceSpan
       */
      function BoundEventAst(name, target, phase, handler, sourceSpan) {
          this.name = name;
          this.target = target;
          this.phase = phase;
          this.handler = handler;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} name
       * @param {?} target
       * @param {?} phase
       * @return {?}
       */
      BoundEventAst.calcFullName = function (name, target, phase) {
          if (target) {
              return target + ":" + name;
          }
          else if (phase) {
              return "@" + name + "." + phase;
          }
          else {
              return name;
          }
      };
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      BoundEventAst.prototype.visit = function (visitor, context) {
          return visitor.visitEvent(this, context);
      };
      Object.defineProperty(BoundEventAst.prototype, "fullName", {
          /**
           * @return {?}
           */
          get: function () { return BoundEventAst.calcFullName(this.name, this.target, this.phase); },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(BoundEventAst.prototype, "isAnimation", {
          /**
           * @return {?}
           */
          get: function () { return !!this.phase; },
          enumerable: true,
          configurable: true
      });
      return BoundEventAst;
  }());
  /**
   *  A reference declaration on an element (e.g. `let someName="expression"`).
   */
  var ReferenceAst = (function () {
      /**
       * @param {?} name
       * @param {?} value
       * @param {?} sourceSpan
       */
      function ReferenceAst(name, value, sourceSpan) {
          this.name = name;
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ReferenceAst.prototype.visit = function (visitor, context) {
          return visitor.visitReference(this, context);
      };
      return ReferenceAst;
  }());
  /**
   *  A variable declaration on a <template> (e.g. `var-someName="someLocalName"`).
   */
  var VariableAst = (function () {
      /**
       * @param {?} name
       * @param {?} value
       * @param {?} sourceSpan
       */
      function VariableAst(name, value, sourceSpan) {
          this.name = name;
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      VariableAst.prototype.visit = function (visitor, context) {
          return visitor.visitVariable(this, context);
      };
      return VariableAst;
  }());
  /**
   *  An element declaration in a template.
   */
  var ElementAst = (function () {
      /**
       * @param {?} name
       * @param {?} attrs
       * @param {?} inputs
       * @param {?} outputs
       * @param {?} references
       * @param {?} directives
       * @param {?} providers
       * @param {?} hasViewContainer
       * @param {?} children
       * @param {?} ngContentIndex
       * @param {?} sourceSpan
       * @param {?} endSourceSpan
       */
      function ElementAst(name, attrs, inputs, outputs, references, directives, providers, hasViewContainer, children, ngContentIndex, sourceSpan, endSourceSpan) {
          this.name = name;
          this.attrs = attrs;
          this.inputs = inputs;
          this.outputs = outputs;
          this.references = references;
          this.directives = directives;
          this.providers = providers;
          this.hasViewContainer = hasViewContainer;
          this.children = children;
          this.ngContentIndex = ngContentIndex;
          this.sourceSpan = sourceSpan;
          this.endSourceSpan = endSourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ElementAst.prototype.visit = function (visitor, context) {
          return visitor.visitElement(this, context);
      };
      return ElementAst;
  }());
  /**
   *  A `<template>` element included in an Angular template.
   */
  var EmbeddedTemplateAst = (function () {
      /**
       * @param {?} attrs
       * @param {?} outputs
       * @param {?} references
       * @param {?} variables
       * @param {?} directives
       * @param {?} providers
       * @param {?} hasViewContainer
       * @param {?} children
       * @param {?} ngContentIndex
       * @param {?} sourceSpan
       */
      function EmbeddedTemplateAst(attrs, outputs, references, variables, directives, providers, hasViewContainer, children, ngContentIndex, sourceSpan) {
          this.attrs = attrs;
          this.outputs = outputs;
          this.references = references;
          this.variables = variables;
          this.directives = directives;
          this.providers = providers;
          this.hasViewContainer = hasViewContainer;
          this.children = children;
          this.ngContentIndex = ngContentIndex;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      EmbeddedTemplateAst.prototype.visit = function (visitor, context) {
          return visitor.visitEmbeddedTemplate(this, context);
      };
      return EmbeddedTemplateAst;
  }());
  /**
   *  A directive property with a bound value (e.g. `*ngIf="condition").
   */
  var BoundDirectivePropertyAst = (function () {
      /**
       * @param {?} directiveName
       * @param {?} templateName
       * @param {?} value
       * @param {?} sourceSpan
       */
      function BoundDirectivePropertyAst(directiveName, templateName, value, sourceSpan) {
          this.directiveName = directiveName;
          this.templateName = templateName;
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      BoundDirectivePropertyAst.prototype.visit = function (visitor, context) {
          return visitor.visitDirectiveProperty(this, context);
      };
      return BoundDirectivePropertyAst;
  }());
  /**
   *  A directive declared on an element.
   */
  var DirectiveAst = (function () {
      /**
       * @param {?} directive
       * @param {?} inputs
       * @param {?} hostProperties
       * @param {?} hostEvents
       * @param {?} sourceSpan
       */
      function DirectiveAst(directive, inputs, hostProperties, hostEvents, sourceSpan) {
          this.directive = directive;
          this.inputs = inputs;
          this.hostProperties = hostProperties;
          this.hostEvents = hostEvents;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      DirectiveAst.prototype.visit = function (visitor, context) {
          return visitor.visitDirective(this, context);
      };
      return DirectiveAst;
  }());
  /**
   *  A provider declared on an element
   */
  var ProviderAst = (function () {
      /**
       * @param {?} token
       * @param {?} multiProvider
       * @param {?} eager
       * @param {?} providers
       * @param {?} providerType
       * @param {?} lifecycleHooks
       * @param {?} sourceSpan
       */
      function ProviderAst(token, multiProvider, eager, providers, providerType, lifecycleHooks, sourceSpan) {
          this.token = token;
          this.multiProvider = multiProvider;
          this.eager = eager;
          this.providers = providers;
          this.providerType = providerType;
          this.lifecycleHooks = lifecycleHooks;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ProviderAst.prototype.visit = function (visitor, context) {
          // No visit method in the visitor for now...
          return null;
      };
      return ProviderAst;
  }());
  var ProviderAstType = {};
  ProviderAstType.PublicService = 0;
  ProviderAstType.PrivateService = 1;
  ProviderAstType.Component = 2;
  ProviderAstType.Directive = 3;
  ProviderAstType.Builtin = 4;
  ProviderAstType[ProviderAstType.PublicService] = "PublicService";
  ProviderAstType[ProviderAstType.PrivateService] = "PrivateService";
  ProviderAstType[ProviderAstType.Component] = "Component";
  ProviderAstType[ProviderAstType.Directive] = "Directive";
  ProviderAstType[ProviderAstType.Builtin] = "Builtin";
  /**
   *  Position where content is to be projected (instance of `<ng-content>` in a template).
   */
  var NgContentAst = (function () {
      /**
       * @param {?} index
       * @param {?} ngContentIndex
       * @param {?} sourceSpan
       */
      function NgContentAst(index, ngContentIndex, sourceSpan) {
          this.index = index;
          this.ngContentIndex = ngContentIndex;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      NgContentAst.prototype.visit = function (visitor, context) {
          return visitor.visitNgContent(this, context);
      };
      return NgContentAst;
  }());
  var PropertyBindingType = {};
  PropertyBindingType.Property = 0;
  PropertyBindingType.Attribute = 1;
  PropertyBindingType.Class = 2;
  PropertyBindingType.Style = 3;
  PropertyBindingType.Animation = 4;
  PropertyBindingType[PropertyBindingType.Property] = "Property";
  PropertyBindingType[PropertyBindingType.Attribute] = "Attribute";
  PropertyBindingType[PropertyBindingType.Class] = "Class";
  PropertyBindingType[PropertyBindingType.Style] = "Style";
  PropertyBindingType[PropertyBindingType.Animation] = "Animation";
  /**
   *  Visit every node in a list of {@link TemplateAst}s with the given {@link TemplateAstVisitor}.
   * @param {?} visitor
   * @param {?} asts
   * @param {?=} context
   * @return {?}
   */
  function templateVisitAll(visitor, asts, context) {
      if (context === void 0) { context = null; }
      var /** @type {?} */ result = [];
      var /** @type {?} */ visit = visitor.visit ?
          function (ast) { return visitor.visit(ast, context) || ast.visit(visitor, context); } :
          function (ast) { return ast.visit(visitor, context); };
      asts.forEach(function (ast) {
          var /** @type {?} */ astResult = visit(ast);
          if (astResult) {
              result.push(astResult);
          }
      });
      return result;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var /** @type {?} */ $EOF = 0;
  var /** @type {?} */ $TAB = 9;
  var /** @type {?} */ $LF = 10;
  var /** @type {?} */ $VTAB = 11;
  var /** @type {?} */ $FF = 12;
  var /** @type {?} */ $CR = 13;
  var /** @type {?} */ $SPACE = 32;
  var /** @type {?} */ $BANG = 33;
  var /** @type {?} */ $DQ = 34;
  var /** @type {?} */ $HASH = 35;
  var /** @type {?} */ $$ = 36;
  var /** @type {?} */ $PERCENT = 37;
  var /** @type {?} */ $AMPERSAND = 38;
  var /** @type {?} */ $SQ = 39;
  var /** @type {?} */ $LPAREN = 40;
  var /** @type {?} */ $RPAREN = 41;
  var /** @type {?} */ $STAR = 42;
  var /** @type {?} */ $PLUS = 43;
  var /** @type {?} */ $COMMA = 44;
  var /** @type {?} */ $MINUS = 45;
  var /** @type {?} */ $PERIOD = 46;
  var /** @type {?} */ $SLASH = 47;
  var /** @type {?} */ $COLON = 58;
  var /** @type {?} */ $SEMICOLON = 59;
  var /** @type {?} */ $LT = 60;
  var /** @type {?} */ $EQ = 61;
  var /** @type {?} */ $GT = 62;
  var /** @type {?} */ $QUESTION = 63;
  var /** @type {?} */ $0 = 48;
  var /** @type {?} */ $9 = 57;
  var /** @type {?} */ $A = 65;
  var /** @type {?} */ $E = 69;
  var /** @type {?} */ $F = 70;
  var /** @type {?} */ $X = 88;
  var /** @type {?} */ $Z = 90;
  var /** @type {?} */ $LBRACKET = 91;
  var /** @type {?} */ $BACKSLASH = 92;
  var /** @type {?} */ $RBRACKET = 93;
  var /** @type {?} */ $CARET = 94;
  var /** @type {?} */ $_ = 95;
  var /** @type {?} */ $a = 97;
  var /** @type {?} */ $e = 101;
  var /** @type {?} */ $f = 102;
  var /** @type {?} */ $n = 110;
  var /** @type {?} */ $r = 114;
  var /** @type {?} */ $t = 116;
  var /** @type {?} */ $u = 117;
  var /** @type {?} */ $v = 118;
  var /** @type {?} */ $x = 120;
  var /** @type {?} */ $z = 122;
  var /** @type {?} */ $LBRACE = 123;
  var /** @type {?} */ $BAR = 124;
  var /** @type {?} */ $RBRACE = 125;
  var /** @type {?} */ $NBSP = 160;
  var /** @type {?} */ $BT = 96;
  /**
   * @param {?} code
   * @return {?}
   */
  function isWhitespace(code) {
      return (code >= $TAB && code <= $SPACE) || (code == $NBSP);
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isDigit(code) {
      return $0 <= code && code <= $9;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isAsciiLetter(code) {
      return code >= $a && code <= $z || code >= $A && code <= $Z;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isAsciiHexDigit(code) {
      return code >= $a && code <= $f || code >= $A && code <= $F || isDigit(code);
  }

  /**
   * @param {?} obj
   * @return {?}
   */
  function isPresent(obj) {
      return obj != null;
  }
  /**
   * @param {?} obj
   * @return {?}
   */
  function isBlank(obj) {
      return obj == null;
  }
  var /** @type {?} */ STRING_MAP_PROTO = Object.getPrototypeOf({});
  /**
   * @param {?} obj
   * @return {?}
   */
  function isStrictStringMap(obj) {
      return typeof obj === 'object' && obj !== null && Object.getPrototypeOf(obj) === STRING_MAP_PROTO;
  }
  /**
   * @param {?} token
   * @return {?}
   */
  function stringify(token) {
      if (typeof token === 'string') {
          return token;
      }
      if (token == null) {
          return '' + token;
      }
      if (token.overriddenName) {
          return token.overriddenName;
      }
      if (token.name) {
          return token.name;
      }
      var /** @type {?} */ res = token.toString();
      var /** @type {?} */ newLineIndex = res.indexOf('\n');
      return newLineIndex === -1 ? res : res.substring(0, newLineIndex);
  }
  var NumberWrapper = (function () {
      function NumberWrapper() {
      }
      /**
       * @param {?} text
       * @return {?}
       */
      NumberWrapper.parseIntAutoRadix = function (text) {
          var /** @type {?} */ result = parseInt(text);
          if (isNaN(result)) {
              throw new Error('Invalid integer literal when parsing ' + text);
          }
          return result;
      };
      /**
       * @param {?} value
       * @return {?}
       */
      NumberWrapper.isNumeric = function (value) { return !isNaN(value - parseFloat(value)); };
      return NumberWrapper;
  }());
  /**
   * @param {?} o
   * @return {?}
   */
  function isJsObject(o) {
      return o !== null && (typeof o === 'function' || typeof o === 'object');
  }
  /**
   * @param {?} obj
   * @return {?}
   */
  function isPrimitive(obj) {
      return !isJsObject(obj);
  }
  /**
   * @param {?} s
   * @return {?}
   */
  function escapeRegExp(s) {
      return s.replace(/([.*+?^=!:${}()|[\]\/\\])/g, '\\$1');
  }

  /**
   * @param {?} identifier
   * @param {?} value
   * @return {?}
   */
  function assertArrayOfStrings(identifier, value) {
      if (!_angular_core.isDevMode() || isBlank(value)) {
          return;
      }
      if (!Array.isArray(value)) {
          throw new Error("Expected '" + identifier + "' to be an array of strings.");
      }
      for (var /** @type {?} */ i = 0; i < value.length; i += 1) {
          if (typeof value[i] !== 'string') {
              throw new Error("Expected '" + identifier + "' to be an array of strings.");
          }
      }
  }
  var /** @type {?} */ INTERPOLATION_BLACKLIST_REGEXPS = [
      /^\s*$/,
      /[<>]/,
      /^[{}]$/,
      /&(#|[a-z])/i,
      /^\/\//,
  ];
  /**
   * @param {?} identifier
   * @param {?} value
   * @return {?}
   */
  function assertInterpolationSymbols(identifier, value) {
      if (isPresent(value) && !(Array.isArray(value) && value.length == 2)) {
          throw new Error("Expected '" + identifier + "' to be an array, [start, end].");
      }
      else if (_angular_core.isDevMode() && !isBlank(value)) {
          var /** @type {?} */ start_1 = (value[0]);
          var /** @type {?} */ end_1 = (value[1]);
          // black list checking
          INTERPOLATION_BLACKLIST_REGEXPS.forEach(function (regexp) {
              if (regexp.test(start_1) || regexp.test(end_1)) {
                  throw new Error("['" + start_1 + "', '" + end_1 + "'] contains unusable interpolation symbol.");
              }
          });
      }
  }

  var InterpolationConfig = (function () {
      /**
       * @param {?} start
       * @param {?} end
       */
      function InterpolationConfig(start, end) {
          this.start = start;
          this.end = end;
      }
      /**
       * @param {?} markers
       * @return {?}
       */
      InterpolationConfig.fromArray = function (markers) {
          if (!markers) {
              return DEFAULT_INTERPOLATION_CONFIG;
          }
          assertInterpolationSymbols('interpolation', markers);
          return new InterpolationConfig(markers[0], markers[1]);
      };
      ;
      return InterpolationConfig;
  }());
  var /** @type {?} */ DEFAULT_INTERPOLATION_CONFIG = new InterpolationConfig('{{', '}}');

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$1 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var ParserError = (function () {
      /**
       * @param {?} message
       * @param {?} input
       * @param {?} errLocation
       * @param {?=} ctxLocation
       */
      function ParserError(message, input, errLocation, ctxLocation) {
          this.input = input;
          this.errLocation = errLocation;
          this.ctxLocation = ctxLocation;
          this.message = "Parser Error: " + message + " " + errLocation + " [" + input + "] in " + ctxLocation;
      }
      return ParserError;
  }());
  var ParseSpan = (function () {
      /**
       * @param {?} start
       * @param {?} end
       */
      function ParseSpan(start, end) {
          this.start = start;
          this.end = end;
      }
      return ParseSpan;
  }());
  var AST = (function () {
      /**
       * @param {?} span
       */
      function AST(span) {
          this.span = span;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      AST.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return null;
      };
      /**
       * @return {?}
       */
      AST.prototype.toString = function () { return 'AST'; };
      return AST;
  }());
  /**
   *  Represents a quoted expression of the form:
    * *
    * quote = prefix `:` uninterpretedExpression
    * prefix = identifier
    * uninterpretedExpression = arbitrary string
    * *
    * A quoted expression is meant to be pre-processed by an AST transformer that
    * converts it into another AST that no longer contains quoted expressions.
    * It is meant to allow third-party developers to extend Angular template
    * expression language. The `uninterpretedExpression` part of the quote is
    * therefore not interpreted by the Angular's own expression parser.
   */
  var Quote = (function (_super) {
      __extends$1(Quote, _super);
      /**
       * @param {?} span
       * @param {?} prefix
       * @param {?} uninterpretedExpression
       * @param {?} location
       */
      function Quote(span, prefix, uninterpretedExpression, location) {
          _super.call(this, span);
          this.prefix = prefix;
          this.uninterpretedExpression = uninterpretedExpression;
          this.location = location;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Quote.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitQuote(this, context);
      };
      /**
       * @return {?}
       */
      Quote.prototype.toString = function () { return 'Quote'; };
      return Quote;
  }(AST));
  var EmptyExpr = (function (_super) {
      __extends$1(EmptyExpr, _super);
      function EmptyExpr() {
          _super.apply(this, arguments);
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      EmptyExpr.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          // do nothing
      };
      return EmptyExpr;
  }(AST));
  var ImplicitReceiver = (function (_super) {
      __extends$1(ImplicitReceiver, _super);
      function ImplicitReceiver() {
          _super.apply(this, arguments);
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      ImplicitReceiver.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitImplicitReceiver(this, context);
      };
      return ImplicitReceiver;
  }(AST));
  /**
   *  Multiple expressions separated by a semicolon.
   */
  var Chain = (function (_super) {
      __extends$1(Chain, _super);
      /**
       * @param {?} span
       * @param {?} expressions
       */
      function Chain(span, expressions) {
          _super.call(this, span);
          this.expressions = expressions;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Chain.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitChain(this, context);
      };
      return Chain;
  }(AST));
  var Conditional = (function (_super) {
      __extends$1(Conditional, _super);
      /**
       * @param {?} span
       * @param {?} condition
       * @param {?} trueExp
       * @param {?} falseExp
       */
      function Conditional(span, condition, trueExp, falseExp) {
          _super.call(this, span);
          this.condition = condition;
          this.trueExp = trueExp;
          this.falseExp = falseExp;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Conditional.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitConditional(this, context);
      };
      return Conditional;
  }(AST));
  var PropertyRead = (function (_super) {
      __extends$1(PropertyRead, _super);
      /**
       * @param {?} span
       * @param {?} receiver
       * @param {?} name
       */
      function PropertyRead(span, receiver, name) {
          _super.call(this, span);
          this.receiver = receiver;
          this.name = name;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      PropertyRead.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitPropertyRead(this, context);
      };
      return PropertyRead;
  }(AST));
  var PropertyWrite = (function (_super) {
      __extends$1(PropertyWrite, _super);
      /**
       * @param {?} span
       * @param {?} receiver
       * @param {?} name
       * @param {?} value
       */
      function PropertyWrite(span, receiver, name, value) {
          _super.call(this, span);
          this.receiver = receiver;
          this.name = name;
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      PropertyWrite.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitPropertyWrite(this, context);
      };
      return PropertyWrite;
  }(AST));
  var SafePropertyRead = (function (_super) {
      __extends$1(SafePropertyRead, _super);
      /**
       * @param {?} span
       * @param {?} receiver
       * @param {?} name
       */
      function SafePropertyRead(span, receiver, name) {
          _super.call(this, span);
          this.receiver = receiver;
          this.name = name;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      SafePropertyRead.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitSafePropertyRead(this, context);
      };
      return SafePropertyRead;
  }(AST));
  var KeyedRead = (function (_super) {
      __extends$1(KeyedRead, _super);
      /**
       * @param {?} span
       * @param {?} obj
       * @param {?} key
       */
      function KeyedRead(span, obj, key) {
          _super.call(this, span);
          this.obj = obj;
          this.key = key;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      KeyedRead.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitKeyedRead(this, context);
      };
      return KeyedRead;
  }(AST));
  var KeyedWrite = (function (_super) {
      __extends$1(KeyedWrite, _super);
      /**
       * @param {?} span
       * @param {?} obj
       * @param {?} key
       * @param {?} value
       */
      function KeyedWrite(span, obj, key, value) {
          _super.call(this, span);
          this.obj = obj;
          this.key = key;
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      KeyedWrite.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitKeyedWrite(this, context);
      };
      return KeyedWrite;
  }(AST));
  var BindingPipe = (function (_super) {
      __extends$1(BindingPipe, _super);
      /**
       * @param {?} span
       * @param {?} exp
       * @param {?} name
       * @param {?} args
       */
      function BindingPipe(span, exp, name, args) {
          _super.call(this, span);
          this.exp = exp;
          this.name = name;
          this.args = args;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      BindingPipe.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitPipe(this, context);
      };
      return BindingPipe;
  }(AST));
  var LiteralPrimitive = (function (_super) {
      __extends$1(LiteralPrimitive, _super);
      /**
       * @param {?} span
       * @param {?} value
       */
      function LiteralPrimitive(span, value) {
          _super.call(this, span);
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      LiteralPrimitive.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitLiteralPrimitive(this, context);
      };
      return LiteralPrimitive;
  }(AST));
  var LiteralArray = (function (_super) {
      __extends$1(LiteralArray, _super);
      /**
       * @param {?} span
       * @param {?} expressions
       */
      function LiteralArray(span, expressions) {
          _super.call(this, span);
          this.expressions = expressions;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      LiteralArray.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitLiteralArray(this, context);
      };
      return LiteralArray;
  }(AST));
  var LiteralMap = (function (_super) {
      __extends$1(LiteralMap, _super);
      /**
       * @param {?} span
       * @param {?} keys
       * @param {?} values
       */
      function LiteralMap(span, keys, values) {
          _super.call(this, span);
          this.keys = keys;
          this.values = values;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      LiteralMap.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitLiteralMap(this, context);
      };
      return LiteralMap;
  }(AST));
  var Interpolation = (function (_super) {
      __extends$1(Interpolation, _super);
      /**
       * @param {?} span
       * @param {?} strings
       * @param {?} expressions
       */
      function Interpolation(span, strings, expressions) {
          _super.call(this, span);
          this.strings = strings;
          this.expressions = expressions;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Interpolation.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitInterpolation(this, context);
      };
      return Interpolation;
  }(AST));
  var Binary = (function (_super) {
      __extends$1(Binary, _super);
      /**
       * @param {?} span
       * @param {?} operation
       * @param {?} left
       * @param {?} right
       */
      function Binary(span, operation, left, right) {
          _super.call(this, span);
          this.operation = operation;
          this.left = left;
          this.right = right;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Binary.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitBinary(this, context);
      };
      return Binary;
  }(AST));
  var PrefixNot = (function (_super) {
      __extends$1(PrefixNot, _super);
      /**
       * @param {?} span
       * @param {?} expression
       */
      function PrefixNot(span, expression) {
          _super.call(this, span);
          this.expression = expression;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      PrefixNot.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitPrefixNot(this, context);
      };
      return PrefixNot;
  }(AST));
  var MethodCall = (function (_super) {
      __extends$1(MethodCall, _super);
      /**
       * @param {?} span
       * @param {?} receiver
       * @param {?} name
       * @param {?} args
       */
      function MethodCall(span, receiver, name, args) {
          _super.call(this, span);
          this.receiver = receiver;
          this.name = name;
          this.args = args;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      MethodCall.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitMethodCall(this, context);
      };
      return MethodCall;
  }(AST));
  var SafeMethodCall = (function (_super) {
      __extends$1(SafeMethodCall, _super);
      /**
       * @param {?} span
       * @param {?} receiver
       * @param {?} name
       * @param {?} args
       */
      function SafeMethodCall(span, receiver, name, args) {
          _super.call(this, span);
          this.receiver = receiver;
          this.name = name;
          this.args = args;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      SafeMethodCall.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitSafeMethodCall(this, context);
      };
      return SafeMethodCall;
  }(AST));
  var FunctionCall = (function (_super) {
      __extends$1(FunctionCall, _super);
      /**
       * @param {?} span
       * @param {?} target
       * @param {?} args
       */
      function FunctionCall(span, target, args) {
          _super.call(this, span);
          this.target = target;
          this.args = args;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      FunctionCall.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return visitor.visitFunctionCall(this, context);
      };
      return FunctionCall;
  }(AST));
  var ASTWithSource = (function (_super) {
      __extends$1(ASTWithSource, _super);
      /**
       * @param {?} ast
       * @param {?} source
       * @param {?} location
       * @param {?} errors
       */
      function ASTWithSource(ast, source, location, errors) {
          _super.call(this, new ParseSpan(0, isBlank(source) ? 0 : source.length));
          this.ast = ast;
          this.source = source;
          this.location = location;
          this.errors = errors;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      ASTWithSource.prototype.visit = function (visitor, context) {
          if (context === void 0) { context = null; }
          return this.ast.visit(visitor, context);
      };
      /**
       * @return {?}
       */
      ASTWithSource.prototype.toString = function () { return this.source + " in " + this.location; };
      return ASTWithSource;
  }(AST));
  var TemplateBinding = (function () {
      /**
       * @param {?} span
       * @param {?} key
       * @param {?} keyIsVar
       * @param {?} name
       * @param {?} expression
       */
      function TemplateBinding(span, key, keyIsVar, name, expression) {
          this.span = span;
          this.key = key;
          this.keyIsVar = keyIsVar;
          this.name = name;
          this.expression = expression;
      }
      return TemplateBinding;
  }());
  var RecursiveAstVisitor = (function () {
      function RecursiveAstVisitor() {
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitBinary = function (ast, context) {
          ast.left.visit(this);
          ast.right.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitChain = function (ast, context) { return this.visitAll(ast.expressions, context); };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitConditional = function (ast, context) {
          ast.condition.visit(this);
          ast.trueExp.visit(this);
          ast.falseExp.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitPipe = function (ast, context) {
          ast.exp.visit(this);
          this.visitAll(ast.args, context);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitFunctionCall = function (ast, context) {
          ast.target.visit(this);
          this.visitAll(ast.args, context);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitImplicitReceiver = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitInterpolation = function (ast, context) {
          return this.visitAll(ast.expressions, context);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitKeyedRead = function (ast, context) {
          ast.obj.visit(this);
          ast.key.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitKeyedWrite = function (ast, context) {
          ast.obj.visit(this);
          ast.key.visit(this);
          ast.value.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitLiteralArray = function (ast, context) {
          return this.visitAll(ast.expressions, context);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitLiteralMap = function (ast, context) { return this.visitAll(ast.values, context); };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitLiteralPrimitive = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitMethodCall = function (ast, context) {
          ast.receiver.visit(this);
          return this.visitAll(ast.args, context);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitPrefixNot = function (ast, context) {
          ast.expression.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitPropertyRead = function (ast, context) {
          ast.receiver.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitPropertyWrite = function (ast, context) {
          ast.receiver.visit(this);
          ast.value.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitSafePropertyRead = function (ast, context) {
          ast.receiver.visit(this);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitSafeMethodCall = function (ast, context) {
          ast.receiver.visit(this);
          return this.visitAll(ast.args, context);
      };
      /**
       * @param {?} asts
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitAll = function (asts, context) {
          var _this = this;
          asts.forEach(function (ast) { return ast.visit(_this, context); });
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveAstVisitor.prototype.visitQuote = function (ast, context) { return null; };
      return RecursiveAstVisitor;
  }());

  var TokenType = {};
  TokenType.Character = 0;
  TokenType.Identifier = 1;
  TokenType.Keyword = 2;
  TokenType.String = 3;
  TokenType.Operator = 4;
  TokenType.Number = 5;
  TokenType.Error = 6;
  TokenType[TokenType.Character] = "Character";
  TokenType[TokenType.Identifier] = "Identifier";
  TokenType[TokenType.Keyword] = "Keyword";
  TokenType[TokenType.String] = "String";
  TokenType[TokenType.Operator] = "Operator";
  TokenType[TokenType.Number] = "Number";
  TokenType[TokenType.Error] = "Error";
  var /** @type {?} */ KEYWORDS = ['var', 'let', 'null', 'undefined', 'true', 'false', 'if', 'else', 'this'];
  var Lexer = (function () {
      function Lexer() {
      }
      /**
       * @param {?} text
       * @return {?}
       */
      Lexer.prototype.tokenize = function (text) {
          var /** @type {?} */ scanner = new _Scanner(text);
          var /** @type {?} */ tokens = [];
          var /** @type {?} */ token = scanner.scanToken();
          while (token != null) {
              tokens.push(token);
              token = scanner.scanToken();
          }
          return tokens;
      };
      Lexer.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      Lexer.ctorParameters = function () { return []; };
      return Lexer;
  }());
  var Token = (function () {
      /**
       * @param {?} index
       * @param {?} type
       * @param {?} numValue
       * @param {?} strValue
       */
      function Token(index, type, numValue, strValue) {
          this.index = index;
          this.type = type;
          this.numValue = numValue;
          this.strValue = strValue;
      }
      /**
       * @param {?} code
       * @return {?}
       */
      Token.prototype.isCharacter = function (code) {
          return this.type == TokenType.Character && this.numValue == code;
      };
      /**
       * @return {?}
       */
      Token.prototype.isNumber = function () { return this.type == TokenType.Number; };
      /**
       * @return {?}
       */
      Token.prototype.isString = function () { return this.type == TokenType.String; };
      /**
       * @param {?} operater
       * @return {?}
       */
      Token.prototype.isOperator = function (operater) {
          return this.type == TokenType.Operator && this.strValue == operater;
      };
      /**
       * @return {?}
       */
      Token.prototype.isIdentifier = function () { return this.type == TokenType.Identifier; };
      /**
       * @return {?}
       */
      Token.prototype.isKeyword = function () { return this.type == TokenType.Keyword; };
      /**
       * @return {?}
       */
      Token.prototype.isKeywordLet = function () { return this.type == TokenType.Keyword && this.strValue == 'let'; };
      /**
       * @return {?}
       */
      Token.prototype.isKeywordNull = function () { return this.type == TokenType.Keyword && this.strValue == 'null'; };
      /**
       * @return {?}
       */
      Token.prototype.isKeywordUndefined = function () {
          return this.type == TokenType.Keyword && this.strValue == 'undefined';
      };
      /**
       * @return {?}
       */
      Token.prototype.isKeywordTrue = function () { return this.type == TokenType.Keyword && this.strValue == 'true'; };
      /**
       * @return {?}
       */
      Token.prototype.isKeywordFalse = function () { return this.type == TokenType.Keyword && this.strValue == 'false'; };
      /**
       * @return {?}
       */
      Token.prototype.isKeywordThis = function () { return this.type == TokenType.Keyword && this.strValue == 'this'; };
      /**
       * @return {?}
       */
      Token.prototype.isError = function () { return this.type == TokenType.Error; };
      /**
       * @return {?}
       */
      Token.prototype.toNumber = function () { return this.type == TokenType.Number ? this.numValue : -1; };
      /**
       * @return {?}
       */
      Token.prototype.toString = function () {
          switch (this.type) {
              case TokenType.Character:
              case TokenType.Identifier:
              case TokenType.Keyword:
              case TokenType.Operator:
              case TokenType.String:
              case TokenType.Error:
                  return this.strValue;
              case TokenType.Number:
                  return this.numValue.toString();
              default:
                  return null;
          }
      };
      return Token;
  }());
  /**
   * @param {?} index
   * @param {?} code
   * @return {?}
   */
  function newCharacterToken(index, code) {
      return new Token(index, TokenType.Character, code, String.fromCharCode(code));
  }
  /**
   * @param {?} index
   * @param {?} text
   * @return {?}
   */
  function newIdentifierToken(index, text) {
      return new Token(index, TokenType.Identifier, 0, text);
  }
  /**
   * @param {?} index
   * @param {?} text
   * @return {?}
   */
  function newKeywordToken(index, text) {
      return new Token(index, TokenType.Keyword, 0, text);
  }
  /**
   * @param {?} index
   * @param {?} text
   * @return {?}
   */
  function newOperatorToken(index, text) {
      return new Token(index, TokenType.Operator, 0, text);
  }
  /**
   * @param {?} index
   * @param {?} text
   * @return {?}
   */
  function newStringToken(index, text) {
      return new Token(index, TokenType.String, 0, text);
  }
  /**
   * @param {?} index
   * @param {?} n
   * @return {?}
   */
  function newNumberToken(index, n) {
      return new Token(index, TokenType.Number, n, '');
  }
  /**
   * @param {?} index
   * @param {?} message
   * @return {?}
   */
  function newErrorToken(index, message) {
      return new Token(index, TokenType.Error, 0, message);
  }
  var /** @type {?} */ EOF = new Token(-1, TokenType.Character, 0, '');
  var _Scanner = (function () {
      /**
       * @param {?} input
       */
      function _Scanner(input) {
          this.input = input;
          this.peek = 0;
          this.index = -1;
          this.length = input.length;
          this.advance();
      }
      /**
       * @return {?}
       */
      _Scanner.prototype.advance = function () {
          this.peek = ++this.index >= this.length ? $EOF : this.input.charCodeAt(this.index);
      };
      /**
       * @return {?}
       */
      _Scanner.prototype.scanToken = function () {
          var /** @type {?} */ input = this.input, /** @type {?} */ length = this.length;
          var /** @type {?} */ peek = this.peek, /** @type {?} */ index = this.index;
          // Skip whitespace.
          while (peek <= $SPACE) {
              if (++index >= length) {
                  peek = $EOF;
                  break;
              }
              else {
                  peek = input.charCodeAt(index);
              }
          }
          this.peek = peek;
          this.index = index;
          if (index >= length) {
              return null;
          }
          // Handle identifiers and numbers.
          if (isIdentifierStart(peek))
              return this.scanIdentifier();
          if (isDigit(peek))
              return this.scanNumber(index);
          var /** @type {?} */ start = index;
          switch (peek) {
              case $PERIOD:
                  this.advance();
                  return isDigit(this.peek) ? this.scanNumber(start) :
                      newCharacterToken(start, $PERIOD);
              case $LPAREN:
              case $RPAREN:
              case $LBRACE:
              case $RBRACE:
              case $LBRACKET:
              case $RBRACKET:
              case $COMMA:
              case $COLON:
              case $SEMICOLON:
                  return this.scanCharacter(start, peek);
              case $SQ:
              case $DQ:
                  return this.scanString();
              case $HASH:
              case $PLUS:
              case $MINUS:
              case $STAR:
              case $SLASH:
              case $PERCENT:
              case $CARET:
                  return this.scanOperator(start, String.fromCharCode(peek));
              case $QUESTION:
                  return this.scanComplexOperator(start, '?', $PERIOD, '.');
              case $LT:
              case $GT:
                  return this.scanComplexOperator(start, String.fromCharCode(peek), $EQ, '=');
              case $BANG:
              case $EQ:
                  return this.scanComplexOperator(start, String.fromCharCode(peek), $EQ, '=', $EQ, '=');
              case $AMPERSAND:
                  return this.scanComplexOperator(start, '&', $AMPERSAND, '&');
              case $BAR:
                  return this.scanComplexOperator(start, '|', $BAR, '|');
              case $NBSP:
                  while (isWhitespace(this.peek))
                      this.advance();
                  return this.scanToken();
          }
          this.advance();
          return this.error("Unexpected character [" + String.fromCharCode(peek) + "]", 0);
      };
      /**
       * @param {?} start
       * @param {?} code
       * @return {?}
       */
      _Scanner.prototype.scanCharacter = function (start, code) {
          this.advance();
          return newCharacterToken(start, code);
      };
      /**
       * @param {?} start
       * @param {?} str
       * @return {?}
       */
      _Scanner.prototype.scanOperator = function (start, str) {
          this.advance();
          return newOperatorToken(start, str);
      };
      /**
       *  Tokenize a 2/3 char long operator
        * *
       * @param {?} start start index in the expression
       * @param {?} one first symbol (always part of the operator)
       * @param {?} twoCode code point for the second symbol
       * @param {?} two second symbol (part of the operator when the second code point matches)
       * @param {?=} threeCode code point for the third symbol
       * @param {?=} three third symbol (part of the operator when provided and matches source expression)
       * @return {?}
       */
      _Scanner.prototype.scanComplexOperator = function (start, one, twoCode, two, threeCode, three) {
          this.advance();
          var /** @type {?} */ str = one;
          if (this.peek == twoCode) {
              this.advance();
              str += two;
          }
          if (isPresent(threeCode) && this.peek == threeCode) {
              this.advance();
              str += three;
          }
          return newOperatorToken(start, str);
      };
      /**
       * @return {?}
       */
      _Scanner.prototype.scanIdentifier = function () {
          var /** @type {?} */ start = this.index;
          this.advance();
          while (isIdentifierPart(this.peek))
              this.advance();
          var /** @type {?} */ str = this.input.substring(start, this.index);
          return KEYWORDS.indexOf(str) > -1 ? newKeywordToken(start, str) :
              newIdentifierToken(start, str);
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _Scanner.prototype.scanNumber = function (start) {
          var /** @type {?} */ simple = (this.index === start);
          this.advance(); // Skip initial digit.
          while (true) {
              if (isDigit(this.peek)) {
              }
              else if (this.peek == $PERIOD) {
                  simple = false;
              }
              else if (isExponentStart(this.peek)) {
                  this.advance();
                  if (isExponentSign(this.peek))
                      this.advance();
                  if (!isDigit(this.peek))
                      return this.error('Invalid exponent', -1);
                  simple = false;
              }
              else {
                  break;
              }
              this.advance();
          }
          var /** @type {?} */ str = this.input.substring(start, this.index);
          var /** @type {?} */ value = simple ? NumberWrapper.parseIntAutoRadix(str) : parseFloat(str);
          return newNumberToken(start, value);
      };
      /**
       * @return {?}
       */
      _Scanner.prototype.scanString = function () {
          var /** @type {?} */ start = this.index;
          var /** @type {?} */ quote = this.peek;
          this.advance(); // Skip initial quote.
          var /** @type {?} */ buffer = '';
          var /** @type {?} */ marker = this.index;
          var /** @type {?} */ input = this.input;
          while (this.peek != quote) {
              if (this.peek == $BACKSLASH) {
                  buffer += input.substring(marker, this.index);
                  this.advance();
                  var /** @type {?} */ unescapedCode = void 0;
                  if (this.peek == $u) {
                      // 4 character hex code for unicode character.
                      var /** @type {?} */ hex = input.substring(this.index + 1, this.index + 5);
                      if (/^[0-9a-f]+$/i.test(hex)) {
                          unescapedCode = parseInt(hex, 16);
                      }
                      else {
                          return this.error("Invalid unicode escape [\\u" + hex + "]", 0);
                      }
                      for (var /** @type {?} */ i = 0; i < 5; i++) {
                          this.advance();
                      }
                  }
                  else {
                      unescapedCode = unescape(this.peek);
                      this.advance();
                  }
                  buffer += String.fromCharCode(unescapedCode);
                  marker = this.index;
              }
              else if (this.peek == $EOF) {
                  return this.error('Unterminated quote', 0);
              }
              else {
                  this.advance();
              }
          }
          var /** @type {?} */ last = input.substring(marker, this.index);
          this.advance(); // Skip terminating quote.
          return newStringToken(start, buffer + last);
      };
      /**
       * @param {?} message
       * @param {?} offset
       * @return {?}
       */
      _Scanner.prototype.error = function (message, offset) {
          var /** @type {?} */ position = this.index + offset;
          return newErrorToken(position, "Lexer Error: " + message + " at column " + position + " in expression [" + this.input + "]");
      };
      return _Scanner;
  }());
  /**
   * @param {?} code
   * @return {?}
   */
  function isIdentifierStart(code) {
      return ($a <= code && code <= $z) || ($A <= code && code <= $Z) ||
          (code == $_) || (code == $$);
  }
  /**
   * @param {?} input
   * @return {?}
   */
  function isIdentifier(input) {
      if (input.length == 0)
          return false;
      var /** @type {?} */ scanner = new _Scanner(input);
      if (!isIdentifierStart(scanner.peek))
          return false;
      scanner.advance();
      while (scanner.peek !== $EOF) {
          if (!isIdentifierPart(scanner.peek))
              return false;
          scanner.advance();
      }
      return true;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isIdentifierPart(code) {
      return isAsciiLetter(code) || isDigit(code) || (code == $_) ||
          (code == $$);
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isExponentStart(code) {
      return code == $e || code == $E;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isExponentSign(code) {
      return code == $MINUS || code == $PLUS;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isQuote(code) {
      return code === $SQ || code === $DQ || code === $BT;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function unescape(code) {
      switch (code) {
          case $n:
              return $LF;
          case $f:
              return $FF;
          case $r:
              return $CR;
          case $t:
              return $TAB;
          case $v:
              return $VTAB;
          default:
              return code;
      }
  }

  var SplitInterpolation = (function () {
      /**
       * @param {?} strings
       * @param {?} expressions
       * @param {?} offsets
       */
      function SplitInterpolation(strings, expressions, offsets) {
          this.strings = strings;
          this.expressions = expressions;
          this.offsets = offsets;
      }
      return SplitInterpolation;
  }());
  var TemplateBindingParseResult = (function () {
      /**
       * @param {?} templateBindings
       * @param {?} warnings
       * @param {?} errors
       */
      function TemplateBindingParseResult(templateBindings, warnings, errors) {
          this.templateBindings = templateBindings;
          this.warnings = warnings;
          this.errors = errors;
      }
      return TemplateBindingParseResult;
  }());
  /**
   * @param {?} config
   * @return {?}
   */
  function _createInterpolateRegExp(config) {
      var /** @type {?} */ pattern = escapeRegExp(config.start) + '([\\s\\S]*?)' + escapeRegExp(config.end);
      return new RegExp(pattern, 'g');
  }
  var Parser = (function () {
      /**
       * @param {?} _lexer
       */
      function Parser(_lexer) {
          this._lexer = _lexer;
          this.errors = [];
      }
      /**
       * @param {?} input
       * @param {?} location
       * @param {?=} interpolationConfig
       * @return {?}
       */
      Parser.prototype.parseAction = function (input, location, interpolationConfig) {
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          this._checkNoInterpolation(input, location, interpolationConfig);
          var /** @type {?} */ sourceToLex = this._stripComments(input);
          var /** @type {?} */ tokens = this._lexer.tokenize(this._stripComments(input));
          var /** @type {?} */ ast = new _ParseAST(input, location, tokens, sourceToLex.length, true, this.errors, input.length - sourceToLex.length)
              .parseChain();
          return new ASTWithSource(ast, input, location, this.errors);
      };
      /**
       * @param {?} input
       * @param {?} location
       * @param {?=} interpolationConfig
       * @return {?}
       */
      Parser.prototype.parseBinding = function (input, location, interpolationConfig) {
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          var /** @type {?} */ ast = this._parseBindingAst(input, location, interpolationConfig);
          return new ASTWithSource(ast, input, location, this.errors);
      };
      /**
       * @param {?} input
       * @param {?} location
       * @param {?=} interpolationConfig
       * @return {?}
       */
      Parser.prototype.parseSimpleBinding = function (input, location, interpolationConfig) {
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          var /** @type {?} */ ast = this._parseBindingAst(input, location, interpolationConfig);
          var /** @type {?} */ errors = SimpleExpressionChecker.check(ast);
          if (errors.length > 0) {
              this._reportError("Host binding expression cannot contain " + errors.join(' '), input, location);
          }
          return new ASTWithSource(ast, input, location, this.errors);
      };
      /**
       * @param {?} message
       * @param {?} input
       * @param {?} errLocation
       * @param {?=} ctxLocation
       * @return {?}
       */
      Parser.prototype._reportError = function (message, input, errLocation, ctxLocation) {
          this.errors.push(new ParserError(message, input, errLocation, ctxLocation));
      };
      /**
       * @param {?} input
       * @param {?} location
       * @param {?} interpolationConfig
       * @return {?}
       */
      Parser.prototype._parseBindingAst = function (input, location, interpolationConfig) {
          // Quotes expressions use 3rd-party expression language. We don't want to use
          // our lexer or parser for that, so we check for that ahead of time.
          var /** @type {?} */ quote = this._parseQuote(input, location);
          if (isPresent(quote)) {
              return quote;
          }
          this._checkNoInterpolation(input, location, interpolationConfig);
          var /** @type {?} */ sourceToLex = this._stripComments(input);
          var /** @type {?} */ tokens = this._lexer.tokenize(sourceToLex);
          return new _ParseAST(input, location, tokens, sourceToLex.length, false, this.errors, input.length - sourceToLex.length)
              .parseChain();
      };
      /**
       * @param {?} input
       * @param {?} location
       * @return {?}
       */
      Parser.prototype._parseQuote = function (input, location) {
          if (isBlank(input))
              return null;
          var /** @type {?} */ prefixSeparatorIndex = input.indexOf(':');
          if (prefixSeparatorIndex == -1)
              return null;
          var /** @type {?} */ prefix = input.substring(0, prefixSeparatorIndex).trim();
          if (!isIdentifier(prefix))
              return null;
          var /** @type {?} */ uninterpretedExpression = input.substring(prefixSeparatorIndex + 1);
          return new Quote(new ParseSpan(0, input.length), prefix, uninterpretedExpression, location);
      };
      /**
       * @param {?} prefixToken
       * @param {?} input
       * @param {?} location
       * @return {?}
       */
      Parser.prototype.parseTemplateBindings = function (prefixToken, input, location) {
          var /** @type {?} */ tokens = this._lexer.tokenize(input);
          if (prefixToken) {
              // Prefix the tokens with the tokens from prefixToken but have them take no space (0 index).
              var /** @type {?} */ prefixTokens = this._lexer.tokenize(prefixToken).map(function (t) {
                  t.index = 0;
                  return t;
              });
              tokens.unshift.apply(tokens, prefixTokens);
          }
          return new _ParseAST(input, location, tokens, input.length, false, this.errors, 0)
              .parseTemplateBindings();
      };
      /**
       * @param {?} input
       * @param {?} location
       * @param {?=} interpolationConfig
       * @return {?}
       */
      Parser.prototype.parseInterpolation = function (input, location, interpolationConfig) {
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          var /** @type {?} */ split = this.splitInterpolation(input, location, interpolationConfig);
          if (split == null)
              return null;
          var /** @type {?} */ expressions = [];
          for (var /** @type {?} */ i = 0; i < split.expressions.length; ++i) {
              var /** @type {?} */ expressionText = split.expressions[i];
              var /** @type {?} */ sourceToLex = this._stripComments(expressionText);
              var /** @type {?} */ tokens = this._lexer.tokenize(this._stripComments(split.expressions[i]));
              var /** @type {?} */ ast = new _ParseAST(input, location, tokens, sourceToLex.length, false, this.errors, split.offsets[i] + (expressionText.length - sourceToLex.length))
                  .parseChain();
              expressions.push(ast);
          }
          return new ASTWithSource(new Interpolation(new ParseSpan(0, isBlank(input) ? 0 : input.length), split.strings, expressions), input, location, this.errors);
      };
      /**
       * @param {?} input
       * @param {?} location
       * @param {?=} interpolationConfig
       * @return {?}
       */
      Parser.prototype.splitInterpolation = function (input, location, interpolationConfig) {
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          var /** @type {?} */ regexp = _createInterpolateRegExp(interpolationConfig);
          var /** @type {?} */ parts = input.split(regexp);
          if (parts.length <= 1) {
              return null;
          }
          var /** @type {?} */ strings = [];
          var /** @type {?} */ expressions = [];
          var /** @type {?} */ offsets = [];
          var /** @type {?} */ offset = 0;
          for (var /** @type {?} */ i = 0; i < parts.length; i++) {
              var /** @type {?} */ part = parts[i];
              if (i % 2 === 0) {
                  // fixed string
                  strings.push(part);
                  offset += part.length;
              }
              else if (part.trim().length > 0) {
                  offset += interpolationConfig.start.length;
                  expressions.push(part);
                  offsets.push(offset);
                  offset += part.length + interpolationConfig.end.length;
              }
              else {
                  this._reportError('Blank expressions are not allowed in interpolated strings', input, "at column " + this._findInterpolationErrorColumn(parts, i, interpolationConfig) + " in", location);
                  expressions.push('$implict');
                  offsets.push(offset);
              }
          }
          return new SplitInterpolation(strings, expressions, offsets);
      };
      /**
       * @param {?} input
       * @param {?} location
       * @return {?}
       */
      Parser.prototype.wrapLiteralPrimitive = function (input, location) {
          return new ASTWithSource(new LiteralPrimitive(new ParseSpan(0, isBlank(input) ? 0 : input.length), input), input, location, this.errors);
      };
      /**
       * @param {?} input
       * @return {?}
       */
      Parser.prototype._stripComments = function (input) {
          var /** @type {?} */ i = this._commentStart(input);
          return isPresent(i) ? input.substring(0, i).trim() : input;
      };
      /**
       * @param {?} input
       * @return {?}
       */
      Parser.prototype._commentStart = function (input) {
          var /** @type {?} */ outerQuote = null;
          for (var /** @type {?} */ i = 0; i < input.length - 1; i++) {
              var /** @type {?} */ char = input.charCodeAt(i);
              var /** @type {?} */ nextChar = input.charCodeAt(i + 1);
              if (char === $SLASH && nextChar == $SLASH && isBlank(outerQuote))
                  return i;
              if (outerQuote === char) {
                  outerQuote = null;
              }
              else if (isBlank(outerQuote) && isQuote(char)) {
                  outerQuote = char;
              }
          }
          return null;
      };
      /**
       * @param {?} input
       * @param {?} location
       * @param {?} interpolationConfig
       * @return {?}
       */
      Parser.prototype._checkNoInterpolation = function (input, location, interpolationConfig) {
          var /** @type {?} */ regexp = _createInterpolateRegExp(interpolationConfig);
          var /** @type {?} */ parts = input.split(regexp);
          if (parts.length > 1) {
              this._reportError("Got interpolation (" + interpolationConfig.start + interpolationConfig.end + ") where expression was expected", input, "at column " + this._findInterpolationErrorColumn(parts, 1, interpolationConfig) + " in", location);
          }
      };
      /**
       * @param {?} parts
       * @param {?} partInErrIdx
       * @param {?} interpolationConfig
       * @return {?}
       */
      Parser.prototype._findInterpolationErrorColumn = function (parts, partInErrIdx, interpolationConfig) {
          var /** @type {?} */ errLocation = '';
          for (var /** @type {?} */ j = 0; j < partInErrIdx; j++) {
              errLocation += j % 2 === 0 ?
                  parts[j] :
                  "" + interpolationConfig.start + parts[j] + interpolationConfig.end;
          }
          return errLocation.length;
      };
      Parser.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      Parser.ctorParameters = function () { return [
          { type: Lexer, },
      ]; };
      return Parser;
  }());
  var _ParseAST = (function () {
      /**
       * @param {?} input
       * @param {?} location
       * @param {?} tokens
       * @param {?} inputLength
       * @param {?} parseAction
       * @param {?} errors
       * @param {?} offset
       */
      function _ParseAST(input, location, tokens, inputLength, parseAction, errors, offset) {
          this.input = input;
          this.location = location;
          this.tokens = tokens;
          this.inputLength = inputLength;
          this.parseAction = parseAction;
          this.errors = errors;
          this.offset = offset;
          this.rparensExpected = 0;
          this.rbracketsExpected = 0;
          this.rbracesExpected = 0;
          this.index = 0;
      }
      /**
       * @param {?} offset
       * @return {?}
       */
      _ParseAST.prototype.peek = function (offset) {
          var /** @type {?} */ i = this.index + offset;
          return i < this.tokens.length ? this.tokens[i] : EOF;
      };
      Object.defineProperty(_ParseAST.prototype, "next", {
          /**
           * @return {?}
           */
          get: function () { return this.peek(0); },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(_ParseAST.prototype, "inputIndex", {
          /**
           * @return {?}
           */
          get: function () {
              return (this.index < this.tokens.length) ? this.next.index + this.offset :
                  this.inputLength + this.offset;
          },
          enumerable: true,
          configurable: true
      });
      /**
       * @param {?} start
       * @return {?}
       */
      _ParseAST.prototype.span = function (start) { return new ParseSpan(start, this.inputIndex); };
      /**
       * @return {?}
       */
      _ParseAST.prototype.advance = function () { this.index++; };
      /**
       * @param {?} code
       * @return {?}
       */
      _ParseAST.prototype.optionalCharacter = function (code) {
          if (this.next.isCharacter(code)) {
              this.advance();
              return true;
          }
          else {
              return false;
          }
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.peekKeywordLet = function () { return this.next.isKeywordLet(); };
      /**
       * @param {?} code
       * @return {?}
       */
      _ParseAST.prototype.expectCharacter = function (code) {
          if (this.optionalCharacter(code))
              return;
          this.error("Missing expected " + String.fromCharCode(code));
      };
      /**
       * @param {?} op
       * @return {?}
       */
      _ParseAST.prototype.optionalOperator = function (op) {
          if (this.next.isOperator(op)) {
              this.advance();
              return true;
          }
          else {
              return false;
          }
      };
      /**
       * @param {?} operator
       * @return {?}
       */
      _ParseAST.prototype.expectOperator = function (operator) {
          if (this.optionalOperator(operator))
              return;
          this.error("Missing expected operator " + operator);
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.expectIdentifierOrKeyword = function () {
          var /** @type {?} */ n = this.next;
          if (!n.isIdentifier() && !n.isKeyword()) {
              this.error("Unexpected token " + n + ", expected identifier or keyword");
              return '';
          }
          this.advance();
          return n.toString();
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.expectIdentifierOrKeywordOrString = function () {
          var /** @type {?} */ n = this.next;
          if (!n.isIdentifier() && !n.isKeyword() && !n.isString()) {
              this.error("Unexpected token " + n + ", expected identifier, keyword, or string");
              return '';
          }
          this.advance();
          return n.toString();
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseChain = function () {
          var /** @type {?} */ exprs = [];
          var /** @type {?} */ start = this.inputIndex;
          while (this.index < this.tokens.length) {
              var /** @type {?} */ expr = this.parsePipe();
              exprs.push(expr);
              if (this.optionalCharacter($SEMICOLON)) {
                  if (!this.parseAction) {
                      this.error('Binding expression cannot contain chained expression');
                  }
                  while (this.optionalCharacter($SEMICOLON)) {
                  } // read all semicolons
              }
              else if (this.index < this.tokens.length) {
                  this.error("Unexpected token '" + this.next + "'");
              }
          }
          if (exprs.length == 0)
              return new EmptyExpr(this.span(start));
          if (exprs.length == 1)
              return exprs[0];
          return new Chain(this.span(start), exprs);
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parsePipe = function () {
          var /** @type {?} */ result = this.parseExpression();
          if (this.optionalOperator('|')) {
              if (this.parseAction) {
                  this.error('Cannot have a pipe in an action expression');
              }
              do {
                  var /** @type {?} */ name_1 = this.expectIdentifierOrKeyword();
                  var /** @type {?} */ args = [];
                  while (this.optionalCharacter($COLON)) {
                      args.push(this.parseExpression());
                  }
                  result = new BindingPipe(this.span(result.span.start - this.offset), result, name_1, args);
              } while (this.optionalOperator('|'));
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseExpression = function () { return this.parseConditional(); };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseConditional = function () {
          var /** @type {?} */ start = this.inputIndex;
          var /** @type {?} */ result = this.parseLogicalOr();
          if (this.optionalOperator('?')) {
              var /** @type {?} */ yes = this.parsePipe();
              var /** @type {?} */ no = void 0;
              if (!this.optionalCharacter($COLON)) {
                  var /** @type {?} */ end = this.inputIndex;
                  var /** @type {?} */ expression = this.input.substring(start, end);
                  this.error("Conditional expression " + expression + " requires all 3 expressions");
                  no = new EmptyExpr(this.span(start));
              }
              else {
                  no = this.parsePipe();
              }
              return new Conditional(this.span(start), result, yes, no);
          }
          else {
              return result;
          }
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseLogicalOr = function () {
          // '||'
          var /** @type {?} */ result = this.parseLogicalAnd();
          while (this.optionalOperator('||')) {
              var /** @type {?} */ right = this.parseLogicalAnd();
              result = new Binary(this.span(result.span.start), '||', result, right);
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseLogicalAnd = function () {
          // '&&'
          var /** @type {?} */ result = this.parseEquality();
          while (this.optionalOperator('&&')) {
              var /** @type {?} */ right = this.parseEquality();
              result = new Binary(this.span(result.span.start), '&&', result, right);
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseEquality = function () {
          // '==','!=','===','!=='
          var /** @type {?} */ result = this.parseRelational();
          while (this.next.type == TokenType.Operator) {
              var /** @type {?} */ operator = this.next.strValue;
              switch (operator) {
                  case '==':
                  case '===':
                  case '!=':
                  case '!==':
                      this.advance();
                      var /** @type {?} */ right = this.parseRelational();
                      result = new Binary(this.span(result.span.start), operator, result, right);
                      continue;
              }
              break;
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseRelational = function () {
          // '<', '>', '<=', '>='
          var /** @type {?} */ result = this.parseAdditive();
          while (this.next.type == TokenType.Operator) {
              var /** @type {?} */ operator = this.next.strValue;
              switch (operator) {
                  case '<':
                  case '>':
                  case '<=':
                  case '>=':
                      this.advance();
                      var /** @type {?} */ right = this.parseAdditive();
                      result = new Binary(this.span(result.span.start), operator, result, right);
                      continue;
              }
              break;
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseAdditive = function () {
          // '+', '-'
          var /** @type {?} */ result = this.parseMultiplicative();
          while (this.next.type == TokenType.Operator) {
              var /** @type {?} */ operator = this.next.strValue;
              switch (operator) {
                  case '+':
                  case '-':
                      this.advance();
                      var /** @type {?} */ right = this.parseMultiplicative();
                      result = new Binary(this.span(result.span.start), operator, result, right);
                      continue;
              }
              break;
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseMultiplicative = function () {
          // '*', '%', '/'
          var /** @type {?} */ result = this.parsePrefix();
          while (this.next.type == TokenType.Operator) {
              var /** @type {?} */ operator = this.next.strValue;
              switch (operator) {
                  case '*':
                  case '%':
                  case '/':
                      this.advance();
                      var /** @type {?} */ right = this.parsePrefix();
                      result = new Binary(this.span(result.span.start), operator, result, right);
                      continue;
              }
              break;
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parsePrefix = function () {
          if (this.next.type == TokenType.Operator) {
              var /** @type {?} */ start = this.inputIndex;
              var /** @type {?} */ operator = this.next.strValue;
              var /** @type {?} */ result = void 0;
              switch (operator) {
                  case '+':
                      this.advance();
                      return this.parsePrefix();
                  case '-':
                      this.advance();
                      result = this.parsePrefix();
                      return new Binary(this.span(start), operator, new LiteralPrimitive(new ParseSpan(start, start), 0), result);
                  case '!':
                      this.advance();
                      result = this.parsePrefix();
                      return new PrefixNot(this.span(start), result);
              }
          }
          return this.parseCallChain();
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseCallChain = function () {
          var /** @type {?} */ result = this.parsePrimary();
          while (true) {
              if (this.optionalCharacter($PERIOD)) {
                  result = this.parseAccessMemberOrMethodCall(result, false);
              }
              else if (this.optionalOperator('?.')) {
                  result = this.parseAccessMemberOrMethodCall(result, true);
              }
              else if (this.optionalCharacter($LBRACKET)) {
                  this.rbracketsExpected++;
                  var /** @type {?} */ key = this.parsePipe();
                  this.rbracketsExpected--;
                  this.expectCharacter($RBRACKET);
                  if (this.optionalOperator('=')) {
                      var /** @type {?} */ value = this.parseConditional();
                      result = new KeyedWrite(this.span(result.span.start), result, key, value);
                  }
                  else {
                      result = new KeyedRead(this.span(result.span.start), result, key);
                  }
              }
              else if (this.optionalCharacter($LPAREN)) {
                  this.rparensExpected++;
                  var /** @type {?} */ args = this.parseCallArguments();
                  this.rparensExpected--;
                  this.expectCharacter($RPAREN);
                  result = new FunctionCall(this.span(result.span.start), result, args);
              }
              else {
                  return result;
              }
          }
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parsePrimary = function () {
          var /** @type {?} */ start = this.inputIndex;
          if (this.optionalCharacter($LPAREN)) {
              this.rparensExpected++;
              var /** @type {?} */ result = this.parsePipe();
              this.rparensExpected--;
              this.expectCharacter($RPAREN);
              return result;
          }
          else if (this.next.isKeywordNull()) {
              this.advance();
              return new LiteralPrimitive(this.span(start), null);
          }
          else if (this.next.isKeywordUndefined()) {
              this.advance();
              return new LiteralPrimitive(this.span(start), void 0);
          }
          else if (this.next.isKeywordTrue()) {
              this.advance();
              return new LiteralPrimitive(this.span(start), true);
          }
          else if (this.next.isKeywordFalse()) {
              this.advance();
              return new LiteralPrimitive(this.span(start), false);
          }
          else if (this.next.isKeywordThis()) {
              this.advance();
              return new ImplicitReceiver(this.span(start));
          }
          else if (this.optionalCharacter($LBRACKET)) {
              this.rbracketsExpected++;
              var /** @type {?} */ elements = this.parseExpressionList($RBRACKET);
              this.rbracketsExpected--;
              this.expectCharacter($RBRACKET);
              return new LiteralArray(this.span(start), elements);
          }
          else if (this.next.isCharacter($LBRACE)) {
              return this.parseLiteralMap();
          }
          else if (this.next.isIdentifier()) {
              return this.parseAccessMemberOrMethodCall(new ImplicitReceiver(this.span(start)), false);
          }
          else if (this.next.isNumber()) {
              var /** @type {?} */ value = this.next.toNumber();
              this.advance();
              return new LiteralPrimitive(this.span(start), value);
          }
          else if (this.next.isString()) {
              var /** @type {?} */ literalValue = this.next.toString();
              this.advance();
              return new LiteralPrimitive(this.span(start), literalValue);
          }
          else if (this.index >= this.tokens.length) {
              this.error("Unexpected end of expression: " + this.input);
              return new EmptyExpr(this.span(start));
          }
          else {
              this.error("Unexpected token " + this.next);
              return new EmptyExpr(this.span(start));
          }
      };
      /**
       * @param {?} terminator
       * @return {?}
       */
      _ParseAST.prototype.parseExpressionList = function (terminator) {
          var /** @type {?} */ result = [];
          if (!this.next.isCharacter(terminator)) {
              do {
                  result.push(this.parsePipe());
              } while (this.optionalCharacter($COMMA));
          }
          return result;
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseLiteralMap = function () {
          var /** @type {?} */ keys = [];
          var /** @type {?} */ values = [];
          var /** @type {?} */ start = this.inputIndex;
          this.expectCharacter($LBRACE);
          if (!this.optionalCharacter($RBRACE)) {
              this.rbracesExpected++;
              do {
                  var /** @type {?} */ key = this.expectIdentifierOrKeywordOrString();
                  keys.push(key);
                  this.expectCharacter($COLON);
                  values.push(this.parsePipe());
              } while (this.optionalCharacter($COMMA));
              this.rbracesExpected--;
              this.expectCharacter($RBRACE);
          }
          return new LiteralMap(this.span(start), keys, values);
      };
      /**
       * @param {?} receiver
       * @param {?=} isSafe
       * @return {?}
       */
      _ParseAST.prototype.parseAccessMemberOrMethodCall = function (receiver, isSafe) {
          if (isSafe === void 0) { isSafe = false; }
          var /** @type {?} */ start = receiver.span.start;
          var /** @type {?} */ id = this.expectIdentifierOrKeyword();
          if (this.optionalCharacter($LPAREN)) {
              this.rparensExpected++;
              var /** @type {?} */ args = this.parseCallArguments();
              this.expectCharacter($RPAREN);
              this.rparensExpected--;
              var /** @type {?} */ span = this.span(start);
              return isSafe ? new SafeMethodCall(span, receiver, id, args) :
                  new MethodCall(span, receiver, id, args);
          }
          else {
              if (isSafe) {
                  if (this.optionalOperator('=')) {
                      this.error('The \'?.\' operator cannot be used in the assignment');
                      return new EmptyExpr(this.span(start));
                  }
                  else {
                      return new SafePropertyRead(this.span(start), receiver, id);
                  }
              }
              else {
                  if (this.optionalOperator('=')) {
                      if (!this.parseAction) {
                          this.error('Bindings cannot contain assignments');
                          return new EmptyExpr(this.span(start));
                      }
                      var /** @type {?} */ value = this.parseConditional();
                      return new PropertyWrite(this.span(start), receiver, id, value);
                  }
                  else {
                      return new PropertyRead(this.span(start), receiver, id);
                  }
              }
          }
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseCallArguments = function () {
          if (this.next.isCharacter($RPAREN))
              return [];
          var /** @type {?} */ positionals = [];
          do {
              positionals.push(this.parsePipe());
          } while (this.optionalCharacter($COMMA));
          return (positionals);
      };
      /**
       *  An identifier, a keyword, a string with an optional `-` inbetween.
       * @return {?}
       */
      _ParseAST.prototype.expectTemplateBindingKey = function () {
          var /** @type {?} */ result = '';
          var /** @type {?} */ operatorFound = false;
          do {
              result += this.expectIdentifierOrKeywordOrString();
              operatorFound = this.optionalOperator('-');
              if (operatorFound) {
                  result += '-';
              }
          } while (operatorFound);
          return result.toString();
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.parseTemplateBindings = function () {
          var /** @type {?} */ bindings = [];
          var /** @type {?} */ prefix = null;
          var /** @type {?} */ warnings = [];
          while (this.index < this.tokens.length) {
              var /** @type {?} */ start = this.inputIndex;
              var /** @type {?} */ keyIsVar = this.peekKeywordLet();
              if (keyIsVar) {
                  this.advance();
              }
              var /** @type {?} */ key = this.expectTemplateBindingKey();
              if (!keyIsVar) {
                  if (prefix == null) {
                      prefix = key;
                  }
                  else {
                      key = prefix + key[0].toUpperCase() + key.substring(1);
                  }
              }
              this.optionalCharacter($COLON);
              var /** @type {?} */ name_2 = null;
              var /** @type {?} */ expression = null;
              if (keyIsVar) {
                  if (this.optionalOperator('=')) {
                      name_2 = this.expectTemplateBindingKey();
                  }
                  else {
                      name_2 = '\$implicit';
                  }
              }
              else if (this.next !== EOF && !this.peekKeywordLet()) {
                  var /** @type {?} */ start_1 = this.inputIndex;
                  var /** @type {?} */ ast = this.parsePipe();
                  var /** @type {?} */ source = this.input.substring(start_1 - this.offset, this.inputIndex - this.offset);
                  expression = new ASTWithSource(ast, source, this.location, this.errors);
              }
              bindings.push(new TemplateBinding(this.span(start), key, keyIsVar, name_2, expression));
              if (!this.optionalCharacter($SEMICOLON)) {
                  this.optionalCharacter($COMMA);
              }
          }
          return new TemplateBindingParseResult(bindings, warnings, this.errors);
      };
      /**
       * @param {?} message
       * @param {?=} index
       * @return {?}
       */
      _ParseAST.prototype.error = function (message, index) {
          if (index === void 0) { index = null; }
          this.errors.push(new ParserError(message, this.input, this.locationText(index), this.location));
          this.skip();
      };
      /**
       * @param {?=} index
       * @return {?}
       */
      _ParseAST.prototype.locationText = function (index) {
          if (index === void 0) { index = null; }
          if (isBlank(index))
              index = this.index;
          return (index < this.tokens.length) ? "at column " + (this.tokens[index].index + 1) + " in" :
              "at the end of the expression";
      };
      /**
       * @return {?}
       */
      _ParseAST.prototype.skip = function () {
          var /** @type {?} */ n = this.next;
          while (this.index < this.tokens.length && !n.isCharacter($SEMICOLON) &&
              (this.rparensExpected <= 0 || !n.isCharacter($RPAREN)) &&
              (this.rbracesExpected <= 0 || !n.isCharacter($RBRACE)) &&
              (this.rbracketsExpected <= 0 || !n.isCharacter($RBRACKET))) {
              if (this.next.isError()) {
                  this.errors.push(new ParserError(this.next.toString(), this.input, this.locationText(), this.location));
              }
              this.advance();
              n = this.next;
          }
      };
      return _ParseAST;
  }());
  var SimpleExpressionChecker = (function () {
      function SimpleExpressionChecker() {
          this.errors = [];
      }
      /**
       * @param {?} ast
       * @return {?}
       */
      SimpleExpressionChecker.check = function (ast) {
          var /** @type {?} */ s = new SimpleExpressionChecker();
          ast.visit(s);
          return s.errors;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitImplicitReceiver = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitInterpolation = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitLiteralPrimitive = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitPropertyRead = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitPropertyWrite = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitSafePropertyRead = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitMethodCall = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitSafeMethodCall = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitFunctionCall = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitLiteralArray = function (ast, context) { this.visitAll(ast.expressions); };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitLiteralMap = function (ast, context) { this.visitAll(ast.values); };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitBinary = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitPrefixNot = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitConditional = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitPipe = function (ast, context) { this.errors.push('pipes'); };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitKeyedRead = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitKeyedWrite = function (ast, context) { };
      /**
       * @param {?} asts
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitAll = function (asts) {
          var _this = this;
          return asts.map(function (node) { return node.visit(_this); });
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitChain = function (ast, context) { };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      SimpleExpressionChecker.prototype.visitQuote = function (ast, context) { };
      return SimpleExpressionChecker;
  }());

  var ParseLocation = (function () {
      /**
       * @param {?} file
       * @param {?} offset
       * @param {?} line
       * @param {?} col
       */
      function ParseLocation(file, offset, line, col) {
          this.file = file;
          this.offset = offset;
          this.line = line;
          this.col = col;
      }
      /**
       * @return {?}
       */
      ParseLocation.prototype.toString = function () {
          return isPresent(this.offset) ? this.file.url + "@" + this.line + ":" + this.col : this.file.url;
      };
      return ParseLocation;
  }());
  var ParseSourceFile = (function () {
      /**
       * @param {?} content
       * @param {?} url
       */
      function ParseSourceFile(content, url) {
          this.content = content;
          this.url = url;
      }
      return ParseSourceFile;
  }());
  var ParseSourceSpan = (function () {
      /**
       * @param {?} start
       * @param {?} end
       * @param {?=} details
       */
      function ParseSourceSpan(start, end, details) {
          if (details === void 0) { details = null; }
          this.start = start;
          this.end = end;
          this.details = details;
      }
      /**
       * @return {?}
       */
      ParseSourceSpan.prototype.toString = function () {
          return this.start.file.content.substring(this.start.offset, this.end.offset);
      };
      return ParseSourceSpan;
  }());
  var ParseErrorLevel = {};
  ParseErrorLevel.WARNING = 0;
  ParseErrorLevel.FATAL = 1;
  ParseErrorLevel[ParseErrorLevel.WARNING] = "WARNING";
  ParseErrorLevel[ParseErrorLevel.FATAL] = "FATAL";
  var ParseError = (function () {
      /**
       * @param {?} span
       * @param {?} msg
       * @param {?=} level
       */
      function ParseError(span, msg, level) {
          if (level === void 0) { level = ParseErrorLevel.FATAL; }
          this.span = span;
          this.msg = msg;
          this.level = level;
      }
      /**
       * @return {?}
       */
      ParseError.prototype.toString = function () {
          var /** @type {?} */ source = this.span.start.file.content;
          var /** @type {?} */ ctxStart = this.span.start.offset;
          var /** @type {?} */ contextStr = '';
          var /** @type {?} */ details = '';
          if (isPresent(ctxStart)) {
              if (ctxStart > source.length - 1) {
                  ctxStart = source.length - 1;
              }
              var /** @type {?} */ ctxEnd = ctxStart;
              var /** @type {?} */ ctxLen = 0;
              var /** @type {?} */ ctxLines = 0;
              while (ctxLen < 100 && ctxStart > 0) {
                  ctxStart--;
                  ctxLen++;
                  if (source[ctxStart] == '\n') {
                      if (++ctxLines == 3) {
                          break;
                      }
                  }
              }
              ctxLen = 0;
              ctxLines = 0;
              while (ctxLen < 100 && ctxEnd < source.length - 1) {
                  ctxEnd++;
                  ctxLen++;
                  if (source[ctxEnd] == '\n') {
                      if (++ctxLines == 3) {
                          break;
                      }
                  }
              }
              var /** @type {?} */ context = source.substring(ctxStart, this.span.start.offset) + '[ERROR ->]' +
                  source.substring(this.span.start.offset, ctxEnd + 1);
              contextStr = " (\"" + context + "\")";
          }
          if (this.span.details) {
              details = ", " + this.span.details;
          }
          return "" + this.msg + contextStr + ": " + this.span.start + details;
      };
      return ParseError;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var Text = (function () {
      /**
       * @param {?} value
       * @param {?} sourceSpan
       */
      function Text(value, sourceSpan) {
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Text.prototype.visit = function (visitor, context) { return visitor.visitText(this, context); };
      return Text;
  }());
  var Expansion = (function () {
      /**
       * @param {?} switchValue
       * @param {?} type
       * @param {?} cases
       * @param {?} sourceSpan
       * @param {?} switchValueSourceSpan
       */
      function Expansion(switchValue, type, cases, sourceSpan, switchValueSourceSpan) {
          this.switchValue = switchValue;
          this.type = type;
          this.cases = cases;
          this.sourceSpan = sourceSpan;
          this.switchValueSourceSpan = switchValueSourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Expansion.prototype.visit = function (visitor, context) { return visitor.visitExpansion(this, context); };
      return Expansion;
  }());
  var ExpansionCase = (function () {
      /**
       * @param {?} value
       * @param {?} expression
       * @param {?} sourceSpan
       * @param {?} valueSourceSpan
       * @param {?} expSourceSpan
       */
      function ExpansionCase(value, expression, sourceSpan, valueSourceSpan, expSourceSpan) {
          this.value = value;
          this.expression = expression;
          this.sourceSpan = sourceSpan;
          this.valueSourceSpan = valueSourceSpan;
          this.expSourceSpan = expSourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ExpansionCase.prototype.visit = function (visitor, context) { return visitor.visitExpansionCase(this, context); };
      return ExpansionCase;
  }());
  var Attribute$1 = (function () {
      /**
       * @param {?} name
       * @param {?} value
       * @param {?} sourceSpan
       * @param {?=} valueSpan
       */
      function Attribute(name, value, sourceSpan, valueSpan) {
          this.name = name;
          this.value = value;
          this.sourceSpan = sourceSpan;
          this.valueSpan = valueSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Attribute.prototype.visit = function (visitor, context) { return visitor.visitAttribute(this, context); };
      return Attribute;
  }());
  var Element = (function () {
      /**
       * @param {?} name
       * @param {?} attrs
       * @param {?} children
       * @param {?} sourceSpan
       * @param {?} startSourceSpan
       * @param {?} endSourceSpan
       */
      function Element(name, attrs, children, sourceSpan, startSourceSpan, endSourceSpan) {
          this.name = name;
          this.attrs = attrs;
          this.children = children;
          this.sourceSpan = sourceSpan;
          this.startSourceSpan = startSourceSpan;
          this.endSourceSpan = endSourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Element.prototype.visit = function (visitor, context) { return visitor.visitElement(this, context); };
      return Element;
  }());
  var Comment = (function () {
      /**
       * @param {?} value
       * @param {?} sourceSpan
       */
      function Comment(value, sourceSpan) {
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Comment.prototype.visit = function (visitor, context) { return visitor.visitComment(this, context); };
      return Comment;
  }());
  /**
   * @param {?} visitor
   * @param {?} nodes
   * @param {?=} context
   * @return {?}
   */
  function visitAll(visitor, nodes, context) {
      if (context === void 0) { context = null; }
      var /** @type {?} */ result = [];
      var /** @type {?} */ visit = visitor.visit ?
          function (ast) { return visitor.visit(ast, context) || ast.visit(visitor, context); } :
          function (ast) { return ast.visit(visitor, context); };
      nodes.forEach(function (ast) {
          var /** @type {?} */ astResult = visit(ast);
          if (astResult) {
              result.push(astResult);
          }
      });
      return result;
  }

  var TagContentType = {};
  TagContentType.RAW_TEXT = 0;
  TagContentType.ESCAPABLE_RAW_TEXT = 1;
  TagContentType.PARSABLE_DATA = 2;
  TagContentType[TagContentType.RAW_TEXT] = "RAW_TEXT";
  TagContentType[TagContentType.ESCAPABLE_RAW_TEXT] = "ESCAPABLE_RAW_TEXT";
  TagContentType[TagContentType.PARSABLE_DATA] = "PARSABLE_DATA";
  /**
   * @param {?} elementName
   * @return {?}
   */
  function splitNsName(elementName) {
      if (elementName[0] != ':') {
          return [null, elementName];
      }
      var /** @type {?} */ colonIndex = elementName.indexOf(':', 1);
      if (colonIndex == -1) {
          throw new Error("Unsupported format \"" + elementName + "\" expecting \":namespace:name\"");
      }
      return [elementName.slice(1, colonIndex), elementName.slice(colonIndex + 1)];
  }
  /**
   * @param {?} fullName
   * @return {?}
   */
  function getNsPrefix(fullName) {
      return fullName === null ? null : splitNsName(fullName)[0];
  }
  /**
   * @param {?} prefix
   * @param {?} localName
   * @return {?}
   */
  function mergeNsAndName(prefix, localName) {
      return prefix ? ":" + prefix + ":" + localName : localName;
  }
  // see http://www.w3.org/TR/html51/syntax.html#named-character-references
  // see https://html.spec.whatwg.org/multipage/entities.json
  // This list is not exhaustive to keep the compiler footprint low.
  // The `&#123;` / `&#x1ab;` syntax should be used when the named character reference does not exist.
  var /** @type {?} */ NAMED_ENTITIES = {
      'Aacute': '\u00C1',
      'aacute': '\u00E1',
      'Acirc': '\u00C2',
      'acirc': '\u00E2',
      'acute': '\u00B4',
      'AElig': '\u00C6',
      'aelig': '\u00E6',
      'Agrave': '\u00C0',
      'agrave': '\u00E0',
      'alefsym': '\u2135',
      'Alpha': '\u0391',
      'alpha': '\u03B1',
      'amp': '&',
      'and': '\u2227',
      'ang': '\u2220',
      'apos': '\u0027',
      'Aring': '\u00C5',
      'aring': '\u00E5',
      'asymp': '\u2248',
      'Atilde': '\u00C3',
      'atilde': '\u00E3',
      'Auml': '\u00C4',
      'auml': '\u00E4',
      'bdquo': '\u201E',
      'Beta': '\u0392',
      'beta': '\u03B2',
      'brvbar': '\u00A6',
      'bull': '\u2022',
      'cap': '\u2229',
      'Ccedil': '\u00C7',
      'ccedil': '\u00E7',
      'cedil': '\u00B8',
      'cent': '\u00A2',
      'Chi': '\u03A7',
      'chi': '\u03C7',
      'circ': '\u02C6',
      'clubs': '\u2663',
      'cong': '\u2245',
      'copy': '\u00A9',
      'crarr': '\u21B5',
      'cup': '\u222A',
      'curren': '\u00A4',
      'dagger': '\u2020',
      'Dagger': '\u2021',
      'darr': '\u2193',
      'dArr': '\u21D3',
      'deg': '\u00B0',
      'Delta': '\u0394',
      'delta': '\u03B4',
      'diams': '\u2666',
      'divide': '\u00F7',
      'Eacute': '\u00C9',
      'eacute': '\u00E9',
      'Ecirc': '\u00CA',
      'ecirc': '\u00EA',
      'Egrave': '\u00C8',
      'egrave': '\u00E8',
      'empty': '\u2205',
      'emsp': '\u2003',
      'ensp': '\u2002',
      'Epsilon': '\u0395',
      'epsilon': '\u03B5',
      'equiv': '\u2261',
      'Eta': '\u0397',
      'eta': '\u03B7',
      'ETH': '\u00D0',
      'eth': '\u00F0',
      'Euml': '\u00CB',
      'euml': '\u00EB',
      'euro': '\u20AC',
      'exist': '\u2203',
      'fnof': '\u0192',
      'forall': '\u2200',
      'frac12': '\u00BD',
      'frac14': '\u00BC',
      'frac34': '\u00BE',
      'frasl': '\u2044',
      'Gamma': '\u0393',
      'gamma': '\u03B3',
      'ge': '\u2265',
      'gt': '>',
      'harr': '\u2194',
      'hArr': '\u21D4',
      'hearts': '\u2665',
      'hellip': '\u2026',
      'Iacute': '\u00CD',
      'iacute': '\u00ED',
      'Icirc': '\u00CE',
      'icirc': '\u00EE',
      'iexcl': '\u00A1',
      'Igrave': '\u00CC',
      'igrave': '\u00EC',
      'image': '\u2111',
      'infin': '\u221E',
      'int': '\u222B',
      'Iota': '\u0399',
      'iota': '\u03B9',
      'iquest': '\u00BF',
      'isin': '\u2208',
      'Iuml': '\u00CF',
      'iuml': '\u00EF',
      'Kappa': '\u039A',
      'kappa': '\u03BA',
      'Lambda': '\u039B',
      'lambda': '\u03BB',
      'lang': '\u27E8',
      'laquo': '\u00AB',
      'larr': '\u2190',
      'lArr': '\u21D0',
      'lceil': '\u2308',
      'ldquo': '\u201C',
      'le': '\u2264',
      'lfloor': '\u230A',
      'lowast': '\u2217',
      'loz': '\u25CA',
      'lrm': '\u200E',
      'lsaquo': '\u2039',
      'lsquo': '\u2018',
      'lt': '<',
      'macr': '\u00AF',
      'mdash': '\u2014',
      'micro': '\u00B5',
      'middot': '\u00B7',
      'minus': '\u2212',
      'Mu': '\u039C',
      'mu': '\u03BC',
      'nabla': '\u2207',
      'nbsp': '\u00A0',
      'ndash': '\u2013',
      'ne': '\u2260',
      'ni': '\u220B',
      'not': '\u00AC',
      'notin': '\u2209',
      'nsub': '\u2284',
      'Ntilde': '\u00D1',
      'ntilde': '\u00F1',
      'Nu': '\u039D',
      'nu': '\u03BD',
      'Oacute': '\u00D3',
      'oacute': '\u00F3',
      'Ocirc': '\u00D4',
      'ocirc': '\u00F4',
      'OElig': '\u0152',
      'oelig': '\u0153',
      'Ograve': '\u00D2',
      'ograve': '\u00F2',
      'oline': '\u203E',
      'Omega': '\u03A9',
      'omega': '\u03C9',
      'Omicron': '\u039F',
      'omicron': '\u03BF',
      'oplus': '\u2295',
      'or': '\u2228',
      'ordf': '\u00AA',
      'ordm': '\u00BA',
      'Oslash': '\u00D8',
      'oslash': '\u00F8',
      'Otilde': '\u00D5',
      'otilde': '\u00F5',
      'otimes': '\u2297',
      'Ouml': '\u00D6',
      'ouml': '\u00F6',
      'para': '\u00B6',
      'permil': '\u2030',
      'perp': '\u22A5',
      'Phi': '\u03A6',
      'phi': '\u03C6',
      'Pi': '\u03A0',
      'pi': '\u03C0',
      'piv': '\u03D6',
      'plusmn': '\u00B1',
      'pound': '\u00A3',
      'prime': '\u2032',
      'Prime': '\u2033',
      'prod': '\u220F',
      'prop': '\u221D',
      'Psi': '\u03A8',
      'psi': '\u03C8',
      'quot': '\u0022',
      'radic': '\u221A',
      'rang': '\u27E9',
      'raquo': '\u00BB',
      'rarr': '\u2192',
      'rArr': '\u21D2',
      'rceil': '\u2309',
      'rdquo': '\u201D',
      'real': '\u211C',
      'reg': '\u00AE',
      'rfloor': '\u230B',
      'Rho': '\u03A1',
      'rho': '\u03C1',
      'rlm': '\u200F',
      'rsaquo': '\u203A',
      'rsquo': '\u2019',
      'sbquo': '\u201A',
      'Scaron': '\u0160',
      'scaron': '\u0161',
      'sdot': '\u22C5',
      'sect': '\u00A7',
      'shy': '\u00AD',
      'Sigma': '\u03A3',
      'sigma': '\u03C3',
      'sigmaf': '\u03C2',
      'sim': '\u223C',
      'spades': '\u2660',
      'sub': '\u2282',
      'sube': '\u2286',
      'sum': '\u2211',
      'sup': '\u2283',
      'sup1': '\u00B9',
      'sup2': '\u00B2',
      'sup3': '\u00B3',
      'supe': '\u2287',
      'szlig': '\u00DF',
      'Tau': '\u03A4',
      'tau': '\u03C4',
      'there4': '\u2234',
      'Theta': '\u0398',
      'theta': '\u03B8',
      'thetasym': '\u03D1',
      'thinsp': '\u2009',
      'THORN': '\u00DE',
      'thorn': '\u00FE',
      'tilde': '\u02DC',
      'times': '\u00D7',
      'trade': '\u2122',
      'Uacute': '\u00DA',
      'uacute': '\u00FA',
      'uarr': '\u2191',
      'uArr': '\u21D1',
      'Ucirc': '\u00DB',
      'ucirc': '\u00FB',
      'Ugrave': '\u00D9',
      'ugrave': '\u00F9',
      'uml': '\u00A8',
      'upsih': '\u03D2',
      'Upsilon': '\u03A5',
      'upsilon': '\u03C5',
      'Uuml': '\u00DC',
      'uuml': '\u00FC',
      'weierp': '\u2118',
      'Xi': '\u039E',
      'xi': '\u03BE',
      'Yacute': '\u00DD',
      'yacute': '\u00FD',
      'yen': '\u00A5',
      'yuml': '\u00FF',
      'Yuml': '\u0178',
      'Zeta': '\u0396',
      'zeta': '\u03B6',
      'zwj': '\u200D',
      'zwnj': '\u200C',
  };

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$3 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var TokenType$1 = {};
  TokenType$1.TAG_OPEN_START = 0;
  TokenType$1.TAG_OPEN_END = 1;
  TokenType$1.TAG_OPEN_END_VOID = 2;
  TokenType$1.TAG_CLOSE = 3;
  TokenType$1.TEXT = 4;
  TokenType$1.ESCAPABLE_RAW_TEXT = 5;
  TokenType$1.RAW_TEXT = 6;
  TokenType$1.COMMENT_START = 7;
  TokenType$1.COMMENT_END = 8;
  TokenType$1.CDATA_START = 9;
  TokenType$1.CDATA_END = 10;
  TokenType$1.ATTR_NAME = 11;
  TokenType$1.ATTR_VALUE = 12;
  TokenType$1.DOC_TYPE = 13;
  TokenType$1.EXPANSION_FORM_START = 14;
  TokenType$1.EXPANSION_CASE_VALUE = 15;
  TokenType$1.EXPANSION_CASE_EXP_START = 16;
  TokenType$1.EXPANSION_CASE_EXP_END = 17;
  TokenType$1.EXPANSION_FORM_END = 18;
  TokenType$1.EOF = 19;
  TokenType$1[TokenType$1.TAG_OPEN_START] = "TAG_OPEN_START";
  TokenType$1[TokenType$1.TAG_OPEN_END] = "TAG_OPEN_END";
  TokenType$1[TokenType$1.TAG_OPEN_END_VOID] = "TAG_OPEN_END_VOID";
  TokenType$1[TokenType$1.TAG_CLOSE] = "TAG_CLOSE";
  TokenType$1[TokenType$1.TEXT] = "TEXT";
  TokenType$1[TokenType$1.ESCAPABLE_RAW_TEXT] = "ESCAPABLE_RAW_TEXT";
  TokenType$1[TokenType$1.RAW_TEXT] = "RAW_TEXT";
  TokenType$1[TokenType$1.COMMENT_START] = "COMMENT_START";
  TokenType$1[TokenType$1.COMMENT_END] = "COMMENT_END";
  TokenType$1[TokenType$1.CDATA_START] = "CDATA_START";
  TokenType$1[TokenType$1.CDATA_END] = "CDATA_END";
  TokenType$1[TokenType$1.ATTR_NAME] = "ATTR_NAME";
  TokenType$1[TokenType$1.ATTR_VALUE] = "ATTR_VALUE";
  TokenType$1[TokenType$1.DOC_TYPE] = "DOC_TYPE";
  TokenType$1[TokenType$1.EXPANSION_FORM_START] = "EXPANSION_FORM_START";
  TokenType$1[TokenType$1.EXPANSION_CASE_VALUE] = "EXPANSION_CASE_VALUE";
  TokenType$1[TokenType$1.EXPANSION_CASE_EXP_START] = "EXPANSION_CASE_EXP_START";
  TokenType$1[TokenType$1.EXPANSION_CASE_EXP_END] = "EXPANSION_CASE_EXP_END";
  TokenType$1[TokenType$1.EXPANSION_FORM_END] = "EXPANSION_FORM_END";
  TokenType$1[TokenType$1.EOF] = "EOF";
  var Token$1 = (function () {
      /**
       * @param {?} type
       * @param {?} parts
       * @param {?} sourceSpan
       */
      function Token(type, parts, sourceSpan) {
          this.type = type;
          this.parts = parts;
          this.sourceSpan = sourceSpan;
      }
      return Token;
  }());
  var TokenError = (function (_super) {
      __extends$3(TokenError, _super);
      /**
       * @param {?} errorMsg
       * @param {?} tokenType
       * @param {?} span
       */
      function TokenError(errorMsg, tokenType, span) {
          _super.call(this, span, errorMsg);
          this.tokenType = tokenType;
      }
      return TokenError;
  }(ParseError));
  var TokenizeResult = (function () {
      /**
       * @param {?} tokens
       * @param {?} errors
       */
      function TokenizeResult(tokens, errors) {
          this.tokens = tokens;
          this.errors = errors;
      }
      return TokenizeResult;
  }());
  /**
   * @param {?} source
   * @param {?} url
   * @param {?} getTagDefinition
   * @param {?=} tokenizeExpansionForms
   * @param {?=} interpolationConfig
   * @return {?}
   */
  function tokenize(source, url, getTagDefinition, tokenizeExpansionForms, interpolationConfig) {
      if (tokenizeExpansionForms === void 0) { tokenizeExpansionForms = false; }
      if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
      return new _Tokenizer(new ParseSourceFile(source, url), getTagDefinition, tokenizeExpansionForms, interpolationConfig)
          .tokenize();
  }
  var /** @type {?} */ _CR_OR_CRLF_REGEXP = /\r\n?/g;
  /**
   * @param {?} charCode
   * @return {?}
   */
  function _unexpectedCharacterErrorMsg(charCode) {
      var /** @type {?} */ char = charCode === $EOF ? 'EOF' : String.fromCharCode(charCode);
      return "Unexpected character \"" + char + "\"";
  }
  /**
   * @param {?} entitySrc
   * @return {?}
   */
  function _unknownEntityErrorMsg(entitySrc) {
      return "Unknown entity \"" + entitySrc + "\" - use the \"&#<decimal>;\" or  \"&#x<hex>;\" syntax";
  }
  var _ControlFlowError = (function () {
      /**
       * @param {?} error
       */
      function _ControlFlowError(error) {
          this.error = error;
      }
      return _ControlFlowError;
  }());
  // See http://www.w3.org/TR/html51/syntax.html#writing
  var _Tokenizer = (function () {
      /**
       * @param {?} _file The html source
       * @param {?} _getTagDefinition
       * @param {?} _tokenizeIcu Whether to tokenize ICU messages (considered as text nodes when false)
       * @param {?=} _interpolationConfig
       */
      function _Tokenizer(_file, _getTagDefinition, _tokenizeIcu, _interpolationConfig) {
          if (_interpolationConfig === void 0) { _interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          this._file = _file;
          this._getTagDefinition = _getTagDefinition;
          this._tokenizeIcu = _tokenizeIcu;
          this._interpolationConfig = _interpolationConfig;
          this._peek = -1;
          this._nextPeek = -1;
          this._index = -1;
          this._line = 0;
          this._column = -1;
          this._expansionCaseStack = [];
          this._inInterpolation = false;
          this.tokens = [];
          this.errors = [];
          this._input = _file.content;
          this._length = _file.content.length;
          this._advance();
      }
      /**
       * @param {?} content
       * @return {?}
       */
      _Tokenizer.prototype._processCarriageReturns = function (content) {
          // http://www.w3.org/TR/html5/syntax.html#preprocessing-the-input-stream
          // In order to keep the original position in the source, we can not
          // pre-process it.
          // Instead CRs are processed right before instantiating the tokens.
          return content.replace(_CR_OR_CRLF_REGEXP, '\n');
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype.tokenize = function () {
          while (this._peek !== $EOF) {
              var /** @type {?} */ start = this._getLocation();
              try {
                  if (this._attemptCharCode($LT)) {
                      if (this._attemptCharCode($BANG)) {
                          if (this._attemptCharCode($LBRACKET)) {
                              this._consumeCdata(start);
                          }
                          else if (this._attemptCharCode($MINUS)) {
                              this._consumeComment(start);
                          }
                          else {
                              this._consumeDocType(start);
                          }
                      }
                      else if (this._attemptCharCode($SLASH)) {
                          this._consumeTagClose(start);
                      }
                      else {
                          this._consumeTagOpen(start);
                      }
                  }
                  else if (!this._tokenizeIcu || !this._tokenizeExpansionForm()) {
                      this._consumeText();
                  }
              }
              catch (e) {
                  if (e instanceof _ControlFlowError) {
                      this.errors.push(e.error);
                  }
                  else {
                      throw e;
                  }
              }
          }
          this._beginToken(TokenType$1.EOF);
          this._endToken([]);
          return new TokenizeResult(mergeTextTokens(this.tokens), this.errors);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._tokenizeExpansionForm = function () {
          if (isExpansionFormStart(this._input, this._index, this._interpolationConfig)) {
              this._consumeExpansionFormStart();
              return true;
          }
          if (isExpansionCaseStart(this._peek) && this._isInExpansionForm()) {
              this._consumeExpansionCaseStart();
              return true;
          }
          if (this._peek === $RBRACE) {
              if (this._isInExpansionCase()) {
                  this._consumeExpansionCaseEnd();
                  return true;
              }
              if (this._isInExpansionForm()) {
                  this._consumeExpansionFormEnd();
                  return true;
              }
          }
          return false;
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._getLocation = function () {
          return new ParseLocation(this._file, this._index, this._line, this._column);
      };
      /**
       * @param {?=} start
       * @param {?=} end
       * @return {?}
       */
      _Tokenizer.prototype._getSpan = function (start, end) {
          if (start === void 0) { start = this._getLocation(); }
          if (end === void 0) { end = this._getLocation(); }
          return new ParseSourceSpan(start, end);
      };
      /**
       * @param {?} type
       * @param {?=} start
       * @return {?}
       */
      _Tokenizer.prototype._beginToken = function (type, start) {
          if (start === void 0) { start = this._getLocation(); }
          this._currentTokenStart = start;
          this._currentTokenType = type;
      };
      /**
       * @param {?} parts
       * @param {?=} end
       * @return {?}
       */
      _Tokenizer.prototype._endToken = function (parts, end) {
          if (end === void 0) { end = this._getLocation(); }
          var /** @type {?} */ token = new Token$1(this._currentTokenType, parts, new ParseSourceSpan(this._currentTokenStart, end));
          this.tokens.push(token);
          this._currentTokenStart = null;
          this._currentTokenType = null;
          return token;
      };
      /**
       * @param {?} msg
       * @param {?} span
       * @return {?}
       */
      _Tokenizer.prototype._createError = function (msg, span) {
          if (this._isInExpansionForm()) {
              msg += " (Do you have an unescaped \"{\" in your template? Use \"{{ '{' }}\") to escape it.)";
          }
          var /** @type {?} */ error = new TokenError(msg, this._currentTokenType, span);
          this._currentTokenStart = null;
          this._currentTokenType = null;
          return new _ControlFlowError(error);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._advance = function () {
          if (this._index >= this._length) {
              throw this._createError(_unexpectedCharacterErrorMsg($EOF), this._getSpan());
          }
          if (this._peek === $LF) {
              this._line++;
              this._column = 0;
          }
          else if (this._peek !== $LF && this._peek !== $CR) {
              this._column++;
          }
          this._index++;
          this._peek = this._index >= this._length ? $EOF : this._input.charCodeAt(this._index);
          this._nextPeek =
              this._index + 1 >= this._length ? $EOF : this._input.charCodeAt(this._index + 1);
      };
      /**
       * @param {?} charCode
       * @return {?}
       */
      _Tokenizer.prototype._attemptCharCode = function (charCode) {
          if (this._peek === charCode) {
              this._advance();
              return true;
          }
          return false;
      };
      /**
       * @param {?} charCode
       * @return {?}
       */
      _Tokenizer.prototype._attemptCharCodeCaseInsensitive = function (charCode) {
          if (compareCharCodeCaseInsensitive(this._peek, charCode)) {
              this._advance();
              return true;
          }
          return false;
      };
      /**
       * @param {?} charCode
       * @return {?}
       */
      _Tokenizer.prototype._requireCharCode = function (charCode) {
          var /** @type {?} */ location = this._getLocation();
          if (!this._attemptCharCode(charCode)) {
              throw this._createError(_unexpectedCharacterErrorMsg(this._peek), this._getSpan(location, location));
          }
      };
      /**
       * @param {?} chars
       * @return {?}
       */
      _Tokenizer.prototype._attemptStr = function (chars) {
          var /** @type {?} */ len = chars.length;
          if (this._index + len > this._length) {
              return false;
          }
          var /** @type {?} */ initialPosition = this._savePosition();
          for (var /** @type {?} */ i = 0; i < len; i++) {
              if (!this._attemptCharCode(chars.charCodeAt(i))) {
                  // If attempting to parse the string fails, we want to reset the parser
                  // to where it was before the attempt
                  this._restorePosition(initialPosition);
                  return false;
              }
          }
          return true;
      };
      /**
       * @param {?} chars
       * @return {?}
       */
      _Tokenizer.prototype._attemptStrCaseInsensitive = function (chars) {
          for (var /** @type {?} */ i = 0; i < chars.length; i++) {
              if (!this._attemptCharCodeCaseInsensitive(chars.charCodeAt(i))) {
                  return false;
              }
          }
          return true;
      };
      /**
       * @param {?} chars
       * @return {?}
       */
      _Tokenizer.prototype._requireStr = function (chars) {
          var /** @type {?} */ location = this._getLocation();
          if (!this._attemptStr(chars)) {
              throw this._createError(_unexpectedCharacterErrorMsg(this._peek), this._getSpan(location));
          }
      };
      /**
       * @param {?} predicate
       * @return {?}
       */
      _Tokenizer.prototype._attemptCharCodeUntilFn = function (predicate) {
          while (!predicate(this._peek)) {
              this._advance();
          }
      };
      /**
       * @param {?} predicate
       * @param {?} len
       * @return {?}
       */
      _Tokenizer.prototype._requireCharCodeUntilFn = function (predicate, len) {
          var /** @type {?} */ start = this._getLocation();
          this._attemptCharCodeUntilFn(predicate);
          if (this._index - start.offset < len) {
              throw this._createError(_unexpectedCharacterErrorMsg(this._peek), this._getSpan(start, start));
          }
      };
      /**
       * @param {?} char
       * @return {?}
       */
      _Tokenizer.prototype._attemptUntilChar = function (char) {
          while (this._peek !== char) {
              this._advance();
          }
      };
      /**
       * @param {?} decodeEntities
       * @return {?}
       */
      _Tokenizer.prototype._readChar = function (decodeEntities) {
          if (decodeEntities && this._peek === $AMPERSAND) {
              return this._decodeEntity();
          }
          else {
              var /** @type {?} */ index = this._index;
              this._advance();
              return this._input[index];
          }
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._decodeEntity = function () {
          var /** @type {?} */ start = this._getLocation();
          this._advance();
          if (this._attemptCharCode($HASH)) {
              var /** @type {?} */ isHex = this._attemptCharCode($x) || this._attemptCharCode($X);
              var /** @type {?} */ numberStart = this._getLocation().offset;
              this._attemptCharCodeUntilFn(isDigitEntityEnd);
              if (this._peek != $SEMICOLON) {
                  throw this._createError(_unexpectedCharacterErrorMsg(this._peek), this._getSpan());
              }
              this._advance();
              var /** @type {?} */ strNum = this._input.substring(numberStart, this._index - 1);
              try {
                  var /** @type {?} */ charCode = parseInt(strNum, isHex ? 16 : 10);
                  return String.fromCharCode(charCode);
              }
              catch (e) {
                  var /** @type {?} */ entity = this._input.substring(start.offset + 1, this._index - 1);
                  throw this._createError(_unknownEntityErrorMsg(entity), this._getSpan(start));
              }
          }
          else {
              var /** @type {?} */ startPosition = this._savePosition();
              this._attemptCharCodeUntilFn(isNamedEntityEnd);
              if (this._peek != $SEMICOLON) {
                  this._restorePosition(startPosition);
                  return '&';
              }
              this._advance();
              var /** @type {?} */ name_1 = this._input.substring(start.offset + 1, this._index - 1);
              var /** @type {?} */ char = NAMED_ENTITIES[name_1];
              if (!char) {
                  throw this._createError(_unknownEntityErrorMsg(name_1), this._getSpan(start));
              }
              return char;
          }
      };
      /**
       * @param {?} decodeEntities
       * @param {?} firstCharOfEnd
       * @param {?} attemptEndRest
       * @return {?}
       */
      _Tokenizer.prototype._consumeRawText = function (decodeEntities, firstCharOfEnd, attemptEndRest) {
          var /** @type {?} */ tagCloseStart;
          var /** @type {?} */ textStart = this._getLocation();
          this._beginToken(decodeEntities ? TokenType$1.ESCAPABLE_RAW_TEXT : TokenType$1.RAW_TEXT, textStart);
          var /** @type {?} */ parts = [];
          while (true) {
              tagCloseStart = this._getLocation();
              if (this._attemptCharCode(firstCharOfEnd) && attemptEndRest()) {
                  break;
              }
              if (this._index > tagCloseStart.offset) {
                  // add the characters consumed by the previous if statement to the output
                  parts.push(this._input.substring(tagCloseStart.offset, this._index));
              }
              while (this._peek !== firstCharOfEnd) {
                  parts.push(this._readChar(decodeEntities));
              }
          }
          return this._endToken([this._processCarriageReturns(parts.join(''))], tagCloseStart);
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _Tokenizer.prototype._consumeComment = function (start) {
          var _this = this;
          this._beginToken(TokenType$1.COMMENT_START, start);
          this._requireCharCode($MINUS);
          this._endToken([]);
          var /** @type {?} */ textToken = this._consumeRawText(false, $MINUS, function () { return _this._attemptStr('->'); });
          this._beginToken(TokenType$1.COMMENT_END, textToken.sourceSpan.end);
          this._endToken([]);
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _Tokenizer.prototype._consumeCdata = function (start) {
          var _this = this;
          this._beginToken(TokenType$1.CDATA_START, start);
          this._requireStr('CDATA[');
          this._endToken([]);
          var /** @type {?} */ textToken = this._consumeRawText(false, $RBRACKET, function () { return _this._attemptStr(']>'); });
          this._beginToken(TokenType$1.CDATA_END, textToken.sourceSpan.end);
          this._endToken([]);
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _Tokenizer.prototype._consumeDocType = function (start) {
          this._beginToken(TokenType$1.DOC_TYPE, start);
          this._attemptUntilChar($GT);
          this._advance();
          this._endToken([this._input.substring(start.offset + 2, this._index - 1)]);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumePrefixAndName = function () {
          var /** @type {?} */ nameOrPrefixStart = this._index;
          var /** @type {?} */ prefix = null;
          while (this._peek !== $COLON && !isPrefixEnd(this._peek)) {
              this._advance();
          }
          var /** @type {?} */ nameStart;
          if (this._peek === $COLON) {
              this._advance();
              prefix = this._input.substring(nameOrPrefixStart, this._index - 1);
              nameStart = this._index;
          }
          else {
              nameStart = nameOrPrefixStart;
          }
          this._requireCharCodeUntilFn(isNameEnd, this._index === nameStart ? 1 : 0);
          var /** @type {?} */ name = this._input.substring(nameStart, this._index);
          return [prefix, name];
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _Tokenizer.prototype._consumeTagOpen = function (start) {
          var /** @type {?} */ savedPos = this._savePosition();
          var /** @type {?} */ tagName;
          var /** @type {?} */ lowercaseTagName;
          try {
              if (!isAsciiLetter(this._peek)) {
                  throw this._createError(_unexpectedCharacterErrorMsg(this._peek), this._getSpan());
              }
              var /** @type {?} */ nameStart = this._index;
              this._consumeTagOpenStart(start);
              tagName = this._input.substring(nameStart, this._index);
              lowercaseTagName = tagName.toLowerCase();
              this._attemptCharCodeUntilFn(isNotWhitespace);
              while (this._peek !== $SLASH && this._peek !== $GT) {
                  this._consumeAttributeName();
                  this._attemptCharCodeUntilFn(isNotWhitespace);
                  if (this._attemptCharCode($EQ)) {
                      this._attemptCharCodeUntilFn(isNotWhitespace);
                      this._consumeAttributeValue();
                  }
                  this._attemptCharCodeUntilFn(isNotWhitespace);
              }
              this._consumeTagOpenEnd();
          }
          catch (e) {
              if (e instanceof _ControlFlowError) {
                  // When the start tag is invalid, assume we want a "<"
                  this._restorePosition(savedPos);
                  // Back to back text tokens are merged at the end
                  this._beginToken(TokenType$1.TEXT, start);
                  this._endToken(['<']);
                  return;
              }
              throw e;
          }
          var /** @type {?} */ contentTokenType = this._getTagDefinition(tagName).contentType;
          if (contentTokenType === TagContentType.RAW_TEXT) {
              this._consumeRawTextWithTagClose(lowercaseTagName, false);
          }
          else if (contentTokenType === TagContentType.ESCAPABLE_RAW_TEXT) {
              this._consumeRawTextWithTagClose(lowercaseTagName, true);
          }
      };
      /**
       * @param {?} lowercaseTagName
       * @param {?} decodeEntities
       * @return {?}
       */
      _Tokenizer.prototype._consumeRawTextWithTagClose = function (lowercaseTagName, decodeEntities) {
          var _this = this;
          var /** @type {?} */ textToken = this._consumeRawText(decodeEntities, $LT, function () {
              if (!_this._attemptCharCode($SLASH))
                  return false;
              _this._attemptCharCodeUntilFn(isNotWhitespace);
              if (!_this._attemptStrCaseInsensitive(lowercaseTagName))
                  return false;
              _this._attemptCharCodeUntilFn(isNotWhitespace);
              return _this._attemptCharCode($GT);
          });
          this._beginToken(TokenType$1.TAG_CLOSE, textToken.sourceSpan.end);
          this._endToken([null, lowercaseTagName]);
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _Tokenizer.prototype._consumeTagOpenStart = function (start) {
          this._beginToken(TokenType$1.TAG_OPEN_START, start);
          var /** @type {?} */ parts = this._consumePrefixAndName();
          this._endToken(parts);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeAttributeName = function () {
          this._beginToken(TokenType$1.ATTR_NAME);
          var /** @type {?} */ prefixAndName = this._consumePrefixAndName();
          this._endToken(prefixAndName);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeAttributeValue = function () {
          this._beginToken(TokenType$1.ATTR_VALUE);
          var /** @type {?} */ value;
          if (this._peek === $SQ || this._peek === $DQ) {
              var /** @type {?} */ quoteChar = this._peek;
              this._advance();
              var /** @type {?} */ parts = [];
              while (this._peek !== quoteChar) {
                  parts.push(this._readChar(true));
              }
              value = parts.join('');
              this._advance();
          }
          else {
              var /** @type {?} */ valueStart = this._index;
              this._requireCharCodeUntilFn(isNameEnd, 1);
              value = this._input.substring(valueStart, this._index);
          }
          this._endToken([this._processCarriageReturns(value)]);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeTagOpenEnd = function () {
          var /** @type {?} */ tokenType = this._attemptCharCode($SLASH) ? TokenType$1.TAG_OPEN_END_VOID : TokenType$1.TAG_OPEN_END;
          this._beginToken(tokenType);
          this._requireCharCode($GT);
          this._endToken([]);
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _Tokenizer.prototype._consumeTagClose = function (start) {
          this._beginToken(TokenType$1.TAG_CLOSE, start);
          this._attemptCharCodeUntilFn(isNotWhitespace);
          var /** @type {?} */ prefixAndName = this._consumePrefixAndName();
          this._attemptCharCodeUntilFn(isNotWhitespace);
          this._requireCharCode($GT);
          this._endToken(prefixAndName);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeExpansionFormStart = function () {
          this._beginToken(TokenType$1.EXPANSION_FORM_START, this._getLocation());
          this._requireCharCode($LBRACE);
          this._endToken([]);
          this._expansionCaseStack.push(TokenType$1.EXPANSION_FORM_START);
          this._beginToken(TokenType$1.RAW_TEXT, this._getLocation());
          var /** @type {?} */ condition = this._readUntil($COMMA);
          this._endToken([condition], this._getLocation());
          this._requireCharCode($COMMA);
          this._attemptCharCodeUntilFn(isNotWhitespace);
          this._beginToken(TokenType$1.RAW_TEXT, this._getLocation());
          var /** @type {?} */ type = this._readUntil($COMMA);
          this._endToken([type], this._getLocation());
          this._requireCharCode($COMMA);
          this._attemptCharCodeUntilFn(isNotWhitespace);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeExpansionCaseStart = function () {
          this._beginToken(TokenType$1.EXPANSION_CASE_VALUE, this._getLocation());
          var /** @type {?} */ value = this._readUntil($LBRACE).trim();
          this._endToken([value], this._getLocation());
          this._attemptCharCodeUntilFn(isNotWhitespace);
          this._beginToken(TokenType$1.EXPANSION_CASE_EXP_START, this._getLocation());
          this._requireCharCode($LBRACE);
          this._endToken([], this._getLocation());
          this._attemptCharCodeUntilFn(isNotWhitespace);
          this._expansionCaseStack.push(TokenType$1.EXPANSION_CASE_EXP_START);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeExpansionCaseEnd = function () {
          this._beginToken(TokenType$1.EXPANSION_CASE_EXP_END, this._getLocation());
          this._requireCharCode($RBRACE);
          this._endToken([], this._getLocation());
          this._attemptCharCodeUntilFn(isNotWhitespace);
          this._expansionCaseStack.pop();
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeExpansionFormEnd = function () {
          this._beginToken(TokenType$1.EXPANSION_FORM_END, this._getLocation());
          this._requireCharCode($RBRACE);
          this._endToken([]);
          this._expansionCaseStack.pop();
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._consumeText = function () {
          var /** @type {?} */ start = this._getLocation();
          this._beginToken(TokenType$1.TEXT, start);
          var /** @type {?} */ parts = [];
          do {
              if (this._interpolationConfig && this._attemptStr(this._interpolationConfig.start)) {
                  parts.push(this._interpolationConfig.start);
                  this._inInterpolation = true;
              }
              else if (this._interpolationConfig && this._attemptStr(this._interpolationConfig.end) &&
                  this._inInterpolation) {
                  parts.push(this._interpolationConfig.end);
                  this._inInterpolation = false;
              }
              else {
                  parts.push(this._readChar(true));
              }
          } while (!this._isTextEnd());
          this._endToken([this._processCarriageReturns(parts.join(''))]);
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._isTextEnd = function () {
          if (this._peek === $LT || this._peek === $EOF) {
              return true;
          }
          if (this._tokenizeIcu && !this._inInterpolation) {
              if (isExpansionFormStart(this._input, this._index, this._interpolationConfig)) {
                  // start of an expansion form
                  return true;
              }
              if (this._peek === $RBRACE && this._isInExpansionCase()) {
                  // end of and expansion case
                  return true;
              }
          }
          return false;
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._savePosition = function () {
          return [this._peek, this._index, this._column, this._line, this.tokens.length];
      };
      /**
       * @param {?} char
       * @return {?}
       */
      _Tokenizer.prototype._readUntil = function (char) {
          var /** @type {?} */ start = this._index;
          this._attemptUntilChar(char);
          return this._input.substring(start, this._index);
      };
      /**
       * @param {?} position
       * @return {?}
       */
      _Tokenizer.prototype._restorePosition = function (position) {
          this._peek = position[0];
          this._index = position[1];
          this._column = position[2];
          this._line = position[3];
          var /** @type {?} */ nbTokens = position[4];
          if (nbTokens < this.tokens.length) {
              // remove any extra tokens
              this.tokens = this.tokens.slice(0, nbTokens);
          }
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._isInExpansionCase = function () {
          return this._expansionCaseStack.length > 0 &&
              this._expansionCaseStack[this._expansionCaseStack.length - 1] ===
                  TokenType$1.EXPANSION_CASE_EXP_START;
      };
      /**
       * @return {?}
       */
      _Tokenizer.prototype._isInExpansionForm = function () {
          return this._expansionCaseStack.length > 0 &&
              this._expansionCaseStack[this._expansionCaseStack.length - 1] ===
                  TokenType$1.EXPANSION_FORM_START;
      };
      return _Tokenizer;
  }());
  /**
   * @param {?} code
   * @return {?}
   */
  function isNotWhitespace(code) {
      return !isWhitespace(code) || code === $EOF;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isNameEnd(code) {
      return isWhitespace(code) || code === $GT || code === $SLASH ||
          code === $SQ || code === $DQ || code === $EQ;
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isPrefixEnd(code) {
      return (code < $a || $z < code) && (code < $A || $Z < code) &&
          (code < $0 || code > $9);
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isDigitEntityEnd(code) {
      return code == $SEMICOLON || code == $EOF || !isAsciiHexDigit(code);
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function isNamedEntityEnd(code) {
      return code == $SEMICOLON || code == $EOF || !isAsciiLetter(code);
  }
  /**
   * @param {?} input
   * @param {?} offset
   * @param {?} interpolationConfig
   * @return {?}
   */
  function isExpansionFormStart(input, offset, interpolationConfig) {
      var /** @type {?} */ isInterpolationStart = interpolationConfig ? input.indexOf(interpolationConfig.start, offset) == offset : false;
      return input.charCodeAt(offset) == $LBRACE && !isInterpolationStart;
  }
  /**
   * @param {?} peek
   * @return {?}
   */
  function isExpansionCaseStart(peek) {
      return peek === $EQ || isAsciiLetter(peek);
  }
  /**
   * @param {?} code1
   * @param {?} code2
   * @return {?}
   */
  function compareCharCodeCaseInsensitive(code1, code2) {
      return toUpperCaseCharCode(code1) == toUpperCaseCharCode(code2);
  }
  /**
   * @param {?} code
   * @return {?}
   */
  function toUpperCaseCharCode(code) {
      return code >= $a && code <= $z ? code - $a + $A : code;
  }
  /**
   * @param {?} srcTokens
   * @return {?}
   */
  function mergeTextTokens(srcTokens) {
      var /** @type {?} */ dstTokens = [];
      var /** @type {?} */ lastDstToken;
      for (var /** @type {?} */ i = 0; i < srcTokens.length; i++) {
          var /** @type {?} */ token = srcTokens[i];
          if (lastDstToken && lastDstToken.type == TokenType$1.TEXT && token.type == TokenType$1.TEXT) {
              lastDstToken.parts[0] += token.parts[0];
              lastDstToken.sourceSpan.end = token.sourceSpan.end;
          }
          else {
              lastDstToken = token;
              dstTokens.push(lastDstToken);
          }
      }
      return dstTokens;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$2 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var TreeError = (function (_super) {
      __extends$2(TreeError, _super);
      /**
       * @param {?} elementName
       * @param {?} span
       * @param {?} msg
       */
      function TreeError(elementName, span, msg) {
          _super.call(this, span, msg);
          this.elementName = elementName;
      }
      /**
       * @param {?} elementName
       * @param {?} span
       * @param {?} msg
       * @return {?}
       */
      TreeError.create = function (elementName, span, msg) {
          return new TreeError(elementName, span, msg);
      };
      return TreeError;
  }(ParseError));
  var ParseTreeResult = (function () {
      /**
       * @param {?} rootNodes
       * @param {?} errors
       */
      function ParseTreeResult(rootNodes, errors) {
          this.rootNodes = rootNodes;
          this.errors = errors;
      }
      return ParseTreeResult;
  }());
  var Parser$1 = (function () {
      /**
       * @param {?} getTagDefinition
       */
      function Parser(getTagDefinition) {
          this.getTagDefinition = getTagDefinition;
      }
      /**
       * @param {?} source
       * @param {?} url
       * @param {?=} parseExpansionForms
       * @param {?=} interpolationConfig
       * @return {?}
       */
      Parser.prototype.parse = function (source, url, parseExpansionForms, interpolationConfig) {
          if (parseExpansionForms === void 0) { parseExpansionForms = false; }
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          var /** @type {?} */ tokensAndErrors = tokenize(source, url, this.getTagDefinition, parseExpansionForms, interpolationConfig);
          var /** @type {?} */ treeAndErrors = new _TreeBuilder(tokensAndErrors.tokens, this.getTagDefinition).build();
          return new ParseTreeResult(treeAndErrors.rootNodes, ((tokensAndErrors.errors)).concat(treeAndErrors.errors));
      };
      return Parser;
  }());
  var _TreeBuilder = (function () {
      /**
       * @param {?} tokens
       * @param {?} getTagDefinition
       */
      function _TreeBuilder(tokens, getTagDefinition) {
          this.tokens = tokens;
          this.getTagDefinition = getTagDefinition;
          this._index = -1;
          this._rootNodes = [];
          this._errors = [];
          this._elementStack = [];
          this._advance();
      }
      /**
       * @return {?}
       */
      _TreeBuilder.prototype.build = function () {
          while (this._peek.type !== TokenType$1.EOF) {
              if (this._peek.type === TokenType$1.TAG_OPEN_START) {
                  this._consumeStartTag(this._advance());
              }
              else if (this._peek.type === TokenType$1.TAG_CLOSE) {
                  this._consumeEndTag(this._advance());
              }
              else if (this._peek.type === TokenType$1.CDATA_START) {
                  this._closeVoidElement();
                  this._consumeCdata(this._advance());
              }
              else if (this._peek.type === TokenType$1.COMMENT_START) {
                  this._closeVoidElement();
                  this._consumeComment(this._advance());
              }
              else if (this._peek.type === TokenType$1.TEXT || this._peek.type === TokenType$1.RAW_TEXT ||
                  this._peek.type === TokenType$1.ESCAPABLE_RAW_TEXT) {
                  this._closeVoidElement();
                  this._consumeText(this._advance());
              }
              else if (this._peek.type === TokenType$1.EXPANSION_FORM_START) {
                  this._consumeExpansion(this._advance());
              }
              else {
                  // Skip all other tokens...
                  this._advance();
              }
          }
          return new ParseTreeResult(this._rootNodes, this._errors);
      };
      /**
       * @return {?}
       */
      _TreeBuilder.prototype._advance = function () {
          var /** @type {?} */ prev = this._peek;
          if (this._index < this.tokens.length - 1) {
              // Note: there is always an EOF token at the end
              this._index++;
          }
          this._peek = this.tokens[this._index];
          return prev;
      };
      /**
       * @param {?} type
       * @return {?}
       */
      _TreeBuilder.prototype._advanceIf = function (type) {
          if (this._peek.type === type) {
              return this._advance();
          }
          return null;
      };
      /**
       * @param {?} startToken
       * @return {?}
       */
      _TreeBuilder.prototype._consumeCdata = function (startToken) {
          this._consumeText(this._advance());
          this._advanceIf(TokenType$1.CDATA_END);
      };
      /**
       * @param {?} token
       * @return {?}
       */
      _TreeBuilder.prototype._consumeComment = function (token) {
          var /** @type {?} */ text = this._advanceIf(TokenType$1.RAW_TEXT);
          this._advanceIf(TokenType$1.COMMENT_END);
          var /** @type {?} */ value = isPresent(text) ? text.parts[0].trim() : null;
          this._addToParent(new Comment(value, token.sourceSpan));
      };
      /**
       * @param {?} token
       * @return {?}
       */
      _TreeBuilder.prototype._consumeExpansion = function (token) {
          var /** @type {?} */ switchValue = this._advance();
          var /** @type {?} */ type = this._advance();
          var /** @type {?} */ cases = [];
          // read =
          while (this._peek.type === TokenType$1.EXPANSION_CASE_VALUE) {
              var /** @type {?} */ expCase = this._parseExpansionCase();
              if (!expCase)
                  return; // error
              cases.push(expCase);
          }
          // read the final }
          if (this._peek.type !== TokenType$1.EXPANSION_FORM_END) {
              this._errors.push(TreeError.create(null, this._peek.sourceSpan, "Invalid ICU message. Missing '}'."));
              return;
          }
          var /** @type {?} */ sourceSpan = new ParseSourceSpan(token.sourceSpan.start, this._peek.sourceSpan.end);
          this._addToParent(new Expansion(switchValue.parts[0], type.parts[0], cases, sourceSpan, switchValue.sourceSpan));
          this._advance();
      };
      /**
       * @return {?}
       */
      _TreeBuilder.prototype._parseExpansionCase = function () {
          var /** @type {?} */ value = this._advance();
          // read {
          if (this._peek.type !== TokenType$1.EXPANSION_CASE_EXP_START) {
              this._errors.push(TreeError.create(null, this._peek.sourceSpan, "Invalid ICU message. Missing '{'."));
              return null;
          }
          // read until }
          var /** @type {?} */ start = this._advance();
          var /** @type {?} */ exp = this._collectExpansionExpTokens(start);
          if (!exp)
              return null;
          var /** @type {?} */ end = this._advance();
          exp.push(new Token$1(TokenType$1.EOF, [], end.sourceSpan));
          // parse everything in between { and }
          var /** @type {?} */ parsedExp = new _TreeBuilder(exp, this.getTagDefinition).build();
          if (parsedExp.errors.length > 0) {
              this._errors = this._errors.concat(/** @type {?} */ (parsedExp.errors));
              return null;
          }
          var /** @type {?} */ sourceSpan = new ParseSourceSpan(value.sourceSpan.start, end.sourceSpan.end);
          var /** @type {?} */ expSourceSpan = new ParseSourceSpan(start.sourceSpan.start, end.sourceSpan.end);
          return new ExpansionCase(value.parts[0], parsedExp.rootNodes, sourceSpan, value.sourceSpan, expSourceSpan);
      };
      /**
       * @param {?} start
       * @return {?}
       */
      _TreeBuilder.prototype._collectExpansionExpTokens = function (start) {
          var /** @type {?} */ exp = [];
          var /** @type {?} */ expansionFormStack = [TokenType$1.EXPANSION_CASE_EXP_START];
          while (true) {
              if (this._peek.type === TokenType$1.EXPANSION_FORM_START ||
                  this._peek.type === TokenType$1.EXPANSION_CASE_EXP_START) {
                  expansionFormStack.push(this._peek.type);
              }
              if (this._peek.type === TokenType$1.EXPANSION_CASE_EXP_END) {
                  if (lastOnStack(expansionFormStack, TokenType$1.EXPANSION_CASE_EXP_START)) {
                      expansionFormStack.pop();
                      if (expansionFormStack.length == 0)
                          return exp;
                  }
                  else {
                      this._errors.push(TreeError.create(null, start.sourceSpan, "Invalid ICU message. Missing '}'."));
                      return null;
                  }
              }
              if (this._peek.type === TokenType$1.EXPANSION_FORM_END) {
                  if (lastOnStack(expansionFormStack, TokenType$1.EXPANSION_FORM_START)) {
                      expansionFormStack.pop();
                  }
                  else {
                      this._errors.push(TreeError.create(null, start.sourceSpan, "Invalid ICU message. Missing '}'."));
                      return null;
                  }
              }
              if (this._peek.type === TokenType$1.EOF) {
                  this._errors.push(TreeError.create(null, start.sourceSpan, "Invalid ICU message. Missing '}'."));
                  return null;
              }
              exp.push(this._advance());
          }
      };
      /**
       * @param {?} token
       * @return {?}
       */
      _TreeBuilder.prototype._consumeText = function (token) {
          var /** @type {?} */ text = token.parts[0];
          if (text.length > 0 && text[0] == '\n') {
              var /** @type {?} */ parent_1 = this._getParentElement();
              if (isPresent(parent_1) && parent_1.children.length == 0 &&
                  this.getTagDefinition(parent_1.name).ignoreFirstLf) {
                  text = text.substring(1);
              }
          }
          if (text.length > 0) {
              this._addToParent(new Text(text, token.sourceSpan));
          }
      };
      /**
       * @return {?}
       */
      _TreeBuilder.prototype._closeVoidElement = function () {
          if (this._elementStack.length > 0) {
              var /** @type {?} */ el = this._elementStack[this._elementStack.length - 1];
              if (this.getTagDefinition(el.name).isVoid) {
                  this._elementStack.pop();
              }
          }
      };
      /**
       * @param {?} startTagToken
       * @return {?}
       */
      _TreeBuilder.prototype._consumeStartTag = function (startTagToken) {
          var /** @type {?} */ prefix = startTagToken.parts[0];
          var /** @type {?} */ name = startTagToken.parts[1];
          var /** @type {?} */ attrs = [];
          while (this._peek.type === TokenType$1.ATTR_NAME) {
              attrs.push(this._consumeAttr(this._advance()));
          }
          var /** @type {?} */ fullName = this._getElementFullName(prefix, name, this._getParentElement());
          var /** @type {?} */ selfClosing = false;
          // Note: There could have been a tokenizer error
          // so that we don't get a token for the end tag...
          if (this._peek.type === TokenType$1.TAG_OPEN_END_VOID) {
              this._advance();
              selfClosing = true;
              var /** @type {?} */ tagDef = this.getTagDefinition(fullName);
              if (!(tagDef.canSelfClose || getNsPrefix(fullName) !== null || tagDef.isVoid)) {
                  this._errors.push(TreeError.create(fullName, startTagToken.sourceSpan, "Only void and foreign elements can be self closed \"" + startTagToken.parts[1] + "\""));
              }
          }
          else if (this._peek.type === TokenType$1.TAG_OPEN_END) {
              this._advance();
              selfClosing = false;
          }
          var /** @type {?} */ end = this._peek.sourceSpan.start;
          var /** @type {?} */ span = new ParseSourceSpan(startTagToken.sourceSpan.start, end);
          var /** @type {?} */ el = new Element(fullName, attrs, [], span, span, null);
          this._pushElement(el);
          if (selfClosing) {
              this._popElement(fullName);
              el.endSourceSpan = span;
          }
      };
      /**
       * @param {?} el
       * @return {?}
       */
      _TreeBuilder.prototype._pushElement = function (el) {
          if (this._elementStack.length > 0) {
              var /** @type {?} */ parentEl = this._elementStack[this._elementStack.length - 1];
              if (this.getTagDefinition(parentEl.name).isClosedByChild(el.name)) {
                  this._elementStack.pop();
              }
          }
          var /** @type {?} */ tagDef = this.getTagDefinition(el.name);
          var _a = this._getParentElementSkippingContainers(), parent = _a.parent, container = _a.container;
          if (isPresent(parent) && tagDef.requireExtraParent(parent.name)) {
              var /** @type {?} */ newParent = new Element(tagDef.parentToAdd, [], [], el.sourceSpan, el.startSourceSpan, el.endSourceSpan);
              this._insertBeforeContainer(parent, container, newParent);
          }
          this._addToParent(el);
          this._elementStack.push(el);
      };
      /**
       * @param {?} endTagToken
       * @return {?}
       */
      _TreeBuilder.prototype._consumeEndTag = function (endTagToken) {
          var /** @type {?} */ fullName = this._getElementFullName(endTagToken.parts[0], endTagToken.parts[1], this._getParentElement());
          if (this._getParentElement()) {
              this._getParentElement().endSourceSpan = endTagToken.sourceSpan;
          }
          if (this.getTagDefinition(fullName).isVoid) {
              this._errors.push(TreeError.create(fullName, endTagToken.sourceSpan, "Void elements do not have end tags \"" + endTagToken.parts[1] + "\""));
          }
          else if (!this._popElement(fullName)) {
              this._errors.push(TreeError.create(fullName, endTagToken.sourceSpan, "Unexpected closing tag \"" + endTagToken.parts[1] + "\""));
          }
      };
      /**
       * @param {?} fullName
       * @return {?}
       */
      _TreeBuilder.prototype._popElement = function (fullName) {
          for (var /** @type {?} */ stackIndex = this._elementStack.length - 1; stackIndex >= 0; stackIndex--) {
              var /** @type {?} */ el = this._elementStack[stackIndex];
              if (el.name == fullName) {
                  this._elementStack.splice(stackIndex, this._elementStack.length - stackIndex);
                  return true;
              }
              if (!this.getTagDefinition(el.name).closedByParent) {
                  return false;
              }
          }
          return false;
      };
      /**
       * @param {?} attrName
       * @return {?}
       */
      _TreeBuilder.prototype._consumeAttr = function (attrName) {
          var /** @type {?} */ fullName = mergeNsAndName(attrName.parts[0], attrName.parts[1]);
          var /** @type {?} */ end = attrName.sourceSpan.end;
          var /** @type {?} */ value = '';
          var /** @type {?} */ valueSpan;
          if (this._peek.type === TokenType$1.ATTR_VALUE) {
              var /** @type {?} */ valueToken = this._advance();
              value = valueToken.parts[0];
              end = valueToken.sourceSpan.end;
              valueSpan = valueToken.sourceSpan;
          }
          return new Attribute$1(fullName, value, new ParseSourceSpan(attrName.sourceSpan.start, end), valueSpan);
      };
      /**
       * @return {?}
       */
      _TreeBuilder.prototype._getParentElement = function () {
          return this._elementStack.length > 0 ? this._elementStack[this._elementStack.length - 1] : null;
      };
      /**
       *  Returns the parent in the DOM and the container.
        * *
        * `<ng-container>` elements are skipped as they are not rendered as DOM element.
       * @return {?}
       */
      _TreeBuilder.prototype._getParentElementSkippingContainers = function () {
          var /** @type {?} */ container = null;
          for (var /** @type {?} */ i = this._elementStack.length - 1; i >= 0; i--) {
              if (this._elementStack[i].name !== 'ng-container') {
                  return { parent: this._elementStack[i], container: container };
              }
              container = this._elementStack[i];
          }
          return { parent: this._elementStack[this._elementStack.length - 1], container: container };
      };
      /**
       * @param {?} node
       * @return {?}
       */
      _TreeBuilder.prototype._addToParent = function (node) {
          var /** @type {?} */ parent = this._getParentElement();
          if (isPresent(parent)) {
              parent.children.push(node);
          }
          else {
              this._rootNodes.push(node);
          }
      };
      /**
       *  Insert a node between the parent and the container.
        * When no container is given, the node is appended as a child of the parent.
        * Also updates the element stack accordingly.
        * *
       * @param {?} parent
       * @param {?} container
       * @param {?} node
       * @return {?}
       */
      _TreeBuilder.prototype._insertBeforeContainer = function (parent, container, node) {
          if (!container) {
              this._addToParent(node);
              this._elementStack.push(node);
          }
          else {
              if (parent) {
                  // replace the container with the new node in the children
                  var /** @type {?} */ index = parent.children.indexOf(container);
                  parent.children[index] = node;
              }
              else {
                  this._rootNodes.push(node);
              }
              node.children.push(container);
              this._elementStack.splice(this._elementStack.indexOf(container), 0, node);
          }
      };
      /**
       * @param {?} prefix
       * @param {?} localName
       * @param {?} parentElement
       * @return {?}
       */
      _TreeBuilder.prototype._getElementFullName = function (prefix, localName, parentElement) {
          if (isBlank(prefix)) {
              prefix = this.getTagDefinition(localName).implicitNamespacePrefix;
              if (isBlank(prefix) && isPresent(parentElement)) {
                  prefix = getNsPrefix(parentElement.name);
              }
          }
          return mergeNsAndName(prefix, localName);
      };
      return _TreeBuilder;
  }());
  /**
   * @param {?} stack
   * @param {?} element
   * @return {?}
   */
  function lastOnStack(stack, element) {
      return stack.length > 0 && stack[stack.length - 1] === element;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var Message = (function () {
      /**
       * @param {?} nodes message AST
       * @param {?} placeholders maps placeholder names to static content
       * @param {?} placeholderToMessage maps placeholder names to messages (used for nested ICU messages)
       * @param {?} meaning
       * @param {?} description
       */
      function Message(nodes, placeholders, placeholderToMessage, meaning, description) {
          this.nodes = nodes;
          this.placeholders = placeholders;
          this.placeholderToMessage = placeholderToMessage;
          this.meaning = meaning;
          this.description = description;
      }
      return Message;
  }());
  var Text$1 = (function () {
      /**
       * @param {?} value
       * @param {?} sourceSpan
       */
      function Text(value, sourceSpan) {
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Text.prototype.visit = function (visitor, context) { return visitor.visitText(this, context); };
      return Text;
  }());
  // TODO(vicb): do we really need this node (vs an array) ?
  var Container = (function () {
      /**
       * @param {?} children
       * @param {?} sourceSpan
       */
      function Container(children, sourceSpan) {
          this.children = children;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Container.prototype.visit = function (visitor, context) { return visitor.visitContainer(this, context); };
      return Container;
  }());
  var Icu = (function () {
      /**
       * @param {?} expression
       * @param {?} type
       * @param {?} cases
       * @param {?} sourceSpan
       */
      function Icu(expression, type, cases, sourceSpan) {
          this.expression = expression;
          this.type = type;
          this.cases = cases;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Icu.prototype.visit = function (visitor, context) { return visitor.visitIcu(this, context); };
      return Icu;
  }());
  var TagPlaceholder = (function () {
      /**
       * @param {?} tag
       * @param {?} attrs
       * @param {?} startName
       * @param {?} closeName
       * @param {?} children
       * @param {?} isVoid
       * @param {?} sourceSpan
       */
      function TagPlaceholder(tag, attrs, startName, closeName, children, isVoid, sourceSpan) {
          this.tag = tag;
          this.attrs = attrs;
          this.startName = startName;
          this.closeName = closeName;
          this.children = children;
          this.isVoid = isVoid;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      TagPlaceholder.prototype.visit = function (visitor, context) { return visitor.visitTagPlaceholder(this, context); };
      return TagPlaceholder;
  }());
  var Placeholder = (function () {
      /**
       * @param {?} value
       * @param {?} name
       * @param {?} sourceSpan
       */
      function Placeholder(value, name, sourceSpan) {
          this.value = value;
          this.name = name;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      Placeholder.prototype.visit = function (visitor, context) { return visitor.visitPlaceholder(this, context); };
      return Placeholder;
  }());
  var IcuPlaceholder = (function () {
      /**
       * @param {?} value
       * @param {?} name
       * @param {?} sourceSpan
       */
      function IcuPlaceholder(value, name, sourceSpan) {
          this.value = value;
          this.name = name;
          this.sourceSpan = sourceSpan;
      }
      /**
       * @param {?} visitor
       * @param {?=} context
       * @return {?}
       */
      IcuPlaceholder.prototype.visit = function (visitor, context) { return visitor.visitIcuPlaceholder(this, context); };
      return IcuPlaceholder;
  }());

  var HtmlTagDefinition = (function () {
      /**
       * @param {?=} __0
       */
      function HtmlTagDefinition(_a) {
          var _this = this;
          var _b = _a === void 0 ? {} : _a, closedByChildren = _b.closedByChildren, requiredParents = _b.requiredParents, implicitNamespacePrefix = _b.implicitNamespacePrefix, _c = _b.contentType, contentType = _c === void 0 ? TagContentType.PARSABLE_DATA : _c, _d = _b.closedByParent, closedByParent = _d === void 0 ? false : _d, _e = _b.isVoid, isVoid = _e === void 0 ? false : _e, _f = _b.ignoreFirstLf, ignoreFirstLf = _f === void 0 ? false : _f;
          this.closedByChildren = {};
          this.closedByParent = false;
          this.canSelfClose = false;
          if (closedByChildren && closedByChildren.length > 0) {
              closedByChildren.forEach(function (tagName) { return _this.closedByChildren[tagName] = true; });
          }
          this.isVoid = isVoid;
          this.closedByParent = closedByParent || isVoid;
          if (requiredParents && requiredParents.length > 0) {
              this.requiredParents = {};
              // The first parent is the list is automatically when none of the listed parents are present
              this.parentToAdd = requiredParents[0];
              requiredParents.forEach(function (tagName) { return _this.requiredParents[tagName] = true; });
          }
          this.implicitNamespacePrefix = implicitNamespacePrefix;
          this.contentType = contentType;
          this.ignoreFirstLf = ignoreFirstLf;
      }
      /**
       * @param {?} currentParent
       * @return {?}
       */
      HtmlTagDefinition.prototype.requireExtraParent = function (currentParent) {
          if (!this.requiredParents) {
              return false;
          }
          if (!currentParent) {
              return true;
          }
          var /** @type {?} */ lcParent = currentParent.toLowerCase();
          return this.requiredParents[lcParent] != true && lcParent != 'template';
      };
      /**
       * @param {?} name
       * @return {?}
       */
      HtmlTagDefinition.prototype.isClosedByChild = function (name) {
          return this.isVoid || name.toLowerCase() in this.closedByChildren;
      };
      return HtmlTagDefinition;
  }());
  // see http://www.w3.org/TR/html51/syntax.html#optional-tags
  // This implementation does not fully conform to the HTML5 spec.
  var /** @type {?} */ TAG_DEFINITIONS = {
      'base': new HtmlTagDefinition({ isVoid: true }),
      'meta': new HtmlTagDefinition({ isVoid: true }),
      'area': new HtmlTagDefinition({ isVoid: true }),
      'embed': new HtmlTagDefinition({ isVoid: true }),
      'link': new HtmlTagDefinition({ isVoid: true }),
      'img': new HtmlTagDefinition({ isVoid: true }),
      'input': new HtmlTagDefinition({ isVoid: true }),
      'param': new HtmlTagDefinition({ isVoid: true }),
      'hr': new HtmlTagDefinition({ isVoid: true }),
      'br': new HtmlTagDefinition({ isVoid: true }),
      'source': new HtmlTagDefinition({ isVoid: true }),
      'track': new HtmlTagDefinition({ isVoid: true }),
      'wbr': new HtmlTagDefinition({ isVoid: true }),
      'p': new HtmlTagDefinition({
          closedByChildren: [
              'address', 'article', 'aside', 'blockquote', 'div', 'dl', 'fieldset', 'footer', 'form',
              'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'hgroup', 'hr',
              'main', 'nav', 'ol', 'p', 'pre', 'section', 'table', 'ul'
          ],
          closedByParent: true
      }),
      'thead': new HtmlTagDefinition({ closedByChildren: ['tbody', 'tfoot'] }),
      'tbody': new HtmlTagDefinition({ closedByChildren: ['tbody', 'tfoot'], closedByParent: true }),
      'tfoot': new HtmlTagDefinition({ closedByChildren: ['tbody'], closedByParent: true }),
      'tr': new HtmlTagDefinition({
          closedByChildren: ['tr'],
          requiredParents: ['tbody', 'tfoot', 'thead'],
          closedByParent: true
      }),
      'td': new HtmlTagDefinition({ closedByChildren: ['td', 'th'], closedByParent: true }),
      'th': new HtmlTagDefinition({ closedByChildren: ['td', 'th'], closedByParent: true }),
      'col': new HtmlTagDefinition({ requiredParents: ['colgroup'], isVoid: true }),
      'svg': new HtmlTagDefinition({ implicitNamespacePrefix: 'svg' }),
      'math': new HtmlTagDefinition({ implicitNamespacePrefix: 'math' }),
      'li': new HtmlTagDefinition({ closedByChildren: ['li'], closedByParent: true }),
      'dt': new HtmlTagDefinition({ closedByChildren: ['dt', 'dd'] }),
      'dd': new HtmlTagDefinition({ closedByChildren: ['dt', 'dd'], closedByParent: true }),
      'rb': new HtmlTagDefinition({ closedByChildren: ['rb', 'rt', 'rtc', 'rp'], closedByParent: true }),
      'rt': new HtmlTagDefinition({ closedByChildren: ['rb', 'rt', 'rtc', 'rp'], closedByParent: true }),
      'rtc': new HtmlTagDefinition({ closedByChildren: ['rb', 'rtc', 'rp'], closedByParent: true }),
      'rp': new HtmlTagDefinition({ closedByChildren: ['rb', 'rt', 'rtc', 'rp'], closedByParent: true }),
      'optgroup': new HtmlTagDefinition({ closedByChildren: ['optgroup'], closedByParent: true }),
      'option': new HtmlTagDefinition({ closedByChildren: ['option', 'optgroup'], closedByParent: true }),
      'pre': new HtmlTagDefinition({ ignoreFirstLf: true }),
      'listing': new HtmlTagDefinition({ ignoreFirstLf: true }),
      'style': new HtmlTagDefinition({ contentType: TagContentType.RAW_TEXT }),
      'script': new HtmlTagDefinition({ contentType: TagContentType.RAW_TEXT }),
      'title': new HtmlTagDefinition({ contentType: TagContentType.ESCAPABLE_RAW_TEXT }),
      'textarea': new HtmlTagDefinition({ contentType: TagContentType.ESCAPABLE_RAW_TEXT, ignoreFirstLf: true }),
  };
  var /** @type {?} */ _DEFAULT_TAG_DEFINITION = new HtmlTagDefinition();
  /**
   * @param {?} tagName
   * @return {?}
   */
  function getHtmlTagDefinition(tagName) {
      return TAG_DEFINITIONS[tagName.toLowerCase()] || _DEFAULT_TAG_DEFINITION;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var /** @type {?} */ TAG_TO_PLACEHOLDER_NAMES = {
      'A': 'LINK',
      'B': 'BOLD_TEXT',
      'BR': 'LINE_BREAK',
      'EM': 'EMPHASISED_TEXT',
      'H1': 'HEADING_LEVEL1',
      'H2': 'HEADING_LEVEL2',
      'H3': 'HEADING_LEVEL3',
      'H4': 'HEADING_LEVEL4',
      'H5': 'HEADING_LEVEL5',
      'H6': 'HEADING_LEVEL6',
      'HR': 'HORIZONTAL_RULE',
      'I': 'ITALIC_TEXT',
      'LI': 'LIST_ITEM',
      'LINK': 'MEDIA_LINK',
      'OL': 'ORDERED_LIST',
      'P': 'PARAGRAPH',
      'Q': 'QUOTATION',
      'S': 'STRIKETHROUGH_TEXT',
      'SMALL': 'SMALL_TEXT',
      'SUB': 'SUBSTRIPT',
      'SUP': 'SUPERSCRIPT',
      'TBODY': 'TABLE_BODY',
      'TD': 'TABLE_CELL',
      'TFOOT': 'TABLE_FOOTER',
      'TH': 'TABLE_HEADER_CELL',
      'THEAD': 'TABLE_HEADER',
      'TR': 'TABLE_ROW',
      'TT': 'MONOSPACED_TEXT',
      'U': 'UNDERLINED_TEXT',
      'UL': 'UNORDERED_LIST',
  };
  /**
   *  Creates unique names for placeholder with different content.
    * *
    * Returns the same placeholder name when the content is identical.
    * *
   */
  var PlaceholderRegistry = (function () {
      function PlaceholderRegistry() {
          this._placeHolderNameCounts = {};
          this._signatureToName = {};
      }
      /**
       * @param {?} tag
       * @param {?} attrs
       * @param {?} isVoid
       * @return {?}
       */
      PlaceholderRegistry.prototype.getStartTagPlaceholderName = function (tag, attrs, isVoid) {
          var /** @type {?} */ signature = this._hashTag(tag, attrs, isVoid);
          if (this._signatureToName[signature]) {
              return this._signatureToName[signature];
          }
          var /** @type {?} */ upperTag = tag.toUpperCase();
          var /** @type {?} */ baseName = TAG_TO_PLACEHOLDER_NAMES[upperTag] || "TAG_" + upperTag;
          var /** @type {?} */ name = this._generateUniqueName(isVoid ? baseName : "START_" + baseName);
          this._signatureToName[signature] = name;
          return name;
      };
      /**
       * @param {?} tag
       * @return {?}
       */
      PlaceholderRegistry.prototype.getCloseTagPlaceholderName = function (tag) {
          var /** @type {?} */ signature = this._hashClosingTag(tag);
          if (this._signatureToName[signature]) {
              return this._signatureToName[signature];
          }
          var /** @type {?} */ upperTag = tag.toUpperCase();
          var /** @type {?} */ baseName = TAG_TO_PLACEHOLDER_NAMES[upperTag] || "TAG_" + upperTag;
          var /** @type {?} */ name = this._generateUniqueName("CLOSE_" + baseName);
          this._signatureToName[signature] = name;
          return name;
      };
      /**
       * @param {?} name
       * @param {?} content
       * @return {?}
       */
      PlaceholderRegistry.prototype.getPlaceholderName = function (name, content) {
          var /** @type {?} */ upperName = name.toUpperCase();
          var /** @type {?} */ signature = "PH: " + upperName + "=" + content;
          if (this._signatureToName[signature]) {
              return this._signatureToName[signature];
          }
          var /** @type {?} */ uniqueName = this._generateUniqueName(upperName);
          this._signatureToName[signature] = uniqueName;
          return uniqueName;
      };
      /**
       * @param {?} name
       * @return {?}
       */
      PlaceholderRegistry.prototype.getUniquePlaceholder = function (name) {
          return this._generateUniqueName(name.toUpperCase());
      };
      /**
       * @param {?} tag
       * @param {?} attrs
       * @param {?} isVoid
       * @return {?}
       */
      PlaceholderRegistry.prototype._hashTag = function (tag, attrs, isVoid) {
          var /** @type {?} */ start = "<" + tag;
          var /** @type {?} */ strAttrs = Object.keys(attrs).sort().map(function (name) { return (" " + name + "=" + attrs[name]); }).join('');
          var /** @type {?} */ end = isVoid ? '/>' : "></" + tag + ">";
          return start + strAttrs + end;
      };
      /**
       * @param {?} tag
       * @return {?}
       */
      PlaceholderRegistry.prototype._hashClosingTag = function (tag) { return this._hashTag("/" + tag, {}, false); };
      /**
       * @param {?} base
       * @return {?}
       */
      PlaceholderRegistry.prototype._generateUniqueName = function (base) {
          var /** @type {?} */ next = this._placeHolderNameCounts[base];
          this._placeHolderNameCounts[base] = next ? next + 1 : 1;
          return next ? base + "_" + next : base;
      };
      return PlaceholderRegistry;
  }());

  var /** @type {?} */ _expParser = new Parser(new Lexer());
  /**
   *  Returns a function converting html nodes to an i18n Message given an interpolationConfig
   * @param {?} interpolationConfig
   * @return {?}
   */
  function createI18nMessageFactory(interpolationConfig) {
      var /** @type {?} */ visitor = new _I18nVisitor(_expParser, interpolationConfig);
      return function (nodes, meaning, description) {
          return visitor.toI18nMessage(nodes, meaning, description);
      };
  }
  var _I18nVisitor = (function () {
      /**
       * @param {?} _expressionParser
       * @param {?} _interpolationConfig
       */
      function _I18nVisitor(_expressionParser, _interpolationConfig) {
          this._expressionParser = _expressionParser;
          this._interpolationConfig = _interpolationConfig;
      }
      /**
       * @param {?} nodes
       * @param {?} meaning
       * @param {?} description
       * @return {?}
       */
      _I18nVisitor.prototype.toI18nMessage = function (nodes, meaning, description) {
          this._isIcu = nodes.length == 1 && nodes[0] instanceof Expansion;
          this._icuDepth = 0;
          this._placeholderRegistry = new PlaceholderRegistry();
          this._placeholderToContent = {};
          this._placeholderToMessage = {};
          var /** @type {?} */ i18nodes = visitAll(this, nodes, {});
          return new Message(i18nodes, this._placeholderToContent, this._placeholderToMessage, meaning, description);
      };
      /**
       * @param {?} el
       * @param {?} context
       * @return {?}
       */
      _I18nVisitor.prototype.visitElement = function (el, context) {
          var /** @type {?} */ children = visitAll(this, el.children);
          var /** @type {?} */ attrs = {};
          el.attrs.forEach(function (attr) {
              // Do not visit the attributes, translatable ones are top-level ASTs
              attrs[attr.name] = attr.value;
          });
          var /** @type {?} */ isVoid = getHtmlTagDefinition(el.name).isVoid;
          var /** @type {?} */ startPhName = this._placeholderRegistry.getStartTagPlaceholderName(el.name, attrs, isVoid);
          this._placeholderToContent[startPhName] = el.sourceSpan.toString();
          var /** @type {?} */ closePhName = '';
          if (!isVoid) {
              closePhName = this._placeholderRegistry.getCloseTagPlaceholderName(el.name);
              this._placeholderToContent[closePhName] = "</" + el.name + ">";
          }
          return new TagPlaceholder(el.name, attrs, startPhName, closePhName, children, isVoid, el.sourceSpan);
      };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      _I18nVisitor.prototype.visitAttribute = function (attribute, context) {
          return this._visitTextWithInterpolation(attribute.value, attribute.sourceSpan);
      };
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      _I18nVisitor.prototype.visitText = function (text, context) {
          return this._visitTextWithInterpolation(text.value, text.sourceSpan);
      };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      _I18nVisitor.prototype.visitComment = function (comment, context) { return null; };
      /**
       * @param {?} icu
       * @param {?} context
       * @return {?}
       */
      _I18nVisitor.prototype.visitExpansion = function (icu, context) {
          var _this = this;
          this._icuDepth++;
          var /** @type {?} */ i18nIcuCases = {};
          var /** @type {?} */ i18nIcu = new Icu(icu.switchValue, icu.type, i18nIcuCases, icu.sourceSpan);
          icu.cases.forEach(function (caze) {
              i18nIcuCases[caze.value] = new Container(caze.expression.map(function (node) { return node.visit(_this, {}); }), caze.expSourceSpan);
          });
          this._icuDepth--;
          if (this._isIcu || this._icuDepth > 0) {
              // Returns an ICU node when:
              // - the message (vs a part of the message) is an ICU message, or
              // - the ICU message is nested.
              var /** @type {?} */ expPh = this._placeholderRegistry.getUniquePlaceholder("VAR_" + icu.type);
              i18nIcu.expressionPlaceholder = expPh;
              this._placeholderToContent[expPh] = icu.switchValue;
              return i18nIcu;
          }
          // Else returns a placeholder
          // ICU placeholders should not be replaced with their original content but with the their
          // translations. We need to create a new visitor (they are not re-entrant) to compute the
          // message id.
          // TODO(vicb): add a html.Node -> i18n.Message cache to avoid having to re-create the msg
          var /** @type {?} */ phName = this._placeholderRegistry.getPlaceholderName('ICU', icu.sourceSpan.toString());
          var /** @type {?} */ visitor = new _I18nVisitor(this._expressionParser, this._interpolationConfig);
          this._placeholderToMessage[phName] = visitor.toI18nMessage([icu], '', '');
          return new IcuPlaceholder(i18nIcu, phName, icu.sourceSpan);
      };
      /**
       * @param {?} icuCase
       * @param {?} context
       * @return {?}
       */
      _I18nVisitor.prototype.visitExpansionCase = function (icuCase, context) {
          throw new Error('Unreachable code');
      };
      /**
       * @param {?} text
       * @param {?} sourceSpan
       * @return {?}
       */
      _I18nVisitor.prototype._visitTextWithInterpolation = function (text, sourceSpan) {
          var /** @type {?} */ splitInterpolation = this._expressionParser.splitInterpolation(text, sourceSpan.start.toString(), this._interpolationConfig);
          if (!splitInterpolation) {
              // No expression, return a single text
              return new Text$1(text, sourceSpan);
          }
          // Return a group of text + expressions
          var /** @type {?} */ nodes = [];
          var /** @type {?} */ container = new Container(nodes, sourceSpan);
          var _a = this._interpolationConfig, sDelimiter = _a.start, eDelimiter = _a.end;
          for (var /** @type {?} */ i = 0; i < splitInterpolation.strings.length - 1; i++) {
              var /** @type {?} */ expression = splitInterpolation.expressions[i];
              var /** @type {?} */ baseName = _extractPlaceholderName(expression) || 'INTERPOLATION';
              var /** @type {?} */ phName = this._placeholderRegistry.getPlaceholderName(baseName, expression);
              if (splitInterpolation.strings[i].length) {
                  // No need to add empty strings
                  nodes.push(new Text$1(splitInterpolation.strings[i], sourceSpan));
              }
              nodes.push(new Placeholder(expression, phName, sourceSpan));
              this._placeholderToContent[phName] = sDelimiter + expression + eDelimiter;
          }
          // The last index contains no expression
          var /** @type {?} */ lastStringIdx = splitInterpolation.strings.length - 1;
          if (splitInterpolation.strings[lastStringIdx].length) {
              nodes.push(new Text$1(splitInterpolation.strings[lastStringIdx], sourceSpan));
          }
          return container;
      };
      return _I18nVisitor;
  }());
  var /** @type {?} */ _CUSTOM_PH_EXP = /\/\/[\s\S]*i18n[\s\S]*\([\s\S]*ph[\s\S]*=[\s\S]*"([\s\S]*?)"[\s\S]*\)/g;
  /**
   * @param {?} input
   * @return {?}
   */
  function _extractPlaceholderName(input) {
      return input.split(_CUSTOM_PH_EXP)[1];
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$4 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  /**
   *  An i18n error.
   */
  var I18nError = (function (_super) {
      __extends$4(I18nError, _super);
      /**
       * @param {?} span
       * @param {?} msg
       */
      function I18nError(span, msg) {
          _super.call(this, span, msg);
      }
      return I18nError;
  }(ParseError));

  var /** @type {?} */ _I18N_ATTR = 'i18n';
  var /** @type {?} */ _I18N_ATTR_PREFIX = 'i18n-';
  var /** @type {?} */ _I18N_COMMENT_PREFIX_REGEXP = /^i18n:?/;
  /**
   *  Extract translatable messages from an html AST
   * @param {?} nodes
   * @param {?} interpolationConfig
   * @param {?} implicitTags
   * @param {?} implicitAttrs
   * @return {?}
   */
  function extractMessages(nodes, interpolationConfig, implicitTags, implicitAttrs) {
      var /** @type {?} */ visitor = new _Visitor(implicitTags, implicitAttrs);
      return visitor.extract(nodes, interpolationConfig);
  }
  /**
   * @param {?} nodes
   * @param {?} translations
   * @param {?} interpolationConfig
   * @param {?} implicitTags
   * @param {?} implicitAttrs
   * @return {?}
   */
  function mergeTranslations(nodes, translations, interpolationConfig, implicitTags, implicitAttrs) {
      var /** @type {?} */ visitor = new _Visitor(implicitTags, implicitAttrs);
      return visitor.merge(nodes, translations, interpolationConfig);
  }
  var ExtractionResult = (function () {
      /**
       * @param {?} messages
       * @param {?} errors
       */
      function ExtractionResult(messages, errors) {
          this.messages = messages;
          this.errors = errors;
      }
      return ExtractionResult;
  }());
  var _VisitorMode = {};
  _VisitorMode.Extract = 0;
  _VisitorMode.Merge = 1;
  _VisitorMode[_VisitorMode.Extract] = "Extract";
  _VisitorMode[_VisitorMode.Merge] = "Merge";
  /**
   *  This Visitor is used:
    * 1. to extract all the translatable strings from an html AST (see `extract()`),
    * 2. to replace the translatable strings with the actual translations (see `merge()`)
    * *
   */
  var _Visitor = (function () {
      /**
       * @param {?} _implicitTags
       * @param {?} _implicitAttrs
       */
      function _Visitor(_implicitTags, _implicitAttrs) {
          this._implicitTags = _implicitTags;
          this._implicitAttrs = _implicitAttrs;
      }
      /**
       *  Extracts the messages from the tree
       * @param {?} nodes
       * @param {?} interpolationConfig
       * @return {?}
       */
      _Visitor.prototype.extract = function (nodes, interpolationConfig) {
          var _this = this;
          this._init(_VisitorMode.Extract, interpolationConfig);
          nodes.forEach(function (node) { return node.visit(_this, null); });
          if (this._inI18nBlock) {
              this._reportError(nodes[nodes.length - 1], 'Unclosed block');
          }
          return new ExtractionResult(this._messages, this._errors);
      };
      /**
       *  Returns a tree where all translatable nodes are translated
       * @param {?} nodes
       * @param {?} translations
       * @param {?} interpolationConfig
       * @return {?}
       */
      _Visitor.prototype.merge = function (nodes, translations, interpolationConfig) {
          this._init(_VisitorMode.Merge, interpolationConfig);
          this._translations = translations;
          // Construct a single fake root element
          var /** @type {?} */ wrapper = new Element('wrapper', [], nodes, null, null, null);
          var /** @type {?} */ translatedNode = wrapper.visit(this, null);
          if (this._inI18nBlock) {
              this._reportError(nodes[nodes.length - 1], 'Unclosed block');
          }
          return new ParseTreeResult(translatedNode.children, this._errors);
      };
      /**
       * @param {?} icuCase
       * @param {?} context
       * @return {?}
       */
      _Visitor.prototype.visitExpansionCase = function (icuCase, context) {
          // Parse cases for translatable html attributes
          var /** @type {?} */ expression = visitAll(this, icuCase.expression, context);
          if (this._mode === _VisitorMode.Merge) {
              return new ExpansionCase(icuCase.value, expression, icuCase.sourceSpan, icuCase.valueSourceSpan, icuCase.expSourceSpan);
          }
      };
      /**
       * @param {?} icu
       * @param {?} context
       * @return {?}
       */
      _Visitor.prototype.visitExpansion = function (icu, context) {
          this._mayBeAddBlockChildren(icu);
          var /** @type {?} */ wasInIcu = this._inIcu;
          if (!this._inIcu) {
              // nested ICU messages should not be extracted but top-level translated as a whole
              if (this._isInTranslatableSection) {
                  this._addMessage([icu]);
              }
              this._inIcu = true;
          }
          var /** @type {?} */ cases = visitAll(this, icu.cases, context);
          if (this._mode === _VisitorMode.Merge) {
              icu = new Expansion(icu.switchValue, icu.type, cases, icu.sourceSpan, icu.switchValueSourceSpan);
          }
          this._inIcu = wasInIcu;
          return icu;
      };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      _Visitor.prototype.visitComment = function (comment, context) {
          var /** @type {?} */ isOpening = _isOpeningComment(comment);
          if (isOpening && this._isInTranslatableSection) {
              this._reportError(comment, 'Could not start a block inside a translatable section');
              return;
          }
          var /** @type {?} */ isClosing = _isClosingComment(comment);
          if (isClosing && !this._inI18nBlock) {
              this._reportError(comment, 'Trying to close an unopened block');
              return;
          }
          if (!this._inI18nNode && !this._inIcu) {
              if (!this._inI18nBlock) {
                  if (isOpening) {
                      this._inI18nBlock = true;
                      this._blockStartDepth = this._depth;
                      this._blockChildren = [];
                      this._blockMeaningAndDesc = comment.value.replace(_I18N_COMMENT_PREFIX_REGEXP, '').trim();
                      this._openTranslatableSection(comment);
                  }
              }
              else {
                  if (isClosing) {
                      if (this._depth == this._blockStartDepth) {
                          this._closeTranslatableSection(comment, this._blockChildren);
                          this._inI18nBlock = false;
                          var /** @type {?} */ message = this._addMessage(this._blockChildren, this._blockMeaningAndDesc);
                          // merge attributes in sections
                          var /** @type {?} */ nodes = this._translateMessage(comment, message);
                          return visitAll(this, nodes);
                      }
                      else {
                          this._reportError(comment, 'I18N blocks should not cross element boundaries');
                          return;
                      }
                  }
              }
          }
      };
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      _Visitor.prototype.visitText = function (text, context) {
          if (this._isInTranslatableSection) {
              this._mayBeAddBlockChildren(text);
          }
          return text;
      };
      /**
       * @param {?} el
       * @param {?} context
       * @return {?}
       */
      _Visitor.prototype.visitElement = function (el, context) {
          var _this = this;
          this._mayBeAddBlockChildren(el);
          this._depth++;
          var /** @type {?} */ wasInI18nNode = this._inI18nNode;
          var /** @type {?} */ wasInImplicitNode = this._inImplicitNode;
          var /** @type {?} */ childNodes;
          // Extract only top level nodes with the (implicit) "i18n" attribute if not in a block or an ICU
          // message
          var /** @type {?} */ i18nAttr = _getI18nAttr(el);
          var /** @type {?} */ isImplicit = this._implicitTags.some(function (tag) { return el.name === tag; }) && !this._inIcu &&
              !this._isInTranslatableSection;
          var /** @type {?} */ isTopLevelImplicit = !wasInImplicitNode && isImplicit;
          this._inImplicitNode = this._inImplicitNode || isImplicit;
          if (!this._isInTranslatableSection && !this._inIcu) {
              if (i18nAttr) {
                  // explicit translation
                  this._inI18nNode = true;
                  var /** @type {?} */ message = this._addMessage(el.children, i18nAttr.value);
                  childNodes = this._translateMessage(el, message);
              }
              else if (isTopLevelImplicit) {
                  // implicit translation
                  this._inI18nNode = true;
                  var /** @type {?} */ message = this._addMessage(el.children);
                  childNodes = this._translateMessage(el, message);
              }
              if (this._mode == _VisitorMode.Extract) {
                  var /** @type {?} */ isTranslatable = i18nAttr || isTopLevelImplicit;
                  if (isTranslatable) {
                      this._openTranslatableSection(el);
                  }
                  visitAll(this, el.children);
                  if (isTranslatable) {
                      this._closeTranslatableSection(el, el.children);
                  }
              }
              if (this._mode === _VisitorMode.Merge && !i18nAttr && !isTopLevelImplicit) {
                  childNodes = [];
                  el.children.forEach(function (child) {
                      var /** @type {?} */ visited = child.visit(_this, context);
                      if (visited && !_this._isInTranslatableSection) {
                          // Do not add the children from translatable sections (= i18n blocks here)
                          // They will be added when the section is close (i.e. on `<!-- /i18n -->`)
                          childNodes = childNodes.concat(visited);
                      }
                  });
              }
          }
          else {
              if (i18nAttr || isTopLevelImplicit) {
                  this._reportError(el, 'Could not mark an element as translatable inside a translatable section');
              }
              if (this._mode == _VisitorMode.Extract) {
                  // Descend into child nodes for extraction
                  visitAll(this, el.children);
              }
              if (this._mode == _VisitorMode.Merge) {
                  // Translate attributes in ICU messages
                  childNodes = [];
                  el.children.forEach(function (child) {
                      var /** @type {?} */ visited = child.visit(_this, context);
                      if (visited && !_this._isInTranslatableSection) {
                          // Do not add the children from translatable sections (= i18n blocks here)
                          // They will be added when the section is close (i.e. on `<!-- /i18n -->`)
                          childNodes = childNodes.concat(visited);
                      }
                  });
              }
          }
          this._visitAttributesOf(el);
          this._depth--;
          this._inI18nNode = wasInI18nNode;
          this._inImplicitNode = wasInImplicitNode;
          if (this._mode === _VisitorMode.Merge) {
              // There are no childNodes in translatable sections - those nodes will be replace anyway
              var /** @type {?} */ translatedAttrs = this._translateAttributes(el);
              return new Element(el.name, translatedAttrs, childNodes, el.sourceSpan, el.startSourceSpan, el.endSourceSpan);
          }
      };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      _Visitor.prototype.visitAttribute = function (attribute, context) {
          throw new Error('unreachable code');
      };
      /**
       * @param {?} mode
       * @param {?} interpolationConfig
       * @return {?}
       */
      _Visitor.prototype._init = function (mode, interpolationConfig) {
          this._mode = mode;
          this._inI18nBlock = false;
          this._inI18nNode = false;
          this._depth = 0;
          this._inIcu = false;
          this._msgCountAtSectionStart = void 0;
          this._errors = [];
          this._messages = [];
          this._inImplicitNode = false;
          this._createI18nMessage = createI18nMessageFactory(interpolationConfig);
      };
      /**
       * @param {?} el
       * @return {?}
       */
      _Visitor.prototype._visitAttributesOf = function (el) {
          var _this = this;
          var /** @type {?} */ explicitAttrNameToValue = {};
          var /** @type {?} */ implicitAttrNames = this._implicitAttrs[el.name] || [];
          el.attrs.filter(function (attr) { return attr.name.startsWith(_I18N_ATTR_PREFIX); })
              .forEach(function (attr) { return explicitAttrNameToValue[attr.name.slice(_I18N_ATTR_PREFIX.length)] =
              attr.value; });
          el.attrs.forEach(function (attr) {
              if (attr.name in explicitAttrNameToValue) {
                  _this._addMessage([attr], explicitAttrNameToValue[attr.name]);
              }
              else if (implicitAttrNames.some(function (name) { return attr.name === name; })) {
                  _this._addMessage([attr]);
              }
          });
      };
      /**
       * @param {?} ast
       * @param {?=} meaningAndDesc
       * @return {?}
       */
      _Visitor.prototype._addMessage = function (ast, meaningAndDesc) {
          if (ast.length == 0 ||
              ast.length == 1 && ast[0] instanceof Attribute$1 && !((ast[0])).value) {
              // Do not create empty messages
              return;
          }
          var _a = _splitMeaningAndDesc(meaningAndDesc), meaning = _a[0], description = _a[1];
          var /** @type {?} */ message = this._createI18nMessage(ast, meaning, description);
          this._messages.push(message);
          return message;
      };
      /**
       * @param {?} el
       * @param {?} message
       * @return {?}
       */
      _Visitor.prototype._translateMessage = function (el, message) {
          if (message && this._mode === _VisitorMode.Merge) {
              var /** @type {?} */ nodes = this._translations.get(message);
              if (nodes) {
                  return nodes;
              }
              this._reportError(el, "Translation unavailable for message id=\"" + this._translations.digest(message) + "\"");
          }
          return [];
      };
      /**
       * @param {?} el
       * @return {?}
       */
      _Visitor.prototype._translateAttributes = function (el) {
          var _this = this;
          var /** @type {?} */ attributes = el.attrs;
          var /** @type {?} */ i18nAttributeMeanings = {};
          attributes.forEach(function (attr) {
              if (attr.name.startsWith(_I18N_ATTR_PREFIX)) {
                  i18nAttributeMeanings[attr.name.slice(_I18N_ATTR_PREFIX.length)] =
                      _splitMeaningAndDesc(attr.value)[0];
              }
          });
          var /** @type {?} */ translatedAttributes = [];
          attributes.forEach(function (attr) {
              if (attr.name === _I18N_ATTR || attr.name.startsWith(_I18N_ATTR_PREFIX)) {
                  // strip i18n specific attributes
                  return;
              }
              if (attr.value && attr.value != '' && i18nAttributeMeanings.hasOwnProperty(attr.name)) {
                  var /** @type {?} */ meaning = i18nAttributeMeanings[attr.name];
                  var /** @type {?} */ message = _this._createI18nMessage([attr], meaning, '');
                  var /** @type {?} */ nodes = _this._translations.get(message);
                  if (nodes) {
                      if (nodes[0] instanceof Text) {
                          var /** @type {?} */ value = ((nodes[0])).value;
                          translatedAttributes.push(new Attribute$1(attr.name, value, attr.sourceSpan));
                      }
                      else {
                          _this._reportError(el, "Unexpected translation for attribute \"" + attr.name + "\" (id=\"" + _this._translations.digest(message) + "\")");
                      }
                  }
                  else {
                      _this._reportError(el, "Translation unavailable for attribute \"" + attr.name + "\" (id=\"" + _this._translations.digest(message) + "\")");
                  }
              }
              else {
                  translatedAttributes.push(attr);
              }
          });
          return translatedAttributes;
      };
      /**
       *  Add the node as a child of the block when:
        * - we are in a block,
        * - we are not inside a ICU message (those are handled separately),
        * - the node is a "direct child" of the block
       * @param {?} node
       * @return {?}
       */
      _Visitor.prototype._mayBeAddBlockChildren = function (node) {
          if (this._inI18nBlock && !this._inIcu && this._depth == this._blockStartDepth) {
              this._blockChildren.push(node);
          }
      };
      /**
       *  Marks the start of a section, see `_endSection`
       * @param {?} node
       * @return {?}
       */
      _Visitor.prototype._openTranslatableSection = function (node) {
          if (this._isInTranslatableSection) {
              this._reportError(node, 'Unexpected section start');
          }
          else {
              this._msgCountAtSectionStart = this._messages.length;
          }
      };
      Object.defineProperty(_Visitor.prototype, "_isInTranslatableSection", {
          /**
           *  A translatable section could be:
            * - a translatable element,
            * - nodes between `<!-- i18n -->` and `<!-- /i18n -->` comments
           * @return {?}
           */
          get: function () {
              return this._msgCountAtSectionStart !== void 0;
          },
          enumerable: true,
          configurable: true
      });
      /**
       *  Terminates a section.
        * *
        * If a section has only one significant children (comments not significant) then we should not
        * keep the message from this children:
        * *
        * `<p i18n="meaning|description">{ICU message}</p>` would produce two messages:
        * - one for the <p> content with meaning and description,
        * - another one for the ICU message.
        * *
        * In this case the last message is discarded as it contains less information (the AST is
        * otherwise identical).
        * *
        * Note that we should still keep messages extracted from attributes inside the section (ie in the
        * ICU message here)
       * @param {?} node
       * @param {?} directChildren
       * @return {?}
       */
      _Visitor.prototype._closeTranslatableSection = function (node, directChildren) {
          if (!this._isInTranslatableSection) {
              this._reportError(node, 'Unexpected section end');
              return;
          }
          var /** @type {?} */ startIndex = this._msgCountAtSectionStart;
          var /** @type {?} */ significantChildren = directChildren.reduce(function (count, node) { return count + (node instanceof Comment ? 0 : 1); }, 0);
          if (significantChildren == 1) {
              for (var /** @type {?} */ i = this._messages.length - 1; i >= startIndex; i--) {
                  var /** @type {?} */ ast = this._messages[i].nodes;
                  if (!(ast.length == 1 && ast[0] instanceof Text$1)) {
                      this._messages.splice(i, 1);
                      break;
                  }
              }
          }
          this._msgCountAtSectionStart = void 0;
      };
      /**
       * @param {?} node
       * @param {?} msg
       * @return {?}
       */
      _Visitor.prototype._reportError = function (node, msg) {
          this._errors.push(new I18nError(node.sourceSpan, msg));
      };
      return _Visitor;
  }());
  /**
   * @param {?} n
   * @return {?}
   */
  function _isOpeningComment(n) {
      return n instanceof Comment && n.value && n.value.startsWith('i18n');
  }
  /**
   * @param {?} n
   * @return {?}
   */
  function _isClosingComment(n) {
      return n instanceof Comment && n.value && n.value === '/i18n';
  }
  /**
   * @param {?} p
   * @return {?}
   */
  function _getI18nAttr(p) {
      return p.attrs.find(function (attr) { return attr.name === _I18N_ATTR; }) || null;
  }
  /**
   * @param {?} i18n
   * @return {?}
   */
  function _splitMeaningAndDesc(i18n) {
      if (!i18n)
          return ['', ''];
      var /** @type {?} */ pipeIndex = i18n.indexOf('|');
      return pipeIndex == -1 ? ['', i18n] : [i18n.slice(0, pipeIndex), i18n.slice(pipeIndex + 1)];
  }

  var XmlTagDefinition = (function () {
      function XmlTagDefinition() {
          this.closedByParent = false;
          this.contentType = TagContentType.PARSABLE_DATA;
          this.isVoid = false;
          this.ignoreFirstLf = false;
          this.canSelfClose = true;
      }
      /**
       * @param {?} currentParent
       * @return {?}
       */
      XmlTagDefinition.prototype.requireExtraParent = function (currentParent) { return false; };
      /**
       * @param {?} name
       * @return {?}
       */
      XmlTagDefinition.prototype.isClosedByChild = function (name) { return false; };
      return XmlTagDefinition;
  }());
  var /** @type {?} */ _TAG_DEFINITION = new XmlTagDefinition();
  /**
   * @param {?} tagName
   * @return {?}
   */
  function getXmlTagDefinition(tagName) {
      return _TAG_DEFINITION;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$5 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var XmlParser = (function (_super) {
      __extends$5(XmlParser, _super);
      function XmlParser() {
          _super.call(this, getXmlTagDefinition);
      }
      /**
       * @param {?} source
       * @param {?} url
       * @param {?=} parseExpansionForms
       * @return {?}
       */
      XmlParser.prototype.parse = function (source, url, parseExpansionForms) {
          if (parseExpansionForms === void 0) { parseExpansionForms = false; }
          return _super.prototype.parse.call(this, source, url, parseExpansionForms, null);
      };
      return XmlParser;
  }(Parser$1));

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$6 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  /**
   * @param {?} message
   * @return {?}
   */
  function digest(message) {
      return sha1(serializeNodes(message.nodes).join('') + ("[" + message.meaning + "]"));
  }
  /**
   * @param {?} message
   * @return {?}
   */
  function decimalDigest(message) {
      var /** @type {?} */ visitor = new _SerializerIgnoreIcuExpVisitor();
      var /** @type {?} */ parts = message.nodes.map(function (a) { return a.visit(visitor, null); });
      return computeMsgId(parts.join(''), message.meaning);
  }
  /**
   *  Serialize the i18n ast to something xml-like in order to generate an UID.
    * *
    * The visitor is also used in the i18n parser tests
    * *
   */
  var _SerializerVisitor = (function () {
      function _SerializerVisitor() {
      }
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      _SerializerVisitor.prototype.visitText = function (text, context) { return text.value; };
      /**
       * @param {?} container
       * @param {?} context
       * @return {?}
       */
      _SerializerVisitor.prototype.visitContainer = function (container, context) {
          var _this = this;
          return "[" + container.children.map(function (child) { return child.visit(_this); }).join(', ') + "]";
      };
      /**
       * @param {?} icu
       * @param {?} context
       * @return {?}
       */
      _SerializerVisitor.prototype.visitIcu = function (icu, context) {
          var _this = this;
          var /** @type {?} */ strCases = Object.keys(icu.cases).map(function (k) { return (k + " {" + icu.cases[k].visit(_this) + "}"); });
          return "{" + icu.expression + ", " + icu.type + ", " + strCases.join(', ') + "}";
      };
      /**
       * @param {?} ph
       * @param {?} context
       * @return {?}
       */
      _SerializerVisitor.prototype.visitTagPlaceholder = function (ph, context) {
          var _this = this;
          return ph.isVoid ?
              "<ph tag name=\"" + ph.startName + "\"/>" :
              "<ph tag name=\"" + ph.startName + "\">" + ph.children.map(function (child) { return child.visit(_this); }).join(', ') + "</ph name=\"" + ph.closeName + "\">";
      };
      /**
       * @param {?} ph
       * @param {?} context
       * @return {?}
       */
      _SerializerVisitor.prototype.visitPlaceholder = function (ph, context) {
          return ph.value ? "<ph name=\"" + ph.name + "\">" + ph.value + "</ph>" : "<ph name=\"" + ph.name + "\"/>";
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      _SerializerVisitor.prototype.visitIcuPlaceholder = function (ph, context) {
          return "<ph icu name=\"" + ph.name + "\">" + ph.value.visit(this) + "</ph>";
      };
      return _SerializerVisitor;
  }());
  var /** @type {?} */ serializerVisitor = new _SerializerVisitor();
  /**
   * @param {?} nodes
   * @return {?}
   */
  function serializeNodes(nodes) {
      return nodes.map(function (a) { return a.visit(serializerVisitor, null); });
  }
  /**
   *  Serialize the i18n ast to something xml-like in order to generate an UID.
    * *
    * Ignore the ICU expressions so that message IDs stays identical if only the expression changes.
    * *
   */
  var _SerializerIgnoreIcuExpVisitor = (function (_super) {
      __extends$6(_SerializerIgnoreIcuExpVisitor, _super);
      function _SerializerIgnoreIcuExpVisitor() {
          _super.apply(this, arguments);
      }
      /**
       * @param {?} icu
       * @param {?} context
       * @return {?}
       */
      _SerializerIgnoreIcuExpVisitor.prototype.visitIcu = function (icu, context) {
          var _this = this;
          var /** @type {?} */ strCases = Object.keys(icu.cases).map(function (k) { return (k + " {" + icu.cases[k].visit(_this) + "}"); });
          // Do not take the expression into account
          return "{" + icu.type + ", " + strCases.join(', ') + "}";
      };
      return _SerializerIgnoreIcuExpVisitor;
  }(_SerializerVisitor));
  /**
   *  Compute the SHA1 of the given string
    * *
    * see http://csrc.nist.gov/publications/fips/fips180-4/fips-180-4.pdf
    * *
    * WARNING: this function has not been designed not tested with security in mind.
    * DO NOT USE IT IN A SECURITY SENSITIVE CONTEXT.
   * @param {?} str
   * @return {?}
   */
  function sha1(str) {
      var /** @type {?} */ utf8 = utf8Encode(str);
      var /** @type {?} */ words32 = stringToWords32(utf8, Endian.Big);
      var /** @type {?} */ len = utf8.length * 8;
      var /** @type {?} */ w = new Array(80);
      var _a = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0], a = _a[0], b = _a[1], c = _a[2], d = _a[3], e = _a[4];
      words32[len >> 5] |= 0x80 << (24 - len % 32);
      words32[((len + 64 >> 9) << 4) + 15] = len;
      for (var /** @type {?} */ i = 0; i < words32.length; i += 16) {
          var _b = [a, b, c, d, e], h0 = _b[0], h1 = _b[1], h2 = _b[2], h3 = _b[3], h4 = _b[4];
          for (var /** @type {?} */ j = 0; j < 80; j++) {
              if (j < 16) {
                  w[j] = words32[i + j];
              }
              else {
                  w[j] = rol32(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1);
              }
              var _c = fk(j, b, c, d), f = _c[0], k = _c[1];
              var /** @type {?} */ temp = [rol32(a, 5), f, e, k, w[j]].reduce(add32);
              _d = [d, c, rol32(b, 30), a, temp], e = _d[0], d = _d[1], c = _d[2], b = _d[3], a = _d[4];
          }
          _e = [add32(a, h0), add32(b, h1), add32(c, h2), add32(d, h3), add32(e, h4)], a = _e[0], b = _e[1], c = _e[2], d = _e[3], e = _e[4];
      }
      return byteStringToHexString(words32ToByteString([a, b, c, d, e]));
      var _d, _e;
  }
  /**
   * @param {?} index
   * @param {?} b
   * @param {?} c
   * @param {?} d
   * @return {?}
   */
  function fk(index, b, c, d) {
      if (index < 20) {
          return [(b & c) | (~b & d), 0x5a827999];
      }
      if (index < 40) {
          return [b ^ c ^ d, 0x6ed9eba1];
      }
      if (index < 60) {
          return [(b & c) | (b & d) | (c & d), 0x8f1bbcdc];
      }
      return [b ^ c ^ d, 0xca62c1d6];
  }
  /**
   *  Compute the fingerprint of the given string
    * *
    * The output is 64 bit number encoded as a decimal string
    * *
    * based on:
    * https://github.com/google/closure-compiler/blob/master/src/com/google/javascript/jscomp/GoogleJsMessageIdGenerator.java
   * @param {?} str
   * @return {?}
   */
  function fingerprint(str) {
      var /** @type {?} */ utf8 = utf8Encode(str);
      var _a = [hash32(utf8, 0), hash32(utf8, 102072)], hi = _a[0], lo = _a[1];
      if (hi == 0 && (lo == 0 || lo == 1)) {
          hi = hi ^ 0x130f9bef;
          lo = lo ^ -0x6b5f56d8;
      }
      return [hi, lo];
  }
  /**
   * @param {?} msg
   * @param {?} meaning
   * @return {?}
   */
  function computeMsgId(msg, meaning) {
      var _a = fingerprint(msg), hi = _a[0], lo = _a[1];
      if (meaning) {
          var _b = fingerprint(meaning), him = _b[0], lom = _b[1];
          _c = add64(rol64([hi, lo], 1), [him, lom]), hi = _c[0], lo = _c[1];
      }
      return byteStringToDecString(words32ToByteString([hi & 0x7fffffff, lo]));
      var _c;
  }
  /**
   * @param {?} str
   * @param {?} c
   * @return {?}
   */
  function hash32(str, c) {
      var _a = [0x9e3779b9, 0x9e3779b9], a = _a[0], b = _a[1];
      var /** @type {?} */ i;
      var /** @type {?} */ len = str.length;
      for (i = 0; i + 12 <= len; i += 12) {
          a = add32(a, wordAt(str, i, Endian.Little));
          b = add32(b, wordAt(str, i + 4, Endian.Little));
          c = add32(c, wordAt(str, i + 8, Endian.Little));
          _b = mix([a, b, c]), a = _b[0], b = _b[1], c = _b[2];
      }
      a = add32(a, wordAt(str, i, Endian.Little));
      b = add32(b, wordAt(str, i + 4, Endian.Little));
      // the first byte of c is reserved for the length
      c = add32(c, len);
      c = add32(c, wordAt(str, i + 8, Endian.Little) << 8);
      return mix([a, b, c])[2];
      var _b;
  }
  /**
   * @param {?} __0
   * @return {?}
   */
  function mix(_a) {
      var a = _a[0], b = _a[1], c = _a[2];
      a = sub32(a, b);
      a = sub32(a, c);
      a ^= c >>> 13;
      b = sub32(b, c);
      b = sub32(b, a);
      b ^= a << 8;
      c = sub32(c, a);
      c = sub32(c, b);
      c ^= b >>> 13;
      a = sub32(a, b);
      a = sub32(a, c);
      a ^= c >>> 12;
      b = sub32(b, c);
      b = sub32(b, a);
      b ^= a << 16;
      c = sub32(c, a);
      c = sub32(c, b);
      c ^= b >>> 5;
      a = sub32(a, b);
      a = sub32(a, c);
      a ^= c >>> 3;
      b = sub32(b, c);
      b = sub32(b, a);
      b ^= a << 10;
      c = sub32(c, a);
      c = sub32(c, b);
      c ^= b >>> 15;
      return [a, b, c];
  }
  var Endian = {};
  Endian.Little = 0;
  Endian.Big = 1;
  Endian[Endian.Little] = "Little";
  Endian[Endian.Big] = "Big";
  /**
   * @param {?} str
   * @return {?}
   */
  function utf8Encode(str) {
      var /** @type {?} */ encoded = '';
      for (var /** @type {?} */ index = 0; index < str.length; index++) {
          var /** @type {?} */ codePoint = decodeSurrogatePairs(str, index);
          if (codePoint <= 0x7f) {
              encoded += String.fromCharCode(codePoint);
          }
          else if (codePoint <= 0x7ff) {
              encoded += String.fromCharCode(0xc0 | codePoint >>> 6, 0x80 | codePoint & 0x3f);
          }
          else if (codePoint <= 0xffff) {
              encoded += String.fromCharCode(0xe0 | codePoint >>> 12, 0x80 | codePoint >>> 6 & 0x3f, 0x80 | codePoint & 0x3f);
          }
          else if (codePoint <= 0x1fffff) {
              encoded += String.fromCharCode(0xf0 | codePoint >>> 18, 0x80 | codePoint >>> 12 & 0x3f, 0x80 | codePoint >>> 6 & 0x3f, 0x80 | codePoint & 0x3f);
          }
      }
      return encoded;
  }
  /**
   * @param {?} str
   * @param {?} index
   * @return {?}
   */
  function decodeSurrogatePairs(str, index) {
      if (index < 0 || index >= str.length) {
          throw new Error("index=" + index + " is out of range in \"" + str + "\"");
      }
      var /** @type {?} */ high = str.charCodeAt(index);
      if (high >= 0xd800 && high <= 0xdfff && str.length > index + 1) {
          var /** @type {?} */ low = byteAt(str, index + 1);
          if (low >= 0xdc00 && low <= 0xdfff) {
              return (high - 0xd800) * 0x400 + low - 0xdc00 + 0x10000;
          }
      }
      return high;
  }
  /**
   * @param {?} a
   * @param {?} b
   * @return {?}
   */
  function add32(a, b) {
      return add32to64(a, b)[1];
  }
  /**
   * @param {?} a
   * @param {?} b
   * @return {?}
   */
  function add32to64(a, b) {
      var /** @type {?} */ low = (a & 0xffff) + (b & 0xffff);
      var /** @type {?} */ high = (a >>> 16) + (b >>> 16) + (low >>> 16);
      return [high >>> 16, (high << 16) | (low & 0xffff)];
  }
  /**
   * @param {?} __0
   * @param {?} __1
   * @return {?}
   */
  function add64(_a, _b) {
      var ah = _a[0], al = _a[1];
      var bh = _b[0], bl = _b[1];
      var _c = add32to64(al, bl), carry = _c[0], l = _c[1];
      var /** @type {?} */ h = add32(add32(ah, bh), carry);
      return [h, l];
  }
  /**
   * @param {?} a
   * @param {?} b
   * @return {?}
   */
  function sub32(a, b) {
      var /** @type {?} */ low = (a & 0xffff) - (b & 0xffff);
      var /** @type {?} */ high = (a >> 16) - (b >> 16) + (low >> 16);
      return (high << 16) | (low & 0xffff);
  }
  /**
   * @param {?} a
   * @param {?} count
   * @return {?}
   */
  function rol32(a, count) {
      return (a << count) | (a >>> (32 - count));
  }
  /**
   * @param {?} __0
   * @param {?} count
   * @return {?}
   */
  function rol64(_a, count) {
      var hi = _a[0], lo = _a[1];
      var /** @type {?} */ h = (hi << count) | (lo >>> (32 - count));
      var /** @type {?} */ l = (lo << count) | (hi >>> (32 - count));
      return [h, l];
  }
  /**
   * @param {?} str
   * @param {?} endian
   * @return {?}
   */
  function stringToWords32(str, endian) {
      var /** @type {?} */ words32 = Array((str.length + 3) >>> 2);
      for (var /** @type {?} */ i = 0; i < words32.length; i++) {
          words32[i] = wordAt(str, i * 4, endian);
      }
      return words32;
  }
  /**
   * @param {?} str
   * @param {?} index
   * @return {?}
   */
  function byteAt(str, index) {
      return index >= str.length ? 0 : str.charCodeAt(index) & 0xff;
  }
  /**
   * @param {?} str
   * @param {?} index
   * @param {?} endian
   * @return {?}
   */
  function wordAt(str, index, endian) {
      var /** @type {?} */ word = 0;
      if (endian === Endian.Big) {
          for (var /** @type {?} */ i = 0; i < 4; i++) {
              word += byteAt(str, index + i) << (24 - 8 * i);
          }
      }
      else {
          for (var /** @type {?} */ i = 0; i < 4; i++) {
              word += byteAt(str, index + i) << 8 * i;
          }
      }
      return word;
  }
  /**
   * @param {?} words32
   * @return {?}
   */
  function words32ToByteString(words32) {
      return words32.reduce(function (str, word) { return str + word32ToByteString(word); }, '');
  }
  /**
   * @param {?} word
   * @return {?}
   */
  function word32ToByteString(word) {
      var /** @type {?} */ str = '';
      for (var /** @type {?} */ i = 0; i < 4; i++) {
          str += String.fromCharCode((word >>> 8 * (3 - i)) & 0xff);
      }
      return str;
  }
  /**
   * @param {?} str
   * @return {?}
   */
  function byteStringToHexString(str) {
      var /** @type {?} */ hex = '';
      for (var /** @type {?} */ i = 0; i < str.length; i++) {
          var /** @type {?} */ b = byteAt(str, i);
          hex += (b >>> 4).toString(16) + (b & 0x0f).toString(16);
      }
      return hex.toLowerCase();
  }
  /**
   * @param {?} str
   * @return {?}
   */
  function byteStringToDecString(str) {
      var /** @type {?} */ decimal = '';
      var /** @type {?} */ toThePower = '1';
      for (var /** @type {?} */ i = str.length - 1; i >= 0; i--) {
          decimal = addBigInt(decimal, numberTimesBigInt(byteAt(str, i), toThePower));
          toThePower = numberTimesBigInt(256, toThePower);
      }
      return decimal.split('').reverse().join('');
  }
  /**
   * @param {?} x
   * @param {?} y
   * @return {?}
   */
  function addBigInt(x, y) {
      var /** @type {?} */ sum = '';
      var /** @type {?} */ len = Math.max(x.length, y.length);
      for (var /** @type {?} */ i = 0, /** @type {?} */ carry = 0; i < len || carry; i++) {
          var /** @type {?} */ tmpSum = carry + +(x[i] || 0) + +(y[i] || 0);
          if (tmpSum >= 10) {
              carry = 1;
              sum += tmpSum - 10;
          }
          else {
              carry = 0;
              sum += tmpSum;
          }
      }
      return sum;
  }
  /**
   * @param {?} num
   * @param {?} b
   * @return {?}
   */
  function numberTimesBigInt(num, b) {
      var /** @type {?} */ product = '';
      var /** @type {?} */ bToThePower = b;
      for (; num !== 0; num = num >>> 1) {
          if (num & 1)
              product = addBigInt(product, bToThePower);
          bToThePower = addBigInt(bToThePower, bToThePower);
      }
      return product;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$7 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var _Visitor$1 = (function () {
      function _Visitor() {
      }
      /**
       * @param {?} tag
       * @return {?}
       */
      _Visitor.prototype.visitTag = function (tag) {
          var _this = this;
          var /** @type {?} */ strAttrs = this._serializeAttributes(tag.attrs);
          if (tag.children.length == 0) {
              return "<" + tag.name + strAttrs + "/>";
          }
          var /** @type {?} */ strChildren = tag.children.map(function (node) { return node.visit(_this); });
          return "<" + tag.name + strAttrs + ">" + strChildren.join('') + "</" + tag.name + ">";
      };
      /**
       * @param {?} text
       * @return {?}
       */
      _Visitor.prototype.visitText = function (text) { return text.value; };
      /**
       * @param {?} decl
       * @return {?}
       */
      _Visitor.prototype.visitDeclaration = function (decl) {
          return "<?xml" + this._serializeAttributes(decl.attrs) + " ?>";
      };
      /**
       * @param {?} attrs
       * @return {?}
       */
      _Visitor.prototype._serializeAttributes = function (attrs) {
          var /** @type {?} */ strAttrs = Object.keys(attrs).map(function (name) { return (name + "=\"" + attrs[name] + "\""); }).join(' ');
          return strAttrs.length > 0 ? ' ' + strAttrs : '';
      };
      /**
       * @param {?} doctype
       * @return {?}
       */
      _Visitor.prototype.visitDoctype = function (doctype) {
          return "<!DOCTYPE " + doctype.rootTag + " [\n" + doctype.dtd + "\n]>";
      };
      return _Visitor;
  }());
  var /** @type {?} */ _visitor = new _Visitor$1();
  /**
   * @param {?} nodes
   * @return {?}
   */
  function serialize(nodes) {
      return nodes.map(function (node) { return node.visit(_visitor); }).join('');
  }
  var Declaration = (function () {
      /**
       * @param {?} unescapedAttrs
       */
      function Declaration(unescapedAttrs) {
          var _this = this;
          this.attrs = {};
          Object.keys(unescapedAttrs).forEach(function (k) {
              _this.attrs[k] = _escapeXml(unescapedAttrs[k]);
          });
      }
      /**
       * @param {?} visitor
       * @return {?}
       */
      Declaration.prototype.visit = function (visitor) { return visitor.visitDeclaration(this); };
      return Declaration;
  }());
  var Doctype = (function () {
      /**
       * @param {?} rootTag
       * @param {?} dtd
       */
      function Doctype(rootTag, dtd) {
          this.rootTag = rootTag;
          this.dtd = dtd;
      }
      ;
      /**
       * @param {?} visitor
       * @return {?}
       */
      Doctype.prototype.visit = function (visitor) { return visitor.visitDoctype(this); };
      return Doctype;
  }());
  var Tag = (function () {
      /**
       * @param {?} name
       * @param {?=} unescapedAttrs
       * @param {?=} children
       */
      function Tag(name, unescapedAttrs, children) {
          var _this = this;
          if (unescapedAttrs === void 0) { unescapedAttrs = {}; }
          if (children === void 0) { children = []; }
          this.name = name;
          this.children = children;
          this.attrs = {};
          Object.keys(unescapedAttrs).forEach(function (k) {
              _this.attrs[k] = _escapeXml(unescapedAttrs[k]);
          });
      }
      /**
       * @param {?} visitor
       * @return {?}
       */
      Tag.prototype.visit = function (visitor) { return visitor.visitTag(this); };
      return Tag;
  }());
  var Text$2 = (function () {
      /**
       * @param {?} unescapedValue
       */
      function Text(unescapedValue) {
          this.value = _escapeXml(unescapedValue);
      }
      ;
      /**
       * @param {?} visitor
       * @return {?}
       */
      Text.prototype.visit = function (visitor) { return visitor.visitText(this); };
      return Text;
  }());
  var CR = (function (_super) {
      __extends$7(CR, _super);
      /**
       * @param {?=} ws
       */
      function CR(ws) {
          if (ws === void 0) { ws = 0; }
          _super.call(this, "\n" + new Array(ws + 1).join(' '));
      }
      return CR;
  }(Text$2));
  var /** @type {?} */ _ESCAPED_CHARS = [
      [/&/g, '&amp;'],
      [/"/g, '&quot;'],
      [/'/g, '&apos;'],
      [/</g, '&lt;'],
      [/>/g, '&gt;'],
  ];
  /**
   * @param {?} text
   * @return {?}
   */
  function _escapeXml(text) {
      return _ESCAPED_CHARS.reduce(function (text, entry) { return text.replace(entry[0], entry[1]); }, text);
  }

  var /** @type {?} */ _VERSION = '1.2';
  var /** @type {?} */ _XMLNS = 'urn:oasis:names:tc:xliff:document:1.2';
  // TODO(vicb): make this a param (s/_/-/)
  var /** @type {?} */ _SOURCE_LANG = 'en';
  var /** @type {?} */ _PLACEHOLDER_TAG = 'x';
  var /** @type {?} */ _SOURCE_TAG = 'source';
  var /** @type {?} */ _TARGET_TAG = 'target';
  var /** @type {?} */ _UNIT_TAG = 'trans-unit';
  // http://docs.oasis-open.org/xliff/v1.2/os/xliff-core.html
  // http://docs.oasis-open.org/xliff/v1.2/xliff-profile-html/xliff-profile-html-1.2.html
  var Xliff = (function () {
      function Xliff() {
      }
      /**
       * @param {?} messages
       * @return {?}
       */
      Xliff.prototype.write = function (messages) {
          var _this = this;
          var /** @type {?} */ visitor = new _WriteVisitor();
          var /** @type {?} */ visited = {};
          var /** @type {?} */ transUnits = [];
          messages.forEach(function (message) {
              var /** @type {?} */ id = _this.digest(message);
              // deduplicate messages
              if (visited[id])
                  return;
              visited[id] = true;
              var /** @type {?} */ transUnit = new Tag(_UNIT_TAG, { id: id, datatype: 'html' });
              transUnit.children.push(new CR(8), new Tag(_SOURCE_TAG, {}, visitor.serialize(message.nodes)), new CR(8), new Tag(_TARGET_TAG));
              if (message.description) {
                  transUnit.children.push(new CR(8), new Tag('note', { priority: '1', from: 'description' }, [new Text$2(message.description)]));
              }
              if (message.meaning) {
                  transUnit.children.push(new CR(8), new Tag('note', { priority: '1', from: 'meaning' }, [new Text$2(message.meaning)]));
              }
              transUnit.children.push(new CR(6));
              transUnits.push(new CR(6), transUnit);
          });
          var /** @type {?} */ body = new Tag('body', {}, transUnits.concat([new CR(4)]));
          var /** @type {?} */ file = new Tag('file', { 'source-language': _SOURCE_LANG, datatype: 'plaintext', original: 'ng2.template' }, [new CR(4), body, new CR(2)]);
          var /** @type {?} */ xliff = new Tag('xliff', { version: _VERSION, xmlns: _XMLNS }, [new CR(2), file, new CR()]);
          return serialize([
              new Declaration({ version: '1.0', encoding: 'UTF-8' }), new CR(), xliff, new CR()
          ]);
      };
      /**
       * @param {?} content
       * @param {?} url
       * @return {?}
       */
      Xliff.prototype.load = function (content, url) {
          // xliff to xml nodes
          var /** @type {?} */ xliffParser = new XliffParser();
          var _a = xliffParser.parse(content, url), mlNodesByMsgId = _a.mlNodesByMsgId, errors = _a.errors;
          // xml nodes to i18n nodes
          var /** @type {?} */ i18nNodesByMsgId = {};
          var /** @type {?} */ converter = new XmlToI18n();
          Object.keys(mlNodesByMsgId).forEach(function (msgId) {
              var _a = converter.convert(mlNodesByMsgId[msgId]), i18nNodes = _a.i18nNodes, e = _a.errors;
              errors.push.apply(errors, e);
              i18nNodesByMsgId[msgId] = i18nNodes;
          });
          if (errors.length) {
              throw new Error("xliff parse errors:\n" + errors.join('\n'));
          }
          return i18nNodesByMsgId;
      };
      /**
       * @param {?} message
       * @return {?}
       */
      Xliff.prototype.digest = function (message) { return digest(message); };
      return Xliff;
  }());
  var _WriteVisitor = (function () {
      function _WriteVisitor() {
      }
      /**
       * @param {?} text
       * @param {?=} context
       * @return {?}
       */
      _WriteVisitor.prototype.visitText = function (text, context) { return [new Text$2(text.value)]; };
      /**
       * @param {?} container
       * @param {?=} context
       * @return {?}
       */
      _WriteVisitor.prototype.visitContainer = function (container, context) {
          var _this = this;
          var /** @type {?} */ nodes = [];
          container.children.forEach(function (node) { return nodes.push.apply(nodes, node.visit(_this)); });
          return nodes;
      };
      /**
       * @param {?} icu
       * @param {?=} context
       * @return {?}
       */
      _WriteVisitor.prototype.visitIcu = function (icu, context) {
          if (this._isInIcu) {
              // nested ICU is not supported
              throw new Error('xliff does not support nested ICU messages');
          }
          this._isInIcu = true;
          // TODO(vicb): support ICU messages
          // https://lists.oasis-open.org/archives/xliff/201201/msg00028.html
          // http://docs.oasis-open.org/xliff/v1.2/xliff-profile-po/xliff-profile-po-1.2-cd02.html
          var /** @type {?} */ nodes = [];
          this._isInIcu = false;
          return nodes;
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      _WriteVisitor.prototype.visitTagPlaceholder = function (ph, context) {
          var /** @type {?} */ ctype = getCtypeForTag(ph.tag);
          var /** @type {?} */ startTagPh = new Tag(_PLACEHOLDER_TAG, { id: ph.startName, ctype: ctype });
          if (ph.isVoid) {
              // void tags have no children nor closing tags
              return [startTagPh];
          }
          var /** @type {?} */ closeTagPh = new Tag(_PLACEHOLDER_TAG, { id: ph.closeName, ctype: ctype });
          return [startTagPh].concat(this.serialize(ph.children), [closeTagPh]);
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      _WriteVisitor.prototype.visitPlaceholder = function (ph, context) {
          return [new Tag(_PLACEHOLDER_TAG, { id: ph.name })];
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      _WriteVisitor.prototype.visitIcuPlaceholder = function (ph, context) {
          return [new Tag(_PLACEHOLDER_TAG, { id: ph.name })];
      };
      /**
       * @param {?} nodes
       * @return {?}
       */
      _WriteVisitor.prototype.serialize = function (nodes) {
          var _this = this;
          this._isInIcu = false;
          return (_a = []).concat.apply(_a, nodes.map(function (node) { return node.visit(_this); }));
          var _a;
      };
      return _WriteVisitor;
  }());
  // TODO(vicb): add error management (structure)
  // Extract messages as xml nodes from the xliff file
  var XliffParser = (function () {
      function XliffParser() {
      }
      /**
       * @param {?} xliff
       * @param {?} url
       * @return {?}
       */
      XliffParser.prototype.parse = function (xliff, url) {
          this._unitMlNodes = [];
          this._mlNodesByMsgId = {};
          var /** @type {?} */ xml = new XmlParser().parse(xliff, url, false);
          this._errors = xml.errors;
          visitAll(this, xml.rootNodes, null);
          return {
              mlNodesByMsgId: this._mlNodesByMsgId,
              errors: this._errors,
          };
      };
      /**
       * @param {?} element
       * @param {?} context
       * @return {?}
       */
      XliffParser.prototype.visitElement = function (element, context) {
          switch (element.name) {
              case _UNIT_TAG:
                  this._unitMlNodes = null;
                  var /** @type {?} */ idAttr = element.attrs.find(function (attr) { return attr.name === 'id'; });
                  if (!idAttr) {
                      this._addError(element, "<" + _UNIT_TAG + "> misses the \"id\" attribute");
                  }
                  else {
                      var /** @type {?} */ id = idAttr.value;
                      if (this._mlNodesByMsgId.hasOwnProperty(id)) {
                          this._addError(element, "Duplicated translations for msg " + id);
                      }
                      else {
                          visitAll(this, element.children, null);
                          if (this._unitMlNodes) {
                              this._mlNodesByMsgId[id] = this._unitMlNodes;
                          }
                          else {
                              this._addError(element, "Message " + id + " misses a translation");
                          }
                      }
                  }
                  break;
              case _SOURCE_TAG:
                  // ignore source message
                  break;
              case _TARGET_TAG:
                  this._unitMlNodes = element.children;
                  break;
              default:
                  // TODO(vicb): assert file structure, xliff version
                  // For now only recurse on unhandled nodes
                  visitAll(this, element.children, null);
          }
      };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      XliffParser.prototype.visitAttribute = function (attribute, context) { };
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      XliffParser.prototype.visitText = function (text, context) { };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      XliffParser.prototype.visitComment = function (comment, context) { };
      /**
       * @param {?} expansion
       * @param {?} context
       * @return {?}
       */
      XliffParser.prototype.visitExpansion = function (expansion, context) { };
      /**
       * @param {?} expansionCase
       * @param {?} context
       * @return {?}
       */
      XliffParser.prototype.visitExpansionCase = function (expansionCase, context) { };
      /**
       * @param {?} node
       * @param {?} message
       * @return {?}
       */
      XliffParser.prototype._addError = function (node, message) {
          this._errors.push(new I18nError(node.sourceSpan, message));
      };
      return XliffParser;
  }());
  // Convert ml nodes (xliff syntax) to i18n nodes
  var XmlToI18n = (function () {
      function XmlToI18n() {
      }
      /**
       * @param {?} nodes
       * @return {?}
       */
      XmlToI18n.prototype.convert = function (nodes) {
          this._errors = [];
          return {
              i18nNodes: visitAll(this, nodes),
              errors: this._errors,
          };
      };
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitText = function (text, context) { return new Text$1(text.value, text.sourceSpan); };
      /**
       * @param {?} el
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitElement = function (el, context) {
          if (el.name === _PLACEHOLDER_TAG) {
              var /** @type {?} */ nameAttr = el.attrs.find(function (attr) { return attr.name === 'id'; });
              if (nameAttr) {
                  return new Placeholder('', nameAttr.value, el.sourceSpan);
              }
              this._addError(el, "<" + _PLACEHOLDER_TAG + "> misses the \"id\" attribute");
          }
          else {
              this._addError(el, "Unexpected tag");
          }
      };
      /**
       * @param {?} icu
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitExpansion = function (icu, context) { };
      /**
       * @param {?} icuCase
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitExpansionCase = function (icuCase, context) { };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitComment = function (comment, context) { };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitAttribute = function (attribute, context) { };
      /**
       * @param {?} node
       * @param {?} message
       * @return {?}
       */
      XmlToI18n.prototype._addError = function (node, message) {
          this._errors.push(new I18nError(node.sourceSpan, message));
      };
      return XmlToI18n;
  }());
  /**
   * @param {?} tag
   * @return {?}
   */
  function getCtypeForTag(tag) {
      switch (tag.toLowerCase()) {
          case 'br':
              return 'lb';
          case 'img':
              return 'image';
          default:
              return "x-" + tag;
      }
  }

  var /** @type {?} */ _MESSAGES_TAG = 'messagebundle';
  var /** @type {?} */ _MESSAGE_TAG = 'msg';
  var /** @type {?} */ _PLACEHOLDER_TAG$1 = 'ph';
  var /** @type {?} */ _EXEMPLE_TAG = 'ex';
  var /** @type {?} */ _DOCTYPE = "<!ELEMENT messagebundle (msg)*>\n<!ATTLIST messagebundle class CDATA #IMPLIED>\n\n<!ELEMENT msg (#PCDATA|ph|source)*>\n<!ATTLIST msg id CDATA #IMPLIED>\n<!ATTLIST msg seq CDATA #IMPLIED>\n<!ATTLIST msg name CDATA #IMPLIED>\n<!ATTLIST msg desc CDATA #IMPLIED>\n<!ATTLIST msg meaning CDATA #IMPLIED>\n<!ATTLIST msg obsolete (obsolete) #IMPLIED>\n<!ATTLIST msg xml:space (default|preserve) \"default\">\n<!ATTLIST msg is_hidden CDATA #IMPLIED>\n\n<!ELEMENT source (#PCDATA)>\n\n<!ELEMENT ph (#PCDATA|ex)*>\n<!ATTLIST ph name CDATA #REQUIRED>\n\n<!ELEMENT ex (#PCDATA)>";
  var Xmb = (function () {
      function Xmb() {
      }
      /**
       * @param {?} messages
       * @return {?}
       */
      Xmb.prototype.write = function (messages) {
          var _this = this;
          var /** @type {?} */ visitor = new _Visitor$2();
          var /** @type {?} */ visited = {};
          var /** @type {?} */ rootNode = new Tag(_MESSAGES_TAG);
          messages.forEach(function (message) {
              var /** @type {?} */ id = _this.digest(message);
              // deduplicate messages
              if (visited[id])
                  return;
              visited[id] = true;
              var /** @type {?} */ attrs = { id: id };
              if (message.description) {
                  attrs['desc'] = message.description;
              }
              if (message.meaning) {
                  attrs['meaning'] = message.meaning;
              }
              rootNode.children.push(new CR(2), new Tag(_MESSAGE_TAG, attrs, visitor.serialize(message.nodes)));
          });
          rootNode.children.push(new CR());
          return serialize([
              new Declaration({ version: '1.0', encoding: 'UTF-8' }),
              new CR(),
              new Doctype(_MESSAGES_TAG, _DOCTYPE),
              new CR(),
              rootNode,
              new CR(),
          ]);
      };
      /**
       * @param {?} content
       * @param {?} url
       * @return {?}
       */
      Xmb.prototype.load = function (content, url) {
          throw new Error('Unsupported');
      };
      /**
       * @param {?} message
       * @return {?}
       */
      Xmb.prototype.digest = function (message) { return digest$1(message); };
      return Xmb;
  }());
  var _Visitor$2 = (function () {
      function _Visitor() {
      }
      /**
       * @param {?} text
       * @param {?=} context
       * @return {?}
       */
      _Visitor.prototype.visitText = function (text, context) { return [new Text$2(text.value)]; };
      /**
       * @param {?} container
       * @param {?=} context
       * @return {?}
       */
      _Visitor.prototype.visitContainer = function (container, context) {
          var _this = this;
          var /** @type {?} */ nodes = [];
          container.children.forEach(function (node) { return nodes.push.apply(nodes, node.visit(_this)); });
          return nodes;
      };
      /**
       * @param {?} icu
       * @param {?=} context
       * @return {?}
       */
      _Visitor.prototype.visitIcu = function (icu, context) {
          var _this = this;
          var /** @type {?} */ nodes = [new Text$2("{" + icu.expressionPlaceholder + ", " + icu.type + ", ")];
          Object.keys(icu.cases).forEach(function (c) {
              nodes.push.apply(nodes, [new Text$2(c + " {")].concat(icu.cases[c].visit(_this), [new Text$2("} ")]));
          });
          nodes.push(new Text$2("}"));
          return nodes;
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      _Visitor.prototype.visitTagPlaceholder = function (ph, context) {
          var /** @type {?} */ startEx = new Tag(_EXEMPLE_TAG, {}, [new Text$2("<" + ph.tag + ">")]);
          var /** @type {?} */ startTagPh = new Tag(_PLACEHOLDER_TAG$1, { name: ph.startName }, [startEx]);
          if (ph.isVoid) {
              // void tags have no children nor closing tags
              return [startTagPh];
          }
          var /** @type {?} */ closeEx = new Tag(_EXEMPLE_TAG, {}, [new Text$2("</" + ph.tag + ">")]);
          var /** @type {?} */ closeTagPh = new Tag(_PLACEHOLDER_TAG$1, { name: ph.closeName }, [closeEx]);
          return [startTagPh].concat(this.serialize(ph.children), [closeTagPh]);
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      _Visitor.prototype.visitPlaceholder = function (ph, context) {
          return [new Tag(_PLACEHOLDER_TAG$1, { name: ph.name })];
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      _Visitor.prototype.visitIcuPlaceholder = function (ph, context) {
          return [new Tag(_PLACEHOLDER_TAG$1, { name: ph.name })];
      };
      /**
       * @param {?} nodes
       * @return {?}
       */
      _Visitor.prototype.serialize = function (nodes) {
          var _this = this;
          return (_a = []).concat.apply(_a, nodes.map(function (node) { return node.visit(_this); }));
          var _a;
      };
      return _Visitor;
  }());
  /**
   * @param {?} message
   * @return {?}
   */
  function digest$1(message) {
      return decimalDigest(message);
  }

  var /** @type {?} */ _TRANSLATIONS_TAG = 'translationbundle';
  var /** @type {?} */ _TRANSLATION_TAG = 'translation';
  var /** @type {?} */ _PLACEHOLDER_TAG$2 = 'ph';
  var Xtb = (function () {
      function Xtb() {
      }
      /**
       * @param {?} messages
       * @return {?}
       */
      Xtb.prototype.write = function (messages) { throw new Error('Unsupported'); };
      /**
       * @param {?} content
       * @param {?} url
       * @return {?}
       */
      Xtb.prototype.load = function (content, url) {
          // xtb to xml nodes
          var /** @type {?} */ xtbParser = new XtbParser();
          var _a = xtbParser.parse(content, url), mlNodesByMsgId = _a.mlNodesByMsgId, errors = _a.errors;
          // xml nodes to i18n nodes
          var /** @type {?} */ i18nNodesByMsgId = {};
          var /** @type {?} */ converter = new XmlToI18n$1();
          Object.keys(mlNodesByMsgId).forEach(function (msgId) {
              var _a = converter.convert(mlNodesByMsgId[msgId]), i18nNodes = _a.i18nNodes, e = _a.errors;
              errors.push.apply(errors, e);
              i18nNodesByMsgId[msgId] = i18nNodes;
          });
          if (errors.length) {
              throw new Error("xtb parse errors:\n" + errors.join('\n'));
          }
          return i18nNodesByMsgId;
      };
      /**
       * @param {?} message
       * @return {?}
       */
      Xtb.prototype.digest = function (message) { return digest$1(message); };
      return Xtb;
  }());
  // Extract messages as xml nodes from the xtb file
  var XtbParser = (function () {
      function XtbParser() {
      }
      /**
       * @param {?} xtb
       * @param {?} url
       * @return {?}
       */
      XtbParser.prototype.parse = function (xtb, url) {
          this._bundleDepth = 0;
          this._mlNodesByMsgId = {};
          var /** @type {?} */ xml = new XmlParser().parse(xtb, url, true);
          this._errors = xml.errors;
          visitAll(this, xml.rootNodes);
          return {
              mlNodesByMsgId: this._mlNodesByMsgId,
              errors: this._errors,
          };
      };
      /**
       * @param {?} element
       * @param {?} context
       * @return {?}
       */
      XtbParser.prototype.visitElement = function (element, context) {
          switch (element.name) {
              case _TRANSLATIONS_TAG:
                  this._bundleDepth++;
                  if (this._bundleDepth > 1) {
                      this._addError(element, "<" + _TRANSLATIONS_TAG + "> elements can not be nested");
                  }
                  visitAll(this, element.children, null);
                  this._bundleDepth--;
                  break;
              case _TRANSLATION_TAG:
                  var /** @type {?} */ idAttr = element.attrs.find(function (attr) { return attr.name === 'id'; });
                  if (!idAttr) {
                      this._addError(element, "<" + _TRANSLATION_TAG + "> misses the \"id\" attribute");
                  }
                  else {
                      var /** @type {?} */ id = idAttr.value;
                      if (this._mlNodesByMsgId.hasOwnProperty(id)) {
                          this._addError(element, "Duplicated translations for msg " + id);
                      }
                      else {
                          this._mlNodesByMsgId[id] = element.children;
                      }
                  }
                  break;
              default:
                  this._addError(element, 'Unexpected tag');
          }
      };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      XtbParser.prototype.visitAttribute = function (attribute, context) { };
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      XtbParser.prototype.visitText = function (text, context) { };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      XtbParser.prototype.visitComment = function (comment, context) { };
      /**
       * @param {?} expansion
       * @param {?} context
       * @return {?}
       */
      XtbParser.prototype.visitExpansion = function (expansion, context) { };
      /**
       * @param {?} expansionCase
       * @param {?} context
       * @return {?}
       */
      XtbParser.prototype.visitExpansionCase = function (expansionCase, context) { };
      /**
       * @param {?} node
       * @param {?} message
       * @return {?}
       */
      XtbParser.prototype._addError = function (node, message) {
          this._errors.push(new I18nError(node.sourceSpan, message));
      };
      return XtbParser;
  }());
  // Convert ml nodes (xtb syntax) to i18n nodes
  var XmlToI18n$1 = (function () {
      function XmlToI18n() {
      }
      /**
       * @param {?} nodes
       * @return {?}
       */
      XmlToI18n.prototype.convert = function (nodes) {
          this._errors = [];
          return {
              i18nNodes: visitAll(this, nodes),
              errors: this._errors,
          };
      };
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitText = function (text, context) { return new Text$1(text.value, text.sourceSpan); };
      /**
       * @param {?} icu
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitExpansion = function (icu, context) {
          var /** @type {?} */ caseMap = {};
          visitAll(this, icu.cases).forEach(function (c) {
              caseMap[c.value] = new Container(c.nodes, icu.sourceSpan);
          });
          return new Icu(icu.switchValue, icu.type, caseMap, icu.sourceSpan);
      };
      /**
       * @param {?} icuCase
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitExpansionCase = function (icuCase, context) {
          return {
              value: icuCase.value,
              nodes: visitAll(this, icuCase.expression),
          };
      };
      /**
       * @param {?} el
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitElement = function (el, context) {
          if (el.name === _PLACEHOLDER_TAG$2) {
              var /** @type {?} */ nameAttr = el.attrs.find(function (attr) { return attr.name === 'name'; });
              if (nameAttr) {
                  return new Placeholder('', nameAttr.value, el.sourceSpan);
              }
              this._addError(el, "<" + _PLACEHOLDER_TAG$2 + "> misses the \"name\" attribute");
          }
          else {
              this._addError(el, "Unexpected tag");
          }
      };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitComment = function (comment, context) { };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      XmlToI18n.prototype.visitAttribute = function (attribute, context) { };
      /**
       * @param {?} node
       * @param {?} message
       * @return {?}
       */
      XmlToI18n.prototype._addError = function (node, message) {
          this._errors.push(new I18nError(node.sourceSpan, message));
      };
      return XmlToI18n;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$8 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var HtmlParser = (function (_super) {
      __extends$8(HtmlParser, _super);
      function HtmlParser() {
          _super.call(this, getHtmlTagDefinition);
      }
      /**
       * @param {?} source
       * @param {?} url
       * @param {?=} parseExpansionForms
       * @param {?=} interpolationConfig
       * @return {?}
       */
      HtmlParser.prototype.parse = function (source, url, parseExpansionForms, interpolationConfig) {
          if (parseExpansionForms === void 0) { parseExpansionForms = false; }
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          return _super.prototype.parse.call(this, source, url, parseExpansionForms, interpolationConfig);
      };
      HtmlParser.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      HtmlParser.ctorParameters = function () { return []; };
      return HtmlParser;
  }(Parser$1));

  /**
   *  A container for translated messages
   */
  var TranslationBundle = (function () {
      /**
       * @param {?=} _i18nNodesByMsgId
       * @param {?} digest
       */
      function TranslationBundle(_i18nNodesByMsgId, digest) {
          if (_i18nNodesByMsgId === void 0) { _i18nNodesByMsgId = {}; }
          this._i18nNodesByMsgId = _i18nNodesByMsgId;
          this.digest = digest;
          this._i18nToHtml = new I18nToHtmlVisitor(_i18nNodesByMsgId, digest);
      }
      /**
       * @param {?} content
       * @param {?} url
       * @param {?} serializer
       * @return {?}
       */
      TranslationBundle.load = function (content, url, serializer) {
          var /** @type {?} */ i18nNodesByMsgId = serializer.load(content, url);
          var /** @type {?} */ digestFn = function (m) { return serializer.digest(m); };
          return new TranslationBundle(i18nNodesByMsgId, digestFn);
      };
      /**
       * @param {?} srcMsg
       * @return {?}
       */
      TranslationBundle.prototype.get = function (srcMsg) {
          var /** @type {?} */ html = this._i18nToHtml.convert(srcMsg);
          if (html.errors.length) {
              throw new Error(html.errors.join('\n'));
          }
          return html.nodes;
      };
      /**
       * @param {?} srcMsg
       * @return {?}
       */
      TranslationBundle.prototype.has = function (srcMsg) { return this.digest(srcMsg) in this._i18nNodesByMsgId; };
      return TranslationBundle;
  }());
  var I18nToHtmlVisitor = (function () {
      /**
       * @param {?=} _i18nNodesByMsgId
       * @param {?} _digest
       */
      function I18nToHtmlVisitor(_i18nNodesByMsgId, _digest) {
          if (_i18nNodesByMsgId === void 0) { _i18nNodesByMsgId = {}; }
          this._i18nNodesByMsgId = _i18nNodesByMsgId;
          this._digest = _digest;
          this._srcMsgStack = [];
          this._errors = [];
      }
      /**
       * @param {?} srcMsg
       * @return {?}
       */
      I18nToHtmlVisitor.prototype.convert = function (srcMsg) {
          this._srcMsgStack.length = 0;
          this._errors.length = 0;
          // i18n to text
          var /** @type {?} */ text = this._convertToText(srcMsg);
          // text to html
          var /** @type {?} */ url = srcMsg.nodes[0].sourceSpan.start.file.url;
          var /** @type {?} */ html = new HtmlParser().parse(text, url, true);
          return {
              nodes: html.rootNodes,
              errors: this._errors.concat(html.errors),
          };
      };
      /**
       * @param {?} text
       * @param {?=} context
       * @return {?}
       */
      I18nToHtmlVisitor.prototype.visitText = function (text, context) { return text.value; };
      /**
       * @param {?} container
       * @param {?=} context
       * @return {?}
       */
      I18nToHtmlVisitor.prototype.visitContainer = function (container, context) {
          var _this = this;
          return container.children.map(function (n) { return n.visit(_this); }).join('');
      };
      /**
       * @param {?} icu
       * @param {?=} context
       * @return {?}
       */
      I18nToHtmlVisitor.prototype.visitIcu = function (icu, context) {
          var _this = this;
          var /** @type {?} */ cases = Object.keys(icu.cases).map(function (k) { return (k + " {" + icu.cases[k].visit(_this) + "}"); });
          // TODO(vicb): Once all format switch to using expression placeholders
          // we should throw when the placeholder is not in the source message
          var /** @type {?} */ exp = this._srcMsg.placeholders.hasOwnProperty(icu.expression) ?
              this._srcMsg.placeholders[icu.expression] :
              icu.expression;
          return "{" + exp + ", " + icu.type + ", " + cases.join(' ') + "}";
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      I18nToHtmlVisitor.prototype.visitPlaceholder = function (ph, context) {
          var /** @type {?} */ phName = ph.name;
          if (this._srcMsg.placeholders.hasOwnProperty(phName)) {
              return this._srcMsg.placeholders[phName];
          }
          if (this._srcMsg.placeholderToMessage.hasOwnProperty(phName)) {
              return this._convertToText(this._srcMsg.placeholderToMessage[phName]);
          }
          this._addError(ph, "Unknown placeholder");
          return '';
      };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      I18nToHtmlVisitor.prototype.visitTagPlaceholder = function (ph, context) { throw 'unreachable code'; };
      /**
       * @param {?} ph
       * @param {?=} context
       * @return {?}
       */
      I18nToHtmlVisitor.prototype.visitIcuPlaceholder = function (ph, context) { throw 'unreachable code'; };
      /**
       * @param {?} srcMsg
       * @return {?}
       */
      I18nToHtmlVisitor.prototype._convertToText = function (srcMsg) {
          var _this = this;
          var /** @type {?} */ digest = this._digest(srcMsg);
          if (this._i18nNodesByMsgId.hasOwnProperty(digest)) {
              this._srcMsgStack.push(this._srcMsg);
              this._srcMsg = srcMsg;
              var /** @type {?} */ nodes = this._i18nNodesByMsgId[digest];
              var /** @type {?} */ text = nodes.map(function (node) { return node.visit(_this); }).join('');
              this._srcMsg = this._srcMsgStack.pop();
              return text;
          }
          this._addError(srcMsg.nodes[0], "Missing translation for message " + digest);
          return '';
      };
      /**
       * @param {?} el
       * @param {?} msg
       * @return {?}
       */
      I18nToHtmlVisitor.prototype._addError = function (el, msg) {
          this._errors.push(new I18nError(el.sourceSpan, msg));
      };
      return I18nToHtmlVisitor;
  }());

  var I18NHtmlParser = (function () {
      /**
       * @param {?} _htmlParser
       * @param {?=} _translations
       * @param {?=} _translationsFormat
       */
      function I18NHtmlParser(_htmlParser, _translations, _translationsFormat) {
          this._htmlParser = _htmlParser;
          this._translations = _translations;
          this._translationsFormat = _translationsFormat;
      }
      /**
       * @param {?} source
       * @param {?} url
       * @param {?=} parseExpansionForms
       * @param {?=} interpolationConfig
       * @return {?}
       */
      I18NHtmlParser.prototype.parse = function (source, url, parseExpansionForms, interpolationConfig) {
          if (parseExpansionForms === void 0) { parseExpansionForms = false; }
          if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
          var /** @type {?} */ parseResult = this._htmlParser.parse(source, url, parseExpansionForms, interpolationConfig);
          if (!this._translations || this._translations === '') {
              // Do not enable i18n when no translation bundle is provided
              return parseResult;
          }
          // TODO(vicb): add support for implicit tags / attributes
          if (parseResult.errors.length) {
              return new ParseTreeResult(parseResult.rootNodes, parseResult.errors);
          }
          var /** @type {?} */ serializer = this._createSerializer();
          var /** @type {?} */ translationBundle = TranslationBundle.load(this._translations, url, serializer);
          return mergeTranslations(parseResult.rootNodes, translationBundle, interpolationConfig, [], {});
      };
      /**
       * @return {?}
       */
      I18NHtmlParser.prototype._createSerializer = function () {
          var /** @type {?} */ format = (this._translationsFormat || 'xlf').toLowerCase();
          switch (format) {
              case 'xmb':
                  return new Xmb();
              case 'xtb':
                  return new Xtb();
              case 'xliff':
              case 'xlf':
              default:
                  return new Xliff();
          }
      };
      return I18NHtmlParser;
  }());

  /**
   * @license undefined
    * Copyright Google Inc. All Rights Reserved.
    * *
    * Use of this source code is governed by an MIT-style license that can be
    * found in the LICENSE file at https://angular.io/license
   * @param {?} value
   * @return {?}
   */
  function isStaticSymbol(value) {
      return typeof value === 'object' && value !== null && value['name'] && value['filePath'];
  }
  /**
   *  A token representing the a reference to a static type.
    * *
    * This token is unique for a filePath and name and can be used as a hash table key.
   */
  var StaticSymbol = (function () {
      /**
       * @param {?} filePath
       * @param {?} name
       * @param {?=} members
       */
      function StaticSymbol(filePath, name, members) {
          this.filePath = filePath;
          this.name = name;
          this.members = members;
      }
      return StaticSymbol;
  }());

  /**
   *  Wraps Javascript Objects
   */
  var StringMapWrapper = (function () {
      function StringMapWrapper() {
      }
      /**
       * @param {?} m1
       * @param {?} m2
       * @return {?}
       */
      StringMapWrapper.merge = function (m1, m2) {
          var /** @type {?} */ m = {};
          for (var _i = 0, _a = Object.keys(m1); _i < _a.length; _i++) {
              var k = _a[_i];
              m[k] = m1[k];
          }
          for (var _b = 0, _c = Object.keys(m2); _b < _c.length; _b++) {
              var k = _c[_b];
              m[k] = m2[k];
          }
          return m;
      };
      /**
       * @param {?} m1
       * @param {?} m2
       * @return {?}
       */
      StringMapWrapper.equals = function (m1, m2) {
          var /** @type {?} */ k1 = Object.keys(m1);
          var /** @type {?} */ k2 = Object.keys(m2);
          if (k1.length != k2.length) {
              return false;
          }
          for (var /** @type {?} */ i = 0; i < k1.length; i++) {
              var /** @type {?} */ key = k1[i];
              if (m1[key] !== m2[key]) {
                  return false;
              }
          }
          return true;
      };
      return StringMapWrapper;
  }());
  var ListWrapper = (function () {
      function ListWrapper() {
      }
      /**
       * @param {?} list
       * @param {?} items
       * @return {?}
       */
      ListWrapper.removeAll = function (list, items) {
          for (var /** @type {?} */ i = 0; i < items.length; ++i) {
              var /** @type {?} */ index = list.indexOf(items[i]);
              if (index > -1) {
                  list.splice(index, 1);
              }
          }
      };
      /**
       * @param {?} list
       * @param {?} el
       * @return {?}
       */
      ListWrapper.remove = function (list, el) {
          var /** @type {?} */ index = list.indexOf(el);
          if (index > -1) {
              list.splice(index, 1);
              return true;
          }
          return false;
      };
      /**
       * @param {?} a
       * @param {?} b
       * @return {?}
       */
      ListWrapper.equals = function (a, b) {
          if (a.length != b.length)
              return false;
          for (var /** @type {?} */ i = 0; i < a.length; ++i) {
              if (a[i] !== b[i])
                  return false;
          }
          return true;
      };
      /**
       * @param {?} list
       * @return {?}
       */
      ListWrapper.flatten = function (list) {
          return list.reduce(function (flat, item) {
              var /** @type {?} */ flatItem = Array.isArray(item) ? ListWrapper.flatten(item) : item;
              return ((flat)).concat(flatItem);
          }, []);
      };
      return ListWrapper;
  }());

  var /** @type {?} */ _SELECTOR_REGEXP = new RegExp('(\\:not\\()|' +
      '([-\\w]+)|' +
      '(?:\\.([-\\w]+))|' +
      '(?:\\[([-\\w*]+)(?:=([^\\]]*))?\\])|' +
      '(\\))|' +
      '(\\s*,\\s*)', // ","
  'g');
  /**
   *  A css selector contains an element name,
    * css classes and attribute/value pairs with the purpose
    * of selecting subsets out of them.
   */
  var CssSelector = (function () {
      function CssSelector() {
          this.element = null;
          this.classNames = [];
          this.attrs = [];
          this.notSelectors = [];
      }
      /**
       * @param {?} selector
       * @return {?}
       */
      CssSelector.parse = function (selector) {
          var /** @type {?} */ results = [];
          var /** @type {?} */ _addResult = function (res, cssSel) {
              if (cssSel.notSelectors.length > 0 && !cssSel.element && cssSel.classNames.length == 0 &&
                  cssSel.attrs.length == 0) {
                  cssSel.element = '*';
              }
              res.push(cssSel);
          };
          var /** @type {?} */ cssSelector = new CssSelector();
          var /** @type {?} */ match;
          var /** @type {?} */ current = cssSelector;
          var /** @type {?} */ inNot = false;
          _SELECTOR_REGEXP.lastIndex = 0;
          while (match = _SELECTOR_REGEXP.exec(selector)) {
              if (match[1]) {
                  if (inNot) {
                      throw new Error('Nesting :not is not allowed in a selector');
                  }
                  inNot = true;
                  current = new CssSelector();
                  cssSelector.notSelectors.push(current);
              }
              if (match[2]) {
                  current.setElement(match[2]);
              }
              if (match[3]) {
                  current.addClassName(match[3]);
              }
              if (match[4]) {
                  current.addAttribute(match[4], match[5]);
              }
              if (match[6]) {
                  inNot = false;
                  current = cssSelector;
              }
              if (match[7]) {
                  if (inNot) {
                      throw new Error('Multiple selectors in :not are not supported');
                  }
                  _addResult(results, cssSelector);
                  cssSelector = current = new CssSelector();
              }
          }
          _addResult(results, cssSelector);
          return results;
      };
      /**
       * @return {?}
       */
      CssSelector.prototype.isElementSelector = function () {
          return this.hasElementSelector() && this.classNames.length == 0 && this.attrs.length == 0 &&
              this.notSelectors.length === 0;
      };
      /**
       * @return {?}
       */
      CssSelector.prototype.hasElementSelector = function () { return !!this.element; };
      /**
       * @param {?=} element
       * @return {?}
       */
      CssSelector.prototype.setElement = function (element) {
          if (element === void 0) { element = null; }
          this.element = element;
      };
      /**
       *  Gets a template string for an element that matches the selector.
       * @return {?}
       */
      CssSelector.prototype.getMatchingElementTemplate = function () {
          var /** @type {?} */ tagName = this.element || 'div';
          var /** @type {?} */ classAttr = this.classNames.length > 0 ? " class=\"" + this.classNames.join(' ') + "\"" : '';
          var /** @type {?} */ attrs = '';
          for (var /** @type {?} */ i = 0; i < this.attrs.length; i += 2) {
              var /** @type {?} */ attrName = this.attrs[i];
              var /** @type {?} */ attrValue = this.attrs[i + 1] !== '' ? "=\"" + this.attrs[i + 1] + "\"" : '';
              attrs += " " + attrName + attrValue;
          }
          return getHtmlTagDefinition(tagName).isVoid ? "<" + tagName + classAttr + attrs + "/>" :
              "<" + tagName + classAttr + attrs + "></" + tagName + ">";
      };
      /**
       * @param {?} name
       * @param {?=} value
       * @return {?}
       */
      CssSelector.prototype.addAttribute = function (name, value) {
          if (value === void 0) { value = ''; }
          this.attrs.push(name, value && value.toLowerCase() || '');
      };
      /**
       * @param {?} name
       * @return {?}
       */
      CssSelector.prototype.addClassName = function (name) { this.classNames.push(name.toLowerCase()); };
      /**
       * @return {?}
       */
      CssSelector.prototype.toString = function () {
          var /** @type {?} */ res = this.element || '';
          if (this.classNames) {
              this.classNames.forEach(function (klass) { return res += "." + klass; });
          }
          if (this.attrs) {
              for (var /** @type {?} */ i = 0; i < this.attrs.length; i += 2) {
                  var /** @type {?} */ name_1 = this.attrs[i];
                  var /** @type {?} */ value = this.attrs[i + 1];
                  res += "[" + name_1 + (value ? '=' + value : '') + "]";
              }
          }
          this.notSelectors.forEach(function (notSelector) { return res += ":not(" + notSelector + ")"; });
          return res;
      };
      return CssSelector;
  }());
  /**
   *  Reads a list of CssSelectors and allows to calculate which ones
    * are contained in a given CssSelector.
   */
  var SelectorMatcher = (function () {
      function SelectorMatcher() {
          this._elementMap = new Map();
          this._elementPartialMap = new Map();
          this._classMap = new Map();
          this._classPartialMap = new Map();
          this._attrValueMap = new Map();
          this._attrValuePartialMap = new Map();
          this._listContexts = [];
      }
      /**
       * @param {?} notSelectors
       * @return {?}
       */
      SelectorMatcher.createNotMatcher = function (notSelectors) {
          var /** @type {?} */ notMatcher = new SelectorMatcher();
          notMatcher.addSelectables(notSelectors, null);
          return notMatcher;
      };
      /**
       * @param {?} cssSelectors
       * @param {?=} callbackCtxt
       * @return {?}
       */
      SelectorMatcher.prototype.addSelectables = function (cssSelectors, callbackCtxt) {
          var /** @type {?} */ listContext = null;
          if (cssSelectors.length > 1) {
              listContext = new SelectorListContext(cssSelectors);
              this._listContexts.push(listContext);
          }
          for (var /** @type {?} */ i = 0; i < cssSelectors.length; i++) {
              this._addSelectable(cssSelectors[i], callbackCtxt, listContext);
          }
      };
      /**
       *  Add an object that can be found later on by calling `match`.
       * @param {?} cssSelector A css selector
       * @param {?} callbackCtxt An opaque object that will be given to the callback of the `match` function
       * @param {?} listContext
       * @return {?}
       */
      SelectorMatcher.prototype._addSelectable = function (cssSelector, callbackCtxt, listContext) {
          var /** @type {?} */ matcher = this;
          var /** @type {?} */ element = cssSelector.element;
          var /** @type {?} */ classNames = cssSelector.classNames;
          var /** @type {?} */ attrs = cssSelector.attrs;
          var /** @type {?} */ selectable = new SelectorContext(cssSelector, callbackCtxt, listContext);
          if (element) {
              var /** @type {?} */ isTerminal = attrs.length === 0 && classNames.length === 0;
              if (isTerminal) {
                  this._addTerminal(matcher._elementMap, element, selectable);
              }
              else {
                  matcher = this._addPartial(matcher._elementPartialMap, element);
              }
          }
          if (classNames) {
              for (var /** @type {?} */ i = 0; i < classNames.length; i++) {
                  var /** @type {?} */ isTerminal = attrs.length === 0 && i === classNames.length - 1;
                  var /** @type {?} */ className = classNames[i];
                  if (isTerminal) {
                      this._addTerminal(matcher._classMap, className, selectable);
                  }
                  else {
                      matcher = this._addPartial(matcher._classPartialMap, className);
                  }
              }
          }
          if (attrs) {
              for (var /** @type {?} */ i = 0; i < attrs.length; i += 2) {
                  var /** @type {?} */ isTerminal = i === attrs.length - 2;
                  var /** @type {?} */ name_2 = attrs[i];
                  var /** @type {?} */ value = attrs[i + 1];
                  if (isTerminal) {
                      var /** @type {?} */ terminalMap = matcher._attrValueMap;
                      var /** @type {?} */ terminalValuesMap = terminalMap.get(name_2);
                      if (!terminalValuesMap) {
                          terminalValuesMap = new Map();
                          terminalMap.set(name_2, terminalValuesMap);
                      }
                      this._addTerminal(terminalValuesMap, value, selectable);
                  }
                  else {
                      var /** @type {?} */ partialMap = matcher._attrValuePartialMap;
                      var /** @type {?} */ partialValuesMap = partialMap.get(name_2);
                      if (!partialValuesMap) {
                          partialValuesMap = new Map();
                          partialMap.set(name_2, partialValuesMap);
                      }
                      matcher = this._addPartial(partialValuesMap, value);
                  }
              }
          }
      };
      /**
       * @param {?} map
       * @param {?} name
       * @param {?} selectable
       * @return {?}
       */
      SelectorMatcher.prototype._addTerminal = function (map, name, selectable) {
          var /** @type {?} */ terminalList = map.get(name);
          if (!terminalList) {
              terminalList = [];
              map.set(name, terminalList);
          }
          terminalList.push(selectable);
      };
      /**
       * @param {?} map
       * @param {?} name
       * @return {?}
       */
      SelectorMatcher.prototype._addPartial = function (map, name) {
          var /** @type {?} */ matcher = map.get(name);
          if (!matcher) {
              matcher = new SelectorMatcher();
              map.set(name, matcher);
          }
          return matcher;
      };
      /**
       *  Find the objects that have been added via `addSelectable`
        * whose css selector is contained in the given css selector.
       * @param {?} cssSelector A css selector
       * @param {?} matchedCallback This callback will be called with the object handed into `addSelectable`
       * @return {?} boolean true if a match was found
       */
      SelectorMatcher.prototype.match = function (cssSelector, matchedCallback) {
          var /** @type {?} */ result = false;
          var /** @type {?} */ element = cssSelector.element;
          var /** @type {?} */ classNames = cssSelector.classNames;
          var /** @type {?} */ attrs = cssSelector.attrs;
          for (var /** @type {?} */ i = 0; i < this._listContexts.length; i++) {
              this._listContexts[i].alreadyMatched = false;
          }
          result = this._matchTerminal(this._elementMap, element, cssSelector, matchedCallback) || result;
          result = this._matchPartial(this._elementPartialMap, element, cssSelector, matchedCallback) ||
              result;
          if (classNames) {
              for (var /** @type {?} */ i = 0; i < classNames.length; i++) {
                  var /** @type {?} */ className = classNames[i];
                  result =
                      this._matchTerminal(this._classMap, className, cssSelector, matchedCallback) || result;
                  result =
                      this._matchPartial(this._classPartialMap, className, cssSelector, matchedCallback) ||
                          result;
              }
          }
          if (attrs) {
              for (var /** @type {?} */ i = 0; i < attrs.length; i += 2) {
                  var /** @type {?} */ name_3 = attrs[i];
                  var /** @type {?} */ value = attrs[i + 1];
                  var /** @type {?} */ terminalValuesMap = this._attrValueMap.get(name_3);
                  if (value) {
                      result =
                          this._matchTerminal(terminalValuesMap, '', cssSelector, matchedCallback) || result;
                  }
                  result =
                      this._matchTerminal(terminalValuesMap, value, cssSelector, matchedCallback) || result;
                  var /** @type {?} */ partialValuesMap = this._attrValuePartialMap.get(name_3);
                  if (value) {
                      result = this._matchPartial(partialValuesMap, '', cssSelector, matchedCallback) || result;
                  }
                  result =
                      this._matchPartial(partialValuesMap, value, cssSelector, matchedCallback) || result;
              }
          }
          return result;
      };
      /**
       * @param {?} map
       * @param {?} name
       * @param {?} cssSelector
       * @param {?} matchedCallback
       * @return {?}
       */
      SelectorMatcher.prototype._matchTerminal = function (map, name, cssSelector, matchedCallback) {
          if (!map || typeof name !== 'string') {
              return false;
          }
          var /** @type {?} */ selectables = map.get(name);
          var /** @type {?} */ starSelectables = map.get('*');
          if (starSelectables) {
              selectables = selectables.concat(starSelectables);
          }
          if (!selectables) {
              return false;
          }
          var /** @type {?} */ selectable;
          var /** @type {?} */ result = false;
          for (var /** @type {?} */ i = 0; i < selectables.length; i++) {
              selectable = selectables[i];
              result = selectable.finalize(cssSelector, matchedCallback) || result;
          }
          return result;
      };
      /**
       * @param {?} map
       * @param {?} name
       * @param {?} cssSelector
       * @param {?} matchedCallback
       * @return {?}
       */
      SelectorMatcher.prototype._matchPartial = function (map, name, cssSelector, matchedCallback) {
          if (!map || typeof name !== 'string') {
              return false;
          }
          var /** @type {?} */ nestedSelector = map.get(name);
          if (!nestedSelector) {
              return false;
          }
          // TODO(perf): get rid of recursion and measure again
          // TODO(perf): don't pass the whole selector into the recursion,
          // but only the not processed parts
          return nestedSelector.match(cssSelector, matchedCallback);
      };
      return SelectorMatcher;
  }());
  var SelectorListContext = (function () {
      /**
       * @param {?} selectors
       */
      function SelectorListContext(selectors) {
          this.selectors = selectors;
          this.alreadyMatched = false;
      }
      return SelectorListContext;
  }());
  // Store context to pass back selector and context when a selector is matched
  var SelectorContext = (function () {
      /**
       * @param {?} selector
       * @param {?} cbContext
       * @param {?} listContext
       */
      function SelectorContext(selector, cbContext, listContext) {
          this.selector = selector;
          this.cbContext = cbContext;
          this.listContext = listContext;
          this.notSelectors = selector.notSelectors;
      }
      /**
       * @param {?} cssSelector
       * @param {?} callback
       * @return {?}
       */
      SelectorContext.prototype.finalize = function (cssSelector, callback) {
          var /** @type {?} */ result = true;
          if (this.notSelectors.length > 0 && (!this.listContext || !this.listContext.alreadyMatched)) {
              var /** @type {?} */ notMatcher = SelectorMatcher.createNotMatcher(this.notSelectors);
              result = !notMatcher.match(cssSelector, null);
          }
          if (result && callback && (!this.listContext || !this.listContext.alreadyMatched)) {
              if (this.listContext) {
                  this.listContext.alreadyMatched = true;
              }
              callback(this.selector, this.cbContext);
          }
          return result;
      };
      return SelectorContext;
  }());

  var /** @type {?} */ MODULE_SUFFIX = '';
  var /** @type {?} */ DASH_CASE_REGEXP = /-+([a-z0-9])/g;
  /**
   * @param {?} input
   * @return {?}
   */
  function dashCaseToCamelCase(input) {
      return input.replace(DASH_CASE_REGEXP, function () {
          var m = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              m[_i - 0] = arguments[_i];
          }
          return m[1].toUpperCase();
      });
  }
  /**
   * @param {?} input
   * @param {?} defaultValues
   * @return {?}
   */
  function splitAtColon(input, defaultValues) {
      return _splitAt(input, ':', defaultValues);
  }
  /**
   * @param {?} input
   * @param {?} defaultValues
   * @return {?}
   */
  function splitAtPeriod(input, defaultValues) {
      return _splitAt(input, '.', defaultValues);
  }
  /**
   * @param {?} input
   * @param {?} character
   * @param {?} defaultValues
   * @return {?}
   */
  function _splitAt(input, character, defaultValues) {
      var /** @type {?} */ characterIndex = input.indexOf(character);
      if (characterIndex == -1)
          return defaultValues;
      return [input.slice(0, characterIndex).trim(), input.slice(characterIndex + 1).trim()];
  }
  /**
   * @param {?} name
   * @return {?}
   */
  function sanitizeIdentifier(name) {
      return name.replace(/\W/g, '_');
  }
  /**
   * @param {?} value
   * @param {?} visitor
   * @param {?} context
   * @return {?}
   */
  function visitValue(value, visitor, context) {
      if (Array.isArray(value)) {
          return visitor.visitArray(/** @type {?} */ (value), context);
      }
      if (isStrictStringMap(value)) {
          return visitor.visitStringMap(/** @type {?} */ (value), context);
      }
      if (value == null || isPrimitive(value)) {
          return visitor.visitPrimitive(value, context);
      }
      return visitor.visitOther(value, context);
  }
  var ValueTransformer = (function () {
      function ValueTransformer() {
      }
      /**
       * @param {?} arr
       * @param {?} context
       * @return {?}
       */
      ValueTransformer.prototype.visitArray = function (arr, context) {
          var _this = this;
          return arr.map(function (value) { return visitValue(value, _this, context); });
      };
      /**
       * @param {?} map
       * @param {?} context
       * @return {?}
       */
      ValueTransformer.prototype.visitStringMap = function (map, context) {
          var _this = this;
          var /** @type {?} */ result = {};
          Object.keys(map).forEach(function (key) { result[key] = visitValue(map[key], _this, context); });
          return result;
      };
      /**
       * @param {?} value
       * @param {?} context
       * @return {?}
       */
      ValueTransformer.prototype.visitPrimitive = function (value, context) { return value; };
      /**
       * @param {?} value
       * @param {?} context
       * @return {?}
       */
      ValueTransformer.prototype.visitOther = function (value, context) { return value; };
      return ValueTransformer;
  }());
  var SyncAsyncResult = (function () {
      /**
       * @param {?} syncResult
       * @param {?=} asyncResult
       */
      function SyncAsyncResult(syncResult, asyncResult) {
          if (asyncResult === void 0) { asyncResult = null; }
          this.syncResult = syncResult;
          this.asyncResult = asyncResult;
          if (!asyncResult) {
              this.asyncResult = Promise.resolve(syncResult);
          }
      }
      return SyncAsyncResult;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$9 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  /**
   * @return {?}
   */
  function unimplemented() {
      throw new Error('unimplemented');
  }
  // group 0: "[prop] or (event) or @trigger"
  // group 1: "prop" from "[prop]"
  // group 2: "event" from "(event)"
  // group 3: "@trigger" from "@trigger"
  var /** @type {?} */ HOST_REG_EXP = /^(?:(?:\[([^\]]+)\])|(?:\(([^\)]+)\)))|(\@[-\w]+)$/;
  /**
   * @abstract
   */
  var CompileMetadataWithIdentifier = (function () {
      function CompileMetadataWithIdentifier() {
      }
      Object.defineProperty(CompileMetadataWithIdentifier.prototype, "identifier", {
          /**
           * @return {?}
           */
          get: function () { return (unimplemented()); },
          enumerable: true,
          configurable: true
      });
      return CompileMetadataWithIdentifier;
  }());
  var CompileAnimationEntryMetadata = (function () {
      /**
       * @param {?=} name
       * @param {?=} definitions
       */
      function CompileAnimationEntryMetadata(name, definitions) {
          if (name === void 0) { name = null; }
          if (definitions === void 0) { definitions = null; }
          this.name = name;
          this.definitions = definitions;
      }
      return CompileAnimationEntryMetadata;
  }());
  /**
   * @abstract
   */
  var CompileAnimationStateMetadata = (function () {
      function CompileAnimationStateMetadata() {
      }
      return CompileAnimationStateMetadata;
  }());
  var CompileAnimationStateDeclarationMetadata = (function (_super) {
      __extends$9(CompileAnimationStateDeclarationMetadata, _super);
      /**
       * @param {?} stateNameExpr
       * @param {?} styles
       */
      function CompileAnimationStateDeclarationMetadata(stateNameExpr, styles) {
          _super.call(this);
          this.stateNameExpr = stateNameExpr;
          this.styles = styles;
      }
      return CompileAnimationStateDeclarationMetadata;
  }(CompileAnimationStateMetadata));
  var CompileAnimationStateTransitionMetadata = (function (_super) {
      __extends$9(CompileAnimationStateTransitionMetadata, _super);
      /**
       * @param {?} stateChangeExpr
       * @param {?} steps
       */
      function CompileAnimationStateTransitionMetadata(stateChangeExpr, steps) {
          _super.call(this);
          this.stateChangeExpr = stateChangeExpr;
          this.steps = steps;
      }
      return CompileAnimationStateTransitionMetadata;
  }(CompileAnimationStateMetadata));
  /**
   * @abstract
   */
  var CompileAnimationMetadata = (function () {
      function CompileAnimationMetadata() {
      }
      return CompileAnimationMetadata;
  }());
  var CompileAnimationKeyframesSequenceMetadata = (function (_super) {
      __extends$9(CompileAnimationKeyframesSequenceMetadata, _super);
      /**
       * @param {?=} steps
       */
      function CompileAnimationKeyframesSequenceMetadata(steps) {
          if (steps === void 0) { steps = []; }
          _super.call(this);
          this.steps = steps;
      }
      return CompileAnimationKeyframesSequenceMetadata;
  }(CompileAnimationMetadata));
  var CompileAnimationStyleMetadata = (function (_super) {
      __extends$9(CompileAnimationStyleMetadata, _super);
      /**
       * @param {?} offset
       * @param {?=} styles
       */
      function CompileAnimationStyleMetadata(offset, styles) {
          if (styles === void 0) { styles = null; }
          _super.call(this);
          this.offset = offset;
          this.styles = styles;
      }
      return CompileAnimationStyleMetadata;
  }(CompileAnimationMetadata));
  var CompileAnimationAnimateMetadata = (function (_super) {
      __extends$9(CompileAnimationAnimateMetadata, _super);
      /**
       * @param {?=} timings
       * @param {?=} styles
       */
      function CompileAnimationAnimateMetadata(timings, styles) {
          if (timings === void 0) { timings = 0; }
          if (styles === void 0) { styles = null; }
          _super.call(this);
          this.timings = timings;
          this.styles = styles;
      }
      return CompileAnimationAnimateMetadata;
  }(CompileAnimationMetadata));
  /**
   * @abstract
   */
  var CompileAnimationWithStepsMetadata = (function (_super) {
      __extends$9(CompileAnimationWithStepsMetadata, _super);
      /**
       * @param {?=} steps
       */
      function CompileAnimationWithStepsMetadata(steps) {
          if (steps === void 0) { steps = null; }
          _super.call(this);
          this.steps = steps;
      }
      return CompileAnimationWithStepsMetadata;
  }(CompileAnimationMetadata));
  var CompileAnimationSequenceMetadata = (function (_super) {
      __extends$9(CompileAnimationSequenceMetadata, _super);
      /**
       * @param {?=} steps
       */
      function CompileAnimationSequenceMetadata(steps) {
          if (steps === void 0) { steps = null; }
          _super.call(this, steps);
      }
      return CompileAnimationSequenceMetadata;
  }(CompileAnimationWithStepsMetadata));
  var CompileAnimationGroupMetadata = (function (_super) {
      __extends$9(CompileAnimationGroupMetadata, _super);
      /**
       * @param {?=} steps
       */
      function CompileAnimationGroupMetadata(steps) {
          if (steps === void 0) { steps = null; }
          _super.call(this, steps);
      }
      return CompileAnimationGroupMetadata;
  }(CompileAnimationWithStepsMetadata));
  var CompileIdentifierMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompileIdentifierMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, reference = _b.reference, name = _b.name, moduleUrl = _b.moduleUrl, prefix = _b.prefix, value = _b.value;
          this.reference = reference;
          this.name = name;
          this.prefix = prefix;
          this.moduleUrl = moduleUrl;
          this.value = value;
      }
      Object.defineProperty(CompileIdentifierMetadata.prototype, "identifier", {
          /**
           * @return {?}
           */
          get: function () { return this; },
          enumerable: true,
          configurable: true
      });
      return CompileIdentifierMetadata;
  }());
  var CompileDiDependencyMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompileDiDependencyMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, isAttribute = _b.isAttribute, isSelf = _b.isSelf, isHost = _b.isHost, isSkipSelf = _b.isSkipSelf, isOptional = _b.isOptional, isValue = _b.isValue, token = _b.token, value = _b.value;
          this.isAttribute = !!isAttribute;
          this.isSelf = !!isSelf;
          this.isHost = !!isHost;
          this.isSkipSelf = !!isSkipSelf;
          this.isOptional = !!isOptional;
          this.isValue = !!isValue;
          this.token = token;
          this.value = value;
      }
      return CompileDiDependencyMetadata;
  }());
  var CompileProviderMetadata = (function () {
      /**
       * @param {?} __0
       */
      function CompileProviderMetadata(_a) {
          var token = _a.token, useClass = _a.useClass, useValue = _a.useValue, useExisting = _a.useExisting, useFactory = _a.useFactory, deps = _a.deps, multi = _a.multi;
          this.token = token;
          this.useClass = useClass;
          this.useValue = useValue;
          this.useExisting = useExisting;
          this.useFactory = useFactory;
          this.deps = deps || null;
          this.multi = !!multi;
      }
      return CompileProviderMetadata;
  }());
  var CompileFactoryMetadata = (function (_super) {
      __extends$9(CompileFactoryMetadata, _super);
      /**
       * @param {?} __0
       */
      function CompileFactoryMetadata(_a) {
          var reference = _a.reference, name = _a.name, moduleUrl = _a.moduleUrl, prefix = _a.prefix, diDeps = _a.diDeps, value = _a.value;
          _super.call(this, { reference: reference, name: name, prefix: prefix, moduleUrl: moduleUrl, value: value });
          this.diDeps = _normalizeArray(diDeps);
      }
      return CompileFactoryMetadata;
  }(CompileIdentifierMetadata));
  var CompileTokenMetadata = (function () {
      /**
       * @param {?} __0
       */
      function CompileTokenMetadata(_a) {
          var value = _a.value, identifier = _a.identifier, identifierIsInstance = _a.identifierIsInstance;
          this.value = value;
          this.identifier = identifier;
          this.identifierIsInstance = !!identifierIsInstance;
      }
      Object.defineProperty(CompileTokenMetadata.prototype, "reference", {
          /**
           * @return {?}
           */
          get: function () {
              if (isPresent(this.identifier)) {
                  return this.identifier.reference;
              }
              else {
                  return this.value;
              }
          },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(CompileTokenMetadata.prototype, "name", {
          /**
           * @return {?}
           */
          get: function () {
              return isPresent(this.value) ? sanitizeIdentifier(this.value) : this.identifier.name;
          },
          enumerable: true,
          configurable: true
      });
      return CompileTokenMetadata;
  }());
  /**
   *  Metadata regarding compilation of a type.
   */
  var CompileTypeMetadata = (function (_super) {
      __extends$9(CompileTypeMetadata, _super);
      /**
       * @param {?=} __0
       */
      function CompileTypeMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, reference = _b.reference, name = _b.name, moduleUrl = _b.moduleUrl, prefix = _b.prefix, isHost = _b.isHost, value = _b.value, diDeps = _b.diDeps, lifecycleHooks = _b.lifecycleHooks;
          _super.call(this, { reference: reference, name: name, moduleUrl: moduleUrl, prefix: prefix, value: value });
          this.isHost = !!isHost;
          this.diDeps = _normalizeArray(diDeps);
          this.lifecycleHooks = _normalizeArray(lifecycleHooks);
      }
      return CompileTypeMetadata;
  }(CompileIdentifierMetadata));
  var CompileQueryMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompileQueryMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, selectors = _b.selectors, descendants = _b.descendants, first = _b.first, propertyName = _b.propertyName, read = _b.read;
          this.selectors = selectors;
          this.descendants = !!descendants;
          this.first = !!first;
          this.propertyName = propertyName;
          this.read = read;
      }
      return CompileQueryMetadata;
  }());
  /**
   *  Metadata about a stylesheet
   */
  var CompileStylesheetMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompileStylesheetMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, moduleUrl = _b.moduleUrl, styles = _b.styles, styleUrls = _b.styleUrls;
          this.moduleUrl = moduleUrl;
          this.styles = _normalizeArray(styles);
          this.styleUrls = _normalizeArray(styleUrls);
      }
      return CompileStylesheetMetadata;
  }());
  /**
   *  Metadata regarding compilation of a template.
   */
  var CompileTemplateMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompileTemplateMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, encapsulation = _b.encapsulation, template = _b.template, templateUrl = _b.templateUrl, styles = _b.styles, styleUrls = _b.styleUrls, externalStylesheets = _b.externalStylesheets, animations = _b.animations, ngContentSelectors = _b.ngContentSelectors, interpolation = _b.interpolation;
          this.encapsulation = encapsulation;
          this.template = template;
          this.templateUrl = templateUrl;
          this.styles = _normalizeArray(styles);
          this.styleUrls = _normalizeArray(styleUrls);
          this.externalStylesheets = _normalizeArray(externalStylesheets);
          this.animations = animations ? ListWrapper.flatten(animations) : [];
          this.ngContentSelectors = ngContentSelectors || [];
          if (interpolation && interpolation.length != 2) {
              throw new Error("'interpolation' should have a start and an end symbol.");
          }
          this.interpolation = interpolation;
      }
      /**
       * @return {?}
       */
      CompileTemplateMetadata.prototype.toSummary = function () {
          return {
              isSummary: true,
              animations: this.animations.map(function (anim) { return anim.name; }),
              ngContentSelectors: this.ngContentSelectors,
              encapsulation: this.encapsulation
          };
      };
      return CompileTemplateMetadata;
  }());
  /**
   *  Metadata regarding compilation of a directive.
   */
  var CompileDirectiveMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompileDirectiveMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, type = _b.type, isComponent = _b.isComponent, selector = _b.selector, exportAs = _b.exportAs, changeDetection = _b.changeDetection, inputs = _b.inputs, outputs = _b.outputs, hostListeners = _b.hostListeners, hostProperties = _b.hostProperties, hostAttributes = _b.hostAttributes, providers = _b.providers, viewProviders = _b.viewProviders, queries = _b.queries, viewQueries = _b.viewQueries, entryComponents = _b.entryComponents, template = _b.template;
          this.type = type;
          this.isComponent = isComponent;
          this.selector = selector;
          this.exportAs = exportAs;
          this.changeDetection = changeDetection;
          this.inputs = inputs;
          this.outputs = outputs;
          this.hostListeners = hostListeners;
          this.hostProperties = hostProperties;
          this.hostAttributes = hostAttributes;
          this.providers = _normalizeArray(providers);
          this.viewProviders = _normalizeArray(viewProviders);
          this.queries = _normalizeArray(queries);
          this.viewQueries = _normalizeArray(viewQueries);
          this.entryComponents = _normalizeArray(entryComponents);
          this.template = template;
      }
      /**
       * @param {?=} __0
       * @return {?}
       */
      CompileDirectiveMetadata.create = function (_a) {
          var _b = _a === void 0 ? {} : _a, type = _b.type, isComponent = _b.isComponent, selector = _b.selector, exportAs = _b.exportAs, changeDetection = _b.changeDetection, inputs = _b.inputs, outputs = _b.outputs, host = _b.host, providers = _b.providers, viewProviders = _b.viewProviders, queries = _b.queries, viewQueries = _b.viewQueries, entryComponents = _b.entryComponents, template = _b.template;
          var /** @type {?} */ hostListeners = {};
          var /** @type {?} */ hostProperties = {};
          var /** @type {?} */ hostAttributes = {};
          if (isPresent(host)) {
              Object.keys(host).forEach(function (key) {
                  var /** @type {?} */ value = host[key];
                  var /** @type {?} */ matches = key.match(HOST_REG_EXP);
                  if (matches === null) {
                      hostAttributes[key] = value;
                  }
                  else if (isPresent(matches[1])) {
                      hostProperties[matches[1]] = value;
                  }
                  else if (isPresent(matches[2])) {
                      hostListeners[matches[2]] = value;
                  }
              });
          }
          var /** @type {?} */ inputsMap = {};
          if (isPresent(inputs)) {
              inputs.forEach(function (bindConfig) {
                  // canonical syntax: `dirProp: elProp`
                  // if there is no `:`, use dirProp = elProp
                  var /** @type {?} */ parts = splitAtColon(bindConfig, [bindConfig, bindConfig]);
                  inputsMap[parts[0]] = parts[1];
              });
          }
          var /** @type {?} */ outputsMap = {};
          if (isPresent(outputs)) {
              outputs.forEach(function (bindConfig) {
                  // canonical syntax: `dirProp: elProp`
                  // if there is no `:`, use dirProp = elProp
                  var /** @type {?} */ parts = splitAtColon(bindConfig, [bindConfig, bindConfig]);
                  outputsMap[parts[0]] = parts[1];
              });
          }
          return new CompileDirectiveMetadata({
              type: type,
              isComponent: !!isComponent, selector: selector, exportAs: exportAs, changeDetection: changeDetection,
              inputs: inputsMap,
              outputs: outputsMap,
              hostListeners: hostListeners,
              hostProperties: hostProperties,
              hostAttributes: hostAttributes,
              providers: providers,
              viewProviders: viewProviders,
              queries: queries,
              viewQueries: viewQueries,
              entryComponents: entryComponents,
              template: template,
          });
      };
      Object.defineProperty(CompileDirectiveMetadata.prototype, "identifier", {
          /**
           * @return {?}
           */
          get: function () { return this.type; },
          enumerable: true,
          configurable: true
      });
      /**
       * @return {?}
       */
      CompileDirectiveMetadata.prototype.toSummary = function () {
          return {
              isSummary: true,
              type: this.type,
              isComponent: this.isComponent,
              selector: this.selector,
              exportAs: this.exportAs,
              inputs: this.inputs,
              outputs: this.outputs,
              hostListeners: this.hostListeners,
              hostProperties: this.hostProperties,
              hostAttributes: this.hostAttributes,
              providers: this.providers,
              viewProviders: this.viewProviders,
              queries: this.queries,
              entryComponents: this.entryComponents,
              changeDetection: this.changeDetection,
              template: this.template && this.template.toSummary()
          };
      };
      return CompileDirectiveMetadata;
  }());
  /**
   *  Construct {@link CompileDirectiveMetadata} from {@link ComponentTypeMetadata} and a selector.
   * @param {?} compMeta
   * @return {?}
   */
  function createHostComponentMeta(compMeta) {
      var /** @type {?} */ template = CssSelector.parse(compMeta.selector)[0].getMatchingElementTemplate();
      return CompileDirectiveMetadata.create({
          type: new CompileTypeMetadata({
              reference: Object,
              name: compMeta.type.name + "_Host",
              moduleUrl: compMeta.type.moduleUrl,
              isHost: true
          }),
          template: new CompileTemplateMetadata({
              encapsulation: _angular_core.ViewEncapsulation.None,
              template: template,
              templateUrl: '',
              styles: [],
              styleUrls: [],
              ngContentSelectors: [],
              animations: []
          }),
          changeDetection: _angular_core.ChangeDetectionStrategy.Default,
          inputs: [],
          outputs: [],
          host: {},
          isComponent: true,
          selector: '*',
          providers: [],
          viewProviders: [],
          queries: [],
          viewQueries: []
      });
  }
  var CompilePipeMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompilePipeMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, type = _b.type, name = _b.name, pure = _b.pure;
          this.type = type;
          this.name = name;
          this.pure = !!pure;
      }
      Object.defineProperty(CompilePipeMetadata.prototype, "identifier", {
          /**
           * @return {?}
           */
          get: function () { return this.type; },
          enumerable: true,
          configurable: true
      });
      /**
       * @return {?}
       */
      CompilePipeMetadata.prototype.toSummary = function () {
          return { isSummary: true, type: this.type, name: this.name, pure: this.pure };
      };
      return CompilePipeMetadata;
  }());
  /**
   *  Metadata regarding compilation of a module.
   */
  var CompileNgModuleMetadata = (function () {
      /**
       * @param {?=} __0
       */
      function CompileNgModuleMetadata(_a) {
          var _b = _a === void 0 ? {} : _a, type = _b.type, providers = _b.providers, declaredDirectives = _b.declaredDirectives, exportedDirectives = _b.exportedDirectives, declaredPipes = _b.declaredPipes, exportedPipes = _b.exportedPipes, entryComponents = _b.entryComponents, bootstrapComponents = _b.bootstrapComponents, importedModules = _b.importedModules, exportedModules = _b.exportedModules, schemas = _b.schemas, transitiveModule = _b.transitiveModule, id = _b.id;
          this.type = type;
          this.declaredDirectives = _normalizeArray(declaredDirectives);
          this.exportedDirectives = _normalizeArray(exportedDirectives);
          this.declaredPipes = _normalizeArray(declaredPipes);
          this.exportedPipes = _normalizeArray(exportedPipes);
          this.providers = _normalizeArray(providers);
          this.entryComponents = _normalizeArray(entryComponents);
          this.bootstrapComponents = _normalizeArray(bootstrapComponents);
          this.importedModules = _normalizeArray(importedModules);
          this.exportedModules = _normalizeArray(exportedModules);
          this.schemas = _normalizeArray(schemas);
          this.id = id;
          this.transitiveModule = transitiveModule;
      }
      Object.defineProperty(CompileNgModuleMetadata.prototype, "identifier", {
          /**
           * @return {?}
           */
          get: function () { return this.type; },
          enumerable: true,
          configurable: true
      });
      /**
       * @return {?}
       */
      CompileNgModuleMetadata.prototype.toSummary = function () {
          return {
              isSummary: true,
              type: this.type,
              entryComponents: this.entryComponents,
              providers: this.providers,
              importedModules: this.importedModules,
              exportedModules: this.exportedModules,
              exportedDirectives: this.exportedDirectives,
              exportedPipes: this.exportedPipes,
              directiveLoaders: this.transitiveModule.directiveLoaders
          };
      };
      /**
       * @return {?}
       */
      CompileNgModuleMetadata.prototype.toInjectorSummary = function () {
          return {
              isSummary: true,
              type: this.type,
              entryComponents: this.entryComponents,
              providers: this.providers,
              importedModules: this.importedModules,
              exportedModules: this.exportedModules
          };
      };
      /**
       * @return {?}
       */
      CompileNgModuleMetadata.prototype.toDirectiveSummary = function () {
          return {
              isSummary: true,
              type: this.type,
              exportedDirectives: this.exportedDirectives,
              exportedPipes: this.exportedPipes,
              exportedModules: this.exportedModules,
              directiveLoaders: this.transitiveModule.directiveLoaders
          };
      };
      return CompileNgModuleMetadata;
  }());
  var TransitiveCompileNgModuleMetadata = (function () {
      /**
       * @param {?} modules
       * @param {?} providers
       * @param {?} entryComponents
       * @param {?} directives
       * @param {?} pipes
       * @param {?} directiveLoaders
       */
      function TransitiveCompileNgModuleMetadata(modules, providers, entryComponents, directives, pipes, directiveLoaders) {
          var _this = this;
          this.modules = modules;
          this.providers = providers;
          this.entryComponents = entryComponents;
          this.directives = directives;
          this.pipes = pipes;
          this.directiveLoaders = directiveLoaders;
          this.directivesSet = new Set();
          this.pipesSet = new Set();
          directives.forEach(function (dir) { return _this.directivesSet.add(dir.reference); });
          pipes.forEach(function (pipe) { return _this.pipesSet.add(pipe.reference); });
      }
      return TransitiveCompileNgModuleMetadata;
  }());
  /**
   * @param {?} items
   * @return {?}
   */
  function removeIdentifierDuplicates(items) {
      var /** @type {?} */ map = new Map();
      items.forEach(function (item) {
          if (!map.get(item.identifier.reference)) {
              map.set(item.identifier.reference, item);
          }
      });
      return Array.from(map.values());
  }
  /**
   * @param {?} obj
   * @return {?}
   */
  function _normalizeArray(obj) {
      return obj || [];
  }
  var ProviderMeta = (function () {
      /**
       * @param {?} token
       * @param {?} __1
       */
      function ProviderMeta(token, _a) {
          var useClass = _a.useClass, useValue = _a.useValue, useExisting = _a.useExisting, useFactory = _a.useFactory, deps = _a.deps, multi = _a.multi;
          this.token = token;
          this.useClass = useClass;
          this.useValue = useValue;
          this.useExisting = useExisting;
          this.useFactory = useFactory;
          this.dependencies = deps;
          this.multi = !!multi;
      }
      return ProviderMeta;
  }());

  var /** @type {?} */ isDefaultChangeDetectionStrategy = _angular_core.__core_private__.isDefaultChangeDetectionStrategy;
  var /** @type {?} */ ChangeDetectorStatus = _angular_core.__core_private__.ChangeDetectorStatus;
  var /** @type {?} */ LifecycleHooks = _angular_core.__core_private__.LifecycleHooks;
  var /** @type {?} */ LIFECYCLE_HOOKS_VALUES = _angular_core.__core_private__.LIFECYCLE_HOOKS_VALUES;
  var /** @type {?} */ ReflectorReader = _angular_core.__core_private__.ReflectorReader;
  var /** @type {?} */ ViewContainer = _angular_core.__core_private__.ViewContainer;
  var /** @type {?} */ CodegenComponentFactoryResolver = _angular_core.__core_private__.CodegenComponentFactoryResolver;
  var /** @type {?} */ ComponentRef_ = _angular_core.__core_private__.ComponentRef_;
  var /** @type {?} */ AppView = _angular_core.__core_private__.AppView;
  var /** @type {?} */ DebugAppView = _angular_core.__core_private__.DebugAppView;
  var /** @type {?} */ NgModuleInjector = _angular_core.__core_private__.NgModuleInjector;
  var /** @type {?} */ registerModuleFactory = _angular_core.__core_private__.registerModuleFactory;
  var /** @type {?} */ ViewType = _angular_core.__core_private__.ViewType;
  var /** @type {?} */ view_utils = _angular_core.__core_private__.view_utils;
  var /** @type {?} */ DebugContext = _angular_core.__core_private__.DebugContext;
  var /** @type {?} */ StaticNodeDebugInfo = _angular_core.__core_private__.StaticNodeDebugInfo;
  var /** @type {?} */ devModeEqual = _angular_core.__core_private__.devModeEqual;
  var /** @type {?} */ UNINITIALIZED = _angular_core.__core_private__.UNINITIALIZED;
  var /** @type {?} */ ValueUnwrapper = _angular_core.__core_private__.ValueUnwrapper;
  var /** @type {?} */ TemplateRef_ = _angular_core.__core_private__.TemplateRef_;
  var /** @type {?} */ Console = _angular_core.__core_private__.Console;
  var /** @type {?} */ reflector = _angular_core.__core_private__.reflector;
  var /** @type {?} */ Reflector = _angular_core.__core_private__.Reflector;
  var /** @type {?} */ ReflectionCapabilities = _angular_core.__core_private__.ReflectionCapabilities;
  var /** @type {?} */ NoOpAnimationPlayer = _angular_core.__core_private__.NoOpAnimationPlayer;
  var /** @type {?} */ AnimationSequencePlayer = _angular_core.__core_private__.AnimationSequencePlayer;
  var /** @type {?} */ AnimationGroupPlayer = _angular_core.__core_private__.AnimationGroupPlayer;
  var /** @type {?} */ AnimationKeyframe = _angular_core.__core_private__.AnimationKeyframe;
  var /** @type {?} */ AnimationStyles = _angular_core.__core_private__.AnimationStyles;
  var /** @type {?} */ ANY_STATE = _angular_core.__core_private__.ANY_STATE;
  var /** @type {?} */ DEFAULT_STATE = _angular_core.__core_private__.DEFAULT_STATE;
  var /** @type {?} */ EMPTY_STATE = _angular_core.__core_private__.EMPTY_STATE;
  var /** @type {?} */ FILL_STYLE_FLAG = _angular_core.__core_private__.FILL_STYLE_FLAG;
  var /** @type {?} */ prepareFinalAnimationStyles = _angular_core.__core_private__.prepareFinalAnimationStyles;
  var /** @type {?} */ balanceAnimationKeyframes = _angular_core.__core_private__.balanceAnimationKeyframes;
  var /** @type {?} */ clearStyles = _angular_core.__core_private__.clearStyles;
  var /** @type {?} */ collectAndResolveStyles = _angular_core.__core_private__.collectAndResolveStyles;
  var /** @type {?} */ renderStyles = _angular_core.__core_private__.renderStyles;
  var /** @type {?} */ ComponentStillLoadingError = _angular_core.__core_private__.ComponentStillLoadingError;
  var /** @type {?} */ AnimationTransition = _angular_core.__core_private__.AnimationTransition;

  var /** @type {?} */ APP_VIEW_MODULE_URL = assetUrl('core', 'linker/view');
  var /** @type {?} */ VIEW_UTILS_MODULE_URL = assetUrl('core', 'linker/view_utils');
  var /** @type {?} */ CD_MODULE_URL = assetUrl('core', 'change_detection/change_detection');
  var /** @type {?} */ ANIMATION_STYLE_UTIL_ASSET_URL = assetUrl('core', 'animation/animation_style_util');
  var Identifiers = (function () {
      function Identifiers() {
      }
      Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS = {
          name: 'ANALYZE_FOR_ENTRY_COMPONENTS',
          moduleUrl: assetUrl('core', 'metadata/di'),
          runtime: _angular_core.ANALYZE_FOR_ENTRY_COMPONENTS
      };
      Identifiers.ViewUtils = {
          name: 'ViewUtils',
          moduleUrl: assetUrl('core', 'linker/view_utils'),
          runtime: view_utils.ViewUtils
      };
      Identifiers.AppView = { name: 'AppView', moduleUrl: APP_VIEW_MODULE_URL, runtime: AppView };
      Identifiers.DebugAppView = {
          name: 'DebugAppView',
          moduleUrl: APP_VIEW_MODULE_URL,
          runtime: DebugAppView
      };
      Identifiers.ViewContainer = {
          name: 'ViewContainer',
          moduleUrl: assetUrl('core', 'linker/view_container'),
          runtime: ViewContainer
      };
      Identifiers.ElementRef = {
          name: 'ElementRef',
          moduleUrl: assetUrl('core', 'linker/element_ref'),
          runtime: _angular_core.ElementRef
      };
      Identifiers.ViewContainerRef = {
          name: 'ViewContainerRef',
          moduleUrl: assetUrl('core', 'linker/view_container_ref'),
          runtime: _angular_core.ViewContainerRef
      };
      Identifiers.ChangeDetectorRef = {
          name: 'ChangeDetectorRef',
          moduleUrl: assetUrl('core', 'change_detection/change_detector_ref'),
          runtime: _angular_core.ChangeDetectorRef
      };
      Identifiers.RenderComponentType = {
          name: 'RenderComponentType',
          moduleUrl: assetUrl('core', 'render/api'),
          runtime: _angular_core.RenderComponentType
      };
      Identifiers.QueryList = {
          name: 'QueryList',
          moduleUrl: assetUrl('core', 'linker/query_list'),
          runtime: _angular_core.QueryList
      };
      Identifiers.TemplateRef = {
          name: 'TemplateRef',
          moduleUrl: assetUrl('core', 'linker/template_ref'),
          runtime: _angular_core.TemplateRef
      };
      Identifiers.TemplateRef_ = {
          name: 'TemplateRef_',
          moduleUrl: assetUrl('core', 'linker/template_ref'),
          runtime: TemplateRef_
      };
      Identifiers.CodegenComponentFactoryResolver = {
          name: 'CodegenComponentFactoryResolver',
          moduleUrl: assetUrl('core', 'linker/component_factory_resolver'),
          runtime: CodegenComponentFactoryResolver
      };
      Identifiers.ComponentFactoryResolver = {
          name: 'ComponentFactoryResolver',
          moduleUrl: assetUrl('core', 'linker/component_factory_resolver'),
          runtime: _angular_core.ComponentFactoryResolver
      };
      Identifiers.ComponentFactory = {
          name: 'ComponentFactory',
          runtime: _angular_core.ComponentFactory,
          moduleUrl: assetUrl('core', 'linker/component_factory')
      };
      Identifiers.ComponentRef_ = {
          name: 'ComponentRef_',
          runtime: ComponentRef_,
          moduleUrl: assetUrl('core', 'linker/component_factory')
      };
      Identifiers.ComponentRef = {
          name: 'ComponentRef',
          runtime: _angular_core.ComponentRef,
          moduleUrl: assetUrl('core', 'linker/component_factory')
      };
      Identifiers.NgModuleFactory = {
          name: 'NgModuleFactory',
          runtime: _angular_core.NgModuleFactory,
          moduleUrl: assetUrl('core', 'linker/ng_module_factory')
      };
      Identifiers.NgModuleInjector = {
          name: 'NgModuleInjector',
          runtime: NgModuleInjector,
          moduleUrl: assetUrl('core', 'linker/ng_module_factory')
      };
      Identifiers.RegisterModuleFactoryFn = {
          name: 'registerModuleFactory',
          runtime: registerModuleFactory,
          moduleUrl: assetUrl('core', 'linker/ng_module_factory_loader')
      };
      Identifiers.ValueUnwrapper = { name: 'ValueUnwrapper', moduleUrl: CD_MODULE_URL, runtime: ValueUnwrapper };
      Identifiers.Injector = {
          name: 'Injector',
          moduleUrl: assetUrl('core', 'di/injector'),
          runtime: _angular_core.Injector
      };
      Identifiers.ViewEncapsulation = {
          name: 'ViewEncapsulation',
          moduleUrl: assetUrl('core', 'metadata/view'),
          runtime: _angular_core.ViewEncapsulation
      };
      Identifiers.ViewType = {
          name: 'ViewType',
          moduleUrl: assetUrl('core', 'linker/view_type'),
          runtime: ViewType
      };
      Identifiers.ChangeDetectionStrategy = {
          name: 'ChangeDetectionStrategy',
          moduleUrl: CD_MODULE_URL,
          runtime: _angular_core.ChangeDetectionStrategy
      };
      Identifiers.StaticNodeDebugInfo = {
          name: 'StaticNodeDebugInfo',
          moduleUrl: assetUrl('core', 'linker/debug_context'),
          runtime: StaticNodeDebugInfo
      };
      Identifiers.DebugContext = {
          name: 'DebugContext',
          moduleUrl: assetUrl('core', 'linker/debug_context'),
          runtime: DebugContext
      };
      Identifiers.Renderer = {
          name: 'Renderer',
          moduleUrl: assetUrl('core', 'render/api'),
          runtime: _angular_core.Renderer
      };
      Identifiers.SimpleChange = { name: 'SimpleChange', moduleUrl: CD_MODULE_URL, runtime: _angular_core.SimpleChange };
      Identifiers.UNINITIALIZED = { name: 'UNINITIALIZED', moduleUrl: CD_MODULE_URL, runtime: UNINITIALIZED };
      Identifiers.ChangeDetectorStatus = {
          name: 'ChangeDetectorStatus',
          moduleUrl: CD_MODULE_URL,
          runtime: ChangeDetectorStatus
      };
      Identifiers.checkBinding = {
          name: 'checkBinding',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.checkBinding
      };
      Identifiers.devModeEqual = { name: 'devModeEqual', moduleUrl: CD_MODULE_URL, runtime: devModeEqual };
      Identifiers.inlineInterpolate = {
          name: 'inlineInterpolate',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.inlineInterpolate
      };
      Identifiers.interpolate = {
          name: 'interpolate',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.interpolate
      };
      Identifiers.castByValue = {
          name: 'castByValue',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.castByValue
      };
      Identifiers.EMPTY_ARRAY = {
          name: 'EMPTY_ARRAY',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.EMPTY_ARRAY
      };
      Identifiers.EMPTY_MAP = {
          name: 'EMPTY_MAP',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.EMPTY_MAP
      };
      Identifiers.createRenderElement = {
          name: 'createRenderElement',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.createRenderElement
      };
      Identifiers.selectOrCreateRenderHostElement = {
          name: 'selectOrCreateRenderHostElement',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.selectOrCreateRenderHostElement
      };
      Identifiers.pureProxies = [
          null,
          { name: 'pureProxy1', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy1 },
          { name: 'pureProxy2', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy2 },
          { name: 'pureProxy3', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy3 },
          { name: 'pureProxy4', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy4 },
          { name: 'pureProxy5', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy5 },
          { name: 'pureProxy6', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy6 },
          { name: 'pureProxy7', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy7 },
          { name: 'pureProxy8', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy8 },
          { name: 'pureProxy9', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy9 },
          { name: 'pureProxy10', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.pureProxy10 },
      ];
      Identifiers.SecurityContext = {
          name: 'SecurityContext',
          moduleUrl: assetUrl('core', 'security'),
          runtime: _angular_core.SecurityContext,
      };
      Identifiers.AnimationKeyframe = {
          name: 'AnimationKeyframe',
          moduleUrl: assetUrl('core', 'animation/animation_keyframe'),
          runtime: AnimationKeyframe
      };
      Identifiers.AnimationStyles = {
          name: 'AnimationStyles',
          moduleUrl: assetUrl('core', 'animation/animation_styles'),
          runtime: AnimationStyles
      };
      Identifiers.NoOpAnimationPlayer = {
          name: 'NoOpAnimationPlayer',
          moduleUrl: assetUrl('core', 'animation/animation_player'),
          runtime: NoOpAnimationPlayer
      };
      Identifiers.AnimationGroupPlayer = {
          name: 'AnimationGroupPlayer',
          moduleUrl: assetUrl('core', 'animation/animation_group_player'),
          runtime: AnimationGroupPlayer
      };
      Identifiers.AnimationSequencePlayer = {
          name: 'AnimationSequencePlayer',
          moduleUrl: assetUrl('core', 'animation/animation_sequence_player'),
          runtime: AnimationSequencePlayer
      };
      Identifiers.prepareFinalAnimationStyles = {
          name: 'prepareFinalAnimationStyles',
          moduleUrl: ANIMATION_STYLE_UTIL_ASSET_URL,
          runtime: prepareFinalAnimationStyles
      };
      Identifiers.balanceAnimationKeyframes = {
          name: 'balanceAnimationKeyframes',
          moduleUrl: ANIMATION_STYLE_UTIL_ASSET_URL,
          runtime: balanceAnimationKeyframes
      };
      Identifiers.clearStyles = {
          name: 'clearStyles',
          moduleUrl: ANIMATION_STYLE_UTIL_ASSET_URL,
          runtime: clearStyles
      };
      Identifiers.renderStyles = {
          name: 'renderStyles',
          moduleUrl: ANIMATION_STYLE_UTIL_ASSET_URL,
          runtime: renderStyles
      };
      Identifiers.collectAndResolveStyles = {
          name: 'collectAndResolveStyles',
          moduleUrl: ANIMATION_STYLE_UTIL_ASSET_URL,
          runtime: collectAndResolveStyles
      };
      Identifiers.LOCALE_ID = {
          name: 'LOCALE_ID',
          moduleUrl: assetUrl('core', 'i18n/tokens'),
          runtime: _angular_core.LOCALE_ID
      };
      Identifiers.TRANSLATIONS_FORMAT = {
          name: 'TRANSLATIONS_FORMAT',
          moduleUrl: assetUrl('core', 'i18n/tokens'),
          runtime: _angular_core.TRANSLATIONS_FORMAT
      };
      Identifiers.setBindingDebugInfo = {
          name: 'setBindingDebugInfo',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.setBindingDebugInfo
      };
      Identifiers.setBindingDebugInfoForChanges = {
          name: 'setBindingDebugInfoForChanges',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.setBindingDebugInfoForChanges
      };
      Identifiers.AnimationTransition = {
          name: 'AnimationTransition',
          moduleUrl: assetUrl('core', 'animation/animation_transition'),
          runtime: AnimationTransition
      };
      // This is just the interface!
      Identifiers.InlineArray = { name: 'InlineArray', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: null };
      Identifiers.inlineArrays = [
          { name: 'InlineArray2', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.InlineArray2 },
          { name: 'InlineArray2', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.InlineArray2 },
          { name: 'InlineArray4', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.InlineArray4 },
          { name: 'InlineArray8', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.InlineArray8 },
          { name: 'InlineArray16', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.InlineArray16 },
      ];
      Identifiers.EMPTY_INLINE_ARRAY = {
          name: 'EMPTY_INLINE_ARRAY',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.EMPTY_INLINE_ARRAY
      };
      Identifiers.InlineArrayDynamic = {
          name: 'InlineArrayDynamic',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.InlineArrayDynamic
      };
      Identifiers.subscribeToRenderElement = {
          name: 'subscribeToRenderElement',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.subscribeToRenderElement
      };
      Identifiers.createRenderComponentType = {
          name: 'createRenderComponentType',
          moduleUrl: VIEW_UTILS_MODULE_URL,
          runtime: view_utils.createRenderComponentType
      };
      Identifiers.noop = { name: 'noop', moduleUrl: VIEW_UTILS_MODULE_URL, runtime: view_utils.noop };
      return Identifiers;
  }());
  /**
   * @param {?} pkg
   * @param {?=} path
   * @param {?=} type
   * @return {?}
   */
  function assetUrl(pkg, path, type) {
      if (path === void 0) { path = null; }
      if (type === void 0) { type = 'src'; }
      if (path == null) {
          return "@angular/" + pkg + "/index";
      }
      else {
          return "@angular/" + pkg + "/" + type + "/" + path;
      }
  }
  /**
   * @param {?} identifier
   * @return {?}
   */
  function resolveIdentifier(identifier) {
      var /** @type {?} */ moduleUrl = identifier.moduleUrl;
      var /** @type {?} */ reference = reflector.resolveIdentifier(identifier.name, identifier.moduleUrl, identifier.runtime);
      if (isStaticSymbol(reference)) {
          moduleUrl = reference.filePath;
      }
      return new CompileIdentifierMetadata({ name: identifier.name, moduleUrl: moduleUrl, reference: reference });
  }
  /**
   * @param {?} identifier
   * @return {?}
   */
  function identifierToken(identifier) {
      return new CompileTokenMetadata({ identifier: identifier });
  }
  /**
   * @param {?} identifier
   * @return {?}
   */
  function resolveIdentifierToken(identifier) {
      return identifierToken(resolveIdentifier(identifier));
  }
  /**
   * @param {?} enumType
   * @param {?} name
   * @return {?}
   */
  function resolveEnumIdentifier(enumType, name) {
      var /** @type {?} */ resolvedEnum = reflector.resolveEnum(enumType.reference, name);
      return new CompileIdentifierMetadata({ name: enumType.name + "." + name, moduleUrl: enumType.moduleUrl, reference: resolvedEnum });
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$10 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  // http://cldr.unicode.org/index/cldr-spec/plural-rules
  var /** @type {?} */ PLURAL_CASES = ['zero', 'one', 'two', 'few', 'many', 'other'];
  /**
   *  Expands special forms into elements.
    * *
    * For example,
    * *
    * ```
    * { messages.length, plural,
    * =0 {zero}
    * =1 {one}
    * other {more than one}
    * }
    * ```
    * *
    * will be expanded into
    * *
    * ```
    * <ng-container [ngPlural]="messages.length">
    * <template ngPluralCase="=0">zero</ng-container>
    * <template ngPluralCase="=1">one</ng-container>
    * <template ngPluralCase="other">more than one</ng-container>
    * </ng-container>
    * ```
   * @param {?} nodes
   * @return {?}
   */
  function expandNodes(nodes) {
      var /** @type {?} */ expander = new _Expander();
      return new ExpansionResult(visitAll(expander, nodes), expander.isExpanded, expander.errors);
  }
  var ExpansionResult = (function () {
      /**
       * @param {?} nodes
       * @param {?} expanded
       * @param {?} errors
       */
      function ExpansionResult(nodes, expanded, errors) {
          this.nodes = nodes;
          this.expanded = expanded;
          this.errors = errors;
      }
      return ExpansionResult;
  }());
  var ExpansionError = (function (_super) {
      __extends$10(ExpansionError, _super);
      /**
       * @param {?} span
       * @param {?} errorMsg
       */
      function ExpansionError(span, errorMsg) {
          _super.call(this, span, errorMsg);
      }
      return ExpansionError;
  }(ParseError));
  /**
   *  Expand expansion forms (plural, select) to directives
    * *
   */
  var _Expander = (function () {
      function _Expander() {
          this.isExpanded = false;
          this.errors = [];
      }
      /**
       * @param {?} element
       * @param {?} context
       * @return {?}
       */
      _Expander.prototype.visitElement = function (element, context) {
          return new Element(element.name, element.attrs, visitAll(this, element.children), element.sourceSpan, element.startSourceSpan, element.endSourceSpan);
      };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      _Expander.prototype.visitAttribute = function (attribute, context) { return attribute; };
      /**
       * @param {?} text
       * @param {?} context
       * @return {?}
       */
      _Expander.prototype.visitText = function (text, context) { return text; };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      _Expander.prototype.visitComment = function (comment, context) { return comment; };
      /**
       * @param {?} icu
       * @param {?} context
       * @return {?}
       */
      _Expander.prototype.visitExpansion = function (icu, context) {
          this.isExpanded = true;
          return icu.type == 'plural' ? _expandPluralForm(icu, this.errors) :
              _expandDefaultForm(icu, this.errors);
      };
      /**
       * @param {?} icuCase
       * @param {?} context
       * @return {?}
       */
      _Expander.prototype.visitExpansionCase = function (icuCase, context) {
          throw new Error('Should not be reached');
      };
      return _Expander;
  }());
  /**
   * @param {?} ast
   * @param {?} errors
   * @return {?}
   */
  function _expandPluralForm(ast, errors) {
      var /** @type {?} */ children = ast.cases.map(function (c) {
          if (PLURAL_CASES.indexOf(c.value) == -1 && !c.value.match(/^=\d+$/)) {
              errors.push(new ExpansionError(c.valueSourceSpan, "Plural cases should be \"=<number>\" or one of " + PLURAL_CASES.join(", ")));
          }
          var /** @type {?} */ expansionResult = expandNodes(c.expression);
          errors.push.apply(errors, expansionResult.errors);
          return new Element("template", [new Attribute$1('ngPluralCase', "" + c.value, c.valueSourceSpan)], expansionResult.nodes, c.sourceSpan, c.sourceSpan, c.sourceSpan);
      });
      var /** @type {?} */ switchAttr = new Attribute$1('[ngPlural]', ast.switchValue, ast.switchValueSourceSpan);
      return new Element('ng-container', [switchAttr], children, ast.sourceSpan, ast.sourceSpan, ast.sourceSpan);
  }
  /**
   * @param {?} ast
   * @param {?} errors
   * @return {?}
   */
  function _expandDefaultForm(ast, errors) {
      var /** @type {?} */ children = ast.cases.map(function (c) {
          var /** @type {?} */ expansionResult = expandNodes(c.expression);
          errors.push.apply(errors, expansionResult.errors);
          if (c.value === 'other') {
              // other is the default case when no values match
              return new Element("template", [new Attribute$1('ngSwitchDefault', '', c.valueSourceSpan)], expansionResult.nodes, c.sourceSpan, c.sourceSpan, c.sourceSpan);
          }
          return new Element("template", [new Attribute$1('ngSwitchCase', "" + c.value, c.valueSourceSpan)], expansionResult.nodes, c.sourceSpan, c.sourceSpan, c.sourceSpan);
      });
      var /** @type {?} */ switchAttr = new Attribute$1('[ngSwitch]', ast.switchValue, ast.switchValueSourceSpan);
      return new Element('ng-container', [switchAttr], children, ast.sourceSpan, ast.sourceSpan, ast.sourceSpan);
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$11 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var ProviderError = (function (_super) {
      __extends$11(ProviderError, _super);
      /**
       * @param {?} message
       * @param {?} span
       */
      function ProviderError(message, span) {
          _super.call(this, span, message);
      }
      return ProviderError;
  }(ParseError));
  var ProviderViewContext = (function () {
      /**
       * @param {?} component
       * @param {?} sourceSpan
       */
      function ProviderViewContext(component, sourceSpan) {
          var _this = this;
          this.component = component;
          this.sourceSpan = sourceSpan;
          this.errors = [];
          this.viewQueries = _getViewQueries(component);
          this.viewProviders = new Map();
          _normalizeProviders(component.viewProviders, sourceSpan, this.errors).forEach(function (provider) {
              if (isBlank(_this.viewProviders.get(provider.token.reference))) {
                  _this.viewProviders.set(provider.token.reference, true);
              }
          });
      }
      return ProviderViewContext;
  }());
  var ProviderElementContext = (function () {
      /**
       * @param {?} viewContext
       * @param {?} _parent
       * @param {?} _isViewRoot
       * @param {?} _directiveAsts
       * @param {?} attrs
       * @param {?} refs
       * @param {?} _sourceSpan
       */
      function ProviderElementContext(viewContext, _parent, _isViewRoot, _directiveAsts, attrs, refs, _sourceSpan) {
          var _this = this;
          this.viewContext = viewContext;
          this._parent = _parent;
          this._isViewRoot = _isViewRoot;
          this._directiveAsts = _directiveAsts;
          this._sourceSpan = _sourceSpan;
          this._transformedProviders = new Map();
          this._seenProviders = new Map();
          this._hasViewContainer = false;
          this._attrs = {};
          attrs.forEach(function (attrAst) { return _this._attrs[attrAst.name] = attrAst.value; });
          var directivesMeta = _directiveAsts.map(function (directiveAst) { return directiveAst.directive; });
          this._allProviders =
              _resolveProvidersFromDirectives(directivesMeta, _sourceSpan, viewContext.errors);
          this._contentQueries = _getContentQueries(directivesMeta);
          var queriedTokens = new Map();
          Array.from(this._allProviders.values()).forEach(function (provider) {
              _this._addQueryReadsTo(provider.token, queriedTokens);
          });
          refs.forEach(function (refAst) {
              _this._addQueryReadsTo(new CompileTokenMetadata({ value: refAst.name }), queriedTokens);
          });
          if (isPresent(queriedTokens.get(resolveIdentifierToken(Identifiers.ViewContainerRef).reference))) {
              this._hasViewContainer = true;
          }
          // create the providers that we know are eager first
          Array.from(this._allProviders.values()).forEach(function (provider) {
              var eager = provider.eager || isPresent(queriedTokens.get(provider.token.reference));
              if (eager) {
                  _this._getOrCreateLocalProvider(provider.providerType, provider.token, true);
              }
          });
      }
      /**
       * @return {?}
       */
      ProviderElementContext.prototype.afterElement = function () {
          var _this = this;
          // collect lazy providers
          Array.from(this._allProviders.values()).forEach(function (provider) {
              _this._getOrCreateLocalProvider(provider.providerType, provider.token, false);
          });
      };
      Object.defineProperty(ProviderElementContext.prototype, "transformProviders", {
          /**
           * @return {?}
           */
          get: function () {
              return Array.from(this._transformedProviders.values());
          },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(ProviderElementContext.prototype, "transformedDirectiveAsts", {
          /**
           * @return {?}
           */
          get: function () {
              var /** @type {?} */ sortedProviderTypes = this.transformProviders.map(function (provider) { return provider.token.identifier; });
              var /** @type {?} */ sortedDirectives = this._directiveAsts.slice();
              sortedDirectives.sort(function (dir1, dir2) { return sortedProviderTypes.indexOf(dir1.directive.type) -
                  sortedProviderTypes.indexOf(dir2.directive.type); });
              return sortedDirectives;
          },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(ProviderElementContext.prototype, "transformedHasViewContainer", {
          /**
           * @return {?}
           */
          get: function () { return this._hasViewContainer; },
          enumerable: true,
          configurable: true
      });
      /**
       * @param {?} token
       * @param {?} queryReadTokens
       * @return {?}
       */
      ProviderElementContext.prototype._addQueryReadsTo = function (token, queryReadTokens) {
          this._getQueriesFor(token).forEach(function (query) {
              var /** @type {?} */ queryReadToken = query.read || token;
              if (isBlank(queryReadTokens.get(queryReadToken.reference))) {
                  queryReadTokens.set(queryReadToken.reference, true);
              }
          });
      };
      /**
       * @param {?} token
       * @return {?}
       */
      ProviderElementContext.prototype._getQueriesFor = function (token) {
          var /** @type {?} */ result = [];
          var /** @type {?} */ currentEl = this;
          var /** @type {?} */ distance = 0;
          var /** @type {?} */ queries;
          while (currentEl !== null) {
              queries = currentEl._contentQueries.get(token.reference);
              if (isPresent(queries)) {
                  result.push.apply(result, queries.filter(function (query) { return query.descendants || distance <= 1; }));
              }
              if (currentEl._directiveAsts.length > 0) {
                  distance++;
              }
              currentEl = currentEl._parent;
          }
          queries = this.viewContext.viewQueries.get(token.reference);
          if (isPresent(queries)) {
              result.push.apply(result, queries);
          }
          return result;
      };
      /**
       * @param {?} requestingProviderType
       * @param {?} token
       * @param {?} eager
       * @return {?}
       */
      ProviderElementContext.prototype._getOrCreateLocalProvider = function (requestingProviderType, token, eager) {
          var _this = this;
          var /** @type {?} */ resolvedProvider = this._allProviders.get(token.reference);
          if (!resolvedProvider || ((requestingProviderType === ProviderAstType.Directive ||
              requestingProviderType === ProviderAstType.PublicService) &&
              resolvedProvider.providerType === ProviderAstType.PrivateService) ||
              ((requestingProviderType === ProviderAstType.PrivateService ||
                  requestingProviderType === ProviderAstType.PublicService) &&
                  resolvedProvider.providerType === ProviderAstType.Builtin)) {
              return null;
          }
          var /** @type {?} */ transformedProviderAst = this._transformedProviders.get(token.reference);
          if (isPresent(transformedProviderAst)) {
              return transformedProviderAst;
          }
          if (isPresent(this._seenProviders.get(token.reference))) {
              this.viewContext.errors.push(new ProviderError("Cannot instantiate cyclic dependency! " + token.name, this._sourceSpan));
              return null;
          }
          this._seenProviders.set(token.reference, true);
          var /** @type {?} */ transformedProviders = resolvedProvider.providers.map(function (provider) {
              var /** @type {?} */ transformedUseValue = provider.useValue;
              var /** @type {?} */ transformedUseExisting = provider.useExisting;
              var /** @type {?} */ transformedDeps;
              if (isPresent(provider.useExisting)) {
                  var /** @type {?} */ existingDiDep = _this._getDependency(resolvedProvider.providerType, new CompileDiDependencyMetadata({ token: provider.useExisting }), eager);
                  if (isPresent(existingDiDep.token)) {
                      transformedUseExisting = existingDiDep.token;
                  }
                  else {
                      transformedUseExisting = null;
                      transformedUseValue = existingDiDep.value;
                  }
              }
              else if (isPresent(provider.useFactory)) {
                  var /** @type {?} */ deps = provider.deps || provider.useFactory.diDeps;
                  transformedDeps =
                      deps.map(function (dep) { return _this._getDependency(resolvedProvider.providerType, dep, eager); });
              }
              else if (isPresent(provider.useClass)) {
                  var /** @type {?} */ deps = provider.deps || provider.useClass.diDeps;
                  transformedDeps =
                      deps.map(function (dep) { return _this._getDependency(resolvedProvider.providerType, dep, eager); });
              }
              return _transformProvider(provider, {
                  useExisting: transformedUseExisting,
                  useValue: transformedUseValue,
                  deps: transformedDeps
              });
          });
          transformedProviderAst =
              _transformProviderAst(resolvedProvider, { eager: eager, providers: transformedProviders });
          this._transformedProviders.set(token.reference, transformedProviderAst);
          return transformedProviderAst;
      };
      /**
       * @param {?} requestingProviderType
       * @param {?} dep
       * @param {?=} eager
       * @return {?}
       */
      ProviderElementContext.prototype._getLocalDependency = function (requestingProviderType, dep, eager) {
          if (eager === void 0) { eager = null; }
          if (dep.isAttribute) {
              var /** @type {?} */ attrValue = this._attrs[dep.token.value];
              return new CompileDiDependencyMetadata({ isValue: true, value: attrValue == null ? null : attrValue });
          }
          if (isPresent(dep.token)) {
              // access builtints
              if ((requestingProviderType === ProviderAstType.Directive ||
                  requestingProviderType === ProviderAstType.Component)) {
                  if (dep.token.reference === resolveIdentifierToken(Identifiers.Renderer).reference ||
                      dep.token.reference === resolveIdentifierToken(Identifiers.ElementRef).reference ||
                      dep.token.reference ===
                          resolveIdentifierToken(Identifiers.ChangeDetectorRef).reference ||
                      dep.token.reference === resolveIdentifierToken(Identifiers.TemplateRef).reference) {
                      return dep;
                  }
                  if (dep.token.reference ===
                      resolveIdentifierToken(Identifiers.ViewContainerRef).reference) {
                      this._hasViewContainer = true;
                  }
              }
              // access the injector
              if (dep.token.reference === resolveIdentifierToken(Identifiers.Injector).reference) {
                  return dep;
              }
              // access providers
              if (isPresent(this._getOrCreateLocalProvider(requestingProviderType, dep.token, eager))) {
                  return dep;
              }
          }
          return null;
      };
      /**
       * @param {?} requestingProviderType
       * @param {?} dep
       * @param {?=} eager
       * @return {?}
       */
      ProviderElementContext.prototype._getDependency = function (requestingProviderType, dep, eager) {
          if (eager === void 0) { eager = null; }
          var /** @type {?} */ currElement = this;
          var /** @type {?} */ currEager = eager;
          var /** @type {?} */ result = null;
          if (!dep.isSkipSelf) {
              result = this._getLocalDependency(requestingProviderType, dep, eager);
          }
          if (dep.isSelf) {
              if (!result && dep.isOptional) {
                  result = new CompileDiDependencyMetadata({ isValue: true, value: null });
              }
          }
          else {
              // check parent elements
              while (!result && isPresent(currElement._parent)) {
                  var /** @type {?} */ prevElement = currElement;
                  currElement = currElement._parent;
                  if (prevElement._isViewRoot) {
                      currEager = false;
                  }
                  result = currElement._getLocalDependency(ProviderAstType.PublicService, dep, currEager);
              }
              // check @Host restriction
              if (!result) {
                  if (!dep.isHost || this.viewContext.component.type.isHost ||
                      this.viewContext.component.type.reference === dep.token.reference ||
                      isPresent(this.viewContext.viewProviders.get(dep.token.reference))) {
                      result = dep;
                  }
                  else {
                      result = dep.isOptional ?
                          result = new CompileDiDependencyMetadata({ isValue: true, value: null }) :
                          null;
                  }
              }
          }
          if (!result) {
              this.viewContext.errors.push(new ProviderError("No provider for " + dep.token.name, this._sourceSpan));
          }
          return result;
      };
      return ProviderElementContext;
  }());
  var NgModuleProviderAnalyzer = (function () {
      /**
       * @param {?} ngModule
       * @param {?} extraProviders
       * @param {?} sourceSpan
       */
      function NgModuleProviderAnalyzer(ngModule, extraProviders, sourceSpan) {
          var _this = this;
          this._transformedProviders = new Map();
          this._seenProviders = new Map();
          this._errors = [];
          this._allProviders = new Map();
          var ngModuleTypes = ngModule.transitiveModule.modules.map(function (moduleMeta) { return moduleMeta.type; });
          ngModuleTypes.forEach(function (ngModuleType) {
              var ngModuleProvider = new CompileProviderMetadata({ token: new CompileTokenMetadata({ identifier: ngModuleType }), useClass: ngModuleType });
              _resolveProviders([ngModuleProvider], ProviderAstType.PublicService, true, sourceSpan, _this._errors, _this._allProviders);
          });
          _resolveProviders(_normalizeProviders(ngModule.transitiveModule.providers.concat(extraProviders), sourceSpan, this._errors), ProviderAstType.PublicService, false, sourceSpan, this._errors, this._allProviders);
      }
      /**
       * @return {?}
       */
      NgModuleProviderAnalyzer.prototype.parse = function () {
          var _this = this;
          Array.from(this._allProviders.values()).forEach(function (provider) {
              _this._getOrCreateLocalProvider(provider.token, provider.eager);
          });
          if (this._errors.length > 0) {
              var /** @type {?} */ errorString = this._errors.join('\n');
              throw new Error("Provider parse errors:\n" + errorString);
          }
          return Array.from(this._transformedProviders.values());
      };
      /**
       * @param {?} token
       * @param {?} eager
       * @return {?}
       */
      NgModuleProviderAnalyzer.prototype._getOrCreateLocalProvider = function (token, eager) {
          var _this = this;
          var /** @type {?} */ resolvedProvider = this._allProviders.get(token.reference);
          if (!resolvedProvider) {
              return null;
          }
          var /** @type {?} */ transformedProviderAst = this._transformedProviders.get(token.reference);
          if (isPresent(transformedProviderAst)) {
              return transformedProviderAst;
          }
          if (isPresent(this._seenProviders.get(token.reference))) {
              this._errors.push(new ProviderError("Cannot instantiate cyclic dependency! " + token.name, resolvedProvider.sourceSpan));
              return null;
          }
          this._seenProviders.set(token.reference, true);
          var /** @type {?} */ transformedProviders = resolvedProvider.providers.map(function (provider) {
              var /** @type {?} */ transformedUseValue = provider.useValue;
              var /** @type {?} */ transformedUseExisting = provider.useExisting;
              var /** @type {?} */ transformedDeps;
              if (isPresent(provider.useExisting)) {
                  var /** @type {?} */ existingDiDep = _this._getDependency(new CompileDiDependencyMetadata({ token: provider.useExisting }), eager, resolvedProvider.sourceSpan);
                  if (isPresent(existingDiDep.token)) {
                      transformedUseExisting = existingDiDep.token;
                  }
                  else {
                      transformedUseExisting = null;
                      transformedUseValue = existingDiDep.value;
                  }
              }
              else if (isPresent(provider.useFactory)) {
                  var /** @type {?} */ deps = provider.deps || provider.useFactory.diDeps;
                  transformedDeps =
                      deps.map(function (dep) { return _this._getDependency(dep, eager, resolvedProvider.sourceSpan); });
              }
              else if (isPresent(provider.useClass)) {
                  var /** @type {?} */ deps = provider.deps || provider.useClass.diDeps;
                  transformedDeps =
                      deps.map(function (dep) { return _this._getDependency(dep, eager, resolvedProvider.sourceSpan); });
              }
              return _transformProvider(provider, {
                  useExisting: transformedUseExisting,
                  useValue: transformedUseValue,
                  deps: transformedDeps
              });
          });
          transformedProviderAst =
              _transformProviderAst(resolvedProvider, { eager: eager, providers: transformedProviders });
          this._transformedProviders.set(token.reference, transformedProviderAst);
          return transformedProviderAst;
      };
      /**
       * @param {?} dep
       * @param {?=} eager
       * @param {?} requestorSourceSpan
       * @return {?}
       */
      NgModuleProviderAnalyzer.prototype._getDependency = function (dep, eager, requestorSourceSpan) {
          if (eager === void 0) { eager = null; }
          var /** @type {?} */ foundLocal = false;
          if (!dep.isSkipSelf && isPresent(dep.token)) {
              // access the injector
              if (dep.token.reference === resolveIdentifierToken(Identifiers.Injector).reference ||
                  dep.token.reference ===
                      resolveIdentifierToken(Identifiers.ComponentFactoryResolver).reference) {
                  foundLocal = true;
              }
              else if (isPresent(this._getOrCreateLocalProvider(dep.token, eager))) {
                  foundLocal = true;
              }
          }
          var /** @type {?} */ result = dep;
          if (dep.isSelf && !foundLocal) {
              if (dep.isOptional) {
                  result = new CompileDiDependencyMetadata({ isValue: true, value: null });
              }
              else {
                  this._errors.push(new ProviderError("No provider for " + dep.token.name, requestorSourceSpan));
              }
          }
          return result;
      };
      return NgModuleProviderAnalyzer;
  }());
  /**
   * @param {?} provider
   * @param {?} __1
   * @return {?}
   */
  function _transformProvider(provider, _a) {
      var useExisting = _a.useExisting, useValue = _a.useValue, deps = _a.deps;
      return new CompileProviderMetadata({
          token: provider.token,
          useClass: provider.useClass,
          useExisting: useExisting,
          useFactory: provider.useFactory,
          useValue: useValue,
          deps: deps,
          multi: provider.multi
      });
  }
  /**
   * @param {?} provider
   * @param {?} __1
   * @return {?}
   */
  function _transformProviderAst(provider, _a) {
      var eager = _a.eager, providers = _a.providers;
      return new ProviderAst(provider.token, provider.multiProvider, provider.eager || eager, providers, provider.providerType, provider.lifecycleHooks, provider.sourceSpan);
  }
  /**
   * @param {?} providers
   * @param {?} sourceSpan
   * @param {?} targetErrors
   * @param {?=} targetProviders
   * @return {?}
   */
  function _normalizeProviders(providers, sourceSpan, targetErrors, targetProviders) {
      if (targetProviders === void 0) { targetProviders = null; }
      if (!targetProviders) {
          targetProviders = [];
      }
      if (isPresent(providers)) {
          providers.forEach(function (provider) {
              if (Array.isArray(provider)) {
                  _normalizeProviders(/** @type {?} */ (provider), sourceSpan, targetErrors, targetProviders);
              }
              else {
                  var /** @type {?} */ normalizeProvider = void 0;
                  if (provider instanceof CompileProviderMetadata) {
                      normalizeProvider = provider;
                  }
                  else if (provider instanceof CompileTypeMetadata) {
                      normalizeProvider = new CompileProviderMetadata({ token: new CompileTokenMetadata({ identifier: provider }), useClass: provider });
                  }
                  else {
                      targetErrors.push(new ProviderError("Unknown provider type " + provider, sourceSpan));
                  }
                  if (isPresent(normalizeProvider)) {
                      targetProviders.push(normalizeProvider);
                  }
              }
          });
      }
      return targetProviders;
  }
  /**
   * @param {?} directives
   * @param {?} sourceSpan
   * @param {?} targetErrors
   * @return {?}
   */
  function _resolveProvidersFromDirectives(directives, sourceSpan, targetErrors) {
      var /** @type {?} */ providersByToken = new Map();
      directives.forEach(function (directive) {
          var /** @type {?} */ dirProvider = new CompileProviderMetadata({ token: new CompileTokenMetadata({ identifier: directive.type }), useClass: directive.type });
          _resolveProviders([dirProvider], directive.isComponent ? ProviderAstType.Component : ProviderAstType.Directive, true, sourceSpan, targetErrors, providersByToken);
      });
      // Note: directives need to be able to overwrite providers of a component!
      var /** @type {?} */ directivesWithComponentFirst = directives.filter(function (dir) { return dir.isComponent; }).concat(directives.filter(function (dir) { return !dir.isComponent; }));
      directivesWithComponentFirst.forEach(function (directive) {
          _resolveProviders(_normalizeProviders(directive.providers, sourceSpan, targetErrors), ProviderAstType.PublicService, false, sourceSpan, targetErrors, providersByToken);
          _resolveProviders(_normalizeProviders(directive.viewProviders, sourceSpan, targetErrors), ProviderAstType.PrivateService, false, sourceSpan, targetErrors, providersByToken);
      });
      return providersByToken;
  }
  /**
   * @param {?} providers
   * @param {?} providerType
   * @param {?} eager
   * @param {?} sourceSpan
   * @param {?} targetErrors
   * @param {?} targetProvidersByToken
   * @return {?}
   */
  function _resolveProviders(providers, providerType, eager, sourceSpan, targetErrors, targetProvidersByToken) {
      providers.forEach(function (provider) {
          var /** @type {?} */ resolvedProvider = targetProvidersByToken.get(provider.token.reference);
          if (isPresent(resolvedProvider) && resolvedProvider.multiProvider !== provider.multi) {
              targetErrors.push(new ProviderError("Mixing multi and non multi provider is not possible for token " + resolvedProvider.token.name, sourceSpan));
          }
          if (!resolvedProvider) {
              var /** @type {?} */ lifecycleHooks = provider.token.identifier && provider.token.identifier instanceof CompileTypeMetadata ?
                  provider.token.identifier.lifecycleHooks :
                  [];
              resolvedProvider = new ProviderAst(provider.token, provider.multi, eager || lifecycleHooks.length > 0, [provider], providerType, lifecycleHooks, sourceSpan);
              targetProvidersByToken.set(provider.token.reference, resolvedProvider);
          }
          else {
              if (!provider.multi) {
                  resolvedProvider.providers.length = 0;
              }
              resolvedProvider.providers.push(provider);
          }
      });
  }
  /**
   * @param {?} component
   * @return {?}
   */
  function _getViewQueries(component) {
      var /** @type {?} */ viewQueries = new Map();
      if (isPresent(component.viewQueries)) {
          component.viewQueries.forEach(function (query) { return _addQueryToTokenMap(viewQueries, query); });
      }
      return viewQueries;
  }
  /**
   * @param {?} directives
   * @return {?}
   */
  function _getContentQueries(directives) {
      var /** @type {?} */ contentQueries = new Map();
      directives.forEach(function (directive) {
          if (isPresent(directive.queries)) {
              directive.queries.forEach(function (query) { return _addQueryToTokenMap(contentQueries, query); });
          }
      });
      return contentQueries;
  }
  /**
   * @param {?} map
   * @param {?} query
   * @return {?}
   */
  function _addQueryToTokenMap(map, query) {
      query.selectors.forEach(function (token) {
          var /** @type {?} */ entry = map.get(token.reference);
          if (!entry) {
              entry = [];
              map.set(token.reference, entry);
          }
          entry.push(query);
      });
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  /**
   * @abstract
   */
  var ElementSchemaRegistry = (function () {
      function ElementSchemaRegistry() {
      }
      /**
       * @abstract
       * @param {?} tagName
       * @param {?} propName
       * @param {?} schemaMetas
       * @return {?}
       */
      ElementSchemaRegistry.prototype.hasProperty = function (tagName, propName, schemaMetas) { };
      /**
       * @abstract
       * @param {?} tagName
       * @param {?} schemaMetas
       * @return {?}
       */
      ElementSchemaRegistry.prototype.hasElement = function (tagName, schemaMetas) { };
      /**
       * @abstract
       * @param {?} elementName
       * @param {?} propName
       * @param {?} isAttribute
       * @return {?}
       */
      ElementSchemaRegistry.prototype.securityContext = function (elementName, propName, isAttribute) { };
      /**
       * @abstract
       * @return {?}
       */
      ElementSchemaRegistry.prototype.allKnownElementNames = function () { };
      /**
       * @abstract
       * @param {?} propName
       * @return {?}
       */
      ElementSchemaRegistry.prototype.getMappedPropName = function (propName) { };
      /**
       * @abstract
       * @return {?}
       */
      ElementSchemaRegistry.prototype.getDefaultComponentElementName = function () { };
      /**
       * @abstract
       * @param {?} name
       * @return {?}
       */
      ElementSchemaRegistry.prototype.validateProperty = function (name) { };
      /**
       * @abstract
       * @param {?} name
       * @return {?}
       */
      ElementSchemaRegistry.prototype.validateAttribute = function (name) { };
      /**
       * @abstract
       * @param {?} propName
       * @return {?}
       */
      ElementSchemaRegistry.prototype.normalizeAnimationStyleProperty = function (propName) { };
      /**
       * @abstract
       * @param {?} camelCaseProp
       * @param {?} userProvidedProp
       * @param {?} val
       * @return {?}
       */
      ElementSchemaRegistry.prototype.normalizeAnimationStyleValue = function (camelCaseProp, userProvidedProp, val) { };
      return ElementSchemaRegistry;
  }());

  var StyleWithImports = (function () {
      /**
       * @param {?} style
       * @param {?} styleUrls
       */
      function StyleWithImports(style, styleUrls) {
          this.style = style;
          this.styleUrls = styleUrls;
      }
      return StyleWithImports;
  }());
  /**
   * @param {?} url
   * @return {?}
   */
  function isStyleUrlResolvable(url) {
      if (isBlank(url) || url.length === 0 || url[0] == '/')
          return false;
      var /** @type {?} */ schemeMatch = url.match(_urlWithSchemaRe);
      return schemeMatch === null || schemeMatch[1] == 'package' || schemeMatch[1] == 'asset';
  }
  /**
   *  Rewrites stylesheets by resolving and removing the @import urls that
    * are either relative or don't have a `package:` scheme
   * @param {?} resolver
   * @param {?} baseUrl
   * @param {?} cssText
   * @return {?}
   */
  function extractStyleUrls(resolver, baseUrl, cssText) {
      var /** @type {?} */ foundUrls = [];
      var /** @type {?} */ modifiedCssText = cssText.replace(_cssImportRe, function () {
          var m = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              m[_i - 0] = arguments[_i];
          }
          var /** @type {?} */ url = m[1] || m[2];
          if (!isStyleUrlResolvable(url)) {
              // Do not attempt to resolve non-package absolute URLs with URI scheme
              return m[0];
          }
          foundUrls.push(resolver.resolve(baseUrl, url));
          return '';
      });
      return new StyleWithImports(modifiedCssText, foundUrls);
  }
  var /** @type {?} */ _cssImportRe = /@import\s+(?:url\()?\s*(?:(?:['"]([^'"]*))|([^;\)\s]*))[^;]*;?/g;
  var /** @type {?} */ _urlWithSchemaRe = /^([^:/?#]+):/;

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$12 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var /** @type {?} */ PROPERTY_PARTS_SEPARATOR = '.';
  var /** @type {?} */ ATTRIBUTE_PREFIX = 'attr';
  var /** @type {?} */ CLASS_PREFIX = 'class';
  var /** @type {?} */ STYLE_PREFIX = 'style';
  var /** @type {?} */ ANIMATE_PROP_PREFIX = 'animate-';
  var BoundPropertyType = {};
  BoundPropertyType.DEFAULT = 0;
  BoundPropertyType.LITERAL_ATTR = 1;
  BoundPropertyType.ANIMATION = 2;
  BoundPropertyType[BoundPropertyType.DEFAULT] = "DEFAULT";
  BoundPropertyType[BoundPropertyType.LITERAL_ATTR] = "LITERAL_ATTR";
  BoundPropertyType[BoundPropertyType.ANIMATION] = "ANIMATION";
  /**
   *  Represents a parsed property.
   */
  var BoundProperty = (function () {
      /**
       * @param {?} name
       * @param {?} expression
       * @param {?} type
       * @param {?} sourceSpan
       */
      function BoundProperty(name, expression, type, sourceSpan) {
          this.name = name;
          this.expression = expression;
          this.type = type;
          this.sourceSpan = sourceSpan;
      }
      Object.defineProperty(BoundProperty.prototype, "isLiteral", {
          /**
           * @return {?}
           */
          get: function () { return this.type === BoundPropertyType.LITERAL_ATTR; },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(BoundProperty.prototype, "isAnimation", {
          /**
           * @return {?}
           */
          get: function () { return this.type === BoundPropertyType.ANIMATION; },
          enumerable: true,
          configurable: true
      });
      return BoundProperty;
  }());
  /**
   *  Parses bindings in templates and in the directive host area.
   */
  var BindingParser = (function () {
      /**
       * @param {?} _exprParser
       * @param {?} _interpolationConfig
       * @param {?} _schemaRegistry
       * @param {?} pipes
       * @param {?} _targetErrors
       */
      function BindingParser(_exprParser, _interpolationConfig, _schemaRegistry, pipes, _targetErrors) {
          var _this = this;
          this._exprParser = _exprParser;
          this._interpolationConfig = _interpolationConfig;
          this._schemaRegistry = _schemaRegistry;
          this._targetErrors = _targetErrors;
          this.pipesByName = new Map();
          pipes.forEach(function (pipe) { return _this.pipesByName.set(pipe.name, pipe); });
      }
      /**
       * @param {?} dirMeta
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype.createDirectiveHostPropertyAsts = function (dirMeta, sourceSpan) {
          var _this = this;
          if (dirMeta.hostProperties) {
              var /** @type {?} */ boundProps_1 = [];
              Object.keys(dirMeta.hostProperties).forEach(function (propName) {
                  var /** @type {?} */ expression = dirMeta.hostProperties[propName];
                  if (typeof expression === 'string') {
                      _this.parsePropertyBinding(propName, expression, true, sourceSpan, [], boundProps_1);
                  }
                  else {
                      _this._reportError("Value of the host property binding \"" + propName + "\" needs to be a string representing an expression but got \"" + expression + "\" (" + typeof expression + ")", sourceSpan);
                  }
              });
              return boundProps_1.map(function (prop) { return _this.createElementPropertyAst(dirMeta.selector, prop); });
          }
      };
      /**
       * @param {?} dirMeta
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype.createDirectiveHostEventAsts = function (dirMeta, sourceSpan) {
          var _this = this;
          if (dirMeta.hostListeners) {
              var /** @type {?} */ targetEventAsts_1 = [];
              Object.keys(dirMeta.hostListeners).forEach(function (propName) {
                  var /** @type {?} */ expression = dirMeta.hostListeners[propName];
                  if (typeof expression === 'string') {
                      _this.parseEvent(propName, expression, sourceSpan, [], targetEventAsts_1);
                  }
                  else {
                      _this._reportError("Value of the host listener \"" + propName + "\" needs to be a string representing an expression but got \"" + expression + "\" (" + typeof expression + ")", sourceSpan);
                  }
              });
              return targetEventAsts_1;
          }
      };
      /**
       * @param {?} value
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype.parseInterpolation = function (value, sourceSpan) {
          var /** @type {?} */ sourceInfo = sourceSpan.start.toString();
          try {
              var /** @type {?} */ ast = this._exprParser.parseInterpolation(value, sourceInfo, this._interpolationConfig);
              if (ast)
                  this._reportExpressionParserErrors(ast.errors, sourceSpan);
              this._checkPipes(ast, sourceSpan);
              return ast;
          }
          catch (e) {
              this._reportError("" + e, sourceSpan);
              return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
          }
      };
      /**
       * @param {?} name
       * @param {?} prefixToken
       * @param {?} value
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetProps
       * @param {?} targetVars
       * @return {?}
       */
      BindingParser.prototype.parseInlineTemplateBinding = function (name, prefixToken, value, sourceSpan, targetMatchableAttrs, targetProps, targetVars) {
          var /** @type {?} */ bindings = this._parseTemplateBindings(prefixToken, value, sourceSpan);
          for (var /** @type {?} */ i = 0; i < bindings.length; i++) {
              var /** @type {?} */ binding = bindings[i];
              if (binding.keyIsVar) {
                  targetVars.push(new VariableAst(binding.key, binding.name, sourceSpan));
              }
              else if (isPresent(binding.expression)) {
                  this._parsePropertyAst(binding.key, binding.expression, sourceSpan, targetMatchableAttrs, targetProps);
              }
              else {
                  targetMatchableAttrs.push([binding.key, '']);
                  this.parseLiteralAttr(binding.key, null, sourceSpan, targetMatchableAttrs, targetProps);
              }
          }
      };
      /**
       * @param {?} prefixToken
       * @param {?} value
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype._parseTemplateBindings = function (prefixToken, value, sourceSpan) {
          var _this = this;
          var /** @type {?} */ sourceInfo = sourceSpan.start.toString();
          try {
              var /** @type {?} */ bindingsResult = this._exprParser.parseTemplateBindings(prefixToken, value, sourceInfo);
              this._reportExpressionParserErrors(bindingsResult.errors, sourceSpan);
              bindingsResult.templateBindings.forEach(function (binding) {
                  if (isPresent(binding.expression)) {
                      _this._checkPipes(binding.expression, sourceSpan);
                  }
              });
              bindingsResult.warnings.forEach(function (warning) { _this._reportError(warning, sourceSpan, ParseErrorLevel.WARNING); });
              return bindingsResult.templateBindings;
          }
          catch (e) {
              this._reportError("" + e, sourceSpan);
              return [];
          }
      };
      /**
       * @param {?} name
       * @param {?} value
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetProps
       * @return {?}
       */
      BindingParser.prototype.parseLiteralAttr = function (name, value, sourceSpan, targetMatchableAttrs, targetProps) {
          if (_isAnimationLabel(name)) {
              name = name.substring(1);
              if (value) {
                  this._reportError("Assigning animation triggers via @prop=\"exp\" attributes with an expression is invalid." +
                      " Use property bindings (e.g. [@prop]=\"exp\") or use an attribute without a value (e.g. @prop) instead.", sourceSpan, ParseErrorLevel.FATAL);
              }
              this._parseAnimation(name, value, sourceSpan, targetMatchableAttrs, targetProps);
          }
          else {
              targetProps.push(new BoundProperty(name, this._exprParser.wrapLiteralPrimitive(value, ''), BoundPropertyType.LITERAL_ATTR, sourceSpan));
          }
      };
      /**
       * @param {?} name
       * @param {?} expression
       * @param {?} isHost
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetProps
       * @return {?}
       */
      BindingParser.prototype.parsePropertyBinding = function (name, expression, isHost, sourceSpan, targetMatchableAttrs, targetProps) {
          var /** @type {?} */ isAnimationProp = false;
          if (name.startsWith(ANIMATE_PROP_PREFIX)) {
              isAnimationProp = true;
              name = name.substring(ANIMATE_PROP_PREFIX.length);
          }
          else if (_isAnimationLabel(name)) {
              isAnimationProp = true;
              name = name.substring(1);
          }
          if (isAnimationProp) {
              this._parseAnimation(name, expression, sourceSpan, targetMatchableAttrs, targetProps);
          }
          else {
              this._parsePropertyAst(name, this._parseBinding(expression, isHost, sourceSpan), sourceSpan, targetMatchableAttrs, targetProps);
          }
      };
      /**
       * @param {?} name
       * @param {?} value
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetProps
       * @return {?}
       */
      BindingParser.prototype.parsePropertyInterpolation = function (name, value, sourceSpan, targetMatchableAttrs, targetProps) {
          var /** @type {?} */ expr = this.parseInterpolation(value, sourceSpan);
          if (isPresent(expr)) {
              this._parsePropertyAst(name, expr, sourceSpan, targetMatchableAttrs, targetProps);
              return true;
          }
          return false;
      };
      /**
       * @param {?} name
       * @param {?} ast
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetProps
       * @return {?}
       */
      BindingParser.prototype._parsePropertyAst = function (name, ast, sourceSpan, targetMatchableAttrs, targetProps) {
          targetMatchableAttrs.push([name, ast.source]);
          targetProps.push(new BoundProperty(name, ast, BoundPropertyType.DEFAULT, sourceSpan));
      };
      /**
       * @param {?} name
       * @param {?} expression
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetProps
       * @return {?}
       */
      BindingParser.prototype._parseAnimation = function (name, expression, sourceSpan, targetMatchableAttrs, targetProps) {
          // This will occur when a @trigger is not paired with an expression.
          // For animations it is valid to not have an expression since */void
          // states will be applied by angular when the element is attached/detached
          var /** @type {?} */ ast = this._parseBinding(expression || 'null', false, sourceSpan);
          targetMatchableAttrs.push([name, ast.source]);
          targetProps.push(new BoundProperty(name, ast, BoundPropertyType.ANIMATION, sourceSpan));
      };
      /**
       * @param {?} value
       * @param {?} isHostBinding
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype._parseBinding = function (value, isHostBinding, sourceSpan) {
          var /** @type {?} */ sourceInfo = sourceSpan.start.toString();
          try {
              var /** @type {?} */ ast = isHostBinding ?
                  this._exprParser.parseSimpleBinding(value, sourceInfo, this._interpolationConfig) :
                  this._exprParser.parseBinding(value, sourceInfo, this._interpolationConfig);
              if (ast)
                  this._reportExpressionParserErrors(ast.errors, sourceSpan);
              this._checkPipes(ast, sourceSpan);
              return ast;
          }
          catch (e) {
              this._reportError("" + e, sourceSpan);
              return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
          }
      };
      /**
       * @param {?} elementSelector
       * @param {?} boundProp
       * @return {?}
       */
      BindingParser.prototype.createElementPropertyAst = function (elementSelector, boundProp) {
          if (boundProp.isAnimation) {
              return new BoundElementPropertyAst(boundProp.name, PropertyBindingType.Animation, _angular_core.SecurityContext.NONE, false, boundProp.expression, null, boundProp.sourceSpan);
          }
          var /** @type {?} */ unit = null;
          var /** @type {?} */ bindingType;
          var /** @type {?} */ boundPropertyName;
          var /** @type {?} */ parts = boundProp.name.split(PROPERTY_PARTS_SEPARATOR);
          var /** @type {?} */ securityContexts;
          if (parts.length === 1) {
              var /** @type {?} */ partValue = parts[0];
              boundPropertyName = this._schemaRegistry.getMappedPropName(partValue);
              securityContexts = calcPossibleSecurityContexts(this._schemaRegistry, elementSelector, boundPropertyName, false);
              bindingType = PropertyBindingType.Property;
              this._validatePropertyOrAttributeName(boundPropertyName, boundProp.sourceSpan, false);
          }
          else {
              if (parts[0] == ATTRIBUTE_PREFIX) {
                  boundPropertyName = parts[1];
                  this._validatePropertyOrAttributeName(boundPropertyName, boundProp.sourceSpan, true);
                  securityContexts = calcPossibleSecurityContexts(this._schemaRegistry, elementSelector, boundPropertyName, true);
                  var /** @type {?} */ nsSeparatorIdx = boundPropertyName.indexOf(':');
                  if (nsSeparatorIdx > -1) {
                      var /** @type {?} */ ns = boundPropertyName.substring(0, nsSeparatorIdx);
                      var /** @type {?} */ name_1 = boundPropertyName.substring(nsSeparatorIdx + 1);
                      boundPropertyName = mergeNsAndName(ns, name_1);
                  }
                  bindingType = PropertyBindingType.Attribute;
              }
              else if (parts[0] == CLASS_PREFIX) {
                  boundPropertyName = parts[1];
                  bindingType = PropertyBindingType.Class;
                  securityContexts = [_angular_core.SecurityContext.NONE];
              }
              else if (parts[0] == STYLE_PREFIX) {
                  unit = parts.length > 2 ? parts[2] : null;
                  boundPropertyName = parts[1];
                  bindingType = PropertyBindingType.Style;
                  securityContexts = [_angular_core.SecurityContext.STYLE];
              }
              else {
                  this._reportError("Invalid property name '" + boundProp.name + "'", boundProp.sourceSpan);
                  bindingType = null;
                  securityContexts = [];
              }
          }
          return new BoundElementPropertyAst(boundPropertyName, bindingType, securityContexts.length === 1 ? securityContexts[0] : null, securityContexts.length > 1, boundProp.expression, unit, boundProp.sourceSpan);
      };
      /**
       * @param {?} name
       * @param {?} expression
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetEvents
       * @return {?}
       */
      BindingParser.prototype.parseEvent = function (name, expression, sourceSpan, targetMatchableAttrs, targetEvents) {
          if (_isAnimationLabel(name)) {
              name = name.substr(1);
              this._parseAnimationEvent(name, expression, sourceSpan, targetEvents);
          }
          else {
              this._parseEvent(name, expression, sourceSpan, targetMatchableAttrs, targetEvents);
          }
      };
      /**
       * @param {?} name
       * @param {?} expression
       * @param {?} sourceSpan
       * @param {?} targetEvents
       * @return {?}
       */
      BindingParser.prototype._parseAnimationEvent = function (name, expression, sourceSpan, targetEvents) {
          var /** @type {?} */ matches = splitAtPeriod(name, [name, '']);
          var /** @type {?} */ eventName = matches[0];
          var /** @type {?} */ phase = matches[1].toLowerCase();
          if (phase) {
              switch (phase) {
                  case 'start':
                  case 'done':
                      var /** @type {?} */ ast = this._parseAction(expression, sourceSpan);
                      targetEvents.push(new BoundEventAst(eventName, null, phase, ast, sourceSpan));
                      break;
                  default:
                      this._reportError("The provided animation output phase value \"" + phase + "\" for \"@" + eventName + "\" is not supported (use start or done)", sourceSpan);
                      break;
              }
          }
          else {
              this._reportError("The animation trigger output event (@" + eventName + ") is missing its phase value name (start or done are currently supported)", sourceSpan);
          }
      };
      /**
       * @param {?} name
       * @param {?} expression
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetEvents
       * @return {?}
       */
      BindingParser.prototype._parseEvent = function (name, expression, sourceSpan, targetMatchableAttrs, targetEvents) {
          // long format: 'target: eventName'
          var _a = splitAtColon(name, [null, name]), target = _a[0], eventName = _a[1];
          var /** @type {?} */ ast = this._parseAction(expression, sourceSpan);
          targetMatchableAttrs.push([name, ast.source]);
          targetEvents.push(new BoundEventAst(eventName, target, null, ast, sourceSpan));
          // Don't detect directives for event names for now,
          // so don't add the event name to the matchableAttrs
      };
      /**
       * @param {?} value
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype._parseAction = function (value, sourceSpan) {
          var /** @type {?} */ sourceInfo = sourceSpan.start.toString();
          try {
              var /** @type {?} */ ast = this._exprParser.parseAction(value, sourceInfo, this._interpolationConfig);
              if (ast) {
                  this._reportExpressionParserErrors(ast.errors, sourceSpan);
              }
              if (!ast || ast.ast instanceof EmptyExpr) {
                  this._reportError("Empty expressions are not allowed", sourceSpan);
                  return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
              }
              this._checkPipes(ast, sourceSpan);
              return ast;
          }
          catch (e) {
              this._reportError("" + e, sourceSpan);
              return this._exprParser.wrapLiteralPrimitive('ERROR', sourceInfo);
          }
      };
      /**
       * @param {?} message
       * @param {?} sourceSpan
       * @param {?=} level
       * @return {?}
       */
      BindingParser.prototype._reportError = function (message, sourceSpan, level) {
          if (level === void 0) { level = ParseErrorLevel.FATAL; }
          this._targetErrors.push(new ParseError(sourceSpan, message, level));
      };
      /**
       * @param {?} errors
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype._reportExpressionParserErrors = function (errors, sourceSpan) {
          for (var _i = 0, errors_1 = errors; _i < errors_1.length; _i++) {
              var error = errors_1[_i];
              this._reportError(error.message, sourceSpan);
          }
      };
      /**
       * @param {?} ast
       * @param {?} sourceSpan
       * @return {?}
       */
      BindingParser.prototype._checkPipes = function (ast, sourceSpan) {
          var _this = this;
          if (isPresent(ast)) {
              var /** @type {?} */ collector = new PipeCollector();
              ast.visit(collector);
              collector.pipes.forEach(function (pipeName) {
                  if (!_this.pipesByName.has(pipeName)) {
                      _this._reportError("The pipe '" + pipeName + "' could not be found", sourceSpan);
                  }
              });
          }
      };
      /**
       * @param {?} propName the name of the property / attribute
       * @param {?} sourceSpan
       * @param {?} isAttr true when binding to an attribute
       * @return {?}
       */
      BindingParser.prototype._validatePropertyOrAttributeName = function (propName, sourceSpan, isAttr) {
          var /** @type {?} */ report = isAttr ? this._schemaRegistry.validateAttribute(propName) :
              this._schemaRegistry.validateProperty(propName);
          if (report.error) {
              this._reportError(report.msg, sourceSpan, ParseErrorLevel.FATAL);
          }
      };
      return BindingParser;
  }());
  var PipeCollector = (function (_super) {
      __extends$12(PipeCollector, _super);
      function PipeCollector() {
          _super.apply(this, arguments);
          this.pipes = new Set();
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      PipeCollector.prototype.visitPipe = function (ast, context) {
          this.pipes.add(ast.name);
          ast.exp.visit(this);
          this.visitAll(ast.args, context);
          return null;
      };
      return PipeCollector;
  }(RecursiveAstVisitor));
  /**
   * @param {?} name
   * @return {?}
   */
  function _isAnimationLabel(name) {
      return name[0] == '@';
  }
  /**
   * @param {?} registry
   * @param {?} selector
   * @param {?} propName
   * @param {?} isAttribute
   * @return {?}
   */
  function calcPossibleSecurityContexts(registry, selector, propName, isAttribute) {
      var /** @type {?} */ ctxs = [];
      CssSelector.parse(selector).forEach(function (selector) {
          var /** @type {?} */ elementNames = selector.element ? [selector.element] : registry.allKnownElementNames();
          var /** @type {?} */ notElementNames = new Set(selector.notSelectors.filter(function (selector) { return selector.isElementSelector(); })
              .map(function (selector) { return selector.element; }));
          var /** @type {?} */ possibleElementNames = elementNames.filter(function (elementName) { return !notElementNames.has(elementName); });
          ctxs.push.apply(ctxs, possibleElementNames.map(function (elementName) { return registry.securityContext(elementName, propName, isAttribute); }));
      });
      return ctxs.length === 0 ? [_angular_core.SecurityContext.NONE] : Array.from(new Set(ctxs)).sort();
  }

  var /** @type {?} */ NG_CONTENT_SELECT_ATTR = 'select';
  var /** @type {?} */ NG_CONTENT_ELEMENT = 'ng-content';
  var /** @type {?} */ LINK_ELEMENT = 'link';
  var /** @type {?} */ LINK_STYLE_REL_ATTR = 'rel';
  var /** @type {?} */ LINK_STYLE_HREF_ATTR = 'href';
  var /** @type {?} */ LINK_STYLE_REL_VALUE = 'stylesheet';
  var /** @type {?} */ STYLE_ELEMENT = 'style';
  var /** @type {?} */ SCRIPT_ELEMENT = 'script';
  var /** @type {?} */ NG_NON_BINDABLE_ATTR = 'ngNonBindable';
  var /** @type {?} */ NG_PROJECT_AS = 'ngProjectAs';
  /**
   * @param {?} ast
   * @return {?}
   */
  function preparseElement(ast) {
      var /** @type {?} */ selectAttr = null;
      var /** @type {?} */ hrefAttr = null;
      var /** @type {?} */ relAttr = null;
      var /** @type {?} */ nonBindable = false;
      var /** @type {?} */ projectAs = null;
      ast.attrs.forEach(function (attr) {
          var /** @type {?} */ lcAttrName = attr.name.toLowerCase();
          if (lcAttrName == NG_CONTENT_SELECT_ATTR) {
              selectAttr = attr.value;
          }
          else if (lcAttrName == LINK_STYLE_HREF_ATTR) {
              hrefAttr = attr.value;
          }
          else if (lcAttrName == LINK_STYLE_REL_ATTR) {
              relAttr = attr.value;
          }
          else if (attr.name == NG_NON_BINDABLE_ATTR) {
              nonBindable = true;
          }
          else if (attr.name == NG_PROJECT_AS) {
              if (attr.value.length > 0) {
                  projectAs = attr.value;
              }
          }
      });
      selectAttr = normalizeNgContentSelect(selectAttr);
      var /** @type {?} */ nodeName = ast.name.toLowerCase();
      var /** @type {?} */ type = PreparsedElementType.OTHER;
      if (splitNsName(nodeName)[1] == NG_CONTENT_ELEMENT) {
          type = PreparsedElementType.NG_CONTENT;
      }
      else if (nodeName == STYLE_ELEMENT) {
          type = PreparsedElementType.STYLE;
      }
      else if (nodeName == SCRIPT_ELEMENT) {
          type = PreparsedElementType.SCRIPT;
      }
      else if (nodeName == LINK_ELEMENT && relAttr == LINK_STYLE_REL_VALUE) {
          type = PreparsedElementType.STYLESHEET;
      }
      return new PreparsedElement(type, selectAttr, hrefAttr, nonBindable, projectAs);
  }
  var PreparsedElementType = {};
  PreparsedElementType.NG_CONTENT = 0;
  PreparsedElementType.STYLE = 1;
  PreparsedElementType.STYLESHEET = 2;
  PreparsedElementType.SCRIPT = 3;
  PreparsedElementType.OTHER = 4;
  PreparsedElementType[PreparsedElementType.NG_CONTENT] = "NG_CONTENT";
  PreparsedElementType[PreparsedElementType.STYLE] = "STYLE";
  PreparsedElementType[PreparsedElementType.STYLESHEET] = "STYLESHEET";
  PreparsedElementType[PreparsedElementType.SCRIPT] = "SCRIPT";
  PreparsedElementType[PreparsedElementType.OTHER] = "OTHER";
  var PreparsedElement = (function () {
      /**
       * @param {?} type
       * @param {?} selectAttr
       * @param {?} hrefAttr
       * @param {?} nonBindable
       * @param {?} projectAs
       */
      function PreparsedElement(type, selectAttr, hrefAttr, nonBindable, projectAs) {
          this.type = type;
          this.selectAttr = selectAttr;
          this.hrefAttr = hrefAttr;
          this.nonBindable = nonBindable;
          this.projectAs = projectAs;
      }
      return PreparsedElement;
  }());
  /**
   * @param {?} selectAttr
   * @return {?}
   */
  function normalizeNgContentSelect(selectAttr) {
      if (selectAttr === null || selectAttr.length === 0) {
          return '*';
      }
      return selectAttr;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  // Group 1 = "bind-"
  // Group 2 = "let-"
  // Group 3 = "ref-/#"
  // Group 4 = "on-"
  // Group 5 = "bindon-"
  // Group 6 = "@"
  // Group 7 = the identifier after "bind-", "let-", "ref-/#", "on-", "bindon-" or "@"
  // Group 8 = identifier inside [()]
  // Group 9 = identifier inside []
  // Group 10 = identifier inside ()
  var /** @type {?} */ BIND_NAME_REGEXP = /^(?:(?:(?:(bind-)|(let-)|(ref-|#)|(on-)|(bindon-)|(@))(.+))|\[\(([^\)]+)\)\]|\[([^\]]+)\]|\(([^\)]+)\))$/;
  var /** @type {?} */ KW_BIND_IDX = 1;
  var /** @type {?} */ KW_LET_IDX = 2;
  var /** @type {?} */ KW_REF_IDX = 3;
  var /** @type {?} */ KW_ON_IDX = 4;
  var /** @type {?} */ KW_BINDON_IDX = 5;
  var /** @type {?} */ KW_AT_IDX = 6;
  var /** @type {?} */ IDENT_KW_IDX = 7;
  var /** @type {?} */ IDENT_BANANA_BOX_IDX = 8;
  var /** @type {?} */ IDENT_PROPERTY_IDX = 9;
  var /** @type {?} */ IDENT_EVENT_IDX = 10;
  var /** @type {?} */ TEMPLATE_ELEMENT = 'template';
  var /** @type {?} */ TEMPLATE_ATTR = 'template';
  var /** @type {?} */ TEMPLATE_ATTR_PREFIX = '*';
  var /** @type {?} */ CLASS_ATTR = 'class';
  var /** @type {?} */ TEXT_CSS_SELECTOR = CssSelector.parse('*')[0];
  /**
   * Provides an array of {@link TemplateAstVisitor}s which will be used to transform
   * parsed templates before compilation is invoked, allowing custom expression syntax
   * and other advanced transformations.
   *
   * This is currently an internal-only feature and not meant for general use.
   */
  var /** @type {?} */ TEMPLATE_TRANSFORMS = new _angular_core.OpaqueToken('TemplateTransforms');
  var TemplateParseError = (function (_super) {
      __extends(TemplateParseError, _super);
      /**
       * @param {?} message
       * @param {?} span
       * @param {?} level
       */
      function TemplateParseError(message, span, level) {
          _super.call(this, span, message, level);
      }
      return TemplateParseError;
  }(ParseError));
  var TemplateParseResult = (function () {
      /**
       * @param {?=} templateAst
       * @param {?=} errors
       */
      function TemplateParseResult(templateAst, errors) {
          this.templateAst = templateAst;
          this.errors = errors;
      }
      return TemplateParseResult;
  }());
  var TemplateParser = (function () {
      /**
       * @param {?} _exprParser
       * @param {?} _schemaRegistry
       * @param {?} _htmlParser
       * @param {?} _console
       * @param {?} transforms
       */
      function TemplateParser(_exprParser, _schemaRegistry, _htmlParser, _console, transforms) {
          this._exprParser = _exprParser;
          this._schemaRegistry = _schemaRegistry;
          this._htmlParser = _htmlParser;
          this._console = _console;
          this.transforms = transforms;
      }
      /**
       * @param {?} component
       * @param {?} template
       * @param {?} directives
       * @param {?} pipes
       * @param {?} schemas
       * @param {?} templateUrl
       * @return {?}
       */
      TemplateParser.prototype.parse = function (component, template, directives, pipes, schemas, templateUrl) {
          var /** @type {?} */ result = this.tryParse(component, template, directives, pipes, schemas, templateUrl);
          var /** @type {?} */ warnings = result.errors.filter(function (error) { return error.level === ParseErrorLevel.WARNING; });
          var /** @type {?} */ errors = result.errors.filter(function (error) { return error.level === ParseErrorLevel.FATAL; });
          if (warnings.length > 0) {
              this._console.warn("Template parse warnings:\n" + warnings.join('\n'));
          }
          if (errors.length > 0) {
              var /** @type {?} */ errorString = errors.join('\n');
              throw new Error("Template parse errors:\n" + errorString);
          }
          return result.templateAst;
      };
      /**
       * @param {?} component
       * @param {?} template
       * @param {?} directives
       * @param {?} pipes
       * @param {?} schemas
       * @param {?} templateUrl
       * @return {?}
       */
      TemplateParser.prototype.tryParse = function (component, template, directives, pipes, schemas, templateUrl) {
          return this.tryParseHtml(this.expandHtml(this._htmlParser.parse(template, templateUrl, true, this.getInterpolationConfig(component))), component, template, directives, pipes, schemas, templateUrl);
      };
      /**
       * @param {?} htmlAstWithErrors
       * @param {?} component
       * @param {?} template
       * @param {?} directives
       * @param {?} pipes
       * @param {?} schemas
       * @param {?} templateUrl
       * @return {?}
       */
      TemplateParser.prototype.tryParseHtml = function (htmlAstWithErrors, component, template, directives, pipes, schemas, templateUrl) {
          var /** @type {?} */ result;
          var /** @type {?} */ errors = htmlAstWithErrors.errors;
          if (htmlAstWithErrors.rootNodes.length > 0) {
              var /** @type {?} */ uniqDirectives = removeSummaryDuplicates(directives);
              var /** @type {?} */ uniqPipes = removeSummaryDuplicates(pipes);
              var /** @type {?} */ providerViewContext = new ProviderViewContext(component, htmlAstWithErrors.rootNodes[0].sourceSpan);
              var /** @type {?} */ interpolationConfig = void 0;
              if (component.template && component.template.interpolation) {
                  interpolationConfig = {
                      start: component.template.interpolation[0],
                      end: component.template.interpolation[1]
                  };
              }
              var /** @type {?} */ bindingParser = new BindingParser(this._exprParser, interpolationConfig, this._schemaRegistry, uniqPipes, errors);
              var /** @type {?} */ parseVisitor = new TemplateParseVisitor(providerViewContext, uniqDirectives, bindingParser, this._schemaRegistry, schemas, errors);
              result = visitAll(parseVisitor, htmlAstWithErrors.rootNodes, EMPTY_ELEMENT_CONTEXT);
              errors.push.apply(errors, providerViewContext.errors);
          }
          else {
              result = [];
          }
          this._assertNoReferenceDuplicationOnTemplate(result, errors);
          if (errors.length > 0) {
              return new TemplateParseResult(result, errors);
          }
          if (isPresent(this.transforms)) {
              this.transforms.forEach(function (transform) { result = templateVisitAll(transform, result); });
          }
          return new TemplateParseResult(result, errors);
      };
      /**
       * @param {?} htmlAstWithErrors
       * @param {?=} forced
       * @return {?}
       */
      TemplateParser.prototype.expandHtml = function (htmlAstWithErrors, forced) {
          if (forced === void 0) { forced = false; }
          var /** @type {?} */ errors = htmlAstWithErrors.errors;
          if (errors.length == 0 || forced) {
              // Transform ICU messages to angular directives
              var /** @type {?} */ expandedHtmlAst = expandNodes(htmlAstWithErrors.rootNodes);
              errors.push.apply(errors, expandedHtmlAst.errors);
              htmlAstWithErrors = new ParseTreeResult(expandedHtmlAst.nodes, errors);
          }
          return htmlAstWithErrors;
      };
      /**
       * @param {?} component
       * @return {?}
       */
      TemplateParser.prototype.getInterpolationConfig = function (component) {
          if (component.template) {
              return InterpolationConfig.fromArray(component.template.interpolation);
          }
      };
      /**
       * @param {?} result
       * @param {?} errors
       * @return {?}
       */
      TemplateParser.prototype._assertNoReferenceDuplicationOnTemplate = function (result, errors) {
          var /** @type {?} */ existingReferences = [];
          result.filter(function (element) { return !!((element)).references; })
              .forEach(function (element) { return ((element)).references.forEach(function (reference) {
              var /** @type {?} */ name = reference.name;
              if (existingReferences.indexOf(name) < 0) {
                  existingReferences.push(name);
              }
              else {
                  var /** @type {?} */ error = new TemplateParseError("Reference \"#" + name + "\" is defined several times", reference.sourceSpan, ParseErrorLevel.FATAL);
                  errors.push(error);
              }
          }); });
      };
      TemplateParser.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      TemplateParser.ctorParameters = function () { return [
          { type: Parser, },
          { type: ElementSchemaRegistry, },
          { type: I18NHtmlParser, },
          { type: Console, },
          { type: Array, decorators: [{ type: _angular_core.Optional }, { type: _angular_core.Inject, args: [TEMPLATE_TRANSFORMS,] },] },
      ]; };
      return TemplateParser;
  }());
  var TemplateParseVisitor = (function () {
      /**
       * @param {?} providerViewContext
       * @param {?} directives
       * @param {?} _bindingParser
       * @param {?} _schemaRegistry
       * @param {?} _schemas
       * @param {?} _targetErrors
       */
      function TemplateParseVisitor(providerViewContext, directives, _bindingParser, _schemaRegistry, _schemas, _targetErrors) {
          var _this = this;
          this.providerViewContext = providerViewContext;
          this._bindingParser = _bindingParser;
          this._schemaRegistry = _schemaRegistry;
          this._schemas = _schemas;
          this._targetErrors = _targetErrors;
          this.selectorMatcher = new SelectorMatcher();
          this.directivesIndex = new Map();
          this.ngContentCount = 0;
          directives.forEach(function (directive, index) {
              var selector = CssSelector.parse(directive.selector);
              _this.selectorMatcher.addSelectables(selector, directive);
              _this.directivesIndex.set(directive, index);
          });
      }
      /**
       * @param {?} expansion
       * @param {?} context
       * @return {?}
       */
      TemplateParseVisitor.prototype.visitExpansion = function (expansion, context) { return null; };
      /**
       * @param {?} expansionCase
       * @param {?} context
       * @return {?}
       */
      TemplateParseVisitor.prototype.visitExpansionCase = function (expansionCase, context) { return null; };
      /**
       * @param {?} text
       * @param {?} parent
       * @return {?}
       */
      TemplateParseVisitor.prototype.visitText = function (text, parent) {
          var /** @type {?} */ ngContentIndex = parent.findNgContentIndex(TEXT_CSS_SELECTOR);
          var /** @type {?} */ expr = this._bindingParser.parseInterpolation(text.value, text.sourceSpan);
          if (isPresent(expr)) {
              return new BoundTextAst(expr, ngContentIndex, text.sourceSpan);
          }
          else {
              return new TextAst(text.value, ngContentIndex, text.sourceSpan);
          }
      };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      TemplateParseVisitor.prototype.visitAttribute = function (attribute, context) {
          return new AttrAst(attribute.name, attribute.value, attribute.sourceSpan);
      };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      TemplateParseVisitor.prototype.visitComment = function (comment, context) { return null; };
      /**
       * @param {?} element
       * @param {?} parent
       * @return {?}
       */
      TemplateParseVisitor.prototype.visitElement = function (element, parent) {
          var _this = this;
          var /** @type {?} */ nodeName = element.name;
          var /** @type {?} */ preparsedElement = preparseElement(element);
          if (preparsedElement.type === PreparsedElementType.SCRIPT ||
              preparsedElement.type === PreparsedElementType.STYLE) {
              // Skipping <script> for security reasons
              // Skipping <style> as we already processed them
              // in the StyleCompiler
              return null;
          }
          if (preparsedElement.type === PreparsedElementType.STYLESHEET &&
              isStyleUrlResolvable(preparsedElement.hrefAttr)) {
              // Skipping stylesheets with either relative urls or package scheme as we already processed
              // them in the StyleCompiler
              return null;
          }
          var /** @type {?} */ matchableAttrs = [];
          var /** @type {?} */ elementOrDirectiveProps = [];
          var /** @type {?} */ elementOrDirectiveRefs = [];
          var /** @type {?} */ elementVars = [];
          var /** @type {?} */ events = [];
          var /** @type {?} */ templateElementOrDirectiveProps = [];
          var /** @type {?} */ templateMatchableAttrs = [];
          var /** @type {?} */ templateElementVars = [];
          var /** @type {?} */ hasInlineTemplates = false;
          var /** @type {?} */ attrs = [];
          var /** @type {?} */ lcElName = splitNsName(nodeName.toLowerCase())[1];
          var /** @type {?} */ isTemplateElement = lcElName == TEMPLATE_ELEMENT;
          element.attrs.forEach(function (attr) {
              var /** @type {?} */ hasBinding = _this._parseAttr(isTemplateElement, attr, matchableAttrs, elementOrDirectiveProps, events, elementOrDirectiveRefs, elementVars);
              var /** @type {?} */ templateBindingsSource = undefined;
              var /** @type {?} */ prefixToken = undefined;
              if (_this._normalizeAttributeName(attr.name) == TEMPLATE_ATTR) {
                  templateBindingsSource = attr.value;
              }
              else if (attr.name.startsWith(TEMPLATE_ATTR_PREFIX)) {
                  templateBindingsSource = attr.value;
                  prefixToken = attr.name.substring(TEMPLATE_ATTR_PREFIX.length); // remove the star
              }
              var /** @type {?} */ hasTemplateBinding = isPresent(templateBindingsSource);
              if (hasTemplateBinding) {
                  if (hasInlineTemplates) {
                      _this._reportError("Can't have multiple template bindings on one element. Use only one attribute named 'template' or prefixed with *", attr.sourceSpan);
                  }
                  hasInlineTemplates = true;
                  _this._bindingParser.parseInlineTemplateBinding(attr.name, prefixToken, templateBindingsSource, attr.sourceSpan, templateMatchableAttrs, templateElementOrDirectiveProps, templateElementVars);
              }
              if (!hasBinding && !hasTemplateBinding) {
                  // don't include the bindings as attributes as well in the AST
                  attrs.push(_this.visitAttribute(attr, null));
                  matchableAttrs.push([attr.name, attr.value]);
              }
          });
          var /** @type {?} */ elementCssSelector = createElementCssSelector(nodeName, matchableAttrs);
          var _a = this._parseDirectives(this.selectorMatcher, elementCssSelector), directiveMetas = _a.directives, matchElement = _a.matchElement;
          var /** @type {?} */ references = [];
          var /** @type {?} */ directiveAsts = this._createDirectiveAsts(isTemplateElement, element.name, directiveMetas, elementOrDirectiveProps, elementOrDirectiveRefs, element.sourceSpan, references);
          var /** @type {?} */ elementProps = this._createElementPropertyAsts(element.name, elementOrDirectiveProps, directiveAsts);
          var /** @type {?} */ isViewRoot = parent.isTemplateElement || hasInlineTemplates;
          var /** @type {?} */ providerContext = new ProviderElementContext(this.providerViewContext, parent.providerContext, isViewRoot, directiveAsts, attrs, references, element.sourceSpan);
          var /** @type {?} */ children = visitAll(preparsedElement.nonBindable ? NON_BINDABLE_VISITOR : this, element.children, ElementContext.create(isTemplateElement, directiveAsts, isTemplateElement ? parent.providerContext : providerContext));
          providerContext.afterElement();
          // Override the actual selector when the `ngProjectAs` attribute is provided
          var /** @type {?} */ projectionSelector = isPresent(preparsedElement.projectAs) ?
              CssSelector.parse(preparsedElement.projectAs)[0] :
              elementCssSelector;
          var /** @type {?} */ ngContentIndex = parent.findNgContentIndex(projectionSelector);
          var /** @type {?} */ parsedElement;
          if (preparsedElement.type === PreparsedElementType.NG_CONTENT) {
              if (element.children && !element.children.every(_isEmptyTextNode)) {
                  this._reportError("<ng-content> element cannot have content.", element.sourceSpan);
              }
              parsedElement = new NgContentAst(this.ngContentCount++, hasInlineTemplates ? null : ngContentIndex, element.sourceSpan);
          }
          else if (isTemplateElement) {
              this._assertAllEventsPublishedByDirectives(directiveAsts, events);
              this._assertNoComponentsNorElementBindingsOnTemplate(directiveAsts, elementProps, element.sourceSpan);
              parsedElement = new EmbeddedTemplateAst(attrs, events, references, elementVars, providerContext.transformedDirectiveAsts, providerContext.transformProviders, providerContext.transformedHasViewContainer, children, hasInlineTemplates ? null : ngContentIndex, element.sourceSpan);
          }
          else {
              this._assertElementExists(matchElement, element);
              this._assertOnlyOneComponent(directiveAsts, element.sourceSpan);
              var /** @type {?} */ ngContentIndex_1 = hasInlineTemplates ? null : parent.findNgContentIndex(projectionSelector);
              parsedElement = new ElementAst(nodeName, attrs, elementProps, events, references, providerContext.transformedDirectiveAsts, providerContext.transformProviders, providerContext.transformedHasViewContainer, children, hasInlineTemplates ? null : ngContentIndex_1, element.sourceSpan, element.endSourceSpan);
              this._findComponentDirectives(directiveAsts)
                  .forEach(function (componentDirectiveAst) { return _this._validateElementAnimationInputOutputs(componentDirectiveAst.hostProperties, componentDirectiveAst.hostEvents, componentDirectiveAst.directive.template); });
              var /** @type {?} */ componentTemplate = providerContext.viewContext.component.template;
              this._validateElementAnimationInputOutputs(elementProps, events, componentTemplate.toSummary());
          }
          if (hasInlineTemplates) {
              var /** @type {?} */ templateCssSelector = createElementCssSelector(TEMPLATE_ELEMENT, templateMatchableAttrs);
              var templateDirectiveMetas = this._parseDirectives(this.selectorMatcher, templateCssSelector).directives;
              var /** @type {?} */ templateDirectiveAsts = this._createDirectiveAsts(true, element.name, templateDirectiveMetas, templateElementOrDirectiveProps, [], element.sourceSpan, []);
              var /** @type {?} */ templateElementProps = this._createElementPropertyAsts(element.name, templateElementOrDirectiveProps, templateDirectiveAsts);
              this._assertNoComponentsNorElementBindingsOnTemplate(templateDirectiveAsts, templateElementProps, element.sourceSpan);
              var /** @type {?} */ templateProviderContext = new ProviderElementContext(this.providerViewContext, parent.providerContext, parent.isTemplateElement, templateDirectiveAsts, [], [], element.sourceSpan);
              templateProviderContext.afterElement();
              parsedElement = new EmbeddedTemplateAst([], [], [], templateElementVars, templateProviderContext.transformedDirectiveAsts, templateProviderContext.transformProviders, templateProviderContext.transformedHasViewContainer, [parsedElement], ngContentIndex, element.sourceSpan);
          }
          return parsedElement;
      };
      /**
       * @param {?} inputs
       * @param {?} outputs
       * @param {?} template
       * @return {?}
       */
      TemplateParseVisitor.prototype._validateElementAnimationInputOutputs = function (inputs, outputs, template) {
          var _this = this;
          var /** @type {?} */ triggerLookup = new Set();
          template.animations.forEach(function (entry) { triggerLookup.add(entry); });
          var /** @type {?} */ animationInputs = inputs.filter(function (input) { return input.isAnimation; });
          animationInputs.forEach(function (input) {
              var /** @type {?} */ name = input.name;
              if (!triggerLookup.has(name)) {
                  _this._reportError("Couldn't find an animation entry for \"" + name + "\"", input.sourceSpan);
              }
          });
          outputs.forEach(function (output) {
              if (output.isAnimation) {
                  var /** @type {?} */ found = animationInputs.find(function (input) { return input.name == output.name; });
                  if (!found) {
                      _this._reportError("Unable to listen on (@" + output.name + "." + output.phase + ") because the animation trigger [@" + output.name + "] isn't being used on the same element", output.sourceSpan);
                  }
              }
          });
      };
      /**
       * @param {?} isTemplateElement
       * @param {?} attr
       * @param {?} targetMatchableAttrs
       * @param {?} targetProps
       * @param {?} targetEvents
       * @param {?} targetRefs
       * @param {?} targetVars
       * @return {?}
       */
      TemplateParseVisitor.prototype._parseAttr = function (isTemplateElement, attr, targetMatchableAttrs, targetProps, targetEvents, targetRefs, targetVars) {
          var /** @type {?} */ name = this._normalizeAttributeName(attr.name);
          var /** @type {?} */ value = attr.value;
          var /** @type {?} */ srcSpan = attr.sourceSpan;
          var /** @type {?} */ bindParts = name.match(BIND_NAME_REGEXP);
          var /** @type {?} */ hasBinding = false;
          if (bindParts !== null) {
              hasBinding = true;
              if (isPresent(bindParts[KW_BIND_IDX])) {
                  this._bindingParser.parsePropertyBinding(bindParts[IDENT_KW_IDX], value, false, srcSpan, targetMatchableAttrs, targetProps);
              }
              else if (bindParts[KW_LET_IDX]) {
                  if (isTemplateElement) {
                      var /** @type {?} */ identifier = bindParts[IDENT_KW_IDX];
                      this._parseVariable(identifier, value, srcSpan, targetVars);
                  }
                  else {
                      this._reportError("\"let-\" is only supported on template elements.", srcSpan);
                  }
              }
              else if (bindParts[KW_REF_IDX]) {
                  var /** @type {?} */ identifier = bindParts[IDENT_KW_IDX];
                  this._parseReference(identifier, value, srcSpan, targetRefs);
              }
              else if (bindParts[KW_ON_IDX]) {
                  this._bindingParser.parseEvent(bindParts[IDENT_KW_IDX], value, srcSpan, targetMatchableAttrs, targetEvents);
              }
              else if (bindParts[KW_BINDON_IDX]) {
                  this._bindingParser.parsePropertyBinding(bindParts[IDENT_KW_IDX], value, false, srcSpan, targetMatchableAttrs, targetProps);
                  this._parseAssignmentEvent(bindParts[IDENT_KW_IDX], value, srcSpan, targetMatchableAttrs, targetEvents);
              }
              else if (bindParts[KW_AT_IDX]) {
                  this._bindingParser.parseLiteralAttr(name, value, srcSpan, targetMatchableAttrs, targetProps);
              }
              else if (bindParts[IDENT_BANANA_BOX_IDX]) {
                  this._bindingParser.parsePropertyBinding(bindParts[IDENT_BANANA_BOX_IDX], value, false, srcSpan, targetMatchableAttrs, targetProps);
                  this._parseAssignmentEvent(bindParts[IDENT_BANANA_BOX_IDX], value, srcSpan, targetMatchableAttrs, targetEvents);
              }
              else if (bindParts[IDENT_PROPERTY_IDX]) {
                  this._bindingParser.parsePropertyBinding(bindParts[IDENT_PROPERTY_IDX], value, false, srcSpan, targetMatchableAttrs, targetProps);
              }
              else if (bindParts[IDENT_EVENT_IDX]) {
                  this._bindingParser.parseEvent(bindParts[IDENT_EVENT_IDX], value, srcSpan, targetMatchableAttrs, targetEvents);
              }
          }
          else {
              hasBinding = this._bindingParser.parsePropertyInterpolation(name, value, srcSpan, targetMatchableAttrs, targetProps);
          }
          if (!hasBinding) {
              this._bindingParser.parseLiteralAttr(name, value, srcSpan, targetMatchableAttrs, targetProps);
          }
          return hasBinding;
      };
      /**
       * @param {?} attrName
       * @return {?}
       */
      TemplateParseVisitor.prototype._normalizeAttributeName = function (attrName) {
          return /^data-/i.test(attrName) ? attrName.substring(5) : attrName;
      };
      /**
       * @param {?} identifier
       * @param {?} value
       * @param {?} sourceSpan
       * @param {?} targetVars
       * @return {?}
       */
      TemplateParseVisitor.prototype._parseVariable = function (identifier, value, sourceSpan, targetVars) {
          if (identifier.indexOf('-') > -1) {
              this._reportError("\"-\" is not allowed in variable names", sourceSpan);
          }
          targetVars.push(new VariableAst(identifier, value, sourceSpan));
      };
      /**
       * @param {?} identifier
       * @param {?} value
       * @param {?} sourceSpan
       * @param {?} targetRefs
       * @return {?}
       */
      TemplateParseVisitor.prototype._parseReference = function (identifier, value, sourceSpan, targetRefs) {
          if (identifier.indexOf('-') > -1) {
              this._reportError("\"-\" is not allowed in reference names", sourceSpan);
          }
          targetRefs.push(new ElementOrDirectiveRef(identifier, value, sourceSpan));
      };
      /**
       * @param {?} name
       * @param {?} expression
       * @param {?} sourceSpan
       * @param {?} targetMatchableAttrs
       * @param {?} targetEvents
       * @return {?}
       */
      TemplateParseVisitor.prototype._parseAssignmentEvent = function (name, expression, sourceSpan, targetMatchableAttrs, targetEvents) {
          this._bindingParser.parseEvent(name + "Change", expression + "=$event", sourceSpan, targetMatchableAttrs, targetEvents);
      };
      /**
       * @param {?} selectorMatcher
       * @param {?} elementCssSelector
       * @return {?}
       */
      TemplateParseVisitor.prototype._parseDirectives = function (selectorMatcher, elementCssSelector) {
          var _this = this;
          // Need to sort the directives so that we get consistent results throughout,
          // as selectorMatcher uses Maps inside.
          // Also deduplicate directives as they might match more than one time!
          var /** @type {?} */ directives = new Array(this.directivesIndex.size);
          // Whether any directive selector matches on the element name
          var /** @type {?} */ matchElement = false;
          selectorMatcher.match(elementCssSelector, function (selector, directive) {
              directives[_this.directivesIndex.get(directive)] = directive;
              matchElement = matchElement || selector.hasElementSelector();
          });
          return {
              directives: directives.filter(function (dir) { return !!dir; }),
              matchElement: matchElement,
          };
      };
      /**
       * @param {?} isTemplateElement
       * @param {?} elementName
       * @param {?} directives
       * @param {?} props
       * @param {?} elementOrDirectiveRefs
       * @param {?} elementSourceSpan
       * @param {?} targetReferences
       * @return {?}
       */
      TemplateParseVisitor.prototype._createDirectiveAsts = function (isTemplateElement, elementName, directives, props, elementOrDirectiveRefs, elementSourceSpan, targetReferences) {
          var _this = this;
          var /** @type {?} */ matchedReferences = new Set();
          var /** @type {?} */ component = null;
          var /** @type {?} */ directiveAsts = directives.map(function (directive) {
              var /** @type {?} */ sourceSpan = new ParseSourceSpan(elementSourceSpan.start, elementSourceSpan.end, "Directive " + directive.type.name);
              if (directive.isComponent) {
                  component = directive;
              }
              var /** @type {?} */ directiveProperties = [];
              var /** @type {?} */ hostProperties = _this._bindingParser.createDirectiveHostPropertyAsts(directive, sourceSpan);
              // Note: We need to check the host properties here as well,
              // as we don't know the element name in the DirectiveWrapperCompiler yet.
              _this._checkPropertiesInSchema(elementName, hostProperties);
              var /** @type {?} */ hostEvents = _this._bindingParser.createDirectiveHostEventAsts(directive, sourceSpan);
              _this._createDirectivePropertyAsts(directive.inputs, props, directiveProperties);
              elementOrDirectiveRefs.forEach(function (elOrDirRef) {
                  if ((elOrDirRef.value.length === 0 && directive.isComponent) ||
                      (directive.exportAs == elOrDirRef.value)) {
                      targetReferences.push(new ReferenceAst(elOrDirRef.name, identifierToken(directive.type), elOrDirRef.sourceSpan));
                      matchedReferences.add(elOrDirRef.name);
                  }
              });
              return new DirectiveAst(directive, directiveProperties, hostProperties, hostEvents, sourceSpan);
          });
          elementOrDirectiveRefs.forEach(function (elOrDirRef) {
              if (elOrDirRef.value.length > 0) {
                  if (!matchedReferences.has(elOrDirRef.name)) {
                      _this._reportError("There is no directive with \"exportAs\" set to \"" + elOrDirRef.value + "\"", elOrDirRef.sourceSpan);
                  }
              }
              else if (!component) {
                  var /** @type {?} */ refToken = null;
                  if (isTemplateElement) {
                      refToken = resolveIdentifierToken(Identifiers.TemplateRef);
                  }
                  targetReferences.push(new ReferenceAst(elOrDirRef.name, refToken, elOrDirRef.sourceSpan));
              }
          }); // fix syntax highlighting issue: `
          return directiveAsts;
      };
      /**
       * @param {?} directiveProperties
       * @param {?} boundProps
       * @param {?} targetBoundDirectiveProps
       * @return {?}
       */
      TemplateParseVisitor.prototype._createDirectivePropertyAsts = function (directiveProperties, boundProps, targetBoundDirectiveProps) {
          if (directiveProperties) {
              var /** @type {?} */ boundPropsByName_1 = new Map();
              boundProps.forEach(function (boundProp) {
                  var /** @type {?} */ prevValue = boundPropsByName_1.get(boundProp.name);
                  if (!prevValue || prevValue.isLiteral) {
                      // give [a]="b" a higher precedence than a="b" on the same element
                      boundPropsByName_1.set(boundProp.name, boundProp);
                  }
              });
              Object.keys(directiveProperties).forEach(function (dirProp) {
                  var /** @type {?} */ elProp = directiveProperties[dirProp];
                  var /** @type {?} */ boundProp = boundPropsByName_1.get(elProp);
                  // Bindings are optional, so this binding only needs to be set up if an expression is given.
                  if (boundProp) {
                      targetBoundDirectiveProps.push(new BoundDirectivePropertyAst(dirProp, boundProp.name, boundProp.expression, boundProp.sourceSpan));
                  }
              });
          }
      };
      /**
       * @param {?} elementName
       * @param {?} props
       * @param {?} directives
       * @return {?}
       */
      TemplateParseVisitor.prototype._createElementPropertyAsts = function (elementName, props, directives) {
          var _this = this;
          var /** @type {?} */ boundElementProps = [];
          var /** @type {?} */ boundDirectivePropsIndex = new Map();
          directives.forEach(function (directive) {
              directive.inputs.forEach(function (prop) {
                  boundDirectivePropsIndex.set(prop.templateName, prop);
              });
          });
          props.forEach(function (prop) {
              if (!prop.isLiteral && !boundDirectivePropsIndex.get(prop.name)) {
                  boundElementProps.push(_this._bindingParser.createElementPropertyAst(elementName, prop));
              }
          });
          this._checkPropertiesInSchema(elementName, boundElementProps);
          return boundElementProps;
      };
      /**
       * @param {?} directives
       * @return {?}
       */
      TemplateParseVisitor.prototype._findComponentDirectives = function (directives) {
          return directives.filter(function (directive) { return directive.directive.isComponent; });
      };
      /**
       * @param {?} directives
       * @return {?}
       */
      TemplateParseVisitor.prototype._findComponentDirectiveNames = function (directives) {
          return this._findComponentDirectives(directives)
              .map(function (directive) { return directive.directive.type.name; });
      };
      /**
       * @param {?} directives
       * @param {?} sourceSpan
       * @return {?}
       */
      TemplateParseVisitor.prototype._assertOnlyOneComponent = function (directives, sourceSpan) {
          var /** @type {?} */ componentTypeNames = this._findComponentDirectiveNames(directives);
          if (componentTypeNames.length > 1) {
              this._reportError("More than one component matched on this element.\n" +
                  "Make sure that only one component's selector can match a given element.\n" +
                  ("Conflicting components: " + componentTypeNames.join(',')), sourceSpan);
          }
      };
      /**
       *  Make sure that non-angular tags conform to the schemas.
        * *
        * Note: An element is considered an angular tag when at least one directive selector matches the
        * tag name.
        * *
       * @param {?} matchElement Whether any directive has matched on the tag name
       * @param {?} element the html element
       * @return {?}
       */
      TemplateParseVisitor.prototype._assertElementExists = function (matchElement, element) {
          var /** @type {?} */ elName = element.name.replace(/^:xhtml:/, '');
          if (!matchElement && !this._schemaRegistry.hasElement(elName, this._schemas)) {
              var /** @type {?} */ errorMsg = ("'" + elName + "' is not a known element:\n") +
                  ("1. If '" + elName + "' is an Angular component, then verify that it is part of this module.\n") +
                  ("2. If '" + elName + "' is a Web Component then add \"CUSTOM_ELEMENTS_SCHEMA\" to the '@NgModule.schemas' of this component to suppress this message.");
              this._reportError(errorMsg, element.sourceSpan);
          }
      };
      /**
       * @param {?} directives
       * @param {?} elementProps
       * @param {?} sourceSpan
       * @return {?}
       */
      TemplateParseVisitor.prototype._assertNoComponentsNorElementBindingsOnTemplate = function (directives, elementProps, sourceSpan) {
          var _this = this;
          var /** @type {?} */ componentTypeNames = this._findComponentDirectiveNames(directives);
          if (componentTypeNames.length > 0) {
              this._reportError("Components on an embedded template: " + componentTypeNames.join(','), sourceSpan);
          }
          elementProps.forEach(function (prop) {
              _this._reportError("Property binding " + prop.name + " not used by any directive on an embedded template. Make sure that the property name is spelled correctly and all directives are listed in the \"directives\" section.", sourceSpan);
          });
      };
      /**
       * @param {?} directives
       * @param {?} events
       * @return {?}
       */
      TemplateParseVisitor.prototype._assertAllEventsPublishedByDirectives = function (directives, events) {
          var _this = this;
          var /** @type {?} */ allDirectiveEvents = new Set();
          directives.forEach(function (directive) {
              Object.keys(directive.directive.outputs).forEach(function (k) {
                  var /** @type {?} */ eventName = directive.directive.outputs[k];
                  allDirectiveEvents.add(eventName);
              });
          });
          events.forEach(function (event) {
              if (isPresent(event.target) || !allDirectiveEvents.has(event.name)) {
                  _this._reportError("Event binding " + event.fullName + " not emitted by any directive on an embedded template. Make sure that the event name is spelled correctly and all directives are listed in the \"directives\" section.", event.sourceSpan);
              }
          });
      };
      /**
       * @param {?} elementName
       * @param {?} boundProps
       * @return {?}
       */
      TemplateParseVisitor.prototype._checkPropertiesInSchema = function (elementName, boundProps) {
          var _this = this;
          boundProps.forEach(function (boundProp) {
              if (boundProp.type === PropertyBindingType.Property &&
                  !_this._schemaRegistry.hasProperty(elementName, boundProp.name, _this._schemas)) {
                  var /** @type {?} */ errorMsg = "Can't bind to '" + boundProp.name + "' since it isn't a known property of '" + elementName + "'.";
                  if (elementName.indexOf('-') > -1) {
                      errorMsg +=
                          ("\n1. If '" + elementName + "' is an Angular component and it has '" + boundProp.name + "' input, then verify that it is part of this module.") +
                              ("\n2. If '" + elementName + "' is a Web Component then add \"CUSTOM_ELEMENTS_SCHEMA\" to the '@NgModule.schemas' of this component to suppress this message.\n");
                  }
                  _this._reportError(errorMsg, boundProp.sourceSpan);
              }
          });
      };
      /**
       * @param {?} message
       * @param {?} sourceSpan
       * @param {?=} level
       * @return {?}
       */
      TemplateParseVisitor.prototype._reportError = function (message, sourceSpan, level) {
          if (level === void 0) { level = ParseErrorLevel.FATAL; }
          this._targetErrors.push(new ParseError(sourceSpan, message, level));
      };
      return TemplateParseVisitor;
  }());
  var NonBindableVisitor = (function () {
      function NonBindableVisitor() {
      }
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      NonBindableVisitor.prototype.visitElement = function (ast, parent) {
          var /** @type {?} */ preparsedElement = preparseElement(ast);
          if (preparsedElement.type === PreparsedElementType.SCRIPT ||
              preparsedElement.type === PreparsedElementType.STYLE ||
              preparsedElement.type === PreparsedElementType.STYLESHEET) {
              // Skipping <script> for security reasons
              // Skipping <style> and stylesheets as we already processed them
              // in the StyleCompiler
              return null;
          }
          var /** @type {?} */ attrNameAndValues = ast.attrs.map(function (attrAst) { return [attrAst.name, attrAst.value]; });
          var /** @type {?} */ selector = createElementCssSelector(ast.name, attrNameAndValues);
          var /** @type {?} */ ngContentIndex = parent.findNgContentIndex(selector);
          var /** @type {?} */ children = visitAll(this, ast.children, EMPTY_ELEMENT_CONTEXT);
          return new ElementAst(ast.name, visitAll(this, ast.attrs), [], [], [], [], [], false, children, ngContentIndex, ast.sourceSpan, ast.endSourceSpan);
      };
      /**
       * @param {?} comment
       * @param {?} context
       * @return {?}
       */
      NonBindableVisitor.prototype.visitComment = function (comment, context) { return null; };
      /**
       * @param {?} attribute
       * @param {?} context
       * @return {?}
       */
      NonBindableVisitor.prototype.visitAttribute = function (attribute, context) {
          return new AttrAst(attribute.name, attribute.value, attribute.sourceSpan);
      };
      /**
       * @param {?} text
       * @param {?} parent
       * @return {?}
       */
      NonBindableVisitor.prototype.visitText = function (text, parent) {
          var /** @type {?} */ ngContentIndex = parent.findNgContentIndex(TEXT_CSS_SELECTOR);
          return new TextAst(text.value, ngContentIndex, text.sourceSpan);
      };
      /**
       * @param {?} expansion
       * @param {?} context
       * @return {?}
       */
      NonBindableVisitor.prototype.visitExpansion = function (expansion, context) { return expansion; };
      /**
       * @param {?} expansionCase
       * @param {?} context
       * @return {?}
       */
      NonBindableVisitor.prototype.visitExpansionCase = function (expansionCase, context) { return expansionCase; };
      return NonBindableVisitor;
  }());
  var ElementOrDirectiveRef = (function () {
      /**
       * @param {?} name
       * @param {?} value
       * @param {?} sourceSpan
       */
      function ElementOrDirectiveRef(name, value, sourceSpan) {
          this.name = name;
          this.value = value;
          this.sourceSpan = sourceSpan;
      }
      return ElementOrDirectiveRef;
  }());
  /**
   * @param {?} classAttrValue
   * @return {?}
   */
  function splitClasses(classAttrValue) {
      return classAttrValue.trim().split(/\s+/g);
  }
  var ElementContext = (function () {
      /**
       * @param {?} isTemplateElement
       * @param {?} _ngContentIndexMatcher
       * @param {?} _wildcardNgContentIndex
       * @param {?} providerContext
       */
      function ElementContext(isTemplateElement, _ngContentIndexMatcher, _wildcardNgContentIndex, providerContext) {
          this.isTemplateElement = isTemplateElement;
          this._ngContentIndexMatcher = _ngContentIndexMatcher;
          this._wildcardNgContentIndex = _wildcardNgContentIndex;
          this.providerContext = providerContext;
      }
      /**
       * @param {?} isTemplateElement
       * @param {?} directives
       * @param {?} providerContext
       * @return {?}
       */
      ElementContext.create = function (isTemplateElement, directives, providerContext) {
          var /** @type {?} */ matcher = new SelectorMatcher();
          var /** @type {?} */ wildcardNgContentIndex = null;
          var /** @type {?} */ component = directives.find(function (directive) { return directive.directive.isComponent; });
          if (component) {
              var /** @type {?} */ ngContentSelectors = component.directive.template.ngContentSelectors;
              for (var /** @type {?} */ i = 0; i < ngContentSelectors.length; i++) {
                  var /** @type {?} */ selector = ngContentSelectors[i];
                  if (selector === '*') {
                      wildcardNgContentIndex = i;
                  }
                  else {
                      matcher.addSelectables(CssSelector.parse(ngContentSelectors[i]), i);
                  }
              }
          }
          return new ElementContext(isTemplateElement, matcher, wildcardNgContentIndex, providerContext);
      };
      /**
       * @param {?} selector
       * @return {?}
       */
      ElementContext.prototype.findNgContentIndex = function (selector) {
          var /** @type {?} */ ngContentIndices = [];
          this._ngContentIndexMatcher.match(selector, function (selector, ngContentIndex) { ngContentIndices.push(ngContentIndex); });
          ngContentIndices.sort();
          if (isPresent(this._wildcardNgContentIndex)) {
              ngContentIndices.push(this._wildcardNgContentIndex);
          }
          return ngContentIndices.length > 0 ? ngContentIndices[0] : null;
      };
      return ElementContext;
  }());
  /**
   * @param {?} elementName
   * @param {?} matchableAttrs
   * @return {?}
   */
  function createElementCssSelector(elementName, matchableAttrs) {
      var /** @type {?} */ cssSelector = new CssSelector();
      var /** @type {?} */ elNameNoNs = splitNsName(elementName)[1];
      cssSelector.setElement(elNameNoNs);
      for (var /** @type {?} */ i = 0; i < matchableAttrs.length; i++) {
          var /** @type {?} */ attrName = matchableAttrs[i][0];
          var /** @type {?} */ attrNameNoNs = splitNsName(attrName)[1];
          var /** @type {?} */ attrValue = matchableAttrs[i][1];
          cssSelector.addAttribute(attrNameNoNs, attrValue);
          if (attrName.toLowerCase() == CLASS_ATTR) {
              var /** @type {?} */ classes = splitClasses(attrValue);
              classes.forEach(function (className) { return cssSelector.addClassName(className); });
          }
      }
      return cssSelector;
  }
  var /** @type {?} */ EMPTY_ELEMENT_CONTEXT = new ElementContext(true, new SelectorMatcher(), null, null);
  var /** @type {?} */ NON_BINDABLE_VISITOR = new NonBindableVisitor();
  /**
   * @param {?} node
   * @return {?}
   */
  function _isEmptyTextNode(node) {
      return node instanceof Text && node.value.trim().length == 0;
  }
  /**
   * @param {?} items
   * @return {?}
   */
  function removeSummaryDuplicates(items) {
      var /** @type {?} */ map = new Map();
      items.forEach(function (item) {
          if (!map.get(item.type.reference)) {
              map.set(item.type.reference, item);
          }
      });
      return Array.from(map.values());
  }

  /**
   * @return {?}
   */
  function unimplemented$1() {
      throw new Error('unimplemented');
  }
  var CompilerConfig = (function () {
      /**
       * @param {?=} __0
       */
      function CompilerConfig(_a) {
          var _b = _a === void 0 ? {} : _a, _c = _b.renderTypes, renderTypes = _c === void 0 ? new DefaultRenderTypes() : _c, _d = _b.defaultEncapsulation, defaultEncapsulation = _d === void 0 ? _angular_core.ViewEncapsulation.Emulated : _d, genDebugInfo = _b.genDebugInfo, logBindingUpdate = _b.logBindingUpdate, _e = _b.useJit, useJit = _e === void 0 ? true : _e;
          this.renderTypes = renderTypes;
          this.defaultEncapsulation = defaultEncapsulation;
          this._genDebugInfo = genDebugInfo;
          this._logBindingUpdate = logBindingUpdate;
          this.useJit = useJit;
      }
      Object.defineProperty(CompilerConfig.prototype, "genDebugInfo", {
          /**
           * @return {?}
           */
          get: function () {
              return this._genDebugInfo === void 0 ? _angular_core.isDevMode() : this._genDebugInfo;
          },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(CompilerConfig.prototype, "logBindingUpdate", {
          /**
           * @return {?}
           */
          get: function () {
              return this._logBindingUpdate === void 0 ? _angular_core.isDevMode() : this._logBindingUpdate;
          },
          enumerable: true,
          configurable: true
      });
      return CompilerConfig;
  }());
  /**
   *  Types used for the renderer.
    * Can be replaced to specialize the generated output to a specific renderer
    * to help tree shaking.
   * @abstract
   */
  var RenderTypes = (function () {
      function RenderTypes() {
      }
      Object.defineProperty(RenderTypes.prototype, "renderer", {
          /**
           * @return {?}
           */
          get: function () { return unimplemented$1(); },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(RenderTypes.prototype, "renderText", {
          /**
           * @return {?}
           */
          get: function () { return unimplemented$1(); },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(RenderTypes.prototype, "renderElement", {
          /**
           * @return {?}
           */
          get: function () { return unimplemented$1(); },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(RenderTypes.prototype, "renderComment", {
          /**
           * @return {?}
           */
          get: function () { return unimplemented$1(); },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(RenderTypes.prototype, "renderNode", {
          /**
           * @return {?}
           */
          get: function () { return unimplemented$1(); },
          enumerable: true,
          configurable: true
      });
      Object.defineProperty(RenderTypes.prototype, "renderEvent", {
          /**
           * @return {?}
           */
          get: function () { return unimplemented$1(); },
          enumerable: true,
          configurable: true
      });
      return RenderTypes;
  }());
  var DefaultRenderTypes = (function () {
      function DefaultRenderTypes() {
          this.renderText = null;
          this.renderElement = null;
          this.renderComment = null;
          this.renderNode = null;
          this.renderEvent = null;
      }
      Object.defineProperty(DefaultRenderTypes.prototype, "renderer", {
          /**
           * @return {?}
           */
          get: function () { return resolveIdentifier(Identifiers.Renderer); },
          enumerable: true,
          configurable: true
      });
      ;
      return DefaultRenderTypes;
  }());

  var __extends$14 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  /**
   * @license undefined
    * Copyright Google Inc. All Rights Reserved.
    * *
    * Use of this source code is governed by an MIT-style license that can be
    * found in the LICENSE file at https://angular.io/license
   * @abstract
   */
  var AnimationAst = (function () {
      function AnimationAst() {
          this.startTime = 0;
          this.playTime = 0;
      }
      /**
       * @abstract
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationAst.prototype.visit = function (visitor, context) { };
      return AnimationAst;
  }());
  /**
   * @abstract
   */
  var AnimationStateAst = (function (_super) {
      __extends$14(AnimationStateAst, _super);
      function AnimationStateAst() {
          _super.apply(this, arguments);
      }
      /**
       * @abstract
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationStateAst.prototype.visit = function (visitor, context) { };
      return AnimationStateAst;
  }(AnimationAst));
  var AnimationEntryAst = (function (_super) {
      __extends$14(AnimationEntryAst, _super);
      /**
       * @param {?} name
       * @param {?} stateDeclarations
       * @param {?} stateTransitions
       */
      function AnimationEntryAst(name, stateDeclarations, stateTransitions) {
          _super.call(this);
          this.name = name;
          this.stateDeclarations = stateDeclarations;
          this.stateTransitions = stateTransitions;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationEntryAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationEntry(this, context);
      };
      return AnimationEntryAst;
  }(AnimationAst));
  var AnimationStateDeclarationAst = (function (_super) {
      __extends$14(AnimationStateDeclarationAst, _super);
      /**
       * @param {?} stateName
       * @param {?} styles
       */
      function AnimationStateDeclarationAst(stateName, styles) {
          _super.call(this);
          this.stateName = stateName;
          this.styles = styles;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationStateDeclarationAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationStateDeclaration(this, context);
      };
      return AnimationStateDeclarationAst;
  }(AnimationStateAst));
  var AnimationStateTransitionExpression = (function () {
      /**
       * @param {?} fromState
       * @param {?} toState
       */
      function AnimationStateTransitionExpression(fromState, toState) {
          this.fromState = fromState;
          this.toState = toState;
      }
      return AnimationStateTransitionExpression;
  }());
  var AnimationStateTransitionAst = (function (_super) {
      __extends$14(AnimationStateTransitionAst, _super);
      /**
       * @param {?} stateChanges
       * @param {?} animation
       */
      function AnimationStateTransitionAst(stateChanges, animation) {
          _super.call(this);
          this.stateChanges = stateChanges;
          this.animation = animation;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationStateTransitionAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationStateTransition(this, context);
      };
      return AnimationStateTransitionAst;
  }(AnimationStateAst));
  var AnimationStepAst = (function (_super) {
      __extends$14(AnimationStepAst, _super);
      /**
       * @param {?} startingStyles
       * @param {?} keyframes
       * @param {?} duration
       * @param {?} delay
       * @param {?} easing
       */
      function AnimationStepAst(startingStyles, keyframes, duration, delay, easing) {
          _super.call(this);
          this.startingStyles = startingStyles;
          this.keyframes = keyframes;
          this.duration = duration;
          this.delay = delay;
          this.easing = easing;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationStepAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationStep(this, context);
      };
      return AnimationStepAst;
  }(AnimationAst));
  var AnimationStylesAst = (function (_super) {
      __extends$14(AnimationStylesAst, _super);
      /**
       * @param {?} styles
       */
      function AnimationStylesAst(styles) {
          _super.call(this);
          this.styles = styles;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationStylesAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationStyles(this, context);
      };
      return AnimationStylesAst;
  }(AnimationAst));
  var AnimationKeyframeAst = (function (_super) {
      __extends$14(AnimationKeyframeAst, _super);
      /**
       * @param {?} offset
       * @param {?} styles
       */
      function AnimationKeyframeAst(offset, styles) {
          _super.call(this);
          this.offset = offset;
          this.styles = styles;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationKeyframeAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationKeyframe(this, context);
      };
      return AnimationKeyframeAst;
  }(AnimationAst));
  /**
   * @abstract
   */
  var AnimationWithStepsAst = (function (_super) {
      __extends$14(AnimationWithStepsAst, _super);
      /**
       * @param {?} steps
       */
      function AnimationWithStepsAst(steps) {
          _super.call(this);
          this.steps = steps;
      }
      return AnimationWithStepsAst;
  }(AnimationAst));
  var AnimationGroupAst = (function (_super) {
      __extends$14(AnimationGroupAst, _super);
      /**
       * @param {?} steps
       */
      function AnimationGroupAst(steps) {
          _super.call(this, steps);
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationGroupAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationGroup(this, context);
      };
      return AnimationGroupAst;
  }(AnimationWithStepsAst));
  var AnimationSequenceAst = (function (_super) {
      __extends$14(AnimationSequenceAst, _super);
      /**
       * @param {?} steps
       */
      function AnimationSequenceAst(steps) {
          _super.call(this, steps);
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      AnimationSequenceAst.prototype.visit = function (visitor, context) {
          return visitor.visitAnimationSequence(this, context);
      };
      return AnimationSequenceAst;
  }(AnimationWithStepsAst));

  var StylesCollectionEntry = (function () {
      /**
       * @param {?} time
       * @param {?} value
       */
      function StylesCollectionEntry(time, value) {
          this.time = time;
          this.value = value;
      }
      /**
       * @param {?} time
       * @param {?} value
       * @return {?}
       */
      StylesCollectionEntry.prototype.matches = function (time, value) {
          return time == this.time && value == this.value;
      };
      return StylesCollectionEntry;
  }());
  var StylesCollection = (function () {
      function StylesCollection() {
          this.styles = {};
      }
      /**
       * @param {?} property
       * @param {?} time
       * @param {?} value
       * @return {?}
       */
      StylesCollection.prototype.insertAtTime = function (property, time, value) {
          var /** @type {?} */ tuple = new StylesCollectionEntry(time, value);
          var /** @type {?} */ entries = this.styles[property];
          if (!isPresent(entries)) {
              entries = this.styles[property] = [];
          }
          // insert this at the right stop in the array
          // this way we can keep it sorted
          var /** @type {?} */ insertionIndex = 0;
          for (var /** @type {?} */ i = entries.length - 1; i >= 0; i--) {
              if (entries[i].time <= time) {
                  insertionIndex = i + 1;
                  break;
              }
          }
          entries.splice(insertionIndex, 0, tuple);
      };
      /**
       * @param {?} property
       * @param {?} index
       * @return {?}
       */
      StylesCollection.prototype.getByIndex = function (property, index) {
          var /** @type {?} */ items = this.styles[property];
          if (isPresent(items)) {
              return index >= items.length ? null : items[index];
          }
          return null;
      };
      /**
       * @param {?} property
       * @param {?} time
       * @return {?}
       */
      StylesCollection.prototype.indexOfAtOrBeforeTime = function (property, time) {
          var /** @type {?} */ entries = this.styles[property];
          if (isPresent(entries)) {
              for (var /** @type {?} */ i = entries.length - 1; i >= 0; i--) {
                  if (entries[i].time <= time)
                      return i;
              }
          }
          return null;
      };
      return StylesCollection;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$13 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var /** @type {?} */ _INITIAL_KEYFRAME = 0;
  var /** @type {?} */ _TERMINAL_KEYFRAME = 1;
  var /** @type {?} */ _ONE_SECOND = 1000;
  var AnimationParseError = (function (_super) {
      __extends$13(AnimationParseError, _super);
      /**
       * @param {?} message
       */
      function AnimationParseError(message) {
          _super.call(this, null, message);
      }
      /**
       * @return {?}
       */
      AnimationParseError.prototype.toString = function () { return "" + this.msg; };
      return AnimationParseError;
  }(ParseError));
  var AnimationEntryParseResult = (function () {
      /**
       * @param {?} ast
       * @param {?} errors
       */
      function AnimationEntryParseResult(ast, errors) {
          this.ast = ast;
          this.errors = errors;
      }
      return AnimationEntryParseResult;
  }());
  var AnimationParser = (function () {
      /**
       * @param {?} _schema
       */
      function AnimationParser(_schema) {
          this._schema = _schema;
      }
      /**
       * @param {?} component
       * @return {?}
       */
      AnimationParser.prototype.parseComponent = function (component) {
          var _this = this;
          var /** @type {?} */ errors = [];
          var /** @type {?} */ componentName = component.type.name;
          var /** @type {?} */ animationTriggerNames = new Set();
          var /** @type {?} */ asts = component.template.animations.map(function (entry) {
              var /** @type {?} */ result = _this.parseEntry(entry);
              var /** @type {?} */ ast = result.ast;
              var /** @type {?} */ triggerName = ast.name;
              if (animationTriggerNames.has(triggerName)) {
                  result.errors.push(new AnimationParseError("The animation trigger \"" + triggerName + "\" has already been registered for the " + componentName + " component"));
              }
              else {
                  animationTriggerNames.add(triggerName);
              }
              if (result.errors.length > 0) {
                  var /** @type {?} */ errorMessage_1 = "- Unable to parse the animation sequence for \"" + triggerName + "\" on the " + componentName + " component due to the following errors:";
                  result.errors.forEach(function (error) { errorMessage_1 += '\n-- ' + error.msg; });
                  errors.push(errorMessage_1);
              }
              return ast;
          });
          if (errors.length > 0) {
              var /** @type {?} */ errorString = errors.join('\n');
              throw new Error("Animation parse errors:\n" + errorString);
          }
          return asts;
      };
      /**
       * @param {?} entry
       * @return {?}
       */
      AnimationParser.prototype.parseEntry = function (entry) {
          var _this = this;
          var /** @type {?} */ errors = [];
          var /** @type {?} */ stateStyles = {};
          var /** @type {?} */ transitions = [];
          var /** @type {?} */ stateDeclarationAsts = [];
          entry.definitions.forEach(function (def) {
              if (def instanceof CompileAnimationStateDeclarationMetadata) {
                  _parseAnimationDeclarationStates(def, _this._schema, errors).forEach(function (ast) {
                      stateDeclarationAsts.push(ast);
                      stateStyles[ast.stateName] = ast.styles;
                  });
              }
              else {
                  transitions.push(/** @type {?} */ (def));
              }
          });
          var /** @type {?} */ stateTransitionAsts = transitions.map(function (transDef) { return _parseAnimationStateTransition(transDef, stateStyles, _this._schema, errors); });
          var /** @type {?} */ ast = new AnimationEntryAst(entry.name, stateDeclarationAsts, stateTransitionAsts);
          return new AnimationEntryParseResult(ast, errors);
      };
      AnimationParser.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      AnimationParser.ctorParameters = function () { return [
          { type: ElementSchemaRegistry, },
      ]; };
      return AnimationParser;
  }());
  /**
   * @param {?} stateMetadata
   * @param {?} schema
   * @param {?} errors
   * @return {?}
   */
  function _parseAnimationDeclarationStates(stateMetadata, schema, errors) {
      var /** @type {?} */ normalizedStyles = _normalizeStyleMetadata(stateMetadata.styles, {}, schema, errors, false);
      var /** @type {?} */ defStyles = new AnimationStylesAst(normalizedStyles);
      var /** @type {?} */ states = stateMetadata.stateNameExpr.split(/\s*,\s*/);
      return states.map(function (state) { return new AnimationStateDeclarationAst(state, defStyles); });
  }
  /**
   * @param {?} transitionStateMetadata
   * @param {?} stateStyles
   * @param {?} schema
   * @param {?} errors
   * @return {?}
   */
  function _parseAnimationStateTransition(transitionStateMetadata, stateStyles, schema, errors) {
      var /** @type {?} */ styles = new StylesCollection();
      var /** @type {?} */ transitionExprs = [];
      var /** @type {?} */ transitionStates = transitionStateMetadata.stateChangeExpr.split(/\s*,\s*/);
      transitionStates.forEach(function (expr) { transitionExprs.push.apply(transitionExprs, _parseAnimationTransitionExpr(expr, errors)); });
      var /** @type {?} */ entry = _normalizeAnimationEntry(transitionStateMetadata.steps);
      var /** @type {?} */ animation = _normalizeStyleSteps(entry, stateStyles, schema, errors);
      var /** @type {?} */ animationAst = _parseTransitionAnimation(animation, 0, styles, stateStyles, errors);
      if (errors.length == 0) {
          _fillAnimationAstStartingKeyframes(animationAst, styles, errors);
      }
      var /** @type {?} */ stepsAst = (animationAst instanceof AnimationWithStepsAst) ?
          animationAst :
          new AnimationSequenceAst([animationAst]);
      return new AnimationStateTransitionAst(transitionExprs, stepsAst);
  }
  /**
   * @param {?} alias
   * @param {?} errors
   * @return {?}
   */
  function _parseAnimationAlias(alias, errors) {
      switch (alias) {
          case ':enter':
              return 'void => *';
          case ':leave':
              return '* => void';
          default:
              errors.push(new AnimationParseError("the transition alias value \"" + alias + "\" is not supported"));
              return '* => *';
      }
  }
  /**
   * @param {?} eventStr
   * @param {?} errors
   * @return {?}
   */
  function _parseAnimationTransitionExpr(eventStr, errors) {
      var /** @type {?} */ expressions = [];
      if (eventStr[0] == ':') {
          eventStr = _parseAnimationAlias(eventStr, errors);
      }
      var /** @type {?} */ match = eventStr.match(/^(\*|[-\w]+)\s*(<?[=-]>)\s*(\*|[-\w]+)$/);
      if (!isPresent(match) || match.length < 4) {
          errors.push(new AnimationParseError("the provided " + eventStr + " is not of a supported format"));
          return expressions;
      }
      var /** @type {?} */ fromState = match[1];
      var /** @type {?} */ separator = match[2];
      var /** @type {?} */ toState = match[3];
      expressions.push(new AnimationStateTransitionExpression(fromState, toState));
      var /** @type {?} */ isFullAnyStateExpr = fromState == ANY_STATE && toState == ANY_STATE;
      if (separator[0] == '<' && !isFullAnyStateExpr) {
          expressions.push(new AnimationStateTransitionExpression(toState, fromState));
      }
      return expressions;
  }
  /**
   * @param {?} entry
   * @return {?}
   */
  function _normalizeAnimationEntry(entry) {
      return Array.isArray(entry) ? new CompileAnimationSequenceMetadata(entry) : entry;
  }
  /**
   * @param {?} entry
   * @param {?} stateStyles
   * @param {?} schema
   * @param {?} errors
   * @param {?} permitStateReferences
   * @return {?}
   */
  function _normalizeStyleMetadata(entry, stateStyles, schema, errors, permitStateReferences) {
      var /** @type {?} */ normalizedStyles = [];
      entry.styles.forEach(function (styleEntry) {
          if (typeof styleEntry === 'string') {
              if (permitStateReferences) {
                  normalizedStyles.push.apply(normalizedStyles, _resolveStylesFromState(/** @type {?} */ (styleEntry), stateStyles, errors));
              }
              else {
                  errors.push(new AnimationParseError("State based animations cannot contain references to other states"));
              }
          }
          else {
              var /** @type {?} */ stylesObj_1 = (styleEntry);
              var /** @type {?} */ normalizedStylesObj_1 = {};
              Object.keys(stylesObj_1).forEach(function (propName) {
                  var /** @type {?} */ normalizedProp = schema.normalizeAnimationStyleProperty(propName);
                  var /** @type {?} */ normalizedOutput = schema.normalizeAnimationStyleValue(normalizedProp, propName, stylesObj_1[propName]);
                  var /** @type {?} */ normalizationError = normalizedOutput['error'];
                  if (normalizationError) {
                      errors.push(new AnimationParseError(normalizationError));
                  }
                  normalizedStylesObj_1[normalizedProp] = normalizedOutput['value'];
              });
              normalizedStyles.push(normalizedStylesObj_1);
          }
      });
      return normalizedStyles;
  }
  /**
   * @param {?} entry
   * @param {?} stateStyles
   * @param {?} schema
   * @param {?} errors
   * @return {?}
   */
  function _normalizeStyleSteps(entry, stateStyles, schema, errors) {
      var /** @type {?} */ steps = _normalizeStyleStepEntry(entry, stateStyles, schema, errors);
      return (entry instanceof CompileAnimationGroupMetadata) ?
          new CompileAnimationGroupMetadata(steps) :
          new CompileAnimationSequenceMetadata(steps);
  }
  /**
   * @param {?} stylesList
   * @param {?} newItem
   * @return {?}
   */
  function _mergeAnimationStyles(stylesList, newItem) {
      if (typeof newItem === 'object' && newItem !== null && stylesList.length > 0) {
          var /** @type {?} */ lastIndex = stylesList.length - 1;
          var /** @type {?} */ lastItem = stylesList[lastIndex];
          if (typeof lastItem === 'object' && lastItem !== null) {
              stylesList[lastIndex] = StringMapWrapper.merge(/** @type {?} */ (lastItem), /** @type {?} */ (newItem));
              return;
          }
      }
      stylesList.push(newItem);
  }
  /**
   * @param {?} entry
   * @param {?} stateStyles
   * @param {?} schema
   * @param {?} errors
   * @return {?}
   */
  function _normalizeStyleStepEntry(entry, stateStyles, schema, errors) {
      var /** @type {?} */ steps;
      if (entry instanceof CompileAnimationWithStepsMetadata) {
          steps = entry.steps;
      }
      else {
          return [entry];
      }
      var /** @type {?} */ newSteps = [];
      var /** @type {?} */ combinedStyles;
      steps.forEach(function (step) {
          if (step instanceof CompileAnimationStyleMetadata) {
              // this occurs when a style step is followed by a previous style step
              // or when the first style step is run. We want to concatenate all subsequent
              // style steps together into a single style step such that we have the correct
              // starting keyframe data to pass into the animation player.
              if (!isPresent(combinedStyles)) {
                  combinedStyles = [];
              }
              _normalizeStyleMetadata(/** @type {?} */ (step), stateStyles, schema, errors, true)
                  .forEach(function (entry) { _mergeAnimationStyles(combinedStyles, entry); });
          }
          else {
              // it is important that we create a metadata entry of the combined styles
              // before we go on an process the animate, sequence or group metadata steps.
              // This will ensure that the AST will have the previous styles painted on
              // screen before any further animations that use the styles take place.
              if (isPresent(combinedStyles)) {
                  newSteps.push(new CompileAnimationStyleMetadata(0, combinedStyles));
                  combinedStyles = null;
              }
              if (step instanceof CompileAnimationAnimateMetadata) {
                  // we do not recurse into CompileAnimationAnimateMetadata since
                  // those style steps are not going to be squashed
                  var /** @type {?} */ animateStyleValue = ((step)).styles;
                  if (animateStyleValue instanceof CompileAnimationStyleMetadata) {
                      animateStyleValue.styles =
                          _normalizeStyleMetadata(animateStyleValue, stateStyles, schema, errors, true);
                  }
                  else if (animateStyleValue instanceof CompileAnimationKeyframesSequenceMetadata) {
                      animateStyleValue.steps.forEach(function (step) {
                          step.styles = _normalizeStyleMetadata(step, stateStyles, schema, errors, true);
                      });
                  }
              }
              else if (step instanceof CompileAnimationWithStepsMetadata) {
                  var /** @type {?} */ innerSteps = _normalizeStyleStepEntry(step, stateStyles, schema, errors);
                  step = step instanceof CompileAnimationGroupMetadata ?
                      new CompileAnimationGroupMetadata(innerSteps) :
                      new CompileAnimationSequenceMetadata(innerSteps);
              }
              newSteps.push(step);
          }
      });
      // this happens when only styles were animated within the sequence
      if (isPresent(combinedStyles)) {
          newSteps.push(new CompileAnimationStyleMetadata(0, combinedStyles));
      }
      return newSteps;
  }
  /**
   * @param {?} stateName
   * @param {?} stateStyles
   * @param {?} errors
   * @return {?}
   */
  function _resolveStylesFromState(stateName, stateStyles, errors) {
      var /** @type {?} */ styles = [];
      if (stateName[0] != ':') {
          errors.push(new AnimationParseError("Animation states via styles must be prefixed with a \":\""));
      }
      else {
          var /** @type {?} */ normalizedStateName = stateName.substring(1);
          var /** @type {?} */ value = stateStyles[normalizedStateName];
          if (!isPresent(value)) {
              errors.push(new AnimationParseError("Unable to apply styles due to missing a state: \"" + normalizedStateName + "\""));
          }
          else {
              value.styles.forEach(function (stylesEntry) {
                  if (typeof stylesEntry === 'object' && stylesEntry !== null) {
                      styles.push(/** @type {?} */ (stylesEntry));
                  }
              });
          }
      }
      return styles;
  }
  var _AnimationTimings = (function () {
      /**
       * @param {?} duration
       * @param {?} delay
       * @param {?} easing
       */
      function _AnimationTimings(duration, delay, easing) {
          this.duration = duration;
          this.delay = delay;
          this.easing = easing;
      }
      return _AnimationTimings;
  }());
  /**
   * @param {?} keyframeSequence
   * @param {?} currentTime
   * @param {?} collectedStyles
   * @param {?} stateStyles
   * @param {?} errors
   * @return {?}
   */
  function _parseAnimationKeyframes(keyframeSequence, currentTime, collectedStyles, stateStyles, errors) {
      var /** @type {?} */ totalEntries = keyframeSequence.steps.length;
      var /** @type {?} */ totalOffsets = 0;
      keyframeSequence.steps.forEach(function (step) { return totalOffsets += (isPresent(step.offset) ? 1 : 0); });
      if (totalOffsets > 0 && totalOffsets < totalEntries) {
          errors.push(new AnimationParseError("Not all style() entries contain an offset for the provided keyframe()"));
          totalOffsets = totalEntries;
      }
      var /** @type {?} */ limit = totalEntries - 1;
      var /** @type {?} */ margin = totalOffsets == 0 ? (1 / limit) : 0;
      var /** @type {?} */ rawKeyframes = [];
      var /** @type {?} */ index = 0;
      var /** @type {?} */ doSortKeyframes = false;
      var /** @type {?} */ lastOffset = 0;
      keyframeSequence.steps.forEach(function (styleMetadata) {
          var /** @type {?} */ offset = styleMetadata.offset;
          var /** @type {?} */ keyframeStyles = {};
          styleMetadata.styles.forEach(function (entry) {
              Object.keys(entry).forEach(function (prop) {
                  if (prop != 'offset') {
                      keyframeStyles[prop] = ((entry))[prop];
                  }
              });
          });
          if (isPresent(offset)) {
              doSortKeyframes = doSortKeyframes || (offset < lastOffset);
          }
          else {
              offset = index == limit ? _TERMINAL_KEYFRAME : (margin * index);
          }
          rawKeyframes.push([offset, keyframeStyles]);
          lastOffset = offset;
          index++;
      });
      if (doSortKeyframes) {
          rawKeyframes.sort(function (a, b) { return a[0] <= b[0] ? -1 : 1; });
      }
      var /** @type {?} */ firstKeyframe = rawKeyframes[0];
      if (firstKeyframe[0] != _INITIAL_KEYFRAME) {
          rawKeyframes.splice(0, 0, firstKeyframe = [_INITIAL_KEYFRAME, {}]);
      }
      var /** @type {?} */ firstKeyframeStyles = firstKeyframe[1];
      limit = rawKeyframes.length - 1;
      var /** @type {?} */ lastKeyframe = rawKeyframes[limit];
      if (lastKeyframe[0] != _TERMINAL_KEYFRAME) {
          rawKeyframes.push(lastKeyframe = [_TERMINAL_KEYFRAME, {}]);
          limit++;
      }
      var /** @type {?} */ lastKeyframeStyles = lastKeyframe[1];
      for (var /** @type {?} */ i = 1; i <= limit; i++) {
          var /** @type {?} */ entry = rawKeyframes[i];
          var /** @type {?} */ styles = entry[1];
          Object.keys(styles).forEach(function (prop) {
              if (!isPresent(firstKeyframeStyles[prop])) {
                  firstKeyframeStyles[prop] = FILL_STYLE_FLAG;
              }
          });
      }
      var _loop_1 = function(i) {
          var /** @type {?} */ entry = rawKeyframes[i];
          var /** @type {?} */ styles = entry[1];
          Object.keys(styles).forEach(function (prop) {
              if (!isPresent(lastKeyframeStyles[prop])) {
                  lastKeyframeStyles[prop] = styles[prop];
              }
          });
      };
      for (var /** @type {?} */ i = limit - 1; i >= 0; i--) {
          _loop_1(i);
      }
      return rawKeyframes.map(function (entry) { return new AnimationKeyframeAst(entry[0], new AnimationStylesAst([entry[1]])); });
  }
  /**
   * @param {?} entry
   * @param {?} currentTime
   * @param {?} collectedStyles
   * @param {?} stateStyles
   * @param {?} errors
   * @return {?}
   */
  function _parseTransitionAnimation(entry, currentTime, collectedStyles, stateStyles, errors) {
      var /** @type {?} */ ast;
      var /** @type {?} */ playTime = 0;
      var /** @type {?} */ startingTime = currentTime;
      if (entry instanceof CompileAnimationWithStepsMetadata) {
          var /** @type {?} */ maxDuration_1 = 0;
          var /** @type {?} */ steps_1 = [];
          var /** @type {?} */ isGroup_1 = entry instanceof CompileAnimationGroupMetadata;
          var /** @type {?} */ previousStyles_1;
          entry.steps.forEach(function (entry) {
              // these will get picked up by the next step...
              var /** @type {?} */ time = isGroup_1 ? startingTime : currentTime;
              if (entry instanceof CompileAnimationStyleMetadata) {
                  entry.styles.forEach(function (stylesEntry) {
                      // by this point we know that we only have stringmap values
                      var /** @type {?} */ map = (stylesEntry);
                      Object.keys(map).forEach(function (prop) { collectedStyles.insertAtTime(prop, time, map[prop]); });
                  });
                  previousStyles_1 = entry.styles;
                  return;
              }
              var /** @type {?} */ innerAst = _parseTransitionAnimation(entry, time, collectedStyles, stateStyles, errors);
              if (isPresent(previousStyles_1)) {
                  if (entry instanceof CompileAnimationWithStepsMetadata) {
                      var /** @type {?} */ startingStyles = new AnimationStylesAst(previousStyles_1);
                      steps_1.push(new AnimationStepAst(startingStyles, [], 0, 0, ''));
                  }
                  else {
                      var /** @type {?} */ innerStep = (innerAst);
                      (_a = innerStep.startingStyles.styles).push.apply(_a, previousStyles_1);
                  }
                  previousStyles_1 = null;
              }
              var /** @type {?} */ astDuration = innerAst.playTime;
              currentTime += astDuration;
              playTime += astDuration;
              maxDuration_1 = Math.max(astDuration, maxDuration_1);
              steps_1.push(innerAst);
              var _a;
          });
          if (isPresent(previousStyles_1)) {
              var /** @type {?} */ startingStyles = new AnimationStylesAst(previousStyles_1);
              steps_1.push(new AnimationStepAst(startingStyles, [], 0, 0, ''));
          }
          if (isGroup_1) {
              ast = new AnimationGroupAst(steps_1);
              playTime = maxDuration_1;
              currentTime = startingTime + playTime;
          }
          else {
              ast = new AnimationSequenceAst(steps_1);
          }
      }
      else if (entry instanceof CompileAnimationAnimateMetadata) {
          var /** @type {?} */ timings = _parseTimeExpression(entry.timings, errors);
          var /** @type {?} */ styles = entry.styles;
          var /** @type {?} */ keyframes = void 0;
          if (styles instanceof CompileAnimationKeyframesSequenceMetadata) {
              keyframes =
                  _parseAnimationKeyframes(styles, currentTime, collectedStyles, stateStyles, errors);
          }
          else {
              var /** @type {?} */ styleData = (styles);
              var /** @type {?} */ offset = _TERMINAL_KEYFRAME;
              var /** @type {?} */ styleAst = new AnimationStylesAst(/** @type {?} */ (styleData.styles));
              var /** @type {?} */ keyframe = new AnimationKeyframeAst(offset, styleAst);
              keyframes = [keyframe];
          }
          ast = new AnimationStepAst(new AnimationStylesAst([]), keyframes, timings.duration, timings.delay, timings.easing);
          playTime = timings.duration + timings.delay;
          currentTime += playTime;
          keyframes.forEach(function (keyframe /** TODO #9100 */) { return keyframe.styles.styles.forEach(function (entry /** TODO #9100 */) { return Object.keys(entry).forEach(function (prop) { collectedStyles.insertAtTime(prop, currentTime, entry[prop]); }); }); });
      }
      else {
          // if the code reaches this stage then an error
          // has already been populated within the _normalizeStyleSteps()
          // operation...
          ast = new AnimationStepAst(null, [], 0, 0, '');
      }
      ast.playTime = playTime;
      ast.startTime = startingTime;
      return ast;
  }
  /**
   * @param {?} ast
   * @param {?} collectedStyles
   * @param {?} errors
   * @return {?}
   */
  function _fillAnimationAstStartingKeyframes(ast, collectedStyles, errors) {
      // steps that only contain style will not be filled
      if ((ast instanceof AnimationStepAst) && ast.keyframes.length > 0) {
          var /** @type {?} */ keyframes = ast.keyframes;
          if (keyframes.length == 1) {
              var /** @type {?} */ endKeyframe = keyframes[0];
              var /** @type {?} */ startKeyframe = _createStartKeyframeFromEndKeyframe(endKeyframe, ast.startTime, ast.playTime, collectedStyles, errors);
              ast.keyframes = [startKeyframe, endKeyframe];
          }
      }
      else if (ast instanceof AnimationWithStepsAst) {
          ast.steps.forEach(function (entry) { return _fillAnimationAstStartingKeyframes(entry, collectedStyles, errors); });
      }
  }
  /**
   * @param {?} exp
   * @param {?} errors
   * @return {?}
   */
  function _parseTimeExpression(exp, errors) {
      var /** @type {?} */ regex = /^([\.\d]+)(m?s)(?:\s+([\.\d]+)(m?s))?(?:\s+([-a-z]+(?:\(.+?\))?))?/i;
      var /** @type {?} */ duration;
      var /** @type {?} */ delay = 0;
      var /** @type {?} */ easing = null;
      if (typeof exp === 'string') {
          var /** @type {?} */ matches = exp.match(regex);
          if (matches === null) {
              errors.push(new AnimationParseError("The provided timing value \"" + exp + "\" is invalid."));
              return new _AnimationTimings(0, 0, null);
          }
          var /** @type {?} */ durationMatch = parseFloat(matches[1]);
          var /** @type {?} */ durationUnit = matches[2];
          if (durationUnit == 's') {
              durationMatch *= _ONE_SECOND;
          }
          duration = Math.floor(durationMatch);
          var /** @type {?} */ delayMatch = matches[3];
          var /** @type {?} */ delayUnit = matches[4];
          if (isPresent(delayMatch)) {
              var /** @type {?} */ delayVal = parseFloat(delayMatch);
              if (isPresent(delayUnit) && delayUnit == 's') {
                  delayVal *= _ONE_SECOND;
              }
              delay = Math.floor(delayVal);
          }
          var /** @type {?} */ easingVal = matches[5];
          if (!isBlank(easingVal)) {
              easing = easingVal;
          }
      }
      else {
          duration = (exp);
      }
      return new _AnimationTimings(duration, delay, easing);
  }
  /**
   * @param {?} endKeyframe
   * @param {?} startTime
   * @param {?} duration
   * @param {?} collectedStyles
   * @param {?} errors
   * @return {?}
   */
  function _createStartKeyframeFromEndKeyframe(endKeyframe, startTime, duration, collectedStyles, errors) {
      var /** @type {?} */ values = {};
      var /** @type {?} */ endTime = startTime + duration;
      endKeyframe.styles.styles.forEach(function (styleData) {
          Object.keys(styleData).forEach(function (prop) {
              var /** @type {?} */ val = styleData[prop];
              if (prop == 'offset')
                  return;
              var /** @type {?} */ resultIndex = collectedStyles.indexOfAtOrBeforeTime(prop, startTime);
              var /** @type {?} */ resultEntry /** TODO #9100 */, /** @type {?} */ nextEntry /** TODO #9100 */, /** @type {?} */ value;
              if (isPresent(resultIndex)) {
                  resultEntry = collectedStyles.getByIndex(prop, resultIndex);
                  value = resultEntry.value;
                  nextEntry = collectedStyles.getByIndex(prop, resultIndex + 1);
              }
              else {
                  // this is a flag that the runtime code uses to pass
                  // in a value either from the state declaration styles
                  // or using the AUTO_STYLE value (e.g. getComputedStyle)
                  value = FILL_STYLE_FLAG;
              }
              if (isPresent(nextEntry) && !nextEntry.matches(endTime, val)) {
                  errors.push(new AnimationParseError("The animated CSS property \"" + prop + "\" unexpectedly changes between steps \"" + resultEntry.time + "ms\" and \"" + endTime + "ms\" at \"" + nextEntry.time + "ms\""));
              }
              values[prop] = value;
          });
      });
      return new AnimationKeyframeAst(_INITIAL_KEYFRAME, new AnimationStylesAst([values]));
  }

  /**
   *  An interface for retrieving documents by URL that the compiler uses
    * to load templates.
   */
  var ResourceLoader = (function () {
      function ResourceLoader() {
      }
      /**
       * @param {?} url
       * @return {?}
       */
      ResourceLoader.prototype.get = function (url) { return null; };
      return ResourceLoader;
  }());

  /**
   *  Create a {@link UrlResolver} with no package prefix.
   * @return {?}
   */
  function createUrlResolverWithoutPackagePrefix() {
      return new UrlResolver();
  }
  /**
   * @return {?}
   */
  function createOfflineCompileUrlResolver() {
      return new UrlResolver('.');
  }
  /**
   * A default provider for {@link PACKAGE_ROOT_URL} that maps to '/'.
   */
  var /** @type {?} */ DEFAULT_PACKAGE_URL_PROVIDER = {
      provide: _angular_core.PACKAGE_ROOT_URL,
      useValue: '/'
  };
  /**
   *  Used by the {@link Compiler} when resolving HTML and CSS template URLs.
    * *
    * This class can be overridden by the application developer to create custom behavior.
    * *
    * See {@link Compiler}
    * *
    * ## Example
    * *
    * {@example compiler/ts/url_resolver/url_resolver.ts region='url_resolver'}
    * *
    * ensure that the entire template comes from a trusted source.
    * Attacker-controlled data introduced by a template could expose your
    * application to XSS risks. For more detail, see the [Security Guide](http://g.co/ng/security).
   */
  var UrlResolver = (function () {
      /**
       * @param {?=} _packagePrefix
       */
      function UrlResolver(_packagePrefix) {
          if (_packagePrefix === void 0) { _packagePrefix = null; }
          this._packagePrefix = _packagePrefix;
      }
      /**
       *  Resolves the `url` given the `baseUrl`:
        * - when the `url` is null, the `baseUrl` is returned,
        * - if `url` is relative ('path/to/here', './path/to/here'), the resolved url is a combination of
        * `baseUrl` and `url`,
        * - if `url` is absolute (it has a scheme: 'http://', 'https://' or start with '/'), the `url` is
        * returned as is (ignoring the `baseUrl`)
       * @param {?} baseUrl
       * @param {?} url
       * @return {?}
       */
      UrlResolver.prototype.resolve = function (baseUrl, url) {
          var /** @type {?} */ resolvedUrl = url;
          if (isPresent(baseUrl) && baseUrl.length > 0) {
              resolvedUrl = _resolveUrl(baseUrl, resolvedUrl);
          }
          var /** @type {?} */ resolvedParts = _split(resolvedUrl);
          var /** @type {?} */ prefix = this._packagePrefix;
          if (isPresent(prefix) && isPresent(resolvedParts) &&
              resolvedParts[_ComponentIndex.Scheme] == 'package') {
              var /** @type {?} */ path = resolvedParts[_ComponentIndex.Path];
              prefix = prefix.replace(/\/+$/, '');
              path = path.replace(/^\/+/, '');
              return prefix + "/" + path;
          }
          return resolvedUrl;
      };
      UrlResolver.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      UrlResolver.ctorParameters = function () { return [
          { type: undefined, decorators: [{ type: _angular_core.Inject, args: [_angular_core.PACKAGE_ROOT_URL,] },] },
      ]; };
      return UrlResolver;
  }());
  /**
   *  Extract the scheme of a URL.
   * @param {?} url
   * @return {?}
   */
  function getUrlScheme(url) {
      var /** @type {?} */ match = _split(url);
      return (match && match[_ComponentIndex.Scheme]) || '';
  }
  /**
   *  Builds a URI string from already-encoded parts.
    * *
    * No encoding is performed.  Any component may be omitted as either null or
    * undefined.
    * *
   * @param {?=} opt_scheme The scheme such as 'http'.
   * @param {?=} opt_userInfo The user name before the '@'.
   * @param {?=} opt_domain The domain such as 'www.google.com', already
    * URI-encoded.
   * @param {?=} opt_port The port number.
   * @param {?=} opt_path The path, already URI-encoded.  If it is not
    * empty, it must begin with a slash.
   * @param {?=} opt_queryData The URI-encoded query data.
   * @param {?=} opt_fragment The URI-encoded fragment identifier.
   * @return {?} The fully combined URI.
   */
  function _buildFromEncodedParts(opt_scheme, opt_userInfo, opt_domain, opt_port, opt_path, opt_queryData, opt_fragment) {
      var /** @type {?} */ out = [];
      if (isPresent(opt_scheme)) {
          out.push(opt_scheme + ':');
      }
      if (isPresent(opt_domain)) {
          out.push('//');
          if (isPresent(opt_userInfo)) {
              out.push(opt_userInfo + '@');
          }
          out.push(opt_domain);
          if (isPresent(opt_port)) {
              out.push(':' + opt_port);
          }
      }
      if (isPresent(opt_path)) {
          out.push(opt_path);
      }
      if (isPresent(opt_queryData)) {
          out.push('?' + opt_queryData);
      }
      if (isPresent(opt_fragment)) {
          out.push('#' + opt_fragment);
      }
      return out.join('');
  }
  /**
   * A regular expression for breaking a URI into its component parts.
   *
   * {@link http://www.gbiv.com/protocols/uri/rfc/rfc3986.html#RFC2234} says
   * As the "first-match-wins" algorithm is identical to the "greedy"
   * disambiguation method used by POSIX regular expressions, it is natural and
   * commonplace to use a regular expression for parsing the potential five
   * components of a URI reference.
   *
   * The following line is the regular expression for breaking-down a
   * well-formed URI reference into its components.
   *
   * <pre>
   * ^(([^:/?#]+):)?(//([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?
   *  12            3  4          5       6  7        8 9
   * </pre>
   *
   * The numbers in the second line above are only to assist readability; they
   * indicate the reference points for each subexpression (i.e., each paired
   * parenthesis). We refer to the value matched for subexpression <n> as $<n>.
   * For example, matching the above expression to
   * <pre>
   *     http://www.ics.uci.edu/pub/ietf/uri/#Related
   * </pre>
   * results in the following subexpression matches:
   * <pre>
   *    $1 = http:
   *    $2 = http
   *    $3 = //www.ics.uci.edu
   *    $4 = www.ics.uci.edu
   *    $5 = /pub/ietf/uri/
   *    $6 = <undefined>
   *    $7 = <undefined>
   *    $8 = #Related
   *    $9 = Related
   * </pre>
   * where <undefined> indicates that the component is not present, as is the
   * case for the query component in the above example. Therefore, we can
   * determine the value of the five components as
   * <pre>
   *    scheme    = $2
   *    authority = $4
   *    path      = $5
   *    query     = $7
   *    fragment  = $9
   * </pre>
   *
   * The regular expression has been modified slightly to expose the
   * userInfo, domain, and port separately from the authority.
   * The modified version yields
   * <pre>
   *    $1 = http              scheme
   *    $2 = <undefined>       userInfo -\
   *    $3 = www.ics.uci.edu   domain     | authority
   *    $4 = <undefined>       port     -/
   *    $5 = /pub/ietf/uri/    path
   *    $6 = <undefined>       query without ?
   *    $7 = Related           fragment without #
   * </pre>
   * @type {!RegExp}
   * @internal
   */
  var /** @type {?} */ _splitRe = new RegExp('^' +
      '(?:' +
      '([^:/?#.]+)' +
      // used by other URL parts such as :,
      // ?, /, #, and .
      ':)?' +
      '(?://' +
      '(?:([^/?#]*)@)?' +
      '([\\w\\d\\-\\u0100-\\uffff.%]*)' +
      // digits, dashes, dots, percent
      // escapes, and unicode characters.
      '(?::([0-9]+))?' +
      ')?' +
      '([^?#]+)?' +
      '(?:\\?([^#]*))?' +
      '(?:#(.*))?' +
      '$');
  var _ComponentIndex = {};
  _ComponentIndex.Scheme = 1;
  _ComponentIndex.UserInfo = 2;
  _ComponentIndex.Domain = 3;
  _ComponentIndex.Port = 4;
  _ComponentIndex.Path = 5;
  _ComponentIndex.QueryData = 6;
  _ComponentIndex.Fragment = 7;
  _ComponentIndex[_ComponentIndex.Scheme] = "Scheme";
  _ComponentIndex[_ComponentIndex.UserInfo] = "UserInfo";
  _ComponentIndex[_ComponentIndex.Domain] = "Domain";
  _ComponentIndex[_ComponentIndex.Port] = "Port";
  _ComponentIndex[_ComponentIndex.Path] = "Path";
  _ComponentIndex[_ComponentIndex.QueryData] = "QueryData";
  _ComponentIndex[_ComponentIndex.Fragment] = "Fragment";
  /**
   *  Splits a URI into its component parts.
    * *
    * Each component can be accessed via the component indices; for example:
    * <pre>
    * goog.uri.utils.split(someStr)[goog.uri.utils.CompontentIndex.QUERY_DATA];
    * </pre>
    * *
   * @param {?} uri The URI string to examine.
   * @return {?} Each component still URI-encoded.
    * Each component that is present will contain the encoded value, whereas
    * components that are not present will be undefined or empty, depending
    * on the browser's regular expression implementation.  Never null, since
    * arbitrary strings may still look like path names.
   */
  function _split(uri) {
      return uri.match(_splitRe);
  }
  /**
   *  Removes dot segments in given path component, as described in
    * RFC 3986, section 5.2.4.
    * *
   * @param {?} path A non-empty path component.
   * @return {?} Path component with removed dot segments.
   */
  function _removeDotSegments(path) {
      if (path == '/')
          return '/';
      var /** @type {?} */ leadingSlash = path[0] == '/' ? '/' : '';
      var /** @type {?} */ trailingSlash = path[path.length - 1] === '/' ? '/' : '';
      var /** @type {?} */ segments = path.split('/');
      var /** @type {?} */ out = [];
      var /** @type {?} */ up = 0;
      for (var /** @type {?} */ pos = 0; pos < segments.length; pos++) {
          var /** @type {?} */ segment = segments[pos];
          switch (segment) {
              case '':
              case '.':
                  break;
              case '..':
                  if (out.length > 0) {
                      out.pop();
                  }
                  else {
                      up++;
                  }
                  break;
              default:
                  out.push(segment);
          }
      }
      if (leadingSlash == '') {
          while (up-- > 0) {
              out.unshift('..');
          }
          if (out.length === 0)
              out.push('.');
      }
      return leadingSlash + out.join('/') + trailingSlash;
  }
  /**
   *  Takes an array of the parts from split and canonicalizes the path part
    * and then joins all the parts.
   * @param {?} parts
   * @return {?}
   */
  function _joinAndCanonicalizePath(parts) {
      var /** @type {?} */ path = parts[_ComponentIndex.Path];
      path = isBlank(path) ? '' : _removeDotSegments(path);
      parts[_ComponentIndex.Path] = path;
      return _buildFromEncodedParts(parts[_ComponentIndex.Scheme], parts[_ComponentIndex.UserInfo], parts[_ComponentIndex.Domain], parts[_ComponentIndex.Port], path, parts[_ComponentIndex.QueryData], parts[_ComponentIndex.Fragment]);
  }
  /**
   *  Resolves a URL.
   * @param {?} base The URL acting as the base URL.
   * @param {?} url
   * @return {?}
   */
  function _resolveUrl(base, url) {
      var /** @type {?} */ parts = _split(encodeURI(url));
      var /** @type {?} */ baseParts = _split(base);
      if (isPresent(parts[_ComponentIndex.Scheme])) {
          return _joinAndCanonicalizePath(parts);
      }
      else {
          parts[_ComponentIndex.Scheme] = baseParts[_ComponentIndex.Scheme];
      }
      for (var /** @type {?} */ i = _ComponentIndex.Scheme; i <= _ComponentIndex.Port; i++) {
          if (isBlank(parts[i])) {
              parts[i] = baseParts[i];
          }
      }
      if (parts[_ComponentIndex.Path][0] == '/') {
          return _joinAndCanonicalizePath(parts);
      }
      var /** @type {?} */ path = baseParts[_ComponentIndex.Path];
      if (isBlank(path))
          path = '/';
      var /** @type {?} */ index = path.lastIndexOf('/');
      path = path.substring(0, index + 1) + parts[_ComponentIndex.Path];
      parts[_ComponentIndex.Path] = path;
      return _joinAndCanonicalizePath(parts);
  }

  var DirectiveNormalizer = (function () {
      /**
       * @param {?} _resourceLoader
       * @param {?} _urlResolver
       * @param {?} _htmlParser
       * @param {?} _config
       */
      function DirectiveNormalizer(_resourceLoader, _urlResolver, _htmlParser, _config) {
          this._resourceLoader = _resourceLoader;
          this._urlResolver = _urlResolver;
          this._htmlParser = _htmlParser;
          this._config = _config;
          this._resourceLoaderCache = new Map();
      }
      /**
       * @return {?}
       */
      DirectiveNormalizer.prototype.clearCache = function () { this._resourceLoaderCache.clear(); };
      /**
       * @param {?} normalizedDirective
       * @return {?}
       */
      DirectiveNormalizer.prototype.clearCacheFor = function (normalizedDirective) {
          var _this = this;
          if (!normalizedDirective.isComponent) {
              return;
          }
          this._resourceLoaderCache.delete(normalizedDirective.template.templateUrl);
          normalizedDirective.template.externalStylesheets.forEach(function (stylesheet) { _this._resourceLoaderCache.delete(stylesheet.moduleUrl); });
      };
      /**
       * @param {?} url
       * @return {?}
       */
      DirectiveNormalizer.prototype._fetch = function (url) {
          var /** @type {?} */ result = this._resourceLoaderCache.get(url);
          if (!result) {
              result = this._resourceLoader.get(url);
              this._resourceLoaderCache.set(url, result);
          }
          return result;
      };
      /**
       * @param {?} prenormData
       * @return {?}
       */
      DirectiveNormalizer.prototype.normalizeTemplate = function (prenormData) {
          var _this = this;
          var /** @type {?} */ normalizedTemplateSync = null;
          var /** @type {?} */ normalizedTemplateAsync;
          if (isPresent(prenormData.template)) {
              normalizedTemplateSync = this.normalizeTemplateSync(prenormData);
              normalizedTemplateAsync = Promise.resolve(normalizedTemplateSync);
          }
          else if (prenormData.templateUrl) {
              normalizedTemplateAsync = this.normalizeTemplateAsync(prenormData);
          }
          else {
              throw new Error("No template specified for component " + stringify(prenormData.componentType));
          }
          if (normalizedTemplateSync && normalizedTemplateSync.styleUrls.length === 0) {
              // sync case
              return new SyncAsyncResult(normalizedTemplateSync);
          }
          else {
              // async case
              return new SyncAsyncResult(null, normalizedTemplateAsync.then(function (normalizedTemplate) { return _this.normalizeExternalStylesheets(normalizedTemplate); }));
          }
      };
      /**
       * @param {?} prenomData
       * @return {?}
       */
      DirectiveNormalizer.prototype.normalizeTemplateSync = function (prenomData) {
          return this.normalizeLoadedTemplate(prenomData, prenomData.template, prenomData.moduleUrl);
      };
      /**
       * @param {?} prenomData
       * @return {?}
       */
      DirectiveNormalizer.prototype.normalizeTemplateAsync = function (prenomData) {
          var _this = this;
          var /** @type {?} */ templateUrl = this._urlResolver.resolve(prenomData.moduleUrl, prenomData.templateUrl);
          return this._fetch(templateUrl)
              .then(function (value) { return _this.normalizeLoadedTemplate(prenomData, value, templateUrl); });
      };
      /**
       * @param {?} prenomData
       * @param {?} template
       * @param {?} templateAbsUrl
       * @return {?}
       */
      DirectiveNormalizer.prototype.normalizeLoadedTemplate = function (prenomData, template, templateAbsUrl) {
          var /** @type {?} */ interpolationConfig = InterpolationConfig.fromArray(prenomData.interpolation);
          var /** @type {?} */ rootNodesAndErrors = this._htmlParser.parse(template, stringify(prenomData.componentType), false, interpolationConfig);
          if (rootNodesAndErrors.errors.length > 0) {
              var /** @type {?} */ errorString = rootNodesAndErrors.errors.join('\n');
              throw new Error("Template parse errors:\n" + errorString);
          }
          var /** @type {?} */ templateMetadataStyles = this.normalizeStylesheet(new CompileStylesheetMetadata({
              styles: prenomData.styles,
              styleUrls: prenomData.styleUrls,
              moduleUrl: prenomData.moduleUrl
          }));
          var /** @type {?} */ visitor = new TemplatePreparseVisitor();
          visitAll(visitor, rootNodesAndErrors.rootNodes);
          var /** @type {?} */ templateStyles = this.normalizeStylesheet(new CompileStylesheetMetadata({ styles: visitor.styles, styleUrls: visitor.styleUrls, moduleUrl: templateAbsUrl }));
          var /** @type {?} */ encapsulation = prenomData.encapsulation;
          if (isBlank(encapsulation)) {
              encapsulation = this._config.defaultEncapsulation;
          }
          var /** @type {?} */ styles = templateMetadataStyles.styles.concat(templateStyles.styles);
          var /** @type {?} */ styleUrls = templateMetadataStyles.styleUrls.concat(templateStyles.styleUrls);
          if (encapsulation === _angular_core.ViewEncapsulation.Emulated && styles.length === 0 &&
              styleUrls.length === 0) {
              encapsulation = _angular_core.ViewEncapsulation.None;
          }
          return new CompileTemplateMetadata({
              encapsulation: encapsulation,
              template: template,
              templateUrl: templateAbsUrl, styles: styles, styleUrls: styleUrls,
              ngContentSelectors: visitor.ngContentSelectors,
              animations: prenomData.animations,
              interpolation: prenomData.interpolation,
          });
      };
      /**
       * @param {?} templateMeta
       * @return {?}
       */
      DirectiveNormalizer.prototype.normalizeExternalStylesheets = function (templateMeta) {
          return this._loadMissingExternalStylesheets(templateMeta.styleUrls)
              .then(function (externalStylesheets) { return new CompileTemplateMetadata({
              encapsulation: templateMeta.encapsulation,
              template: templateMeta.template,
              templateUrl: templateMeta.templateUrl,
              styles: templateMeta.styles,
              styleUrls: templateMeta.styleUrls,
              externalStylesheets: externalStylesheets,
              ngContentSelectors: templateMeta.ngContentSelectors,
              animations: templateMeta.animations,
              interpolation: templateMeta.interpolation
          }); });
      };
      /**
       * @param {?} styleUrls
       * @param {?=} loadedStylesheets
       * @return {?}
       */
      DirectiveNormalizer.prototype._loadMissingExternalStylesheets = function (styleUrls, loadedStylesheets) {
          var _this = this;
          if (loadedStylesheets === void 0) { loadedStylesheets = new Map(); }
          return Promise
              .all(styleUrls.filter(function (styleUrl) { return !loadedStylesheets.has(styleUrl); })
              .map(function (styleUrl) { return _this._fetch(styleUrl).then(function (loadedStyle) {
              var /** @type {?} */ stylesheet = _this.normalizeStylesheet(new CompileStylesheetMetadata({ styles: [loadedStyle], moduleUrl: styleUrl }));
              loadedStylesheets.set(styleUrl, stylesheet);
              return _this._loadMissingExternalStylesheets(stylesheet.styleUrls, loadedStylesheets);
          }); }))
              .then(function (_) { return Array.from(loadedStylesheets.values()); });
      };
      /**
       * @param {?} stylesheet
       * @return {?}
       */
      DirectiveNormalizer.prototype.normalizeStylesheet = function (stylesheet) {
          var _this = this;
          var /** @type {?} */ allStyleUrls = stylesheet.styleUrls.filter(isStyleUrlResolvable)
              .map(function (url) { return _this._urlResolver.resolve(stylesheet.moduleUrl, url); });
          var /** @type {?} */ allStyles = stylesheet.styles.map(function (style) {
              var /** @type {?} */ styleWithImports = extractStyleUrls(_this._urlResolver, stylesheet.moduleUrl, style);
              allStyleUrls.push.apply(allStyleUrls, styleWithImports.styleUrls);
              return styleWithImports.style;
          });
          return new CompileStylesheetMetadata({ styles: allStyles, styleUrls: allStyleUrls, moduleUrl: stylesheet.moduleUrl });
      };
      DirectiveNormalizer.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      DirectiveNormalizer.ctorParameters = function () { return [
          { type: ResourceLoader, },
          { type: UrlResolver, },
          { type: HtmlParser, },
          { type: CompilerConfig, },
      ]; };
      return DirectiveNormalizer;
  }());
  var TemplatePreparseVisitor = (function () {
      function TemplatePreparseVisitor() {
          this.ngContentSelectors = [];
          this.styles = [];
          this.styleUrls = [];
          this.ngNonBindableStackCount = 0;
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      TemplatePreparseVisitor.prototype.visitElement = function (ast, context) {
          var /** @type {?} */ preparsedElement = preparseElement(ast);
          switch (preparsedElement.type) {
              case PreparsedElementType.NG_CONTENT:
                  if (this.ngNonBindableStackCount === 0) {
                      this.ngContentSelectors.push(preparsedElement.selectAttr);
                  }
                  break;
              case PreparsedElementType.STYLE:
                  var /** @type {?} */ textContent_1 = '';
                  ast.children.forEach(function (child) {
                      if (child instanceof Text) {
                          textContent_1 += child.value;
                      }
                  });
                  this.styles.push(textContent_1);
                  break;
              case PreparsedElementType.STYLESHEET:
                  this.styleUrls.push(preparsedElement.hrefAttr);
                  break;
              default:
                  break;
          }
          if (preparsedElement.nonBindable) {
              this.ngNonBindableStackCount++;
          }
          visitAll(this, ast.children);
          if (preparsedElement.nonBindable) {
              this.ngNonBindableStackCount--;
          }
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      TemplatePreparseVisitor.prototype.visitComment = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      TemplatePreparseVisitor.prototype.visitAttribute = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      TemplatePreparseVisitor.prototype.visitText = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      TemplatePreparseVisitor.prototype.visitExpansion = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      TemplatePreparseVisitor.prototype.visitExpansionCase = function (ast, context) { return null; };
      return TemplatePreparseVisitor;
  }());

  /*
   * Resolve a `Type` for {@link Directive}.
   *
   * This interface can be overridden by the application developer to create custom behavior.
   *
   * See {@link Compiler}
   */
  var DirectiveResolver = (function () {
      /**
       * @param {?=} _reflector
       */
      function DirectiveResolver(_reflector) {
          if (_reflector === void 0) { _reflector = reflector; }
          this._reflector = _reflector;
      }
      /**
       * @param {?} type
       * @return {?}
       */
      DirectiveResolver.prototype.isDirective = function (type) {
          var /** @type {?} */ typeMetadata = this._reflector.annotations(_angular_core.resolveForwardRef(type));
          return typeMetadata && typeMetadata.some(isDirectiveMetadata);
      };
      /**
       *  Return {@link Directive} for a given `Type`.
       * @param {?} type
       * @param {?=} throwIfNotFound
       * @return {?}
       */
      DirectiveResolver.prototype.resolve = function (type, throwIfNotFound) {
          if (throwIfNotFound === void 0) { throwIfNotFound = true; }
          var /** @type {?} */ typeMetadata = this._reflector.annotations(_angular_core.resolveForwardRef(type));
          if (typeMetadata) {
              var /** @type {?} */ metadata = typeMetadata.find(isDirectiveMetadata);
              if (metadata) {
                  var /** @type {?} */ propertyMetadata = this._reflector.propMetadata(type);
                  return this._mergeWithPropertyMetadata(metadata, propertyMetadata, type);
              }
          }
          if (throwIfNotFound) {
              throw new Error("No Directive annotation found on " + stringify(type));
          }
          return null;
      };
      /**
       * @param {?} dm
       * @param {?} propertyMetadata
       * @param {?} directiveType
       * @return {?}
       */
      DirectiveResolver.prototype._mergeWithPropertyMetadata = function (dm, propertyMetadata, directiveType) {
          var /** @type {?} */ inputs = [];
          var /** @type {?} */ outputs = [];
          var /** @type {?} */ host = {};
          var /** @type {?} */ queries = {};
          Object.keys(propertyMetadata).forEach(function (propName) {
              propertyMetadata[propName].forEach(function (a) {
                  if (a instanceof _angular_core.Input) {
                      if (a.bindingPropertyName) {
                          inputs.push(propName + ": " + a.bindingPropertyName);
                      }
                      else {
                          inputs.push(propName);
                      }
                  }
                  else if (a instanceof _angular_core.Output) {
                      var /** @type {?} */ output = a;
                      if (output.bindingPropertyName) {
                          outputs.push(propName + ": " + output.bindingPropertyName);
                      }
                      else {
                          outputs.push(propName);
                      }
                  }
                  else if (a instanceof _angular_core.HostBinding) {
                      var /** @type {?} */ hostBinding = a;
                      if (hostBinding.hostPropertyName) {
                          var /** @type {?} */ startWith = hostBinding.hostPropertyName[0];
                          if (startWith === '(') {
                              throw new Error("@HostBinding can not bind to events. Use @HostListener instead.");
                          }
                          else if (startWith === '[') {
                              throw new Error("@HostBinding parameter should be a property name, 'class.<name>', or 'attr.<name>'.");
                          }
                          host[("[" + hostBinding.hostPropertyName + "]")] = propName;
                      }
                      else {
                          host[("[" + propName + "]")] = propName;
                      }
                  }
                  else if (a instanceof _angular_core.HostListener) {
                      var /** @type {?} */ hostListener = a;
                      var /** @type {?} */ args = hostListener.args || [];
                      host[("(" + hostListener.eventName + ")")] = propName + "(" + args.join(',') + ")";
                  }
                  else if (a instanceof _angular_core.Query) {
                      queries[propName] = a;
                  }
              });
          });
          return this._merge(dm, inputs, outputs, host, queries, directiveType);
      };
      /**
       * @param {?} def
       * @return {?}
       */
      DirectiveResolver.prototype._extractPublicName = function (def) { return splitAtColon(def, [null, def])[1].trim(); };
      /**
       * @param {?} directive
       * @param {?} inputs
       * @param {?} outputs
       * @param {?} host
       * @param {?} queries
       * @param {?} directiveType
       * @return {?}
       */
      DirectiveResolver.prototype._merge = function (directive, inputs, outputs, host, queries, directiveType) {
          var _this = this;
          var /** @type {?} */ mergedInputs = inputs;
          if (directive.inputs) {
              var /** @type {?} */ inputNames_1 = directive.inputs.map(function (def) { return _this._extractPublicName(def); });
              inputs.forEach(function (inputDef) {
                  var /** @type {?} */ publicName = _this._extractPublicName(inputDef);
                  if (inputNames_1.indexOf(publicName) > -1) {
                      throw new Error("Input '" + publicName + "' defined multiple times in '" + stringify(directiveType) + "'");
                  }
              });
              mergedInputs.unshift.apply(mergedInputs, directive.inputs);
          }
          var /** @type {?} */ mergedOutputs = outputs;
          if (directive.outputs) {
              var /** @type {?} */ outputNames_1 = directive.outputs.map(function (def) { return _this._extractPublicName(def); });
              outputs.forEach(function (outputDef) {
                  var /** @type {?} */ publicName = _this._extractPublicName(outputDef);
                  if (outputNames_1.indexOf(publicName) > -1) {
                      throw new Error("Output event '" + publicName + "' defined multiple times in '" + stringify(directiveType) + "'");
                  }
              });
              mergedOutputs.unshift.apply(mergedOutputs, directive.outputs);
          }
          var /** @type {?} */ mergedHost = directive.host ? StringMapWrapper.merge(directive.host, host) : host;
          var /** @type {?} */ mergedQueries = directive.queries ? StringMapWrapper.merge(directive.queries, queries) : queries;
          if (directive instanceof _angular_core.Component) {
              return new _angular_core.Component({
                  selector: directive.selector,
                  inputs: mergedInputs,
                  outputs: mergedOutputs,
                  host: mergedHost,
                  exportAs: directive.exportAs,
                  moduleId: directive.moduleId,
                  queries: mergedQueries,
                  changeDetection: directive.changeDetection,
                  providers: directive.providers,
                  viewProviders: directive.viewProviders,
                  entryComponents: directive.entryComponents,
                  template: directive.template,
                  templateUrl: directive.templateUrl,
                  styles: directive.styles,
                  styleUrls: directive.styleUrls,
                  encapsulation: directive.encapsulation,
                  animations: directive.animations,
                  interpolation: directive.interpolation
              });
          }
          else {
              return new _angular_core.Directive({
                  selector: directive.selector,
                  inputs: mergedInputs,
                  outputs: mergedOutputs,
                  host: mergedHost,
                  exportAs: directive.exportAs,
                  queries: mergedQueries,
                  providers: directive.providers
              });
          }
      };
      DirectiveResolver.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      DirectiveResolver.ctorParameters = function () { return [
          { type: ReflectorReader, },
      ]; };
      return DirectiveResolver;
  }());
  /**
   * @param {?} type
   * @return {?}
   */
  function isDirectiveMetadata(type) {
      return type instanceof _angular_core.Directive;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$15 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var TypeModifier = {};
  TypeModifier.Const = 0;
  TypeModifier[TypeModifier.Const] = "Const";
  /**
   * @abstract
   */
  var Type$1 = (function () {
      /**
       * @param {?=} modifiers
       */
      function Type(modifiers) {
          if (modifiers === void 0) { modifiers = null; }
          this.modifiers = modifiers;
          if (!modifiers) {
              this.modifiers = [];
          }
      }
      /**
       * @abstract
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Type.prototype.visitType = function (visitor, context) { };
      /**
       * @param {?} modifier
       * @return {?}
       */
      Type.prototype.hasModifier = function (modifier) { return this.modifiers.indexOf(modifier) !== -1; };
      return Type;
  }());
  var BuiltinTypeName = {};
  BuiltinTypeName.Dynamic = 0;
  BuiltinTypeName.Bool = 1;
  BuiltinTypeName.String = 2;
  BuiltinTypeName.Int = 3;
  BuiltinTypeName.Number = 4;
  BuiltinTypeName.Function = 5;
  BuiltinTypeName.Null = 6;
  BuiltinTypeName[BuiltinTypeName.Dynamic] = "Dynamic";
  BuiltinTypeName[BuiltinTypeName.Bool] = "Bool";
  BuiltinTypeName[BuiltinTypeName.String] = "String";
  BuiltinTypeName[BuiltinTypeName.Int] = "Int";
  BuiltinTypeName[BuiltinTypeName.Number] = "Number";
  BuiltinTypeName[BuiltinTypeName.Function] = "Function";
  BuiltinTypeName[BuiltinTypeName.Null] = "Null";
  var BuiltinType = (function (_super) {
      __extends$15(BuiltinType, _super);
      /**
       * @param {?} name
       * @param {?=} modifiers
       */
      function BuiltinType(name, modifiers) {
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, modifiers);
          this.name = name;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      BuiltinType.prototype.visitType = function (visitor, context) {
          return visitor.visitBuiltintType(this, context);
      };
      return BuiltinType;
  }(Type$1));
  var ExternalType = (function (_super) {
      __extends$15(ExternalType, _super);
      /**
       * @param {?} value
       * @param {?=} typeParams
       * @param {?=} modifiers
       */
      function ExternalType(value, typeParams, modifiers) {
          if (typeParams === void 0) { typeParams = null; }
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, modifiers);
          this.value = value;
          this.typeParams = typeParams;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ExternalType.prototype.visitType = function (visitor, context) {
          return visitor.visitExternalType(this, context);
      };
      return ExternalType;
  }(Type$1));
  var ArrayType = (function (_super) {
      __extends$15(ArrayType, _super);
      /**
       * @param {?} of
       * @param {?=} modifiers
       */
      function ArrayType(of, modifiers) {
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, modifiers);
          this.of = of;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ArrayType.prototype.visitType = function (visitor, context) {
          return visitor.visitArrayType(this, context);
      };
      return ArrayType;
  }(Type$1));
  var MapType = (function (_super) {
      __extends$15(MapType, _super);
      /**
       * @param {?} valueType
       * @param {?=} modifiers
       */
      function MapType(valueType, modifiers) {
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, modifiers);
          this.valueType = valueType;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      MapType.prototype.visitType = function (visitor, context) { return visitor.visitMapType(this, context); };
      return MapType;
  }(Type$1));
  var /** @type {?} */ DYNAMIC_TYPE = new BuiltinType(BuiltinTypeName.Dynamic);
  var /** @type {?} */ BOOL_TYPE = new BuiltinType(BuiltinTypeName.Bool);
  var /** @type {?} */ INT_TYPE = new BuiltinType(BuiltinTypeName.Int);
  var /** @type {?} */ NUMBER_TYPE = new BuiltinType(BuiltinTypeName.Number);
  var /** @type {?} */ STRING_TYPE = new BuiltinType(BuiltinTypeName.String);
  var /** @type {?} */ FUNCTION_TYPE = new BuiltinType(BuiltinTypeName.Function);
  var /** @type {?} */ NULL_TYPE = new BuiltinType(BuiltinTypeName.Null);
  var BinaryOperator = {};
  BinaryOperator.Equals = 0;
  BinaryOperator.NotEquals = 1;
  BinaryOperator.Identical = 2;
  BinaryOperator.NotIdentical = 3;
  BinaryOperator.Minus = 4;
  BinaryOperator.Plus = 5;
  BinaryOperator.Divide = 6;
  BinaryOperator.Multiply = 7;
  BinaryOperator.Modulo = 8;
  BinaryOperator.And = 9;
  BinaryOperator.Or = 10;
  BinaryOperator.Lower = 11;
  BinaryOperator.LowerEquals = 12;
  BinaryOperator.Bigger = 13;
  BinaryOperator.BiggerEquals = 14;
  BinaryOperator[BinaryOperator.Equals] = "Equals";
  BinaryOperator[BinaryOperator.NotEquals] = "NotEquals";
  BinaryOperator[BinaryOperator.Identical] = "Identical";
  BinaryOperator[BinaryOperator.NotIdentical] = "NotIdentical";
  BinaryOperator[BinaryOperator.Minus] = "Minus";
  BinaryOperator[BinaryOperator.Plus] = "Plus";
  BinaryOperator[BinaryOperator.Divide] = "Divide";
  BinaryOperator[BinaryOperator.Multiply] = "Multiply";
  BinaryOperator[BinaryOperator.Modulo] = "Modulo";
  BinaryOperator[BinaryOperator.And] = "And";
  BinaryOperator[BinaryOperator.Or] = "Or";
  BinaryOperator[BinaryOperator.Lower] = "Lower";
  BinaryOperator[BinaryOperator.LowerEquals] = "LowerEquals";
  BinaryOperator[BinaryOperator.Bigger] = "Bigger";
  BinaryOperator[BinaryOperator.BiggerEquals] = "BiggerEquals";
  /**
   * @abstract
   */
  var Expression = (function () {
      /**
       * @param {?} type
       */
      function Expression(type) {
          this.type = type;
      }
      /**
       * @abstract
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Expression.prototype.visitExpression = function (visitor, context) { };
      /**
       * @param {?} name
       * @return {?}
       */
      Expression.prototype.prop = function (name) { return new ReadPropExpr(this, name); };
      /**
       * @param {?} index
       * @param {?=} type
       * @return {?}
       */
      Expression.prototype.key = function (index, type) {
          if (type === void 0) { type = null; }
          return new ReadKeyExpr(this, index, type);
      };
      /**
       * @param {?} name
       * @param {?} params
       * @return {?}
       */
      Expression.prototype.callMethod = function (name, params) {
          return new InvokeMethodExpr(this, name, params);
      };
      /**
       * @param {?} params
       * @return {?}
       */
      Expression.prototype.callFn = function (params) { return new InvokeFunctionExpr(this, params); };
      /**
       * @param {?} params
       * @param {?=} type
       * @return {?}
       */
      Expression.prototype.instantiate = function (params, type) {
          if (type === void 0) { type = null; }
          return new InstantiateExpr(this, params, type);
      };
      /**
       * @param {?} trueCase
       * @param {?=} falseCase
       * @return {?}
       */
      Expression.prototype.conditional = function (trueCase, falseCase) {
          if (falseCase === void 0) { falseCase = null; }
          return new ConditionalExpr(this, trueCase, falseCase);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.equals = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Equals, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.notEquals = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.NotEquals, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.identical = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Identical, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.notIdentical = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.NotIdentical, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.minus = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Minus, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.plus = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Plus, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.divide = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Divide, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.multiply = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Multiply, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.modulo = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Modulo, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.and = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.And, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.or = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Or, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.lower = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Lower, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.lowerEquals = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.LowerEquals, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.bigger = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.Bigger, this, rhs);
      };
      /**
       * @param {?} rhs
       * @return {?}
       */
      Expression.prototype.biggerEquals = function (rhs) {
          return new BinaryOperatorExpr(BinaryOperator.BiggerEquals, this, rhs);
      };
      /**
       * @return {?}
       */
      Expression.prototype.isBlank = function () {
          // Note: We use equals by purpose here to compare to null and undefined in JS.
          // We use the typed null to allow strictNullChecks to narrow types.
          return this.equals(TYPED_NULL_EXPR);
      };
      /**
       * @param {?} type
       * @return {?}
       */
      Expression.prototype.cast = function (type) { return new CastExpr(this, type); };
      /**
       * @return {?}
       */
      Expression.prototype.toStmt = function () { return new ExpressionStatement(this); };
      return Expression;
  }());
  var BuiltinVar = {};
  BuiltinVar.This = 0;
  BuiltinVar.Super = 1;
  BuiltinVar.CatchError = 2;
  BuiltinVar.CatchStack = 3;
  BuiltinVar[BuiltinVar.This] = "This";
  BuiltinVar[BuiltinVar.Super] = "Super";
  BuiltinVar[BuiltinVar.CatchError] = "CatchError";
  BuiltinVar[BuiltinVar.CatchStack] = "CatchStack";
  var ReadVarExpr = (function (_super) {
      __extends$15(ReadVarExpr, _super);
      /**
       * @param {?} name
       * @param {?=} type
       */
      function ReadVarExpr(name, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          if (typeof name === 'string') {
              this.name = name;
              this.builtin = null;
          }
          else {
              this.name = null;
              this.builtin = name;
          }
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ReadVarExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitReadVarExpr(this, context);
      };
      /**
       * @param {?} value
       * @return {?}
       */
      ReadVarExpr.prototype.set = function (value) { return new WriteVarExpr(this.name, value); };
      return ReadVarExpr;
  }(Expression));
  var WriteVarExpr = (function (_super) {
      __extends$15(WriteVarExpr, _super);
      /**
       * @param {?} name
       * @param {?} value
       * @param {?=} type
       */
      function WriteVarExpr(name, value, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type || value.type);
          this.name = name;
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      WriteVarExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitWriteVarExpr(this, context);
      };
      /**
       * @param {?=} type
       * @param {?=} modifiers
       * @return {?}
       */
      WriteVarExpr.prototype.toDeclStmt = function (type, modifiers) {
          if (type === void 0) { type = null; }
          if (modifiers === void 0) { modifiers = null; }
          return new DeclareVarStmt(this.name, this.value, type, modifiers);
      };
      return WriteVarExpr;
  }(Expression));
  var WriteKeyExpr = (function (_super) {
      __extends$15(WriteKeyExpr, _super);
      /**
       * @param {?} receiver
       * @param {?} index
       * @param {?} value
       * @param {?=} type
       */
      function WriteKeyExpr(receiver, index, value, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type || value.type);
          this.receiver = receiver;
          this.index = index;
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      WriteKeyExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitWriteKeyExpr(this, context);
      };
      return WriteKeyExpr;
  }(Expression));
  var WritePropExpr = (function (_super) {
      __extends$15(WritePropExpr, _super);
      /**
       * @param {?} receiver
       * @param {?} name
       * @param {?} value
       * @param {?=} type
       */
      function WritePropExpr(receiver, name, value, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type || value.type);
          this.receiver = receiver;
          this.name = name;
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      WritePropExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitWritePropExpr(this, context);
      };
      return WritePropExpr;
  }(Expression));
  var BuiltinMethod = {};
  BuiltinMethod.ConcatArray = 0;
  BuiltinMethod.SubscribeObservable = 1;
  BuiltinMethod.Bind = 2;
  BuiltinMethod[BuiltinMethod.ConcatArray] = "ConcatArray";
  BuiltinMethod[BuiltinMethod.SubscribeObservable] = "SubscribeObservable";
  BuiltinMethod[BuiltinMethod.Bind] = "Bind";
  var InvokeMethodExpr = (function (_super) {
      __extends$15(InvokeMethodExpr, _super);
      /**
       * @param {?} receiver
       * @param {?} method
       * @param {?} args
       * @param {?=} type
       */
      function InvokeMethodExpr(receiver, method, args, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.receiver = receiver;
          this.args = args;
          if (typeof method === 'string') {
              this.name = method;
              this.builtin = null;
          }
          else {
              this.name = null;
              this.builtin = method;
          }
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      InvokeMethodExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitInvokeMethodExpr(this, context);
      };
      return InvokeMethodExpr;
  }(Expression));
  var InvokeFunctionExpr = (function (_super) {
      __extends$15(InvokeFunctionExpr, _super);
      /**
       * @param {?} fn
       * @param {?} args
       * @param {?=} type
       */
      function InvokeFunctionExpr(fn, args, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.fn = fn;
          this.args = args;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      InvokeFunctionExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitInvokeFunctionExpr(this, context);
      };
      return InvokeFunctionExpr;
  }(Expression));
  var InstantiateExpr = (function (_super) {
      __extends$15(InstantiateExpr, _super);
      /**
       * @param {?} classExpr
       * @param {?} args
       * @param {?=} type
       */
      function InstantiateExpr(classExpr, args, type) {
          _super.call(this, type);
          this.classExpr = classExpr;
          this.args = args;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      InstantiateExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitInstantiateExpr(this, context);
      };
      return InstantiateExpr;
  }(Expression));
  var LiteralExpr = (function (_super) {
      __extends$15(LiteralExpr, _super);
      /**
       * @param {?} value
       * @param {?=} type
       */
      function LiteralExpr(value, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      LiteralExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitLiteralExpr(this, context);
      };
      return LiteralExpr;
  }(Expression));
  var ExternalExpr = (function (_super) {
      __extends$15(ExternalExpr, _super);
      /**
       * @param {?} value
       * @param {?=} type
       * @param {?=} typeParams
       */
      function ExternalExpr(value, type, typeParams) {
          if (type === void 0) { type = null; }
          if (typeParams === void 0) { typeParams = null; }
          _super.call(this, type);
          this.value = value;
          this.typeParams = typeParams;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ExternalExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitExternalExpr(this, context);
      };
      return ExternalExpr;
  }(Expression));
  var ConditionalExpr = (function (_super) {
      __extends$15(ConditionalExpr, _super);
      /**
       * @param {?} condition
       * @param {?} trueCase
       * @param {?=} falseCase
       * @param {?=} type
       */
      function ConditionalExpr(condition, trueCase, falseCase, type) {
          if (falseCase === void 0) { falseCase = null; }
          if (type === void 0) { type = null; }
          _super.call(this, type || trueCase.type);
          this.condition = condition;
          this.falseCase = falseCase;
          this.trueCase = trueCase;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ConditionalExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitConditionalExpr(this, context);
      };
      return ConditionalExpr;
  }(Expression));
  var NotExpr = (function (_super) {
      __extends$15(NotExpr, _super);
      /**
       * @param {?} condition
       */
      function NotExpr(condition) {
          _super.call(this, BOOL_TYPE);
          this.condition = condition;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      NotExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitNotExpr(this, context);
      };
      return NotExpr;
  }(Expression));
  var CastExpr = (function (_super) {
      __extends$15(CastExpr, _super);
      /**
       * @param {?} value
       * @param {?} type
       */
      function CastExpr(value, type) {
          _super.call(this, type);
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      CastExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitCastExpr(this, context);
      };
      return CastExpr;
  }(Expression));
  var FnParam = (function () {
      /**
       * @param {?} name
       * @param {?=} type
       */
      function FnParam(name, type) {
          if (type === void 0) { type = null; }
          this.name = name;
          this.type = type;
      }
      return FnParam;
  }());
  var FunctionExpr = (function (_super) {
      __extends$15(FunctionExpr, _super);
      /**
       * @param {?} params
       * @param {?} statements
       * @param {?=} type
       */
      function FunctionExpr(params, statements, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.params = params;
          this.statements = statements;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      FunctionExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitFunctionExpr(this, context);
      };
      /**
       * @param {?} name
       * @param {?=} modifiers
       * @return {?}
       */
      FunctionExpr.prototype.toDeclStmt = function (name, modifiers) {
          if (modifiers === void 0) { modifiers = null; }
          return new DeclareFunctionStmt(name, this.params, this.statements, this.type, modifiers);
      };
      return FunctionExpr;
  }(Expression));
  var BinaryOperatorExpr = (function (_super) {
      __extends$15(BinaryOperatorExpr, _super);
      /**
       * @param {?} operator
       * @param {?} lhs
       * @param {?} rhs
       * @param {?=} type
       */
      function BinaryOperatorExpr(operator, lhs, rhs, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type || lhs.type);
          this.operator = operator;
          this.rhs = rhs;
          this.lhs = lhs;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      BinaryOperatorExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitBinaryOperatorExpr(this, context);
      };
      return BinaryOperatorExpr;
  }(Expression));
  var ReadPropExpr = (function (_super) {
      __extends$15(ReadPropExpr, _super);
      /**
       * @param {?} receiver
       * @param {?} name
       * @param {?=} type
       */
      function ReadPropExpr(receiver, name, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.receiver = receiver;
          this.name = name;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ReadPropExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitReadPropExpr(this, context);
      };
      /**
       * @param {?} value
       * @return {?}
       */
      ReadPropExpr.prototype.set = function (value) {
          return new WritePropExpr(this.receiver, this.name, value);
      };
      return ReadPropExpr;
  }(Expression));
  var ReadKeyExpr = (function (_super) {
      __extends$15(ReadKeyExpr, _super);
      /**
       * @param {?} receiver
       * @param {?} index
       * @param {?=} type
       */
      function ReadKeyExpr(receiver, index, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.receiver = receiver;
          this.index = index;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ReadKeyExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitReadKeyExpr(this, context);
      };
      /**
       * @param {?} value
       * @return {?}
       */
      ReadKeyExpr.prototype.set = function (value) {
          return new WriteKeyExpr(this.receiver, this.index, value);
      };
      return ReadKeyExpr;
  }(Expression));
  var LiteralArrayExpr = (function (_super) {
      __extends$15(LiteralArrayExpr, _super);
      /**
       * @param {?} entries
       * @param {?=} type
       */
      function LiteralArrayExpr(entries, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.entries = entries;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      LiteralArrayExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitLiteralArrayExpr(this, context);
      };
      return LiteralArrayExpr;
  }(Expression));
  var LiteralMapExpr = (function (_super) {
      __extends$15(LiteralMapExpr, _super);
      /**
       * @param {?} entries
       * @param {?=} type
       */
      function LiteralMapExpr(entries, type) {
          if (type === void 0) { type = null; }
          _super.call(this, type);
          this.entries = entries;
          this.valueType = null;
          if (isPresent(type)) {
              this.valueType = type.valueType;
          }
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      LiteralMapExpr.prototype.visitExpression = function (visitor, context) {
          return visitor.visitLiteralMapExpr(this, context);
      };
      return LiteralMapExpr;
  }(Expression));
  var /** @type {?} */ THIS_EXPR = new ReadVarExpr(BuiltinVar.This);
  var /** @type {?} */ SUPER_EXPR = new ReadVarExpr(BuiltinVar.Super);
  var /** @type {?} */ CATCH_ERROR_VAR = new ReadVarExpr(BuiltinVar.CatchError);
  var /** @type {?} */ CATCH_STACK_VAR = new ReadVarExpr(BuiltinVar.CatchStack);
  var /** @type {?} */ NULL_EXPR = new LiteralExpr(null, null);
  var /** @type {?} */ TYPED_NULL_EXPR = new LiteralExpr(null, NULL_TYPE);
  var StmtModifier = {};
  StmtModifier.Final = 0;
  StmtModifier.Private = 1;
  StmtModifier[StmtModifier.Final] = "Final";
  StmtModifier[StmtModifier.Private] = "Private";
  /**
   * @abstract
   */
  var Statement = (function () {
      /**
       * @param {?=} modifiers
       */
      function Statement(modifiers) {
          if (modifiers === void 0) { modifiers = null; }
          this.modifiers = modifiers;
          if (!modifiers) {
              this.modifiers = [];
          }
      }
      /**
       * @abstract
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      Statement.prototype.visitStatement = function (visitor, context) { };
      /**
       * @param {?} modifier
       * @return {?}
       */
      Statement.prototype.hasModifier = function (modifier) { return this.modifiers.indexOf(modifier) !== -1; };
      return Statement;
  }());
  var DeclareVarStmt = (function (_super) {
      __extends$15(DeclareVarStmt, _super);
      /**
       * @param {?} name
       * @param {?} value
       * @param {?=} type
       * @param {?=} modifiers
       */
      function DeclareVarStmt(name, value, type, modifiers) {
          if (type === void 0) { type = null; }
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, modifiers);
          this.name = name;
          this.value = value;
          this.type = type || value.type;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      DeclareVarStmt.prototype.visitStatement = function (visitor, context) {
          return visitor.visitDeclareVarStmt(this, context);
      };
      return DeclareVarStmt;
  }(Statement));
  var DeclareFunctionStmt = (function (_super) {
      __extends$15(DeclareFunctionStmt, _super);
      /**
       * @param {?} name
       * @param {?} params
       * @param {?} statements
       * @param {?=} type
       * @param {?=} modifiers
       */
      function DeclareFunctionStmt(name, params, statements, type, modifiers) {
          if (type === void 0) { type = null; }
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, modifiers);
          this.name = name;
          this.params = params;
          this.statements = statements;
          this.type = type;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      DeclareFunctionStmt.prototype.visitStatement = function (visitor, context) {
          return visitor.visitDeclareFunctionStmt(this, context);
      };
      return DeclareFunctionStmt;
  }(Statement));
  var ExpressionStatement = (function (_super) {
      __extends$15(ExpressionStatement, _super);
      /**
       * @param {?} expr
       */
      function ExpressionStatement(expr) {
          _super.call(this);
          this.expr = expr;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ExpressionStatement.prototype.visitStatement = function (visitor, context) {
          return visitor.visitExpressionStmt(this, context);
      };
      return ExpressionStatement;
  }(Statement));
  var ReturnStatement = (function (_super) {
      __extends$15(ReturnStatement, _super);
      /**
       * @param {?} value
       */
      function ReturnStatement(value) {
          _super.call(this);
          this.value = value;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ReturnStatement.prototype.visitStatement = function (visitor, context) {
          return visitor.visitReturnStmt(this, context);
      };
      return ReturnStatement;
  }(Statement));
  var AbstractClassPart = (function () {
      /**
       * @param {?=} type
       * @param {?} modifiers
       */
      function AbstractClassPart(type, modifiers) {
          if (type === void 0) { type = null; }
          this.type = type;
          this.modifiers = modifiers;
          if (!modifiers) {
              this.modifiers = [];
          }
      }
      /**
       * @param {?} modifier
       * @return {?}
       */
      AbstractClassPart.prototype.hasModifier = function (modifier) { return this.modifiers.indexOf(modifier) !== -1; };
      return AbstractClassPart;
  }());
  var ClassField = (function (_super) {
      __extends$15(ClassField, _super);
      /**
       * @param {?} name
       * @param {?=} type
       * @param {?=} modifiers
       */
      function ClassField(name, type, modifiers) {
          if (type === void 0) { type = null; }
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, type, modifiers);
          this.name = name;
      }
      return ClassField;
  }(AbstractClassPart));
  var ClassMethod = (function (_super) {
      __extends$15(ClassMethod, _super);
      /**
       * @param {?} name
       * @param {?} params
       * @param {?} body
       * @param {?=} type
       * @param {?=} modifiers
       */
      function ClassMethod(name, params, body, type, modifiers) {
          if (type === void 0) { type = null; }
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, type, modifiers);
          this.name = name;
          this.params = params;
          this.body = body;
      }
      return ClassMethod;
  }(AbstractClassPart));
  var ClassGetter = (function (_super) {
      __extends$15(ClassGetter, _super);
      /**
       * @param {?} name
       * @param {?} body
       * @param {?=} type
       * @param {?=} modifiers
       */
      function ClassGetter(name, body, type, modifiers) {
          if (type === void 0) { type = null; }
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, type, modifiers);
          this.name = name;
          this.body = body;
      }
      return ClassGetter;
  }(AbstractClassPart));
  var ClassStmt = (function (_super) {
      __extends$15(ClassStmt, _super);
      /**
       * @param {?} name
       * @param {?} parent
       * @param {?} fields
       * @param {?} getters
       * @param {?} constructorMethod
       * @param {?} methods
       * @param {?=} modifiers
       */
      function ClassStmt(name, parent, fields, getters, constructorMethod, methods, modifiers) {
          if (modifiers === void 0) { modifiers = null; }
          _super.call(this, modifiers);
          this.name = name;
          this.parent = parent;
          this.fields = fields;
          this.getters = getters;
          this.constructorMethod = constructorMethod;
          this.methods = methods;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ClassStmt.prototype.visitStatement = function (visitor, context) {
          return visitor.visitDeclareClassStmt(this, context);
      };
      return ClassStmt;
  }(Statement));
  var IfStmt = (function (_super) {
      __extends$15(IfStmt, _super);
      /**
       * @param {?} condition
       * @param {?} trueCase
       * @param {?=} falseCase
       */
      function IfStmt(condition, trueCase, falseCase) {
          if (falseCase === void 0) { falseCase = []; }
          _super.call(this);
          this.condition = condition;
          this.trueCase = trueCase;
          this.falseCase = falseCase;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      IfStmt.prototype.visitStatement = function (visitor, context) {
          return visitor.visitIfStmt(this, context);
      };
      return IfStmt;
  }(Statement));
  var CommentStmt = (function (_super) {
      __extends$15(CommentStmt, _super);
      /**
       * @param {?} comment
       */
      function CommentStmt(comment) {
          _super.call(this);
          this.comment = comment;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      CommentStmt.prototype.visitStatement = function (visitor, context) {
          return visitor.visitCommentStmt(this, context);
      };
      return CommentStmt;
  }(Statement));
  var TryCatchStmt = (function (_super) {
      __extends$15(TryCatchStmt, _super);
      /**
       * @param {?} bodyStmts
       * @param {?} catchStmts
       */
      function TryCatchStmt(bodyStmts, catchStmts) {
          _super.call(this);
          this.bodyStmts = bodyStmts;
          this.catchStmts = catchStmts;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      TryCatchStmt.prototype.visitStatement = function (visitor, context) {
          return visitor.visitTryCatchStmt(this, context);
      };
      return TryCatchStmt;
  }(Statement));
  var ThrowStmt = (function (_super) {
      __extends$15(ThrowStmt, _super);
      /**
       * @param {?} error
       */
      function ThrowStmt(error) {
          _super.call(this);
          this.error = error;
      }
      /**
       * @param {?} visitor
       * @param {?} context
       * @return {?}
       */
      ThrowStmt.prototype.visitStatement = function (visitor, context) {
          return visitor.visitThrowStmt(this, context);
      };
      return ThrowStmt;
  }(Statement));
  var ExpressionTransformer = (function () {
      function ExpressionTransformer() {
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitReadVarExpr = function (ast, context) { return ast; };
      /**
       * @param {?} expr
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitWriteVarExpr = function (expr, context) {
          return new WriteVarExpr(expr.name, expr.value.visitExpression(this, context));
      };
      /**
       * @param {?} expr
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitWriteKeyExpr = function (expr, context) {
          return new WriteKeyExpr(expr.receiver.visitExpression(this, context), expr.index.visitExpression(this, context), expr.value.visitExpression(this, context));
      };
      /**
       * @param {?} expr
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitWritePropExpr = function (expr, context) {
          return new WritePropExpr(expr.receiver.visitExpression(this, context), expr.name, expr.value.visitExpression(this, context));
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitInvokeMethodExpr = function (ast, context) {
          var /** @type {?} */ method = ast.builtin || ast.name;
          return new InvokeMethodExpr(ast.receiver.visitExpression(this, context), method, this.visitAllExpressions(ast.args, context), ast.type);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitInvokeFunctionExpr = function (ast, context) {
          return new InvokeFunctionExpr(ast.fn.visitExpression(this, context), this.visitAllExpressions(ast.args, context), ast.type);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitInstantiateExpr = function (ast, context) {
          return new InstantiateExpr(ast.classExpr.visitExpression(this, context), this.visitAllExpressions(ast.args, context), ast.type);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitLiteralExpr = function (ast, context) { return ast; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitExternalExpr = function (ast, context) { return ast; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitConditionalExpr = function (ast, context) {
          return new ConditionalExpr(ast.condition.visitExpression(this, context), ast.trueCase.visitExpression(this, context), ast.falseCase.visitExpression(this, context));
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitNotExpr = function (ast, context) {
          return new NotExpr(ast.condition.visitExpression(this, context));
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitCastExpr = function (ast, context) {
          return new CastExpr(ast.value.visitExpression(this, context), context);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitFunctionExpr = function (ast, context) {
          // Don't descend into nested functions
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitBinaryOperatorExpr = function (ast, context) {
          return new BinaryOperatorExpr(ast.operator, ast.lhs.visitExpression(this, context), ast.rhs.visitExpression(this, context), ast.type);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitReadPropExpr = function (ast, context) {
          return new ReadPropExpr(ast.receiver.visitExpression(this, context), ast.name, ast.type);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitReadKeyExpr = function (ast, context) {
          return new ReadKeyExpr(ast.receiver.visitExpression(this, context), ast.index.visitExpression(this, context), ast.type);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitLiteralArrayExpr = function (ast, context) {
          return new LiteralArrayExpr(this.visitAllExpressions(ast.entries, context));
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitLiteralMapExpr = function (ast, context) {
          var _this = this;
          var /** @type {?} */ entries = ast.entries.map(function (entry) { return [entry[0], entry[1].visitExpression(_this, context),]; });
          return new LiteralMapExpr(entries);
      };
      /**
       * @param {?} exprs
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitAllExpressions = function (exprs, context) {
          var _this = this;
          return exprs.map(function (expr) { return expr.visitExpression(_this, context); });
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitDeclareVarStmt = function (stmt, context) {
          return new DeclareVarStmt(stmt.name, stmt.value.visitExpression(this, context), stmt.type, stmt.modifiers);
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitDeclareFunctionStmt = function (stmt, context) {
          // Don't descend into nested functions
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitExpressionStmt = function (stmt, context) {
          return new ExpressionStatement(stmt.expr.visitExpression(this, context));
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitReturnStmt = function (stmt, context) {
          return new ReturnStatement(stmt.value.visitExpression(this, context));
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitDeclareClassStmt = function (stmt, context) {
          // Don't descend into nested functions
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitIfStmt = function (stmt, context) {
          return new IfStmt(stmt.condition.visitExpression(this, context), this.visitAllStatements(stmt.trueCase, context), this.visitAllStatements(stmt.falseCase, context));
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitTryCatchStmt = function (stmt, context) {
          return new TryCatchStmt(this.visitAllStatements(stmt.bodyStmts, context), this.visitAllStatements(stmt.catchStmts, context));
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitThrowStmt = function (stmt, context) {
          return new ThrowStmt(stmt.error.visitExpression(this, context));
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitCommentStmt = function (stmt, context) { return stmt; };
      /**
       * @param {?} stmts
       * @param {?} context
       * @return {?}
       */
      ExpressionTransformer.prototype.visitAllStatements = function (stmts, context) {
          var _this = this;
          return stmts.map(function (stmt) { return stmt.visitStatement(_this, context); });
      };
      return ExpressionTransformer;
  }());
  var RecursiveExpressionVisitor = (function () {
      function RecursiveExpressionVisitor() {
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitReadVarExpr = function (ast, context) { return ast; };
      /**
       * @param {?} expr
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitWriteVarExpr = function (expr, context) {
          expr.value.visitExpression(this, context);
          return expr;
      };
      /**
       * @param {?} expr
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitWriteKeyExpr = function (expr, context) {
          expr.receiver.visitExpression(this, context);
          expr.index.visitExpression(this, context);
          expr.value.visitExpression(this, context);
          return expr;
      };
      /**
       * @param {?} expr
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitWritePropExpr = function (expr, context) {
          expr.receiver.visitExpression(this, context);
          expr.value.visitExpression(this, context);
          return expr;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitInvokeMethodExpr = function (ast, context) {
          ast.receiver.visitExpression(this, context);
          this.visitAllExpressions(ast.args, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitInvokeFunctionExpr = function (ast, context) {
          ast.fn.visitExpression(this, context);
          this.visitAllExpressions(ast.args, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitInstantiateExpr = function (ast, context) {
          ast.classExpr.visitExpression(this, context);
          this.visitAllExpressions(ast.args, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitLiteralExpr = function (ast, context) { return ast; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitExternalExpr = function (ast, context) { return ast; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitConditionalExpr = function (ast, context) {
          ast.condition.visitExpression(this, context);
          ast.trueCase.visitExpression(this, context);
          ast.falseCase.visitExpression(this, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitNotExpr = function (ast, context) {
          ast.condition.visitExpression(this, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitCastExpr = function (ast, context) {
          ast.value.visitExpression(this, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitFunctionExpr = function (ast, context) { return ast; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitBinaryOperatorExpr = function (ast, context) {
          ast.lhs.visitExpression(this, context);
          ast.rhs.visitExpression(this, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitReadPropExpr = function (ast, context) {
          ast.receiver.visitExpression(this, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitReadKeyExpr = function (ast, context) {
          ast.receiver.visitExpression(this, context);
          ast.index.visitExpression(this, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitLiteralArrayExpr = function (ast, context) {
          this.visitAllExpressions(ast.entries, context);
          return ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitLiteralMapExpr = function (ast, context) {
          var _this = this;
          ast.entries.forEach(function (entry) { return ((entry[1])).visitExpression(_this, context); });
          return ast;
      };
      /**
       * @param {?} exprs
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitAllExpressions = function (exprs, context) {
          var _this = this;
          exprs.forEach(function (expr) { return expr.visitExpression(_this, context); });
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitDeclareVarStmt = function (stmt, context) {
          stmt.value.visitExpression(this, context);
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitDeclareFunctionStmt = function (stmt, context) {
          // Don't descend into nested functions
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitExpressionStmt = function (stmt, context) {
          stmt.expr.visitExpression(this, context);
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitReturnStmt = function (stmt, context) {
          stmt.value.visitExpression(this, context);
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitDeclareClassStmt = function (stmt, context) {
          // Don't descend into nested functions
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitIfStmt = function (stmt, context) {
          stmt.condition.visitExpression(this, context);
          this.visitAllStatements(stmt.trueCase, context);
          this.visitAllStatements(stmt.falseCase, context);
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitTryCatchStmt = function (stmt, context) {
          this.visitAllStatements(stmt.bodyStmts, context);
          this.visitAllStatements(stmt.catchStmts, context);
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitThrowStmt = function (stmt, context) {
          stmt.error.visitExpression(this, context);
          return stmt;
      };
      /**
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitCommentStmt = function (stmt, context) { return stmt; };
      /**
       * @param {?} stmts
       * @param {?} context
       * @return {?}
       */
      RecursiveExpressionVisitor.prototype.visitAllStatements = function (stmts, context) {
          var _this = this;
          stmts.forEach(function (stmt) { return stmt.visitStatement(_this, context); });
      };
      return RecursiveExpressionVisitor;
  }());
  /**
   * @param {?} varName
   * @param {?} newValue
   * @param {?} expression
   * @return {?}
   */
  function replaceVarInExpression(varName, newValue, expression) {
      var /** @type {?} */ transformer = new _ReplaceVariableTransformer(varName, newValue);
      return expression.visitExpression(transformer, null);
  }
  var _ReplaceVariableTransformer = (function (_super) {
      __extends$15(_ReplaceVariableTransformer, _super);
      /**
       * @param {?} _varName
       * @param {?} _newValue
       */
      function _ReplaceVariableTransformer(_varName, _newValue) {
          _super.call(this);
          this._varName = _varName;
          this._newValue = _newValue;
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _ReplaceVariableTransformer.prototype.visitReadVarExpr = function (ast, context) {
          return ast.name == this._varName ? this._newValue : ast;
      };
      return _ReplaceVariableTransformer;
  }(ExpressionTransformer));
  /**
   * @param {?} stmts
   * @return {?}
   */
  function findReadVarNames(stmts) {
      var /** @type {?} */ finder = new _VariableFinder();
      finder.visitAllStatements(stmts, null);
      return finder.varNames;
  }
  var _VariableFinder = (function (_super) {
      __extends$15(_VariableFinder, _super);
      function _VariableFinder() {
          _super.apply(this, arguments);
          this.varNames = new Set();
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _VariableFinder.prototype.visitReadVarExpr = function (ast, context) {
          this.varNames.add(ast.name);
          return null;
      };
      return _VariableFinder;
  }(RecursiveExpressionVisitor));
  /**
   * @param {?} name
   * @param {?=} type
   * @return {?}
   */
  function variable(name, type) {
      if (type === void 0) { type = null; }
      return new ReadVarExpr(name, type);
  }
  /**
   * @param {?} id
   * @param {?=} typeParams
   * @return {?}
   */
  function importExpr(id, typeParams) {
      if (typeParams === void 0) { typeParams = null; }
      return new ExternalExpr(id, null, typeParams);
  }
  /**
   * @param {?} id
   * @param {?=} typeParams
   * @param {?=} typeModifiers
   * @return {?}
   */
  function importType(id, typeParams, typeModifiers) {
      if (typeParams === void 0) { typeParams = null; }
      if (typeModifiers === void 0) { typeModifiers = null; }
      return isPresent(id) ? new ExternalType(id, typeParams, typeModifiers) : null;
  }
  /**
   * @param {?} values
   * @param {?=} type
   * @return {?}
   */
  function literalArr(values, type) {
      if (type === void 0) { type = null; }
      return new LiteralArrayExpr(values, type);
  }
  /**
   * @param {?} values
   * @param {?=} type
   * @return {?}
   */
  function literalMap(values, type) {
      if (type === void 0) { type = null; }
      return new LiteralMapExpr(values, type);
  }
  /**
   * @param {?} expr
   * @return {?}
   */
  function not(expr) {
      return new NotExpr(expr);
  }
  /**
   * @param {?} params
   * @param {?} body
   * @param {?=} type
   * @return {?}
   */
  function fn(params, body, type) {
      if (type === void 0) { type = null; }
      return new FunctionExpr(params, body, type);
  }
  /**
   * @param {?} value
   * @param {?=} type
   * @return {?}
   */
  function literal(value, type) {
      if (type === void 0) { type = null; }
      return new LiteralExpr(value, type);
  }

  var CheckBindingField = (function () {
      /**
       * @param {?} expression
       * @param {?} bindingId
       */
      function CheckBindingField(expression, bindingId) {
          this.expression = expression;
          this.bindingId = bindingId;
      }
      return CheckBindingField;
  }());
  /**
   * @param {?} builder
   * @return {?}
   */
  function createCheckBindingField(builder) {
      var /** @type {?} */ bindingId = "" + builder.fields.length;
      var /** @type {?} */ fieldExpr = createBindFieldExpr(bindingId);
      // private is fine here as no child view will reference the cached value...
      builder.fields.push(new ClassField(fieldExpr.name, null, [StmtModifier.Private]));
      builder.ctorStmts.push(THIS_EXPR.prop(fieldExpr.name)
          .set(importExpr(resolveIdentifier(Identifiers.UNINITIALIZED)))
          .toStmt());
      return new CheckBindingField(fieldExpr, bindingId);
  }
  /**
   * @param {?} evalResult
   * @param {?} fieldExpr
   * @param {?} throwOnChangeVar
   * @param {?} actions
   * @return {?}
   */
  function createCheckBindingStmt(evalResult, fieldExpr, throwOnChangeVar, actions) {
      var /** @type {?} */ condition = importExpr(resolveIdentifier(Identifiers.checkBinding)).callFn([
          throwOnChangeVar, fieldExpr, evalResult.currValExpr
      ]);
      if (evalResult.forceUpdate) {
          condition = evalResult.forceUpdate.or(condition);
      }
      return evalResult.stmts.concat([
          new IfStmt(condition, actions.concat([(THIS_EXPR.prop(fieldExpr.name).set(evalResult.currValExpr).toStmt())
          ]))
      ]);
  }
  /**
   * @param {?} bindingId
   * @return {?}
   */
  function createBindFieldExpr(bindingId) {
      return THIS_EXPR.prop("_expr_" + bindingId);
  }

  /**
   * @param {?} token
   * @return {?}
   */
  function createDiTokenExpression(token) {
      if (isPresent(token.value)) {
          return literal(token.value);
      }
      else if (token.identifierIsInstance) {
          return importExpr(token.identifier)
              .instantiate([], importType(token.identifier, [], [TypeModifier.Const]));
      }
      else {
          return importExpr(token.identifier);
      }
  }
  /**
   * @param {?} values
   * @return {?}
   */
  function createInlineArray(values) {
      if (values.length === 0) {
          return importExpr(resolveIdentifier(Identifiers.EMPTY_INLINE_ARRAY));
      }
      var /** @type {?} */ log2 = Math.log(values.length) / Math.log(2);
      var /** @type {?} */ index = Math.ceil(log2);
      var /** @type {?} */ identifierSpec = index < Identifiers.inlineArrays.length ? Identifiers.inlineArrays[index] :
          Identifiers.InlineArrayDynamic;
      var /** @type {?} */ identifier = resolveIdentifier(identifierSpec);
      return importExpr(identifier).instantiate([(literal(values.length))
      ].concat(values));
  }
  /**
   * @param {?} fn
   * @param {?} argCount
   * @param {?} pureProxyProp
   * @param {?} builder
   * @return {?}
   */
  function createPureProxy(fn, argCount, pureProxyProp, builder) {
      builder.fields.push(new ClassField(pureProxyProp.name, null));
      var /** @type {?} */ pureProxyId = argCount < Identifiers.pureProxies.length ? Identifiers.pureProxies[argCount] : null;
      if (!pureProxyId) {
          throw new Error("Unsupported number of argument for pure functions: " + argCount);
      }
      builder.ctorStmts.push(THIS_EXPR.prop(pureProxyProp.name)
          .set(importExpr(resolveIdentifier(pureProxyId)).callFn([fn]))
          .toStmt());
  }
  /**
   * @param {?} enumType
   * @param {?} enumValue
   * @return {?}
   */
  function createEnumExpression(enumType, enumValue) {
      var /** @type {?} */ enumName = Object.keys(enumType.runtime).find(function (propName) { return enumType.runtime[propName] === enumValue; });
      if (!enumName) {
          throw new Error("Unknown enum value " + enumValue + " in " + enumType.name);
      }
      return importExpr(resolveEnumIdentifier(resolveIdentifier(enumType), enumName));
  }

  var /** @type {?} */ VAL_UNWRAPPER_VAR = variable("valUnwrapper");
  var EventHandlerVars = (function () {
      function EventHandlerVars() {
      }
      EventHandlerVars.event = variable('$event');
      return EventHandlerVars;
  }());
  var ConvertPropertyBindingResult = (function () {
      /**
       * @param {?} stmts
       * @param {?} currValExpr
       * @param {?} forceUpdate
       */
      function ConvertPropertyBindingResult(stmts, currValExpr, forceUpdate) {
          this.stmts = stmts;
          this.currValExpr = currValExpr;
          this.forceUpdate = forceUpdate;
      }
      return ConvertPropertyBindingResult;
  }());
  /**
   *  Converts the given expression AST into an executable output AST, assuming the expression is
    * used in a property binding.
   * @param {?} builder
   * @param {?} nameResolver
   * @param {?} implicitReceiver
   * @param {?} expression
   * @param {?} bindingId
   * @return {?}
   */
  function convertPropertyBinding(builder, nameResolver, implicitReceiver, expression, bindingId) {
      var /** @type {?} */ currValExpr = createCurrValueExpr(bindingId);
      var /** @type {?} */ stmts = [];
      if (!nameResolver) {
          nameResolver = new DefaultNameResolver();
      }
      var /** @type {?} */ visitor = new _AstToIrVisitor(builder, nameResolver, implicitReceiver, VAL_UNWRAPPER_VAR, bindingId, false);
      var /** @type {?} */ outputExpr = expression.visit(visitor, _Mode.Expression);
      if (!outputExpr) {
          // e.g. an empty expression was given
          return null;
      }
      if (visitor.temporaryCount) {
          for (var /** @type {?} */ i = 0; i < visitor.temporaryCount; i++) {
              stmts.push(temporaryDeclaration(bindingId, i));
          }
      }
      if (visitor.needsValueUnwrapper) {
          var /** @type {?} */ initValueUnwrapperStmt = VAL_UNWRAPPER_VAR.callMethod('reset', []).toStmt();
          stmts.push(initValueUnwrapperStmt);
      }
      stmts.push(currValExpr.set(outputExpr).toDeclStmt(null, [StmtModifier.Final]));
      if (visitor.needsValueUnwrapper) {
          return new ConvertPropertyBindingResult(stmts, currValExpr, VAL_UNWRAPPER_VAR.prop('hasWrappedValue'));
      }
      else {
          return new ConvertPropertyBindingResult(stmts, currValExpr, null);
      }
  }
  var ConvertActionBindingResult = (function () {
      /**
       * @param {?} stmts
       * @param {?} preventDefault
       */
      function ConvertActionBindingResult(stmts, preventDefault) {
          this.stmts = stmts;
          this.preventDefault = preventDefault;
      }
      return ConvertActionBindingResult;
  }());
  /**
   *  Converts the given expression AST into an executable output AST, assuming the expression is
    * used in an action binding (e.g. an event handler).
   * @param {?} builder
   * @param {?} nameResolver
   * @param {?} implicitReceiver
   * @param {?} action
   * @param {?} bindingId
   * @return {?}
   */
  function convertActionBinding(builder, nameResolver, implicitReceiver, action, bindingId) {
      if (!nameResolver) {
          nameResolver = new DefaultNameResolver();
      }
      var /** @type {?} */ visitor = new _AstToIrVisitor(builder, nameResolver, implicitReceiver, null, bindingId, true);
      var /** @type {?} */ actionStmts = [];
      flattenStatements(action.visit(visitor, _Mode.Statement), actionStmts);
      prependTemporaryDecls(visitor.temporaryCount, bindingId, actionStmts);
      var /** @type {?} */ lastIndex = actionStmts.length - 1;
      var /** @type {?} */ preventDefaultVar = null;
      if (lastIndex >= 0) {
          var /** @type {?} */ lastStatement = actionStmts[lastIndex];
          var /** @type {?} */ returnExpr = convertStmtIntoExpression(lastStatement);
          if (returnExpr) {
              // Note: We need to cast the result of the method call to dynamic,
              // as it might be a void method!
              preventDefaultVar = createPreventDefaultVar(bindingId);
              actionStmts[lastIndex] =
                  preventDefaultVar.set(returnExpr.cast(DYNAMIC_TYPE).notIdentical(literal(false)))
                      .toDeclStmt(null, [StmtModifier.Final]);
          }
      }
      return new ConvertActionBindingResult(actionStmts, preventDefaultVar);
  }
  /**
   *  Creates variables that are shared by multiple calls to `convertActionBinding` /
    * `convertPropertyBinding`
   * @param {?} stmts
   * @return {?}
   */
  function createSharedBindingVariablesIfNeeded(stmts) {
      var /** @type {?} */ unwrapperStmts = [];
      var /** @type {?} */ readVars = findReadVarNames(stmts);
      if (readVars.has(VAL_UNWRAPPER_VAR.name)) {
          unwrapperStmts.push(VAL_UNWRAPPER_VAR
              .set(importExpr(resolveIdentifier(Identifiers.ValueUnwrapper)).instantiate([]))
              .toDeclStmt(null, [StmtModifier.Final]));
      }
      return unwrapperStmts;
  }
  /**
   * @param {?} bindingId
   * @param {?} temporaryNumber
   * @return {?}
   */
  function temporaryName(bindingId, temporaryNumber) {
      return "tmp_" + bindingId + "_" + temporaryNumber;
  }
  /**
   * @param {?} bindingId
   * @param {?} temporaryNumber
   * @return {?}
   */
  function temporaryDeclaration(bindingId, temporaryNumber) {
      return new DeclareVarStmt(temporaryName(bindingId, temporaryNumber), NULL_EXPR);
  }
  /**
   * @param {?} temporaryCount
   * @param {?} bindingId
   * @param {?} statements
   * @return {?}
   */
  function prependTemporaryDecls(temporaryCount, bindingId, statements) {
      for (var /** @type {?} */ i = temporaryCount - 1; i >= 0; i--) {
          statements.unshift(temporaryDeclaration(bindingId, i));
      }
  }
  var _Mode = {};
  _Mode.Statement = 0;
  _Mode.Expression = 1;
  _Mode[_Mode.Statement] = "Statement";
  _Mode[_Mode.Expression] = "Expression";
  /**
   * @param {?} mode
   * @param {?} ast
   * @return {?}
   */
  function ensureStatementMode(mode, ast) {
      if (mode !== _Mode.Statement) {
          throw new Error("Expected a statement, but saw " + ast);
      }
  }
  /**
   * @param {?} mode
   * @param {?} ast
   * @return {?}
   */
  function ensureExpressionMode(mode, ast) {
      if (mode !== _Mode.Expression) {
          throw new Error("Expected an expression, but saw " + ast);
      }
  }
  /**
   * @param {?} mode
   * @param {?} expr
   * @return {?}
   */
  function convertToStatementIfNeeded(mode, expr) {
      if (mode === _Mode.Statement) {
          return expr.toStmt();
      }
      else {
          return expr;
      }
  }
  var _AstToIrVisitor = (function () {
      /**
       * @param {?} _builder
       * @param {?} _nameResolver
       * @param {?} _implicitReceiver
       * @param {?} _valueUnwrapper
       * @param {?} bindingId
       * @param {?} isAction
       */
      function _AstToIrVisitor(_builder, _nameResolver, _implicitReceiver, _valueUnwrapper, bindingId, isAction) {
          this._builder = _builder;
          this._nameResolver = _nameResolver;
          this._implicitReceiver = _implicitReceiver;
          this._valueUnwrapper = _valueUnwrapper;
          this.bindingId = bindingId;
          this.isAction = isAction;
          this._nodeMap = new Map();
          this._resultMap = new Map();
          this._currentTemporary = 0;
          this.needsValueUnwrapper = false;
          this.temporaryCount = 0;
      }
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitBinary = function (ast, mode) {
          var /** @type {?} */ op;
          switch (ast.operation) {
              case '+':
                  op = BinaryOperator.Plus;
                  break;
              case '-':
                  op = BinaryOperator.Minus;
                  break;
              case '*':
                  op = BinaryOperator.Multiply;
                  break;
              case '/':
                  op = BinaryOperator.Divide;
                  break;
              case '%':
                  op = BinaryOperator.Modulo;
                  break;
              case '&&':
                  op = BinaryOperator.And;
                  break;
              case '||':
                  op = BinaryOperator.Or;
                  break;
              case '==':
                  op = BinaryOperator.Equals;
                  break;
              case '!=':
                  op = BinaryOperator.NotEquals;
                  break;
              case '===':
                  op = BinaryOperator.Identical;
                  break;
              case '!==':
                  op = BinaryOperator.NotIdentical;
                  break;
              case '<':
                  op = BinaryOperator.Lower;
                  break;
              case '>':
                  op = BinaryOperator.Bigger;
                  break;
              case '<=':
                  op = BinaryOperator.LowerEquals;
                  break;
              case '>=':
                  op = BinaryOperator.BiggerEquals;
                  break;
              default:
                  throw new Error("Unsupported operation " + ast.operation);
          }
          return convertToStatementIfNeeded(mode, new BinaryOperatorExpr(op, this.visit(ast.left, _Mode.Expression), this.visit(ast.right, _Mode.Expression)));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitChain = function (ast, mode) {
          ensureStatementMode(mode, ast);
          return this.visitAll(ast.expressions, mode);
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitConditional = function (ast, mode) {
          var /** @type {?} */ value = this.visit(ast.condition, _Mode.Expression);
          return convertToStatementIfNeeded(mode, value.conditional(this.visit(ast.trueExp, _Mode.Expression), this.visit(ast.falseExp, _Mode.Expression)));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitPipe = function (ast, mode) {
          var /** @type {?} */ input = this.visit(ast.exp, _Mode.Expression);
          var /** @type {?} */ args = this.visitAll(ast.args, _Mode.Expression);
          var /** @type {?} */ value = this._nameResolver.callPipe(ast.name, input, args);
          if (!value) {
              throw new Error("Illegal state: Pipe " + ast.name + " is not allowed here!");
          }
          this.needsValueUnwrapper = true;
          return convertToStatementIfNeeded(mode, this._valueUnwrapper.callMethod('unwrap', [value]));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitFunctionCall = function (ast, mode) {
          return convertToStatementIfNeeded(mode, this.visit(ast.target, _Mode.Expression).callFn(this.visitAll(ast.args, _Mode.Expression)));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitImplicitReceiver = function (ast, mode) {
          ensureExpressionMode(mode, ast);
          return this._implicitReceiver;
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitInterpolation = function (ast, mode) {
          ensureExpressionMode(mode, ast);
          var /** @type {?} */ args = [literal(ast.expressions.length)];
          for (var /** @type {?} */ i = 0; i < ast.strings.length - 1; i++) {
              args.push(literal(ast.strings[i]));
              args.push(this.visit(ast.expressions[i], _Mode.Expression));
          }
          args.push(literal(ast.strings[ast.strings.length - 1]));
          return ast.expressions.length <= 9 ?
              importExpr(resolveIdentifier(Identifiers.inlineInterpolate)).callFn(args) :
              importExpr(resolveIdentifier(Identifiers.interpolate)).callFn([
                  args[0], literalArr(args.slice(1))
              ]);
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitKeyedRead = function (ast, mode) {
          return convertToStatementIfNeeded(mode, this.visit(ast.obj, _Mode.Expression).key(this.visit(ast.key, _Mode.Expression)));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitKeyedWrite = function (ast, mode) {
          var /** @type {?} */ obj = this.visit(ast.obj, _Mode.Expression);
          var /** @type {?} */ key = this.visit(ast.key, _Mode.Expression);
          var /** @type {?} */ value = this.visit(ast.value, _Mode.Expression);
          return convertToStatementIfNeeded(mode, obj.key(key).set(value));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitLiteralArray = function (ast, mode) {
          var /** @type {?} */ parts = this.visitAll(ast.expressions, mode);
          var /** @type {?} */ literalArr$$ = this.isAction ? literalArr(parts) : createCachedLiteralArray(this._builder, parts);
          return convertToStatementIfNeeded(mode, literalArr$$);
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitLiteralMap = function (ast, mode) {
          var /** @type {?} */ parts = [];
          for (var /** @type {?} */ i = 0; i < ast.keys.length; i++) {
              parts.push([ast.keys[i], this.visit(ast.values[i], _Mode.Expression)]);
          }
          var /** @type {?} */ literalMap$$ = this.isAction ? literalMap(parts) : createCachedLiteralMap(this._builder, parts);
          return convertToStatementIfNeeded(mode, literalMap$$);
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitLiteralPrimitive = function (ast, mode) {
          return convertToStatementIfNeeded(mode, literal(ast.value));
      };
      /**
       * @param {?} name
       * @return {?}
       */
      _AstToIrVisitor.prototype._getLocal = function (name) {
          if (this.isAction && name == EventHandlerVars.event.name) {
              return EventHandlerVars.event;
          }
          return this._nameResolver.getLocal(name);
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitMethodCall = function (ast, mode) {
          var /** @type {?} */ leftMostSafe = this.leftMostSafeNode(ast);
          if (leftMostSafe) {
              return this.convertSafeAccess(ast, leftMostSafe, mode);
          }
          else {
              var /** @type {?} */ args = this.visitAll(ast.args, _Mode.Expression);
              var /** @type {?} */ result = null;
              var /** @type {?} */ receiver = this.visit(ast.receiver, _Mode.Expression);
              if (receiver === this._implicitReceiver) {
                  var /** @type {?} */ varExpr = this._getLocal(ast.name);
                  if (isPresent(varExpr)) {
                      result = varExpr.callFn(args);
                  }
              }
              if (isBlank(result)) {
                  result = receiver.callMethod(ast.name, args);
              }
              return convertToStatementIfNeeded(mode, result);
          }
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitPrefixNot = function (ast, mode) {
          return convertToStatementIfNeeded(mode, not(this.visit(ast.expression, _Mode.Expression)));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitPropertyRead = function (ast, mode) {
          var /** @type {?} */ leftMostSafe = this.leftMostSafeNode(ast);
          if (leftMostSafe) {
              return this.convertSafeAccess(ast, leftMostSafe, mode);
          }
          else {
              var /** @type {?} */ result = null;
              var /** @type {?} */ receiver = this.visit(ast.receiver, _Mode.Expression);
              if (receiver === this._implicitReceiver) {
                  result = this._getLocal(ast.name);
              }
              if (isBlank(result)) {
                  result = receiver.prop(ast.name);
              }
              return convertToStatementIfNeeded(mode, result);
          }
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitPropertyWrite = function (ast, mode) {
          var /** @type {?} */ receiver = this.visit(ast.receiver, _Mode.Expression);
          if (receiver === this._implicitReceiver) {
              var /** @type {?} */ varExpr = this._getLocal(ast.name);
              if (isPresent(varExpr)) {
                  throw new Error('Cannot assign to a reference or variable!');
              }
          }
          return convertToStatementIfNeeded(mode, receiver.prop(ast.name).set(this.visit(ast.value, _Mode.Expression)));
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitSafePropertyRead = function (ast, mode) {
          return this.convertSafeAccess(ast, this.leftMostSafeNode(ast), mode);
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitSafeMethodCall = function (ast, mode) {
          return this.convertSafeAccess(ast, this.leftMostSafeNode(ast), mode);
      };
      /**
       * @param {?} asts
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitAll = function (asts, mode) {
          var _this = this;
          return asts.map(function (ast) { return _this.visit(ast, mode); });
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visitQuote = function (ast, mode) {
          throw new Error('Quotes are not supported for evaluation!');
      };
      /**
       * @param {?} ast
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.visit = function (ast, mode) {
          var /** @type {?} */ result = this._resultMap.get(ast);
          if (result)
              return result;
          return (this._nodeMap.get(ast) || ast).visit(this, mode);
      };
      /**
       * @param {?} ast
       * @param {?} leftMostSafe
       * @param {?} mode
       * @return {?}
       */
      _AstToIrVisitor.prototype.convertSafeAccess = function (ast, leftMostSafe, mode) {
          // If the expression contains a safe access node on the left it needs to be converted to
          // an expression that guards the access to the member by checking the receiver for blank. As
          // execution proceeds from left to right, the left most part of the expression must be guarded
          // first but, because member access is left associative, the right side of the expression is at
          // the top of the AST. The desired result requires lifting a copy of the the left part of the
          // expression up to test it for blank before generating the unguarded version.
          // Consider, for example the following expression: a?.b.c?.d.e
          // This results in the ast:
          //         .
          //        / \
          //       ?.   e
          //      /  \
          //     .    d
          //    / \
          //   ?.  c
          //  /  \
          // a    b
          // The following tree should be generated:
          //
          //        /---- ? ----\
          //       /      |      \
          //     a   /--- ? ---\  null
          //        /     |     \
          //       .      .     null
          //      / \    / \
          //     .  c   .   e
          //    / \    / \
          //   a   b  ,   d
          //         / \
          //        .   c
          //       / \
          //      a   b
          //
          // Notice that the first guard condition is the left hand of the left most safe access node
          // which comes in as leftMostSafe to this routine.
          var /** @type {?} */ guardedExpression = this.visit(leftMostSafe.receiver, _Mode.Expression);
          var /** @type {?} */ temporary;
          if (this.needsTemporary(leftMostSafe.receiver)) {
              // If the expression has method calls or pipes then we need to save the result into a
              // temporary variable to avoid calling stateful or impure code more than once.
              temporary = this.allocateTemporary();
              // Preserve the result in the temporary variable
              guardedExpression = temporary.set(guardedExpression);
              // Ensure all further references to the guarded expression refer to the temporary instead.
              this._resultMap.set(leftMostSafe.receiver, temporary);
          }
          var /** @type {?} */ condition = guardedExpression.isBlank();
          // Convert the ast to an unguarded access to the receiver's member. The map will substitute
          // leftMostNode with its unguarded version in the call to `this.visit()`.
          if (leftMostSafe instanceof SafeMethodCall) {
              this._nodeMap.set(leftMostSafe, new MethodCall(leftMostSafe.span, leftMostSafe.receiver, leftMostSafe.name, leftMostSafe.args));
          }
          else {
              this._nodeMap.set(leftMostSafe, new PropertyRead(leftMostSafe.span, leftMostSafe.receiver, leftMostSafe.name));
          }
          // Recursively convert the node now without the guarded member access.
          var /** @type {?} */ access = this.visit(ast, _Mode.Expression);
          // Remove the mapping. This is not strictly required as the converter only traverses each node
          // once but is safer if the conversion is changed to traverse the nodes more than once.
          this._nodeMap.delete(leftMostSafe);
          // If we allcoated a temporary, release it.
          if (temporary) {
              this.releaseTemporary(temporary);
          }
          // Produce the conditional
          return convertToStatementIfNeeded(mode, condition.conditional(literal(null), access));
      };
      /**
       * @param {?} ast
       * @return {?}
       */
      _AstToIrVisitor.prototype.leftMostSafeNode = function (ast) {
          var _this = this;
          var /** @type {?} */ visit = function (visitor, ast) {
              return (_this._nodeMap.get(ast) || ast).visit(visitor);
          };
          return ast.visit({
              /**
               * @param {?} ast
               * @return {?}
               */
              visitBinary: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitChain: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitConditional: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitFunctionCall: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitImplicitReceiver: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitInterpolation: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitKeyedRead: function (ast) { return visit(this, ast.obj); },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitKeyedWrite: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitLiteralArray: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitLiteralMap: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitLiteralPrimitive: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitMethodCall: function (ast) { return visit(this, ast.receiver); },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPipe: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPrefixNot: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPropertyRead: function (ast) { return visit(this, ast.receiver); },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPropertyWrite: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitQuote: function (ast) { return null; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitSafeMethodCall: function (ast) { return visit(this, ast.receiver) || ast; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitSafePropertyRead: function (ast) {
                  return visit(this, ast.receiver) || ast;
              }
          });
      };
      /**
       * @param {?} ast
       * @return {?}
       */
      _AstToIrVisitor.prototype.needsTemporary = function (ast) {
          var _this = this;
          var /** @type {?} */ visit = function (visitor, ast) {
              return ast && (_this._nodeMap.get(ast) || ast).visit(visitor);
          };
          var /** @type {?} */ visitSome = function (visitor, ast) {
              return ast.some(function (ast) { return visit(visitor, ast); });
          };
          return ast.visit({
              /**
               * @param {?} ast
               * @return {?}
               */
              visitBinary: function (ast) { return visit(this, ast.left) || visit(this, ast.right); },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitChain: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitConditional: function (ast) {
                  return visit(this, ast.condition) || visit(this, ast.trueExp) ||
                      visit(this, ast.falseExp);
              },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitFunctionCall: function (ast) { return true; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitImplicitReceiver: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitInterpolation: function (ast) { return visitSome(this, ast.expressions); },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitKeyedRead: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitKeyedWrite: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitLiteralArray: function (ast) { return true; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitLiteralMap: function (ast) { return true; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitLiteralPrimitive: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitMethodCall: function (ast) { return true; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPipe: function (ast) { return true; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPrefixNot: function (ast) { return visit(this, ast.expression); },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPropertyRead: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitPropertyWrite: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitQuote: function (ast) { return false; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitSafeMethodCall: function (ast) { return true; },
              /**
               * @param {?} ast
               * @return {?}
               */
              visitSafePropertyRead: function (ast) { return false; }
          });
      };
      /**
       * @return {?}
       */
      _AstToIrVisitor.prototype.allocateTemporary = function () {
          var /** @type {?} */ tempNumber = this._currentTemporary++;
          this.temporaryCount = Math.max(this._currentTemporary, this.temporaryCount);
          return new ReadVarExpr(temporaryName(this.bindingId, tempNumber));
      };
      /**
       * @param {?} temporary
       * @return {?}
       */
      _AstToIrVisitor.prototype.releaseTemporary = function (temporary) {
          this._currentTemporary--;
          if (temporary.name != temporaryName(this.bindingId, this._currentTemporary)) {
              throw new Error("Temporary " + temporary.name + " released out of order");
          }
      };
      return _AstToIrVisitor;
  }());
  /**
   * @param {?} arg
   * @param {?} output
   * @return {?}
   */
  function flattenStatements(arg, output) {
      if (Array.isArray(arg)) {
          ((arg)).forEach(function (entry) { return flattenStatements(entry, output); });
      }
      else {
          output.push(arg);
      }
  }
  /**
   * @param {?} builder
   * @param {?} values
   * @return {?}
   */
  function createCachedLiteralArray(builder, values) {
      if (values.length === 0) {
          return importExpr(resolveIdentifier(Identifiers.EMPTY_ARRAY));
      }
      var /** @type {?} */ proxyExpr = THIS_EXPR.prop("_arr_" + builder.fields.length);
      var /** @type {?} */ proxyParams = [];
      var /** @type {?} */ proxyReturnEntries = [];
      for (var /** @type {?} */ i = 0; i < values.length; i++) {
          var /** @type {?} */ paramName = "p" + i;
          proxyParams.push(new FnParam(paramName));
          proxyReturnEntries.push(variable(paramName));
      }
      createPureProxy(fn(proxyParams, [new ReturnStatement(literalArr(proxyReturnEntries))], new ArrayType(DYNAMIC_TYPE)), values.length, proxyExpr, builder);
      return proxyExpr.callFn(values);
  }
  /**
   * @param {?} builder
   * @param {?} entries
   * @return {?}
   */
  function createCachedLiteralMap(builder, entries) {
      if (entries.length === 0) {
          return importExpr(resolveIdentifier(Identifiers.EMPTY_MAP));
      }
      var /** @type {?} */ proxyExpr = THIS_EXPR.prop("_map_" + builder.fields.length);
      var /** @type {?} */ proxyParams = [];
      var /** @type {?} */ proxyReturnEntries = [];
      var /** @type {?} */ values = [];
      for (var /** @type {?} */ i = 0; i < entries.length; i++) {
          var /** @type {?} */ paramName = "p" + i;
          proxyParams.push(new FnParam(paramName));
          proxyReturnEntries.push([entries[i][0], variable(paramName)]);
          values.push(/** @type {?} */ (entries[i][1]));
      }
      createPureProxy(fn(proxyParams, [new ReturnStatement(literalMap(proxyReturnEntries))], new MapType(DYNAMIC_TYPE)), entries.length, proxyExpr, builder);
      return proxyExpr.callFn(values);
  }
  var DefaultNameResolver = (function () {
      function DefaultNameResolver() {
      }
      /**
       * @param {?} name
       * @param {?} input
       * @param {?} args
       * @return {?}
       */
      DefaultNameResolver.prototype.callPipe = function (name, input, args) { return null; };
      /**
       * @param {?} name
       * @return {?}
       */
      DefaultNameResolver.prototype.getLocal = function (name) { return null; };
      return DefaultNameResolver;
  }());
  /**
   * @param {?} bindingId
   * @return {?}
   */
  function createCurrValueExpr(bindingId) {
      return variable("currVal_" + bindingId); // fix syntax highlighting: `
  }
  /**
   * @param {?} bindingId
   * @return {?}
   */
  function createPreventDefaultVar(bindingId) {
      return variable("pd_" + bindingId);
  }
  /**
   * @param {?} stmt
   * @return {?}
   */
  function convertStmtIntoExpression(stmt) {
      if (stmt instanceof ExpressionStatement) {
          return stmt.expr;
      }
      else if (stmt instanceof ReturnStatement) {
          return stmt.value;
      }
      return null;
  }

  /**
   * @param {?} view
   * @param {?} boundProp
   * @param {?} renderElement
   * @param {?} renderValue
   * @param {?} logBindingUpdate
   * @param {?=} securityContextExpression
   * @return {?}
   */
  function writeToRenderer(view, boundProp, renderElement, renderValue, logBindingUpdate, securityContextExpression) {
      var /** @type {?} */ updateStmts = [];
      var /** @type {?} */ renderer = view.prop('renderer');
      renderValue = sanitizedValue(view, boundProp, renderValue, securityContextExpression);
      switch (boundProp.type) {
          case PropertyBindingType.Property:
              if (logBindingUpdate) {
                  updateStmts.push(importExpr(resolveIdentifier(Identifiers.setBindingDebugInfo))
                      .callFn([renderer, renderElement, literal(boundProp.name), renderValue])
                      .toStmt());
              }
              updateStmts.push(renderer
                  .callMethod('setElementProperty', [renderElement, literal(boundProp.name), renderValue])
                  .toStmt());
              break;
          case PropertyBindingType.Attribute:
              renderValue =
                  renderValue.isBlank().conditional(NULL_EXPR, renderValue.callMethod('toString', []));
              updateStmts.push(renderer
                  .callMethod('setElementAttribute', [renderElement, literal(boundProp.name), renderValue])
                  .toStmt());
              break;
          case PropertyBindingType.Class:
              updateStmts.push(renderer
                  .callMethod('setElementClass', [renderElement, literal(boundProp.name), renderValue])
                  .toStmt());
              break;
          case PropertyBindingType.Style:
              var /** @type {?} */ strValue = renderValue.callMethod('toString', []);
              if (isPresent(boundProp.unit)) {
                  strValue = strValue.plus(literal(boundProp.unit));
              }
              renderValue = renderValue.isBlank().conditional(NULL_EXPR, strValue);
              updateStmts.push(renderer
                  .callMethod('setElementStyle', [renderElement, literal(boundProp.name), renderValue])
                  .toStmt());
              break;
          case PropertyBindingType.Animation:
              throw new Error('Illegal state: Should not come here!');
      }
      return updateStmts;
  }
  /**
   * @param {?} view
   * @param {?} boundProp
   * @param {?} renderValue
   * @param {?=} securityContextExpression
   * @return {?}
   */
  function sanitizedValue(view, boundProp, renderValue, securityContextExpression) {
      if (boundProp.securityContext === _angular_core.SecurityContext.NONE) {
          return renderValue; // No sanitization needed.
      }
      if (!boundProp.needsRuntimeSecurityContext) {
          securityContextExpression =
              createEnumExpression(Identifiers.SecurityContext, boundProp.securityContext);
      }
      if (!securityContextExpression) {
          throw new Error("internal error, no SecurityContext given " + boundProp.name);
      }
      var /** @type {?} */ ctx = view.prop('viewUtils').prop('sanitizer');
      var /** @type {?} */ args = [securityContextExpression, renderValue];
      return ctx.callMethod('sanitize', args);
  }
  /**
   * @param {?} view
   * @param {?} componentView
   * @param {?} boundProp
   * @param {?} eventListener
   * @param {?} renderElement
   * @param {?} renderValue
   * @param {?} lastRenderValue
   * @return {?}
   */
  function triggerAnimation(view, componentView, boundProp, eventListener, renderElement, renderValue, lastRenderValue) {
      var /** @type {?} */ detachStmts = [];
      var /** @type {?} */ updateStmts = [];
      var /** @type {?} */ animationName = boundProp.name;
      var /** @type {?} */ animationFnExpr = componentView.prop('componentType').prop('animations').key(literal(animationName));
      // it's important to normalize the void value as `void` explicitly
      // so that the styles data can be obtained from the stringmap
      var /** @type {?} */ emptyStateValue = literal(EMPTY_STATE);
      var /** @type {?} */ unitializedValue = importExpr(resolveIdentifier(Identifiers.UNINITIALIZED));
      var /** @type {?} */ animationTransitionVar = variable('animationTransition_' + animationName);
      updateStmts.push(animationTransitionVar
          .set(animationFnExpr.callFn([
          view, renderElement,
          lastRenderValue.equals(unitializedValue).conditional(emptyStateValue, lastRenderValue),
          renderValue.equals(unitializedValue).conditional(emptyStateValue, renderValue)
      ]))
          .toDeclStmt());
      detachStmts.push(animationTransitionVar
          .set(animationFnExpr.callFn([view, renderElement, lastRenderValue, emptyStateValue]))
          .toDeclStmt());
      var /** @type {?} */ registerStmts = [
          animationTransitionVar
              .callMethod('onStart', [eventListener.callMethod(BuiltinMethod.Bind, [view, literal(BoundEventAst.calcFullName(animationName, null, 'start'))])])
              .toStmt(),
          animationTransitionVar
              .callMethod('onDone', [eventListener.callMethod(BuiltinMethod.Bind, [view, literal(BoundEventAst.calcFullName(animationName, null, 'done'))])])
              .toStmt(),
      ];
      updateStmts.push.apply(updateStmts, registerStmts);
      detachStmts.push.apply(detachStmts, registerStmts);
      return { updateStmts: updateStmts, detachStmts: detachStmts };
  }

  /**
   *  Create a new class stmts based on the given data.
   * @param {?} config
   * @return {?}
   */
  function createClassStmt(config) {
      var /** @type {?} */ parentArgs = config.parentArgs || [];
      var /** @type {?} */ superCtorStmts = config.parent ? [SUPER_EXPR.callFn(parentArgs).toStmt()] : [];
      var /** @type {?} */ builder = concatClassBuilderParts(Array.isArray(config.builders) ? config.builders : [config.builders]);
      var /** @type {?} */ ctor = new ClassMethod(null, config.ctorParams || [], superCtorStmts.concat(builder.ctorStmts));
      return new ClassStmt(config.name, config.parent, builder.fields, builder.getters, ctor, builder.methods, config.modifiers || []);
  }
  /**
   * @param {?} builders
   * @return {?}
   */
  function concatClassBuilderParts(builders) {
      return {
          fields: (_a = []).concat.apply(_a, builders.map(function (builder) { return builder.fields || []; })),
          methods: (_b = []).concat.apply(_b, builders.map(function (builder) { return builder.methods || []; })),
          getters: (_c = []).concat.apply(_c, builders.map(function (builder) { return builder.getters || []; })),
          ctorStmts: (_d = []).concat.apply(_d, builders.map(function (builder) { return builder.ctorStmts || []; })),
      };
      var _a, _b, _c, _d;
  }

  var DirectiveWrapperCompileResult = (function () {
      /**
       * @param {?} statements
       * @param {?} dirWrapperClassVar
       */
      function DirectiveWrapperCompileResult(statements, dirWrapperClassVar) {
          this.statements = statements;
          this.dirWrapperClassVar = dirWrapperClassVar;
      }
      return DirectiveWrapperCompileResult;
  }());
  var /** @type {?} */ CONTEXT_FIELD_NAME = 'context';
  var /** @type {?} */ CHANGES_FIELD_NAME = '_changes';
  var /** @type {?} */ CHANGED_FIELD_NAME = '_changed';
  var /** @type {?} */ EVENT_HANDLER_FIELD_NAME = '_eventHandler';
  var /** @type {?} */ CURR_VALUE_VAR = variable('currValue');
  var /** @type {?} */ THROW_ON_CHANGE_VAR = variable('throwOnChange');
  var /** @type {?} */ FORCE_UPDATE_VAR = variable('forceUpdate');
  var /** @type {?} */ VIEW_VAR = variable('view');
  var /** @type {?} */ COMPONENT_VIEW_VAR = variable('componentView');
  var /** @type {?} */ RENDER_EL_VAR = variable('el');
  var /** @type {?} */ EVENT_NAME_VAR = variable('eventName');
  var /** @type {?} */ RESET_CHANGES_STMT = THIS_EXPR.prop(CHANGES_FIELD_NAME).set(literalMap([])).toStmt();
  /**
   *  We generate directive wrappers to prevent code bloat when a directive is used.
    * A directive wrapper encapsulates
    * the dirty checking for `@Input`, the handling of `@HostListener` / `@HostBinding`
    * and calling the lifecyclehooks `ngOnInit`, `ngOnChanges`, `ngDoCheck`.
    * *
    * So far, only `@Input` and the lifecycle hooks have been implemented.
   */
  var DirectiveWrapperCompiler = (function () {
      /**
       * @param {?} compilerConfig
       * @param {?} _exprParser
       * @param {?} _schemaRegistry
       * @param {?} _console
       */
      function DirectiveWrapperCompiler(compilerConfig, _exprParser, _schemaRegistry, _console) {
          this.compilerConfig = compilerConfig;
          this._exprParser = _exprParser;
          this._schemaRegistry = _schemaRegistry;
          this._console = _console;
      }
      /**
       * @param {?} id
       * @return {?}
       */
      DirectiveWrapperCompiler.dirWrapperClassName = function (id) { return "Wrapper_" + id.name; };
      /**
       * @param {?} dirMeta
       * @return {?}
       */
      DirectiveWrapperCompiler.prototype.compile = function (dirMeta) {
          var /** @type {?} */ hostParseResult = parseHostBindings(dirMeta, this._exprParser, this._schemaRegistry);
          reportParseErrors(hostParseResult.errors, this._console);
          var /** @type {?} */ builder = new DirectiveWrapperBuilder(this.compilerConfig, dirMeta);
          Object.keys(dirMeta.inputs).forEach(function (inputFieldName) {
              addCheckInputMethod(inputFieldName, builder);
          });
          addNgDoCheckMethod(builder);
          addCheckHostMethod(hostParseResult.hostProps, builder);
          addHandleEventMethod(hostParseResult.hostListeners, builder);
          addSubscribeMethod(dirMeta, builder);
          var /** @type {?} */ classStmt = builder.build();
          return new DirectiveWrapperCompileResult([classStmt], classStmt.name);
      };
      DirectiveWrapperCompiler.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      DirectiveWrapperCompiler.ctorParameters = function () { return [
          { type: CompilerConfig, },
          { type: Parser, },
          { type: ElementSchemaRegistry, },
          { type: Console, },
      ]; };
      return DirectiveWrapperCompiler;
  }());
  var DirectiveWrapperBuilder = (function () {
      /**
       * @param {?} compilerConfig
       * @param {?} dirMeta
       */
      function DirectiveWrapperBuilder(compilerConfig, dirMeta) {
          this.compilerConfig = compilerConfig;
          this.dirMeta = dirMeta;
          this.fields = [];
          this.getters = [];
          this.methods = [];
          this.ctorStmts = [];
          this.detachStmts = [];
          this.destroyStmts = [];
          var dirLifecycleHooks = dirMeta.type.lifecycleHooks;
          this.genChanges = dirLifecycleHooks.indexOf(LifecycleHooks.OnChanges) !== -1 ||
              this.compilerConfig.logBindingUpdate;
          this.ngOnChanges = dirLifecycleHooks.indexOf(LifecycleHooks.OnChanges) !== -1;
          this.ngOnInit = dirLifecycleHooks.indexOf(LifecycleHooks.OnInit) !== -1;
          this.ngDoCheck = dirLifecycleHooks.indexOf(LifecycleHooks.DoCheck) !== -1;
          this.ngOnDestroy = dirLifecycleHooks.indexOf(LifecycleHooks.OnDestroy) !== -1;
          if (this.ngOnDestroy) {
              this.destroyStmts.push(THIS_EXPR.prop(CONTEXT_FIELD_NAME).callMethod('ngOnDestroy', []).toStmt());
          }
      }
      /**
       * @return {?}
       */
      DirectiveWrapperBuilder.prototype.build = function () {
          var /** @type {?} */ dirDepParamNames = [];
          for (var /** @type {?} */ i = 0; i < this.dirMeta.type.diDeps.length; i++) {
              dirDepParamNames.push("p" + i);
          }
          var /** @type {?} */ methods = [
              new ClassMethod('ngOnDetach', [
                  new FnParam(VIEW_VAR.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
                  new FnParam(COMPONENT_VIEW_VAR.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
                  new FnParam(RENDER_EL_VAR.name, DYNAMIC_TYPE),
              ], this.detachStmts),
              new ClassMethod('ngOnDestroy', [], this.destroyStmts),
          ];
          var /** @type {?} */ fields = [
              new ClassField(EVENT_HANDLER_FIELD_NAME, FUNCTION_TYPE, [StmtModifier.Private]),
              new ClassField(CONTEXT_FIELD_NAME, importType(this.dirMeta.type)),
              new ClassField(CHANGED_FIELD_NAME, BOOL_TYPE, [StmtModifier.Private]),
          ];
          var /** @type {?} */ ctorStmts = [THIS_EXPR.prop(CHANGED_FIELD_NAME).set(literal(false)).toStmt()];
          if (this.genChanges) {
              fields.push(new ClassField(CHANGES_FIELD_NAME, new MapType(DYNAMIC_TYPE), [StmtModifier.Private]));
              ctorStmts.push(RESET_CHANGES_STMT);
          }
          ctorStmts.push(THIS_EXPR.prop(CONTEXT_FIELD_NAME)
              .set(importExpr(this.dirMeta.type)
              .instantiate(dirDepParamNames.map(function (paramName) { return variable(paramName); })))
              .toStmt());
          return createClassStmt({
              name: DirectiveWrapperCompiler.dirWrapperClassName(this.dirMeta.type),
              ctorParams: dirDepParamNames.map(function (paramName) { return new FnParam(paramName, DYNAMIC_TYPE); }),
              builders: [{ fields: fields, ctorStmts: ctorStmts, methods: methods }, this]
          });
      };
      return DirectiveWrapperBuilder;
  }());
  /**
   * @param {?} builder
   * @return {?}
   */
  function addNgDoCheckMethod(builder) {
      var /** @type {?} */ changedVar = variable('changed');
      var /** @type {?} */ stmts = [
          changedVar.set(THIS_EXPR.prop(CHANGED_FIELD_NAME)).toDeclStmt(),
          THIS_EXPR.prop(CHANGED_FIELD_NAME).set(literal(false)).toStmt(),
      ];
      var /** @type {?} */ lifecycleStmts = [];
      if (builder.genChanges) {
          var /** @type {?} */ onChangesStmts = [];
          if (builder.ngOnChanges) {
              onChangesStmts.push(THIS_EXPR.prop(CONTEXT_FIELD_NAME)
                  .callMethod('ngOnChanges', [THIS_EXPR.prop(CHANGES_FIELD_NAME)])
                  .toStmt());
          }
          if (builder.compilerConfig.logBindingUpdate) {
              onChangesStmts.push(importExpr(resolveIdentifier(Identifiers.setBindingDebugInfoForChanges))
                  .callFn([VIEW_VAR.prop('renderer'), RENDER_EL_VAR, THIS_EXPR.prop(CHANGES_FIELD_NAME)])
                  .toStmt());
          }
          onChangesStmts.push(RESET_CHANGES_STMT);
          lifecycleStmts.push(new IfStmt(changedVar, onChangesStmts));
      }
      if (builder.ngOnInit) {
          lifecycleStmts.push(new IfStmt(VIEW_VAR.prop('numberOfChecks').identical(new LiteralExpr(0)), [THIS_EXPR.prop(CONTEXT_FIELD_NAME).callMethod('ngOnInit', []).toStmt()]));
      }
      if (builder.ngDoCheck) {
          lifecycleStmts.push(THIS_EXPR.prop(CONTEXT_FIELD_NAME).callMethod('ngDoCheck', []).toStmt());
      }
      if (lifecycleStmts.length > 0) {
          stmts.push(new IfStmt(not(THROW_ON_CHANGE_VAR), lifecycleStmts));
      }
      stmts.push(new ReturnStatement(changedVar));
      builder.methods.push(new ClassMethod('ngDoCheck', [
          new FnParam(VIEW_VAR.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
          new FnParam(RENDER_EL_VAR.name, DYNAMIC_TYPE),
          new FnParam(THROW_ON_CHANGE_VAR.name, BOOL_TYPE),
      ], stmts, BOOL_TYPE));
  }
  /**
   * @param {?} input
   * @param {?} builder
   * @return {?}
   */
  function addCheckInputMethod(input, builder) {
      var /** @type {?} */ field = createCheckBindingField(builder);
      var /** @type {?} */ onChangeStatements = [
          THIS_EXPR.prop(CHANGED_FIELD_NAME).set(literal(true)).toStmt(),
          THIS_EXPR.prop(CONTEXT_FIELD_NAME).prop(input).set(CURR_VALUE_VAR).toStmt(),
      ];
      if (builder.genChanges) {
          onChangeStatements.push(THIS_EXPR.prop(CHANGES_FIELD_NAME)
              .key(literal(input))
              .set(importExpr(resolveIdentifier(Identifiers.SimpleChange))
              .instantiate([field.expression, CURR_VALUE_VAR]))
              .toStmt());
      }
      var /** @type {?} */ methodBody = createCheckBindingStmt({ currValExpr: CURR_VALUE_VAR, forceUpdate: FORCE_UPDATE_VAR, stmts: [] }, field.expression, THROW_ON_CHANGE_VAR, onChangeStatements);
      builder.methods.push(new ClassMethod("check_" + input, [
          new FnParam(CURR_VALUE_VAR.name, DYNAMIC_TYPE),
          new FnParam(THROW_ON_CHANGE_VAR.name, BOOL_TYPE),
          new FnParam(FORCE_UPDATE_VAR.name, BOOL_TYPE),
      ], methodBody));
  }
  /**
   * @param {?} hostProps
   * @param {?} builder
   * @return {?}
   */
  function addCheckHostMethod(hostProps, builder) {
      var /** @type {?} */ stmts = [];
      var /** @type {?} */ methodParams = [
          new FnParam(VIEW_VAR.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
          new FnParam(COMPONENT_VIEW_VAR.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
          new FnParam(RENDER_EL_VAR.name, DYNAMIC_TYPE),
          new FnParam(THROW_ON_CHANGE_VAR.name, BOOL_TYPE),
      ];
      hostProps.forEach(function (hostProp, hostPropIdx) {
          var /** @type {?} */ field = createCheckBindingField(builder);
          var /** @type {?} */ evalResult = convertPropertyBinding(builder, null, THIS_EXPR.prop(CONTEXT_FIELD_NAME), hostProp.value, field.bindingId);
          if (!evalResult) {
              return;
          }
          var /** @type {?} */ securityContextExpr;
          if (hostProp.needsRuntimeSecurityContext) {
              securityContextExpr = variable("secCtx_" + methodParams.length);
              methodParams.push(new FnParam(securityContextExpr.name, importType(resolveIdentifier(Identifiers.SecurityContext))));
          }
          var /** @type {?} */ checkBindingStmts;
          if (hostProp.isAnimation) {
              var _a = triggerAnimation(VIEW_VAR, COMPONENT_VIEW_VAR, hostProp, THIS_EXPR.prop(EVENT_HANDLER_FIELD_NAME)
                  .or(importExpr(resolveIdentifier(Identifiers.noop))), RENDER_EL_VAR, evalResult.currValExpr, field.expression), updateStmts = _a.updateStmts, detachStmts = _a.detachStmts;
              checkBindingStmts = updateStmts;
              (_b = builder.detachStmts).push.apply(_b, detachStmts);
          }
          else {
              checkBindingStmts = writeToRenderer(VIEW_VAR, hostProp, RENDER_EL_VAR, evalResult.currValExpr, builder.compilerConfig.logBindingUpdate, securityContextExpr);
          }
          stmts.push.apply(stmts, createCheckBindingStmt(evalResult, field.expression, THROW_ON_CHANGE_VAR, checkBindingStmts));
          var _b;
      });
      builder.methods.push(new ClassMethod('checkHost', methodParams, stmts));
  }
  /**
   * @param {?} hostListeners
   * @param {?} builder
   * @return {?}
   */
  function addHandleEventMethod(hostListeners, builder) {
      var /** @type {?} */ resultVar = variable("result");
      var /** @type {?} */ actionStmts = [resultVar.set(literal(true)).toDeclStmt(BOOL_TYPE)];
      hostListeners.forEach(function (hostListener, eventIdx) {
          var /** @type {?} */ evalResult = convertActionBinding(builder, null, THIS_EXPR.prop(CONTEXT_FIELD_NAME), hostListener.handler, "sub_" + eventIdx);
          var /** @type {?} */ trueStmts = evalResult.stmts;
          if (evalResult.preventDefault) {
              trueStmts.push(resultVar.set(evalResult.preventDefault.and(resultVar)).toStmt());
          }
          // TODO(tbosch): convert this into a `switch` once our OutputAst supports it.
          actionStmts.push(new IfStmt(EVENT_NAME_VAR.equals(literal(hostListener.fullName)), trueStmts));
      });
      actionStmts.push(new ReturnStatement(resultVar));
      builder.methods.push(new ClassMethod('handleEvent', [
          new FnParam(EVENT_NAME_VAR.name, STRING_TYPE),
          new FnParam(EventHandlerVars.event.name, DYNAMIC_TYPE)
      ], actionStmts, BOOL_TYPE));
  }
  /**
   * @param {?} dirMeta
   * @param {?} builder
   * @return {?}
   */
  function addSubscribeMethod(dirMeta, builder) {
      var /** @type {?} */ methodParams = [
          new FnParam(VIEW_VAR.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
          new FnParam(EVENT_HANDLER_FIELD_NAME, DYNAMIC_TYPE)
      ];
      var /** @type {?} */ stmts = [
          THIS_EXPR.prop(EVENT_HANDLER_FIELD_NAME).set(variable(EVENT_HANDLER_FIELD_NAME)).toStmt()
      ];
      Object.keys(dirMeta.outputs).forEach(function (emitterPropName, emitterIdx) {
          var /** @type {?} */ eventName = dirMeta.outputs[emitterPropName];
          var /** @type {?} */ paramName = "emit" + emitterIdx;
          methodParams.push(new FnParam(paramName, BOOL_TYPE));
          var /** @type {?} */ subscriptionFieldName = "subscription" + emitterIdx;
          builder.fields.push(new ClassField(subscriptionFieldName, DYNAMIC_TYPE));
          stmts.push(new IfStmt(variable(paramName), [
              THIS_EXPR.prop(subscriptionFieldName)
                  .set(THIS_EXPR.prop(CONTEXT_FIELD_NAME)
                  .prop(emitterPropName)
                  .callMethod(BuiltinMethod.SubscribeObservable, [variable(EVENT_HANDLER_FIELD_NAME)
                      .callMethod(BuiltinMethod.Bind, [VIEW_VAR, literal(eventName)])]))
                  .toStmt()
          ]));
          builder.destroyStmts.push(THIS_EXPR.prop(subscriptionFieldName)
              .and(THIS_EXPR.prop(subscriptionFieldName).callMethod('unsubscribe', []))
              .toStmt());
      });
      builder.methods.push(new ClassMethod('subscribe', methodParams, stmts));
  }
  var ParseResult = (function () {
      /**
       * @param {?} hostProps
       * @param {?} hostListeners
       * @param {?} errors
       */
      function ParseResult(hostProps, hostListeners, errors) {
          this.hostProps = hostProps;
          this.hostListeners = hostListeners;
          this.errors = errors;
      }
      return ParseResult;
  }());
  /**
   * @param {?} dirMeta
   * @param {?} exprParser
   * @param {?} schemaRegistry
   * @return {?}
   */
  function parseHostBindings(dirMeta, exprParser, schemaRegistry) {
      var /** @type {?} */ errors = [];
      var /** @type {?} */ parser = new BindingParser(exprParser, DEFAULT_INTERPOLATION_CONFIG, schemaRegistry, [], errors);
      var /** @type {?} */ sourceFileName = dirMeta.type.moduleUrl ?
          "in Directive " + dirMeta.type.name + " in " + dirMeta.type.moduleUrl :
          "in Directive " + dirMeta.type.name;
      var /** @type {?} */ sourceFile = new ParseSourceFile('', sourceFileName);
      var /** @type {?} */ sourceSpan = new ParseSourceSpan(new ParseLocation(sourceFile, null, null, null), new ParseLocation(sourceFile, null, null, null));
      var /** @type {?} */ parsedHostProps = parser.createDirectiveHostPropertyAsts(dirMeta.toSummary(), sourceSpan);
      var /** @type {?} */ parsedHostListeners = parser.createDirectiveHostEventAsts(dirMeta.toSummary(), sourceSpan);
      return new ParseResult(parsedHostProps, parsedHostListeners, errors);
  }
  /**
   * @param {?} parseErrors
   * @param {?} console
   * @return {?}
   */
  function reportParseErrors(parseErrors, console) {
      var /** @type {?} */ warnings = parseErrors.filter(function (error) { return error.level === ParseErrorLevel.WARNING; });
      var /** @type {?} */ errors = parseErrors.filter(function (error) { return error.level === ParseErrorLevel.FATAL; });
      if (warnings.length > 0) {
          this._console.warn("Directive parse warnings:\n" + warnings.join('\n'));
      }
      if (errors.length > 0) {
          throw new Error("Directive parse errors:\n" + errors.join('\n'));
      }
  }
  var DirectiveWrapperExpressions = (function () {
      function DirectiveWrapperExpressions() {
      }
      /**
       * @param {?} dir
       * @param {?} depsExpr
       * @return {?}
       */
      DirectiveWrapperExpressions.create = function (dir, depsExpr) {
          return importExpr(dir).instantiate(depsExpr, importType(dir));
      };
      /**
       * @param {?} dirWrapper
       * @return {?}
       */
      DirectiveWrapperExpressions.context = function (dirWrapper) {
          return dirWrapper.prop(CONTEXT_FIELD_NAME);
      };
      /**
       * @param {?} dirWrapper
       * @param {?} view
       * @param {?} renderElement
       * @param {?} throwOnChange
       * @return {?}
       */
      DirectiveWrapperExpressions.ngDoCheck = function (dirWrapper, view, renderElement, throwOnChange) {
          return dirWrapper.callMethod('ngDoCheck', [view, renderElement, throwOnChange]);
      };
      /**
       * @param {?} hostProps
       * @param {?} dirWrapper
       * @param {?} view
       * @param {?} componentView
       * @param {?} renderElement
       * @param {?} throwOnChange
       * @param {?} runtimeSecurityContexts
       * @return {?}
       */
      DirectiveWrapperExpressions.checkHost = function (hostProps, dirWrapper, view, componentView, renderElement, throwOnChange, runtimeSecurityContexts) {
          if (hostProps.length) {
              return [dirWrapper
                      .callMethod('checkHost', [view, componentView, renderElement, throwOnChange].concat(runtimeSecurityContexts))
                      .toStmt()];
          }
          else {
              return [];
          }
      };
      /**
       * @param {?} hostProps
       * @param {?} dirWrapper
       * @param {?} view
       * @param {?} componentView
       * @param {?} renderEl
       * @return {?}
       */
      DirectiveWrapperExpressions.ngOnDetach = function (hostProps, dirWrapper, view, componentView, renderEl) {
          if (hostProps.some(function (prop) { return prop.isAnimation; })) {
              return [dirWrapper
                      .callMethod('ngOnDetach', [
                      view,
                      componentView,
                      renderEl,
                  ])
                      .toStmt()];
          }
          else {
              return [];
          }
      };
      /**
       * @param {?} dir
       * @param {?} dirWrapper
       * @return {?}
       */
      DirectiveWrapperExpressions.ngOnDestroy = function (dir, dirWrapper) {
          if (dir.type.lifecycleHooks.indexOf(LifecycleHooks.OnDestroy) !== -1 ||
              Object.keys(dir.outputs).length > 0) {
              return [dirWrapper.callMethod('ngOnDestroy', []).toStmt()];
          }
          else {
              return [];
          }
      };
      /**
       * @param {?} dirMeta
       * @param {?} hostProps
       * @param {?} usedEvents
       * @param {?} dirWrapper
       * @param {?} view
       * @param {?} eventListener
       * @return {?}
       */
      DirectiveWrapperExpressions.subscribe = function (dirMeta, hostProps, usedEvents, dirWrapper, view, eventListener) {
          var /** @type {?} */ needsSubscribe = false;
          var /** @type {?} */ eventFlags = [];
          Object.keys(dirMeta.outputs).forEach(function (propName) {
              var /** @type {?} */ eventName = dirMeta.outputs[propName];
              var /** @type {?} */ eventUsed = usedEvents.indexOf(eventName) > -1;
              needsSubscribe = needsSubscribe || eventUsed;
              eventFlags.push(literal(eventUsed));
          });
          hostProps.forEach(function (hostProp) {
              if (hostProp.isAnimation && usedEvents.length > 0) {
                  needsSubscribe = true;
              }
          });
          if (needsSubscribe) {
              return [
                  dirWrapper.callMethod('subscribe', [view, eventListener].concat(eventFlags)).toStmt()
              ];
          }
          else {
              return [];
          }
      };
      /**
       * @param {?} hostEvents
       * @param {?} dirWrapper
       * @param {?} eventName
       * @param {?} event
       * @return {?}
       */
      DirectiveWrapperExpressions.handleEvent = function (hostEvents, dirWrapper, eventName, event) {
          return dirWrapper.callMethod('handleEvent', [eventName, event]);
      };
      return DirectiveWrapperExpressions;
  }());

  /**
   * @param {?} hook
   * @param {?} token
   * @return {?}
   */
  function hasLifecycleHook(hook, token) {
      return reflector.hasLifecycleHook(token, getHookName(hook));
  }
  /**
   * @param {?} hook
   * @return {?}
   */
  function getHookName(hook) {
      switch (hook) {
          case LifecycleHooks.OnInit:
              return 'ngOnInit';
          case LifecycleHooks.OnDestroy:
              return 'ngOnDestroy';
          case LifecycleHooks.DoCheck:
              return 'ngDoCheck';
          case LifecycleHooks.OnChanges:
              return 'ngOnChanges';
          case LifecycleHooks.AfterContentInit:
              return 'ngAfterContentInit';
          case LifecycleHooks.AfterContentChecked:
              return 'ngAfterContentChecked';
          case LifecycleHooks.AfterViewInit:
              return 'ngAfterViewInit';
          case LifecycleHooks.AfterViewChecked:
              return 'ngAfterViewChecked';
      }
  }

  /**
   * @param {?} obj
   * @return {?}
   */
  function _isNgModuleMetadata(obj) {
      return obj instanceof _angular_core.NgModule;
  }
  /**
   *  Resolves types to {@link NgModule}.
   */
  var NgModuleResolver = (function () {
      /**
       * @param {?=} _reflector
       */
      function NgModuleResolver(_reflector) {
          if (_reflector === void 0) { _reflector = reflector; }
          this._reflector = _reflector;
      }
      /**
       * @param {?} type
       * @return {?}
       */
      NgModuleResolver.prototype.isNgModule = function (type) { return this._reflector.annotations(type).some(_isNgModuleMetadata); };
      /**
       * @param {?} type
       * @param {?=} throwIfNotFound
       * @return {?}
       */
      NgModuleResolver.prototype.resolve = function (type, throwIfNotFound) {
          if (throwIfNotFound === void 0) { throwIfNotFound = true; }
          var /** @type {?} */ ngModuleMeta = this._reflector.annotations(type).find(_isNgModuleMetadata);
          if (isPresent(ngModuleMeta)) {
              return ngModuleMeta;
          }
          else {
              if (throwIfNotFound) {
                  throw new Error("No NgModule metadata found for '" + stringify(type) + "'.");
              }
              return null;
          }
      };
      NgModuleResolver.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      NgModuleResolver.ctorParameters = function () { return [
          { type: ReflectorReader, },
      ]; };
      return NgModuleResolver;
  }());

  /**
   * @param {?} type
   * @return {?}
   */
  function _isPipeMetadata(type) {
      return type instanceof _angular_core.Pipe;
  }
  /**
   *  Resolve a `Type` for {@link Pipe}.
    * *
    * This interface can be overridden by the application developer to create custom behavior.
    * *
    * See {@link Compiler}
   */
  var PipeResolver = (function () {
      /**
       * @param {?=} _reflector
       */
      function PipeResolver(_reflector) {
          if (_reflector === void 0) { _reflector = reflector; }
          this._reflector = _reflector;
      }
      /**
       * @param {?} type
       * @return {?}
       */
      PipeResolver.prototype.isPipe = function (type) {
          var /** @type {?} */ typeMetadata = this._reflector.annotations(_angular_core.resolveForwardRef(type));
          return typeMetadata && typeMetadata.some(_isPipeMetadata);
      };
      /**
       *  Return {@link Pipe} for a given `Type`.
       * @param {?} type
       * @param {?=} throwIfNotFound
       * @return {?}
       */
      PipeResolver.prototype.resolve = function (type, throwIfNotFound) {
          if (throwIfNotFound === void 0) { throwIfNotFound = true; }
          var /** @type {?} */ metas = this._reflector.annotations(_angular_core.resolveForwardRef(type));
          if (isPresent(metas)) {
              var /** @type {?} */ annotation = metas.find(_isPipeMetadata);
              if (isPresent(annotation)) {
                  return annotation;
              }
          }
          if (throwIfNotFound) {
              throw new Error("No Pipe decorator found on " + stringify(type));
          }
          return null;
      };
      PipeResolver.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      PipeResolver.ctorParameters = function () { return [
          { type: ReflectorReader, },
      ]; };
      return PipeResolver;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$16 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  // Design notes:
  // - don't lazily create metadata:
  //   For some metadata, we need to do async work sometimes,
  //   so the user has to kick off this loading.
  //   But we want to report errors even when the async work is
  //   not required to check that the user would have been able
  //   to wait correctly.
  var CompileMetadataResolver = (function () {
      /**
       * @param {?} _ngModuleResolver
       * @param {?} _directiveResolver
       * @param {?} _pipeResolver
       * @param {?} _schemaRegistry
       * @param {?} _directiveNormalizer
       * @param {?=} _reflector
       */
      function CompileMetadataResolver(_ngModuleResolver, _directiveResolver, _pipeResolver, _schemaRegistry, _directiveNormalizer, _reflector) {
          if (_reflector === void 0) { _reflector = reflector; }
          this._ngModuleResolver = _ngModuleResolver;
          this._directiveResolver = _directiveResolver;
          this._pipeResolver = _pipeResolver;
          this._schemaRegistry = _schemaRegistry;
          this._directiveNormalizer = _directiveNormalizer;
          this._reflector = _reflector;
          this._directiveCache = new Map();
          this._directiveSummaryCache = new Map();
          this._pipeCache = new Map();
          this._pipeSummaryCache = new Map();
          this._ngModuleCache = new Map();
          this._ngModuleOfTypes = new Map();
          this._anonymousTypes = new Map();
          this._anonymousTypeIndex = 0;
      }
      /**
       * @param {?} token
       * @return {?}
       */
      CompileMetadataResolver.prototype.sanitizeTokenName = function (token) {
          var /** @type {?} */ identifier = stringify(token);
          if (identifier.indexOf('(') >= 0) {
              // case: anonymous functions!
              var /** @type {?} */ found = this._anonymousTypes.get(token);
              if (!found) {
                  this._anonymousTypes.set(token, this._anonymousTypeIndex++);
                  found = this._anonymousTypes.get(token);
              }
              identifier = "anonymous_token_" + found + "_";
          }
          return sanitizeIdentifier(identifier);
      };
      /**
       * @param {?} type
       * @return {?}
       */
      CompileMetadataResolver.prototype.clearCacheFor = function (type) {
          var /** @type {?} */ dirMeta = this._directiveCache.get(type);
          this._directiveCache.delete(type);
          this._directiveSummaryCache.delete(type);
          this._pipeCache.delete(type);
          this._pipeSummaryCache.delete(type);
          this._ngModuleOfTypes.delete(type);
          // Clear all of the NgModule as they contain transitive information!
          this._ngModuleCache.clear();
          if (dirMeta) {
              this._directiveNormalizer.clearCacheFor(dirMeta);
          }
      };
      /**
       * @return {?}
       */
      CompileMetadataResolver.prototype.clearCache = function () {
          this._directiveCache.clear();
          this._directiveSummaryCache.clear();
          this._pipeCache.clear();
          this._pipeSummaryCache.clear();
          this._ngModuleCache.clear();
          this._ngModuleOfTypes.clear();
          this._directiveNormalizer.clearCache();
      };
      /**
       * @param {?} entry
       * @return {?}
       */
      CompileMetadataResolver.prototype.getAnimationEntryMetadata = function (entry) {
          var _this = this;
          var /** @type {?} */ defs = entry.definitions.map(function (def) { return _this._getAnimationStateMetadata(def); });
          return new CompileAnimationEntryMetadata(entry.name, defs);
      };
      /**
       * @param {?} value
       * @return {?}
       */
      CompileMetadataResolver.prototype._getAnimationStateMetadata = function (value) {
          if (value instanceof _angular_core.AnimationStateDeclarationMetadata) {
              var /** @type {?} */ styles = this._getAnimationStyleMetadata(value.styles);
              return new CompileAnimationStateDeclarationMetadata(value.stateNameExpr, styles);
          }
          if (value instanceof _angular_core.AnimationStateTransitionMetadata) {
              return new CompileAnimationStateTransitionMetadata(value.stateChangeExpr, this._getAnimationMetadata(value.steps));
          }
          return null;
      };
      /**
       * @param {?} value
       * @return {?}
       */
      CompileMetadataResolver.prototype._getAnimationStyleMetadata = function (value) {
          return new CompileAnimationStyleMetadata(value.offset, value.styles);
      };
      /**
       * @param {?} value
       * @return {?}
       */
      CompileMetadataResolver.prototype._getAnimationMetadata = function (value) {
          var _this = this;
          if (value instanceof _angular_core.AnimationStyleMetadata) {
              return this._getAnimationStyleMetadata(value);
          }
          if (value instanceof _angular_core.AnimationKeyframesSequenceMetadata) {
              return new CompileAnimationKeyframesSequenceMetadata(value.steps.map(function (entry) { return _this._getAnimationStyleMetadata(entry); }));
          }
          if (value instanceof _angular_core.AnimationAnimateMetadata) {
              var /** @type {?} */ animateData = (this
                  ._getAnimationMetadata(value.styles));
              return new CompileAnimationAnimateMetadata(value.timings, animateData);
          }
          if (value instanceof _angular_core.AnimationWithStepsMetadata) {
              var /** @type {?} */ steps = value.steps.map(function (step) { return _this._getAnimationMetadata(step); });
              if (value instanceof _angular_core.AnimationGroupMetadata) {
                  return new CompileAnimationGroupMetadata(steps);
              }
              return new CompileAnimationSequenceMetadata(steps);
          }
          return null;
      };
      /**
       * @param {?} directiveType
       * @param {?} isSync
       * @return {?}
       */
      CompileMetadataResolver.prototype._loadDirectiveMetadata = function (directiveType, isSync) {
          var _this = this;
          if (this._directiveCache.has(directiveType)) {
              return;
          }
          directiveType = _angular_core.resolveForwardRef(directiveType);
          var /** @type {?} */ nonNormalizedMetadata = this.getNonNormalizedDirectiveMetadata(directiveType);
          var /** @type {?} */ createDirectiveMetadata = function (templateMetadata) {
              var /** @type {?} */ normalizedDirMeta = new CompileDirectiveMetadata({
                  type: nonNormalizedMetadata.type,
                  isComponent: nonNormalizedMetadata.isComponent,
                  selector: nonNormalizedMetadata.selector,
                  exportAs: nonNormalizedMetadata.exportAs,
                  changeDetection: nonNormalizedMetadata.changeDetection,
                  inputs: nonNormalizedMetadata.inputs,
                  outputs: nonNormalizedMetadata.outputs,
                  hostListeners: nonNormalizedMetadata.hostListeners,
                  hostProperties: nonNormalizedMetadata.hostProperties,
                  hostAttributes: nonNormalizedMetadata.hostAttributes,
                  providers: nonNormalizedMetadata.providers,
                  viewProviders: nonNormalizedMetadata.viewProviders,
                  queries: nonNormalizedMetadata.queries,
                  viewQueries: nonNormalizedMetadata.viewQueries,
                  entryComponents: nonNormalizedMetadata.entryComponents,
                  template: templateMetadata
              });
              _this._directiveCache.set(directiveType, normalizedDirMeta);
              _this._directiveSummaryCache.set(directiveType, normalizedDirMeta.toSummary());
              return normalizedDirMeta;
          };
          if (nonNormalizedMetadata.isComponent) {
              var /** @type {?} */ templateMeta = this._directiveNormalizer.normalizeTemplate({
                  componentType: directiveType,
                  moduleUrl: nonNormalizedMetadata.type.moduleUrl,
                  encapsulation: nonNormalizedMetadata.template.encapsulation,
                  template: nonNormalizedMetadata.template.template,
                  templateUrl: nonNormalizedMetadata.template.templateUrl,
                  styles: nonNormalizedMetadata.template.styles,
                  styleUrls: nonNormalizedMetadata.template.styleUrls,
                  animations: nonNormalizedMetadata.template.animations,
                  interpolation: nonNormalizedMetadata.template.interpolation
              });
              if (templateMeta.syncResult) {
                  createDirectiveMetadata(templateMeta.syncResult);
                  return null;
              }
              else {
                  if (isSync) {
                      throw new ComponentStillLoadingError(directiveType);
                  }
                  return templateMeta.asyncResult.then(createDirectiveMetadata);
              }
          }
          else {
              // directive
              createDirectiveMetadata(null);
              return null;
          }
      };
      /**
       * @param {?} directiveType
       * @return {?}
       */
      CompileMetadataResolver.prototype.getNonNormalizedDirectiveMetadata = function (directiveType) {
          var _this = this;
          directiveType = _angular_core.resolveForwardRef(directiveType);
          var /** @type {?} */ dirMeta = this._directiveResolver.resolve(directiveType);
          if (!dirMeta) {
              return null;
          }
          var /** @type {?} */ moduleUrl = staticTypeModuleUrl(directiveType);
          var /** @type {?} */ nonNormalizedTemplateMetadata;
          if (dirMeta instanceof _angular_core.Component) {
              // component
              moduleUrl = componentModuleUrl(this._reflector, directiveType, dirMeta);
              assertArrayOfStrings('styles', dirMeta.styles);
              assertArrayOfStrings('styleUrls', dirMeta.styleUrls);
              assertInterpolationSymbols('interpolation', dirMeta.interpolation);
              var /** @type {?} */ animations = dirMeta.animations ?
                  dirMeta.animations.map(function (e) { return _this.getAnimationEntryMetadata(e); }) :
                  null;
              nonNormalizedTemplateMetadata = new CompileTemplateMetadata({
                  encapsulation: dirMeta.encapsulation,
                  template: dirMeta.template,
                  templateUrl: dirMeta.templateUrl,
                  styles: dirMeta.styles,
                  styleUrls: dirMeta.styleUrls,
                  animations: animations,
                  interpolation: dirMeta.interpolation
              });
          }
          var /** @type {?} */ changeDetectionStrategy = null;
          var /** @type {?} */ viewProviders = [];
          var /** @type {?} */ entryComponentMetadata = [];
          var /** @type {?} */ selector = dirMeta.selector;
          if (dirMeta instanceof _angular_core.Component) {
              // Component
              changeDetectionStrategy = dirMeta.changeDetection;
              if (dirMeta.viewProviders) {
                  viewProviders = this._getProvidersMetadata(dirMeta.viewProviders, entryComponentMetadata, "viewProviders for \"" + stringify(directiveType) + "\"");
              }
              if (dirMeta.entryComponents) {
                  entryComponentMetadata =
                      flattenAndDedupeArray(dirMeta.entryComponents)
                          .map(function (type) { return _this._getIdentifierMetadata(type, staticTypeModuleUrl(type)); })
                          .concat(entryComponentMetadata);
              }
              if (!selector) {
                  selector = this._schemaRegistry.getDefaultComponentElementName();
              }
          }
          else {
              // Directive
              if (!selector) {
                  throw new Error("Directive " + stringify(directiveType) + " has no selector, please add it!");
              }
          }
          var /** @type {?} */ providers = [];
          if (isPresent(dirMeta.providers)) {
              providers = this._getProvidersMetadata(dirMeta.providers, entryComponentMetadata, "providers for \"" + stringify(directiveType) + "\"");
          }
          var /** @type {?} */ queries = [];
          var /** @type {?} */ viewQueries = [];
          if (isPresent(dirMeta.queries)) {
              queries = this._getQueriesMetadata(dirMeta.queries, false, directiveType);
              viewQueries = this._getQueriesMetadata(dirMeta.queries, true, directiveType);
          }
          return CompileDirectiveMetadata.create({
              selector: selector,
              exportAs: dirMeta.exportAs,
              isComponent: !!nonNormalizedTemplateMetadata,
              type: this._getTypeMetadata(directiveType, moduleUrl),
              template: nonNormalizedTemplateMetadata,
              changeDetection: changeDetectionStrategy,
              inputs: dirMeta.inputs,
              outputs: dirMeta.outputs,
              host: dirMeta.host,
              providers: providers,
              viewProviders: viewProviders,
              queries: queries,
              viewQueries: viewQueries,
              entryComponents: entryComponentMetadata
          });
      };
      /**
       *  Gets the metadata for the given directive.
        * This assumes `loadNgModuleMetadata` has been called first.
       * @param {?} directiveType
       * @return {?}
       */
      CompileMetadataResolver.prototype.getDirectiveMetadata = function (directiveType) {
          var /** @type {?} */ dirMeta = this._directiveCache.get(directiveType);
          if (!dirMeta) {
              throw new Error("Illegal state: getDirectiveMetadata can only be called after loadNgModuleMetadata for a module that declares it. Directive " + stringify(directiveType) + ".");
          }
          return dirMeta;
      };
      /**
       * @param {?} dirType
       * @return {?}
       */
      CompileMetadataResolver.prototype.getDirectiveSummary = function (dirType) {
          var /** @type {?} */ dirSummary = this._directiveSummaryCache.get(dirType);
          if (!dirSummary) {
              throw new Error("Illegal state: getDirectiveSummary can only be called after loadNgModuleMetadata for a module that imports it. Directive " + stringify(dirType) + ".");
          }
          return dirSummary;
      };
      /**
       * @param {?} type
       * @return {?}
       */
      CompileMetadataResolver.prototype.isDirective = function (type) { return this._directiveResolver.isDirective(type); };
      /**
       * @param {?} type
       * @return {?}
       */
      CompileMetadataResolver.prototype.isPipe = function (type) { return this._pipeResolver.isPipe(type); };
      /**
       *  Gets the metadata for the given module.
        * This assumes `loadNgModuleMetadata` has been called first.
       * @param {?} moduleType
       * @return {?}
       */
      CompileMetadataResolver.prototype.getNgModuleMetadata = function (moduleType) {
          var /** @type {?} */ modMeta = this._ngModuleCache.get(moduleType);
          if (!modMeta) {
              throw new Error("Illegal state: getNgModuleMetadata can only be called after loadNgModuleMetadata. Module " + stringify(moduleType) + ".");
          }
          return modMeta;
      };
      /**
       * @param {?} moduleType
       * @param {?} isSync
       * @return {?}
       */
      CompileMetadataResolver.prototype._loadNgModuleSummary = function (moduleType, isSync) {
          // TODO(tbosch): add logic to read summary files!
          // - needs to add directive / pipe summaries to this._directiveSummaryCache /
          // this._pipeSummaryCache as well!
          var /** @type {?} */ moduleMeta = this._loadNgModuleMetadata(moduleType, isSync, false);
          return moduleMeta ? moduleMeta.toSummary() : null;
      };
      /**
       *  Loads an NgModule and all of its directives. This includes loading the exported directives of
        * imported modules,
        * but not private directives of imported modules.
       * @param {?} moduleType
       * @param {?} isSync
       * @param {?=} throwIfNotFound
       * @return {?}
       */
      CompileMetadataResolver.prototype.loadNgModuleMetadata = function (moduleType, isSync, throwIfNotFound) {
          if (throwIfNotFound === void 0) { throwIfNotFound = true; }
          var /** @type {?} */ ngModule = this._loadNgModuleMetadata(moduleType, isSync, throwIfNotFound);
          var /** @type {?} */ loading = ngModule ?
              Promise.all(ngModule.transitiveModule.directiveLoaders.map(function (loader) { return loader(); })) :
              Promise.resolve(null);
          return { ngModule: ngModule, loading: loading };
      };
      /**
       *  Get the NgModule metadata without loading the directives.
       * @param {?} moduleType
       * @param {?} isSync
       * @param {?=} throwIfNotFound
       * @return {?}
       */
      CompileMetadataResolver.prototype.getUnloadedNgModuleMetadata = function (moduleType, isSync, throwIfNotFound) {
          if (throwIfNotFound === void 0) { throwIfNotFound = true; }
          return this._loadNgModuleMetadata(moduleType, isSync, throwIfNotFound);
      };
      /**
       * @param {?} moduleType
       * @param {?} isSync
       * @param {?=} throwIfNotFound
       * @return {?}
       */
      CompileMetadataResolver.prototype._loadNgModuleMetadata = function (moduleType, isSync, throwIfNotFound) {
          var _this = this;
          if (throwIfNotFound === void 0) { throwIfNotFound = true; }
          moduleType = _angular_core.resolveForwardRef(moduleType);
          var /** @type {?} */ compileMeta = this._ngModuleCache.get(moduleType);
          if (compileMeta) {
              return compileMeta;
          }
          var /** @type {?} */ meta = this._ngModuleResolver.resolve(moduleType, throwIfNotFound);
          if (!meta) {
              return null;
          }
          var /** @type {?} */ declaredDirectives = [];
          var /** @type {?} */ exportedNonModuleIdentifiers = [];
          var /** @type {?} */ declaredPipes = [];
          var /** @type {?} */ importedModules = [];
          var /** @type {?} */ exportedModules = [];
          var /** @type {?} */ providers = [];
          var /** @type {?} */ entryComponents = [];
          var /** @type {?} */ bootstrapComponents = [];
          var /** @type {?} */ schemas = [];
          if (meta.imports) {
              flattenAndDedupeArray(meta.imports).forEach(function (importedType) {
                  var /** @type {?} */ importedModuleType;
                  if (isValidType(importedType)) {
                      importedModuleType = importedType;
                  }
                  else if (importedType && importedType.ngModule) {
                      var /** @type {?} */ moduleWithProviders = importedType;
                      importedModuleType = moduleWithProviders.ngModule;
                      if (moduleWithProviders.providers) {
                          providers.push.apply(providers, _this._getProvidersMetadata(moduleWithProviders.providers, entryComponents, "provider for the NgModule '" + stringify(importedModuleType) + "'"));
                      }
                  }
                  if (importedModuleType) {
                      var /** @type {?} */ importedModuleSummary = _this._loadNgModuleSummary(importedModuleType, isSync);
                      if (!importedModuleSummary) {
                          throw new Error("Unexpected " + _this._getTypeDescriptor(importedType) + " '" + stringify(importedType) + "' imported by the module '" + stringify(moduleType) + "'");
                      }
                      importedModules.push(importedModuleSummary);
                  }
                  else {
                      throw new Error("Unexpected value '" + stringify(importedType) + "' imported by the module '" + stringify(moduleType) + "'");
                  }
              });
          }
          if (meta.exports) {
              flattenAndDedupeArray(meta.exports).forEach(function (exportedType) {
                  if (!isValidType(exportedType)) {
                      throw new Error("Unexpected value '" + stringify(exportedType) + "' exported by the module '" + stringify(moduleType) + "'");
                  }
                  var /** @type {?} */ exportedModuleSummary = _this._loadNgModuleSummary(exportedType, isSync);
                  if (exportedModuleSummary) {
                      exportedModules.push(exportedModuleSummary);
                  }
                  else {
                      exportedNonModuleIdentifiers.push(_this._getIdentifierMetadata(exportedType, staticTypeModuleUrl(exportedType)));
                  }
              });
          }
          // Note: This will be modified later, so we rely on
          // getting a new instance every time!
          var /** @type {?} */ transitiveModule = this._getTransitiveNgModuleMetadata(importedModules, exportedModules);
          if (meta.declarations) {
              flattenAndDedupeArray(meta.declarations).forEach(function (declaredType) {
                  if (!isValidType(declaredType)) {
                      throw new Error("Unexpected value '" + stringify(declaredType) + "' declared by the module '" + stringify(moduleType) + "'");
                  }
                  var /** @type {?} */ declaredIdentifier = _this._getIdentifierMetadata(declaredType, staticTypeModuleUrl(declaredType));
                  if (_this._directiveResolver.isDirective(declaredType)) {
                      transitiveModule.directivesSet.add(declaredType);
                      transitiveModule.directives.push(declaredIdentifier);
                      declaredDirectives.push(declaredIdentifier);
                      _this._addTypeToModule(declaredType, moduleType);
                      transitiveModule.directiveLoaders.push(function () { return _this._loadDirectiveMetadata(declaredType, isSync); });
                  }
                  else if (_this._pipeResolver.isPipe(declaredType)) {
                      transitiveModule.pipesSet.add(declaredType);
                      transitiveModule.pipes.push(declaredIdentifier);
                      declaredPipes.push(declaredIdentifier);
                      _this._addTypeToModule(declaredType, moduleType);
                      _this._loadPipeMetadata(declaredType);
                  }
                  else {
                      throw new Error("Unexpected " + _this._getTypeDescriptor(declaredType) + " '" + stringify(declaredType) + "' declared by the module '" + stringify(moduleType) + "'");
                  }
              });
          }
          var /** @type {?} */ exportedDirectives = [];
          var /** @type {?} */ exportedPipes = [];
          exportedNonModuleIdentifiers.forEach(function (exportedId) {
              if (transitiveModule.directivesSet.has(exportedId.reference)) {
                  exportedDirectives.push(exportedId);
              }
              else if (transitiveModule.pipesSet.has(exportedId.reference)) {
                  exportedPipes.push(exportedId);
              }
              else {
                  throw new Error("Can't export " + _this._getTypeDescriptor(exportedId.reference) + " " + stringify(exportedId.reference) + " from " + stringify(moduleType) + " as it was neither declared nor imported!");
              }
          });
          // The providers of the module have to go last
          // so that they overwrite any other provider we already added.
          if (meta.providers) {
              providers.push.apply(providers, this._getProvidersMetadata(meta.providers, entryComponents, "provider for the NgModule '" + stringify(moduleType) + "'"));
          }
          if (meta.entryComponents) {
              entryComponents.push.apply(entryComponents, flattenAndDedupeArray(meta.entryComponents)
                  .map(function (type) { return _this._getTypeMetadata(type, staticTypeModuleUrl(type)); }));
          }
          if (meta.bootstrap) {
              var /** @type {?} */ typeMetadata = flattenAndDedupeArray(meta.bootstrap).map(function (type) {
                  if (!isValidType(type)) {
                      throw new Error("Unexpected value '" + stringify(type) + "' used in the bootstrap property of module '" + stringify(moduleType) + "'");
                  }
                  return _this._getTypeMetadata(type, staticTypeModuleUrl(type));
              });
              bootstrapComponents.push.apply(bootstrapComponents, typeMetadata);
          }
          entryComponents.push.apply(entryComponents, bootstrapComponents);
          if (meta.schemas) {
              schemas.push.apply(schemas, flattenAndDedupeArray(meta.schemas));
          }
          (_a = transitiveModule.entryComponents).push.apply(_a, entryComponents);
          (_b = transitiveModule.providers).push.apply(_b, providers);
          compileMeta = new CompileNgModuleMetadata({
              type: this._getTypeMetadata(moduleType, staticTypeModuleUrl(moduleType)),
              providers: providers,
              entryComponents: entryComponents,
              bootstrapComponents: bootstrapComponents,
              schemas: schemas,
              declaredDirectives: declaredDirectives,
              exportedDirectives: exportedDirectives,
              declaredPipes: declaredPipes,
              exportedPipes: exportedPipes,
              importedModules: importedModules,
              exportedModules: exportedModules,
              transitiveModule: transitiveModule,
              id: meta.id,
          });
          transitiveModule.modules.push(compileMeta.toInjectorSummary());
          this._ngModuleCache.set(moduleType, compileMeta);
          return compileMeta;
          var _a, _b;
      };
      /**
       * @param {?} type
       * @return {?}
       */
      CompileMetadataResolver.prototype._getTypeDescriptor = function (type) {
          if (this._directiveResolver.isDirective(type)) {
              return 'directive';
          }
          if (this._pipeResolver.isPipe(type)) {
              return 'pipe';
          }
          if (this._ngModuleResolver.isNgModule(type)) {
              return 'module';
          }
          if (((type)).provide) {
              return 'provider';
          }
          return 'value';
      };
      /**
       * @param {?} type
       * @param {?} moduleType
       * @return {?}
       */
      CompileMetadataResolver.prototype._addTypeToModule = function (type, moduleType) {
          var /** @type {?} */ oldModule = this._ngModuleOfTypes.get(type);
          if (oldModule && oldModule !== moduleType) {
              throw new Error(("Type " + stringify(type) + " is part of the declarations of 2 modules: " + stringify(oldModule) + " and " + stringify(moduleType) + "! ") +
                  ("Please consider moving " + stringify(type) + " to a higher module that imports " + stringify(oldModule) + " and " + stringify(moduleType) + ". ") +
                  ("You can also create a new NgModule that exports and includes " + stringify(type) + " then import that NgModule in " + stringify(oldModule) + " and " + stringify(moduleType) + "."));
          }
          this._ngModuleOfTypes.set(type, moduleType);
      };
      /**
       * @param {?} importedModules
       * @param {?} exportedModules
       * @return {?}
       */
      CompileMetadataResolver.prototype._getTransitiveNgModuleMetadata = function (importedModules, exportedModules) {
          // collect `providers` / `entryComponents` from all imported and all exported modules
          var /** @type {?} */ transitiveModules = getTransitiveImportedModules(importedModules.concat(exportedModules));
          var /** @type {?} */ providers = flattenArray(transitiveModules.map(function (ngModule) { return ngModule.providers; }));
          var /** @type {?} */ entryComponents = flattenArray(transitiveModules.map(function (ngModule) { return ngModule.entryComponents; }));
          var /** @type {?} */ transitiveExportedModules = getTransitiveExportedModules(importedModules);
          var /** @type {?} */ directives = flattenArray(transitiveExportedModules.map(function (ngModule) { return ngModule.exportedDirectives; }));
          var /** @type {?} */ pipes = flattenArray(transitiveExportedModules.map(function (ngModule) { return ngModule.exportedPipes; }));
          var /** @type {?} */ directiveLoaders = ListWrapper.flatten(transitiveExportedModules.map(function (ngModule) { return ngModule.directiveLoaders; }));
          return new TransitiveCompileNgModuleMetadata(transitiveModules, providers, entryComponents, directives, pipes, directiveLoaders);
      };
      /**
       * @param {?} type
       * @param {?} moduleUrl
       * @return {?}
       */
      CompileMetadataResolver.prototype._getIdentifierMetadata = function (type, moduleUrl) {
          type = _angular_core.resolveForwardRef(type);
          return new CompileIdentifierMetadata({ name: this.sanitizeTokenName(type), moduleUrl: moduleUrl, reference: type });
      };
      /**
       * @param {?} type
       * @param {?} moduleUrl
       * @param {?=} dependencies
       * @return {?}
       */
      CompileMetadataResolver.prototype._getTypeMetadata = function (type, moduleUrl, dependencies) {
          if (dependencies === void 0) { dependencies = null; }
          var /** @type {?} */ identifier = this._getIdentifierMetadata(type, moduleUrl);
          return new CompileTypeMetadata({
              name: identifier.name,
              moduleUrl: identifier.moduleUrl,
              reference: identifier.reference,
              diDeps: this._getDependenciesMetadata(identifier.reference, dependencies),
              lifecycleHooks: LIFECYCLE_HOOKS_VALUES.filter(function (hook) { return hasLifecycleHook(hook, identifier.reference); }),
          });
      };
      /**
       * @param {?} factory
       * @param {?} moduleUrl
       * @param {?=} dependencies
       * @return {?}
       */
      CompileMetadataResolver.prototype._getFactoryMetadata = function (factory, moduleUrl, dependencies) {
          if (dependencies === void 0) { dependencies = null; }
          factory = _angular_core.resolveForwardRef(factory);
          return new CompileFactoryMetadata({
              name: this.sanitizeTokenName(factory),
              moduleUrl: moduleUrl,
              reference: factory,
              diDeps: this._getDependenciesMetadata(factory, dependencies)
          });
      };
      /**
       *  Gets the metadata for the given pipe.
        * This assumes `loadNgModuleMetadata` has been called first.
       * @param {?} pipeType
       * @return {?}
       */
      CompileMetadataResolver.prototype.getPipeMetadata = function (pipeType) {
          var /** @type {?} */ pipeMeta = this._pipeCache.get(pipeType);
          if (!pipeMeta) {
              throw new Error("Illegal state: getPipeMetadata can only be called after loadNgModuleMetadata for a module that declares it. Pipe " + stringify(pipeType) + ".");
          }
          return pipeMeta;
      };
      /**
       * @param {?} pipeType
       * @return {?}
       */
      CompileMetadataResolver.prototype.getPipeSummary = function (pipeType) {
          var /** @type {?} */ pipeSummary = this._pipeSummaryCache.get(pipeType);
          if (!pipeSummary) {
              throw new Error("Illegal state: getPipeSummary can only be called after loadNgModuleMetadata for a module that imports it. Pipe " + stringify(pipeType) + ".");
          }
          return pipeSummary;
      };
      /**
       * @param {?} pipeType
       * @return {?}
       */
      CompileMetadataResolver.prototype.getOrLoadPipeMetadata = function (pipeType) {
          var /** @type {?} */ pipeMeta = this._pipeCache.get(pipeType);
          if (!pipeMeta) {
              pipeMeta = this._loadPipeMetadata(pipeType);
          }
          return pipeMeta;
      };
      /**
       * @param {?} pipeType
       * @return {?}
       */
      CompileMetadataResolver.prototype._loadPipeMetadata = function (pipeType) {
          pipeType = _angular_core.resolveForwardRef(pipeType);
          var /** @type {?} */ pipeAnnotation = this._pipeResolver.resolve(pipeType);
          var /** @type {?} */ pipeMeta = new CompilePipeMetadata({
              type: this._getTypeMetadata(pipeType, staticTypeModuleUrl(pipeType)),
              name: pipeAnnotation.name,
              pure: pipeAnnotation.pure
          });
          this._pipeCache.set(pipeType, pipeMeta);
          this._pipeSummaryCache.set(pipeType, pipeMeta.toSummary());
          return pipeMeta;
      };
      /**
       * @param {?} typeOrFunc
       * @param {?} dependencies
       * @return {?}
       */
      CompileMetadataResolver.prototype._getDependenciesMetadata = function (typeOrFunc, dependencies) {
          var _this = this;
          var /** @type {?} */ hasUnknownDeps = false;
          var /** @type {?} */ params = dependencies || this._reflector.parameters(typeOrFunc) || [];
          var /** @type {?} */ dependenciesMetadata = params.map(function (param) {
              var /** @type {?} */ isAttribute = false;
              var /** @type {?} */ isHost = false;
              var /** @type {?} */ isSelf = false;
              var /** @type {?} */ isSkipSelf = false;
              var /** @type {?} */ isOptional = false;
              var /** @type {?} */ token = null;
              if (Array.isArray(param)) {
                  param.forEach(function (paramEntry) {
                      if (paramEntry instanceof _angular_core.Host) {
                          isHost = true;
                      }
                      else if (paramEntry instanceof _angular_core.Self) {
                          isSelf = true;
                      }
                      else if (paramEntry instanceof _angular_core.SkipSelf) {
                          isSkipSelf = true;
                      }
                      else if (paramEntry instanceof _angular_core.Optional) {
                          isOptional = true;
                      }
                      else if (paramEntry instanceof _angular_core.Attribute) {
                          isAttribute = true;
                          token = paramEntry.attributeName;
                      }
                      else if (paramEntry instanceof _angular_core.Inject) {
                          token = paramEntry.token;
                      }
                      else if (isValidType(paramEntry) && isBlank(token)) {
                          token = paramEntry;
                      }
                  });
              }
              else {
                  token = param;
              }
              if (isBlank(token)) {
                  hasUnknownDeps = true;
                  return null;
              }
              return new CompileDiDependencyMetadata({
                  isAttribute: isAttribute,
                  isHost: isHost,
                  isSelf: isSelf,
                  isSkipSelf: isSkipSelf,
                  isOptional: isOptional,
                  token: _this._getTokenMetadata(token)
              });
          });
          if (hasUnknownDeps) {
              var /** @type {?} */ depsTokens = dependenciesMetadata.map(function (dep) { return dep ? stringify(dep.token) : '?'; }).join(', ');
              throw new Error("Can't resolve all parameters for " + stringify(typeOrFunc) + ": (" + depsTokens + ").");
          }
          return dependenciesMetadata;
      };
      /**
       * @param {?} token
       * @return {?}
       */
      CompileMetadataResolver.prototype._getTokenMetadata = function (token) {
          token = _angular_core.resolveForwardRef(token);
          var /** @type {?} */ compileToken;
          if (typeof token === 'string') {
              compileToken = new CompileTokenMetadata({ value: token });
          }
          else {
              compileToken = new CompileTokenMetadata({
                  identifier: new CompileIdentifierMetadata({
                      reference: token,
                      name: this.sanitizeTokenName(token),
                      moduleUrl: staticTypeModuleUrl(token)
                  })
              });
          }
          return compileToken;
      };
      /**
       * @param {?} providers
       * @param {?} targetEntryComponents
       * @param {?=} debugInfo
       * @return {?}
       */
      CompileMetadataResolver.prototype._getProvidersMetadata = function (providers, targetEntryComponents, debugInfo) {
          var _this = this;
          var /** @type {?} */ compileProviders = [];
          providers.forEach(function (provider, providerIdx) {
              provider = _angular_core.resolveForwardRef(provider);
              if (provider && typeof provider == 'object' && provider.hasOwnProperty('provide')) {
                  provider = new ProviderMeta(provider.provide, provider);
              }
              var /** @type {?} */ compileProvider;
              if (Array.isArray(provider)) {
                  compileProvider = _this._getProvidersMetadata(provider, targetEntryComponents, debugInfo);
              }
              else if (provider instanceof ProviderMeta) {
                  var /** @type {?} */ tokenMeta = _this._getTokenMetadata(provider.token);
                  if (tokenMeta.reference ===
                      resolveIdentifierToken(Identifiers.ANALYZE_FOR_ENTRY_COMPONENTS).reference) {
                      targetEntryComponents.push.apply(targetEntryComponents, _this._getEntryComponentsFromProvider(provider));
                  }
                  else {
                      compileProvider = _this.getProviderMetadata(provider);
                  }
              }
              else if (isValidType(provider)) {
                  compileProvider = _this._getTypeMetadata(provider, staticTypeModuleUrl(provider));
              }
              else {
                  var /** @type {?} */ providersInfo = ((providers.reduce(function (soFar, seenProvider, seenProviderIdx) {
                      if (seenProviderIdx < providerIdx) {
                          soFar.push("" + stringify(seenProvider));
                      }
                      else if (seenProviderIdx == providerIdx) {
                          soFar.push("?" + stringify(seenProvider) + "?");
                      }
                      else if (seenProviderIdx == providerIdx + 1) {
                          soFar.push('...');
                      }
                      return soFar;
                  }, [])))
                      .join(', ');
                  throw new Error("Invalid " + (debugInfo ? debugInfo : 'provider') + " - only instances of Provider and Type are allowed, got: [" + providersInfo + "]");
              }
              if (compileProvider) {
                  compileProviders.push(compileProvider);
              }
          });
          return compileProviders;
      };
      /**
       * @param {?} provider
       * @return {?}
       */
      CompileMetadataResolver.prototype._getEntryComponentsFromProvider = function (provider) {
          var _this = this;
          var /** @type {?} */ components = [];
          var /** @type {?} */ collectedIdentifiers = [];
          if (provider.useFactory || provider.useExisting || provider.useClass) {
              throw new Error("The ANALYZE_FOR_ENTRY_COMPONENTS token only supports useValue!");
          }
          if (!provider.multi) {
              throw new Error("The ANALYZE_FOR_ENTRY_COMPONENTS token only supports 'multi = true'!");
          }
          convertToCompileValue(provider.useValue, collectedIdentifiers);
          collectedIdentifiers.forEach(function (identifier) {
              if (_this._directiveResolver.isDirective(identifier.reference)) {
                  components.push(identifier);
              }
          });
          return components;
      };
      /**
       * @param {?} provider
       * @return {?}
       */
      CompileMetadataResolver.prototype.getProviderMetadata = function (provider) {
          var /** @type {?} */ compileDeps;
          var /** @type {?} */ compileTypeMetadata = null;
          var /** @type {?} */ compileFactoryMetadata = null;
          if (provider.useClass) {
              compileTypeMetadata = this._getTypeMetadata(provider.useClass, staticTypeModuleUrl(provider.useClass), provider.dependencies);
              compileDeps = compileTypeMetadata.diDeps;
          }
          else if (provider.useFactory) {
              compileFactoryMetadata = this._getFactoryMetadata(provider.useFactory, staticTypeModuleUrl(provider.useFactory), provider.dependencies);
              compileDeps = compileFactoryMetadata.diDeps;
          }
          return new CompileProviderMetadata({
              token: this._getTokenMetadata(provider.token),
              useClass: compileTypeMetadata,
              useValue: convertToCompileValue(provider.useValue, []),
              useFactory: compileFactoryMetadata,
              useExisting: provider.useExisting ? this._getTokenMetadata(provider.useExisting) : null,
              deps: compileDeps,
              multi: provider.multi
          });
      };
      /**
       * @param {?} queries
       * @param {?} isViewQuery
       * @param {?} directiveType
       * @return {?}
       */
      CompileMetadataResolver.prototype._getQueriesMetadata = function (queries, isViewQuery, directiveType) {
          var _this = this;
          var /** @type {?} */ res = [];
          Object.keys(queries).forEach(function (propertyName) {
              var /** @type {?} */ query = queries[propertyName];
              if (query.isViewQuery === isViewQuery) {
                  res.push(_this._getQueryMetadata(query, propertyName, directiveType));
              }
          });
          return res;
      };
      /**
       * @param {?} selector
       * @return {?}
       */
      CompileMetadataResolver.prototype._queryVarBindings = function (selector) { return selector.split(/\s*,\s*/); };
      /**
       * @param {?} q
       * @param {?} propertyName
       * @param {?} typeOrFunc
       * @return {?}
       */
      CompileMetadataResolver.prototype._getQueryMetadata = function (q, propertyName, typeOrFunc) {
          var _this = this;
          var /** @type {?} */ selectors;
          if (typeof q.selector === 'string') {
              selectors =
                  this._queryVarBindings(q.selector).map(function (varName) { return _this._getTokenMetadata(varName); });
          }
          else {
              if (!q.selector) {
                  throw new Error("Can't construct a query for the property \"" + propertyName + "\" of \"" + stringify(typeOrFunc) + "\" since the query selector wasn't defined.");
              }
              selectors = [this._getTokenMetadata(q.selector)];
          }
          return new CompileQueryMetadata({
              selectors: selectors,
              first: q.first,
              descendants: q.descendants, propertyName: propertyName,
              read: q.read ? this._getTokenMetadata(q.read) : null
          });
      };
      CompileMetadataResolver.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      CompileMetadataResolver.ctorParameters = function () { return [
          { type: NgModuleResolver, },
          { type: DirectiveResolver, },
          { type: PipeResolver, },
          { type: ElementSchemaRegistry, },
          { type: DirectiveNormalizer, },
          { type: ReflectorReader, },
      ]; };
      return CompileMetadataResolver;
  }());
  /**
   * @param {?} modules
   * @param {?=} targetModules
   * @param {?=} visitedModules
   * @return {?}
   */
  function getTransitiveExportedModules(modules, targetModules, visitedModules) {
      if (targetModules === void 0) { targetModules = []; }
      if (visitedModules === void 0) { visitedModules = new Set(); }
      modules.forEach(function (ngModule) {
          if (!visitedModules.has(ngModule.type.reference)) {
              visitedModules.add(ngModule.type.reference);
              getTransitiveExportedModules(ngModule.exportedModules, targetModules, visitedModules);
              // Add after recursing so imported/exported modules are before the module itself.
              // This is important for overwriting providers of imported modules!
              targetModules.push(ngModule);
          }
      });
      return targetModules;
  }
  /**
   * @param {?} modules
   * @param {?=} targetModules
   * @param {?=} visitedModules
   * @return {?}
   */
  function getTransitiveImportedModules(modules, targetModules, visitedModules) {
      if (targetModules === void 0) { targetModules = []; }
      if (visitedModules === void 0) { visitedModules = new Set(); }
      modules.forEach(function (ngModule) {
          if (!visitedModules.has(ngModule.type.reference)) {
              visitedModules.add(ngModule.type.reference);
              var /** @type {?} */ nestedModules = ngModule.importedModules.concat(ngModule.exportedModules);
              getTransitiveImportedModules(nestedModules, targetModules, visitedModules);
              // Add after recursing so imported/exported modules are before the module itself.
              // This is important for overwriting providers of imported modules!
              targetModules.push(ngModule);
          }
      });
      return targetModules;
  }
  /**
   * @param {?} tree
   * @param {?=} out
   * @return {?}
   */
  function flattenArray(tree, out) {
      if (out === void 0) { out = []; }
      if (tree) {
          for (var /** @type {?} */ i = 0; i < tree.length; i++) {
              var /** @type {?} */ item = _angular_core.resolveForwardRef(tree[i]);
              if (Array.isArray(item)) {
                  flattenArray(item, out);
              }
              else {
                  out.push(item);
              }
          }
      }
      return out;
  }
  /**
   * @param {?} array
   * @return {?}
   */
  function dedupeArray(array) {
      if (array) {
          return Array.from(new Set(array));
      }
      return [];
  }
  /**
   * @param {?} tree
   * @return {?}
   */
  function flattenAndDedupeArray(tree) {
      return dedupeArray(flattenArray(tree));
  }
  /**
   * @param {?} value
   * @return {?}
   */
  function isValidType(value) {
      return isStaticSymbol(value) || (value instanceof _angular_core.Type);
  }
  /**
   * @param {?} value
   * @return {?}
   */
  function staticTypeModuleUrl(value) {
      return isStaticSymbol(value) ? value.filePath : null;
  }
  /**
   * @param {?} reflector
   * @param {?} type
   * @param {?} cmpMetadata
   * @return {?}
   */
  function componentModuleUrl(reflector, type, cmpMetadata) {
      if (isStaticSymbol(type)) {
          return staticTypeModuleUrl(type);
      }
      var /** @type {?} */ moduleId = cmpMetadata.moduleId;
      if (typeof moduleId === 'string') {
          var /** @type {?} */ scheme = getUrlScheme(moduleId);
          return scheme ? moduleId : "package:" + moduleId + MODULE_SUFFIX;
      }
      else if (moduleId !== null && moduleId !== void 0) {
          throw new Error(("moduleId should be a string in \"" + stringify(type) + "\". See https://goo.gl/wIDDiL for more information.\n") +
              "If you're using Webpack you should inline the template and the styles, see https://goo.gl/X2J8zc.");
      }
      return reflector.importUri(type);
  }
  /**
   * @param {?} value
   * @param {?} targetIdentifiers
   * @return {?}
   */
  function convertToCompileValue(value, targetIdentifiers) {
      return visitValue(value, new _CompileValueConverter(), targetIdentifiers);
  }
  var _CompileValueConverter = (function (_super) {
      __extends$16(_CompileValueConverter, _super);
      function _CompileValueConverter() {
          _super.apply(this, arguments);
      }
      /**
       * @param {?} value
       * @param {?} targetIdentifiers
       * @return {?}
       */
      _CompileValueConverter.prototype.visitOther = function (value, targetIdentifiers) {
          var /** @type {?} */ identifier;
          if (isStaticSymbol(value)) {
              identifier = new CompileIdentifierMetadata({ name: value.name, moduleUrl: value.filePath, reference: value });
          }
          else {
              identifier = new CompileIdentifierMetadata({ reference: value });
          }
          targetIdentifiers.push(identifier);
          return identifier;
      };
      return _CompileValueConverter;
  }(ValueTransformer));

  /**
   * @param {?} value
   * @param {?=} type
   * @return {?}
   */
  function convertValueToOutputAst(value, type) {
      if (type === void 0) { type = null; }
      return visitValue(value, new _ValueOutputAstTransformer(), type);
  }
  var _ValueOutputAstTransformer = (function () {
      function _ValueOutputAstTransformer() {
      }
      /**
       * @param {?} arr
       * @param {?} type
       * @return {?}
       */
      _ValueOutputAstTransformer.prototype.visitArray = function (arr, type) {
          var _this = this;
          return literalArr(arr.map(function (value) { return visitValue(value, _this, null); }), type);
      };
      /**
       * @param {?} map
       * @param {?} type
       * @return {?}
       */
      _ValueOutputAstTransformer.prototype.visitStringMap = function (map, type) {
          var _this = this;
          var /** @type {?} */ entries = [];
          Object.keys(map).forEach(function (key) { entries.push([key, visitValue(map[key], _this, null)]); });
          return literalMap(entries, type);
      };
      /**
       * @param {?} value
       * @param {?} type
       * @return {?}
       */
      _ValueOutputAstTransformer.prototype.visitPrimitive = function (value, type) { return literal(value, type); };
      /**
       * @param {?} value
       * @param {?} type
       * @return {?}
       */
      _ValueOutputAstTransformer.prototype.visitOther = function (value, type) {
          if (value instanceof CompileIdentifierMetadata) {
              return importExpr(value);
          }
          else if (value instanceof Expression) {
              return value;
          }
          else {
              throw new Error("Illegal state: Don't now how to compile value " + value);
          }
      };
      return _ValueOutputAstTransformer;
  }());

  var ComponentFactoryDependency = (function () {
      /**
       * @param {?} comp
       * @param {?} placeholder
       */
      function ComponentFactoryDependency(comp, placeholder) {
          this.comp = comp;
          this.placeholder = placeholder;
      }
      return ComponentFactoryDependency;
  }());
  var NgModuleCompileResult = (function () {
      /**
       * @param {?} statements
       * @param {?} ngModuleFactoryVar
       * @param {?} dependencies
       */
      function NgModuleCompileResult(statements, ngModuleFactoryVar, dependencies) {
          this.statements = statements;
          this.ngModuleFactoryVar = ngModuleFactoryVar;
          this.dependencies = dependencies;
      }
      return NgModuleCompileResult;
  }());
  var NgModuleCompiler = (function () {
      function NgModuleCompiler() {
      }
      /**
       * @param {?} ngModuleMeta
       * @param {?} extraProviders
       * @return {?}
       */
      NgModuleCompiler.prototype.compile = function (ngModuleMeta, extraProviders) {
          var /** @type {?} */ sourceFileName = isPresent(ngModuleMeta.type.moduleUrl) ?
              "in NgModule " + ngModuleMeta.type.name + " in " + ngModuleMeta.type.moduleUrl :
              "in NgModule " + ngModuleMeta.type.name;
          var /** @type {?} */ sourceFile = new ParseSourceFile('', sourceFileName);
          var /** @type {?} */ sourceSpan = new ParseSourceSpan(new ParseLocation(sourceFile, null, null, null), new ParseLocation(sourceFile, null, null, null));
          var /** @type {?} */ deps = [];
          var /** @type {?} */ bootstrapComponentFactories = [];
          var /** @type {?} */ entryComponentFactories = ngModuleMeta.transitiveModule.entryComponents.map(function (entryComponent) {
              var /** @type {?} */ id = new CompileIdentifierMetadata({ name: entryComponent.name });
              if (ngModuleMeta.bootstrapComponents.indexOf(entryComponent) > -1) {
                  bootstrapComponentFactories.push(id);
              }
              deps.push(new ComponentFactoryDependency(entryComponent, id));
              return id;
          });
          var /** @type {?} */ builder = new _InjectorBuilder(ngModuleMeta, entryComponentFactories, bootstrapComponentFactories, sourceSpan);
          var /** @type {?} */ providerParser = new NgModuleProviderAnalyzer(ngModuleMeta, extraProviders, sourceSpan);
          providerParser.parse().forEach(function (provider) { return builder.addProvider(provider); });
          var /** @type {?} */ injectorClass = builder.build();
          var /** @type {?} */ ngModuleFactoryVar = ngModuleMeta.type.name + "NgFactory";
          var /** @type {?} */ ngModuleFactoryStmt = variable(ngModuleFactoryVar)
              .set(importExpr(resolveIdentifier(Identifiers.NgModuleFactory))
              .instantiate([variable(injectorClass.name), importExpr(ngModuleMeta.type)], importType(resolveIdentifier(Identifiers.NgModuleFactory), [importType(ngModuleMeta.type)], [TypeModifier.Const])))
              .toDeclStmt(null, [StmtModifier.Final]);
          var /** @type {?} */ stmts = [injectorClass, ngModuleFactoryStmt];
          if (ngModuleMeta.id) {
              var /** @type {?} */ registerFactoryStmt = importExpr(resolveIdentifier(Identifiers.RegisterModuleFactoryFn))
                  .callFn([literal(ngModuleMeta.id), variable(ngModuleFactoryVar)])
                  .toStmt();
              stmts.push(registerFactoryStmt);
          }
          return new NgModuleCompileResult(stmts, ngModuleFactoryVar, deps);
      };
      NgModuleCompiler.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      NgModuleCompiler.ctorParameters = function () { return []; };
      return NgModuleCompiler;
  }());
  var _InjectorBuilder = (function () {
      /**
       * @param {?} _ngModuleMeta
       * @param {?} _entryComponentFactories
       * @param {?} _bootstrapComponentFactories
       * @param {?} _sourceSpan
       */
      function _InjectorBuilder(_ngModuleMeta, _entryComponentFactories, _bootstrapComponentFactories, _sourceSpan) {
          this._ngModuleMeta = _ngModuleMeta;
          this._entryComponentFactories = _entryComponentFactories;
          this._bootstrapComponentFactories = _bootstrapComponentFactories;
          this._sourceSpan = _sourceSpan;
          this.fields = [];
          this.getters = [];
          this.methods = [];
          this.ctorStmts = [];
          this._tokens = [];
          this._instances = new Map();
          this._createStmts = [];
          this._destroyStmts = [];
      }
      /**
       * @param {?} resolvedProvider
       * @return {?}
       */
      _InjectorBuilder.prototype.addProvider = function (resolvedProvider) {
          var _this = this;
          var /** @type {?} */ providerValueExpressions = resolvedProvider.providers.map(function (provider) { return _this._getProviderValue(provider); });
          var /** @type {?} */ propName = "_" + resolvedProvider.token.name + "_" + this._instances.size;
          var /** @type {?} */ instance = this._createProviderProperty(propName, resolvedProvider, providerValueExpressions, resolvedProvider.multiProvider, resolvedProvider.eager);
          if (resolvedProvider.lifecycleHooks.indexOf(LifecycleHooks.OnDestroy) !== -1) {
              this._destroyStmts.push(instance.callMethod('ngOnDestroy', []).toStmt());
          }
          this._tokens.push(resolvedProvider.token);
          this._instances.set(resolvedProvider.token.reference, instance);
      };
      /**
       * @return {?}
       */
      _InjectorBuilder.prototype.build = function () {
          var _this = this;
          var /** @type {?} */ getMethodStmts = this._tokens.map(function (token) {
              var /** @type {?} */ providerExpr = _this._instances.get(token.reference);
              return new IfStmt(InjectMethodVars.token.identical(createDiTokenExpression(token)), [new ReturnStatement(providerExpr)]);
          });
          var /** @type {?} */ methods = [
              new ClassMethod('createInternal', [], this._createStmts.concat(new ReturnStatement(this._instances.get(this._ngModuleMeta.type.reference))), importType(this._ngModuleMeta.type)),
              new ClassMethod('getInternal', [
                  new FnParam(InjectMethodVars.token.name, DYNAMIC_TYPE),
                  new FnParam(InjectMethodVars.notFoundResult.name, DYNAMIC_TYPE)
              ], getMethodStmts.concat([new ReturnStatement(InjectMethodVars.notFoundResult)]), DYNAMIC_TYPE),
              new ClassMethod('destroyInternal', [], this._destroyStmts),
          ];
          var /** @type {?} */ parentArgs = [
              variable(InjectorProps.parent.name),
              literalArr(this._entryComponentFactories.map(function (componentFactory) { return importExpr(componentFactory); })),
              literalArr(this._bootstrapComponentFactories.map(function (componentFactory) { return importExpr(componentFactory); }))
          ];
          var /** @type {?} */ injClassName = this._ngModuleMeta.type.name + "Injector";
          return createClassStmt({
              name: injClassName,
              ctorParams: [new FnParam(InjectorProps.parent.name, importType(resolveIdentifier(Identifiers.Injector)))],
              parent: importExpr(resolveIdentifier(Identifiers.NgModuleInjector), [importType(this._ngModuleMeta.type)]),
              parentArgs: parentArgs,
              builders: [{ methods: methods }, this]
          });
      };
      /**
       * @param {?} provider
       * @return {?}
       */
      _InjectorBuilder.prototype._getProviderValue = function (provider) {
          var _this = this;
          var /** @type {?} */ result;
          if (isPresent(provider.useExisting)) {
              result = this._getDependency(new CompileDiDependencyMetadata({ token: provider.useExisting }));
          }
          else if (isPresent(provider.useFactory)) {
              var /** @type {?} */ deps = provider.deps || provider.useFactory.diDeps;
              var /** @type {?} */ depsExpr = deps.map(function (dep) { return _this._getDependency(dep); });
              result = importExpr(provider.useFactory).callFn(depsExpr);
          }
          else if (isPresent(provider.useClass)) {
              var /** @type {?} */ deps = provider.deps || provider.useClass.diDeps;
              var /** @type {?} */ depsExpr = deps.map(function (dep) { return _this._getDependency(dep); });
              result =
                  importExpr(provider.useClass).instantiate(depsExpr, importType(provider.useClass));
          }
          else {
              result = convertValueToOutputAst(provider.useValue);
          }
          return result;
      };
      /**
       * @param {?} propName
       * @param {?} provider
       * @param {?} providerValueExpressions
       * @param {?} isMulti
       * @param {?} isEager
       * @return {?}
       */
      _InjectorBuilder.prototype._createProviderProperty = function (propName, provider, providerValueExpressions, isMulti, isEager) {
          var /** @type {?} */ resolvedProviderValueExpr;
          var /** @type {?} */ type;
          if (isMulti) {
              resolvedProviderValueExpr = literalArr(providerValueExpressions);
              type = new ArrayType(DYNAMIC_TYPE);
          }
          else {
              resolvedProviderValueExpr = providerValueExpressions[0];
              type = providerValueExpressions[0].type;
          }
          if (!type) {
              type = DYNAMIC_TYPE;
          }
          if (isEager) {
              this.fields.push(new ClassField(propName, type));
              this._createStmts.push(THIS_EXPR.prop(propName).set(resolvedProviderValueExpr).toStmt());
          }
          else {
              var /** @type {?} */ internalField = "_" + propName;
              this.fields.push(new ClassField(internalField, type));
              // Note: Equals is important for JS so that it also checks the undefined case!
              var /** @type {?} */ getterStmts = [
                  new IfStmt(THIS_EXPR.prop(internalField).isBlank(), [THIS_EXPR.prop(internalField).set(resolvedProviderValueExpr).toStmt()]),
                  new ReturnStatement(THIS_EXPR.prop(internalField))
              ];
              this.getters.push(new ClassGetter(propName, getterStmts, type));
          }
          return THIS_EXPR.prop(propName);
      };
      /**
       * @param {?} dep
       * @return {?}
       */
      _InjectorBuilder.prototype._getDependency = function (dep) {
          var /** @type {?} */ result = null;
          if (dep.isValue) {
              result = literal(dep.value);
          }
          if (!dep.isSkipSelf) {
              if (dep.token &&
                  (dep.token.reference === resolveIdentifierToken(Identifiers.Injector).reference ||
                      dep.token.reference ===
                          resolveIdentifierToken(Identifiers.ComponentFactoryResolver).reference)) {
                  result = THIS_EXPR;
              }
              if (!result) {
                  result = this._instances.get(dep.token.reference);
              }
          }
          if (!result) {
              var /** @type {?} */ args = [createDiTokenExpression(dep.token)];
              if (dep.isOptional) {
                  args.push(NULL_EXPR);
              }
              result = InjectorProps.parent.callMethod('get', args);
          }
          return result;
      };
      return _InjectorBuilder;
  }());
  var InjectorProps = (function () {
      function InjectorProps() {
      }
      InjectorProps.parent = THIS_EXPR.prop('parent');
      return InjectorProps;
  }());
  var InjectMethodVars = (function () {
      function InjectMethodVars() {
      }
      InjectMethodVars.token = variable('token');
      InjectMethodVars.notFoundResult = variable('notFoundResult');
      return InjectMethodVars;
  }());

  var /** @type {?} */ _SINGLE_QUOTE_ESCAPE_STRING_RE = /'|\\|\n|\r|\$/g;
  var /** @type {?} */ _LEGAL_IDENTIFIER_RE = /^[$A-Z_][0-9A-Z_$]*$/i;
  var /** @type {?} */ CATCH_ERROR_VAR$1 = variable('error');
  var /** @type {?} */ CATCH_STACK_VAR$1 = variable('stack');
  var _EmittedLine = (function () {
      /**
       * @param {?} indent
       */
      function _EmittedLine(indent) {
          this.indent = indent;
          this.parts = [];
      }
      return _EmittedLine;
  }());
  var EmitterVisitorContext = (function () {
      /**
       * @param {?} _exportedVars
       * @param {?} _indent
       */
      function EmitterVisitorContext(_exportedVars, _indent) {
          this._exportedVars = _exportedVars;
          this._indent = _indent;
          this._classes = [];
          this._lines = [new _EmittedLine(_indent)];
      }
      /**
       * @param {?} exportedVars
       * @return {?}
       */
      EmitterVisitorContext.createRoot = function (exportedVars) {
          return new EmitterVisitorContext(exportedVars, 0);
      };
      Object.defineProperty(EmitterVisitorContext.prototype, "_currentLine", {
          /**
           * @return {?}
           */
          get: function () { return this._lines[this._lines.length - 1]; },
          enumerable: true,
          configurable: true
      });
      /**
       * @param {?} varName
       * @return {?}
       */
      EmitterVisitorContext.prototype.isExportedVar = function (varName) { return this._exportedVars.indexOf(varName) !== -1; };
      /**
       * @param {?=} lastPart
       * @return {?}
       */
      EmitterVisitorContext.prototype.println = function (lastPart) {
          if (lastPart === void 0) { lastPart = ''; }
          this.print(lastPart, true);
      };
      /**
       * @return {?}
       */
      EmitterVisitorContext.prototype.lineIsEmpty = function () { return this._currentLine.parts.length === 0; };
      /**
       * @param {?} part
       * @param {?=} newLine
       * @return {?}
       */
      EmitterVisitorContext.prototype.print = function (part, newLine) {
          if (newLine === void 0) { newLine = false; }
          if (part.length > 0) {
              this._currentLine.parts.push(part);
          }
          if (newLine) {
              this._lines.push(new _EmittedLine(this._indent));
          }
      };
      /**
       * @return {?}
       */
      EmitterVisitorContext.prototype.removeEmptyLastLine = function () {
          if (this.lineIsEmpty()) {
              this._lines.pop();
          }
      };
      /**
       * @return {?}
       */
      EmitterVisitorContext.prototype.incIndent = function () {
          this._indent++;
          this._currentLine.indent = this._indent;
      };
      /**
       * @return {?}
       */
      EmitterVisitorContext.prototype.decIndent = function () {
          this._indent--;
          this._currentLine.indent = this._indent;
      };
      /**
       * @param {?} clazz
       * @return {?}
       */
      EmitterVisitorContext.prototype.pushClass = function (clazz) { this._classes.push(clazz); };
      /**
       * @return {?}
       */
      EmitterVisitorContext.prototype.popClass = function () { return this._classes.pop(); };
      Object.defineProperty(EmitterVisitorContext.prototype, "currentClass", {
          /**
           * @return {?}
           */
          get: function () {
              return this._classes.length > 0 ? this._classes[this._classes.length - 1] : null;
          },
          enumerable: true,
          configurable: true
      });
      /**
       * @return {?}
       */
      EmitterVisitorContext.prototype.toSource = function () {
          var /** @type {?} */ lines = this._lines;
          if (lines[lines.length - 1].parts.length === 0) {
              lines = lines.slice(0, lines.length - 1);
          }
          return lines
              .map(function (line) {
              if (line.parts.length > 0) {
                  return _createIndent(line.indent) + line.parts.join('');
              }
              else {
                  return '';
              }
          })
              .join('\n');
      };
      return EmitterVisitorContext;
  }());
  /**
   * @abstract
   */
  var AbstractEmitterVisitor = (function () {
      /**
       * @param {?} _escapeDollarInStrings
       */
      function AbstractEmitterVisitor(_escapeDollarInStrings) {
          this._escapeDollarInStrings = _escapeDollarInStrings;
      }
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitExpressionStmt = function (stmt, ctx) {
          stmt.expr.visitExpression(this, ctx);
          ctx.println(';');
          return null;
      };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitReturnStmt = function (stmt, ctx) {
          ctx.print("return ");
          stmt.value.visitExpression(this, ctx);
          ctx.println(';');
          return null;
      };
      /**
       * @abstract
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitCastExpr = function (ast, context) { };
      /**
       * @abstract
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitDeclareClassStmt = function (stmt, ctx) { };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitIfStmt = function (stmt, ctx) {
          ctx.print("if (");
          stmt.condition.visitExpression(this, ctx);
          ctx.print(") {");
          var /** @type {?} */ hasElseCase = isPresent(stmt.falseCase) && stmt.falseCase.length > 0;
          if (stmt.trueCase.length <= 1 && !hasElseCase) {
              ctx.print(" ");
              this.visitAllStatements(stmt.trueCase, ctx);
              ctx.removeEmptyLastLine();
              ctx.print(" ");
          }
          else {
              ctx.println();
              ctx.incIndent();
              this.visitAllStatements(stmt.trueCase, ctx);
              ctx.decIndent();
              if (hasElseCase) {
                  ctx.println("} else {");
                  ctx.incIndent();
                  this.visitAllStatements(stmt.falseCase, ctx);
                  ctx.decIndent();
              }
          }
          ctx.println("}");
          return null;
      };
      /**
       * @abstract
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitTryCatchStmt = function (stmt, ctx) { };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitThrowStmt = function (stmt, ctx) {
          ctx.print("throw ");
          stmt.error.visitExpression(this, ctx);
          ctx.println(";");
          return null;
      };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitCommentStmt = function (stmt, ctx) {
          var /** @type {?} */ lines = stmt.comment.split('\n');
          lines.forEach(function (line) { ctx.println("// " + line); });
          return null;
      };
      /**
       * @abstract
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitDeclareVarStmt = function (stmt, ctx) { };
      /**
       * @param {?} expr
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitWriteVarExpr = function (expr, ctx) {
          var /** @type {?} */ lineWasEmpty = ctx.lineIsEmpty();
          if (!lineWasEmpty) {
              ctx.print('(');
          }
          ctx.print(expr.name + " = ");
          expr.value.visitExpression(this, ctx);
          if (!lineWasEmpty) {
              ctx.print(')');
          }
          return null;
      };
      /**
       * @param {?} expr
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitWriteKeyExpr = function (expr, ctx) {
          var /** @type {?} */ lineWasEmpty = ctx.lineIsEmpty();
          if (!lineWasEmpty) {
              ctx.print('(');
          }
          expr.receiver.visitExpression(this, ctx);
          ctx.print("[");
          expr.index.visitExpression(this, ctx);
          ctx.print("] = ");
          expr.value.visitExpression(this, ctx);
          if (!lineWasEmpty) {
              ctx.print(')');
          }
          return null;
      };
      /**
       * @param {?} expr
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitWritePropExpr = function (expr, ctx) {
          var /** @type {?} */ lineWasEmpty = ctx.lineIsEmpty();
          if (!lineWasEmpty) {
              ctx.print('(');
          }
          expr.receiver.visitExpression(this, ctx);
          ctx.print("." + expr.name + " = ");
          expr.value.visitExpression(this, ctx);
          if (!lineWasEmpty) {
              ctx.print(')');
          }
          return null;
      };
      /**
       * @param {?} expr
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitInvokeMethodExpr = function (expr, ctx) {
          expr.receiver.visitExpression(this, ctx);
          var /** @type {?} */ name = expr.name;
          if (isPresent(expr.builtin)) {
              name = this.getBuiltinMethodName(expr.builtin);
              if (isBlank(name)) {
                  // some builtins just mean to skip the call.
                  return null;
              }
          }
          ctx.print("." + name + "(");
          this.visitAllExpressions(expr.args, ctx, ",");
          ctx.print(")");
          return null;
      };
      /**
       * @abstract
       * @param {?} method
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.getBuiltinMethodName = function (method) { };
      /**
       * @param {?} expr
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitInvokeFunctionExpr = function (expr, ctx) {
          expr.fn.visitExpression(this, ctx);
          ctx.print("(");
          this.visitAllExpressions(expr.args, ctx, ',');
          ctx.print(")");
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitReadVarExpr = function (ast, ctx) {
          var /** @type {?} */ varName = ast.name;
          if (isPresent(ast.builtin)) {
              switch (ast.builtin) {
                  case BuiltinVar.Super:
                      varName = 'super';
                      break;
                  case BuiltinVar.This:
                      varName = 'this';
                      break;
                  case BuiltinVar.CatchError:
                      varName = CATCH_ERROR_VAR$1.name;
                      break;
                  case BuiltinVar.CatchStack:
                      varName = CATCH_STACK_VAR$1.name;
                      break;
                  default:
                      throw new Error("Unknown builtin variable " + ast.builtin);
              }
          }
          ctx.print(varName);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitInstantiateExpr = function (ast, ctx) {
          ctx.print("new ");
          ast.classExpr.visitExpression(this, ctx);
          ctx.print("(");
          this.visitAllExpressions(ast.args, ctx, ',');
          ctx.print(")");
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitLiteralExpr = function (ast, ctx) {
          var /** @type {?} */ value = ast.value;
          if (typeof value === 'string') {
              ctx.print(escapeIdentifier(value, this._escapeDollarInStrings));
          }
          else {
              ctx.print("" + value);
          }
          return null;
      };
      /**
       * @abstract
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitExternalExpr = function (ast, ctx) { };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitConditionalExpr = function (ast, ctx) {
          ctx.print("(");
          ast.condition.visitExpression(this, ctx);
          ctx.print('? ');
          ast.trueCase.visitExpression(this, ctx);
          ctx.print(': ');
          ast.falseCase.visitExpression(this, ctx);
          ctx.print(")");
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitNotExpr = function (ast, ctx) {
          ctx.print('!');
          ast.condition.visitExpression(this, ctx);
          return null;
      };
      /**
       * @abstract
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitFunctionExpr = function (ast, ctx) { };
      /**
       * @abstract
       * @param {?} stmt
       * @param {?} context
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitDeclareFunctionStmt = function (stmt, context) { };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitBinaryOperatorExpr = function (ast, ctx) {
          var /** @type {?} */ opStr;
          switch (ast.operator) {
              case BinaryOperator.Equals:
                  opStr = '==';
                  break;
              case BinaryOperator.Identical:
                  opStr = '===';
                  break;
              case BinaryOperator.NotEquals:
                  opStr = '!=';
                  break;
              case BinaryOperator.NotIdentical:
                  opStr = '!==';
                  break;
              case BinaryOperator.And:
                  opStr = '&&';
                  break;
              case BinaryOperator.Or:
                  opStr = '||';
                  break;
              case BinaryOperator.Plus:
                  opStr = '+';
                  break;
              case BinaryOperator.Minus:
                  opStr = '-';
                  break;
              case BinaryOperator.Divide:
                  opStr = '/';
                  break;
              case BinaryOperator.Multiply:
                  opStr = '*';
                  break;
              case BinaryOperator.Modulo:
                  opStr = '%';
                  break;
              case BinaryOperator.Lower:
                  opStr = '<';
                  break;
              case BinaryOperator.LowerEquals:
                  opStr = '<=';
                  break;
              case BinaryOperator.Bigger:
                  opStr = '>';
                  break;
              case BinaryOperator.BiggerEquals:
                  opStr = '>=';
                  break;
              default:
                  throw new Error("Unknown operator " + ast.operator);
          }
          ctx.print("(");
          ast.lhs.visitExpression(this, ctx);
          ctx.print(" " + opStr + " ");
          ast.rhs.visitExpression(this, ctx);
          ctx.print(")");
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitReadPropExpr = function (ast, ctx) {
          ast.receiver.visitExpression(this, ctx);
          ctx.print(".");
          ctx.print(ast.name);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitReadKeyExpr = function (ast, ctx) {
          ast.receiver.visitExpression(this, ctx);
          ctx.print("[");
          ast.index.visitExpression(this, ctx);
          ctx.print("]");
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitLiteralArrayExpr = function (ast, ctx) {
          var /** @type {?} */ useNewLine = ast.entries.length > 1;
          ctx.print("[", useNewLine);
          ctx.incIndent();
          this.visitAllExpressions(ast.entries, ctx, ',', useNewLine);
          ctx.decIndent();
          ctx.print("]", useNewLine);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitLiteralMapExpr = function (ast, ctx) {
          var _this = this;
          var /** @type {?} */ useNewLine = ast.entries.length > 1;
          ctx.print("{", useNewLine);
          ctx.incIndent();
          this.visitAllObjects(function (entry) {
              ctx.print(escapeIdentifier(entry[0], _this._escapeDollarInStrings, false) + ": ");
              entry[1].visitExpression(_this, ctx);
          }, ast.entries, ctx, ',', useNewLine);
          ctx.decIndent();
          ctx.print("}", useNewLine);
          return null;
      };
      /**
       * @param {?} expressions
       * @param {?} ctx
       * @param {?} separator
       * @param {?=} newLine
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitAllExpressions = function (expressions, ctx, separator, newLine) {
          var _this = this;
          if (newLine === void 0) { newLine = false; }
          this.visitAllObjects(function (expr) { return expr.visitExpression(_this, ctx); }, expressions, ctx, separator, newLine);
      };
      /**
       * @param {?} handler
       * @param {?} expressions
       * @param {?} ctx
       * @param {?} separator
       * @param {?=} newLine
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitAllObjects = function (handler, expressions, ctx, separator, newLine) {
          if (newLine === void 0) { newLine = false; }
          for (var /** @type {?} */ i = 0; i < expressions.length; i++) {
              if (i > 0) {
                  ctx.print(separator, newLine);
              }
              handler(expressions[i]);
          }
          if (newLine) {
              ctx.println();
          }
      };
      /**
       * @param {?} statements
       * @param {?} ctx
       * @return {?}
       */
      AbstractEmitterVisitor.prototype.visitAllStatements = function (statements, ctx) {
          var _this = this;
          statements.forEach(function (stmt) { return stmt.visitStatement(_this, ctx); });
      };
      return AbstractEmitterVisitor;
  }());
  /**
   * @param {?} input
   * @param {?} escapeDollar
   * @param {?=} alwaysQuote
   * @return {?}
   */
  function escapeIdentifier(input, escapeDollar, alwaysQuote) {
      if (alwaysQuote === void 0) { alwaysQuote = true; }
      if (isBlank(input)) {
          return null;
      }
      var /** @type {?} */ body = input.replace(_SINGLE_QUOTE_ESCAPE_STRING_RE, function () {
          var match = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              match[_i - 0] = arguments[_i];
          }
          if (match[0] == '$') {
              return escapeDollar ? '\\$' : '$';
          }
          else if (match[0] == '\n') {
              return '\\n';
          }
          else if (match[0] == '\r') {
              return '\\r';
          }
          else {
              return "\\" + match[0];
          }
      });
      var /** @type {?} */ requiresQuotes = alwaysQuote || !_LEGAL_IDENTIFIER_RE.test(body);
      return requiresQuotes ? "'" + body + "'" : body;
  }
  /**
   * @param {?} count
   * @return {?}
   */
  function _createIndent(count) {
      var /** @type {?} */ res = '';
      for (var /** @type {?} */ i = 0; i < count; i++) {
          res += '  ';
      }
      return res;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$17 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var /** @type {?} */ _debugModuleUrl = '/debug/lib';
  /**
   * @param {?} ast
   * @return {?}
   */
  function debugOutputAstAsTypeScript(ast) {
      var /** @type {?} */ converter = new _TsEmitterVisitor(_debugModuleUrl);
      var /** @type {?} */ ctx = EmitterVisitorContext.createRoot([]);
      var /** @type {?} */ asts = Array.isArray(ast) ? ast : [ast];
      asts.forEach(function (ast) {
          if (ast instanceof Statement) {
              ast.visitStatement(converter, ctx);
          }
          else if (ast instanceof Expression) {
              ast.visitExpression(converter, ctx);
          }
          else if (ast instanceof Type$1) {
              ast.visitType(converter, ctx);
          }
          else {
              throw new Error("Don't know how to print debug info for " + ast);
          }
      });
      return ctx.toSource();
  }
  var TypeScriptEmitter = (function () {
      /**
       * @param {?} _importGenerator
       */
      function TypeScriptEmitter(_importGenerator) {
          this._importGenerator = _importGenerator;
      }
      /**
       * @param {?} moduleUrl
       * @param {?} stmts
       * @param {?} exportedVars
       * @return {?}
       */
      TypeScriptEmitter.prototype.emitStatements = function (moduleUrl, stmts, exportedVars) {
          var _this = this;
          var /** @type {?} */ converter = new _TsEmitterVisitor(moduleUrl);
          var /** @type {?} */ ctx = EmitterVisitorContext.createRoot(exportedVars);
          converter.visitAllStatements(stmts, ctx);
          var /** @type {?} */ srcParts = [];
          converter.importsWithPrefixes.forEach(function (prefix, importedModuleUrl) {
              // Note: can't write the real word for import as it screws up system.js auto detection...
              srcParts.push("imp" +
                  ("ort * as " + prefix + " from '" + _this._importGenerator.fileNameToModuleName(importedModuleUrl, moduleUrl) + "';"));
          });
          srcParts.push(ctx.toSource());
          return srcParts.join('\n');
      };
      return TypeScriptEmitter;
  }());
  var _TsEmitterVisitor = (function (_super) {
      __extends$17(_TsEmitterVisitor, _super);
      /**
       * @param {?} _moduleUrl
       */
      function _TsEmitterVisitor(_moduleUrl) {
          _super.call(this, false);
          this._moduleUrl = _moduleUrl;
          this.importsWithPrefixes = new Map();
      }
      /**
       * @param {?} t
       * @param {?} ctx
       * @param {?=} defaultType
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitType = function (t, ctx, defaultType) {
          if (defaultType === void 0) { defaultType = 'any'; }
          if (isPresent(t)) {
              t.visitType(this, ctx);
          }
          else {
              ctx.print(defaultType);
          }
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitLiteralExpr = function (ast, ctx) {
          var /** @type {?} */ value = ast.value;
          if (isBlank(value) && ast.type != NULL_TYPE) {
              ctx.print("(" + value + " as any)");
              return null;
          }
          return _super.prototype.visitLiteralExpr.call(this, ast, ctx);
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitLiteralArrayExpr = function (ast, ctx) {
          if (ast.entries.length === 0) {
              ctx.print('(');
          }
          var /** @type {?} */ result = _super.prototype.visitLiteralArrayExpr.call(this, ast, ctx);
          if (ast.entries.length === 0) {
              ctx.print(' as any[])');
          }
          return result;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitExternalExpr = function (ast, ctx) {
          this._visitIdentifier(ast.value, ast.typeParams, ctx);
          return null;
      };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitDeclareVarStmt = function (stmt, ctx) {
          if (ctx.isExportedVar(stmt.name)) {
              ctx.print("export ");
          }
          if (stmt.hasModifier(StmtModifier.Final)) {
              ctx.print("const");
          }
          else {
              ctx.print("var");
          }
          ctx.print(" " + stmt.name + ":");
          this.visitType(stmt.type, ctx);
          ctx.print(" = ");
          stmt.value.visitExpression(this, ctx);
          ctx.println(";");
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitCastExpr = function (ast, ctx) {
          ctx.print("(<");
          ast.type.visitType(this, ctx);
          ctx.print(">");
          ast.value.visitExpression(this, ctx);
          ctx.print(")");
          return null;
      };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitDeclareClassStmt = function (stmt, ctx) {
          var _this = this;
          ctx.pushClass(stmt);
          if (ctx.isExportedVar(stmt.name)) {
              ctx.print("export ");
          }
          ctx.print("class " + stmt.name);
          if (isPresent(stmt.parent)) {
              ctx.print(" extends ");
              stmt.parent.visitExpression(this, ctx);
          }
          ctx.println(" {");
          ctx.incIndent();
          stmt.fields.forEach(function (field) { return _this._visitClassField(field, ctx); });
          if (isPresent(stmt.constructorMethod)) {
              this._visitClassConstructor(stmt, ctx);
          }
          stmt.getters.forEach(function (getter) { return _this._visitClassGetter(getter, ctx); });
          stmt.methods.forEach(function (method) { return _this._visitClassMethod(method, ctx); });
          ctx.decIndent();
          ctx.println("}");
          ctx.popClass();
          return null;
      };
      /**
       * @param {?} field
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype._visitClassField = function (field, ctx) {
          if (field.hasModifier(StmtModifier.Private)) {
              // comment out as a workaround for #10967
              ctx.print("/*private*/ ");
          }
          ctx.print(field.name);
          ctx.print(':');
          this.visitType(field.type, ctx);
          ctx.println(";");
      };
      /**
       * @param {?} getter
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype._visitClassGetter = function (getter, ctx) {
          if (getter.hasModifier(StmtModifier.Private)) {
              ctx.print("private ");
          }
          ctx.print("get " + getter.name + "()");
          ctx.print(':');
          this.visitType(getter.type, ctx);
          ctx.println(" {");
          ctx.incIndent();
          this.visitAllStatements(getter.body, ctx);
          ctx.decIndent();
          ctx.println("}");
      };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype._visitClassConstructor = function (stmt, ctx) {
          ctx.print("constructor(");
          this._visitParams(stmt.constructorMethod.params, ctx);
          ctx.println(") {");
          ctx.incIndent();
          this.visitAllStatements(stmt.constructorMethod.body, ctx);
          ctx.decIndent();
          ctx.println("}");
      };
      /**
       * @param {?} method
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype._visitClassMethod = function (method, ctx) {
          if (method.hasModifier(StmtModifier.Private)) {
              ctx.print("private ");
          }
          ctx.print(method.name + "(");
          this._visitParams(method.params, ctx);
          ctx.print("):");
          this.visitType(method.type, ctx, 'void');
          ctx.println(" {");
          ctx.incIndent();
          this.visitAllStatements(method.body, ctx);
          ctx.decIndent();
          ctx.println("}");
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitFunctionExpr = function (ast, ctx) {
          ctx.print("(");
          this._visitParams(ast.params, ctx);
          ctx.print("):");
          this.visitType(ast.type, ctx, 'void');
          ctx.println(" => {");
          ctx.incIndent();
          this.visitAllStatements(ast.statements, ctx);
          ctx.decIndent();
          ctx.print("}");
          return null;
      };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitDeclareFunctionStmt = function (stmt, ctx) {
          if (ctx.isExportedVar(stmt.name)) {
              ctx.print("export ");
          }
          ctx.print("function " + stmt.name + "(");
          this._visitParams(stmt.params, ctx);
          ctx.print("):");
          this.visitType(stmt.type, ctx, 'void');
          ctx.println(" {");
          ctx.incIndent();
          this.visitAllStatements(stmt.statements, ctx);
          ctx.decIndent();
          ctx.println("}");
          return null;
      };
      /**
       * @param {?} stmt
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitTryCatchStmt = function (stmt, ctx) {
          ctx.println("try {");
          ctx.incIndent();
          this.visitAllStatements(stmt.bodyStmts, ctx);
          ctx.decIndent();
          ctx.println("} catch (" + CATCH_ERROR_VAR$1.name + ") {");
          ctx.incIndent();
          var /** @type {?} */ catchStmts = [(CATCH_STACK_VAR$1.set(CATCH_ERROR_VAR$1.prop('stack')).toDeclStmt(null, [
                  StmtModifier.Final
              ]))].concat(stmt.catchStmts);
          this.visitAllStatements(catchStmts, ctx);
          ctx.decIndent();
          ctx.println("}");
          return null;
      };
      /**
       * @param {?} type
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitBuiltintType = function (type, ctx) {
          var /** @type {?} */ typeStr;
          switch (type.name) {
              case BuiltinTypeName.Bool:
                  typeStr = 'boolean';
                  break;
              case BuiltinTypeName.Dynamic:
                  typeStr = 'any';
                  break;
              case BuiltinTypeName.Function:
                  typeStr = 'Function';
                  break;
              case BuiltinTypeName.Number:
                  typeStr = 'number';
                  break;
              case BuiltinTypeName.Int:
                  typeStr = 'number';
                  break;
              case BuiltinTypeName.String:
                  typeStr = 'string';
                  break;
              default:
                  throw new Error("Unsupported builtin type " + type.name);
          }
          ctx.print(typeStr);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitExternalType = function (ast, ctx) {
          this._visitIdentifier(ast.value, ast.typeParams, ctx);
          return null;
      };
      /**
       * @param {?} type
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitArrayType = function (type, ctx) {
          this.visitType(type.of, ctx);
          ctx.print("[]");
          return null;
      };
      /**
       * @param {?} type
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype.visitMapType = function (type, ctx) {
          ctx.print("{[key: string]:");
          this.visitType(type.valueType, ctx);
          ctx.print("}");
          return null;
      };
      /**
       * @param {?} method
       * @return {?}
       */
      _TsEmitterVisitor.prototype.getBuiltinMethodName = function (method) {
          var /** @type {?} */ name;
          switch (method) {
              case BuiltinMethod.ConcatArray:
                  name = 'concat';
                  break;
              case BuiltinMethod.SubscribeObservable:
                  name = 'subscribe';
                  break;
              case BuiltinMethod.Bind:
                  name = 'bind';
                  break;
              default:
                  throw new Error("Unknown builtin method: " + method);
          }
          return name;
      };
      /**
       * @param {?} params
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype._visitParams = function (params, ctx) {
          var _this = this;
          this.visitAllObjects(function (param) {
              ctx.print(param.name);
              ctx.print(':');
              _this.visitType(param.type, ctx);
          }, params, ctx, ',');
      };
      /**
       * @param {?} value
       * @param {?} typeParams
       * @param {?} ctx
       * @return {?}
       */
      _TsEmitterVisitor.prototype._visitIdentifier = function (value, typeParams, ctx) {
          var _this = this;
          if (isBlank(value.name)) {
              throw new Error("Internal error: unknown identifier " + value);
          }
          if (isPresent(value.moduleUrl) && value.moduleUrl != this._moduleUrl) {
              var /** @type {?} */ prefix = this.importsWithPrefixes.get(value.moduleUrl);
              if (isBlank(prefix)) {
                  prefix = "import" + this.importsWithPrefixes.size;
                  this.importsWithPrefixes.set(value.moduleUrl, prefix);
              }
              ctx.print(prefix + ".");
          }
          if (value.reference && value.reference.members) {
              ctx.print(value.reference.name);
              ctx.print('.');
              ctx.print(value.reference.members.join('.'));
          }
          else {
              ctx.print(value.name);
          }
          if (isPresent(typeParams) && typeParams.length > 0) {
              ctx.print("<");
              this.visitAllObjects(function (type) { return type.visitType(_this, ctx); }, typeParams, ctx, ',');
              ctx.print(">");
          }
      };
      return _TsEmitterVisitor;
  }(AbstractEmitterVisitor));

  // =================================================================================================
  // =================================================================================================
  // =========== S T O P   -  S T O P   -  S T O P   -  S T O P   -  S T O P   -  S T O P  ===========
  // =================================================================================================
  // =================================================================================================
  //
  //        DO NOT EDIT THIS LIST OF SECURITY SENSITIVE PROPERTIES WITHOUT A SECURITY REVIEW!
  //                               Reach out to mprobst for details.
  //
  // =================================================================================================
  /** Map from tagName|propertyName SecurityContext. Properties applying to all tags use '*'. */
  var /** @type {?} */ SECURITY_SCHEMA = {};
  /**
   * @param {?} ctx
   * @param {?} specs
   * @return {?}
   */
  function registerContext(ctx, specs) {
      for (var _i = 0, specs_1 = specs; _i < specs_1.length; _i++) {
          var spec = specs_1[_i];
          SECURITY_SCHEMA[spec.toLowerCase()] = ctx;
      }
  }
  // Case is insignificant below, all element and attribute names are lower-cased for lookup.
  registerContext(_angular_core.SecurityContext.HTML, [
      'iframe|srcdoc',
      '*|innerHTML',
      '*|outerHTML',
  ]);
  registerContext(_angular_core.SecurityContext.STYLE, ['*|style']);
  // NB: no SCRIPT contexts here, they are never allowed due to the parser stripping them.
  registerContext(_angular_core.SecurityContext.URL, [
      '*|formAction', 'area|href', 'area|ping', 'audio|src', 'a|href',
      'a|ping', 'blockquote|cite', 'body|background', 'del|cite', 'form|action',
      'img|src', 'img|srcset', 'input|src', 'ins|cite', 'q|cite',
      'source|src', 'source|srcset', 'track|src', 'video|poster', 'video|src',
  ]);
  registerContext(_angular_core.SecurityContext.RESOURCE_URL, [
      'applet|code',
      'applet|codebase',
      'base|href',
      'embed|src',
      'frame|src',
      'head|profile',
      'html|manifest',
      'iframe|src',
      'link|href',
      'media|src',
      'object|codebase',
      'object|data',
      'script|src',
  ]);

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$18 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var /** @type {?} */ BOOLEAN = 'boolean';
  var /** @type {?} */ NUMBER = 'number';
  var /** @type {?} */ STRING = 'string';
  var /** @type {?} */ OBJECT = 'object';
  /**
   * This array represents the DOM schema. It encodes inheritance, properties, and events.
   *
   * ## Overview
   *
   * Each line represents one kind of element. The `element_inheritance` and properties are joined
   * using `element_inheritance|properties` syntax.
   *
   * ## Element Inheritance
   *
   * The `element_inheritance` can be further subdivided as `element1,element2,...^parentElement`.
   * Here the individual elements are separated by `,` (commas). Every element in the list
   * has identical properties.
   *
   * An `element` may inherit additional properties from `parentElement` If no `^parentElement` is
   * specified then `""` (blank) element is assumed.
   *
   * NOTE: The blank element inherits from root `[Element]` element, the super element of all
   * elements.
   *
   * NOTE an element prefix such as `:svg:` has no special meaning to the schema.
   *
   * ## Properties
   *
   * Each element has a set of properties separated by `,` (commas). Each property can be prefixed
   * by a special character designating its type:
   *
   * - (no prefix): property is a string.
   * - `*`: property represents an event.
   * - `!`: property is a boolean.
   * - `#`: property is a number.
   * - `%`: property is an object.
   *
   * ## Query
   *
   * The class creates an internal squas representation which allows to easily answer the query of
   * if a given property exist on a given element.
   *
   * NOTE: We don't yet support querying for types or events.
   * NOTE: This schema is auto extracted from `schema_extractor.ts` located in the test folder,
   *       see dom_element_schema_registry_spec.ts
   */
  // =================================================================================================
  // =================================================================================================
  // =========== S T O P   -  S T O P   -  S T O P   -  S T O P   -  S T O P   -  S T O P  ===========
  // =================================================================================================
  // =================================================================================================
  //
  //                       DO NOT EDIT THIS DOM SCHEMA WITHOUT A SECURITY REVIEW!
  //
  // Newly added properties must be security reviewed and assigned an appropriate SecurityContext in
  // dom_security_schema.ts. Reach out to mprobst & rjamet for details.
  //
  // =================================================================================================
  var /** @type {?} */ SCHEMA = [
      '[Element]|textContent,%classList,className,id,innerHTML,*beforecopy,*beforecut,*beforepaste,*copy,*cut,*paste,*search,*selectstart,*webkitfullscreenchange,*webkitfullscreenerror,*wheel,outerHTML,#scrollLeft,#scrollTop',
      '[HTMLElement]^[Element]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*beforecopy,*beforecut,*beforepaste,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*copy,*cuechange,*cut,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*message,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*mozfullscreenchange,*mozfullscreenerror,*mozpointerlockchange,*mozpointerlockerror,*paste,*pause,*play,*playing,*progress,*ratechange,*reset,*resize,*scroll,*search,*seeked,*seeking,*select,*selectstart,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,*webglcontextcreationerror,*webglcontextlost,*webglcontextrestored,*webkitfullscreenchange,*webkitfullscreenerror,*wheel,outerText,!spellcheck,%style,#tabIndex,title,!translate',
      'abbr,address,article,aside,b,bdi,bdo,cite,code,dd,dfn,dt,em,figcaption,figure,footer,header,i,kbd,main,mark,nav,noscript,rb,rp,rt,rtc,ruby,s,samp,section,small,strong,sub,sup,u,var,wbr^[HTMLElement]|accessKey,contentEditable,dir,!draggable,!hidden,innerText,lang,*abort,*beforecopy,*beforecut,*beforepaste,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*copy,*cuechange,*cut,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*message,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*mozfullscreenchange,*mozfullscreenerror,*mozpointerlockchange,*mozpointerlockerror,*paste,*pause,*play,*playing,*progress,*ratechange,*reset,*resize,*scroll,*search,*seeked,*seeking,*select,*selectstart,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,*webglcontextcreationerror,*webglcontextlost,*webglcontextrestored,*webkitfullscreenchange,*webkitfullscreenerror,*wheel,outerText,!spellcheck,%style,#tabIndex,title,!translate',
      'media^[HTMLElement]|!autoplay,!controls,%crossOrigin,#currentTime,!defaultMuted,#defaultPlaybackRate,!disableRemotePlayback,!loop,!muted,*encrypted,#playbackRate,preload,src,%srcObject,#volume',
      ':svg:^[HTMLElement]|*abort,*blur,*cancel,*canplay,*canplaythrough,*change,*click,*close,*contextmenu,*cuechange,*dblclick,*drag,*dragend,*dragenter,*dragleave,*dragover,*dragstart,*drop,*durationchange,*emptied,*ended,*error,*focus,*input,*invalid,*keydown,*keypress,*keyup,*load,*loadeddata,*loadedmetadata,*loadstart,*mousedown,*mouseenter,*mouseleave,*mousemove,*mouseout,*mouseover,*mouseup,*mousewheel,*pause,*play,*playing,*progress,*ratechange,*reset,*resize,*scroll,*seeked,*seeking,*select,*show,*stalled,*submit,*suspend,*timeupdate,*toggle,*volumechange,*waiting,%style,#tabIndex',
      ':svg:graphics^:svg:|',
      ':svg:animation^:svg:|*begin,*end,*repeat',
      ':svg:geometry^:svg:|',
      ':svg:componentTransferFunction^:svg:|',
      ':svg:gradient^:svg:|',
      ':svg:textContent^:svg:graphics|',
      ':svg:textPositioning^:svg:textContent|',
      'a^[HTMLElement]|charset,coords,download,hash,host,hostname,href,hreflang,name,password,pathname,ping,port,protocol,referrerPolicy,rel,rev,search,shape,target,text,type,username',
      'area^[HTMLElement]|alt,coords,hash,host,hostname,href,!noHref,password,pathname,ping,port,protocol,referrerPolicy,search,shape,target,username',
      'audio^media|',
      'br^[HTMLElement]|clear',
      'base^[HTMLElement]|href,target',
      'body^[HTMLElement]|aLink,background,bgColor,link,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,text,vLink',
      'button^[HTMLElement]|!autofocus,!disabled,formAction,formEnctype,formMethod,!formNoValidate,formTarget,name,type,value',
      'canvas^[HTMLElement]|#height,#width',
      'content^[HTMLElement]|select',
      'dl^[HTMLElement]|!compact',
      'datalist^[HTMLElement]|',
      'details^[HTMLElement]|!open',
      'dialog^[HTMLElement]|!open,returnValue',
      'dir^[HTMLElement]|!compact',
      'div^[HTMLElement]|align',
      'embed^[HTMLElement]|align,height,name,src,type,width',
      'fieldset^[HTMLElement]|!disabled,name',
      'font^[HTMLElement]|color,face,size',
      'form^[HTMLElement]|acceptCharset,action,autocomplete,encoding,enctype,method,name,!noValidate,target',
      'frame^[HTMLElement]|frameBorder,longDesc,marginHeight,marginWidth,name,!noResize,scrolling,src',
      'frameset^[HTMLElement]|cols,*beforeunload,*blur,*error,*focus,*hashchange,*languagechange,*load,*message,*offline,*online,*pagehide,*pageshow,*popstate,*rejectionhandled,*resize,*scroll,*storage,*unhandledrejection,*unload,rows',
      'hr^[HTMLElement]|align,color,!noShade,size,width',
      'head^[HTMLElement]|',
      'h1,h2,h3,h4,h5,h6^[HTMLElement]|align',
      'html^[HTMLElement]|version',
      'iframe^[HTMLElement]|align,!allowFullscreen,frameBorder,height,longDesc,marginHeight,marginWidth,name,referrerPolicy,%sandbox,scrolling,src,srcdoc,width',
      'img^[HTMLElement]|align,alt,border,%crossOrigin,#height,#hspace,!isMap,longDesc,lowsrc,name,referrerPolicy,sizes,src,srcset,useMap,#vspace,#width',
      'input^[HTMLElement]|accept,align,alt,autocapitalize,autocomplete,!autofocus,!checked,!defaultChecked,defaultValue,dirName,!disabled,%files,formAction,formEnctype,formMethod,!formNoValidate,formTarget,#height,!incremental,!indeterminate,max,#maxLength,min,#minLength,!multiple,name,pattern,placeholder,!readOnly,!required,selectionDirection,#selectionEnd,#selectionStart,#size,src,step,type,useMap,value,%valueAsDate,#valueAsNumber,#width',
      'keygen^[HTMLElement]|!autofocus,challenge,!disabled,keytype,name',
      'li^[HTMLElement]|type,#value',
      'label^[HTMLElement]|htmlFor',
      'legend^[HTMLElement]|align',
      'link^[HTMLElement]|as,charset,%crossOrigin,!disabled,href,hreflang,integrity,media,rel,%relList,rev,%sizes,target,type',
      'map^[HTMLElement]|name',
      'marquee^[HTMLElement]|behavior,bgColor,direction,height,#hspace,#loop,#scrollAmount,#scrollDelay,!trueSpeed,#vspace,width',
      'menu^[HTMLElement]|!compact',
      'meta^[HTMLElement]|content,httpEquiv,name,scheme',
      'meter^[HTMLElement]|#high,#low,#max,#min,#optimum,#value',
      'ins,del^[HTMLElement]|cite,dateTime',
      'ol^[HTMLElement]|!compact,!reversed,#start,type',
      'object^[HTMLElement]|align,archive,border,code,codeBase,codeType,data,!declare,height,#hspace,name,standby,type,useMap,#vspace,width',
      'optgroup^[HTMLElement]|!disabled,label',
      'option^[HTMLElement]|!defaultSelected,!disabled,label,!selected,text,value',
      'output^[HTMLElement]|defaultValue,%htmlFor,name,value',
      'p^[HTMLElement]|align',
      'param^[HTMLElement]|name,type,value,valueType',
      'picture^[HTMLElement]|',
      'pre^[HTMLElement]|#width',
      'progress^[HTMLElement]|#max,#value',
      'q,blockquote,cite^[HTMLElement]|',
      'script^[HTMLElement]|!async,charset,%crossOrigin,!defer,event,htmlFor,integrity,src,text,type',
      'select^[HTMLElement]|!autofocus,!disabled,#length,!multiple,name,!required,#selectedIndex,#size,value',
      'shadow^[HTMLElement]|',
      'source^[HTMLElement]|media,sizes,src,srcset,type',
      'span^[HTMLElement]|',
      'style^[HTMLElement]|!disabled,media,type',
      'caption^[HTMLElement]|align',
      'th,td^[HTMLElement]|abbr,align,axis,bgColor,ch,chOff,#colSpan,headers,height,!noWrap,#rowSpan,scope,vAlign,width',
      'col,colgroup^[HTMLElement]|align,ch,chOff,#span,vAlign,width',
      'table^[HTMLElement]|align,bgColor,border,%caption,cellPadding,cellSpacing,frame,rules,summary,%tFoot,%tHead,width',
      'tr^[HTMLElement]|align,bgColor,ch,chOff,vAlign',
      'tfoot,thead,tbody^[HTMLElement]|align,ch,chOff,vAlign',
      'template^[HTMLElement]|',
      'textarea^[HTMLElement]|autocapitalize,!autofocus,#cols,defaultValue,dirName,!disabled,#maxLength,#minLength,name,placeholder,!readOnly,!required,#rows,selectionDirection,#selectionEnd,#selectionStart,value,wrap',
      'title^[HTMLElement]|text',
      'track^[HTMLElement]|!default,kind,label,src,srclang',
      'ul^[HTMLElement]|!compact,type',
      'unknown^[HTMLElement]|',
      'video^media|#height,poster,#width',
      ':svg:a^:svg:graphics|',
      ':svg:animate^:svg:animation|',
      ':svg:animateMotion^:svg:animation|',
      ':svg:animateTransform^:svg:animation|',
      ':svg:circle^:svg:geometry|',
      ':svg:clipPath^:svg:graphics|',
      ':svg:cursor^:svg:|',
      ':svg:defs^:svg:graphics|',
      ':svg:desc^:svg:|',
      ':svg:discard^:svg:|',
      ':svg:ellipse^:svg:geometry|',
      ':svg:feBlend^:svg:|',
      ':svg:feColorMatrix^:svg:|',
      ':svg:feComponentTransfer^:svg:|',
      ':svg:feComposite^:svg:|',
      ':svg:feConvolveMatrix^:svg:|',
      ':svg:feDiffuseLighting^:svg:|',
      ':svg:feDisplacementMap^:svg:|',
      ':svg:feDistantLight^:svg:|',
      ':svg:feDropShadow^:svg:|',
      ':svg:feFlood^:svg:|',
      ':svg:feFuncA^:svg:componentTransferFunction|',
      ':svg:feFuncB^:svg:componentTransferFunction|',
      ':svg:feFuncG^:svg:componentTransferFunction|',
      ':svg:feFuncR^:svg:componentTransferFunction|',
      ':svg:feGaussianBlur^:svg:|',
      ':svg:feImage^:svg:|',
      ':svg:feMerge^:svg:|',
      ':svg:feMergeNode^:svg:|',
      ':svg:feMorphology^:svg:|',
      ':svg:feOffset^:svg:|',
      ':svg:fePointLight^:svg:|',
      ':svg:feSpecularLighting^:svg:|',
      ':svg:feSpotLight^:svg:|',
      ':svg:feTile^:svg:|',
      ':svg:feTurbulence^:svg:|',
      ':svg:filter^:svg:|',
      ':svg:foreignObject^:svg:graphics|',
      ':svg:g^:svg:graphics|',
      ':svg:image^:svg:graphics|',
      ':svg:line^:svg:geometry|',
      ':svg:linearGradient^:svg:gradient|',
      ':svg:mpath^:svg:|',
      ':svg:marker^:svg:|',
      ':svg:mask^:svg:|',
      ':svg:metadata^:svg:|',
      ':svg:path^:svg:geometry|',
      ':svg:pattern^:svg:|',
      ':svg:polygon^:svg:geometry|',
      ':svg:polyline^:svg:geometry|',
      ':svg:radialGradient^:svg:gradient|',
      ':svg:rect^:svg:geometry|',
      ':svg:svg^:svg:graphics|#currentScale,#zoomAndPan',
      ':svg:script^:svg:|type',
      ':svg:set^:svg:animation|',
      ':svg:stop^:svg:|',
      ':svg:style^:svg:|!disabled,media,title,type',
      ':svg:switch^:svg:graphics|',
      ':svg:symbol^:svg:|',
      ':svg:tspan^:svg:textPositioning|',
      ':svg:text^:svg:textPositioning|',
      ':svg:textPath^:svg:textContent|',
      ':svg:title^:svg:|',
      ':svg:use^:svg:graphics|',
      ':svg:view^:svg:|#zoomAndPan',
      'data^[HTMLElement]|value',
      'menuitem^[HTMLElement]|type,label,icon,!disabled,!checked,radiogroup,!default',
      'summary^[HTMLElement]|',
      'time^[HTMLElement]|dateTime',
  ];
  var /** @type {?} */ _ATTR_TO_PROP = {
      'class': 'className',
      'for': 'htmlFor',
      'formaction': 'formAction',
      'innerHtml': 'innerHTML',
      'readonly': 'readOnly',
      'tabindex': 'tabIndex',
  };
  var DomElementSchemaRegistry = (function (_super) {
      __extends$18(DomElementSchemaRegistry, _super);
      function DomElementSchemaRegistry() {
          var _this = this;
          _super.call(this);
          this._schema = {};
          SCHEMA.forEach(function (encodedType) {
              var type = {};
              var _a = encodedType.split('|'), strType = _a[0], strProperties = _a[1];
              var properties = strProperties.split(',');
              var _b = strType.split('^'), typeNames = _b[0], superName = _b[1];
              typeNames.split(',').forEach(function (tag) { return _this._schema[tag.toLowerCase()] = type; });
              var superType = superName && _this._schema[superName.toLowerCase()];
              if (superType) {
                  Object.keys(superType).forEach(function (prop) { type[prop] = superType[prop]; });
              }
              properties.forEach(function (property) {
                  if (property.length > 0) {
                      switch (property[0]) {
                          case '*':
                              // We don't yet support events.
                              // If ever allowing to bind to events, GO THROUGH A SECURITY REVIEW, allowing events
                              // will
                              // almost certainly introduce bad XSS vulnerabilities.
                              // type[property.substring(1)] = EVENT;
                              break;
                          case '!':
                              type[property.substring(1)] = BOOLEAN;
                              break;
                          case '#':
                              type[property.substring(1)] = NUMBER;
                              break;
                          case '%':
                              type[property.substring(1)] = OBJECT;
                              break;
                          default:
                              type[property] = STRING;
                      }
                  }
              });
          });
      }
      /**
       * @param {?} tagName
       * @param {?} propName
       * @param {?} schemaMetas
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.hasProperty = function (tagName, propName, schemaMetas) {
          if (schemaMetas.some(function (schema) { return schema.name === _angular_core.NO_ERRORS_SCHEMA.name; })) {
              return true;
          }
          if (tagName.indexOf('-') > -1) {
              if (tagName === 'ng-container' || tagName === 'ng-content') {
                  return false;
              }
              if (schemaMetas.some(function (schema) { return schema.name === _angular_core.CUSTOM_ELEMENTS_SCHEMA.name; })) {
                  // Can't tell now as we don't know which properties a custom element will get
                  // once it is instantiated
                  return true;
              }
          }
          var /** @type {?} */ elementProperties = this._schema[tagName.toLowerCase()] || this._schema['unknown'];
          return !!elementProperties[propName];
      };
      /**
       * @param {?} tagName
       * @param {?} schemaMetas
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.hasElement = function (tagName, schemaMetas) {
          if (schemaMetas.some(function (schema) { return schema.name === _angular_core.NO_ERRORS_SCHEMA.name; })) {
              return true;
          }
          if (tagName.indexOf('-') > -1) {
              if (tagName === 'ng-container' || tagName === 'ng-content') {
                  return true;
              }
              if (schemaMetas.some(function (schema) { return schema.name === _angular_core.CUSTOM_ELEMENTS_SCHEMA.name; })) {
                  // Allow any custom elements
                  return true;
              }
          }
          return !!this._schema[tagName.toLowerCase()];
      };
      /**
       *  securityContext returns the security context for the given property on the given DOM tag.
        * *
        * Tag and property name are statically known and cannot change at runtime, i.e. it is not
        * possible to bind a value into a changing attribute or tag name.
        * *
        * The filtering is white list based. All attributes in the schema above are assumed to have the
        * 'NONE' security context, i.e. that they are safe inert string values. Only specific well known
        * attack vectors are assigned their appropriate context.
       * @param {?} tagName
       * @param {?} propName
       * @param {?} isAttribute
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.securityContext = function (tagName, propName, isAttribute) {
          if (isAttribute) {
              // NB: For security purposes, use the mapped property name, not the attribute name.
              propName = this.getMappedPropName(propName);
          }
          // Make sure comparisons are case insensitive, so that case differences between attribute and
          // property names do not have a security impact.
          tagName = tagName.toLowerCase();
          propName = propName.toLowerCase();
          var /** @type {?} */ ctx = SECURITY_SCHEMA[tagName + '|' + propName];
          if (ctx) {
              return ctx;
          }
          ctx = SECURITY_SCHEMA['*|' + propName];
          return ctx ? ctx : _angular_core.SecurityContext.NONE;
      };
      /**
       * @param {?} propName
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.getMappedPropName = function (propName) { return _ATTR_TO_PROP[propName] || propName; };
      /**
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.getDefaultComponentElementName = function () { return 'ng-component'; };
      /**
       * @param {?} name
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.validateProperty = function (name) {
          if (name.toLowerCase().startsWith('on')) {
              var /** @type {?} */ msg = ("Binding to event property '" + name + "' is disallowed for security reasons, ") +
                  ("please use (" + name.slice(2) + ")=...") +
                  ("\nIf '" + name + "' is a directive input, make sure the directive is imported by the") +
                  " current module.";
              return { error: true, msg: msg };
          }
          else {
              return { error: false };
          }
      };
      /**
       * @param {?} name
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.validateAttribute = function (name) {
          if (name.toLowerCase().startsWith('on')) {
              var /** @type {?} */ msg = ("Binding to event attribute '" + name + "' is disallowed for security reasons, ") +
                  ("please use (" + name.slice(2) + ")=...");
              return { error: true, msg: msg };
          }
          else {
              return { error: false };
          }
      };
      /**
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.allKnownElementNames = function () { return Object.keys(this._schema); };
      /**
       * @param {?} propName
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.normalizeAnimationStyleProperty = function (propName) {
          return dashCaseToCamelCase(propName);
      };
      /**
       * @param {?} camelCaseProp
       * @param {?} userProvidedProp
       * @param {?} val
       * @return {?}
       */
      DomElementSchemaRegistry.prototype.normalizeAnimationStyleValue = function (camelCaseProp, userProvidedProp, val) {
          var /** @type {?} */ unit = '';
          var /** @type {?} */ strVal = val.toString().trim();
          var /** @type {?} */ errorMsg = null;
          if (_isPixelDimensionStyle(camelCaseProp) && val !== 0 && val !== '0') {
              if (typeof val === 'number') {
                  unit = 'px';
              }
              else {
                  var /** @type {?} */ valAndSuffixMatch = val.match(/^[+-]?[\d\.]+([a-z]*)$/);
                  if (valAndSuffixMatch && valAndSuffixMatch[1].length == 0) {
                      errorMsg = "Please provide a CSS unit value for " + userProvidedProp + ":" + val;
                  }
              }
          }
          return { error: errorMsg, value: strVal + unit };
      };
      DomElementSchemaRegistry.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      DomElementSchemaRegistry.ctorParameters = function () { return []; };
      return DomElementSchemaRegistry;
  }(ElementSchemaRegistry));
  /**
   * @param {?} prop
   * @return {?}
   */
  function _isPixelDimensionStyle(prop) {
      switch (prop) {
          case 'width':
          case 'height':
          case 'minWidth':
          case 'minHeight':
          case 'maxWidth':
          case 'maxHeight':
          case 'left':
          case 'top':
          case 'bottom':
          case 'right':
          case 'fontSize':
          case 'outlineWidth':
          case 'outlineOffset':
          case 'paddingTop':
          case 'paddingLeft':
          case 'paddingBottom':
          case 'paddingRight':
          case 'marginTop':
          case 'marginLeft':
          case 'marginBottom':
          case 'marginRight':
          case 'borderRadius':
          case 'borderWidth':
          case 'borderTopWidth':
          case 'borderLeftWidth':
          case 'borderRightWidth':
          case 'borderBottomWidth':
          case 'textIndent':
              return true;
          default:
              return false;
      }
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  /**
   * This file is a port of shadowCSS from webcomponents.js to TypeScript.
   *
   * Please make sure to keep to edits in sync with the source file.
   *
   * Source:
   * https://github.com/webcomponents/webcomponentsjs/blob/4efecd7e0e/src/ShadowCSS/ShadowCSS.js
   *
   * The original file level comment is reproduced below
   */
  /*
    This is a limited shim for ShadowDOM css styling.
    https://dvcs.w3.org/hg/webcomponents/raw-file/tip/spec/shadow/index.html#styles

    The intention here is to support only the styling features which can be
    relatively simply implemented. The goal is to allow users to avoid the
    most obvious pitfalls and do so without compromising performance significantly.
    For ShadowDOM styling that's not covered here, a set of best practices
    can be provided that should allow users to accomplish more complex styling.

    The following is a list of specific ShadowDOM styling features and a brief
    discussion of the approach used to shim.

    Shimmed features:

    * :host, :host-context: ShadowDOM allows styling of the shadowRoot's host
    element using the :host rule. To shim this feature, the :host styles are
    reformatted and prefixed with a given scope name and promoted to a
    document level stylesheet.
    For example, given a scope name of .foo, a rule like this:

      :host {
          background: red;
        }
      }

    becomes:

      .foo {
        background: red;
      }

    * encapsulation: Styles defined within ShadowDOM, apply only to
    dom inside the ShadowDOM. Polymer uses one of two techniques to implement
    this feature.

    By default, rules are prefixed with the host element tag name
    as a descendant selector. This ensures styling does not leak out of the 'top'
    of the element's ShadowDOM. For example,

    div {
        font-weight: bold;
      }

    becomes:

    x-foo div {
        font-weight: bold;
      }

    becomes:


    Alternatively, if WebComponents.ShadowCSS.strictStyling is set to true then
    selectors are scoped by adding an attribute selector suffix to each
    simple selector that contains the host element tag name. Each element
    in the element's ShadowDOM template is also given the scope attribute.
    Thus, these rules match only elements that have the scope attribute.
    For example, given a scope name of x-foo, a rule like this:

      div {
        font-weight: bold;
      }

    becomes:

      div[x-foo] {
        font-weight: bold;
      }

    Note that elements that are dynamically added to a scope must have the scope
    selector added to them manually.

    * upper/lower bound encapsulation: Styles which are defined outside a
    shadowRoot should not cross the ShadowDOM boundary and should not apply
    inside a shadowRoot.

    This styling behavior is not emulated. Some possible ways to do this that
    were rejected due to complexity and/or performance concerns include: (1) reset
    every possible property for every possible selector for a given scope name;
    (2) re-implement css in javascript.

    As an alternative, users should make sure to use selectors
    specific to the scope in which they are working.

    * ::distributed: This behavior is not emulated. It's often not necessary
    to style the contents of a specific insertion point and instead, descendants
    of the host element can be styled selectively. Users can also create an
    extra node around an insertion point and style that node's contents
    via descendent selectors. For example, with a shadowRoot like this:

      <style>
        ::content(div) {
          background: red;
        }
      </style>
      <content></content>

    could become:

      <style>
        / *@polyfill .content-container div * /
        ::content(div) {
          background: red;
        }
      </style>
      <div class="content-container">
        <content></content>
      </div>

    Note the use of @polyfill in the comment above a ShadowDOM specific style
    declaration. This is a directive to the styling shim to use the selector
    in comments in lieu of the next selector when running under polyfill.
  */
  var ShadowCss = (function () {
      function ShadowCss() {
          this.strictStyling = true;
      }
      /**
       * @param {?} cssText
       * @param {?} selector
       * @param {?=} hostSelector
       * @return {?}
       */
      ShadowCss.prototype.shimCssText = function (cssText, selector, hostSelector) {
          if (hostSelector === void 0) { hostSelector = ''; }
          var /** @type {?} */ sourceMappingUrl = extractSourceMappingUrl(cssText);
          cssText = stripComments(cssText);
          cssText = this._insertDirectives(cssText);
          return this._scopeCssText(cssText, selector, hostSelector) + sourceMappingUrl;
      };
      /**
       * @param {?} cssText
       * @return {?}
       */
      ShadowCss.prototype._insertDirectives = function (cssText) {
          cssText = this._insertPolyfillDirectivesInCssText(cssText);
          return this._insertPolyfillRulesInCssText(cssText);
      };
      /**
       * @param {?} cssText
       * @return {?}
       */
      ShadowCss.prototype._insertPolyfillDirectivesInCssText = function (cssText) {
          // Difference with webcomponents.js: does not handle comments
          return cssText.replace(_cssContentNextSelectorRe, function () {
              var m = [];
              for (var _i = 0; _i < arguments.length; _i++) {
                  m[_i - 0] = arguments[_i];
              }
              return m[2] + '{';
          });
      };
      /**
       * @param {?} cssText
       * @return {?}
       */
      ShadowCss.prototype._insertPolyfillRulesInCssText = function (cssText) {
          // Difference with webcomponents.js: does not handle comments
          return cssText.replace(_cssContentRuleRe, function () {
              var m = [];
              for (var _i = 0; _i < arguments.length; _i++) {
                  m[_i - 0] = arguments[_i];
              }
              var /** @type {?} */ rule = m[0].replace(m[1], '').replace(m[2], '');
              return m[4] + rule;
          });
      };
      /**
       * @param {?} cssText
       * @param {?} scopeSelector
       * @param {?} hostSelector
       * @return {?}
       */
      ShadowCss.prototype._scopeCssText = function (cssText, scopeSelector, hostSelector) {
          var /** @type {?} */ unscopedRules = this._extractUnscopedRulesFromCssText(cssText);
          // replace :host and :host-context -shadowcsshost and -shadowcsshost respectively
          cssText = this._insertPolyfillHostInCssText(cssText);
          cssText = this._convertColonHost(cssText);
          cssText = this._convertColonHostContext(cssText);
          cssText = this._convertShadowDOMSelectors(cssText);
          if (scopeSelector) {
              cssText = this._scopeSelectors(cssText, scopeSelector, hostSelector);
          }
          cssText = cssText + '\n' + unscopedRules;
          return cssText.trim();
      };
      /**
       * @param {?} cssText
       * @return {?}
       */
      ShadowCss.prototype._extractUnscopedRulesFromCssText = function (cssText) {
          // Difference with webcomponents.js: does not handle comments
          var /** @type {?} */ r = '';
          var /** @type {?} */ m;
          _cssContentUnscopedRuleRe.lastIndex = 0;
          while ((m = _cssContentUnscopedRuleRe.exec(cssText)) !== null) {
              var /** @type {?} */ rule = m[0].replace(m[2], '').replace(m[1], m[4]);
              r += rule + '\n\n';
          }
          return r;
      };
      /**
       * @param {?} cssText
       * @return {?}
       */
      ShadowCss.prototype._convertColonHost = function (cssText) {
          return this._convertColonRule(cssText, _cssColonHostRe, this._colonHostPartReplacer);
      };
      /**
       * @param {?} cssText
       * @return {?}
       */
      ShadowCss.prototype._convertColonHostContext = function (cssText) {
          return this._convertColonRule(cssText, _cssColonHostContextRe, this._colonHostContextPartReplacer);
      };
      /**
       * @param {?} cssText
       * @param {?} regExp
       * @param {?} partReplacer
       * @return {?}
       */
      ShadowCss.prototype._convertColonRule = function (cssText, regExp, partReplacer) {
          // m[1] = :host(-context), m[2] = contents of (), m[3] rest of rule
          return cssText.replace(regExp, function () {
              var m = [];
              for (var _i = 0; _i < arguments.length; _i++) {
                  m[_i - 0] = arguments[_i];
              }
              if (m[2]) {
                  var /** @type {?} */ parts = m[2].split(',');
                  var /** @type {?} */ r = [];
                  for (var /** @type {?} */ i = 0; i < parts.length; i++) {
                      var /** @type {?} */ p = parts[i].trim();
                      if (!p)
                          break;
                      r.push(partReplacer(_polyfillHostNoCombinator, p, m[3]));
                  }
                  return r.join(',');
              }
              else {
                  return _polyfillHostNoCombinator + m[3];
              }
          });
      };
      /**
       * @param {?} host
       * @param {?} part
       * @param {?} suffix
       * @return {?}
       */
      ShadowCss.prototype._colonHostContextPartReplacer = function (host, part, suffix) {
          if (part.indexOf(_polyfillHost) > -1) {
              return this._colonHostPartReplacer(host, part, suffix);
          }
          else {
              return host + part + suffix + ', ' + part + ' ' + host + suffix;
          }
      };
      /**
       * @param {?} host
       * @param {?} part
       * @param {?} suffix
       * @return {?}
       */
      ShadowCss.prototype._colonHostPartReplacer = function (host, part, suffix) {
          return host + part.replace(_polyfillHost, '') + suffix;
      };
      /**
       * @param {?} cssText
       * @return {?}
       */
      ShadowCss.prototype._convertShadowDOMSelectors = function (cssText) {
          return _shadowDOMSelectorsRe.reduce(function (result, pattern) { return result.replace(pattern, ' '); }, cssText);
      };
      /**
       * @param {?} cssText
       * @param {?} scopeSelector
       * @param {?} hostSelector
       * @return {?}
       */
      ShadowCss.prototype._scopeSelectors = function (cssText, scopeSelector, hostSelector) {
          var _this = this;
          return processRules(cssText, function (rule) {
              var /** @type {?} */ selector = rule.selector;
              var /** @type {?} */ content = rule.content;
              if (rule.selector[0] != '@') {
                  selector =
                      _this._scopeSelector(rule.selector, scopeSelector, hostSelector, _this.strictStyling);
              }
              else if (rule.selector.startsWith('@media') || rule.selector.startsWith('@supports') ||
                  rule.selector.startsWith('@page') || rule.selector.startsWith('@document')) {
                  content = _this._scopeSelectors(rule.content, scopeSelector, hostSelector);
              }
              return new CssRule(selector, content);
          });
      };
      /**
       * @param {?} selector
       * @param {?} scopeSelector
       * @param {?} hostSelector
       * @param {?} strict
       * @return {?}
       */
      ShadowCss.prototype._scopeSelector = function (selector, scopeSelector, hostSelector, strict) {
          var _this = this;
          return selector.split(',')
              .map(function (part) { return part.trim().split(_shadowDeepSelectors); })
              .map(function (deepParts) {
              var shallowPart = deepParts[0], otherParts = deepParts.slice(1);
              var /** @type {?} */ applyScope = function (shallowPart) {
                  if (_this._selectorNeedsScoping(shallowPart, scopeSelector)) {
                      return strict ?
                          _this._applyStrictSelectorScope(shallowPart, scopeSelector, hostSelector) :
                          _this._applySelectorScope(shallowPart, scopeSelector, hostSelector);
                  }
                  else {
                      return shallowPart;
                  }
              };
              return [applyScope(shallowPart)].concat(otherParts).join(' ');
          })
              .join(', ');
      };
      /**
       * @param {?} selector
       * @param {?} scopeSelector
       * @return {?}
       */
      ShadowCss.prototype._selectorNeedsScoping = function (selector, scopeSelector) {
          var /** @type {?} */ re = this._makeScopeMatcher(scopeSelector);
          return !re.test(selector);
      };
      /**
       * @param {?} scopeSelector
       * @return {?}
       */
      ShadowCss.prototype._makeScopeMatcher = function (scopeSelector) {
          var /** @type {?} */ lre = /\[/g;
          var /** @type {?} */ rre = /\]/g;
          scopeSelector = scopeSelector.replace(lre, '\\[').replace(rre, '\\]');
          return new RegExp('^(' + scopeSelector + ')' + _selectorReSuffix, 'm');
      };
      /**
       * @param {?} selector
       * @param {?} scopeSelector
       * @param {?} hostSelector
       * @return {?}
       */
      ShadowCss.prototype._applySelectorScope = function (selector, scopeSelector, hostSelector) {
          // Difference from webcomponents.js: scopeSelector could not be an array
          return this._applySimpleSelectorScope(selector, scopeSelector, hostSelector);
      };
      /**
       * @param {?} selector
       * @param {?} scopeSelector
       * @param {?} hostSelector
       * @return {?}
       */
      ShadowCss.prototype._applySimpleSelectorScope = function (selector, scopeSelector, hostSelector) {
          // In Android browser, the lastIndex is not reset when the regex is used in String.replace()
          _polyfillHostRe.lastIndex = 0;
          if (_polyfillHostRe.test(selector)) {
              var /** @type {?} */ replaceBy_1 = this.strictStyling ? "[" + hostSelector + "]" : scopeSelector;
              return selector
                  .replace(_polyfillHostNoCombinatorRe, function (hnc, selector) {
                  return selector.replace(/([^:]*)(:*)(.*)/, function (_, before, colon, after) {
                      return before + replaceBy_1 + colon + after;
                  });
              })
                  .replace(_polyfillHostRe, replaceBy_1 + ' ');
          }
          return scopeSelector + ' ' + selector;
      };
      /**
       * @param {?} selector
       * @param {?} scopeSelector
       * @param {?} hostSelector
       * @return {?}
       */
      ShadowCss.prototype._applyStrictSelectorScope = function (selector, scopeSelector, hostSelector) {
          var _this = this;
          var /** @type {?} */ isRe = /\[is=([^\]]*)\]/g;
          scopeSelector = scopeSelector.replace(isRe, function (_) {
              var parts = [];
              for (var _i = 1; _i < arguments.length; _i++) {
                  parts[_i - 1] = arguments[_i];
              }
              return parts[0];
          });
          var /** @type {?} */ attrName = '[' + scopeSelector + ']';
          var /** @type {?} */ _scopeSelectorPart = function (p) {
              var /** @type {?} */ scopedP = p.trim();
              if (!scopedP) {
                  return '';
              }
              if (p.indexOf(_polyfillHostNoCombinator) > -1) {
                  scopedP = _this._applySimpleSelectorScope(p, scopeSelector, hostSelector);
              }
              else {
                  // remove :host since it should be unnecessary
                  var /** @type {?} */ t = p.replace(_polyfillHostRe, '');
                  if (t.length > 0) {
                      var /** @type {?} */ matches = t.match(/([^:]*)(:*)(.*)/);
                      if (matches) {
                          scopedP = matches[1] + attrName + matches[2] + matches[3];
                      }
                  }
              }
              return scopedP;
          };
          var /** @type {?} */ safeContent = new SafeSelector(selector);
          selector = safeContent.content();
          var /** @type {?} */ scopedSelector = '';
          var /** @type {?} */ startIndex = 0;
          var /** @type {?} */ res;
          var /** @type {?} */ sep = /( |>|\+|~(?!=))\s*/g;
          var /** @type {?} */ scopeAfter = selector.indexOf(_polyfillHostNoCombinator);
          while ((res = sep.exec(selector)) !== null) {
              var /** @type {?} */ separator = res[1];
              var /** @type {?} */ part = selector.slice(startIndex, res.index).trim();
              // if a selector appears before :host-context it should not be shimmed as it
              // matches on ancestor elements and not on elements in the host's shadow
              var /** @type {?} */ scopedPart = startIndex >= scopeAfter ? _scopeSelectorPart(part) : part;
              scopedSelector += scopedPart + " " + separator + " ";
              startIndex = sep.lastIndex;
          }
          scopedSelector += _scopeSelectorPart(selector.substring(startIndex));
          // replace the placeholders with their original values
          return safeContent.restore(scopedSelector);
      };
      /**
       * @param {?} selector
       * @return {?}
       */
      ShadowCss.prototype._insertPolyfillHostInCssText = function (selector) {
          return selector.replace(_colonHostContextRe, _polyfillHostContext)
              .replace(_colonHostRe, _polyfillHost);
      };
      return ShadowCss;
  }());
  var SafeSelector = (function () {
      /**
       * @param {?} selector
       */
      function SafeSelector(selector) {
          var _this = this;
          this.placeholders = [];
          this.index = 0;
          // Replaces attribute selectors with placeholders.
          // The WS in [attr="va lue"] would otherwise be interpreted as a selector separator.
          selector = selector.replace(/(\[[^\]]*\])/g, function (_, keep) {
              var replaceBy = "__ph-" + _this.index + "__";
              _this.placeholders.push(keep);
              _this.index++;
              return replaceBy;
          });
          // Replaces the expression in `:nth-child(2n + 1)` with a placeholder.
          // WS and "+" would otherwise be interpreted as selector separators.
          this._content = selector.replace(/(:nth-[-\w]+)(\([^)]+\))/g, function (_, pseudo, exp) {
              var replaceBy = "__ph-" + _this.index + "__";
              _this.placeholders.push(exp);
              _this.index++;
              return pseudo + replaceBy;
          });
      }
      ;
      /**
       * @param {?} content
       * @return {?}
       */
      SafeSelector.prototype.restore = function (content) {
          var _this = this;
          return content.replace(/__ph-(\d+)__/g, function (ph, index) { return _this.placeholders[+index]; });
      };
      /**
       * @return {?}
       */
      SafeSelector.prototype.content = function () { return this._content; };
      return SafeSelector;
  }());
  var /** @type {?} */ _cssContentNextSelectorRe = /polyfill-next-selector[^}]*content:[\s]*?(['"])(.*?)\1[;\s]*}([^{]*?){/gim;
  var /** @type {?} */ _cssContentRuleRe = /(polyfill-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim;
  var /** @type {?} */ _cssContentUnscopedRuleRe = /(polyfill-unscoped-rule)[^}]*(content:[\s]*(['"])(.*?)\3)[;\s]*[^}]*}/gim;
  var /** @type {?} */ _polyfillHost = '-shadowcsshost';
  // note: :host-context pre-processed to -shadowcsshostcontext.
  var /** @type {?} */ _polyfillHostContext = '-shadowcsscontext';
  var /** @type {?} */ _parenSuffix = ')(?:\\((' +
      '(?:\\([^)(]*\\)|[^)(]*)+?' +
      ')\\))?([^,{]*)';
  var /** @type {?} */ _cssColonHostRe = new RegExp('(' + _polyfillHost + _parenSuffix, 'gim');
  var /** @type {?} */ _cssColonHostContextRe = new RegExp('(' + _polyfillHostContext + _parenSuffix, 'gim');
  var /** @type {?} */ _polyfillHostNoCombinator = _polyfillHost + '-no-combinator';
  var /** @type {?} */ _polyfillHostNoCombinatorRe = /-shadowcsshost-no-combinator([^\s]*)/;
  var /** @type {?} */ _shadowDOMSelectorsRe = [
      /::shadow/g,
      /::content/g,
      // Deprecated selectors
      /\/shadow-deep\//g,
      /\/shadow\//g,
  ];
  var /** @type {?} */ _shadowDeepSelectors = /(?:>>>)|(?:\/deep\/)/g;
  var /** @type {?} */ _selectorReSuffix = '([>\\s~+\[.,{:][\\s\\S]*)?$';
  var /** @type {?} */ _polyfillHostRe = /-shadowcsshost/gim;
  var /** @type {?} */ _colonHostRe = /:host/gim;
  var /** @type {?} */ _colonHostContextRe = /:host-context/gim;
  var /** @type {?} */ _commentRe = /\/\*\s*[\s\S]*?\*\//g;
  /**
   * @param {?} input
   * @return {?}
   */
  function stripComments(input) {
      return input.replace(_commentRe, '');
  }
  // all comments except inline source mapping
  var /** @type {?} */ _sourceMappingUrlRe = /\/\*\s*#\s*sourceMappingURL=[\s\S]+?\*\//;
  /**
   * @param {?} input
   * @return {?}
   */
  function extractSourceMappingUrl(input) {
      var /** @type {?} */ matcher = input.match(_sourceMappingUrlRe);
      return matcher ? matcher[0] : '';
  }
  var /** @type {?} */ _ruleRe = /(\s*)([^;\{\}]+?)(\s*)((?:{%BLOCK%}?\s*;?)|(?:\s*;))/g;
  var /** @type {?} */ _curlyRe = /([{}])/g;
  var /** @type {?} */ OPEN_CURLY = '{';
  var /** @type {?} */ CLOSE_CURLY = '}';
  var /** @type {?} */ BLOCK_PLACEHOLDER = '%BLOCK%';
  var CssRule = (function () {
      /**
       * @param {?} selector
       * @param {?} content
       */
      function CssRule(selector, content) {
          this.selector = selector;
          this.content = content;
      }
      return CssRule;
  }());
  /**
   * @param {?} input
   * @param {?} ruleCallback
   * @return {?}
   */
  function processRules(input, ruleCallback) {
      var /** @type {?} */ inputWithEscapedBlocks = escapeBlocks(input);
      var /** @type {?} */ nextBlockIndex = 0;
      return inputWithEscapedBlocks.escapedString.replace(_ruleRe, function () {
          var m = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              m[_i - 0] = arguments[_i];
          }
          var /** @type {?} */ selector = m[2];
          var /** @type {?} */ content = '';
          var /** @type {?} */ suffix = m[4];
          var /** @type {?} */ contentPrefix = '';
          if (suffix && suffix.startsWith('{' + BLOCK_PLACEHOLDER)) {
              content = inputWithEscapedBlocks.blocks[nextBlockIndex++];
              suffix = suffix.substring(BLOCK_PLACEHOLDER.length + 1);
              contentPrefix = '{';
          }
          var /** @type {?} */ rule = ruleCallback(new CssRule(selector, content));
          return "" + m[1] + rule.selector + m[3] + contentPrefix + rule.content + suffix;
      });
  }
  var StringWithEscapedBlocks = (function () {
      /**
       * @param {?} escapedString
       * @param {?} blocks
       */
      function StringWithEscapedBlocks(escapedString, blocks) {
          this.escapedString = escapedString;
          this.blocks = blocks;
      }
      return StringWithEscapedBlocks;
  }());
  /**
   * @param {?} input
   * @return {?}
   */
  function escapeBlocks(input) {
      var /** @type {?} */ inputParts = input.split(_curlyRe);
      var /** @type {?} */ resultParts = [];
      var /** @type {?} */ escapedBlocks = [];
      var /** @type {?} */ bracketCount = 0;
      var /** @type {?} */ currentBlockParts = [];
      for (var /** @type {?} */ partIndex = 0; partIndex < inputParts.length; partIndex++) {
          var /** @type {?} */ part = inputParts[partIndex];
          if (part == CLOSE_CURLY) {
              bracketCount--;
          }
          if (bracketCount > 0) {
              currentBlockParts.push(part);
          }
          else {
              if (currentBlockParts.length > 0) {
                  escapedBlocks.push(currentBlockParts.join(''));
                  resultParts.push(BLOCK_PLACEHOLDER);
                  currentBlockParts = [];
              }
              resultParts.push(part);
          }
          if (part == OPEN_CURLY) {
              bracketCount++;
          }
      }
      if (currentBlockParts.length > 0) {
          escapedBlocks.push(currentBlockParts.join(''));
          resultParts.push(BLOCK_PLACEHOLDER);
      }
      return new StringWithEscapedBlocks(resultParts.join(''), escapedBlocks);
  }

  var /** @type {?} */ COMPONENT_VARIABLE = '%COMP%';
  var /** @type {?} */ HOST_ATTR = "_nghost-" + COMPONENT_VARIABLE;
  var /** @type {?} */ CONTENT_ATTR = "_ngcontent-" + COMPONENT_VARIABLE;
  var StylesCompileDependency = (function () {
      /**
       * @param {?} moduleUrl
       * @param {?} isShimmed
       * @param {?} valuePlaceholder
       */
      function StylesCompileDependency(moduleUrl, isShimmed, valuePlaceholder) {
          this.moduleUrl = moduleUrl;
          this.isShimmed = isShimmed;
          this.valuePlaceholder = valuePlaceholder;
      }
      return StylesCompileDependency;
  }());
  var StylesCompileResult = (function () {
      /**
       * @param {?} componentStylesheet
       * @param {?} externalStylesheets
       */
      function StylesCompileResult(componentStylesheet, externalStylesheets) {
          this.componentStylesheet = componentStylesheet;
          this.externalStylesheets = externalStylesheets;
      }
      return StylesCompileResult;
  }());
  var CompiledStylesheet = (function () {
      /**
       * @param {?} statements
       * @param {?} stylesVar
       * @param {?} dependencies
       * @param {?} isShimmed
       * @param {?} meta
       */
      function CompiledStylesheet(statements, stylesVar, dependencies, isShimmed, meta) {
          this.statements = statements;
          this.stylesVar = stylesVar;
          this.dependencies = dependencies;
          this.isShimmed = isShimmed;
          this.meta = meta;
      }
      return CompiledStylesheet;
  }());
  var StyleCompiler = (function () {
      /**
       * @param {?} _urlResolver
       */
      function StyleCompiler(_urlResolver) {
          this._urlResolver = _urlResolver;
          this._shadowCss = new ShadowCss();
      }
      /**
       * @param {?} comp
       * @return {?}
       */
      StyleCompiler.prototype.compileComponent = function (comp) {
          var _this = this;
          var /** @type {?} */ externalStylesheets = [];
          var /** @type {?} */ componentStylesheet = this._compileStyles(comp, new CompileStylesheetMetadata({
              styles: comp.template.styles,
              styleUrls: comp.template.styleUrls,
              moduleUrl: comp.type.moduleUrl
          }), true);
          comp.template.externalStylesheets.forEach(function (stylesheetMeta) {
              var /** @type {?} */ compiledStylesheet = _this._compileStyles(comp, stylesheetMeta, false);
              externalStylesheets.push(compiledStylesheet);
          });
          return new StylesCompileResult(componentStylesheet, externalStylesheets);
      };
      /**
       * @param {?} comp
       * @param {?} stylesheet
       * @param {?} isComponentStylesheet
       * @return {?}
       */
      StyleCompiler.prototype._compileStyles = function (comp, stylesheet, isComponentStylesheet) {
          var _this = this;
          var /** @type {?} */ shim = comp.template.encapsulation === _angular_core.ViewEncapsulation.Emulated;
          var /** @type {?} */ styleExpressions = stylesheet.styles.map(function (plainStyle) { return literal(_this._shimIfNeeded(plainStyle, shim)); });
          var /** @type {?} */ dependencies = [];
          for (var /** @type {?} */ i = 0; i < stylesheet.styleUrls.length; i++) {
              var /** @type {?} */ identifier = new CompileIdentifierMetadata({ name: getStylesVarName(null) });
              dependencies.push(new StylesCompileDependency(stylesheet.styleUrls[i], shim, identifier));
              styleExpressions.push(new ExternalExpr(identifier));
          }
          // styles variable contains plain strings and arrays of other styles arrays (recursive),
          // so we set its type to dynamic.
          var /** @type {?} */ stylesVar = getStylesVarName(isComponentStylesheet ? comp : null);
          var /** @type {?} */ stmt = variable(stylesVar)
              .set(literalArr(styleExpressions, new ArrayType(DYNAMIC_TYPE, [TypeModifier.Const])))
              .toDeclStmt(null, [StmtModifier.Final]);
          return new CompiledStylesheet([stmt], stylesVar, dependencies, shim, stylesheet);
      };
      /**
       * @param {?} style
       * @param {?} shim
       * @return {?}
       */
      StyleCompiler.prototype._shimIfNeeded = function (style, shim) {
          return shim ? this._shadowCss.shimCssText(style, CONTENT_ATTR, HOST_ATTR) : style;
      };
      StyleCompiler.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      StyleCompiler.ctorParameters = function () { return [
          { type: UrlResolver, },
      ]; };
      return StyleCompiler;
  }());
  /**
   * @param {?} component
   * @return {?}
   */
  function getStylesVarName(component) {
      var /** @type {?} */ result = "styles";
      if (component) {
          result += "_" + component.type.name;
      }
      return result;
  }

  var _DebugState = (function () {
      /**
       * @param {?} nodeIndex
       * @param {?} sourceAst
       */
      function _DebugState(nodeIndex, sourceAst) {
          this.nodeIndex = nodeIndex;
          this.sourceAst = sourceAst;
      }
      return _DebugState;
  }());
  var /** @type {?} */ NULL_DEBUG_STATE = new _DebugState(null, null);
  var CompileMethod = (function () {
      /**
       * @param {?} _view
       */
      function CompileMethod(_view) {
          this._view = _view;
          this._newState = NULL_DEBUG_STATE;
          this._currState = NULL_DEBUG_STATE;
          this._bodyStatements = [];
          this._debugEnabled = this._view.genConfig.genDebugInfo;
      }
      /**
       * @return {?}
       */
      CompileMethod.prototype._updateDebugContextIfNeeded = function () {
          if (this._newState.nodeIndex !== this._currState.nodeIndex ||
              this._newState.sourceAst !== this._currState.sourceAst) {
              var /** @type {?} */ expr = this._updateDebugContext(this._newState);
              if (isPresent(expr)) {
                  this._bodyStatements.push(expr.toStmt());
              }
          }
      };
      /**
       * @param {?} newState
       * @return {?}
       */
      CompileMethod.prototype._updateDebugContext = function (newState) {
          this._currState = this._newState = newState;
          if (this._debugEnabled) {
              var /** @type {?} */ sourceLocation = isPresent(newState.sourceAst) ? newState.sourceAst.sourceSpan.start : null;
              return THIS_EXPR.callMethod('debug', [
                  literal(newState.nodeIndex),
                  isPresent(sourceLocation) ? literal(sourceLocation.line) : NULL_EXPR,
                  isPresent(sourceLocation) ? literal(sourceLocation.col) : NULL_EXPR
              ]);
          }
          else {
              return null;
          }
      };
      /**
       * @param {?} nodeIndex
       * @param {?} templateAst
       * @return {?}
       */
      CompileMethod.prototype.resetDebugInfoExpr = function (nodeIndex, templateAst) {
          var /** @type {?} */ res = this._updateDebugContext(new _DebugState(nodeIndex, templateAst));
          return res || NULL_EXPR;
      };
      /**
       * @param {?} nodeIndex
       * @param {?} templateAst
       * @return {?}
       */
      CompileMethod.prototype.resetDebugInfo = function (nodeIndex, templateAst) {
          this._newState = new _DebugState(nodeIndex, templateAst);
      };
      /**
       * @param {...?} stmts
       * @return {?}
       */
      CompileMethod.prototype.push = function () {
          var stmts = [];
          for (var _i = 0; _i < arguments.length; _i++) {
              stmts[_i - 0] = arguments[_i];
          }
          this.addStmts(stmts);
      };
      /**
       * @param {?} stmt
       * @return {?}
       */
      CompileMethod.prototype.addStmt = function (stmt) {
          this._updateDebugContextIfNeeded();
          this._bodyStatements.push(stmt);
      };
      /**
       * @param {?} stmts
       * @return {?}
       */
      CompileMethod.prototype.addStmts = function (stmts) {
          this._updateDebugContextIfNeeded();
          (_a = this._bodyStatements).push.apply(_a, stmts);
          var _a;
      };
      /**
       * @return {?}
       */
      CompileMethod.prototype.finish = function () { return this._bodyStatements; };
      /**
       * @return {?}
       */
      CompileMethod.prototype.isEmpty = function () { return this._bodyStatements.length === 0; };
      return CompileMethod;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$20 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  /**
   * @param {?} property
   * @param {?} callingView
   * @param {?} definedView
   * @return {?}
   */
  function getPropertyInView(property, callingView, definedView) {
      if (callingView === definedView) {
          return property;
      }
      else {
          var /** @type {?} */ viewProp = THIS_EXPR;
          var /** @type {?} */ currView = callingView;
          while (currView !== definedView && isPresent(currView.declarationElement.view)) {
              currView = currView.declarationElement.view;
              viewProp = viewProp.prop('parentView');
          }
          if (currView !== definedView) {
              throw new Error("Internal error: Could not calculate a property in a parent view: " + property);
          }
          return property.visitExpression(new _ReplaceViewTransformer(viewProp, definedView), null);
      }
  }
  var _ReplaceViewTransformer = (function (_super) {
      __extends$20(_ReplaceViewTransformer, _super);
      /**
       * @param {?} _viewExpr
       * @param {?} _view
       */
      function _ReplaceViewTransformer(_viewExpr, _view) {
          _super.call(this);
          this._viewExpr = _viewExpr;
          this._view = _view;
      }
      /**
       * @param {?} expr
       * @return {?}
       */
      _ReplaceViewTransformer.prototype._isThis = function (expr) {
          return expr instanceof ReadVarExpr && expr.builtin === BuiltinVar.This;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _ReplaceViewTransformer.prototype.visitReadVarExpr = function (ast, context) {
          return this._isThis(ast) ? this._viewExpr : ast;
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _ReplaceViewTransformer.prototype.visitReadPropExpr = function (ast, context) {
          if (this._isThis(ast.receiver)) {
              // Note: Don't cast for members of the AppView base class...
              if (this._view.fields.some(function (field) { return field.name == ast.name; }) ||
                  this._view.getters.some(function (field) { return field.name == ast.name; })) {
                  return this._viewExpr.cast(this._view.classType).prop(ast.name);
              }
          }
          return _super.prototype.visitReadPropExpr.call(this, ast, context);
      };
      return _ReplaceViewTransformer;
  }(ExpressionTransformer));
  /**
   * @param {?} view
   * @param {?} token
   * @param {?} optional
   * @return {?}
   */
  function injectFromViewParentInjector(view, token, optional) {
      var /** @type {?} */ viewExpr;
      if (view.viewType === ViewType.HOST) {
          viewExpr = THIS_EXPR;
      }
      else {
          viewExpr = THIS_EXPR.prop('parentView');
      }
      var /** @type {?} */ args = [createDiTokenExpression(token), THIS_EXPR.prop('parentIndex')];
      if (optional) {
          args.push(NULL_EXPR);
      }
      return viewExpr.callMethod('injectorGet', args);
  }
  /**
   * @param {?} component
   * @param {?} embeddedTemplateIndex
   * @return {?}
   */
  function getViewClassName(component, embeddedTemplateIndex) {
      return "View_" + component.type.name + embeddedTemplateIndex;
  }
  /**
   * @param {?} elementIndex
   * @return {?}
   */
  function getHandleEventMethodName(elementIndex) {
      return "handleEvent_" + elementIndex;
  }

  var ViewQueryValues = (function () {
      /**
       * @param {?} view
       * @param {?} values
       */
      function ViewQueryValues(view, values) {
          this.view = view;
          this.values = values;
      }
      return ViewQueryValues;
  }());
  var CompileQuery = (function () {
      /**
       * @param {?} meta
       * @param {?} queryList
       * @param {?} ownerDirectiveExpression
       * @param {?} view
       */
      function CompileQuery(meta, queryList, ownerDirectiveExpression, view) {
          this.meta = meta;
          this.queryList = queryList;
          this.ownerDirectiveExpression = ownerDirectiveExpression;
          this.view = view;
          this._values = new ViewQueryValues(view, []);
      }
      /**
       * @param {?} value
       * @param {?} view
       * @return {?}
       */
      CompileQuery.prototype.addValue = function (value, view) {
          var /** @type {?} */ currentView = view;
          var /** @type {?} */ elPath = [];
          while (isPresent(currentView) && currentView !== this.view) {
              var /** @type {?} */ parentEl = currentView.declarationElement;
              elPath.unshift(parentEl);
              currentView = parentEl.view;
          }
          var /** @type {?} */ queryListForDirtyExpr = getPropertyInView(this.queryList, view, this.view);
          var /** @type {?} */ viewValues = this._values;
          elPath.forEach(function (el) {
              var /** @type {?} */ last = viewValues.values.length > 0 ? viewValues.values[viewValues.values.length - 1] : null;
              if (last instanceof ViewQueryValues && last.view === el.embeddedView) {
                  viewValues = last;
              }
              else {
                  var /** @type {?} */ newViewValues = new ViewQueryValues(el.embeddedView, []);
                  viewValues.values.push(newViewValues);
                  viewValues = newViewValues;
              }
          });
          viewValues.values.push(value);
          if (elPath.length > 0) {
              view.dirtyParentQueriesMethod.addStmt(queryListForDirtyExpr.callMethod('setDirty', []).toStmt());
          }
      };
      /**
       * @return {?}
       */
      CompileQuery.prototype._isStatic = function () {
          return !this._values.values.some(function (value) { return value instanceof ViewQueryValues; });
      };
      /**
       * @param {?} targetStaticMethod
       * @param {?} targetDynamicMethod
       * @return {?}
       */
      CompileQuery.prototype.afterChildren = function (targetStaticMethod, targetDynamicMethod) {
          var /** @type {?} */ values = createQueryValues(this._values);
          var /** @type {?} */ updateStmts = [this.queryList.callMethod('reset', [literalArr(values)]).toStmt()];
          if (isPresent(this.ownerDirectiveExpression)) {
              var /** @type {?} */ valueExpr = this.meta.first ? this.queryList.prop('first') : this.queryList;
              updateStmts.push(this.ownerDirectiveExpression.prop(this.meta.propertyName).set(valueExpr).toStmt());
          }
          if (!this.meta.first) {
              updateStmts.push(this.queryList.callMethod('notifyOnChanges', []).toStmt());
          }
          if (this.meta.first && this._isStatic()) {
              // for queries that don't change and the user asked for a single element,
              // set it immediately. That is e.g. needed for querying for ViewContainerRefs, ...
              // we don't do this for QueryLists for now as this would break the timing when
              // we call QueryList listeners...
              targetStaticMethod.addStmts(updateStmts);
          }
          else {
              targetDynamicMethod.addStmt(new IfStmt(this.queryList.prop('dirty'), updateStmts));
          }
      };
      return CompileQuery;
  }());
  /**
   * @param {?} viewValues
   * @return {?}
   */
  function createQueryValues(viewValues) {
      return ListWrapper.flatten(viewValues.values.map(function (entry) {
          if (entry instanceof ViewQueryValues) {
              return mapNestedViews(entry.view.declarationElement.viewContainer, entry.view, createQueryValues(entry));
          }
          else {
              return (entry);
          }
      }));
  }
  /**
   * @param {?} viewContainer
   * @param {?} view
   * @param {?} expressions
   * @return {?}
   */
  function mapNestedViews(viewContainer, view, expressions) {
      var /** @type {?} */ adjustedExpressions = expressions.map(function (expr) { return replaceVarInExpression(THIS_EXPR.name, variable('nestedView'), expr); });
      return viewContainer.callMethod('mapNestedViews', [
          variable(view.className),
          fn([new FnParam('nestedView', view.classType)], [new ReturnStatement(literalArr(adjustedExpressions))], DYNAMIC_TYPE)
      ]);
  }
  /**
   * @param {?} query
   * @param {?} directiveInstance
   * @param {?} propertyName
   * @param {?} compileView
   * @return {?}
   */
  function createQueryList(query, directiveInstance, propertyName, compileView) {
      compileView.fields.push(new ClassField(propertyName, importType(resolveIdentifier(Identifiers.QueryList), [DYNAMIC_TYPE])));
      var /** @type {?} */ expr = THIS_EXPR.prop(propertyName);
      compileView.createMethod.addStmt(THIS_EXPR.prop(propertyName)
          .set(importExpr(resolveIdentifier(Identifiers.QueryList), [DYNAMIC_TYPE])
          .instantiate([]))
          .toStmt());
      return expr;
  }
  /**
   * @param {?} map
   * @param {?} query
   * @return {?}
   */
  function addQueryToTokenMap(map, query) {
      query.meta.selectors.forEach(function (selector) {
          var /** @type {?} */ entry = map.get(selector.reference);
          if (!entry) {
              entry = [];
              map.set(selector.reference, entry);
          }
          entry.push(query);
      });
  }

  var ViewTypeEnum = (function () {
      function ViewTypeEnum() {
      }
      /**
       * @param {?} value
       * @return {?}
       */
      ViewTypeEnum.fromValue = function (value) {
          return createEnumExpression(Identifiers.ViewType, value);
      };
      return ViewTypeEnum;
  }());
  var ViewEncapsulationEnum = (function () {
      function ViewEncapsulationEnum() {
      }
      /**
       * @param {?} value
       * @return {?}
       */
      ViewEncapsulationEnum.fromValue = function (value) {
          return createEnumExpression(Identifiers.ViewEncapsulation, value);
      };
      return ViewEncapsulationEnum;
  }());
  var ChangeDetectorStatusEnum = (function () {
      function ChangeDetectorStatusEnum() {
      }
      /**
       * @param {?} value
       * @return {?}
       */
      ChangeDetectorStatusEnum.fromValue = function (value) {
          return createEnumExpression(Identifiers.ChangeDetectorStatus, value);
      };
      return ChangeDetectorStatusEnum;
  }());
  var ViewConstructorVars = (function () {
      function ViewConstructorVars() {
      }
      ViewConstructorVars.viewUtils = variable('viewUtils');
      ViewConstructorVars.parentView = variable('parentView');
      ViewConstructorVars.parentIndex = variable('parentIndex');
      ViewConstructorVars.parentElement = variable('parentElement');
      return ViewConstructorVars;
  }());
  var ViewProperties = (function () {
      function ViewProperties() {
      }
      ViewProperties.renderer = THIS_EXPR.prop('renderer');
      ViewProperties.viewUtils = THIS_EXPR.prop('viewUtils');
      return ViewProperties;
  }());
  var InjectMethodVars$1 = (function () {
      function InjectMethodVars() {
      }
      InjectMethodVars.token = variable('token');
      InjectMethodVars.requestNodeIndex = variable('requestNodeIndex');
      InjectMethodVars.notFoundResult = variable('notFoundResult');
      return InjectMethodVars;
  }());
  var DetectChangesVars = (function () {
      function DetectChangesVars() {
      }
      DetectChangesVars.throwOnChange = variable("throwOnChange");
      DetectChangesVars.changes = variable("changes");
      DetectChangesVars.changed = variable("changed");
      return DetectChangesVars;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var ViewClassDependency = (function () {
      /**
       * @param {?} comp
       * @param {?} placeholder
       */
      function ViewClassDependency(comp, placeholder) {
          this.comp = comp;
          this.placeholder = placeholder;
      }
      return ViewClassDependency;
  }());
  var ComponentFactoryDependency$1 = (function () {
      /**
       * @param {?} comp
       * @param {?} placeholder
       */
      function ComponentFactoryDependency(comp, placeholder) {
          this.comp = comp;
          this.placeholder = placeholder;
      }
      return ComponentFactoryDependency;
  }());
  var DirectiveWrapperDependency = (function () {
      /**
       * @param {?} dir
       * @param {?} placeholder
       */
      function DirectiveWrapperDependency(dir, placeholder) {
          this.dir = dir;
          this.placeholder = placeholder;
      }
      return DirectiveWrapperDependency;
  }());

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$19 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var CompileNode = (function () {
      /**
       * @param {?} parent
       * @param {?} view
       * @param {?} nodeIndex
       * @param {?} renderNode
       * @param {?} sourceAst
       */
      function CompileNode(parent, view, nodeIndex, renderNode, sourceAst) {
          this.parent = parent;
          this.view = view;
          this.nodeIndex = nodeIndex;
          this.renderNode = renderNode;
          this.sourceAst = sourceAst;
      }
      /**
       * @return {?}
       */
      CompileNode.prototype.isNull = function () { return !this.renderNode; };
      /**
       * @return {?}
       */
      CompileNode.prototype.isRootElement = function () { return this.view != this.parent.view; };
      return CompileNode;
  }());
  var CompileElement = (function (_super) {
      __extends$19(CompileElement, _super);
      /**
       * @param {?} parent
       * @param {?} view
       * @param {?} nodeIndex
       * @param {?} renderNode
       * @param {?} sourceAst
       * @param {?} component
       * @param {?} _directives
       * @param {?} _resolvedProvidersArray
       * @param {?} hasViewContainer
       * @param {?} hasEmbeddedView
       * @param {?} references
       * @param {?} _targetDependencies
       */
      function CompileElement(parent, view, nodeIndex, renderNode, sourceAst, component, _directives, _resolvedProvidersArray, hasViewContainer, hasEmbeddedView, references, _targetDependencies) {
          var _this = this;
          _super.call(this, parent, view, nodeIndex, renderNode, sourceAst);
          this.component = component;
          this._directives = _directives;
          this._resolvedProvidersArray = _resolvedProvidersArray;
          this.hasViewContainer = hasViewContainer;
          this.hasEmbeddedView = hasEmbeddedView;
          this._targetDependencies = _targetDependencies;
          this.compViewExpr = null;
          this.instances = new Map();
          this.directiveWrapperInstance = new Map();
          this._queryCount = 0;
          this._queries = new Map();
          this.contentNodesByNgContentIndex = null;
          this.referenceTokens = {};
          references.forEach(function (ref) { return _this.referenceTokens[ref.name] = ref.value; });
          this.elementRef =
              importExpr(resolveIdentifier(Identifiers.ElementRef)).instantiate([this.renderNode]);
          this.instances.set(resolveIdentifierToken(Identifiers.ElementRef).reference, this.elementRef);
          this.instances.set(resolveIdentifierToken(Identifiers.Injector).reference, THIS_EXPR.callMethod('injector', [literal(this.nodeIndex)]));
          this.instances.set(resolveIdentifierToken(Identifiers.Renderer).reference, THIS_EXPR.prop('renderer'));
          if (this.hasViewContainer || this.hasEmbeddedView) {
              this._createViewContainer();
          }
          if (this.component) {
              this._createComponentFactoryResolver();
          }
      }
      /**
       * @return {?}
       */
      CompileElement.createNull = function () {
          return new CompileElement(null, null, null, null, null, null, [], [], false, false, [], []);
      };
      /**
       * @return {?}
       */
      CompileElement.prototype._createViewContainer = function () {
          var /** @type {?} */ fieldName = "_vc_" + this.nodeIndex;
          var /** @type {?} */ parentNodeIndex = this.isRootElement() ? null : this.parent.nodeIndex;
          // private is fine here as no child view will reference a ViewContainer
          this.view.fields.push(new ClassField(fieldName, importType(resolveIdentifier(Identifiers.ViewContainer)), [StmtModifier.Private]));
          var /** @type {?} */ statement = THIS_EXPR.prop(fieldName)
              .set(importExpr(resolveIdentifier(Identifiers.ViewContainer)).instantiate([
              literal(this.nodeIndex), literal(parentNodeIndex), THIS_EXPR, this.renderNode
          ]))
              .toStmt();
          this.view.createMethod.addStmt(statement);
          this.viewContainer = THIS_EXPR.prop(fieldName);
          this.instances.set(resolveIdentifierToken(Identifiers.ViewContainer).reference, this.viewContainer);
          this.view.viewContainers.push(this.viewContainer);
      };
      /**
       * @return {?}
       */
      CompileElement.prototype._createComponentFactoryResolver = function () {
          var _this = this;
          var /** @type {?} */ entryComponents = this.component.entryComponents.map(function (entryComponent) {
              var /** @type {?} */ id = new CompileIdentifierMetadata({ name: entryComponent.name });
              _this._targetDependencies.push(new ComponentFactoryDependency$1(entryComponent, id));
              return id;
          });
          if (!entryComponents || entryComponents.length === 0) {
              return;
          }
          var /** @type {?} */ createComponentFactoryResolverExpr = importExpr(resolveIdentifier(Identifiers.CodegenComponentFactoryResolver)).instantiate([
              literalArr(entryComponents.map(function (entryComponent) { return importExpr(entryComponent); })),
              injectFromViewParentInjector(this.view, resolveIdentifierToken(Identifiers.ComponentFactoryResolver), false)
          ]);
          var /** @type {?} */ provider = new CompileProviderMetadata({
              token: resolveIdentifierToken(Identifiers.ComponentFactoryResolver),
              useValue: createComponentFactoryResolverExpr
          });
          // Add ComponentFactoryResolver as first provider as it does not have deps on other providers
          // ProviderAstType.PrivateService as only the component and its view can see it,
          // but nobody else
          this._resolvedProvidersArray.unshift(new ProviderAst(provider.token, false, true, [provider], ProviderAstType.PrivateService, [], this.sourceAst.sourceSpan));
      };
      /**
       * @param {?} compViewExpr
       * @return {?}
       */
      CompileElement.prototype.setComponentView = function (compViewExpr) {
          this.compViewExpr = compViewExpr;
          this.contentNodesByNgContentIndex =
              new Array(this.component.template.ngContentSelectors.length);
          for (var /** @type {?} */ i = 0; i < this.contentNodesByNgContentIndex.length; i++) {
              this.contentNodesByNgContentIndex[i] = [];
          }
      };
      /**
       * @param {?} embeddedView
       * @return {?}
       */
      CompileElement.prototype.setEmbeddedView = function (embeddedView) {
          this.embeddedView = embeddedView;
          if (isPresent(embeddedView)) {
              var /** @type {?} */ createTemplateRefExpr = importExpr(resolveIdentifier(Identifiers.TemplateRef_)).instantiate([
                  THIS_EXPR, literal(this.nodeIndex), this.renderNode
              ]);
              var /** @type {?} */ provider = new CompileProviderMetadata({
                  token: resolveIdentifierToken(Identifiers.TemplateRef),
                  useValue: createTemplateRefExpr
              });
              // Add TemplateRef as first provider as it does not have deps on other providers
              this._resolvedProvidersArray.unshift(new ProviderAst(provider.token, false, true, [provider], ProviderAstType.Builtin, [], this.sourceAst.sourceSpan));
          }
      };
      /**
       * @return {?}
       */
      CompileElement.prototype.beforeChildren = function () {
          var _this = this;
          if (this.hasViewContainer) {
              this.instances.set(resolveIdentifierToken(Identifiers.ViewContainerRef).reference, this.viewContainer.prop('vcRef'));
          }
          this._resolvedProviders = new Map();
          this._resolvedProvidersArray.forEach(function (provider) { return _this._resolvedProviders.set(provider.token.reference, provider); });
          // create all the provider instances, some in the view constructor,
          // some as getters. We rely on the fact that they are already sorted topologically.
          Array.from(this._resolvedProviders.values()).forEach(function (resolvedProvider) {
              var /** @type {?} */ isDirectiveWrapper = resolvedProvider.providerType === ProviderAstType.Component ||
                  resolvedProvider.providerType === ProviderAstType.Directive;
              var /** @type {?} */ providerValueExpressions = resolvedProvider.providers.map(function (provider) {
                  if (provider.useExisting) {
                      return _this._getDependency(resolvedProvider.providerType, new CompileDiDependencyMetadata({ token: provider.useExisting }));
                  }
                  else if (provider.useFactory) {
                      var /** @type {?} */ deps = provider.deps || provider.useFactory.diDeps;
                      var /** @type {?} */ depsExpr = deps.map(function (dep) { return _this._getDependency(resolvedProvider.providerType, dep); });
                      return importExpr(provider.useFactory).callFn(depsExpr);
                  }
                  else if (provider.useClass) {
                      var /** @type {?} */ deps = provider.deps || provider.useClass.diDeps;
                      var /** @type {?} */ depsExpr = deps.map(function (dep) { return _this._getDependency(resolvedProvider.providerType, dep); });
                      if (isDirectiveWrapper) {
                          var /** @type {?} */ directiveWrapperIdentifier = new CompileIdentifierMetadata({ name: DirectiveWrapperCompiler.dirWrapperClassName(provider.useClass) });
                          _this._targetDependencies.push(new DirectiveWrapperDependency(provider.useClass, directiveWrapperIdentifier));
                          return DirectiveWrapperExpressions.create(directiveWrapperIdentifier, depsExpr);
                      }
                      else {
                          return importExpr(provider.useClass)
                              .instantiate(depsExpr, importType(provider.useClass));
                      }
                  }
                  else {
                      return convertValueToOutputAst(provider.useValue);
                  }
              });
              var /** @type {?} */ propName = "_" + resolvedProvider.token.name + "_" + _this.nodeIndex + "_" + _this.instances.size;
              var /** @type {?} */ instance = createProviderProperty(propName, resolvedProvider, providerValueExpressions, resolvedProvider.multiProvider, resolvedProvider.eager, _this);
              if (isDirectiveWrapper) {
                  _this.directiveWrapperInstance.set(resolvedProvider.token.reference, instance);
                  _this.instances.set(resolvedProvider.token.reference, DirectiveWrapperExpressions.context(instance));
              }
              else {
                  _this.instances.set(resolvedProvider.token.reference, instance);
              }
          });
          var _loop_1 = function(i) {
              var /** @type {?} */ directive = this_1._directives[i];
              var /** @type {?} */ directiveInstance = this_1.instances.get(identifierToken(directive.type).reference);
              directive.queries.forEach(function (queryMeta) { _this._addQuery(queryMeta, directiveInstance); });
          };
          var this_1 = this;
          for (var /** @type {?} */ i = 0; i < this._directives.length; i++) {
              _loop_1(i);
          }
          var /** @type {?} */ queriesWithReads = [];
          Array.from(this._resolvedProviders.values()).forEach(function (resolvedProvider) {
              var /** @type {?} */ queriesForProvider = _this._getQueriesFor(resolvedProvider.token);
              queriesWithReads.push.apply(queriesWithReads, queriesForProvider.map(function (query) { return new _QueryWithRead(query, resolvedProvider.token); }));
          });
          Object.keys(this.referenceTokens).forEach(function (varName) {
              var /** @type {?} */ token = _this.referenceTokens[varName];
              var /** @type {?} */ varValue;
              if (token) {
                  varValue = _this.instances.get(token.reference);
              }
              else {
                  varValue = _this.renderNode;
              }
              _this.view.locals.set(varName, varValue);
              var /** @type {?} */ varToken = new CompileTokenMetadata({ value: varName });
              queriesWithReads.push.apply(queriesWithReads, _this._getQueriesFor(varToken).map(function (query) { return new _QueryWithRead(query, varToken); }));
          });
          queriesWithReads.forEach(function (queryWithRead) {
              var /** @type {?} */ value;
              if (isPresent(queryWithRead.read.identifier)) {
                  // query for an identifier
                  value = _this.instances.get(queryWithRead.read.reference);
              }
              else {
                  // query for a reference
                  var /** @type {?} */ token = _this.referenceTokens[queryWithRead.read.value];
                  if (isPresent(token)) {
                      value = _this.instances.get(token.reference);
                  }
                  else {
                      value = _this.elementRef;
                  }
              }
              if (isPresent(value)) {
                  queryWithRead.query.addValue(value, _this.view);
              }
          });
      };
      /**
       * @param {?} childNodeCount
       * @return {?}
       */
      CompileElement.prototype.afterChildren = function (childNodeCount) {
          var _this = this;
          Array.from(this._resolvedProviders.values()).forEach(function (resolvedProvider) {
              // Note: afterChildren is called after recursing into children.
              // This is good so that an injector match in an element that is closer to a requesting element
              // matches first.
              var /** @type {?} */ providerExpr = _this.instances.get(resolvedProvider.token.reference);
              // Note: view providers are only visible on the injector of that element.
              // This is not fully correct as the rules during codegen don't allow a directive
              // to get hold of a view provdier on the same element. We still do this semantic
              // as it simplifies our model to having only one runtime injector per element.
              var /** @type {?} */ providerChildNodeCount = resolvedProvider.providerType === ProviderAstType.PrivateService ? 0 : childNodeCount;
              _this.view.injectorGetMethod.addStmt(createInjectInternalCondition(_this.nodeIndex, providerChildNodeCount, resolvedProvider, providerExpr));
          });
          Array.from(this._queries.values())
              .forEach(function (queries) { return queries.forEach(function (q) {
              return q.afterChildren(_this.view.createMethod, _this.view.updateContentQueriesMethod);
          }); });
      };
      /**
       * @param {?} ngContentIndex
       * @param {?} nodeExpr
       * @return {?}
       */
      CompileElement.prototype.addContentNode = function (ngContentIndex, nodeExpr) {
          this.contentNodesByNgContentIndex[ngContentIndex].push(nodeExpr);
      };
      /**
       * @return {?}
       */
      CompileElement.prototype.getComponent = function () {
          return isPresent(this.component) ?
              this.instances.get(identifierToken(this.component.type).reference) :
              null;
      };
      /**
       * @return {?}
       */
      CompileElement.prototype.getProviderTokens = function () {
          return Array.from(this._resolvedProviders.values())
              .map(function (resolvedProvider) { return createDiTokenExpression(resolvedProvider.token); });
      };
      /**
       * @param {?} token
       * @return {?}
       */
      CompileElement.prototype._getQueriesFor = function (token) {
          var /** @type {?} */ result = [];
          var /** @type {?} */ currentEl = this;
          var /** @type {?} */ distance = 0;
          var /** @type {?} */ queries;
          while (!currentEl.isNull()) {
              queries = currentEl._queries.get(token.reference);
              if (isPresent(queries)) {
                  result.push.apply(result, queries.filter(function (query) { return query.meta.descendants || distance <= 1; }));
              }
              if (currentEl._directives.length > 0) {
                  distance++;
              }
              currentEl = currentEl.parent;
          }
          queries = this.view.componentView.viewQueries.get(token.reference);
          if (isPresent(queries)) {
              result.push.apply(result, queries);
          }
          return result;
      };
      /**
       * @param {?} queryMeta
       * @param {?} directiveInstance
       * @return {?}
       */
      CompileElement.prototype._addQuery = function (queryMeta, directiveInstance) {
          var /** @type {?} */ propName = "_query_" + queryMeta.selectors[0].name + "_" + this.nodeIndex + "_" + this._queryCount++;
          var /** @type {?} */ queryList = createQueryList(queryMeta, directiveInstance, propName, this.view);
          var /** @type {?} */ query = new CompileQuery(queryMeta, queryList, directiveInstance, this.view);
          addQueryToTokenMap(this._queries, query);
          return query;
      };
      /**
       * @param {?} requestingProviderType
       * @param {?} dep
       * @return {?}
       */
      CompileElement.prototype._getLocalDependency = function (requestingProviderType, dep) {
          var /** @type {?} */ result = null;
          if (isPresent(dep.token)) {
              // access builtins with special visibility
              if (!result) {
                  if (dep.token.reference ===
                      resolveIdentifierToken(Identifiers.ChangeDetectorRef).reference) {
                      if (requestingProviderType === ProviderAstType.Component) {
                          return this.compViewExpr.prop('ref');
                      }
                      else {
                          return getPropertyInView(THIS_EXPR.prop('ref'), this.view, this.view.componentView);
                      }
                  }
              }
              // access regular providers on the element
              if (!result) {
                  var /** @type {?} */ resolvedProvider = this._resolvedProviders.get(dep.token.reference);
                  // don't allow directives / public services to access private services.
                  // only components and private services can access private services.
                  if (resolvedProvider && (requestingProviderType === ProviderAstType.Directive ||
                      requestingProviderType === ProviderAstType.PublicService) &&
                      resolvedProvider.providerType === ProviderAstType.PrivateService) {
                      return null;
                  }
                  result = this.instances.get(dep.token.reference);
              }
          }
          return result;
      };
      /**
       * @param {?} requestingProviderType
       * @param {?} dep
       * @return {?}
       */
      CompileElement.prototype._getDependency = function (requestingProviderType, dep) {
          var /** @type {?} */ currElement = this;
          var /** @type {?} */ result = null;
          if (dep.isValue) {
              result = literal(dep.value);
          }
          if (!result && !dep.isSkipSelf) {
              result = this._getLocalDependency(requestingProviderType, dep);
          }
          // check parent elements
          while (!result && !currElement.parent.isNull()) {
              currElement = currElement.parent;
              result = currElement._getLocalDependency(ProviderAstType.PublicService, new CompileDiDependencyMetadata({ token: dep.token }));
          }
          if (!result) {
              result = injectFromViewParentInjector(this.view, dep.token, dep.isOptional);
          }
          if (!result) {
              result = NULL_EXPR;
          }
          return getPropertyInView(result, this.view, currElement.view);
      };
      return CompileElement;
  }(CompileNode));
  /**
   * @param {?} nodeIndex
   * @param {?} childNodeCount
   * @param {?} provider
   * @param {?} providerExpr
   * @return {?}
   */
  function createInjectInternalCondition(nodeIndex, childNodeCount, provider, providerExpr) {
      var /** @type {?} */ indexCondition;
      if (childNodeCount > 0) {
          indexCondition = literal(nodeIndex)
              .lowerEquals(InjectMethodVars$1.requestNodeIndex)
              .and(InjectMethodVars$1.requestNodeIndex.lowerEquals(literal(nodeIndex + childNodeCount)));
      }
      else {
          indexCondition = literal(nodeIndex).identical(InjectMethodVars$1.requestNodeIndex);
      }
      return new IfStmt(InjectMethodVars$1.token.identical(createDiTokenExpression(provider.token)).and(indexCondition), [new ReturnStatement(providerExpr)]);
  }
  /**
   * @param {?} propName
   * @param {?} provider
   * @param {?} providerValueExpressions
   * @param {?} isMulti
   * @param {?} isEager
   * @param {?} compileElement
   * @return {?}
   */
  function createProviderProperty(propName, provider, providerValueExpressions, isMulti, isEager, compileElement) {
      var /** @type {?} */ view = compileElement.view;
      var /** @type {?} */ resolvedProviderValueExpr;
      var /** @type {?} */ type;
      if (isMulti) {
          resolvedProviderValueExpr = literalArr(providerValueExpressions);
          type = new ArrayType(DYNAMIC_TYPE);
      }
      else {
          resolvedProviderValueExpr = providerValueExpressions[0];
          type = providerValueExpressions[0].type;
      }
      if (!type) {
          type = DYNAMIC_TYPE;
      }
      if (isEager) {
          view.fields.push(new ClassField(propName, type));
          view.createMethod.addStmt(THIS_EXPR.prop(propName).set(resolvedProviderValueExpr).toStmt());
      }
      else {
          var /** @type {?} */ internalField = "_" + propName;
          view.fields.push(new ClassField(internalField, type));
          var /** @type {?} */ getter = new CompileMethod(view);
          getter.resetDebugInfo(compileElement.nodeIndex, compileElement.sourceAst);
          // Note: Equals is important for JS so that it also checks the undefined case!
          getter.addStmt(new IfStmt(THIS_EXPR.prop(internalField).isBlank(), [THIS_EXPR.prop(internalField).set(resolvedProviderValueExpr).toStmt()]));
          getter.addStmt(new ReturnStatement(THIS_EXPR.prop(internalField)));
          view.getters.push(new ClassGetter(propName, getter.finish(), type));
      }
      return THIS_EXPR.prop(propName);
  }
  var _QueryWithRead = (function () {
      /**
       * @param {?} query
       * @param {?} match
       */
      function _QueryWithRead(query, match) {
          this.query = query;
          this.read = query.meta.read || match;
      }
      return _QueryWithRead;
  }());

  var CompilePipe = (function () {
      /**
       * @param {?} view
       * @param {?} meta
       */
      function CompilePipe(view, meta) {
          var _this = this;
          this.view = view;
          this.meta = meta;
          this._purePipeProxyCount = 0;
          this.instance = THIS_EXPR.prop("_pipe_" + meta.name + "_" + view.pipeCount++);
          var deps = this.meta.type.diDeps.map(function (diDep) {
              if (diDep.token.reference ===
                  resolveIdentifierToken(Identifiers.ChangeDetectorRef).reference) {
                  return getPropertyInView(THIS_EXPR.prop('ref'), _this.view, _this.view.componentView);
              }
              return injectFromViewParentInjector(view, diDep.token, false);
          });
          this.view.fields.push(new ClassField(this.instance.name, importType(this.meta.type)));
          this.view.createMethod.resetDebugInfo(null, null);
          this.view.createMethod.addStmt(THIS_EXPR.prop(this.instance.name)
              .set(importExpr(this.meta.type).instantiate(deps))
              .toStmt());
      }
      /**
       * @param {?} view
       * @param {?} name
       * @param {?} args
       * @return {?}
       */
      CompilePipe.call = function (view, name, args) {
          var /** @type {?} */ compView = view.componentView;
          var /** @type {?} */ meta = _findPipeMeta(compView, name);
          var /** @type {?} */ pipe;
          if (meta.pure) {
              // pure pipes live on the component view
              pipe = compView.purePipes.get(name);
              if (!pipe) {
                  pipe = new CompilePipe(compView, meta);
                  compView.purePipes.set(name, pipe);
                  compView.pipes.push(pipe);
              }
          }
          else {
              // Non pure pipes live on the view that called it
              pipe = new CompilePipe(view, meta);
              view.pipes.push(pipe);
          }
          return pipe._call(view, args);
      };
      Object.defineProperty(CompilePipe.prototype, "pure", {
          /**
           * @return {?}
           */
          get: function () { return this.meta.pure; },
          enumerable: true,
          configurable: true
      });
      /**
       * @param {?} callingView
       * @param {?} args
       * @return {?}
       */
      CompilePipe.prototype._call = function (callingView, args) {
          if (this.meta.pure) {
              // PurePipeProxies live on the view that called them.
              var /** @type {?} */ purePipeProxyInstance = THIS_EXPR.prop(this.instance.name + "_" + this._purePipeProxyCount++);
              var /** @type {?} */ pipeInstanceSeenFromPureProxy = getPropertyInView(this.instance, callingView, this.view);
              createPureProxy(pipeInstanceSeenFromPureProxy.prop('transform')
                  .callMethod(BuiltinMethod.Bind, [pipeInstanceSeenFromPureProxy]), args.length, purePipeProxyInstance, { fields: callingView.fields, ctorStmts: callingView.createMethod });
              return importExpr(resolveIdentifier(Identifiers.castByValue))
                  .callFn([purePipeProxyInstance, pipeInstanceSeenFromPureProxy.prop('transform')])
                  .callFn(args);
          }
          else {
              return getPropertyInView(this.instance, callingView, this.view).callMethod('transform', args);
          }
      };
      return CompilePipe;
  }());
  /**
   * @param {?} view
   * @param {?} name
   * @return {?}
   */
  function _findPipeMeta(view, name) {
      var /** @type {?} */ pipeMeta = null;
      for (var /** @type {?} */ i = view.pipeMetas.length - 1; i >= 0; i--) {
          var /** @type {?} */ localPipeMeta = view.pipeMetas[i];
          if (localPipeMeta.name == name) {
              pipeMeta = localPipeMeta;
              break;
          }
      }
      if (!pipeMeta) {
          throw new Error("Illegal state: Could not find pipe " + name + " although the parser should have detected this error!");
      }
      return pipeMeta;
  }

  var CompileViewRootNodeType = {};
  CompileViewRootNodeType.Node = 0;
  CompileViewRootNodeType.ViewContainer = 1;
  CompileViewRootNodeType.NgContent = 2;
  CompileViewRootNodeType[CompileViewRootNodeType.Node] = "Node";
  CompileViewRootNodeType[CompileViewRootNodeType.ViewContainer] = "ViewContainer";
  CompileViewRootNodeType[CompileViewRootNodeType.NgContent] = "NgContent";
  var CompileViewRootNode = (function () {
      /**
       * @param {?} type
       * @param {?} expr
       * @param {?=} ngContentIndex
       */
      function CompileViewRootNode(type, expr, ngContentIndex) {
          this.type = type;
          this.expr = expr;
          this.ngContentIndex = ngContentIndex;
      }
      return CompileViewRootNode;
  }());
  var CompileView = (function () {
      /**
       * @param {?} component
       * @param {?} genConfig
       * @param {?} pipeMetas
       * @param {?} styles
       * @param {?} animations
       * @param {?} viewIndex
       * @param {?} declarationElement
       * @param {?} templateVariableBindings
       */
      function CompileView(component, genConfig, pipeMetas, styles, animations, viewIndex, declarationElement, templateVariableBindings) {
          var _this = this;
          this.component = component;
          this.genConfig = genConfig;
          this.pipeMetas = pipeMetas;
          this.styles = styles;
          this.animations = animations;
          this.viewIndex = viewIndex;
          this.declarationElement = declarationElement;
          this.templateVariableBindings = templateVariableBindings;
          this.viewChildren = [];
          this.nodes = [];
          this.rootNodes = [];
          this.lastRenderNode = NULL_EXPR;
          this.viewContainers = [];
          this.methods = [];
          this.ctorStmts = [];
          this.fields = [];
          this.getters = [];
          this.disposables = [];
          this.purePipes = new Map();
          this.pipes = [];
          this.locals = new Map();
          this.literalArrayCount = 0;
          this.literalMapCount = 0;
          this.pipeCount = 0;
          this.createMethod = new CompileMethod(this);
          this.animationBindingsMethod = new CompileMethod(this);
          this.injectorGetMethod = new CompileMethod(this);
          this.updateContentQueriesMethod = new CompileMethod(this);
          this.dirtyParentQueriesMethod = new CompileMethod(this);
          this.updateViewQueriesMethod = new CompileMethod(this);
          this.detectChangesInInputsMethod = new CompileMethod(this);
          this.detectChangesRenderPropertiesMethod = new CompileMethod(this);
          this.afterContentLifecycleCallbacksMethod = new CompileMethod(this);
          this.afterViewLifecycleCallbacksMethod = new CompileMethod(this);
          this.destroyMethod = new CompileMethod(this);
          this.detachMethod = new CompileMethod(this);
          this.viewType = getViewType(component, viewIndex);
          this.className = getViewClassName(component, viewIndex);
          this.classType = importType(new CompileIdentifierMetadata({ name: this.className }));
          this.classExpr = variable(this.className);
          if (this.viewType === ViewType.COMPONENT || this.viewType === ViewType.HOST) {
              this.componentView = this;
          }
          else {
              this.componentView = this.declarationElement.view.componentView;
          }
          this.componentContext =
              getPropertyInView(THIS_EXPR.prop('context'), this, this.componentView);
          var viewQueries = new Map();
          if (this.viewType === ViewType.COMPONENT) {
              var directiveInstance_1 = THIS_EXPR.prop('context');
              this.component.viewQueries.forEach(function (queryMeta, queryIndex) {
                  var propName = "_viewQuery_" + queryMeta.selectors[0].name + "_" + queryIndex;
                  var queryList = createQueryList(queryMeta, directiveInstance_1, propName, _this);
                  var query = new CompileQuery(queryMeta, queryList, directiveInstance_1, _this);
                  addQueryToTokenMap(viewQueries, query);
              });
          }
          this.viewQueries = viewQueries;
          templateVariableBindings.forEach(function (entry) { _this.locals.set(entry[1], THIS_EXPR.prop('context').prop(entry[0])); });
          if (!this.declarationElement.isNull()) {
              this.declarationElement.setEmbeddedView(this);
          }
      }
      /**
       * @param {?} name
       * @param {?} input
       * @param {?} args
       * @return {?}
       */
      CompileView.prototype.callPipe = function (name, input, args) {
          return CompilePipe.call(this, name, [input].concat(args));
      };
      /**
       * @param {?} name
       * @return {?}
       */
      CompileView.prototype.getLocal = function (name) {
          if (name == EventHandlerVars.event.name) {
              return EventHandlerVars.event;
          }
          var /** @type {?} */ currView = this;
          var /** @type {?} */ result = currView.locals.get(name);
          while (!result && isPresent(currView.declarationElement.view)) {
              currView = currView.declarationElement.view;
              result = currView.locals.get(name);
          }
          if (isPresent(result)) {
              return getPropertyInView(result, this, currView);
          }
          else {
              return null;
          }
      };
      /**
       * @return {?}
       */
      CompileView.prototype.afterNodes = function () {
          var _this = this;
          Array.from(this.viewQueries.values())
              .forEach(function (queries) { return queries.forEach(function (q) { return q.afterChildren(_this.createMethod, _this.updateViewQueriesMethod); }); });
      };
      return CompileView;
  }());
  /**
   * @param {?} component
   * @param {?} embeddedTemplateIndex
   * @return {?}
   */
  function getViewType(component, embeddedTemplateIndex) {
      if (embeddedTemplateIndex > 0) {
          return ViewType.EMBEDDED;
      }
      if (component.type.isHost) {
          return ViewType.HOST;
      }
      return ViewType.COMPONENT;
  }

  /**
   * @param {?} boundEvents
   * @param {?} directives
   * @param {?} compileElement
   * @param {?} bindToRenderer
   * @return {?}
   */
  function bindOutputs(boundEvents, directives, compileElement, bindToRenderer) {
      var /** @type {?} */ usedEvents = collectEvents(boundEvents, directives);
      if (!usedEvents.size) {
          return false;
      }
      if (bindToRenderer) {
          subscribeToRenderEvents(usedEvents, compileElement);
      }
      subscribeToDirectiveEvents(usedEvents, directives, compileElement);
      generateHandleEventMethod(boundEvents, directives, compileElement);
      return true;
  }
  /**
   * @param {?} boundEvents
   * @param {?} directives
   * @return {?}
   */
  function collectEvents(boundEvents, directives) {
      var /** @type {?} */ usedEvents = new Map();
      boundEvents.forEach(function (event) { usedEvents.set(event.fullName, event); });
      directives.forEach(function (dirAst) {
          dirAst.hostEvents.forEach(function (event) { usedEvents.set(event.fullName, event); });
      });
      return usedEvents;
  }
  /**
   * @param {?} usedEvents
   * @param {?} compileElement
   * @return {?}
   */
  function subscribeToRenderEvents(usedEvents, compileElement) {
      var /** @type {?} */ eventAndTargetExprs = [];
      usedEvents.forEach(function (event) {
          if (!event.phase) {
              eventAndTargetExprs.push(literal(event.name), literal(event.target));
          }
      });
      if (eventAndTargetExprs.length) {
          var /** @type {?} */ disposableVar = variable("disposable_" + compileElement.view.disposables.length);
          compileElement.view.disposables.push(disposableVar);
          compileElement.view.createMethod.addStmt(disposableVar
              .set(importExpr(resolveIdentifier(Identifiers.subscribeToRenderElement)).callFn([
              THIS_EXPR, compileElement.renderNode, createInlineArray(eventAndTargetExprs),
              handleEventExpr(compileElement)
          ]))
              .toDeclStmt(FUNCTION_TYPE, [StmtModifier.Private]));
      }
  }
  /**
   * @param {?} usedEvents
   * @param {?} directives
   * @param {?} compileElement
   * @return {?}
   */
  function subscribeToDirectiveEvents(usedEvents, directives, compileElement) {
      var /** @type {?} */ usedEventNames = Array.from(usedEvents.keys());
      directives.forEach(function (dirAst) {
          var /** @type {?} */ dirWrapper = compileElement.directiveWrapperInstance.get(dirAst.directive.type.reference);
          compileElement.view.createMethod.addStmts(DirectiveWrapperExpressions.subscribe(dirAst.directive, dirAst.hostProperties, usedEventNames, dirWrapper, THIS_EXPR, handleEventExpr(compileElement)));
      });
  }
  /**
   * @param {?} boundEvents
   * @param {?} directives
   * @param {?} compileElement
   * @return {?}
   */
  function generateHandleEventMethod(boundEvents, directives, compileElement) {
      var /** @type {?} */ hasComponentHostListener = directives.some(function (dirAst) { return dirAst.hostEvents.some(function (event) { return dirAst.directive.isComponent; }); });
      var /** @type {?} */ markPathToRootStart = hasComponentHostListener ? compileElement.compViewExpr : THIS_EXPR;
      var /** @type {?} */ handleEventStmts = new CompileMethod(compileElement.view);
      handleEventStmts.resetDebugInfo(compileElement.nodeIndex, compileElement.sourceAst);
      handleEventStmts.push(markPathToRootStart.callMethod('markPathToRootAsCheckOnce', []).toStmt());
      var /** @type {?} */ eventNameVar = variable('eventName');
      var /** @type {?} */ resultVar = variable('result');
      handleEventStmts.push(resultVar.set(literal(true)).toDeclStmt(BOOL_TYPE));
      directives.forEach(function (dirAst, dirIdx) {
          var /** @type {?} */ dirWrapper = compileElement.directiveWrapperInstance.get(dirAst.directive.type.reference);
          if (dirAst.hostEvents.length > 0) {
              handleEventStmts.push(resultVar
                  .set(DirectiveWrapperExpressions
                  .handleEvent(dirAst.hostEvents, dirWrapper, eventNameVar, EventHandlerVars.event)
                  .and(resultVar))
                  .toStmt());
          }
      });
      boundEvents.forEach(function (renderEvent, renderEventIdx) {
          var /** @type {?} */ evalResult = convertActionBinding(compileElement.view, compileElement.view, compileElement.view.componentContext, renderEvent.handler, "sub_" + renderEventIdx);
          var /** @type {?} */ trueStmts = evalResult.stmts;
          if (evalResult.preventDefault) {
              trueStmts.push(resultVar.set(evalResult.preventDefault.and(resultVar)).toStmt());
          }
          // TODO(tbosch): convert this into a `switch` once our OutputAst supports it.
          handleEventStmts.push(new IfStmt(eventNameVar.equals(literal(renderEvent.fullName)), trueStmts));
      });
      handleEventStmts.push(new ReturnStatement(resultVar));
      compileElement.view.methods.push(new ClassMethod(getHandleEventMethodName(compileElement.nodeIndex), [
          new FnParam(eventNameVar.name, STRING_TYPE),
          new FnParam(EventHandlerVars.event.name, DYNAMIC_TYPE)
      ], handleEventStmts.finish(), BOOL_TYPE));
  }
  /**
   * @param {?} compileElement
   * @return {?}
   */
  function handleEventExpr(compileElement) {
      var /** @type {?} */ handleEventMethodName = getHandleEventMethodName(compileElement.nodeIndex);
      return THIS_EXPR.callMethod('eventHandler', [THIS_EXPR.prop(handleEventMethodName)]);
  }

  var /** @type {?} */ STATE_IS_NEVER_CHECKED = THIS_EXPR.prop('numberOfChecks').identical(new LiteralExpr(0));
  var /** @type {?} */ NOT_THROW_ON_CHANGES = not(DetectChangesVars.throwOnChange);
  /**
   * @param {?} directiveMeta
   * @param {?} directiveInstance
   * @param {?} compileElement
   * @return {?}
   */
  function bindDirectiveAfterContentLifecycleCallbacks(directiveMeta, directiveInstance, compileElement) {
      var /** @type {?} */ view = compileElement.view;
      var /** @type {?} */ lifecycleHooks = directiveMeta.type.lifecycleHooks;
      var /** @type {?} */ afterContentLifecycleCallbacksMethod = view.afterContentLifecycleCallbacksMethod;
      afterContentLifecycleCallbacksMethod.resetDebugInfo(compileElement.nodeIndex, compileElement.sourceAst);
      if (lifecycleHooks.indexOf(LifecycleHooks.AfterContentInit) !== -1) {
          afterContentLifecycleCallbacksMethod.addStmt(new IfStmt(STATE_IS_NEVER_CHECKED, [directiveInstance.callMethod('ngAfterContentInit', []).toStmt()]));
      }
      if (lifecycleHooks.indexOf(LifecycleHooks.AfterContentChecked) !== -1) {
          afterContentLifecycleCallbacksMethod.addStmt(directiveInstance.callMethod('ngAfterContentChecked', []).toStmt());
      }
  }
  /**
   * @param {?} directiveMeta
   * @param {?} directiveInstance
   * @param {?} compileElement
   * @return {?}
   */
  function bindDirectiveAfterViewLifecycleCallbacks(directiveMeta, directiveInstance, compileElement) {
      var /** @type {?} */ view = compileElement.view;
      var /** @type {?} */ lifecycleHooks = directiveMeta.type.lifecycleHooks;
      var /** @type {?} */ afterViewLifecycleCallbacksMethod = view.afterViewLifecycleCallbacksMethod;
      afterViewLifecycleCallbacksMethod.resetDebugInfo(compileElement.nodeIndex, compileElement.sourceAst);
      if (lifecycleHooks.indexOf(LifecycleHooks.AfterViewInit) !== -1) {
          afterViewLifecycleCallbacksMethod.addStmt(new IfStmt(STATE_IS_NEVER_CHECKED, [directiveInstance.callMethod('ngAfterViewInit', []).toStmt()]));
      }
      if (lifecycleHooks.indexOf(LifecycleHooks.AfterViewChecked) !== -1) {
          afterViewLifecycleCallbacksMethod.addStmt(directiveInstance.callMethod('ngAfterViewChecked', []).toStmt());
      }
  }
  /**
   * @param {?} dir
   * @param {?} directiveWrapperIntance
   * @param {?} compileElement
   * @return {?}
   */
  function bindDirectiveWrapperLifecycleCallbacks(dir, directiveWrapperIntance, compileElement) {
      compileElement.view.destroyMethod.addStmts(DirectiveWrapperExpressions.ngOnDestroy(dir.directive, directiveWrapperIntance));
      compileElement.view.detachMethod.addStmts(DirectiveWrapperExpressions.ngOnDetach(dir.hostProperties, directiveWrapperIntance, THIS_EXPR, compileElement.compViewExpr || THIS_EXPR, compileElement.renderNode));
  }
  /**
   * @param {?} provider
   * @param {?} providerInstance
   * @param {?} compileElement
   * @return {?}
   */
  function bindInjectableDestroyLifecycleCallbacks(provider, providerInstance, compileElement) {
      var /** @type {?} */ onDestroyMethod = compileElement.view.destroyMethod;
      onDestroyMethod.resetDebugInfo(compileElement.nodeIndex, compileElement.sourceAst);
      if (provider.providerType !== ProviderAstType.Directive &&
          provider.providerType !== ProviderAstType.Component &&
          provider.lifecycleHooks.indexOf(LifecycleHooks.OnDestroy) !== -1) {
          onDestroyMethod.addStmt(providerInstance.callMethod('ngOnDestroy', []).toStmt());
      }
  }
  /**
   * @param {?} pipeMeta
   * @param {?} pipeInstance
   * @param {?} view
   * @return {?}
   */
  function bindPipeDestroyLifecycleCallbacks(pipeMeta, pipeInstance, view) {
      var /** @type {?} */ onDestroyMethod = view.destroyMethod;
      if (pipeMeta.type.lifecycleHooks.indexOf(LifecycleHooks.OnDestroy) !== -1) {
          onDestroyMethod.addStmt(pipeInstance.callMethod('ngOnDestroy', []).toStmt());
      }
  }

  /**
   * @param {?} boundText
   * @param {?} compileNode
   * @param {?} view
   * @return {?}
   */
  function bindRenderText(boundText, compileNode, view) {
      var /** @type {?} */ valueField = createCheckBindingField(view);
      var /** @type {?} */ evalResult = convertPropertyBinding(view, view, view.componentContext, boundText.value, valueField.bindingId);
      if (!evalResult) {
          return null;
      }
      view.detectChangesRenderPropertiesMethod.resetDebugInfo(compileNode.nodeIndex, boundText);
      view.detectChangesRenderPropertiesMethod.addStmts(createCheckBindingStmt(evalResult, valueField.expression, DetectChangesVars.throwOnChange, [THIS_EXPR.prop('renderer')
              .callMethod('setText', [compileNode.renderNode, evalResult.currValExpr])
              .toStmt()]));
  }
  /**
   * @param {?} boundProps
   * @param {?} hasEvents
   * @param {?} compileElement
   * @return {?}
   */
  function bindRenderInputs(boundProps, hasEvents, compileElement) {
      var /** @type {?} */ view = compileElement.view;
      var /** @type {?} */ renderNode = compileElement.renderNode;
      boundProps.forEach(function (boundProp) {
          var /** @type {?} */ bindingField = createCheckBindingField(view);
          view.detectChangesRenderPropertiesMethod.resetDebugInfo(compileElement.nodeIndex, boundProp);
          var /** @type {?} */ evalResult = convertPropertyBinding(view, view, compileElement.view.componentContext, boundProp.value, bindingField.bindingId);
          if (!evalResult) {
              return;
          }
          var /** @type {?} */ checkBindingStmts = [];
          var /** @type {?} */ compileMethod = view.detectChangesRenderPropertiesMethod;
          switch (boundProp.type) {
              case PropertyBindingType.Property:
              case PropertyBindingType.Attribute:
              case PropertyBindingType.Class:
              case PropertyBindingType.Style:
                  checkBindingStmts.push.apply(checkBindingStmts, writeToRenderer(THIS_EXPR, boundProp, renderNode, evalResult.currValExpr, view.genConfig.logBindingUpdate));
                  break;
              case PropertyBindingType.Animation:
                  compileMethod = view.animationBindingsMethod;
                  var _a = triggerAnimation(THIS_EXPR, THIS_EXPR, boundProp, (hasEvents ? THIS_EXPR.prop(getHandleEventMethodName(compileElement.nodeIndex)) :
                      importExpr(resolveIdentifier(Identifiers.noop)))
                      .callMethod(BuiltinMethod.Bind, [THIS_EXPR]), compileElement.renderNode, evalResult.currValExpr, bindingField.expression), updateStmts = _a.updateStmts, detachStmts = _a.detachStmts;
                  checkBindingStmts.push.apply(checkBindingStmts, updateStmts);
                  view.detachMethod.addStmts(detachStmts);
                  break;
          }
          compileMethod.addStmts(createCheckBindingStmt(evalResult, bindingField.expression, DetectChangesVars.throwOnChange, checkBindingStmts));
      });
  }
  /**
   * @param {?} directiveAst
   * @param {?} directiveWrapperInstance
   * @param {?} compileElement
   * @param {?} elementName
   * @param {?} schemaRegistry
   * @return {?}
   */
  function bindDirectiveHostProps(directiveAst, directiveWrapperInstance, compileElement, elementName, schemaRegistry) {
      // We need to provide the SecurityContext for properties that could need sanitization.
      var /** @type {?} */ runtimeSecurityCtxExprs = directiveAst.hostProperties.filter(function (boundProp) { return boundProp.needsRuntimeSecurityContext; })
          .map(function (boundProp) {
          var /** @type {?} */ ctx;
          switch (boundProp.type) {
              case PropertyBindingType.Property:
                  ctx = schemaRegistry.securityContext(elementName, boundProp.name, false);
                  break;
              case PropertyBindingType.Attribute:
                  ctx = schemaRegistry.securityContext(elementName, boundProp.name, true);
                  break;
              default:
                  throw new Error("Illegal state: Only property / attribute bindings can have an unknown security context! Binding " + boundProp.name);
          }
          return createEnumExpression(Identifiers.SecurityContext, ctx);
      });
      compileElement.view.detectChangesRenderPropertiesMethod.addStmts(DirectiveWrapperExpressions.checkHost(directiveAst.hostProperties, directiveWrapperInstance, THIS_EXPR, compileElement.compViewExpr || THIS_EXPR, compileElement.renderNode, DetectChangesVars.throwOnChange, runtimeSecurityCtxExprs));
  }
  /**
   * @param {?} directiveAst
   * @param {?} directiveWrapperInstance
   * @param {?} dirIndex
   * @param {?} compileElement
   * @return {?}
   */
  function bindDirectiveInputs(directiveAst, directiveWrapperInstance, dirIndex, compileElement) {
      var /** @type {?} */ view = compileElement.view;
      var /** @type {?} */ detectChangesInInputsMethod = view.detectChangesInInputsMethod;
      detectChangesInInputsMethod.resetDebugInfo(compileElement.nodeIndex, compileElement.sourceAst);
      directiveAst.inputs.forEach(function (input, inputIdx) {
          // Note: We can't use `fields.length` here, as we are not adding a field!
          var /** @type {?} */ bindingId = compileElement.nodeIndex + "_" + dirIndex + "_" + inputIdx;
          detectChangesInInputsMethod.resetDebugInfo(compileElement.nodeIndex, input);
          var /** @type {?} */ evalResult = convertPropertyBinding(view, view, view.componentContext, input.value, bindingId);
          if (!evalResult) {
              return;
          }
          detectChangesInInputsMethod.addStmts(evalResult.stmts);
          detectChangesInInputsMethod.addStmt(directiveWrapperInstance
              .callMethod("check_" + input.directiveName, [
              evalResult.currValExpr, DetectChangesVars.throwOnChange,
              evalResult.forceUpdate || literal(false)
          ])
              .toStmt());
      });
      var /** @type {?} */ isOnPushComp = directiveAst.directive.isComponent &&
          !isDefaultChangeDetectionStrategy(directiveAst.directive.changeDetection);
      var /** @type {?} */ directiveDetectChangesExpr = DirectiveWrapperExpressions.ngDoCheck(directiveWrapperInstance, THIS_EXPR, compileElement.renderNode, DetectChangesVars.throwOnChange);
      var /** @type {?} */ directiveDetectChangesStmt = isOnPushComp ?
          new IfStmt(directiveDetectChangesExpr, [compileElement.compViewExpr.callMethod('markAsCheckOnce', []).toStmt()]) :
          directiveDetectChangesExpr.toStmt();
      detectChangesInInputsMethod.addStmt(directiveDetectChangesStmt);
  }

  /**
   * @param {?} view
   * @param {?} parsedTemplate
   * @param {?} schemaRegistry
   * @return {?}
   */
  function bindView(view, parsedTemplate, schemaRegistry) {
      var /** @type {?} */ visitor = new ViewBinderVisitor(view, schemaRegistry);
      templateVisitAll(visitor, parsedTemplate);
      view.pipes.forEach(function (pipe) { bindPipeDestroyLifecycleCallbacks(pipe.meta, pipe.instance, pipe.view); });
  }
  var ViewBinderVisitor = (function () {
      /**
       * @param {?} view
       * @param {?} _schemaRegistry
       */
      function ViewBinderVisitor(view, _schemaRegistry) {
          this.view = view;
          this._schemaRegistry = _schemaRegistry;
          this._nodeIndex = 0;
      }
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitBoundText = function (ast, parent) {
          var /** @type {?} */ node = this.view.nodes[this._nodeIndex++];
          bindRenderText(ast, node, this.view);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitText = function (ast, parent) {
          this._nodeIndex++;
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitNgContent = function (ast, parent) { return null; };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitElement = function (ast, parent) {
          var _this = this;
          var /** @type {?} */ compileElement = (this.view.nodes[this._nodeIndex++]);
          var /** @type {?} */ hasEvents = bindOutputs(ast.outputs, ast.directives, compileElement, true);
          bindRenderInputs(ast.inputs, hasEvents, compileElement);
          ast.directives.forEach(function (directiveAst, dirIndex) {
              var /** @type {?} */ directiveWrapperInstance = compileElement.directiveWrapperInstance.get(directiveAst.directive.type.reference);
              bindDirectiveInputs(directiveAst, directiveWrapperInstance, dirIndex, compileElement);
              bindDirectiveHostProps(directiveAst, directiveWrapperInstance, compileElement, ast.name, _this._schemaRegistry);
          });
          templateVisitAll(this, ast.children, compileElement);
          // afterContent and afterView lifecycles need to be called bottom up
          // so that children are notified before parents
          ast.directives.forEach(function (directiveAst) {
              var /** @type {?} */ directiveInstance = compileElement.instances.get(directiveAst.directive.type.reference);
              var /** @type {?} */ directiveWrapperInstance = compileElement.directiveWrapperInstance.get(directiveAst.directive.type.reference);
              bindDirectiveAfterContentLifecycleCallbacks(directiveAst.directive, directiveInstance, compileElement);
              bindDirectiveAfterViewLifecycleCallbacks(directiveAst.directive, directiveInstance, compileElement);
              bindDirectiveWrapperLifecycleCallbacks(directiveAst, directiveWrapperInstance, compileElement);
          });
          ast.providers.forEach(function (providerAst) {
              var /** @type {?} */ providerInstance = compileElement.instances.get(providerAst.token.reference);
              bindInjectableDestroyLifecycleCallbacks(providerAst, providerInstance, compileElement);
          });
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitEmbeddedTemplate = function (ast, parent) {
          var /** @type {?} */ compileElement = (this.view.nodes[this._nodeIndex++]);
          bindOutputs(ast.outputs, ast.directives, compileElement, false);
          ast.directives.forEach(function (directiveAst, dirIndex) {
              var /** @type {?} */ directiveInstance = compileElement.instances.get(directiveAst.directive.type.reference);
              var /** @type {?} */ directiveWrapperInstance = compileElement.directiveWrapperInstance.get(directiveAst.directive.type.reference);
              bindDirectiveInputs(directiveAst, directiveWrapperInstance, dirIndex, compileElement);
              bindDirectiveAfterContentLifecycleCallbacks(directiveAst.directive, directiveInstance, compileElement);
              bindDirectiveAfterViewLifecycleCallbacks(directiveAst.directive, directiveInstance, compileElement);
              bindDirectiveWrapperLifecycleCallbacks(directiveAst, directiveWrapperInstance, compileElement);
          });
          ast.providers.forEach(function (providerAst) {
              var /** @type {?} */ providerInstance = compileElement.instances.get(providerAst.token.reference);
              bindInjectableDestroyLifecycleCallbacks(providerAst, providerInstance, compileElement);
          });
          bindView(compileElement.embeddedView, ast.children, this._schemaRegistry);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitAttr = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitDirective = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} eventTargetAndNames
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitEvent = function (ast, eventTargetAndNames) {
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitReference = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitDirectiveProperty = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ViewBinderVisitor.prototype.visitElementProperty = function (ast, context) { return null; };
      return ViewBinderVisitor;
  }());

  var /** @type {?} */ IMPLICIT_TEMPLATE_VAR = '\$implicit';
  var /** @type {?} */ CLASS_ATTR$1 = 'class';
  var /** @type {?} */ STYLE_ATTR = 'style';
  var /** @type {?} */ NG_CONTAINER_TAG = 'ng-container';
  var /** @type {?} */ parentRenderNodeVar = variable('parentRenderNode');
  var /** @type {?} */ rootSelectorVar = variable('rootSelector');
  /**
   * @param {?} view
   * @param {?} template
   * @param {?} targetDependencies
   * @return {?}
   */
  function buildView(view, template, targetDependencies) {
      var /** @type {?} */ builderVisitor = new ViewBuilderVisitor(view, targetDependencies);
      var /** @type {?} */ parentEl = view.declarationElement.isNull() ? view.declarationElement : view.declarationElement.parent;
      templateVisitAll(builderVisitor, template, parentEl);
      if (view.viewType === ViewType.EMBEDDED || view.viewType === ViewType.HOST) {
          view.lastRenderNode = builderVisitor.getOrCreateLastRenderNode();
      }
      return builderVisitor.nestedViewCount;
  }
  /**
   * @param {?} view
   * @param {?} targetStatements
   * @return {?}
   */
  function finishView(view, targetStatements) {
      view.afterNodes();
      createViewTopLevelStmts(view, targetStatements);
      view.nodes.forEach(function (node) {
          if (node instanceof CompileElement && node.hasEmbeddedView) {
              finishView(node.embeddedView, targetStatements);
          }
      });
  }
  var ViewBuilderVisitor = (function () {
      /**
       * @param {?} view
       * @param {?} targetDependencies
       */
      function ViewBuilderVisitor(view, targetDependencies) {
          this.view = view;
          this.targetDependencies = targetDependencies;
          this.nestedViewCount = 0;
      }
      /**
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype._isRootNode = function (parent) { return parent.view !== this.view; };
      /**
       * @param {?} node
       * @return {?}
       */
      ViewBuilderVisitor.prototype._addRootNodeAndProject = function (node) {
          var /** @type {?} */ projectedNode = _getOuterContainerOrSelf(node);
          var /** @type {?} */ parent = projectedNode.parent;
          var /** @type {?} */ ngContentIndex = ((projectedNode.sourceAst)).ngContentIndex;
          var /** @type {?} */ viewContainer = (node instanceof CompileElement && node.hasViewContainer) ? node.viewContainer : null;
          if (this._isRootNode(parent)) {
              if (this.view.viewType !== ViewType.COMPONENT) {
                  this.view.rootNodes.push(new CompileViewRootNode(viewContainer ? CompileViewRootNodeType.ViewContainer : CompileViewRootNodeType.Node, viewContainer || node.renderNode));
              }
          }
          else if (isPresent(parent.component) && isPresent(ngContentIndex)) {
              parent.addContentNode(ngContentIndex, new CompileViewRootNode(viewContainer ? CompileViewRootNodeType.ViewContainer : CompileViewRootNodeType.Node, viewContainer || node.renderNode));
          }
      };
      /**
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype._getParentRenderNode = function (parent) {
          parent = _getOuterContainerParentOrSelf(parent);
          if (this._isRootNode(parent)) {
              if (this.view.viewType === ViewType.COMPONENT) {
                  return parentRenderNodeVar;
              }
              else {
                  // root node of an embedded/host view
                  return NULL_EXPR;
              }
          }
          else {
              return isPresent(parent.component) &&
                  parent.component.template.encapsulation !== _angular_core.ViewEncapsulation.Native ?
                  NULL_EXPR :
                  parent.renderNode;
          }
      };
      /**
       * @return {?}
       */
      ViewBuilderVisitor.prototype.getOrCreateLastRenderNode = function () {
          var /** @type {?} */ view = this.view;
          if (view.rootNodes.length === 0 ||
              view.rootNodes[view.rootNodes.length - 1].type !== CompileViewRootNodeType.Node) {
              var /** @type {?} */ fieldName = "_el_" + view.nodes.length;
              view.fields.push(new ClassField(fieldName, importType(view.genConfig.renderTypes.renderElement)));
              view.createMethod.addStmt(THIS_EXPR.prop(fieldName)
                  .set(ViewProperties.renderer.callMethod('createTemplateAnchor', [NULL_EXPR, NULL_EXPR]))
                  .toStmt());
              view.rootNodes.push(new CompileViewRootNode(CompileViewRootNodeType.Node, THIS_EXPR.prop(fieldName)));
          }
          return view.rootNodes[view.rootNodes.length - 1].expr;
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitBoundText = function (ast, parent) {
          return this._visitText(ast, '', parent);
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitText = function (ast, parent) {
          return this._visitText(ast, ast.value, parent);
      };
      /**
       * @param {?} ast
       * @param {?} value
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype._visitText = function (ast, value, parent) {
          var /** @type {?} */ fieldName = "_text_" + this.view.nodes.length;
          this.view.fields.push(new ClassField(fieldName, importType(this.view.genConfig.renderTypes.renderText)));
          var /** @type {?} */ renderNode = THIS_EXPR.prop(fieldName);
          var /** @type {?} */ compileNode = new CompileNode(parent, this.view, this.view.nodes.length, renderNode, ast);
          var /** @type {?} */ createRenderNode = THIS_EXPR.prop(fieldName)
              .set(ViewProperties.renderer.callMethod('createText', [
              this._getParentRenderNode(parent), literal(value),
              this.view.createMethod.resetDebugInfoExpr(this.view.nodes.length, ast)
          ]))
              .toStmt();
          this.view.nodes.push(compileNode);
          this.view.createMethod.addStmt(createRenderNode);
          this._addRootNodeAndProject(compileNode);
          return renderNode;
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitNgContent = function (ast, parent) {
          // the projected nodes originate from a different view, so we don't
          // have debug information for them...
          this.view.createMethod.resetDebugInfo(null, ast);
          var /** @type {?} */ parentRenderNode = this._getParentRenderNode(parent);
          if (parentRenderNode !== NULL_EXPR) {
              this.view.createMethod.addStmt(THIS_EXPR.callMethod('projectNodes', [parentRenderNode, literal(ast.index)])
                  .toStmt());
          }
          else if (this._isRootNode(parent)) {
              if (this.view.viewType !== ViewType.COMPONENT) {
                  // store root nodes only for embedded/host views
                  this.view.rootNodes.push(new CompileViewRootNode(CompileViewRootNodeType.NgContent, null, ast.index));
              }
          }
          else {
              if (isPresent(parent.component) && isPresent(ast.ngContentIndex)) {
                  parent.addContentNode(ast.ngContentIndex, new CompileViewRootNode(CompileViewRootNodeType.NgContent, null, ast.index));
              }
          }
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitElement = function (ast, parent) {
          var /** @type {?} */ nodeIndex = this.view.nodes.length;
          var /** @type {?} */ createRenderNodeExpr;
          var /** @type {?} */ debugContextExpr = this.view.createMethod.resetDebugInfoExpr(nodeIndex, ast);
          var /** @type {?} */ directives = ast.directives.map(function (directiveAst) { return directiveAst.directive; });
          var /** @type {?} */ component = directives.find(function (directive) { return directive.isComponent; });
          if (ast.name === NG_CONTAINER_TAG) {
              createRenderNodeExpr = ViewProperties.renderer.callMethod('createTemplateAnchor', [this._getParentRenderNode(parent), debugContextExpr]);
          }
          else {
              var /** @type {?} */ htmlAttrs = _readHtmlAttrs(ast.attrs);
              var /** @type {?} */ attrNameAndValues = createInlineArray(_mergeHtmlAndDirectiveAttrs(htmlAttrs, directives).map(function (v) { return literal(v); }));
              if (nodeIndex === 0 && this.view.viewType === ViewType.HOST) {
                  createRenderNodeExpr =
                      importExpr(resolveIdentifier(Identifiers.selectOrCreateRenderHostElement)).callFn([
                          ViewProperties.renderer, literal(ast.name), attrNameAndValues, rootSelectorVar,
                          debugContextExpr
                      ]);
              }
              else {
                  createRenderNodeExpr =
                      importExpr(resolveIdentifier(Identifiers.createRenderElement)).callFn([
                          ViewProperties.renderer, this._getParentRenderNode(parent), literal(ast.name),
                          attrNameAndValues, debugContextExpr
                      ]);
              }
          }
          var /** @type {?} */ fieldName = "_el_" + nodeIndex;
          this.view.fields.push(new ClassField(fieldName, importType(this.view.genConfig.renderTypes.renderElement)));
          this.view.createMethod.addStmt(THIS_EXPR.prop(fieldName).set(createRenderNodeExpr).toStmt());
          var /** @type {?} */ renderNode = THIS_EXPR.prop(fieldName);
          var /** @type {?} */ compileElement = new CompileElement(parent, this.view, nodeIndex, renderNode, ast, component, directives, ast.providers, ast.hasViewContainer, false, ast.references, this.targetDependencies);
          this.view.nodes.push(compileElement);
          var /** @type {?} */ compViewExpr = null;
          if (isPresent(component)) {
              var /** @type {?} */ nestedComponentIdentifier = new CompileIdentifierMetadata({ name: getViewClassName(component, 0) });
              this.targetDependencies.push(new ViewClassDependency(component.type, nestedComponentIdentifier));
              compViewExpr = THIS_EXPR.prop("compView_" + nodeIndex); // fix highlighting: `
              this.view.fields.push(new ClassField(compViewExpr.name, importType(resolveIdentifier(Identifiers.AppView), [importType(component.type)])));
              this.view.viewChildren.push(compViewExpr);
              compileElement.setComponentView(compViewExpr);
              this.view.createMethod.addStmt(compViewExpr
                  .set(importExpr(nestedComponentIdentifier).instantiate([
                  ViewProperties.viewUtils, THIS_EXPR, literal(nodeIndex), renderNode
              ]))
                  .toStmt());
          }
          compileElement.beforeChildren();
          this._addRootNodeAndProject(compileElement);
          templateVisitAll(this, ast.children, compileElement);
          compileElement.afterChildren(this.view.nodes.length - nodeIndex - 1);
          if (isPresent(compViewExpr)) {
              this.view.createMethod.addStmt(compViewExpr.callMethod('create', [compileElement.getComponent()]).toStmt());
          }
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} parent
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitEmbeddedTemplate = function (ast, parent) {
          var /** @type {?} */ nodeIndex = this.view.nodes.length;
          var /** @type {?} */ fieldName = "_anchor_" + nodeIndex;
          this.view.fields.push(new ClassField(fieldName, importType(this.view.genConfig.renderTypes.renderComment)));
          this.view.createMethod.addStmt(THIS_EXPR.prop(fieldName)
              .set(ViewProperties.renderer.callMethod('createTemplateAnchor', [
              this._getParentRenderNode(parent),
              this.view.createMethod.resetDebugInfoExpr(nodeIndex, ast)
          ]))
              .toStmt());
          var /** @type {?} */ renderNode = THIS_EXPR.prop(fieldName);
          var /** @type {?} */ templateVariableBindings = ast.variables.map(function (varAst) { return [varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR, varAst.name]; });
          var /** @type {?} */ directives = ast.directives.map(function (directiveAst) { return directiveAst.directive; });
          var /** @type {?} */ compileElement = new CompileElement(parent, this.view, nodeIndex, renderNode, ast, null, directives, ast.providers, ast.hasViewContainer, true, ast.references, this.targetDependencies);
          this.view.nodes.push(compileElement);
          this.nestedViewCount++;
          var /** @type {?} */ embeddedView = new CompileView(this.view.component, this.view.genConfig, this.view.pipeMetas, NULL_EXPR, this.view.animations, this.view.viewIndex + this.nestedViewCount, compileElement, templateVariableBindings);
          this.nestedViewCount += buildView(embeddedView, ast.children, this.targetDependencies);
          compileElement.beforeChildren();
          this._addRootNodeAndProject(compileElement);
          compileElement.afterChildren(0);
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitAttr = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitDirective = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} eventTargetAndNames
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitEvent = function (ast, eventTargetAndNames) {
          return null;
      };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitReference = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} ctx
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitDirectiveProperty = function (ast, context) { return null; };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      ViewBuilderVisitor.prototype.visitElementProperty = function (ast, context) { return null; };
      return ViewBuilderVisitor;
  }());
  /**
   *  Walks up the nodes while the direct parent is a container.
    * *
    * Returns the outer container or the node itself when it is not a direct child of a container.
    * *
   * @param {?} node
   * @return {?}
   */
  function _getOuterContainerOrSelf(node) {
      var /** @type {?} */ view = node.view;
      while (_isNgContainer(node.parent, view)) {
          node = node.parent;
      }
      return node;
  }
  /**
   *  Walks up the nodes while they are container and returns the first parent which is not.
    * *
    * Returns the parent of the outer container or the node itself when it is not a container.
    * *
   * @param {?} el
   * @return {?}
   */
  function _getOuterContainerParentOrSelf(el) {
      var /** @type {?} */ view = el.view;
      while (_isNgContainer(el, view)) {
          el = el.parent;
      }
      return el;
  }
  /**
   * @param {?} node
   * @param {?} view
   * @return {?}
   */
  function _isNgContainer(node, view) {
      return !node.isNull() && ((node.sourceAst)).name === NG_CONTAINER_TAG &&
          node.view === view;
  }
  /**
   * @param {?} declaredHtmlAttrs
   * @param {?} directives
   * @return {?}
   */
  function _mergeHtmlAndDirectiveAttrs(declaredHtmlAttrs, directives) {
      var /** @type {?} */ mapResult = {};
      Object.keys(declaredHtmlAttrs).forEach(function (key) { mapResult[key] = declaredHtmlAttrs[key]; });
      directives.forEach(function (directiveMeta) {
          Object.keys(directiveMeta.hostAttributes).forEach(function (name) {
              var /** @type {?} */ value = directiveMeta.hostAttributes[name];
              var /** @type {?} */ prevValue = mapResult[name];
              mapResult[name] = isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
          });
      });
      var /** @type {?} */ arrResult = [];
      // Note: We need to sort to get a defined output order
      // for tests and for caching generated artifacts...
      Object.keys(mapResult).sort().forEach(function (attrName) { arrResult.push(attrName, mapResult[attrName]); });
      return arrResult;
  }
  /**
   * @param {?} attrs
   * @return {?}
   */
  function _readHtmlAttrs(attrs) {
      var /** @type {?} */ htmlAttrs = {};
      attrs.forEach(function (ast) { htmlAttrs[ast.name] = ast.value; });
      return htmlAttrs;
  }
  /**
   * @param {?} attrName
   * @param {?} attrValue1
   * @param {?} attrValue2
   * @return {?}
   */
  function mergeAttributeValue(attrName, attrValue1, attrValue2) {
      if (attrName == CLASS_ATTR$1 || attrName == STYLE_ATTR) {
          return attrValue1 + " " + attrValue2;
      }
      else {
          return attrValue2;
      }
  }
  /**
   * @param {?} view
   * @param {?} targetStatements
   * @return {?}
   */
  function createViewTopLevelStmts(view, targetStatements) {
      var /** @type {?} */ nodeDebugInfosVar = NULL_EXPR;
      if (view.genConfig.genDebugInfo) {
          nodeDebugInfosVar = variable("nodeDebugInfos_" + view.component.type.name + view.viewIndex); // fix highlighting: `
          targetStatements.push(((nodeDebugInfosVar))
              .set(literalArr(view.nodes.map(createStaticNodeDebugInfo), new ArrayType(new ExternalType(resolveIdentifier(Identifiers.StaticNodeDebugInfo)), [TypeModifier.Const])))
              .toDeclStmt(null, [StmtModifier.Final]));
      }
      var /** @type {?} */ renderCompTypeVar = variable("renderType_" + view.component.type.name); // fix highlighting: `
      if (view.viewIndex === 0) {
          var /** @type {?} */ templateUrlInfo = void 0;
          if (view.component.template.templateUrl == view.component.type.moduleUrl) {
              templateUrlInfo =
                  view.component.type.moduleUrl + " class " + view.component.type.name + " - inline template";
          }
          else {
              templateUrlInfo = view.component.template.templateUrl;
          }
          targetStatements.push(renderCompTypeVar
              .set(importExpr(resolveIdentifier(Identifiers.createRenderComponentType)).callFn([
              view.genConfig.genDebugInfo ? literal(templateUrlInfo) : literal(''),
              literal(view.component.template.ngContentSelectors.length),
              ViewEncapsulationEnum.fromValue(view.component.template.encapsulation),
              view.styles,
              literalMap(view.animations.map(function (entry) { return [entry.name, entry.fnExp]; })),
          ]))
              .toDeclStmt(importType(resolveIdentifier(Identifiers.RenderComponentType))));
      }
      var /** @type {?} */ viewClass = createViewClass(view, renderCompTypeVar, nodeDebugInfosVar);
      targetStatements.push(viewClass);
  }
  /**
   * @param {?} node
   * @return {?}
   */
  function createStaticNodeDebugInfo(node) {
      var /** @type {?} */ compileElement = node instanceof CompileElement ? node : null;
      var /** @type {?} */ providerTokens = [];
      var /** @type {?} */ componentToken = NULL_EXPR;
      var /** @type {?} */ varTokenEntries = [];
      if (isPresent(compileElement)) {
          providerTokens = compileElement.getProviderTokens();
          if (isPresent(compileElement.component)) {
              componentToken = createDiTokenExpression(identifierToken(compileElement.component.type));
          }
          Object.keys(compileElement.referenceTokens).forEach(function (varName) {
              var /** @type {?} */ token = compileElement.referenceTokens[varName];
              varTokenEntries.push([varName, isPresent(token) ? createDiTokenExpression(token) : NULL_EXPR]);
          });
      }
      return importExpr(resolveIdentifier(Identifiers.StaticNodeDebugInfo))
          .instantiate([
          literalArr(providerTokens, new ArrayType(DYNAMIC_TYPE, [TypeModifier.Const])),
          componentToken,
          literalMap(varTokenEntries, new MapType(DYNAMIC_TYPE, [TypeModifier.Const]))
      ], importType(resolveIdentifier(Identifiers.StaticNodeDebugInfo), null, [TypeModifier.Const]));
  }
  /**
   * @param {?} view
   * @param {?} renderCompTypeVar
   * @param {?} nodeDebugInfosVar
   * @return {?}
   */
  function createViewClass(view, renderCompTypeVar, nodeDebugInfosVar) {
      var /** @type {?} */ viewConstructorArgs = [
          new FnParam(ViewConstructorVars.viewUtils.name, importType(resolveIdentifier(Identifiers.ViewUtils))),
          new FnParam(ViewConstructorVars.parentView.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
          new FnParam(ViewConstructorVars.parentIndex.name, NUMBER_TYPE),
          new FnParam(ViewConstructorVars.parentElement.name, DYNAMIC_TYPE)
      ];
      var /** @type {?} */ superConstructorArgs = [
          variable(view.className), renderCompTypeVar, ViewTypeEnum.fromValue(view.viewType),
          ViewConstructorVars.viewUtils, ViewConstructorVars.parentView, ViewConstructorVars.parentIndex,
          ViewConstructorVars.parentElement,
          ChangeDetectorStatusEnum.fromValue(getChangeDetectionMode(view))
      ];
      if (view.genConfig.genDebugInfo) {
          superConstructorArgs.push(nodeDebugInfosVar);
      }
      if (view.viewType === ViewType.EMBEDDED) {
          viewConstructorArgs.push(new FnParam('declaredViewContainer', importType(resolveIdentifier(Identifiers.ViewContainer))));
          superConstructorArgs.push(variable('declaredViewContainer'));
      }
      var /** @type {?} */ viewMethods = [
          new ClassMethod('createInternal', [new FnParam(rootSelectorVar.name, STRING_TYPE)], generateCreateMethod(view), importType(resolveIdentifier(Identifiers.ComponentRef), [DYNAMIC_TYPE])),
          new ClassMethod('injectorGetInternal', [
              new FnParam(InjectMethodVars$1.token.name, DYNAMIC_TYPE),
              // Note: Can't use o.INT_TYPE here as the method in AppView uses number
              new FnParam(InjectMethodVars$1.requestNodeIndex.name, NUMBER_TYPE),
              new FnParam(InjectMethodVars$1.notFoundResult.name, DYNAMIC_TYPE)
          ], addReturnValuefNotEmpty(view.injectorGetMethod.finish(), InjectMethodVars$1.notFoundResult), DYNAMIC_TYPE),
          new ClassMethod('detectChangesInternal', [new FnParam(DetectChangesVars.throwOnChange.name, BOOL_TYPE)], generateDetectChangesMethod(view)),
          new ClassMethod('dirtyParentQueriesInternal', [], view.dirtyParentQueriesMethod.finish()),
          new ClassMethod('destroyInternal', [], generateDestroyMethod(view)),
          new ClassMethod('detachInternal', [], view.detachMethod.finish()),
          generateVisitRootNodesMethod(view), generateVisitProjectableNodesMethod(view),
          generateCreateEmbeddedViewsMethod(view)
      ].filter(function (method) { return method.body.length > 0; });
      var /** @type {?} */ superClass = view.genConfig.genDebugInfo ? Identifiers.DebugAppView : Identifiers.AppView;
      var /** @type {?} */ viewClass = createClassStmt({
          name: view.className,
          parent: importExpr(resolveIdentifier(superClass), [getContextType(view)]),
          parentArgs: superConstructorArgs,
          ctorParams: viewConstructorArgs,
          builders: [{ methods: viewMethods }, view]
      });
      return viewClass;
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function generateDestroyMethod(view) {
      var /** @type {?} */ stmts = [];
      view.viewContainers.forEach(function (viewContainer) {
          stmts.push(viewContainer.callMethod('destroyNestedViews', []).toStmt());
      });
      view.viewChildren.forEach(function (viewChild) { stmts.push(viewChild.callMethod('destroy', []).toStmt()); });
      stmts.push.apply(stmts, view.destroyMethod.finish());
      return stmts;
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function generateCreateMethod(view) {
      var /** @type {?} */ parentRenderNodeExpr = NULL_EXPR;
      var /** @type {?} */ parentRenderNodeStmts = [];
      if (view.viewType === ViewType.COMPONENT) {
          parentRenderNodeExpr =
              ViewProperties.renderer.callMethod('createViewRoot', [THIS_EXPR.prop('parentElement')]);
          parentRenderNodeStmts =
              [parentRenderNodeVar.set(parentRenderNodeExpr)
                      .toDeclStmt(importType(view.genConfig.renderTypes.renderNode), [StmtModifier.Final])];
      }
      var /** @type {?} */ resultExpr;
      if (view.viewType === ViewType.HOST) {
          var /** @type {?} */ hostEl = (view.nodes[0]);
          resultExpr =
              importExpr(resolveIdentifier(Identifiers.ComponentRef_), [DYNAMIC_TYPE]).instantiate([
                  literal(hostEl.nodeIndex), THIS_EXPR, hostEl.renderNode, hostEl.getComponent()
              ]);
      }
      else {
          resultExpr = NULL_EXPR;
      }
      var /** @type {?} */ allNodesExpr = ViewProperties.renderer.cast(DYNAMIC_TYPE)
          .prop('directRenderer')
          .conditional(NULL_EXPR, literalArr(view.nodes.map(function (node) { return node.renderNode; })));
      return parentRenderNodeStmts.concat(view.createMethod.finish(), [
          THIS_EXPR
              .callMethod('init', [
              view.lastRenderNode,
              allNodesExpr,
              view.disposables.length ? literalArr(view.disposables) : NULL_EXPR,
          ])
              .toStmt(),
          new ReturnStatement(resultExpr)
      ]);
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function generateDetectChangesMethod(view) {
      var /** @type {?} */ stmts = [];
      if (view.animationBindingsMethod.isEmpty() && view.detectChangesInInputsMethod.isEmpty() &&
          view.updateContentQueriesMethod.isEmpty() &&
          view.afterContentLifecycleCallbacksMethod.isEmpty() &&
          view.detectChangesRenderPropertiesMethod.isEmpty() &&
          view.updateViewQueriesMethod.isEmpty() && view.afterViewLifecycleCallbacksMethod.isEmpty() &&
          view.viewContainers.length === 0 && view.viewChildren.length === 0) {
          return stmts;
      }
      stmts.push.apply(stmts, view.animationBindingsMethod.finish());
      stmts.push.apply(stmts, view.detectChangesInInputsMethod.finish());
      view.viewContainers.forEach(function (viewContainer) {
          stmts.push(viewContainer.callMethod('detectChangesInNestedViews', [DetectChangesVars.throwOnChange])
              .toStmt());
      });
      var /** @type {?} */ afterContentStmts = view.updateContentQueriesMethod.finish().concat(view.afterContentLifecycleCallbacksMethod.finish());
      if (afterContentStmts.length > 0) {
          stmts.push(new IfStmt(not(DetectChangesVars.throwOnChange), afterContentStmts));
      }
      stmts.push.apply(stmts, view.detectChangesRenderPropertiesMethod.finish());
      view.viewChildren.forEach(function (viewChild) {
          stmts.push(viewChild.callMethod('detectChanges', [DetectChangesVars.throwOnChange]).toStmt());
      });
      var /** @type {?} */ afterViewStmts = view.updateViewQueriesMethod.finish().concat(view.afterViewLifecycleCallbacksMethod.finish());
      if (afterViewStmts.length > 0) {
          stmts.push(new IfStmt(not(DetectChangesVars.throwOnChange), afterViewStmts));
      }
      var /** @type {?} */ varStmts = [];
      var /** @type {?} */ readVars = findReadVarNames(stmts);
      if (readVars.has(DetectChangesVars.changed.name)) {
          varStmts.push(DetectChangesVars.changed.set(literal(true)).toDeclStmt(BOOL_TYPE));
      }
      if (readVars.has(DetectChangesVars.changes.name)) {
          varStmts.push(DetectChangesVars.changes.set(NULL_EXPR)
              .toDeclStmt(new MapType(importType(resolveIdentifier(Identifiers.SimpleChange)))));
      }
      varStmts.push.apply(varStmts, createSharedBindingVariablesIfNeeded(stmts));
      return varStmts.concat(stmts);
  }
  /**
   * @param {?} statements
   * @param {?} value
   * @return {?}
   */
  function addReturnValuefNotEmpty(statements, value) {
      if (statements.length > 0) {
          return statements.concat([new ReturnStatement(value)]);
      }
      else {
          return statements;
      }
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function getContextType(view) {
      if (view.viewType === ViewType.COMPONENT) {
          return importType(view.component.type);
      }
      return DYNAMIC_TYPE;
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function getChangeDetectionMode(view) {
      var /** @type {?} */ mode;
      if (view.viewType === ViewType.COMPONENT) {
          mode = isDefaultChangeDetectionStrategy(view.component.changeDetection) ?
              ChangeDetectorStatus.CheckAlways :
              ChangeDetectorStatus.CheckOnce;
      }
      else {
          mode = ChangeDetectorStatus.CheckAlways;
      }
      return mode;
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function generateVisitRootNodesMethod(view) {
      var /** @type {?} */ cbVar = variable('cb');
      var /** @type {?} */ ctxVar = variable('ctx');
      var /** @type {?} */ stmts = generateVisitNodesStmts(view.rootNodes, cbVar, ctxVar);
      return new ClassMethod('visitRootNodesInternal', [new FnParam(cbVar.name, DYNAMIC_TYPE), new FnParam(ctxVar.name, DYNAMIC_TYPE)], stmts);
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function generateVisitProjectableNodesMethod(view) {
      var /** @type {?} */ nodeIndexVar = variable('nodeIndex');
      var /** @type {?} */ ngContentIndexVar = variable('ngContentIndex');
      var /** @type {?} */ cbVar = variable('cb');
      var /** @type {?} */ ctxVar = variable('ctx');
      var /** @type {?} */ stmts = [];
      view.nodes.forEach(function (node) {
          if (node instanceof CompileElement && node.component) {
              node.contentNodesByNgContentIndex.forEach(function (projectedNodes, ngContentIndex) {
                  stmts.push(new IfStmt(nodeIndexVar.equals(literal(node.nodeIndex))
                      .and(ngContentIndexVar.equals(literal(ngContentIndex))), generateVisitNodesStmts(projectedNodes, cbVar, ctxVar)));
              });
          }
      });
      return new ClassMethod('visitProjectableNodesInternal', [
          new FnParam(nodeIndexVar.name, NUMBER_TYPE),
          new FnParam(ngContentIndexVar.name, NUMBER_TYPE),
          new FnParam(cbVar.name, DYNAMIC_TYPE), new FnParam(ctxVar.name, DYNAMIC_TYPE)
      ], stmts);
  }
  /**
   * @param {?} nodes
   * @param {?} cb
   * @param {?} ctx
   * @return {?}
   */
  function generateVisitNodesStmts(nodes, cb, ctx) {
      var /** @type {?} */ stmts = [];
      nodes.forEach(function (node) {
          switch (node.type) {
              case CompileViewRootNodeType.Node:
                  stmts.push(cb.callFn([node.expr, ctx]).toStmt());
                  break;
              case CompileViewRootNodeType.ViewContainer:
                  stmts.push(cb.callFn([node.expr.prop('nativeElement'), ctx]).toStmt());
                  stmts.push(node.expr.callMethod('visitNestedViewRootNodes', [cb, ctx]).toStmt());
                  break;
              case CompileViewRootNodeType.NgContent:
                  stmts.push(THIS_EXPR.callMethod('visitProjectedNodes', [literal(node.ngContentIndex), cb, ctx])
                      .toStmt());
                  break;
          }
      });
      return stmts;
  }
  /**
   * @param {?} view
   * @return {?}
   */
  function generateCreateEmbeddedViewsMethod(view) {
      var /** @type {?} */ nodeIndexVar = variable('nodeIndex');
      var /** @type {?} */ stmts = [];
      view.nodes.forEach(function (node) {
          if (node instanceof CompileElement) {
              if (node.embeddedView) {
                  var /** @type {?} */ parentNodeIndex = node.isRootElement() ? null : node.parent.nodeIndex;
                  stmts.push(new IfStmt(nodeIndexVar.equals(literal(node.nodeIndex)), [new ReturnStatement(node.embeddedView.classExpr.instantiate([
                          ViewProperties.viewUtils, THIS_EXPR, literal(node.nodeIndex), node.renderNode,
                          node.viewContainer
                      ]))]));
              }
          }
      });
      if (stmts.length > 0) {
          stmts.push(new ReturnStatement(NULL_EXPR));
      }
      return new ClassMethod('createEmbeddedViewInternal', [new FnParam(nodeIndexVar.name, NUMBER_TYPE)], stmts, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE]));
  }

  var ViewCompileResult = (function () {
      /**
       * @param {?} statements
       * @param {?} viewClassVar
       * @param {?} dependencies
       */
      function ViewCompileResult(statements, viewClassVar, dependencies) {
          this.statements = statements;
          this.viewClassVar = viewClassVar;
          this.dependencies = dependencies;
      }
      return ViewCompileResult;
  }());
  var ViewCompiler = (function () {
      /**
       * @param {?} _genConfig
       * @param {?} _schemaRegistry
       */
      function ViewCompiler(_genConfig, _schemaRegistry) {
          this._genConfig = _genConfig;
          this._schemaRegistry = _schemaRegistry;
      }
      /**
       * @param {?} component
       * @param {?} template
       * @param {?} styles
       * @param {?} pipes
       * @param {?} compiledAnimations
       * @return {?}
       */
      ViewCompiler.prototype.compileComponent = function (component, template, styles, pipes, compiledAnimations) {
          var /** @type {?} */ dependencies = [];
          var /** @type {?} */ view = new CompileView(component, this._genConfig, pipes, styles, compiledAnimations, 0, CompileElement.createNull(), []);
          var /** @type {?} */ statements = [];
          buildView(view, template, dependencies);
          // Need to separate binding from creation to be able to refer to
          // variables that have been declared after usage.
          bindView(view, template, this._schemaRegistry);
          finishView(view, statements);
          return new ViewCompileResult(statements, view.classExpr.name, dependencies);
      };
      ViewCompiler.decorators = [
          { type: _angular_core.Injectable },
      ];
      /** @nocollapse */
      ViewCompiler.ctorParameters = function () { return [
          { type: CompilerConfig, },
          { type: ElementSchemaRegistry, },
      ]; };
      return ViewCompiler;
  }());

  var AnimationEntryCompileResult = (function () {
      /**
       * @param {?} name
       * @param {?} statements
       * @param {?} fnExp
       */
      function AnimationEntryCompileResult(name, statements, fnExp) {
          this.name = name;
          this.statements = statements;
          this.fnExp = fnExp;
      }
      return AnimationEntryCompileResult;
  }());
  var AnimationCompiler = (function () {
      function AnimationCompiler() {
      }
      /**
       * @param {?} factoryNamePrefix
       * @param {?} parsedAnimations
       * @return {?}
       */
      AnimationCompiler.prototype.compile = function (factoryNamePrefix, parsedAnimations) {
          return parsedAnimations.map(function (entry) {
              var /** @type {?} */ factoryName = factoryNamePrefix + "_" + entry.name;
              var /** @type {?} */ visitor = new _AnimationBuilder(entry.name, factoryName);
              return visitor.build(entry);
          });
      };
      return AnimationCompiler;
  }());
  var /** @type {?} */ _ANIMATION_FACTORY_ELEMENT_VAR = variable('element');
  var /** @type {?} */ _ANIMATION_DEFAULT_STATE_VAR = variable('defaultStateStyles');
  var /** @type {?} */ _ANIMATION_FACTORY_VIEW_VAR = variable('view');
  var /** @type {?} */ _ANIMATION_FACTORY_VIEW_CONTEXT = _ANIMATION_FACTORY_VIEW_VAR.prop('animationContext');
  var /** @type {?} */ _ANIMATION_FACTORY_RENDERER_VAR = _ANIMATION_FACTORY_VIEW_VAR.prop('renderer');
  var /** @type {?} */ _ANIMATION_CURRENT_STATE_VAR = variable('currentState');
  var /** @type {?} */ _ANIMATION_NEXT_STATE_VAR = variable('nextState');
  var /** @type {?} */ _ANIMATION_PLAYER_VAR = variable('player');
  var /** @type {?} */ _ANIMATION_TIME_VAR = variable('totalTime');
  var /** @type {?} */ _ANIMATION_START_STATE_STYLES_VAR = variable('startStateStyles');
  var /** @type {?} */ _ANIMATION_END_STATE_STYLES_VAR = variable('endStateStyles');
  var /** @type {?} */ _ANIMATION_COLLECTED_STYLES = variable('collectedStyles');
  var /** @type {?} */ _PREVIOUS_ANIMATION_PLAYERS = variable('previousPlayers');
  var /** @type {?} */ _EMPTY_MAP = literalMap([]);
  var /** @type {?} */ _EMPTY_ARRAY = literalArr([]);
  var _AnimationBuilder = (function () {
      /**
       * @param {?} animationName
       * @param {?} factoryName
       */
      function _AnimationBuilder(animationName, factoryName) {
          this.animationName = animationName;
          this._fnVarName = factoryName + '_factory';
          this._statesMapVarName = factoryName + '_states';
          this._statesMapVar = variable(this._statesMapVarName);
      }
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationStyles = function (ast, context) {
          var /** @type {?} */ stylesArr = [];
          if (context.isExpectingFirstStyleStep) {
              stylesArr.push(_ANIMATION_START_STATE_STYLES_VAR);
              context.isExpectingFirstStyleStep = false;
          }
          ast.styles.forEach(function (entry) {
              var /** @type {?} */ entries = Object.keys(entry).map(function (key) { return [key, literal(entry[key])]; });
              stylesArr.push(literalMap(entries));
          });
          return importExpr(resolveIdentifier(Identifiers.AnimationStyles)).instantiate([
              importExpr(resolveIdentifier(Identifiers.collectAndResolveStyles)).callFn([
                  _ANIMATION_COLLECTED_STYLES, literalArr(stylesArr)
              ])
          ]);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationKeyframe = function (ast, context) {
          return importExpr(resolveIdentifier(Identifiers.AnimationKeyframe)).instantiate([
              literal(ast.offset), ast.styles.visit(this, context)
          ]);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationStep = function (ast, context) {
          var _this = this;
          if (context.endStateAnimateStep === ast) {
              return this._visitEndStateAnimation(ast, context);
          }
          var /** @type {?} */ startingStylesExpr = ast.startingStyles.visit(this, context);
          var /** @type {?} */ keyframeExpressions = ast.keyframes.map(function (keyframeEntry) { return keyframeEntry.visit(_this, context); });
          return this._callAnimateMethod(ast, startingStylesExpr, literalArr(keyframeExpressions), context);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype._visitEndStateAnimation = function (ast, context) {
          var _this = this;
          var /** @type {?} */ startingStylesExpr = ast.startingStyles.visit(this, context);
          var /** @type {?} */ keyframeExpressions = ast.keyframes.map(function (keyframe) { return keyframe.visit(_this, context); });
          var /** @type {?} */ keyframesExpr = importExpr(resolveIdentifier(Identifiers.balanceAnimationKeyframes)).callFn([
              _ANIMATION_COLLECTED_STYLES, _ANIMATION_END_STATE_STYLES_VAR,
              literalArr(keyframeExpressions)
          ]);
          return this._callAnimateMethod(ast, startingStylesExpr, keyframesExpr, context);
      };
      /**
       * @param {?} ast
       * @param {?} startingStylesExpr
       * @param {?} keyframesExpr
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype._callAnimateMethod = function (ast, startingStylesExpr, keyframesExpr, context) {
          var /** @type {?} */ previousStylesValue = _EMPTY_ARRAY;
          if (context.isExpectingFirstAnimateStep) {
              previousStylesValue = _PREVIOUS_ANIMATION_PLAYERS;
              context.isExpectingFirstAnimateStep = false;
          }
          context.totalTransitionTime += ast.duration + ast.delay;
          return _ANIMATION_FACTORY_RENDERER_VAR.callMethod('animate', [
              _ANIMATION_FACTORY_ELEMENT_VAR, startingStylesExpr, keyframesExpr, literal(ast.duration),
              literal(ast.delay), literal(ast.easing), previousStylesValue
          ]);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationSequence = function (ast, context) {
          var _this = this;
          var /** @type {?} */ playerExprs = ast.steps.map(function (step) { return step.visit(_this, context); });
          return importExpr(resolveIdentifier(Identifiers.AnimationSequencePlayer)).instantiate([
              literalArr(playerExprs)
          ]);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationGroup = function (ast, context) {
          var _this = this;
          var /** @type {?} */ playerExprs = ast.steps.map(function (step) { return step.visit(_this, context); });
          return importExpr(resolveIdentifier(Identifiers.AnimationGroupPlayer)).instantiate([
              literalArr(playerExprs)
          ]);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationStateDeclaration = function (ast, context) {
          var /** @type {?} */ flatStyles = {};
          _getStylesArray(ast).forEach(function (entry) { Object.keys(entry).forEach(function (key) { flatStyles[key] = entry[key]; }); });
          context.stateMap.registerState(ast.stateName, flatStyles);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationStateTransition = function (ast, context) {
          var /** @type {?} */ steps = ast.animation.steps;
          var /** @type {?} */ lastStep = steps[steps.length - 1];
          if (_isEndStateAnimateStep(lastStep)) {
              context.endStateAnimateStep = (lastStep);
          }
          context.totalTransitionTime = 0;
          context.isExpectingFirstStyleStep = true;
          context.isExpectingFirstAnimateStep = true;
          var /** @type {?} */ stateChangePreconditions = [];
          ast.stateChanges.forEach(function (stateChange) {
              stateChangePreconditions.push(_compareToAnimationStateExpr(_ANIMATION_CURRENT_STATE_VAR, stateChange.fromState)
                  .and(_compareToAnimationStateExpr(_ANIMATION_NEXT_STATE_VAR, stateChange.toState)));
              if (stateChange.fromState != ANY_STATE) {
                  context.stateMap.registerState(stateChange.fromState);
              }
              if (stateChange.toState != ANY_STATE) {
                  context.stateMap.registerState(stateChange.toState);
              }
          });
          var /** @type {?} */ animationPlayerExpr = ast.animation.visit(this, context);
          var /** @type {?} */ reducedStateChangesPrecondition = stateChangePreconditions.reduce(function (a, b) { return a.or(b); });
          var /** @type {?} */ precondition = _ANIMATION_PLAYER_VAR.equals(NULL_EXPR).and(reducedStateChangesPrecondition);
          var /** @type {?} */ animationStmt = _ANIMATION_PLAYER_VAR.set(animationPlayerExpr).toStmt();
          var /** @type {?} */ totalTimeStmt = _ANIMATION_TIME_VAR.set(literal(context.totalTransitionTime)).toStmt();
          return new IfStmt(precondition, [animationStmt, totalTimeStmt]);
      };
      /**
       * @param {?} ast
       * @param {?} context
       * @return {?}
       */
      _AnimationBuilder.prototype.visitAnimationEntry = function (ast, context) {
          var _this = this;
          // visit each of the declarations first to build the context state map
          ast.stateDeclarations.forEach(function (def) { return def.visit(_this, context); });
          // this should always be defined even if the user overrides it
          context.stateMap.registerState(DEFAULT_STATE, {});
          var /** @type {?} */ statements = [];
          statements.push(_PREVIOUS_ANIMATION_PLAYERS
              .set(_ANIMATION_FACTORY_VIEW_CONTEXT.callMethod('getAnimationPlayers', [
              _ANIMATION_FACTORY_ELEMENT_VAR, literal(this.animationName),
              _ANIMATION_NEXT_STATE_VAR.equals(literal(EMPTY_STATE))
          ]))
              .toDeclStmt());
          statements.push(_ANIMATION_COLLECTED_STYLES.set(_EMPTY_MAP).toDeclStmt());
          statements.push(_ANIMATION_PLAYER_VAR.set(NULL_EXPR).toDeclStmt());
          statements.push(_ANIMATION_TIME_VAR.set(literal(0)).toDeclStmt());
          statements.push(_ANIMATION_DEFAULT_STATE_VAR.set(this._statesMapVar.key(literal(DEFAULT_STATE)))
              .toDeclStmt());
          statements.push(_ANIMATION_START_STATE_STYLES_VAR.set(this._statesMapVar.key(_ANIMATION_CURRENT_STATE_VAR))
              .toDeclStmt());
          statements.push(new IfStmt(_ANIMATION_START_STATE_STYLES_VAR.equals(NULL_EXPR), [_ANIMATION_START_STATE_STYLES_VAR.set(_ANIMATION_DEFAULT_STATE_VAR).toStmt()]));
          statements.push(_ANIMATION_END_STATE_STYLES_VAR.set(this._statesMapVar.key(_ANIMATION_NEXT_STATE_VAR))
              .toDeclStmt());
          statements.push(new IfStmt(_ANIMATION_END_STATE_STYLES_VAR.equals(NULL_EXPR), [_ANIMATION_END_STATE_STYLES_VAR.set(_ANIMATION_DEFAULT_STATE_VAR).toStmt()]));
          var /** @type {?} */ RENDER_STYLES_FN = importExpr(resolveIdentifier(Identifiers.renderStyles));
          ast.stateTransitions.forEach(function (transAst) { return statements.push(transAst.visit(_this, context)); });
          // this check ensures that the animation factory always returns a player
          // so that the onDone callback can be used for tracking
          statements.push(new IfStmt(_ANIMATION_PLAYER_VAR.equals(NULL_EXPR), [_ANIMATION_PLAYER_VAR
                  .set(importExpr(resolveIdentifier(Identifiers.NoOpAnimationPlayer)).instantiate([]))
                  .toStmt()]));
          // once complete we want to apply the styles on the element
          // since the destination state's values should persist once
          // the animation sequence has completed.
          statements.push(_ANIMATION_PLAYER_VAR
              .callMethod('onDone', [fn([], [
                  _ANIMATION_PLAYER_VAR.callMethod('destroy', []).toStmt(),
                  RENDER_STYLES_FN
                      .callFn([
                      _ANIMATION_FACTORY_ELEMENT_VAR, _ANIMATION_FACTORY_RENDERER_VAR,
                      importExpr(resolveIdentifier(Identifiers.prepareFinalAnimationStyles))
                          .callFn([
                          _ANIMATION_START_STATE_STYLES_VAR,
                          _ANIMATION_END_STATE_STYLES_VAR
                      ])
                  ])
                      .toStmt()
              ])])
              .toStmt());
          statements.push(importExpr(resolveIdentifier(Identifiers.AnimationSequencePlayer))
              .instantiate([_PREVIOUS_ANIMATION_PLAYERS])
              .callMethod('destroy', [])
              .toStmt());
          // before we start any animation we want to clear out the starting
          // styles from the element's style property (since they were placed
          // there at the end of the last animation
          statements.push(RENDER_STYLES_FN
              .callFn([
              _ANIMATION_FACTORY_ELEMENT_VAR, _ANIMATION_FACTORY_RENDERER_VAR,
              importExpr(resolveIdentifier(Identifiers.clearStyles))
                  .callFn([_ANIMATION_START_STATE_STYLES_VAR])
          ])
              .toStmt());
          statements.push(_ANIMATION_FACTORY_VIEW_CONTEXT
              .callMethod('queueAnimation', [
              _ANIMATION_FACTORY_ELEMENT_VAR, literal(this.animationName),
              _ANIMATION_PLAYER_VAR
          ])
              .toStmt());
          statements.push(new ReturnStatement(importExpr(resolveIdentifier(Identifiers.AnimationTransition)).instantiate([
              _ANIMATION_PLAYER_VAR, _ANIMATION_CURRENT_STATE_VAR, _ANIMATION_NEXT_STATE_VAR,
              _ANIMATION_TIME_VAR
          ])));
          return fn([
              new FnParam(_ANIMATION_FACTORY_VIEW_VAR.name, importType(resolveIdentifier(Identifiers.AppView), [DYNAMIC_TYPE])),
              new FnParam(_ANIMATION_FACTORY_ELEMENT_VAR.name, DYNAMIC_TYPE),
              new FnParam(_ANIMATION_CURRENT_STATE_VAR.name, DYNAMIC_TYPE),
              new FnParam(_ANIMATION_NEXT_STATE_VAR.name, DYNAMIC_TYPE)
          ], statements, importType(resolveIdentifier(Identifiers.AnimationTransition)));
      };
      /**
       * @param {?} ast
       * @return {?}
       */
      _AnimationBuilder.prototype.build = function (ast) {
          var /** @type {?} */ context = new _AnimationBuilderContext();
          var /** @type {?} */ fnStatement = ast.visit(this, context).toDeclStmt(this._fnVarName);
          var /** @type {?} */ fnVariable = variable(this._fnVarName);
          var /** @type {?} */ lookupMap = [];
          Object.keys(context.stateMap.states).forEach(function (stateName) {
              var /** @type {?} */ value = context.stateMap.states[stateName];
              var /** @type {?} */ variableValue = _EMPTY_MAP;
              if (isPresent(value)) {
                  var /** @type {?} */ styleMap_1 = [];
                  Object.keys(value).forEach(function (key) { styleMap_1.push([key, literal(value[key])]); });
                  variableValue = literalMap(styleMap_1);
              }
              lookupMap.push([stateName, variableValue]);
          });
          var /** @type {?} */ compiledStatesMapStmt = this._statesMapVar.set(literalMap(lookupMap)).toDeclStmt();
          var /** @type {?} */ statements = [compiledStatesMapStmt, fnStatement];
          return new AnimationEntryCompileResult(this.animationName, statements, fnVariable);
      };
      return _AnimationBuilder;
  }());
  var _AnimationBuilderContext = (function () {
      function _AnimationBuilderContext() {
          this.stateMap = new _AnimationBuilderStateMap();
          this.endStateAnimateStep = null;
          this.isExpectingFirstStyleStep = false;
          this.isExpectingFirstAnimateStep = false;
          this.totalTransitionTime = 0;
      }
      return _AnimationBuilderContext;
  }());
  var _AnimationBuilderStateMap = (function () {
      function _AnimationBuilderStateMap() {
          this._states = {};
      }
      Object.defineProperty(_AnimationBuilderStateMap.prototype, "states", {
          /**
           * @return {?}
           */
          get: function () { return this._states; },
          enumerable: true,
          configurable: true
      });
      /**
       * @param {?} name
       * @param {?=} value
       * @return {?}
       */
      _AnimationBuilderStateMap.prototype.registerState = function (name, value) {
          if (value === void 0) { value = null; }
          var /** @type {?} */ existingEntry = this._states[name];
          if (!existingEntry) {
              this._states[name] = value;
          }
      };
      return _AnimationBuilderStateMap;
  }());
  /**
   * @param {?} value
   * @param {?} animationState
   * @return {?}
   */
  function _compareToAnimationStateExpr(value, animationState) {
      var /** @type {?} */ emptyStateLiteral = literal(EMPTY_STATE);
      switch (animationState) {
          case EMPTY_STATE:
              return value.equals(emptyStateLiteral);
          case ANY_STATE:
              return literal(true);
          default:
              return value.equals(literal(animationState));
      }
  }
  /**
   * @param {?} step
   * @return {?}
   */
  function _isEndStateAnimateStep(step) {
      // the final animation step is characterized by having only TWO
      // keyframe values and it must have zero styles for both keyframes
      if (step instanceof AnimationStepAst && step.duration > 0 && step.keyframes.length == 2) {
          var /** @type {?} */ styles1 = _getStylesArray(step.keyframes[0])[0];
          var /** @type {?} */ styles2 = _getStylesArray(step.keyframes[1])[0];
          return Object.keys(styles1).length === 0 && Object.keys(styles2).length === 0;
      }
      return false;
  }
  /**
   * @param {?} obj
   * @return {?}
   */
  function _getStylesArray(obj) {
      return obj.styles.styles;
  }

  var SourceModule = (function () {
      /**
       * @param {?} fileUrl
       * @param {?} moduleUrl
       * @param {?} source
       */
      function SourceModule(fileUrl, moduleUrl, source) {
          this.fileUrl = fileUrl;
          this.moduleUrl = moduleUrl;
          this.source = source;
      }
      return SourceModule;
  }());
  var AotCompiler = (function () {
      /**
       * @param {?} _metadataResolver
       * @param {?} _templateParser
       * @param {?} _styleCompiler
       * @param {?} _viewCompiler
       * @param {?} _dirWrapperCompiler
       * @param {?} _ngModuleCompiler
       * @param {?} _outputEmitter
       * @param {?} _localeId
       * @param {?} _translationFormat
       * @param {?} _animationParser
       * @param {?} _staticReflector
       * @param {?} _options
       */
      function AotCompiler(_metadataResolver, _templateParser, _styleCompiler, _viewCompiler, _dirWrapperCompiler, _ngModuleCompiler, _outputEmitter, _localeId, _translationFormat, _animationParser, _staticReflector, _options) {
          this._metadataResolver = _metadataResolver;
          this._templateParser = _templateParser;
          this._styleCompiler = _styleCompiler;
          this._viewCompiler = _viewCompiler;
          this._dirWrapperCompiler = _dirWrapperCompiler;
          this._ngModuleCompiler = _ngModuleCompiler;
          this._outputEmitter = _outputEmitter;
          this._localeId = _localeId;
          this._translationFormat = _translationFormat;
          this._animationParser = _animationParser;
          this._staticReflector = _staticReflector;
          this._options = _options;
          this._animationCompiler = new AnimationCompiler();
      }
      /**
       * @return {?}
       */
      AotCompiler.prototype.clearCache = function () { this._metadataResolver.clearCache(); };
      /**
       * @param {?} rootFiles
       * @return {?}
       */
      AotCompiler.prototype.compileAll = function (rootFiles) {
          var _this = this;
          var /** @type {?} */ programSymbols = extractProgramSymbols(this._staticReflector, rootFiles, this._options);
          var _a = analyzeAndValidateNgModules(programSymbols, this._options, this._metadataResolver), ngModuleByPipeOrDirective = _a.ngModuleByPipeOrDirective, files = _a.files, ngModules = _a.ngModules;
          return loadNgModuleDirectives(ngModules).then(function () {
              var /** @type {?} */ sourceModules = files.map(function (file) { return _this._compileSrcFile(file.srcUrl, ngModuleByPipeOrDirective, file.directives, file.ngModules); });
              return ListWrapper.flatten(sourceModules);
          });
      };
      /**
       * @param {?} srcFileUrl
       * @param {?} ngModuleByPipeOrDirective
       * @param {?} directives
       * @param {?} ngModules
       * @return {?}
       */
      AotCompiler.prototype._compileSrcFile = function (srcFileUrl, ngModuleByPipeOrDirective, directives, ngModules) {
          var _this = this;
          var /** @type {?} */ fileSuffix = _splitTypescriptSuffix(srcFileUrl)[1];
          var /** @type {?} */ statements = [];
          var /** @type {?} */ exportedVars = [];
          var /** @type {?} */ outputSourceModules = [];
          // compile all ng modules
          exportedVars.push.apply(exportedVars, ngModules.map(function (ngModuleType) { return _this._compileModule(ngModuleType, statements); }));
          // compile directive wrappers
          exportedVars.push.apply(exportedVars, directives.map(function (directiveType) { return _this._compileDirectiveWrapper(directiveType, statements); }));
          // compile components
          directives.forEach(function (dirType) {
              var /** @type {?} */ compMeta = _this._metadataResolver.getDirectiveMetadata(/** @type {?} */ (dirType));
              if (!compMeta.isComponent) {
                  return Promise.resolve(null);
              }
              var /** @type {?} */ ngModule = ngModuleByPipeOrDirective.get(dirType);
              if (!ngModule) {
                  throw new Error("Internal Error: cannot determine the module for component " + compMeta.type.name + "!");
              }
              _assertComponent(compMeta);
              // compile styles
              var /** @type {?} */ stylesCompileResults = _this._styleCompiler.compileComponent(compMeta);
              stylesCompileResults.externalStylesheets.forEach(function (compiledStyleSheet) {
                  outputSourceModules.push(_this._codgenStyles(srcFileUrl, compiledStyleSheet, fileSuffix));
              });
              // compile components
              exportedVars.push(_this._compileComponentFactory(compMeta, ngModule, fileSuffix, statements), _this._compileComponent(compMeta, ngModule, ngModule.transitiveModule.directives, stylesCompileResults.componentStylesheet, fileSuffix, statements));
          });
          if (statements.length > 0) {
              var /** @type {?} */ srcModule = this._codegenSourceModule(srcFileUrl, _ngfactoryModuleUrl(srcFileUrl), statements, exportedVars);
              outputSourceModules.unshift(srcModule);
          }
          return outputSourceModules;
      };
      /**
       * @param {?} ngModuleType
       * @param {?} targetStatements
       * @return {?}
       */
      AotCompiler.prototype._compileModule = function (ngModuleType, targetStatements) {
          var /** @type {?} */ ngModule = this._metadataResolver.getNgModuleMetadata(ngModuleType);
          var /** @type {?} */ providers = [];
          if (this._localeId) {
              providers.push(new CompileProviderMetadata({
                  token: resolveIdentifierToken(Identifiers.LOCALE_ID),
                  useValue: this._localeId,
              }));
          }
          if (this._translationFormat) {
              providers.push(new CompileProviderMetadata({
                  token: resolveIdentifierToken(Identifiers.TRANSLATIONS_FORMAT),
                  useValue: this._translationFormat
              }));
          }
          var /** @type {?} */ appCompileResult = this._ngModuleCompiler.compile(ngModule, providers);
          appCompileResult.dependencies.forEach(function (dep) {
              dep.placeholder.name = _componentFactoryName(dep.comp);
              dep.placeholder.moduleUrl = _ngfactoryModuleUrl(dep.comp.moduleUrl);
          });
          targetStatements.push.apply(targetStatements, appCompileResult.statements);
          return appCompileResult.ngModuleFactoryVar;
      };
      /**
       * @param {?} directiveType
       * @param {?} targetStatements
       * @return {?}
       */
      AotCompiler.prototype._compileDirectiveWrapper = function (directiveType, targetStatements) {
          var /** @type {?} */ dirMeta = this._metadataResolver.getDirectiveMetadata(directiveType);
          var /** @type {?} */ dirCompileResult = this._dirWrapperCompiler.compile(dirMeta);
          targetStatements.push.apply(targetStatements, dirCompileResult.statements);
          return dirCompileResult.dirWrapperClassVar;
      };
      /**
       * @param {?} compMeta
       * @param {?} ngModule
       * @param {?} fileSuffix
       * @param {?} targetStatements
       * @return {?}
       */
      AotCompiler.prototype._compileComponentFactory = function (compMeta, ngModule, fileSuffix, targetStatements) {
          var /** @type {?} */ hostMeta = createHostComponentMeta(compMeta);
          var /** @type {?} */ hostViewFactoryVar = this._compileComponent(hostMeta, ngModule, [compMeta.type], null, fileSuffix, targetStatements);
          var /** @type {?} */ compFactoryVar = _componentFactoryName(compMeta.type);
          targetStatements.push(variable(compFactoryVar)
              .set(importExpr(resolveIdentifier(Identifiers.ComponentFactory), [importType(compMeta.type)])
              .instantiate([
              literal(compMeta.selector),
              variable(hostViewFactoryVar),
              importExpr(compMeta.type),
          ], importType(resolveIdentifier(Identifiers.ComponentFactory), [importType(compMeta.type)], [TypeModifier.Const])))
              .toDeclStmt(null, [StmtModifier.Final]));
          return compFactoryVar;
      };
      /**
       * @param {?} compMeta
       * @param {?} ngModule
       * @param {?} directiveIdentifiers
       * @param {?} componentStyles
       * @param {?} fileSuffix
       * @param {?} targetStatements
       * @return {?}
       */
      AotCompiler.prototype._compileComponent = function (compMeta, ngModule, directiveIdentifiers, componentStyles, fileSuffix, targetStatements) {
          var _this = this;
          var /** @type {?} */ parsedAnimations = this._animationParser.parseComponent(compMeta);
          var /** @type {?} */ directives = directiveIdentifiers.map(function (dir) { return _this._metadataResolver.getDirectiveSummary(dir.reference); });
          var /** @type {?} */ pipes = ngModule.transitiveModule.pipes.map(function (pipe) { return _this._metadataResolver.getPipeSummary(pipe.reference); });
          var /** @type {?} */ parsedTemplate = this._templateParser.parse(compMeta, compMeta.template.template, directives, pipes, ngModule.schemas, compMeta.type.name);
          var /** @type {?} */ stylesExpr = componentStyles ? variable(componentStyles.stylesVar) : literalArr([]);
          var /** @type {?} */ compiledAnimations = this._animationCompiler.compile(compMeta.type.name, parsedAnimations);
          var /** @type {?} */ viewResult = this._viewCompiler.compileComponent(compMeta, parsedTemplate, stylesExpr, pipes, compiledAnimations);
          if (componentStyles) {
              targetStatements.push.apply(targetStatements, _resolveStyleStatements(componentStyles, fileSuffix));
          }
          compiledAnimations.forEach(function (entry) { return targetStatements.push.apply(targetStatements, entry.statements); });
          targetStatements.push.apply(targetStatements, _resolveViewStatements(viewResult));
          return viewResult.viewClassVar;
      };
      /**
       * @param {?} fileUrl
       * @param {?} stylesCompileResult
       * @param {?} fileSuffix
       * @return {?}
       */
      AotCompiler.prototype._codgenStyles = function (fileUrl, stylesCompileResult, fileSuffix) {
          _resolveStyleStatements(stylesCompileResult, fileSuffix);
          return this._codegenSourceModule(fileUrl, _stylesModuleUrl(stylesCompileResult.meta.moduleUrl, stylesCompileResult.isShimmed, fileSuffix), stylesCompileResult.statements, [stylesCompileResult.stylesVar]);
      };
      /**
       * @param {?} fileUrl
       * @param {?} moduleUrl
       * @param {?} statements
       * @param {?} exportedVars
       * @return {?}
       */
      AotCompiler.prototype._codegenSourceModule = function (fileUrl, moduleUrl, statements, exportedVars) {
          return new SourceModule(fileUrl, moduleUrl, this._outputEmitter.emitStatements(moduleUrl, statements, exportedVars));
      };
      return AotCompiler;
  }());
  /**
   * @param {?} compileResult
   * @return {?}
   */
  function _resolveViewStatements(compileResult) {
      compileResult.dependencies.forEach(function (dep) {
          if (dep instanceof ViewClassDependency) {
              var /** @type {?} */ vfd = (dep);
              vfd.placeholder.moduleUrl = _ngfactoryModuleUrl(vfd.comp.moduleUrl);
          }
          else if (dep instanceof ComponentFactoryDependency$1) {
              var /** @type {?} */ cfd = (dep);
              cfd.placeholder.name = _componentFactoryName(cfd.comp);
              cfd.placeholder.moduleUrl = _ngfactoryModuleUrl(cfd.comp.moduleUrl);
          }
          else if (dep instanceof DirectiveWrapperDependency) {
              var /** @type {?} */ dwd = (dep);
              dwd.placeholder.moduleUrl = _ngfactoryModuleUrl(dwd.dir.moduleUrl);
          }
      });
      return compileResult.statements;
  }
  /**
   * @param {?} compileResult
   * @param {?} fileSuffix
   * @return {?}
   */
  function _resolveStyleStatements(compileResult, fileSuffix) {
      compileResult.dependencies.forEach(function (dep) {
          dep.valuePlaceholder.moduleUrl = _stylesModuleUrl(dep.moduleUrl, dep.isShimmed, fileSuffix);
      });
      return compileResult.statements;
  }
  /**
   * @param {?} dirUrl
   * @return {?}
   */
  function _ngfactoryModuleUrl(dirUrl) {
      var /** @type {?} */ urlWithSuffix = _splitTypescriptSuffix(dirUrl);
      return urlWithSuffix[0] + ".ngfactory" + urlWithSuffix[1];
  }
  /**
   * @param {?} comp
   * @return {?}
   */
  function _componentFactoryName(comp) {
      return comp.name + "NgFactory";
  }
  /**
   * @param {?} stylesheetUrl
   * @param {?} shim
   * @param {?} suffix
   * @return {?}
   */
  function _stylesModuleUrl(stylesheetUrl, shim, suffix) {
      return shim ? stylesheetUrl + ".shim" + suffix : "" + stylesheetUrl + suffix;
  }
  /**
   * @param {?} meta
   * @return {?}
   */
  function _assertComponent(meta) {
      if (!meta.isComponent) {
          throw new Error("Could not compile '" + meta.type.name + "' because it is not a component.");
      }
  }
  /**
   * @param {?} path
   * @return {?}
   */
  function _splitTypescriptSuffix(path) {
      if (path.endsWith('.d.ts')) {
          return [path.slice(0, -5), '.ts'];
      }
      var /** @type {?} */ lastDot = path.lastIndexOf('.');
      if (lastDot !== -1) {
          return [path.substring(0, lastDot), path.substring(lastDot)];
      }
      return [path, ''];
  }
  /**
   * @param {?} programStaticSymbols
   * @param {?} options
   * @param {?} metadataResolver
   * @return {?}
   */
  function analyzeNgModules(programStaticSymbols, options, metadataResolver) {
      var _a = _createNgModules(programStaticSymbols, options, metadataResolver), ngModules = _a.ngModules, symbolsMissingModule = _a.symbolsMissingModule;
      return _analyzeNgModules(ngModules, symbolsMissingModule);
  }
  /**
   * @param {?} programStaticSymbols
   * @param {?} options
   * @param {?} metadataResolver
   * @return {?}
   */
  function analyzeAndValidateNgModules(programStaticSymbols, options, metadataResolver) {
      var /** @type {?} */ result = analyzeNgModules(programStaticSymbols, options, metadataResolver);
      if (result.symbolsMissingModule && result.symbolsMissingModule.length) {
          var /** @type {?} */ messages = result.symbolsMissingModule.map(function (s) { return ("Cannot determine the module for class " + s.name + " in " + s.filePath + "!"); });
          throw new Error(messages.join('\n'));
      }
      return result;
  }
  /**
   * @param {?} ngModules
   * @return {?}
   */
  function loadNgModuleDirectives(ngModules) {
      return Promise
          .all(ListWrapper.flatten(ngModules.map(function (ngModule) { return ngModule.transitiveModule.directiveLoaders.map(function (loader) { return loader(); }); })))
          .then(function () { });
  }
  /**
   * @param {?} ngModuleMetas
   * @param {?} symbolsMissingModule
   * @return {?}
   */
  function _analyzeNgModules(ngModuleMetas, symbolsMissingModule) {
      var /** @type {?} */ moduleMetasByRef = new Map();
      ngModuleMetas.forEach(function (ngModule) { return moduleMetasByRef.set(ngModule.type.reference, ngModule); });
      var /** @type {?} */ ngModuleByPipeOrDirective = new Map();
      var /** @type {?} */ ngModulesByFile = new Map();
      var /** @type {?} */ ngDirectivesByFile = new Map();
      var /** @type {?} */ filePaths = new Set();
      // Looping over all modules to construct:
      // - a map from file to modules `ngModulesByFile`,
      // - a map from file to directives `ngDirectivesByFile`,
      // - a map from directive/pipe to module `ngModuleByPipeOrDirective`.
      ngModuleMetas.forEach(function (ngModuleMeta) {
          var /** @type {?} */ srcFileUrl = ngModuleMeta.type.reference.filePath;
          filePaths.add(srcFileUrl);
          ngModulesByFile.set(srcFileUrl, (ngModulesByFile.get(srcFileUrl) || []).concat(ngModuleMeta.type.reference));
          ngModuleMeta.declaredDirectives.forEach(function (dirIdentifier) {
              var /** @type {?} */ fileUrl = dirIdentifier.reference.filePath;
              filePaths.add(fileUrl);
              ngDirectivesByFile.set(fileUrl, (ngDirectivesByFile.get(fileUrl) || []).concat(dirIdentifier.reference));
              ngModuleByPipeOrDirective.set(dirIdentifier.reference, ngModuleMeta);
          });
          ngModuleMeta.declaredPipes.forEach(function (pipeIdentifier) {
              var /** @type {?} */ fileUrl = pipeIdentifier.reference.filePath;
              filePaths.add(fileUrl);
              ngModuleByPipeOrDirective.set(pipeIdentifier.reference, ngModuleMeta);
          });
      });
      var /** @type {?} */ files = [];
      filePaths.forEach(function (srcUrl) {
          var /** @type {?} */ directives = ngDirectivesByFile.get(srcUrl) || [];
          var /** @type {?} */ ngModules = ngModulesByFile.get(srcUrl) || [];
          files.push({ srcUrl: srcUrl, directives: directives, ngModules: ngModules });
      });
      return {
          // map directive/pipe to module
          ngModuleByPipeOrDirective: ngModuleByPipeOrDirective,
          // list modules and directives for every source file
          files: files,
          ngModules: ngModuleMetas, symbolsMissingModule: symbolsMissingModule
      };
  }
  /**
   * @param {?} staticReflector
   * @param {?} files
   * @param {?=} options
   * @return {?}
   */
  function extractProgramSymbols(staticReflector, files, options) {
      if (options === void 0) { options = {}; }
      var /** @type {?} */ staticSymbols = [];
      files.filter(function (fileName) { return _filterFileByPatterns(fileName, options); }).forEach(function (sourceFile) {
          var /** @type {?} */ moduleMetadata = staticReflector.getModuleMetadata(sourceFile);
          if (!moduleMetadata) {
              console.log("WARNING: no metadata found for " + sourceFile);
              return;
          }
          var /** @type {?} */ metadata = moduleMetadata['metadata'];
          if (!metadata) {
              return;
          }
          for (var _i = 0, _a = Object.keys(metadata); _i < _a.length; _i++) {
              var symbol = _a[_i];
              if (metadata[symbol] && metadata[symbol].__symbolic == 'error') {
                  // Ignore symbols that are only included to record error information.
                  continue;
              }
              staticSymbols.push(staticReflector.getStaticSymbol(sourceFile, symbol));
          }
      });
      return staticSymbols;
  }
  /**
   * @param {?} programStaticSymbols
   * @param {?} options
   * @param {?} metadataResolver
   * @return {?}
   */
  function _createNgModules(programStaticSymbols, options, metadataResolver) {
      var /** @type {?} */ ngModules = new Map();
      var /** @type {?} */ programPipesAndDirectives = [];
      var /** @type {?} */ ngModulePipesAndDirective = new Set();
      var /** @type {?} */ addNgModule = function (staticSymbol) {
          if (ngModules.has(staticSymbol) || !_filterFileByPatterns(staticSymbol.filePath, options)) {
              return false;
          }
          var /** @type {?} */ ngModule = metadataResolver.getUnloadedNgModuleMetadata(staticSymbol, false, false);
          if (ngModule) {
              ngModules.set(ngModule.type.reference, ngModule);
              ngModule.declaredDirectives.forEach(function (dir) { return ngModulePipesAndDirective.add(dir.reference); });
              ngModule.declaredPipes.forEach(function (pipe) { return ngModulePipesAndDirective.add(pipe.reference); });
              // For every input module add the list of transitively included modules
              ngModule.transitiveModule.modules.forEach(function (modMeta) { return addNgModule(modMeta.type.reference); });
          }
          return !!ngModule;
      };
      programStaticSymbols.forEach(function (staticSymbol) {
          if (!addNgModule(staticSymbol) &&
              (metadataResolver.isDirective(staticSymbol) || metadataResolver.isPipe(staticSymbol))) {
              programPipesAndDirectives.push(staticSymbol);
          }
      });
      // Throw an error if any of the program pipe or directives is not declared by a module
      var /** @type {?} */ symbolsMissingModule = programPipesAndDirectives.filter(function (s) { return !ngModulePipesAndDirective.has(s); });
      return { ngModules: Array.from(ngModules.values()), symbolsMissingModule: symbolsMissingModule };
  }
  /**
   * @param {?} fileName
   * @param {?=} options
   * @return {?}
   */
  function _filterFileByPatterns(fileName, options) {
      if (options === void 0) { options = {}; }
      var /** @type {?} */ match = true;
      if (options.includeFilePattern) {
          match = match && !!options.includeFilePattern.exec(fileName);
      }
      if (options.excludeFilePattern) {
          match = match && !options.excludeFilePattern.exec(fileName);
      }
      return match;
  }

  var StaticAndDynamicReflectionCapabilities = (function () {
      /**
       * @param {?} staticDelegate
       */
      function StaticAndDynamicReflectionCapabilities(staticDelegate) {
          this.staticDelegate = staticDelegate;
          this.dynamicDelegate = new ReflectionCapabilities();
      }
      /**
       * @param {?} staticDelegate
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.install = function (staticDelegate) {
          reflector.updateCapabilities(new StaticAndDynamicReflectionCapabilities(staticDelegate));
      };
      /**
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.isReflectionEnabled = function () { return true; };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.factory = function (type) { return this.dynamicDelegate.factory(type); };
      /**
       * @param {?} type
       * @param {?} lcProperty
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.hasLifecycleHook = function (type, lcProperty) {
          return isStaticType(type) ? this.staticDelegate.hasLifecycleHook(type, lcProperty) :
              this.dynamicDelegate.hasLifecycleHook(type, lcProperty);
      };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.parameters = function (type) {
          return isStaticType(type) ? this.staticDelegate.parameters(type) :
              this.dynamicDelegate.parameters(type);
      };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.annotations = function (type) {
          return isStaticType(type) ? this.staticDelegate.annotations(type) :
              this.dynamicDelegate.annotations(type);
      };
      /**
       * @param {?} typeOrFunc
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.propMetadata = function (typeOrFunc) {
          return isStaticType(typeOrFunc) ? this.staticDelegate.propMetadata(typeOrFunc) :
              this.dynamicDelegate.propMetadata(typeOrFunc);
      };
      /**
       * @param {?} name
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.getter = function (name) { return this.dynamicDelegate.getter(name); };
      /**
       * @param {?} name
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.setter = function (name) { return this.dynamicDelegate.setter(name); };
      /**
       * @param {?} name
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.method = function (name) { return this.dynamicDelegate.method(name); };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.importUri = function (type) { return this.staticDelegate.importUri(type); };
      /**
       * @param {?} name
       * @param {?} moduleUrl
       * @param {?} runtime
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.resolveIdentifier = function (name, moduleUrl, runtime) {
          return this.staticDelegate.resolveIdentifier(name, moduleUrl, runtime);
      };
      /**
       * @param {?} enumIdentifier
       * @param {?} name
       * @return {?}
       */
      StaticAndDynamicReflectionCapabilities.prototype.resolveEnum = function (enumIdentifier, name) {
          if (isStaticType(enumIdentifier)) {
              return this.staticDelegate.resolveEnum(enumIdentifier, name);
          }
          else {
              return null;
          }
      };
      return StaticAndDynamicReflectionCapabilities;
  }());
  /**
   * @param {?} type
   * @return {?}
   */
  function isStaticType(type) {
      return typeof type === 'object' && type.name && type.filePath;
  }

  /**
   * @license
   * Copyright Google Inc. All Rights Reserved.
   *
   * Use of this source code is governed by an MIT-style license that can be
   * found in the LICENSE file at https://angular.io/license
   */
  var __extends$21 = (this && this.__extends) || function (d, b) {
      for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
      function __() { this.constructor = d; }
      d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  };
  var /** @type {?} */ SUPPORTED_SCHEMA_VERSION = 2;
  var /** @type {?} */ ANGULAR_IMPORT_LOCATIONS = {
      coreDecorators: '@angular/core/src/metadata',
      diDecorators: '@angular/core/src/di/metadata',
      diMetadata: '@angular/core/src/di/metadata',
      diOpaqueToken: '@angular/core/src/di/opaque_token',
      animationMetadata: '@angular/core/src/animation/metadata',
      provider: '@angular/core/src/di/provider'
  };
  /**
   *  A cache of static symbol used by the StaticReflector to return the same symbol for the
    * same symbol values.
   */
  var StaticSymbolCache = (function () {
      function StaticSymbolCache() {
          this.cache = new Map();
      }
      /**
       * @param {?} declarationFile
       * @param {?} name
       * @param {?=} members
       * @return {?}
       */
      StaticSymbolCache.prototype.get = function (declarationFile, name, members) {
          var /** @type {?} */ memberSuffix = members ? "." + members.join('.') : '';
          var /** @type {?} */ key = "\"" + declarationFile + "\"." + name + memberSuffix;
          var /** @type {?} */ result = this.cache.get(key);
          if (!result) {
              result = new StaticSymbol(declarationFile, name, members);
              this.cache.set(key, result);
          }
          return result;
      };
      return StaticSymbolCache;
  }());
  /**
   *  A static reflector implements enough of the Reflector API that is necessary to compile
    * templates statically.
   */
  var StaticReflector = (function () {
      /**
       * @param {?} host
       * @param {?=} staticSymbolCache
       */
      function StaticReflector(host, staticSymbolCache) {
          if (staticSymbolCache === void 0) { staticSymbolCache = new StaticSymbolCache(); }
          this.host = host;
          this.staticSymbolCache = staticSymbolCache;
          this.declarationCache = new Map();
          this.annotationCache = new Map();
          this.propertyCache = new Map();
          this.parameterCache = new Map();
          this.metadataCache = new Map();
          this.conversionMap = new Map();
          this.initializeConversionMap();
      }
      /**
       * @param {?} typeOrFunc
       * @return {?}
       */
      StaticReflector.prototype.importUri = function (typeOrFunc) {
          var /** @type {?} */ staticSymbol = this.findDeclaration(typeOrFunc.filePath, typeOrFunc.name, '');
          return staticSymbol ? staticSymbol.filePath : null;
      };
      /**
       * @param {?} name
       * @param {?} moduleUrl
       * @param {?} runtime
       * @return {?}
       */
      StaticReflector.prototype.resolveIdentifier = function (name, moduleUrl, runtime) {
          return this.findDeclaration(moduleUrl, name, '');
      };
      /**
       * @param {?} enumIdentifier
       * @param {?} name
       * @return {?}
       */
      StaticReflector.prototype.resolveEnum = function (enumIdentifier, name) {
          var /** @type {?} */ staticSymbol = enumIdentifier;
          return this.getStaticSymbol(staticSymbol.filePath, staticSymbol.name, [name]);
      };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticReflector.prototype.annotations = function (type) {
          var /** @type {?} */ annotations = this.annotationCache.get(type);
          if (!annotations) {
              var /** @type {?} */ classMetadata = this.getTypeMetadata(type);
              if (classMetadata['decorators']) {
                  annotations = this.simplify(type, classMetadata['decorators']);
              }
              else {
                  annotations = [];
              }
              this.annotationCache.set(type, annotations.filter(function (ann) { return !!ann; }));
          }
          return annotations;
      };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticReflector.prototype.propMetadata = function (type) {
          var _this = this;
          var /** @type {?} */ propMetadata = this.propertyCache.get(type);
          if (!propMetadata) {
              var /** @type {?} */ classMetadata = this.getTypeMetadata(type);
              var /** @type {?} */ members = classMetadata ? classMetadata['members'] : {};
              propMetadata = mapStringMap(members, function (propData, propName) {
                  var /** @type {?} */ prop = ((propData))
                      .find(function (a) { return a['__symbolic'] == 'property' || a['__symbolic'] == 'method'; });
                  if (prop && prop['decorators']) {
                      return _this.simplify(type, prop['decorators']);
                  }
                  else {
                      return [];
                  }
              });
              this.propertyCache.set(type, propMetadata);
          }
          return propMetadata;
      };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticReflector.prototype.parameters = function (type) {
          if (!(type instanceof StaticSymbol)) {
              throw new Error("parameters received " + JSON.stringify(type) + " which is not a StaticSymbol");
          }
          try {
              var /** @type {?} */ parameters_1 = this.parameterCache.get(type);
              if (!parameters_1) {
                  var /** @type {?} */ classMetadata = this.getTypeMetadata(type);
                  var /** @type {?} */ members = classMetadata ? classMetadata['members'] : null;
                  var /** @type {?} */ ctorData = members ? members['__ctor__'] : null;
                  if (ctorData) {
                      var /** @type {?} */ ctor = ((ctorData)).find(function (a) { return a['__symbolic'] == 'constructor'; });
                      var /** @type {?} */ parameterTypes = (this.simplify(type, ctor['parameters'] || []));
                      var /** @type {?} */ parameterDecorators_1 = (this.simplify(type, ctor['parameterDecorators'] || []));
                      parameters_1 = [];
                      parameterTypes.forEach(function (paramType, index) {
                          var /** @type {?} */ nestedResult = [];
                          if (paramType) {
                              nestedResult.push(paramType);
                          }
                          var /** @type {?} */ decorators = parameterDecorators_1 ? parameterDecorators_1[index] : null;
                          if (decorators) {
                              nestedResult.push.apply(nestedResult, decorators);
                          }
                          parameters_1.push(nestedResult);
                      });
                  }
                  if (!parameters_1) {
                      parameters_1 = [];
                  }
                  this.parameterCache.set(type, parameters_1);
              }
              return parameters_1;
          }
          catch (e) {
              console.log("Failed on type " + JSON.stringify(type) + " with error " + e);
              throw e;
          }
      };
      /**
       * @param {?} type
       * @param {?} lcProperty
       * @return {?}
       */
      StaticReflector.prototype.hasLifecycleHook = function (type, lcProperty) {
          if (!(type instanceof StaticSymbol)) {
              throw new Error("hasLifecycleHook received " + JSON.stringify(type) + " which is not a StaticSymbol");
          }
          var /** @type {?} */ classMetadata = this.getTypeMetadata(type);
          var /** @type {?} */ members = classMetadata ? classMetadata['members'] : null;
          var /** @type {?} */ member = members && members.hasOwnProperty(lcProperty) ? members[lcProperty] : null;
          return member ? member.some(function (a) { return a['__symbolic'] == 'method'; }) : false;
      };
      /**
       * @param {?} type
       * @param {?} ctor
       * @return {?}
       */
      StaticReflector.prototype.registerDecoratorOrConstructor = function (type, ctor) {
          this.conversionMap.set(type, function (context, args) { return new (ctor.bind.apply(ctor, [void 0].concat(args)))(); });
      };
      /**
       * @param {?} type
       * @param {?} fn
       * @return {?}
       */
      StaticReflector.prototype.registerFunction = function (type, fn) {
          this.conversionMap.set(type, function (context, args) { return fn.apply(undefined, args); });
      };
      /**
       * @return {?}
       */
      StaticReflector.prototype.initializeConversionMap = function () {
          var coreDecorators = ANGULAR_IMPORT_LOCATIONS.coreDecorators, diDecorators = ANGULAR_IMPORT_LOCATIONS.diDecorators, diMetadata = ANGULAR_IMPORT_LOCATIONS.diMetadata, diOpaqueToken = ANGULAR_IMPORT_LOCATIONS.diOpaqueToken, animationMetadata = ANGULAR_IMPORT_LOCATIONS.animationMetadata, provider = ANGULAR_IMPORT_LOCATIONS.provider;
          this.opaqueToken = this.findDeclaration(diOpaqueToken, 'OpaqueToken');
          this.registerDecoratorOrConstructor(this.findDeclaration(diDecorators, 'Host'), _angular_core.Host);
          this.registerDecoratorOrConstructor(this.findDeclaration(diDecorators, 'Injectable'), _angular_core.Injectable);
          this.registerDecoratorOrConstructor(this.findDeclaration(diDecorators, 'Self'), _angular_core.Self);
          this.registerDecoratorOrConstructor(this.findDeclaration(diDecorators, 'SkipSelf'), _angular_core.SkipSelf);
          this.registerDecoratorOrConstructor(this.findDeclaration(diDecorators, 'Inject'), _angular_core.Inject);
          this.registerDecoratorOrConstructor(this.findDeclaration(diDecorators, 'Optional'), _angular_core.Optional);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'Attribute'), _angular_core.Attribute);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'ContentChild'), _angular_core.ContentChild);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'ContentChildren'), _angular_core.ContentChildren);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'ViewChild'), _angular_core.ViewChild);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'ViewChildren'), _angular_core.ViewChildren);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'Input'), _angular_core.Input);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'Output'), _angular_core.Output);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'Pipe'), _angular_core.Pipe);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'HostBinding'), _angular_core.HostBinding);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'HostListener'), _angular_core.HostListener);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'Directive'), _angular_core.Directive);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'Component'), _angular_core.Component);
          this.registerDecoratorOrConstructor(this.findDeclaration(coreDecorators, 'NgModule'), _angular_core.NgModule);
          // Note: Some metadata classes can be used directly with Provider.deps.
          this.registerDecoratorOrConstructor(this.findDeclaration(diMetadata, 'Host'), _angular_core.Host);
          this.registerDecoratorOrConstructor(this.findDeclaration(diMetadata, 'Self'), _angular_core.Self);
          this.registerDecoratorOrConstructor(this.findDeclaration(diMetadata, 'SkipSelf'), _angular_core.SkipSelf);
          this.registerDecoratorOrConstructor(this.findDeclaration(diMetadata, 'Optional'), _angular_core.Optional);
          this.registerFunction(this.findDeclaration(animationMetadata, 'trigger'), _angular_core.trigger);
          this.registerFunction(this.findDeclaration(animationMetadata, 'state'), _angular_core.state);
          this.registerFunction(this.findDeclaration(animationMetadata, 'transition'), _angular_core.transition);
          this.registerFunction(this.findDeclaration(animationMetadata, 'style'), _angular_core.style);
          this.registerFunction(this.findDeclaration(animationMetadata, 'animate'), _angular_core.animate);
          this.registerFunction(this.findDeclaration(animationMetadata, 'keyframes'), _angular_core.keyframes);
          this.registerFunction(this.findDeclaration(animationMetadata, 'sequence'), _angular_core.sequence);
          this.registerFunction(this.findDeclaration(animationMetadata, 'group'), _angular_core.group);
      };
      /**
       *  getStaticSymbol produces a Type whose metadata is known but whose implementation is not loaded.
        * All types passed to the StaticResolver should be pseudo-types returned by this method.
        * *
       * @param {?} declarationFile the absolute path of the file where the symbol is declared
       * @param {?} name the name of the type.
       * @param {?=} members
       * @return {?}
       */
      StaticReflector.prototype.getStaticSymbol = function (declarationFile, name, members) {
          return this.staticSymbolCache.get(declarationFile, name, members);
      };
      /**
       * @param {?} filePath
       * @param {?} symbolName
       * @return {?}
       */
      StaticReflector.prototype.resolveExportedSymbol = function (filePath, symbolName) {
          var _this = this;
          var /** @type {?} */ resolveModule = function (moduleName) {
              var /** @type {?} */ resolvedModulePath = _this.host.moduleNameToFileName(moduleName, filePath);
              if (!resolvedModulePath) {
                  throw new Error("Could not resolve module '" + moduleName + "' relative to file " + filePath);
              }
              return resolvedModulePath;
          };
          var /** @type {?} */ cacheKey = filePath + "|" + symbolName;
          var /** @type {?} */ staticSymbol = this.declarationCache.get(cacheKey);
          if (staticSymbol) {
              return staticSymbol;
          }
          var /** @type {?} */ metadata = this.getModuleMetadata(filePath);
          if (metadata) {
              // If we have metadata for the symbol, this is the original exporting location.
              if (metadata['metadata'][symbolName]) {
                  staticSymbol = this.getStaticSymbol(filePath, symbolName);
              }
              // If no, try to find the symbol in one of the re-export location
              if (!staticSymbol && metadata['exports']) {
                  // Try and find the symbol in the list of explicitly re-exported symbols.
                  for (var _i = 0, _a = metadata['exports']; _i < _a.length; _i++) {
                      var moduleExport = _a[_i];
                      if (moduleExport.export) {
                          var /** @type {?} */ exportSymbol = moduleExport.export.find(function (symbol) {
                              if (typeof symbol === 'string') {
                                  return symbol == symbolName;
                              }
                              else {
                                  return symbol.as == symbolName;
                              }
                          });
                          if (exportSymbol) {
                              var /** @type {?} */ symName = symbolName;
                              if (typeof exportSymbol !== 'string') {
                                  symName = exportSymbol.name;
                              }
                              staticSymbol = this.resolveExportedSymbol(resolveModule(moduleExport.from), symName);
                          }
                      }
                  }
                  if (!staticSymbol) {
                      // Try to find the symbol via export * directives.
                      for (var _b = 0, _c = metadata['exports']; _b < _c.length; _b++) {
                          var moduleExport = _c[_b];
                          if (!moduleExport.export) {
                              var /** @type {?} */ resolvedModule = resolveModule(moduleExport.from);
                              var /** @type {?} */ candidateSymbol = this.resolveExportedSymbol(resolvedModule, symbolName);
                              if (candidateSymbol) {
                                  staticSymbol = candidateSymbol;
                                  break;
                              }
                          }
                      }
                  }
              }
          }
          this.declarationCache.set(cacheKey, staticSymbol);
          return staticSymbol;
      };
      /**
       * @param {?} module
       * @param {?} symbolName
       * @param {?=} containingFile
       * @return {?}
       */
      StaticReflector.prototype.findDeclaration = function (module, symbolName, containingFile) {
          try {
              var /** @type {?} */ filePath = this.host.moduleNameToFileName(module, containingFile);
              var /** @type {?} */ symbol = void 0;
              if (!filePath) {
                  // If the file cannot be found the module is probably referencing a declared module
                  // for which there is no disambiguating file and we also don't need to track
                  // re-exports. Just use the module name.
                  symbol = this.getStaticSymbol(module, symbolName);
              }
              else {
                  symbol = this.resolveExportedSymbol(filePath, symbolName) ||
                      this.getStaticSymbol(filePath, symbolName);
              }
              return symbol;
          }
          catch (e) {
              console.error("can't resolve module " + module + " from " + containingFile);
              throw e;
          }
      };
      /**
       * @param {?} context
       * @param {?} value
       * @return {?}
       */
      StaticReflector.prototype.simplify = function (context, value) {
          var /** @type {?} */ _this = this;
          var /** @type {?} */ scope = BindingScope.empty;
          var /** @type {?} */ calling = new Map();
          /**
           * @param {?} context
           * @param {?} value
           * @param {?} depth
           * @return {?}
           */
          function simplifyInContext(context, value, depth) {
              /**
               * @param {?} context
               * @param {?} expression
               * @return {?}
               */
              function resolveReference(context, expression) {
                  var /** @type {?} */ staticSymbol;
                  if (expression['module']) {
                      staticSymbol =
                          _this.findDeclaration(expression['module'], expression['name'], context.filePath);
                  }
                  else {
                      staticSymbol = _this.getStaticSymbol(context.filePath, expression['name']);
                  }
                  return staticSymbol;
              }
              /**
               * @param {?} staticSymbol
               * @return {?}
               */
              function resolveReferenceValue(staticSymbol) {
                  var /** @type {?} */ moduleMetadata = _this.getModuleMetadata(staticSymbol.filePath);
                  var /** @type {?} */ declarationValue = moduleMetadata ? moduleMetadata['metadata'][staticSymbol.name] : null;
                  return declarationValue;
              }
              /**
               * @param {?} context
               * @param {?} value
               * @return {?}
               */
              function isOpaqueToken(context, value) {
                  if (value && value.__symbolic === 'new' && value.expression) {
                      var /** @type {?} */ target = value.expression;
                      if (target.__symbolic == 'reference') {
                          return sameSymbol(resolveReference(context, target), _this.opaqueToken);
                      }
                  }
                  return false;
              }
              /**
               * @param {?} expression
               * @return {?}
               */
              function simplifyCall(expression) {
                  var /** @type {?} */ callContext = undefined;
                  if (expression['__symbolic'] == 'call') {
                      var /** @type {?} */ target = expression['expression'];
                      var /** @type {?} */ functionSymbol = void 0;
                      var /** @type {?} */ targetFunction = void 0;
                      if (target) {
                          switch (target.__symbolic) {
                              case 'reference':
                                  // Find the function to call.
                                  callContext = { name: target.name };
                                  functionSymbol = resolveReference(context, target);
                                  targetFunction = resolveReferenceValue(functionSymbol);
                                  break;
                              case 'select':
                                  // Find the static method to call
                                  if (target.expression.__symbolic == 'reference') {
                                      functionSymbol = resolveReference(context, target.expression);
                                      var /** @type {?} */ classData = resolveReferenceValue(functionSymbol);
                                      if (classData && classData.statics) {
                                          targetFunction = classData.statics[target.member];
                                      }
                                  }
                                  break;
                          }
                      }
                      if (targetFunction && targetFunction['__symbolic'] == 'function') {
                          if (calling.get(functionSymbol)) {
                              throw new Error('Recursion not supported');
                          }
                          calling.set(functionSymbol, true);
                          try {
                              var /** @type {?} */ value_1 = targetFunction['value'];
                              if (value_1 && (depth != 0 || value_1.__symbolic != 'error')) {
                                  // Determine the arguments
                                  var /** @type {?} */ args = (expression['arguments'] || []).map(function (arg) { return simplify(arg); });
                                  var /** @type {?} */ parameters = targetFunction['parameters'];
                                  var /** @type {?} */ defaults = targetFunction.defaults;
                                  if (defaults && defaults.length > args.length) {
                                      args.push.apply(args, defaults.slice(args.length).map(function (value) { return simplify(value); }));
                                  }
                                  var /** @type {?} */ functionScope = BindingScope.build();
                                  for (var /** @type {?} */ i = 0; i < parameters.length; i++) {
                                      functionScope.define(parameters[i], args[i]);
                                  }
                                  var /** @type {?} */ oldScope = scope;
                                  var /** @type {?} */ result_1;
                                  try {
                                      scope = functionScope.done();
                                      result_1 = simplifyInContext(functionSymbol, value_1, depth + 1);
                                  }
                                  finally {
                                      scope = oldScope;
                                  }
                                  return result_1;
                              }
                          }
                          finally {
                              calling.delete(functionSymbol);
                          }
                      }
                  }
                  if (depth === 0) {
                      // If depth is 0 we are evaluating the top level expression that is describing element
                      // decorator. In this case, it is a decorator we don't understand, such as a custom
                      // non-angular decorator, and we should just ignore it.
                      return { __symbolic: 'ignore' };
                  }
                  return simplify({ __symbolic: 'error', message: 'Function call not supported', context: callContext });
              }
              /**
               * @param {?} expression
               * @return {?}
               */
              function simplify(expression) {
                  if (isPrimitive$1(expression)) {
                      return expression;
                  }
                  if (expression instanceof Array) {
                      var /** @type {?} */ result_2 = [];
                      for (var _i = 0, _a = ((expression)); _i < _a.length; _i++) {
                          var item = _a[_i];
                          // Check for a spread expression
                          if (item && item.__symbolic === 'spread') {
                              var /** @type {?} */ spreadArray = simplify(item.expression);
                              if (Array.isArray(spreadArray)) {
                                  for (var _b = 0, spreadArray_1 = spreadArray; _b < spreadArray_1.length; _b++) {
                                      var spreadItem = spreadArray_1[_b];
                                      result_2.push(spreadItem);
                                  }
                                  continue;
                              }
                          }
                          var /** @type {?} */ value_2 = simplify(item);
                          if (shouldIgnore(value_2)) {
                              continue;
                          }
                          result_2.push(value_2);
                      }
                      return result_2;
                  }
                  if (expression instanceof StaticSymbol) {
                      return expression;
                  }
                  if (expression) {
                      if (expression['__symbolic']) {
                          var /** @type {?} */ staticSymbol = void 0;
                          switch (expression['__symbolic']) {
                              case 'binop':
                                  var /** @type {?} */ left = simplify(expression['left']);
                                  if (shouldIgnore(left))
                                      return left;
                                  var /** @type {?} */ right = simplify(expression['right']);
                                  if (shouldIgnore(right))
                                      return right;
                                  switch (expression['operator']) {
                                      case '&&':
                                          return left && right;
                                      case '||':
                                          return left || right;
                                      case '|':
                                          return left | right;
                                      case '^':
                                          return left ^ right;
                                      case '&':
                                          return left & right;
                                      case '==':
                                          return left == right;
                                      case '!=':
                                          return left != right;
                                      case '===':
                                          return left === right;
                                      case '!==':
                                          return left !== right;
                                      case '<':
                                          return left < right;
                                      case '>':
                                          return left > right;
                                      case '<=':
                                          return left <= right;
                                      case '>=':
                                          return left >= right;
                                      case '<<':
                                          return left << right;
                                      case '>>':
                                          return left >> right;
                                      case '+':
                                          return left + right;
                                      case '-':
                                          return left - right;
                                      case '*':
                                          return left * right;
                                      case '/':
                                          return left / right;
                                      case '%':
                                          return left % right;
                                  }
                                  return null;
                              case 'if':
                                  var /** @type {?} */ condition = simplify(expression['condition']);
                                  return condition ? simplify(expression['thenExpression']) :
                                      simplify(expression['elseExpression']);
                              case 'pre':
                                  var /** @type {?} */ operand = simplify(expression['operand']);
                                  if (shouldIgnore(operand))
                                      return operand;
                                  switch (expression['operator']) {
                                      case '+':
                                          return operand;
                                      case '-':
                                          return -operand;
                                      case '!':
                                          return !operand;
                                      case '~':
                                          return ~operand;
                                  }
                                  return null;
                              case 'index':
                                  var /** @type {?} */ indexTarget = simplify(expression['expression']);
                                  var /** @type {?} */ index = simplify(expression['index']);
                                  if (indexTarget && isPrimitive$1(index))
                                      return indexTarget[index];
                                  return null;
                              case 'select':
                                  var /** @type {?} */ selectTarget = simplify(expression['expression']);
                                  if (selectTarget instanceof StaticSymbol) {
                                      // Access to a static instance variable
                                      var /** @type {?} */ declarationValue_1 = resolveReferenceValue(selectTarget);
                                      if (declarationValue_1 && declarationValue_1.statics) {
                                          selectTarget = declarationValue_1.statics;
                                      }
                                      else {
                                          var /** @type {?} */ member_1 = expression['member'];
                                          var /** @type {?} */ members = selectTarget.members ?
                                              ((selectTarget.members)).concat(member_1) :
                                              [member_1];
                                          return _this.getStaticSymbol(selectTarget.filePath, selectTarget.name, members);
                                      }
                                  }
                                  var /** @type {?} */ member = simplify(expression['member']);
                                  if (selectTarget && isPrimitive$1(member))
                                      return simplify(selectTarget[member]);
                                  return null;
                              case 'reference':
                                  if (!expression.module) {
                                      var /** @type {?} */ name_1 = expression['name'];
                                      var /** @type {?} */ localValue = scope.resolve(name_1);
                                      if (localValue != BindingScope.missing) {
                                          return localValue;
                                      }
                                  }
                                  staticSymbol = resolveReference(context, expression);
                                  var /** @type {?} */ result_3 = staticSymbol;
                                  var /** @type {?} */ declarationValue = resolveReferenceValue(result_3);
                                  if (declarationValue) {
                                      if (isOpaqueToken(staticSymbol, declarationValue)) {
                                          // If the referenced symbol is initalized by a new OpaqueToken we can keep the
                                          // reference to the symbol.
                                          return staticSymbol;
                                      }
                                      result_3 = simplifyInContext(staticSymbol, declarationValue, depth + 1);
                                  }
                                  return result_3;
                              case 'class':
                                  return context;
                              case 'function':
                                  return context;
                              case 'new':
                              case 'call':
                                  // Determine if the function is a built-in conversion
                                  var /** @type {?} */ target = expression['expression'];
                                  if (target['module']) {
                                      staticSymbol =
                                          _this.findDeclaration(target['module'], target['name'], context.filePath);
                                  }
                                  else {
                                      staticSymbol = _this.getStaticSymbol(context.filePath, target['name']);
                                  }
                                  var /** @type {?} */ converter = _this.conversionMap.get(staticSymbol);
                                  if (converter) {
                                      var /** @type {?} */ args = expression['arguments'];
                                      if (!args) {
                                          args = [];
                                      }
                                      return converter(context, args.map(function (arg) { return simplifyInContext(context, arg, depth + 1); }));
                                  }
                                  // Determine if the function is one we can simplify.
                                  return simplifyCall(expression);
                              case 'error':
                                  var /** @type {?} */ message = produceErrorMessage(expression);
                                  if (expression['line']) {
                                      message =
                                          message + " (position " + (expression['line'] + 1) + ":" + (expression['character'] + 1) + " in the original .ts file)";
                                      throw positionalError(message, context.filePath, expression['line'], expression['character']);
                                  }
                                  throw new Error(message);
                          }
                          return null;
                      }
                      return mapStringMap(expression, function (value, name) { return simplify(value); });
                  }
                  return null;
              }
              try {
                  return simplify(value);
              }
              catch (e) {
                  var /** @type {?} */ message = e.message + ", resolving symbol " + context.name + " in " + context.filePath;
                  if (e.fileName) {
                      throw positionalError(message, e.fileName, e.line, e.column);
                  }
                  throw new Error(message);
              }
          }
          var /** @type {?} */ result = simplifyInContext(context, value, 0);
          if (shouldIgnore(result)) {
              return undefined;
          }
          return result;
      };
      /**
       * @param {?} module an absolute path to a module file.
       * @return {?}
       */
      StaticReflector.prototype.getModuleMetadata = function (module) {
          var /** @type {?} */ moduleMetadata = this.metadataCache.get(module);
          if (!moduleMetadata) {
              var /** @type {?} */ moduleMetadatas = this.host.getMetadataFor(module);
              if (moduleMetadatas) {
                  var /** @type {?} */ maxVersion_1 = -1;
                  moduleMetadatas.forEach(function (md) {
                      if (md['version'] > maxVersion_1) {
                          maxVersion_1 = md['version'];
                          moduleMetadata = md;
                      }
                  });
              }
              if (!moduleMetadata) {
                  moduleMetadata =
                      { __symbolic: 'module', version: SUPPORTED_SCHEMA_VERSION, module: module, metadata: {} };
              }
              if (moduleMetadata['version'] != SUPPORTED_SCHEMA_VERSION) {
                  throw new Error("Metadata version mismatch for module " + module + ", found version " + moduleMetadata['version'] + ", expected " + SUPPORTED_SCHEMA_VERSION);
              }
              this.metadataCache.set(module, moduleMetadata);
          }
          return moduleMetadata;
      };
      /**
       * @param {?} type
       * @return {?}
       */
      StaticReflector.prototype.getTypeMetadata = function (type) {
          var /** @type {?} */ moduleMetadata = this.getModuleMetadata(type.filePath);
          return moduleMetadata['metadata'][type.name] || { __symbolic: 'class' };
      };
      return StaticReflector;
  }());
  /**
   * @param {?} error
   * @return {?}
   */
  function expandedMessage(error) {
      switch (error.message) {
          case 'Reference to non-exported class':
              if (error.context && error.context.className) {
                  return "Reference to a non-exported class " + error.context.className + ". Consider exporting the class";
              }
              break;
          case 'Variable not initialized':
              return 'Only initialized variables and constants can be referenced because the value of this variable is needed by the template compiler';
          case 'Destructuring not supported':
              return 'Referencing an exported destructured variable or constant is not supported by the template compiler. Consider simplifying this to avoid destructuring';
          case 'Could not resolve type':
              if (error.context && error.context.typeName) {
                  return "Could not resolve type " + error.context.typeName;
              }
              break;
          case 'Function call not supported':
              var /** @type {?} */ prefix = error.context && error.context.name ? "Calling function '" + error.context.name + "', f" : 'F';
              return prefix +
                  'unction calls are not supported. Consider replacing the function or lambda with a reference to an exported function';
          case 'Reference to a local symbol':
              if (error.context && error.context.name) {
                  return "Reference to a local (non-exported) symbol '" + error.context.name + "'. Consider exporting the symbol";
              }
              break;
      }
      return error.message;
  }
  /**
   * @param {?} error
   * @return {?}
   */
  function produceErrorMessage(error) {
      return "Error encountered resolving symbol values statically. " + expandedMessage(error);
  }
  /**
   * @param {?} input
   * @param {?} transform
   * @return {?}
   */
  function mapStringMap(input, transform) {
      if (!input)
          return {};
      var /** @type {?} */ result = {};
      Object.keys(input).forEach(function (key) {
          var /** @type {?} */ value = transform(input[key], key);
          if (!shouldIgnore(value)) {
              result[key] = value;
          }
      });
      return result;
  }
  /**
   * @param {?} o
   * @return {?}
   */
  function isPrimitive$1(o) {
      return o === null || (typeof o !== 'function' && typeof o !== 'object');
  }
  /**
   * @abstract
   */
  var BindingScope = (function () {
      function BindingScope() {
      }
      /**
       * @abstract
       * @param {?} name
       * @return {?}
       */
      BindingScope.prototype.resolve = func