/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { Injectable } from '@angular/core';
import { getHtmlTagDefinition } from './html_tags';
import { DEFAULT_INTERPOLATION_CONFIG } from './interpolation_config';
import { Parser } from './parser';
export { ParseTreeResult, TreeError } from './parser';
export var HtmlParser = (function (_super) {
    __extends(HtmlParser, _super);
    function HtmlParser() {
        _super.call(this, getHtmlTagDefinition);
    }
    /**
     * @param {?} source
     * @param {?} url
     * @param {?=} parseExpansionForms
     * @param {?=} interpolationConfig
     * @return {?}
     */
    HtmlParser.prototype.parse = function (source, url, parseExpansionForms, interpolationConfig) {
        if (parseExpansionForms === void 0) { parseExpansionForms = false; }
        if (interpolationConfig === void 0) { interpolationConfig = DEFAULT_INTERPOLATION_CONFIG; }
        return _super.prototype.parse.call(this, source, url, parseExpansionForms, interpolationConfig);
    };
    HtmlParser.decorators = [
        { type: Injectable },
    ];
    /** @nocollapse */
    HtmlParser.ctorParameters = function () { return []; };
    return HtmlParser;
}(Parser));
function HtmlParser_tsickle_Closure_declarations() {
    /** @type {?} */
    HtmlParser.decorators;
    /**
     * @nocollapse
     * @type {?}
     */
    HtmlParser.ctorParameters;
}
//# sourceMappingURL=html_parser.js.map