/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { AnimationEntryCompileResult } from '../animation/animation_compiler';
import { CompileDirectiveMetadata, CompilePipeSummary } from '../compile_metadata';
import { NameResolver } from '../compiler_util/expression_converter';
import { CompilerConfig } from '../config';
import * as o from '../output/output_ast';
import { ViewType } from '../private_import_core';
import { CompileElement, CompileNode } from './compile_element';
import { CompileMethod } from './compile_method';
import { CompilePipe } from './compile_pipe';
import { CompileQuery } from './compile_query';
import { ComponentFactoryDependency, ComponentViewDependency, DirectiveWrapperDependency } from './deps';
export declare enum CompileViewRootNodeType {
    Node = 0,
    ViewContainer = 1,
    NgContent = 2,
}
export declare class CompileViewRootNode {
    type: CompileViewRootNodeType;
    expr: o.Expression;
    ngContentIndex: number;
    constructor(type: CompileViewRootNodeType, expr: o.Expression, ngContentIndex?: number);
}
export declare class CompileView implements NameResolver {
    component: CompileDirectiveMetadata;
    genConfig: CompilerConfig;
    pipeMetas: CompilePipeSummary[];
    styles: o.Expression;
    animations: AnimationEntryCompileResult[];
    viewIndex: number;
    declarationElement: CompileElement;
    templateVariableBindings: string[][];
    targetDependencies: Array<ComponentViewDependency | ComponentFactoryDependency | DirectiveWrapperDependency>;
    viewType: ViewType;
    viewQueries: Map<any, CompileQuery[]>;
    viewChildren: o.Expression[];
    nodes: CompileNode[];
    rootNodes: CompileViewRootNode[];
    lastRenderNode: o.Expression;
    viewContainers: o.Expression[];
    createMethod: CompileMethod;
    animationBindingsMethod: CompileMethod;
    injectorGetMethod: CompileMethod;
    updateContentQueriesMethod: CompileMethod;
    dirtyParentQueriesMethod: CompileMethod;
    updateViewQueriesMethod: CompileMethod;
    detectChangesInInputsMethod: CompileMethod;
    detectChangesRenderPropertiesMethod: CompileMethod;
    afterContentLifecycleCallbacksMethod: CompileMethod;
    afterViewLifecycleCallbacksMethod: CompileMethod;
    destroyMethod: CompileMethod;
    detachMethod: CompileMethod;
    methods: o.ClassMethod[];
    ctorStmts: o.Statement[];
    fields: o.ClassField[];
    getters: o.ClassGetter[];
    disposables: o.Expression[];
    componentView: CompileView;
    purePipes: Map<string, CompilePipe>;
    pipes: CompilePipe[];
    locals: Map<string, o.Expression>;
    className: string;
    classType: o.Type;
    classExpr: o.ReadVarExpr;
    literalArrayCount: number;
    literalMapCount: number;
    pipeCount: number;
    componentContext: o.Expression;
    constructor(component: CompileDirectiveMetadata, genConfig: CompilerConfig, pipeMetas: CompilePipeSummary[], styles: o.Expression, animations: AnimationEntryCompileResult[], viewIndex: number, declarationElement: CompileElement, templateVariableBindings: string[][], targetDependencies: Array<ComponentViewDependency | ComponentFactoryDependency | DirectiveWrapperDependency>);
    callPipe(name: string, input: o.Expression, args: o.Expression[]): o.Expression;
    getLocal(name: string): o.Expression;
    finish(): void;
}
