/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler/src/compiler", ["require", "exports", "tslib", "@angular/compiler/src/core", "@angular/compiler/src/version", "@angular/compiler/src/template_parser/template_ast", "@angular/compiler/src/config", "@angular/compiler/src/compile_metadata", "@angular/compiler/src/aot/compiler_factory", "@angular/compiler/src/aot/compiler", "@angular/compiler/src/aot/generated_file", "@angular/compiler/src/aot/formatted_error", "@angular/compiler/src/aot/static_reflector", "@angular/compiler/src/aot/static_symbol", "@angular/compiler/src/aot/static_symbol_resolver", "@angular/compiler/src/aot/summary_resolver", "@angular/compiler/src/aot/util", "@angular/compiler/src/ast_path", "@angular/compiler/src/summary_resolver", "@angular/compiler/src/identifiers", "@angular/compiler/src/jit/compiler", "@angular/compiler/src/compile_reflector", "@angular/compiler/src/url_resolver", "@angular/compiler/src/resource_loader", "@angular/compiler/src/constant_pool", "@angular/compiler/src/directive_resolver", "@angular/compiler/src/pipe_resolver", "@angular/compiler/src/ng_module_resolver", "@angular/compiler/src/ml_parser/interpolation_config", "@angular/compiler/src/schema/element_schema_registry", "@angular/compiler/src/i18n/index", "@angular/compiler/src/directive_normalizer", "@angular/compiler/src/expression_parser/ast", "@angular/compiler/src/expression_parser/lexer", "@angular/compiler/src/expression_parser/parser", "@angular/compiler/src/metadata_resolver", "@angular/compiler/src/ml_parser/ast", "@angular/compiler/src/ml_parser/html_parser", "@angular/compiler/src/ml_parser/html_tags", "@angular/compiler/src/ml_parser/interpolation_config", "@angular/compiler/src/ml_parser/tags", "@angular/compiler/src/ng_module_compiler", "@angular/compiler/src/output/output_ast", "@angular/compiler/src/output/abstract_emitter", "@angular/compiler/src/output/ts_emitter", "@angular/compiler/src/parse_util", "@angular/compiler/src/schema/dom_element_schema_registry", "@angular/compiler/src/selector", "@angular/compiler/src/style_compiler", "@angular/compiler/src/template_parser/template_parser", "@angular/compiler/src/view_compiler/view_compiler", "@angular/compiler/src/util", "@angular/compiler/src/injectable_compiler_2", "@angular/compiler/src/render3/r3_ast", "@angular/compiler/src/render3/view/t2_binder", "@angular/compiler/src/render3/r3_jit", "@angular/compiler/src/render3/r3_factory", "@angular/compiler/src/render3/r3_module_compiler", "@angular/compiler/src/render3/r3_pipe_compiler", "@angular/compiler/src/render3/view/template", "@angular/compiler/src/render3/view/compiler"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var tslib_1 = require("tslib");
    /**
     * @module
     * @description
     * Entry point for all APIs of the compiler package.
     *
     * <div class="callout is-critical">
     *   <header>Unstable APIs</header>
     *   <p>
     *     All compiler apis are currently considered experimental and private!
     *   </p>
     *   <p>
     *     We expect the APIs in this package to keep on changing. Do not rely on them.
     *   </p>
     * </div>
     */
    var core = require("@angular/compiler/src/core");
    exports.core = core;
    tslib_1.__exportStar(require("@angular/compiler/src/version"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/template_parser/template_ast"), exports);
    var config_1 = require("@angular/compiler/src/config");
    exports.CompilerConfig = config_1.CompilerConfig;
    exports.preserveWhitespacesDefault = config_1.preserveWhitespacesDefault;
    tslib_1.__exportStar(require("@angular/compiler/src/compile_metadata"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/compiler_factory"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/compiler"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/generated_file"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/formatted_error"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/static_reflector"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/static_symbol"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/static_symbol_resolver"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/aot/summary_resolver"), exports);
    var util_1 = require("@angular/compiler/src/aot/util");
    exports.isLoweredSymbol = util_1.isLoweredSymbol;
    exports.createLoweredSymbol = util_1.createLoweredSymbol;
    tslib_1.__exportStar(require("@angular/compiler/src/ast_path"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/summary_resolver"), exports);
    var identifiers_1 = require("@angular/compiler/src/identifiers");
    exports.Identifiers = identifiers_1.Identifiers;
    var compiler_1 = require("@angular/compiler/src/jit/compiler");
    exports.JitCompiler = compiler_1.JitCompiler;
    tslib_1.__exportStar(require("@angular/compiler/src/compile_reflector"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/url_resolver"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/resource_loader"), exports);
    var constant_pool_1 = require("@angular/compiler/src/constant_pool");
    exports.ConstantPool = constant_pool_1.ConstantPool;
    var directive_resolver_1 = require("@angular/compiler/src/directive_resolver");
    exports.DirectiveResolver = directive_resolver_1.DirectiveResolver;
    var pipe_resolver_1 = require("@angular/compiler/src/pipe_resolver");
    exports.PipeResolver = pipe_resolver_1.PipeResolver;
    var ng_module_resolver_1 = require("@angular/compiler/src/ng_module_resolver");
    exports.NgModuleResolver = ng_module_resolver_1.NgModuleResolver;
    var interpolation_config_1 = require("@angular/compiler/src/ml_parser/interpolation_config");
    exports.DEFAULT_INTERPOLATION_CONFIG = interpolation_config_1.DEFAULT_INTERPOLATION_CONFIG;
    exports.InterpolationConfig = interpolation_config_1.InterpolationConfig;
    tslib_1.__exportStar(require("@angular/compiler/src/schema/element_schema_registry"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/i18n/index"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/directive_normalizer"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/expression_parser/ast"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/expression_parser/lexer"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/expression_parser/parser"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/metadata_resolver"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/ml_parser/ast"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/ml_parser/html_parser"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/ml_parser/html_tags"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/ml_parser/interpolation_config"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/ml_parser/tags"), exports);
    var ng_module_compiler_1 = require("@angular/compiler/src/ng_module_compiler");
    exports.NgModuleCompiler = ng_module_compiler_1.NgModuleCompiler;
    var output_ast_1 = require("@angular/compiler/src/output/output_ast");
    exports.ArrayType = output_ast_1.ArrayType;
    exports.AssertNotNull = output_ast_1.AssertNotNull;
    exports.BinaryOperator = output_ast_1.BinaryOperator;
    exports.BinaryOperatorExpr = output_ast_1.BinaryOperatorExpr;
    exports.BuiltinMethod = output_ast_1.BuiltinMethod;
    exports.BuiltinType = output_ast_1.BuiltinType;
    exports.BuiltinTypeName = output_ast_1.BuiltinTypeName;
    exports.BuiltinVar = output_ast_1.BuiltinVar;
    exports.CastExpr = output_ast_1.CastExpr;
    exports.ClassField = output_ast_1.ClassField;
    exports.ClassMethod = output_ast_1.ClassMethod;
    exports.ClassStmt = output_ast_1.ClassStmt;
    exports.CommaExpr = output_ast_1.CommaExpr;
    exports.CommentStmt = output_ast_1.CommentStmt;
    exports.ConditionalExpr = output_ast_1.ConditionalExpr;
    exports.DeclareFunctionStmt = output_ast_1.DeclareFunctionStmt;
    exports.DeclareVarStmt = output_ast_1.DeclareVarStmt;
    exports.Expression = output_ast_1.Expression;
    exports.ExpressionStatement = output_ast_1.ExpressionStatement;
    exports.ExpressionType = output_ast_1.ExpressionType;
    exports.ExternalExpr = output_ast_1.ExternalExpr;
    exports.ExternalReference = output_ast_1.ExternalReference;
    exports.FunctionExpr = output_ast_1.FunctionExpr;
    exports.IfStmt = output_ast_1.IfStmt;
    exports.InstantiateExpr = output_ast_1.InstantiateExpr;
    exports.InvokeFunctionExpr = output_ast_1.InvokeFunctionExpr;
    exports.InvokeMethodExpr = output_ast_1.InvokeMethodExpr;
    exports.JSDocCommentStmt = output_ast_1.JSDocCommentStmt;
    exports.LiteralArrayExpr = output_ast_1.LiteralArrayExpr;
    exports.LiteralExpr = output_ast_1.LiteralExpr;
    exports.LiteralMapExpr = output_ast_1.LiteralMapExpr;
    exports.MapType = output_ast_1.MapType;
    exports.NotExpr = output_ast_1.NotExpr;
    exports.ReadKeyExpr = output_ast_1.ReadKeyExpr;
    exports.ReadPropExpr = output_ast_1.ReadPropExpr;
    exports.ReadVarExpr = output_ast_1.ReadVarExpr;
    exports.ReturnStatement = output_ast_1.ReturnStatement;
    exports.ThrowStmt = output_ast_1.ThrowStmt;
    exports.TryCatchStmt = output_ast_1.TryCatchStmt;
    exports.Type = output_ast_1.Type;
    exports.WrappedNodeExpr = output_ast_1.WrappedNodeExpr;
    exports.WriteKeyExpr = output_ast_1.WriteKeyExpr;
    exports.WritePropExpr = output_ast_1.WritePropExpr;
    exports.WriteVarExpr = output_ast_1.WriteVarExpr;
    exports.StmtModifier = output_ast_1.StmtModifier;
    exports.Statement = output_ast_1.Statement;
    exports.TypeofExpr = output_ast_1.TypeofExpr;
    exports.collectExternalReferences = output_ast_1.collectExternalReferences;
    var abstract_emitter_1 = require("@angular/compiler/src/output/abstract_emitter");
    exports.EmitterVisitorContext = abstract_emitter_1.EmitterVisitorContext;
    tslib_1.__exportStar(require("@angular/compiler/src/output/ts_emitter"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/parse_util"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/schema/dom_element_schema_registry"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/selector"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/style_compiler"), exports);
    tslib_1.__exportStar(require("@angular/compiler/src/template_parser/template_parser"), exports);
    var view_compiler_1 = require("@angular/compiler/src/view_compiler/view_compiler");
    exports.ViewCompiler = view_compiler_1.ViewCompiler;
    var util_2 = require("@angular/compiler/src/util");
    exports.getParseErrors = util_2.getParseErrors;
    exports.isSyntaxError = util_2.isSyntaxError;
    exports.syntaxError = util_2.syntaxError;
    exports.Version = util_2.Version;
    tslib_1.__exportStar(require("@angular/compiler/src/injectable_compiler_2"), exports);
    var r3_ast_1 = require("@angular/compiler/src/render3/r3_ast");
    exports.TmplAstBoundAttribute = r3_ast_1.BoundAttribute;
    exports.TmplAstBoundEvent = r3_ast_1.BoundEvent;
    exports.TmplAstBoundText = r3_ast_1.BoundText;
    exports.TmplAstContent = r3_ast_1.Content;
    exports.TmplAstElement = r3_ast_1.Element;
    exports.TmplAstReference = r3_ast_1.Reference;
    exports.TmplAstTemplate = r3_ast_1.Template;
    exports.TmplAstText = r3_ast_1.Text;
    exports.TmplAstTextAttribute = r3_ast_1.TextAttribute;
    exports.TmplAstVariable = r3_ast_1.Variable;
    tslib_1.__exportStar(require("@angular/compiler/src/render3/view/t2_binder"), exports);
    var r3_jit_1 = require("@angular/compiler/src/render3/r3_jit");
    exports.jitExpression = r3_jit_1.jitExpression;
    var r3_factory_1 = require("@angular/compiler/src/render3/r3_factory");
    exports.R3ResolvedDependencyType = r3_factory_1.R3ResolvedDependencyType;
    var r3_module_compiler_1 = require("@angular/compiler/src/render3/r3_module_compiler");
    exports.compileInjector = r3_module_compiler_1.compileInjector;
    exports.compileNgModule = r3_module_compiler_1.compileNgModule;
    var r3_pipe_compiler_1 = require("@angular/compiler/src/render3/r3_pipe_compiler");
    exports.compilePipeFromMetadata = r3_pipe_compiler_1.compilePipeFromMetadata;
    var template_1 = require("@angular/compiler/src/render3/view/template");
    exports.makeBindingParser = template_1.makeBindingParser;
    exports.parseTemplate = template_1.parseTemplate;
    var compiler_2 = require("@angular/compiler/src/render3/view/compiler");
    exports.compileBaseDefFromMetadata = compiler_2.compileBaseDefFromMetadata;
    exports.compileComponentFromMetadata = compiler_2.compileComponentFromMetadata;
    exports.compileDirectiveFromMetadata = compiler_2.compileDirectiveFromMetadata;
    exports.parseHostBindings = compiler_2.parseHostBindings;
});
// This file only reexports content of the `src` folder. Keep it that way.
//# sourceMappingURL=data:application/json;base64,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