/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/compiler/src/render3/r3_identifiers", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var CORE = '@angular/core';
    var Identifiers = /** @class */ (function () {
        function Identifiers() {
        }
        /* Methods */
        Identifiers.NEW_METHOD = 'factory';
        Identifiers.TRANSFORM_METHOD = 'transform';
        Identifiers.PATCH_DEPS = 'patchedDeps';
        /* Instructions */
        Identifiers.namespaceHTML = { name: 'ɵnamespaceHTML', moduleName: CORE };
        Identifiers.namespaceMathML = { name: 'ɵnamespaceMathML', moduleName: CORE };
        Identifiers.namespaceSVG = { name: 'ɵnamespaceSVG', moduleName: CORE };
        Identifiers.element = { name: 'ɵelement', moduleName: CORE };
        Identifiers.elementStart = { name: 'ɵelementStart', moduleName: CORE };
        Identifiers.elementEnd = { name: 'ɵelementEnd', moduleName: CORE };
        Identifiers.elementProperty = { name: 'ɵelementProperty', moduleName: CORE };
        Identifiers.elementAttribute = { name: 'ɵelementAttribute', moduleName: CORE };
        Identifiers.elementClassProp = { name: 'ɵelementClassProp', moduleName: CORE };
        Identifiers.elementContainerStart = { name: 'ɵEC', moduleName: CORE };
        Identifiers.elementContainerEnd = { name: 'ɵeC', moduleName: CORE };
        Identifiers.elementStyling = { name: 'ɵelementStyling', moduleName: CORE };
        Identifiers.elementStylingMap = { name: 'ɵelementStylingMap', moduleName: CORE };
        Identifiers.elementStyleProp = { name: 'ɵelementStyleProp', moduleName: CORE };
        Identifiers.elementStylingApply = { name: 'ɵelementStylingApply', moduleName: CORE };
        Identifiers.containerCreate = { name: 'ɵcontainer', moduleName: CORE };
        Identifiers.nextContext = { name: 'ɵnextContext', moduleName: CORE };
        Identifiers.templateCreate = { name: 'ɵtemplate', moduleName: CORE };
        Identifiers.text = { name: 'ɵtext', moduleName: CORE };
        Identifiers.textBinding = { name: 'ɵtextBinding', moduleName: CORE };
        Identifiers.bind = { name: 'ɵbind', moduleName: CORE };
        Identifiers.enableBindings = { name: 'ɵenableBindings', moduleName: CORE };
        Identifiers.disableBindings = { name: 'ɵdisableBindings', moduleName: CORE };
        Identifiers.getCurrentView = { name: 'ɵgetCurrentView', moduleName: CORE };
        Identifiers.restoreView = { name: 'ɵrestoreView', moduleName: CORE };
        Identifiers.interpolation1 = { name: 'ɵinterpolation1', moduleName: CORE };
        Identifiers.interpolation2 = { name: 'ɵinterpolation2', moduleName: CORE };
        Identifiers.interpolation3 = { name: 'ɵinterpolation3', moduleName: CORE };
        Identifiers.interpolation4 = { name: 'ɵinterpolation4', moduleName: CORE };
        Identifiers.interpolation5 = { name: 'ɵinterpolation5', moduleName: CORE };
        Identifiers.interpolation6 = { name: 'ɵinterpolation6', moduleName: CORE };
        Identifiers.interpolation7 = { name: 'ɵinterpolation7', moduleName: CORE };
        Identifiers.interpolation8 = { name: 'ɵinterpolation8', moduleName: CORE };
        Identifiers.interpolationV = { name: 'ɵinterpolationV', moduleName: CORE };
        Identifiers.pureFunction0 = { name: 'ɵpureFunction0', moduleName: CORE };
        Identifiers.pureFunction1 = { name: 'ɵpureFunction1', moduleName: CORE };
        Identifiers.pureFunction2 = { name: 'ɵpureFunction2', moduleName: CORE };
        Identifiers.pureFunction3 = { name: 'ɵpureFunction3', moduleName: CORE };
        Identifiers.pureFunction4 = { name: 'ɵpureFunction4', moduleName: CORE };
        Identifiers.pureFunction5 = { name: 'ɵpureFunction5', moduleName: CORE };
        Identifiers.pureFunction6 = { name: 'ɵpureFunction6', moduleName: CORE };
        Identifiers.pureFunction7 = { name: 'ɵpureFunction7', moduleName: CORE };
        Identifiers.pureFunction8 = { name: 'ɵpureFunction8', moduleName: CORE };
        Identifiers.pureFunctionV = { name: 'ɵpureFunctionV', moduleName: CORE };
        Identifiers.pipeBind1 = { name: 'ɵpipeBind1', moduleName: CORE };
        Identifiers.pipeBind2 = { name: 'ɵpipeBind2', moduleName: CORE };
        Identifiers.pipeBind3 = { name: 'ɵpipeBind3', moduleName: CORE };
        Identifiers.pipeBind4 = { name: 'ɵpipeBind4', moduleName: CORE };
        Identifiers.pipeBindV = { name: 'ɵpipeBindV', moduleName: CORE };
        Identifiers.i18nAttribute = { name: 'ɵi18nAttribute', moduleName: CORE };
        Identifiers.i18nExp = { name: 'ɵi18nExp', moduleName: CORE };
        Identifiers.i18nStart = { name: 'ɵi18nStart', moduleName: CORE };
        Identifiers.i18nEnd = { name: 'ɵi18nEnd', moduleName: CORE };
        Identifiers.i18nApply = { name: 'ɵi18nApply', moduleName: CORE };
        Identifiers.load = { name: 'ɵload', moduleName: CORE };
        Identifiers.loadQueryList = { name: 'ɵloadQueryList', moduleName: CORE };
        Identifiers.pipe = { name: 'ɵpipe', moduleName: CORE };
        Identifiers.projection = { name: 'ɵprojection', moduleName: CORE };
        Identifiers.projectionDef = { name: 'ɵprojectionDef', moduleName: CORE };
        Identifiers.reference = { name: 'ɵreference', moduleName: CORE };
        Identifiers.inject = { name: 'inject', moduleName: CORE };
        Identifiers.injectAttribute = { name: 'ɵinjectAttribute', moduleName: CORE };
        Identifiers.directiveInject = { name: 'ɵdirectiveInject', moduleName: CORE };
        Identifiers.templateRefExtractor = { name: 'ɵtemplateRefExtractor', moduleName: CORE };
        Identifiers.defineBase = { name: 'ɵdefineBase', moduleName: CORE };
        Identifiers.BaseDef = {
            name: 'ɵBaseDef',
            moduleName: CORE,
        };
        Identifiers.defineComponent = { name: 'ɵdefineComponent', moduleName: CORE };
        Identifiers.ComponentDefWithMeta = {
            name: 'ɵComponentDefWithMeta',
            moduleName: CORE,
        };
        Identifiers.defineDirective = {
            name: 'ɵdefineDirective',
            moduleName: CORE,
        };
        Identifiers.DirectiveDefWithMeta = {
            name: 'ɵDirectiveDefWithMeta',
            moduleName: CORE,
        };
        Identifiers.InjectorDef = {
            name: 'ɵInjectorDef',
            moduleName: CORE,
        };
        Identifiers.defineInjector = {
            name: 'defineInjector',
            moduleName: CORE,
        };
        Identifiers.NgModuleDefWithMeta = {
            name: 'ɵNgModuleDefWithMeta',
            moduleName: CORE,
        };
        Identifiers.defineNgModule = { name: 'ɵdefineNgModule', moduleName: CORE };
        Identifiers.PipeDefWithMeta = { name: 'ɵPipeDefWithMeta', moduleName: CORE };
        Identifiers.definePipe = { name: 'ɵdefinePipe', moduleName: CORE };
        Identifiers.query = { name: 'ɵquery', moduleName: CORE };
        Identifiers.queryRefresh = { name: 'ɵqueryRefresh', moduleName: CORE };
        Identifiers.registerContentQuery = { name: 'ɵregisterContentQuery', moduleName: CORE };
        Identifiers.NgOnChangesFeature = { name: 'ɵNgOnChangesFeature', moduleName: CORE };
        Identifiers.InheritDefinitionFeature = { name: 'ɵInheritDefinitionFeature', moduleName: CORE };
        Identifiers.ProvidersFeature = { name: 'ɵProvidersFeature', moduleName: CORE };
        Identifiers.listener = { name: 'ɵlistener', moduleName: CORE };
        Identifiers.getFactoryOf = {
            name: 'ɵgetFactoryOf',
            moduleName: CORE,
        };
        Identifiers.getInheritedFactory = {
            name: 'ɵgetInheritedFactory',
            moduleName: CORE,
        };
        // sanitization-related functions
        Identifiers.sanitizeHtml = { name: 'ɵsanitizeHtml', moduleName: CORE };
        Identifiers.sanitizeStyle = { name: 'ɵsanitizeStyle', moduleName: CORE };
        Identifiers.defaultStyleSanitizer = { name: 'ɵdefaultStyleSanitizer', moduleName: CORE };
        Identifiers.sanitizeResourceUrl = { name: 'ɵsanitizeResourceUrl', moduleName: CORE };
        Identifiers.sanitizeScript = { name: 'ɵsanitizeScript', moduleName: CORE };
        Identifiers.sanitizeUrl = { name: 'ɵsanitizeUrl', moduleName: CORE };
        return Identifiers;
    }());
    exports.Identifiers = Identifiers;
});
//# sourceMappingURL=data:application/json;base64,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