/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
import { Directive, Host, Inject, Input, Optional, Self, SkipSelf, forwardRef } from '@angular/core';
import { NG_ASYNC_VALIDATORS, NG_VALIDATORS } from '../validators';
import { AbstractFormGroupDirective } from './abstract_form_group_directive';
import { ControlContainer } from './control_container';
import { NgForm } from './ng_form';
import { TemplateDrivenErrors } from './template_driven_errors';
export var modelGroupProvider = {
    provide: ControlContainer,
    useExisting: forwardRef(function () { return NgModelGroup; })
};
/**
 * Creates and binds a model group to a DOM element.
 *
 * This directive can only be used as a child of {@link NgForm}.
 *
 * ```typescript
 * @Component({
 *   selector: 'my-app',
 *   template: `
 *     <div>
 *       <h2>Angular forms Example</h2>
 *       <form #f="ngForm">
 *         <div ngModelGroup="name" #mgName="ngModelGroup">
 *           <h3>Enter your name:</h3>
 *           <p>First: <input name="first" ngModel required></p>
 *           <p>Middle: <input name="middle" ngModel></p>
 *           <p>Last: <input name="last" ngModel required></p>
 *         </div>
 *         <h3>Name value:</h3>
 *         <pre>{{ mgName.value | json }}</pre>
 *         <p>Name is {{mgName?.valid ? "valid" : "invalid"}}</p>
 *         <h3>What's your favorite food?</h3>
 *         <p><input name="food" ngModel></p>
 *         <h3>Form value</h3>
 *         <pre>{{ f.value | json }}</pre>
 *       </form>
 *     </div>
 *   `
 * })
 * export class App {}
 * ```
 *
 * This example declares a model group for a user's name. The value and validation state of
 * this group can be accessed separately from the overall form.
 *
 * @stable
 */
export var NgModelGroup = (function (_super) {
    __extends(NgModelGroup, _super);
    function NgModelGroup(parent, validators, asyncValidators) {
        _super.call(this);
        this._parent = parent;
        this._validators = validators;
        this._asyncValidators = asyncValidators;
    }
    /** @internal */
    NgModelGroup.prototype._checkParentType = function () {
        if (!(this._parent instanceof NgModelGroup) && !(this._parent instanceof NgForm)) {
            TemplateDrivenErrors.modelGroupParentException();
        }
    };
    NgModelGroup.decorators = [
        { type: Directive, args: [{ selector: '[ngModelGroup]', providers: [modelGroupProvider], exportAs: 'ngModelGroup' },] },
    ];
    /** @nocollapse */
    NgModelGroup.ctorParameters = [
        { type: ControlContainer, decorators: [{ type: Host }, { type: SkipSelf },] },
        { type: Array, decorators: [{ type: Optional }, { type: Self }, { type: Inject, args: [NG_VALIDATORS,] },] },
        { type: Array, decorators: [{ type: Optional }, { type: Self }, { type: Inject, args: [NG_ASYNC_VALIDATORS,] },] },
    ];
    NgModelGroup.propDecorators = {
        'name': [{ type: Input, args: ['ngModelGroup',] },],
    };
    return NgModelGroup;
}(AbstractFormGroupDirective));
//# sourceMappingURL=ng_model_group.js.map