/**
 * @license Angular v2.3.0
 * (c) 2010-2016 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/core"),require("rxjs/operator/toPromise"),require("rxjs/Subject"),require("rxjs/Observable"),require("rxjs/observable/fromPromise")):"function"==typeof define&&define.amd?define(["exports","@angular/core","rxjs/operator/toPromise","rxjs/Subject","rxjs/Observable","rxjs/observable/fromPromise"],factory):factory((global.ng=global.ng||{},global.ng.forms=global.ng.forms||{}),global.ng.core,global.Rx.Observable.prototype,global.Rx,global.Rx,global.Rx.Observable)}(this,function(exports,_angular_core,rxjs_operator_toPromise,rxjs_Subject,rxjs_Observable,rxjs_observable_fromPromise){"use strict";function isPresent(obj){return null!=obj}function isBlank(obj){return null==obj}function looseIdentical(a,b){return a===b||"number"==typeof a&&"number"==typeof b&&isNaN(a)&&isNaN(b)}function isJsObject(o){return null!==o&&("function"==typeof o||"object"==typeof o)}function isPrimitive(obj){return!isJsObject(obj)}function isEmptyInputValue(value){return null==value||"string"==typeof value&&0===value.length}function _convertToPromise(obj){return isPromise(obj)?obj:rxjs_operator_toPromise.toPromise.call(obj)}function _executeValidators(control,validators){return validators.map(function(v){return v(control)})}function _executeAsyncValidators(control,validators){return validators.map(function(v){return v(control)})}function _mergeErrors(arrayOfErrors){var res=arrayOfErrors.reduce(function(res,errors){return isPresent(errors)?StringMapWrapper.merge(res,errors):res},{});return 0===Object.keys(res).length?null:res}/**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
function normalizeValidator(validator){return validator.validate?function(c){return validator.validate(c)}:validator}function normalizeAsyncValidator(validator){return validator.validate?function(c){return validator.validate(c)}:validator}function unimplemented(){throw new Error("unimplemented")}function _buildValueString(id,value){return null==id?""+value:(isPrimitive(value)||(value="Object"),(id+": "+value).slice(0,50))}function _extractId(valueString){return valueString.split(":")[0]}function _buildValueString$1(id,value){return null==id?""+value:("string"==typeof value&&(value="'"+value+"'"),isPrimitive(value)||(value="Object"),(id+": "+value).slice(0,50))}function _extractId$1(valueString){return valueString.split(":")[0]}function controlPath(name,parent){return parent.path.concat([name])}function setUpControl(control,dir){control||_throwError(dir,"Cannot find control with"),dir.valueAccessor||_throwError(dir,"No value accessor for form control with"),control.validator=Validators.compose([control.validator,dir.validator]),control.asyncValidator=Validators.composeAsync([control.asyncValidator,dir.asyncValidator]),dir.valueAccessor.writeValue(control.value),dir.valueAccessor.registerOnChange(function(newValue){dir.viewToModelUpdate(newValue),control.markAsDirty(),control.setValue(newValue,{emitModelToViewChange:!1})}),dir.valueAccessor.registerOnTouched(function(){return control.markAsTouched()}),control.registerOnChange(function(newValue,emitModelEvent){dir.valueAccessor.writeValue(newValue),emitModelEvent&&dir.viewToModelUpdate(newValue)}),dir.valueAccessor.setDisabledState&&control.registerOnDisabledChange(function(isDisabled){dir.valueAccessor.setDisabledState(isDisabled)}),dir._rawValidators.forEach(function(validator){validator.registerOnValidatorChange&&validator.registerOnValidatorChange(function(){return control.updateValueAndValidity()})}),dir._rawAsyncValidators.forEach(function(validator){validator.registerOnValidatorChange&&validator.registerOnValidatorChange(function(){return control.updateValueAndValidity()})})}function cleanUpControl(control,dir){dir.valueAccessor.registerOnChange(function(){return _noControlError(dir)}),dir.valueAccessor.registerOnTouched(function(){return _noControlError(dir)}),dir._rawValidators.forEach(function(validator){validator.registerOnValidatorChange&&validator.registerOnValidatorChange(null)}),dir._rawAsyncValidators.forEach(function(validator){validator.registerOnValidatorChange&&validator.registerOnValidatorChange(null)}),control&&control._clearChangeFns()}function setUpFormContainer(control,dir){isBlank(control)&&_throwError(dir,"Cannot find control with"),control.validator=Validators.compose([control.validator,dir.validator]),control.asyncValidator=Validators.composeAsync([control.asyncValidator,dir.asyncValidator])}function _noControlError(dir){return _throwError(dir,"There is no FormControl instance attached to form control element with")}function _throwError(dir,message){var messageEnd;throw messageEnd=dir.path.length>1?"path: '"+dir.path.join(" -> ")+"'":dir.path[0]?"name: '"+dir.path+"'":"unspecified name attribute",new Error(message+" "+messageEnd)}function composeValidators(validators){return isPresent(validators)?Validators.compose(validators.map(normalizeValidator)):null}function composeAsyncValidators(validators){return isPresent(validators)?Validators.composeAsync(validators.map(normalizeAsyncValidator)):null}function isPropertyUpdated(changes,viewModel){if(!changes.hasOwnProperty("model"))return!1;var change=changes.model;return!!change.isFirstChange()||!looseIdentical(viewModel,change.currentValue)}function isBuiltInAccessor(valueAccessor){return BUILTIN_ACCESSORS.some(function(a){return valueAccessor.constructor===a})}function selectValueAccessor(dir,valueAccessors){if(!valueAccessors)return null;var defaultAccessor,builtinAccessor,customAccessor;return valueAccessors.forEach(function(v){v.constructor===DefaultValueAccessor?defaultAccessor=v:isBuiltInAccessor(v)?(builtinAccessor&&_throwError(dir,"More than one built-in value accessor matches form control with"),builtinAccessor=v):(customAccessor&&_throwError(dir,"More than one custom value accessor matches form control with"),customAccessor=v)}),customAccessor?customAccessor:builtinAccessor?builtinAccessor:defaultAccessor?defaultAccessor:(_throwError(dir,"No valid value accessor for form control with"),null)}function _find(control,path,delimiter){return null==path?null:(path instanceof Array||(path=path.split(delimiter)),path instanceof Array&&0===path.length?null:path.reduce(function(v,name){return v instanceof FormGroup?v.controls[name]||null:v instanceof FormArray?v.at(name)||null:null},control))}function toObservable(r){return isPromise(r)?rxjs_observable_fromPromise.fromPromise(r):r}function coerceToValidator(validator){return Array.isArray(validator)?composeValidators(validator):validator}function coerceToAsyncValidator(asyncValidator){return Array.isArray(asyncValidator)?composeAsyncValidators(asyncValidator):asyncValidator}function _hasInvalidParent(parent){return!(parent instanceof FormGroupName||parent instanceof FormGroupDirective||parent instanceof FormArrayName)}/**
     * @license
     * Copyright Google Inc. All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
var AbstractControlDirective=function(){function AbstractControlDirective(){}return Object.defineProperty(AbstractControlDirective.prototype,"control",{get:function(){throw new Error("unimplemented")},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"value",{get:function(){return this.control?this.control.value:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"valid",{get:function(){return this.control?this.control.valid:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"invalid",{get:function(){return this.control?this.control.invalid:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"pending",{get:function(){return this.control?this.control.pending:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"errors",{get:function(){return this.control?this.control.errors:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"pristine",{get:function(){return this.control?this.control.pristine:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"dirty",{get:function(){return this.control?this.control.dirty:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"touched",{get:function(){return this.control?this.control.touched:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"untouched",{get:function(){return this.control?this.control.untouched:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"disabled",{get:function(){return this.control?this.control.disabled:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"enabled",{get:function(){return this.control?this.control.enabled:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"statusChanges",{get:function(){return this.control?this.control.statusChanges:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"valueChanges",{get:function(){return this.control?this.control.valueChanges:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlDirective.prototype,"path",{get:function(){return null},enumerable:!0,configurable:!0}),AbstractControlDirective.prototype.reset=function(value){void 0===value&&(value=void 0),this.control&&this.control.reset(value)},AbstractControlDirective.prototype.hasError=function(errorCode,path){return void 0===path&&(path=null),!!this.control&&this.control.hasError(errorCode,path)},AbstractControlDirective.prototype.getError=function(errorCode,path){return void 0===path&&(path=null),this.control?this.control.getError(errorCode,path):null},AbstractControlDirective}(),__extends$1=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},ControlContainer=function(_super){function ControlContainer(){_super.apply(this,arguments)}return __extends$1(ControlContainer,_super),Object.defineProperty(ControlContainer.prototype,"formDirective",{get:function(){return null},enumerable:!0,configurable:!0}),Object.defineProperty(ControlContainer.prototype,"path",{get:function(){return null},enumerable:!0,configurable:!0}),ControlContainer}(AbstractControlDirective),StringMapWrapper=function(){function StringMapWrapper(){}return StringMapWrapper.merge=function(m1,m2){for(var m={},_i=0,_a=Object.keys(m1);_i<_a.length;_i++){var k=_a[_i];m[k]=m1[k]}for(var _b=0,_c=Object.keys(m2);_b<_c.length;_b++){var k=_c[_b];m[k]=m2[k]}return m},StringMapWrapper.equals=function(m1,m2){var k1=Object.keys(m1),k2=Object.keys(m2);if(k1.length!=k2.length)return!1;for(var i=0;i<k1.length;i++){var key=k1[i];if(m1[key]!==m2[key])return!1}return!0},StringMapWrapper}(),ListWrapper=function(){function ListWrapper(){}return ListWrapper.findLast=function(arr,condition){for(var i=arr.length-1;i>=0;i--)if(condition(arr[i]))return arr[i];return null},ListWrapper.removeAll=function(list,items){for(var i=0;i<items.length;++i){var index=list.indexOf(items[i]);index>-1&&list.splice(index,1)}},ListWrapper.remove=function(list,el){var index=list.indexOf(el);return index>-1&&(list.splice(index,1),!0)},ListWrapper.equals=function(a,b){if(a.length!=b.length)return!1;for(var i=0;i<a.length;++i)if(a[i]!==b[i])return!1;return!0},ListWrapper.flatten=function(list){return list.reduce(function(flat,item){var flatItem=Array.isArray(item)?ListWrapper.flatten(item):item;return flat.concat(flatItem)},[])},ListWrapper}(),isPromise=_angular_core.__core_private__.isPromise,NG_VALIDATORS=new _angular_core.OpaqueToken("NgValidators"),NG_ASYNC_VALIDATORS=new _angular_core.OpaqueToken("NgAsyncValidators"),Validators=function(){function Validators(){}return Validators.required=function(control){return isEmptyInputValue(control.value)?{required:!0}:null},Validators.minLength=function(minLength){return function(control){if(isEmptyInputValue(control.value))return null;var length="string"==typeof control.value?control.value.length:0;return length<minLength?{minlength:{requiredLength:minLength,actualLength:length}}:null}},Validators.maxLength=function(maxLength){return function(control){var length="string"==typeof control.value?control.value.length:0;return length>maxLength?{maxlength:{requiredLength:maxLength,actualLength:length}}:null}},Validators.pattern=function(pattern){if(!pattern)return Validators.nullValidator;var regex,regexStr;return"string"==typeof pattern?(regexStr="^"+pattern+"$",regex=new RegExp(regexStr)):(regexStr=pattern.toString(),regex=pattern),function(control){if(isEmptyInputValue(control.value))return null;var value=control.value;return regex.test(value)?null:{pattern:{requiredPattern:regexStr,actualValue:value}}}},Validators.nullValidator=function(c){return null},Validators.compose=function(validators){if(!validators)return null;var presentValidators=validators.filter(isPresent);return 0==presentValidators.length?null:function(control){return _mergeErrors(_executeValidators(control,presentValidators))}},Validators.composeAsync=function(validators){if(!validators)return null;var presentValidators=validators.filter(isPresent);return 0==presentValidators.length?null:function(control){var promises=_executeAsyncValidators(control,presentValidators).map(_convertToPromise);return Promise.all(promises).then(_mergeErrors)}},Validators}(),NG_VALUE_ACCESSOR=new _angular_core.OpaqueToken("NgValueAccessor"),CHECKBOX_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:_angular_core.forwardRef(function(){return CheckboxControlValueAccessor}),multi:!0},CheckboxControlValueAccessor=function(){function CheckboxControlValueAccessor(_renderer,_elementRef){this._renderer=_renderer,this._elementRef=_elementRef,this.onChange=function(_){},this.onTouched=function(){}}return CheckboxControlValueAccessor.prototype.writeValue=function(value){this._renderer.setElementProperty(this._elementRef.nativeElement,"checked",value)},CheckboxControlValueAccessor.prototype.registerOnChange=function(fn){this.onChange=fn},CheckboxControlValueAccessor.prototype.registerOnTouched=function(fn){this.onTouched=fn},CheckboxControlValueAccessor.prototype.setDisabledState=function(isDisabled){this._renderer.setElementProperty(this._elementRef.nativeElement,"disabled",isDisabled)},CheckboxControlValueAccessor.decorators=[{type:_angular_core.Directive,args:[{selector:"input[type=checkbox][formControlName],input[type=checkbox][formControl],input[type=checkbox][ngModel]",host:{"(change)":"onChange($event.target.checked)","(blur)":"onTouched()"},providers:[CHECKBOX_VALUE_ACCESSOR]}]}],CheckboxControlValueAccessor.ctorParameters=function(){return[{type:_angular_core.Renderer},{type:_angular_core.ElementRef}]},CheckboxControlValueAccessor}(),DEFAULT_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:_angular_core.forwardRef(function(){return DefaultValueAccessor}),multi:!0},DefaultValueAccessor=function(){function DefaultValueAccessor(_renderer,_elementRef){this._renderer=_renderer,this._elementRef=_elementRef,this.onChange=function(_){},this.onTouched=function(){}}return DefaultValueAccessor.prototype.writeValue=function(value){var normalizedValue=null==value?"":value;this._renderer.setElementProperty(this._elementRef.nativeElement,"value",normalizedValue)},DefaultValueAccessor.prototype.registerOnChange=function(fn){this.onChange=fn},DefaultValueAccessor.prototype.registerOnTouched=function(fn){this.onTouched=fn},DefaultValueAccessor.prototype.setDisabledState=function(isDisabled){this._renderer.setElementProperty(this._elementRef.nativeElement,"disabled",isDisabled)},DefaultValueAccessor.decorators=[{type:_angular_core.Directive,args:[{selector:"input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]",host:{"(input)":"onChange($event.target.value)","(blur)":"onTouched()"},providers:[DEFAULT_VALUE_ACCESSOR]}]}],DefaultValueAccessor.ctorParameters=function(){return[{type:_angular_core.Renderer},{type:_angular_core.ElementRef}]},DefaultValueAccessor}(),NUMBER_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:_angular_core.forwardRef(function(){return NumberValueAccessor}),multi:!0},NumberValueAccessor=function(){function NumberValueAccessor(_renderer,_elementRef){this._renderer=_renderer,this._elementRef=_elementRef,this.onChange=function(_){},this.onTouched=function(){}}return NumberValueAccessor.prototype.writeValue=function(value){var normalizedValue=null==value?"":value;this._renderer.setElementProperty(this._elementRef.nativeElement,"value",normalizedValue)},NumberValueAccessor.prototype.registerOnChange=function(fn){this.onChange=function(value){fn(""==value?null:parseFloat(value))}},NumberValueAccessor.prototype.registerOnTouched=function(fn){this.onTouched=fn},NumberValueAccessor.prototype.setDisabledState=function(isDisabled){this._renderer.setElementProperty(this._elementRef.nativeElement,"disabled",isDisabled)},NumberValueAccessor.decorators=[{type:_angular_core.Directive,args:[{selector:"input[type=number][formControlName],input[type=number][formControl],input[type=number][ngModel]",host:{"(change)":"onChange($event.target.value)","(input)":"onChange($event.target.value)","(blur)":"onTouched()"},providers:[NUMBER_VALUE_ACCESSOR]}]}],NumberValueAccessor.ctorParameters=function(){return[{type:_angular_core.Renderer},{type:_angular_core.ElementRef}]},NumberValueAccessor}(),__extends$2=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},NgControl=function(_super){function NgControl(){_super.apply(this,arguments),this._parent=null,this.name=null,this.valueAccessor=null,this._rawValidators=[],this._rawAsyncValidators=[]}return __extends$2(NgControl,_super),Object.defineProperty(NgControl.prototype,"validator",{get:function(){return unimplemented()},enumerable:!0,configurable:!0}),Object.defineProperty(NgControl.prototype,"asyncValidator",{get:function(){return unimplemented()},enumerable:!0,configurable:!0}),NgControl.prototype.viewToModelUpdate=function(newValue){},NgControl}(AbstractControlDirective),RADIO_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:_angular_core.forwardRef(function(){return RadioControlValueAccessor}),multi:!0},RadioControlRegistry=function(){function RadioControlRegistry(){this._accessors=[]}return RadioControlRegistry.prototype.add=function(control,accessor){this._accessors.push([control,accessor])},RadioControlRegistry.prototype.remove=function(accessor){for(var i=this._accessors.length-1;i>=0;--i)if(this._accessors[i][1]===accessor)return void this._accessors.splice(i,1)},RadioControlRegistry.prototype.select=function(accessor){var _this=this;this._accessors.forEach(function(c){_this._isSameGroup(c,accessor)&&c[1]!==accessor&&c[1].fireUncheck(accessor.value)})},RadioControlRegistry.prototype._isSameGroup=function(controlPair,accessor){return!!controlPair[0].control&&(controlPair[0]._parent===accessor._control._parent&&controlPair[1].name===accessor.name)},RadioControlRegistry.decorators=[{type:_angular_core.Injectable}],RadioControlRegistry.ctorParameters=function(){return[]},RadioControlRegistry}(),RadioControlValueAccessor=function(){function RadioControlValueAccessor(_renderer,_elementRef,_registry,_injector){this._renderer=_renderer,this._elementRef=_elementRef,this._registry=_registry,this._injector=_injector,this.onChange=function(){},this.onTouched=function(){}}return RadioControlValueAccessor.prototype.ngOnInit=function(){this._control=this._injector.get(NgControl),this._checkName(),this._registry.add(this._control,this)},RadioControlValueAccessor.prototype.ngOnDestroy=function(){this._registry.remove(this)},RadioControlValueAccessor.prototype.writeValue=function(value){this._state=value===this.value,this._renderer.setElementProperty(this._elementRef.nativeElement,"checked",this._state)},RadioControlValueAccessor.prototype.registerOnChange=function(fn){var _this=this;this._fn=fn,this.onChange=function(){fn(_this.value),_this._registry.select(_this)}},RadioControlValueAccessor.prototype.fireUncheck=function(value){this.writeValue(value)},RadioControlValueAccessor.prototype.registerOnTouched=function(fn){this.onTouched=fn},RadioControlValueAccessor.prototype.setDisabledState=function(isDisabled){this._renderer.setElementProperty(this._elementRef.nativeElement,"disabled",isDisabled)},RadioControlValueAccessor.prototype._checkName=function(){this.name&&this.formControlName&&this.name!==this.formControlName&&this._throwNameError(),!this.name&&this.formControlName&&(this.name=this.formControlName)},RadioControlValueAccessor.prototype._throwNameError=function(){throw new Error('\n      If you define both a name and a formControlName attribute on your radio button, their values\n      must match. Ex: <input type="radio" formControlName="food" name="food">\n    ')},RadioControlValueAccessor.decorators=[{type:_angular_core.Directive,args:[{selector:"input[type=radio][formControlName],input[type=radio][formControl],input[type=radio][ngModel]",host:{"(change)":"onChange()","(blur)":"onTouched()"},providers:[RADIO_VALUE_ACCESSOR]}]}],RadioControlValueAccessor.ctorParameters=function(){return[{type:_angular_core.Renderer},{type:_angular_core.ElementRef},{type:RadioControlRegistry},{type:_angular_core.Injector}]},RadioControlValueAccessor.propDecorators={name:[{type:_angular_core.Input}],formControlName:[{type:_angular_core.Input}],value:[{type:_angular_core.Input}]},RadioControlValueAccessor}(),RANGE_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:_angular_core.forwardRef(function(){return RangeValueAccessor}),multi:!0},RangeValueAccessor=function(){function RangeValueAccessor(_renderer,_elementRef){this._renderer=_renderer,this._elementRef=_elementRef,this.onChange=function(_){},this.onTouched=function(){}}return RangeValueAccessor.prototype.writeValue=function(value){this._renderer.setElementProperty(this._elementRef.nativeElement,"value",parseFloat(value))},RangeValueAccessor.prototype.registerOnChange=function(fn){this.onChange=function(value){fn(""==value?null:parseFloat(value))}},RangeValueAccessor.prototype.registerOnTouched=function(fn){this.onTouched=fn},RangeValueAccessor.prototype.setDisabledState=function(isDisabled){this._renderer.setElementProperty(this._elementRef.nativeElement,"disabled",isDisabled)},RangeValueAccessor.decorators=[{type:_angular_core.Directive,args:[{selector:"input[type=range][formControlName],input[type=range][formControl],input[type=range][ngModel]",host:{"(change)":"onChange($event.target.value)","(input)":"onChange($event.target.value)","(blur)":"onTouched()"},providers:[RANGE_VALUE_ACCESSOR]}]}],RangeValueAccessor.ctorParameters=function(){return[{type:_angular_core.Renderer},{type:_angular_core.ElementRef}]},RangeValueAccessor}(),SELECT_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:_angular_core.forwardRef(function(){return SelectControlValueAccessor}),multi:!0},SelectControlValueAccessor=function(){function SelectControlValueAccessor(_renderer,_elementRef){this._renderer=_renderer,this._elementRef=_elementRef,this._optionMap=new Map,this._idCounter=0,this.onChange=function(_){},this.onTouched=function(){}}return SelectControlValueAccessor.prototype.writeValue=function(value){this.value=value;var valueString=_buildValueString(this._getOptionId(value),value);this._renderer.setElementProperty(this._elementRef.nativeElement,"value",valueString)},SelectControlValueAccessor.prototype.registerOnChange=function(fn){var _this=this;this.onChange=function(valueString){_this.value=valueString,fn(_this._getOptionValue(valueString))}},SelectControlValueAccessor.prototype.registerOnTouched=function(fn){this.onTouched=fn},SelectControlValueAccessor.prototype.setDisabledState=function(isDisabled){this._renderer.setElementProperty(this._elementRef.nativeElement,"disabled",isDisabled)},SelectControlValueAccessor.prototype._registerOption=function(){return(this._idCounter++).toString()},SelectControlValueAccessor.prototype._getOptionId=function(value){for(var _i=0,_a=Array.from(this._optionMap.keys());_i<_a.length;_i++){var id=_a[_i];if(looseIdentical(this._optionMap.get(id),value))return id}return null},SelectControlValueAccessor.prototype._getOptionValue=function(valueString){var id=_extractId(valueString);return this._optionMap.has(id)?this._optionMap.get(id):valueString},SelectControlValueAccessor.decorators=[{type:_angular_core.Directive,args:[{selector:"select:not([multiple])[formControlName],select:not([multiple])[formControl],select:not([multiple])[ngModel]",host:{"(change)":"onChange($event.target.value)","(blur)":"onTouched()"},providers:[SELECT_VALUE_ACCESSOR]}]}],SelectControlValueAccessor.ctorParameters=function(){return[{type:_angular_core.Renderer},{type:_angular_core.ElementRef}]},SelectControlValueAccessor}(),NgSelectOption=function(){function NgSelectOption(_element,_renderer,_select){this._element=_element,this._renderer=_renderer,this._select=_select,this._select&&(this.id=this._select._registerOption())}return Object.defineProperty(NgSelectOption.prototype,"ngValue",{set:function(value){null!=this._select&&(this._select._optionMap.set(this.id,value),this._setElementValue(_buildValueString(this.id,value)),this._select.writeValue(this._select.value))},enumerable:!0,configurable:!0}),Object.defineProperty(NgSelectOption.prototype,"value",{set:function(value){this._setElementValue(value),this._select&&this._select.writeValue(this._select.value)},enumerable:!0,configurable:!0}),NgSelectOption.prototype._setElementValue=function(value){this._renderer.setElementProperty(this._element.nativeElement,"value",value)},NgSelectOption.prototype.ngOnDestroy=function(){this._select&&(this._select._optionMap.delete(this.id),this._select.writeValue(this._select.value))},NgSelectOption.decorators=[{type:_angular_core.Directive,args:[{selector:"option"}]}],NgSelectOption.ctorParameters=function(){return[{type:_angular_core.ElementRef},{type:_angular_core.Renderer},{type:SelectControlValueAccessor,decorators:[{type:_angular_core.Optional},{type:_angular_core.Host}]}]},NgSelectOption.propDecorators={ngValue:[{type:_angular_core.Input,args:["ngValue"]}],value:[{type:_angular_core.Input,args:["value"]}]},NgSelectOption}(),SELECT_MULTIPLE_VALUE_ACCESSOR={provide:NG_VALUE_ACCESSOR,useExisting:_angular_core.forwardRef(function(){return SelectMultipleControlValueAccessor}),multi:!0},SelectMultipleControlValueAccessor=function(){function SelectMultipleControlValueAccessor(_renderer,_elementRef){this._renderer=_renderer,this._elementRef=_elementRef,this._optionMap=new Map,this._idCounter=0,this.onChange=function(_){},this.onTouched=function(){}}return SelectMultipleControlValueAccessor.prototype.writeValue=function(value){var _this=this;if(this.value=value,null!=value){var values=value,ids=values.map(function(v){return _this._getOptionId(v)});this._optionMap.forEach(function(opt,o){opt._setSelected(ids.indexOf(o.toString())>-1)})}},SelectMultipleControlValueAccessor.prototype.registerOnChange=function(fn){var _this=this;this.onChange=function(_){var selected=[];if(_.hasOwnProperty("selectedOptions"))for(var options=_.selectedOptions,i=0;i<options.length;i++){var opt=options.item(i),val=_this._getOptionValue(opt.value);selected.push(val)}else for(var options=_.options,i=0;i<options.length;i++){var opt=options.item(i);if(opt.selected){var val=_this._getOptionValue(opt.value);selected.push(val)}}fn(selected)}},SelectMultipleControlValueAccessor.prototype.registerOnTouched=function(fn){this.onTouched=fn},SelectMultipleControlValueAccessor.prototype.setDisabledState=function(isDisabled){this._renderer.setElementProperty(this._elementRef.nativeElement,"disabled",isDisabled)},SelectMultipleControlValueAccessor.prototype._registerOption=function(value){var id=(this._idCounter++).toString();return this._optionMap.set(id,value),id},SelectMultipleControlValueAccessor.prototype._getOptionId=function(value){for(var _i=0,_a=Array.from(this._optionMap.keys());_i<_a.length;_i++){var id=_a[_i];if(looseIdentical(this._optionMap.get(id)._value,value))return id}return null},SelectMultipleControlValueAccessor.prototype._getOptionValue=function(valueString){var id=_extractId$1(valueString);return this._optionMap.has(id)?this._optionMap.get(id)._value:valueString},SelectMultipleControlValueAccessor.decorators=[{type:_angular_core.Directive,args:[{selector:"select[multiple][formControlName],select[multiple][formControl],select[multiple][ngModel]",host:{"(change)":"onChange($event.target)","(blur)":"onTouched()"},providers:[SELECT_MULTIPLE_VALUE_ACCESSOR]}]}],SelectMultipleControlValueAccessor.ctorParameters=function(){return[{type:_angular_core.Renderer},{type:_angular_core.ElementRef}]},SelectMultipleControlValueAccessor}(),NgSelectMultipleOption=function(){function NgSelectMultipleOption(_element,_renderer,_select){this._element=_element,this._renderer=_renderer,this._select=_select,this._select&&(this.id=this._select._registerOption(this))}return Object.defineProperty(NgSelectMultipleOption.prototype,"ngValue",{set:function(value){null!=this._select&&(this._value=value,this._setElementValue(_buildValueString$1(this.id,value)),this._select.writeValue(this._select.value))},enumerable:!0,configurable:!0}),Object.defineProperty(NgSelectMultipleOption.prototype,"value",{set:function(value){this._select?(this._value=value,this._setElementValue(_buildValueString$1(this.id,value)),this._select.writeValue(this._select.value)):this._setElementValue(value)},enumerable:!0,configurable:!0}),NgSelectMultipleOption.prototype._setElementValue=function(value){this._renderer.setElementProperty(this._element.nativeElement,"value",value)},NgSelectMultipleOption.prototype._setSelected=function(selected){this._renderer.setElementProperty(this._element.nativeElement,"selected",selected)},NgSelectMultipleOption.prototype.ngOnDestroy=function(){this._select&&(this._select._optionMap.delete(this.id),this._select.writeValue(this._select.value))},NgSelectMultipleOption.decorators=[{type:_angular_core.Directive,args:[{selector:"option"}]}],NgSelectMultipleOption.ctorParameters=function(){return[{type:_angular_core.ElementRef},{type:_angular_core.Renderer},{type:SelectMultipleControlValueAccessor,decorators:[{type:_angular_core.Optional},{type:_angular_core.Host}]}]},NgSelectMultipleOption.propDecorators={ngValue:[{type:_angular_core.Input,args:["ngValue"]}],value:[{type:_angular_core.Input,args:["value"]}]},NgSelectMultipleOption}(),BUILTIN_ACCESSORS=[CheckboxControlValueAccessor,RangeValueAccessor,NumberValueAccessor,SelectControlValueAccessor,SelectMultipleControlValueAccessor,RadioControlValueAccessor],__extends=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},AbstractFormGroupDirective=function(_super){function AbstractFormGroupDirective(){_super.apply(this,arguments)}return __extends(AbstractFormGroupDirective,_super),AbstractFormGroupDirective.prototype.ngOnInit=function(){this._checkParentType(),this.formDirective.addFormGroup(this)},AbstractFormGroupDirective.prototype.ngOnDestroy=function(){this.formDirective&&this.formDirective.removeFormGroup(this)},Object.defineProperty(AbstractFormGroupDirective.prototype,"control",{get:function(){return this.formDirective.getFormGroup(this)},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractFormGroupDirective.prototype,"path",{get:function(){return controlPath(this.name,this._parent)},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractFormGroupDirective.prototype,"formDirective",{get:function(){return this._parent?this._parent.formDirective:null},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractFormGroupDirective.prototype,"validator",{get:function(){return composeValidators(this._validators)},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractFormGroupDirective.prototype,"asyncValidator",{get:function(){return composeAsyncValidators(this._asyncValidators)},enumerable:!0,configurable:!0}),AbstractFormGroupDirective.prototype._checkParentType=function(){},AbstractFormGroupDirective}(ControlContainer),__extends$3=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},AbstractControlStatus=function(){function AbstractControlStatus(cd){this._cd=cd}return Object.defineProperty(AbstractControlStatus.prototype,"ngClassUntouched",{get:function(){return!!this._cd.control&&this._cd.control.untouched},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlStatus.prototype,"ngClassTouched",{get:function(){return!!this._cd.control&&this._cd.control.touched},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlStatus.prototype,"ngClassPristine",{get:function(){return!!this._cd.control&&this._cd.control.pristine},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlStatus.prototype,"ngClassDirty",{get:function(){return!!this._cd.control&&this._cd.control.dirty},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlStatus.prototype,"ngClassValid",{get:function(){return!!this._cd.control&&this._cd.control.valid},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlStatus.prototype,"ngClassInvalid",{get:function(){return!!this._cd.control&&this._cd.control.invalid},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControlStatus.prototype,"ngClassPending",{get:function(){return!!this._cd.control&&this._cd.control.pending},enumerable:!0,configurable:!0}),AbstractControlStatus}(),ngControlStatusHost={"[class.ng-untouched]":"ngClassUntouched","[class.ng-touched]":"ngClassTouched","[class.ng-pristine]":"ngClassPristine","[class.ng-dirty]":"ngClassDirty","[class.ng-valid]":"ngClassValid","[class.ng-invalid]":"ngClassInvalid","[class.ng-pending]":"ngClassPending"},NgControlStatus=function(_super){function NgControlStatus(cd){_super.call(this,cd)}return __extends$3(NgControlStatus,_super),NgControlStatus.decorators=[{type:_angular_core.Directive,args:[{selector:"[formControlName],[ngModel],[formControl]",host:ngControlStatusHost}]}],NgControlStatus.ctorParameters=function(){return[{type:NgControl,decorators:[{type:_angular_core.Self}]}]},NgControlStatus}(AbstractControlStatus),NgControlStatusGroup=function(_super){function NgControlStatusGroup(cd){_super.call(this,cd)}return __extends$3(NgControlStatusGroup,_super),NgControlStatusGroup.decorators=[{type:_angular_core.Directive,args:[{selector:"[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]",host:ngControlStatusHost}]}],NgControlStatusGroup.ctorParameters=function(){return[{type:ControlContainer,decorators:[{type:_angular_core.Self}]}]},NgControlStatusGroup}(AbstractControlStatus),__extends$5=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},EventEmitter=function(_super){function EventEmitter(isAsync){void 0===isAsync&&(isAsync=!1),_super.call(this),this.__isAsync=isAsync}return __extends$5(EventEmitter,_super),EventEmitter.prototype.emit=function(value){_super.prototype.next.call(this,value)},EventEmitter.prototype.subscribe=function(generatorOrNext,error,complete){var schedulerFn,errorFn=function(err){return null},completeFn=function(){return null};return generatorOrNext&&"object"==typeof generatorOrNext?(schedulerFn=this.__isAsync?function(value){setTimeout(function(){return generatorOrNext.next(value)})}:function(value){generatorOrNext.next(value)},generatorOrNext.error&&(errorFn=this.__isAsync?function(err){setTimeout(function(){return generatorOrNext.error(err)})}:function(err){generatorOrNext.error(err)}),generatorOrNext.complete&&(completeFn=this.__isAsync?function(){setTimeout(function(){return generatorOrNext.complete()})}:function(){generatorOrNext.complete()})):(schedulerFn=this.__isAsync?function(value){setTimeout(function(){return generatorOrNext(value)})}:function(value){generatorOrNext(value)},error&&(errorFn=this.__isAsync?function(err){setTimeout(function(){return error(err)})}:function(err){error(err)}),complete&&(completeFn=this.__isAsync?function(){setTimeout(function(){return complete()})}:function(){complete()})),_super.prototype.subscribe.call(this,schedulerFn,errorFn,completeFn)},EventEmitter}(rxjs_Subject.Subject),__extends$6=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},VALID="VALID",INVALID="INVALID",PENDING="PENDING",DISABLED="DISABLED",AbstractControl=function(){function AbstractControl(validator,asyncValidator){this.validator=validator,this.asyncValidator=asyncValidator,this._onCollectionChange=function(){},this._pristine=!0,this._touched=!1,this._onDisabledChange=[]}return Object.defineProperty(AbstractControl.prototype,"value",{get:function(){return this._value},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"parent",{get:function(){return this._parent},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"status",{get:function(){return this._status},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"valid",{get:function(){return this._status===VALID},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"invalid",{get:function(){return this._status===INVALID},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"pending",{get:function(){return this._status==PENDING},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"disabled",{get:function(){return this._status===DISABLED},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"enabled",{get:function(){return this._status!==DISABLED},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"errors",{get:function(){return this._errors},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"pristine",{get:function(){return this._pristine},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"dirty",{get:function(){return!this.pristine},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"touched",{
get:function(){return this._touched},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"untouched",{get:function(){return!this._touched},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"valueChanges",{get:function(){return this._valueChanges},enumerable:!0,configurable:!0}),Object.defineProperty(AbstractControl.prototype,"statusChanges",{get:function(){return this._statusChanges},enumerable:!0,configurable:!0}),AbstractControl.prototype.setValidators=function(newValidator){this.validator=coerceToValidator(newValidator)},AbstractControl.prototype.setAsyncValidators=function(newValidator){this.asyncValidator=coerceToAsyncValidator(newValidator)},AbstractControl.prototype.clearValidators=function(){this.validator=null},AbstractControl.prototype.clearAsyncValidators=function(){this.asyncValidator=null},AbstractControl.prototype.markAsTouched=function(_a){var onlySelf=(void 0===_a?{}:_a).onlySelf;this._touched=!0,this._parent&&!onlySelf&&this._parent.markAsTouched({onlySelf:onlySelf})},AbstractControl.prototype.markAsUntouched=function(_a){var onlySelf=(void 0===_a?{}:_a).onlySelf;this._touched=!1,this._forEachChild(function(control){control.markAsUntouched({onlySelf:!0})}),this._parent&&!onlySelf&&this._parent._updateTouched({onlySelf:onlySelf})},AbstractControl.prototype.markAsDirty=function(_a){var onlySelf=(void 0===_a?{}:_a).onlySelf;this._pristine=!1,this._parent&&!onlySelf&&this._parent.markAsDirty({onlySelf:onlySelf})},AbstractControl.prototype.markAsPristine=function(_a){var onlySelf=(void 0===_a?{}:_a).onlySelf;this._pristine=!0,this._forEachChild(function(control){control.markAsPristine({onlySelf:!0})}),this._parent&&!onlySelf&&this._parent._updatePristine({onlySelf:onlySelf})},AbstractControl.prototype.markAsPending=function(_a){var onlySelf=(void 0===_a?{}:_a).onlySelf;this._status=PENDING,this._parent&&!onlySelf&&this._parent.markAsPending({onlySelf:onlySelf})},AbstractControl.prototype.disable=function(_a){var _b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._status=DISABLED,this._errors=null,this._forEachChild(function(control){control.disable({onlySelf:!0})}),this._updateValue(),emitEvent!==!1&&(this._valueChanges.emit(this._value),this._statusChanges.emit(this._status)),this._updateAncestors(onlySelf),this._onDisabledChange.forEach(function(changeFn){return changeFn(!0)})},AbstractControl.prototype.enable=function(_a){var _b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._status=VALID,this._forEachChild(function(control){control.enable({onlySelf:!0})}),this.updateValueAndValidity({onlySelf:!0,emitEvent:emitEvent}),this._updateAncestors(onlySelf),this._onDisabledChange.forEach(function(changeFn){return changeFn(!1)})},AbstractControl.prototype._updateAncestors=function(onlySelf){this._parent&&!onlySelf&&(this._parent.updateValueAndValidity(),this._parent._updatePristine(),this._parent._updateTouched())},AbstractControl.prototype.setParent=function(parent){this._parent=parent},AbstractControl.prototype.setValue=function(value,options){},AbstractControl.prototype.patchValue=function(value,options){},AbstractControl.prototype.reset=function(value,options){},AbstractControl.prototype.updateValueAndValidity=function(_a){var _b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._setInitialStatus(),this._updateValue(),this.enabled&&(this._errors=this._runValidator(),this._status=this._calculateStatus(),this._status!==VALID&&this._status!==PENDING||this._runAsyncValidator(emitEvent)),emitEvent!==!1&&(this._valueChanges.emit(this._value),this._statusChanges.emit(this._status)),this._parent&&!onlySelf&&this._parent.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent})},AbstractControl.prototype._updateTreeValidity=function(_a){var emitEvent=(void 0===_a?{emitEvent:!0}:_a).emitEvent;this._forEachChild(function(ctrl){return ctrl._updateTreeValidity({emitEvent:emitEvent})}),this.updateValueAndValidity({onlySelf:!0,emitEvent:emitEvent})},AbstractControl.prototype._setInitialStatus=function(){this._status=this._allControlsDisabled()?DISABLED:VALID},AbstractControl.prototype._runValidator=function(){return this.validator?this.validator(this):null},AbstractControl.prototype._runAsyncValidator=function(emitEvent){var _this=this;if(this.asyncValidator){this._status=PENDING,this._cancelExistingSubscription();var obs=toObservable(this.asyncValidator(this));this._asyncValidationSubscription=obs.subscribe({next:function(res){return _this.setErrors(res,{emitEvent:emitEvent})}})}},AbstractControl.prototype._cancelExistingSubscription=function(){this._asyncValidationSubscription&&this._asyncValidationSubscription.unsubscribe()},AbstractControl.prototype.setErrors=function(errors,_a){var emitEvent=(void 0===_a?{}:_a).emitEvent;this._errors=errors,this._updateControlsErrors(emitEvent!==!1)},AbstractControl.prototype.get=function(path){return _find(this,path,".")},AbstractControl.prototype.getError=function(errorCode,path){void 0===path&&(path=null);var control=path?this.get(path):this;return control&&control._errors?control._errors[errorCode]:null},AbstractControl.prototype.hasError=function(errorCode,path){return void 0===path&&(path=null),!!this.getError(errorCode,path)},Object.defineProperty(AbstractControl.prototype,"root",{get:function(){for(var x=this;x._parent;)x=x._parent;return x},enumerable:!0,configurable:!0}),AbstractControl.prototype._updateControlsErrors=function(emitEvent){this._status=this._calculateStatus(),emitEvent&&this._statusChanges.emit(this._status),this._parent&&this._parent._updateControlsErrors(emitEvent)},AbstractControl.prototype._initObservables=function(){this._valueChanges=new EventEmitter,this._statusChanges=new EventEmitter},AbstractControl.prototype._calculateStatus=function(){return this._allControlsDisabled()?DISABLED:this._errors?INVALID:this._anyControlsHaveStatus(PENDING)?PENDING:this._anyControlsHaveStatus(INVALID)?INVALID:VALID},AbstractControl.prototype._updateValue=function(){},AbstractControl.prototype._forEachChild=function(cb){},AbstractControl.prototype._anyControls=function(condition){},AbstractControl.prototype._allControlsDisabled=function(){},AbstractControl.prototype._anyControlsHaveStatus=function(status){return this._anyControls(function(control){return control.status===status})},AbstractControl.prototype._anyControlsDirty=function(){return this._anyControls(function(control){return control.dirty})},AbstractControl.prototype._anyControlsTouched=function(){return this._anyControls(function(control){return control.touched})},AbstractControl.prototype._updatePristine=function(_a){var onlySelf=(void 0===_a?{}:_a).onlySelf;this._pristine=!this._anyControlsDirty(),this._parent&&!onlySelf&&this._parent._updatePristine({onlySelf:onlySelf})},AbstractControl.prototype._updateTouched=function(_a){var onlySelf=(void 0===_a?{}:_a).onlySelf;this._touched=this._anyControlsTouched(),this._parent&&!onlySelf&&this._parent._updateTouched({onlySelf:onlySelf})},AbstractControl.prototype._isBoxedValue=function(formState){return"object"==typeof formState&&null!==formState&&2===Object.keys(formState).length&&"value"in formState&&"disabled"in formState},AbstractControl.prototype._registerOnCollectionChange=function(fn){this._onCollectionChange=fn},AbstractControl}(),FormControl=function(_super){function FormControl(formState,validator,asyncValidator){void 0===formState&&(formState=null),void 0===validator&&(validator=null),void 0===asyncValidator&&(asyncValidator=null),_super.call(this,coerceToValidator(validator),coerceToAsyncValidator(asyncValidator)),this._onChange=[],this._applyFormState(formState),this.updateValueAndValidity({onlySelf:!0,emitEvent:!1}),this._initObservables()}return __extends$6(FormControl,_super),FormControl.prototype.setValue=function(value,_a){var _this=this,_b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent,emitModelToViewChange=_b.emitModelToViewChange,emitViewToModelChange=_b.emitViewToModelChange;this._value=value,this._onChange.length&&emitModelToViewChange!==!1&&this._onChange.forEach(function(changeFn){return changeFn(_this._value,emitViewToModelChange!==!1)}),this.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent})},FormControl.prototype.patchValue=function(value,options){void 0===options&&(options={}),this.setValue(value,options)},FormControl.prototype.reset=function(formState,_a){void 0===formState&&(formState=null);var _b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._applyFormState(formState),this.markAsPristine({onlySelf:onlySelf}),this.markAsUntouched({onlySelf:onlySelf}),this.setValue(this._value,{onlySelf:onlySelf,emitEvent:emitEvent})},FormControl.prototype._updateValue=function(){},FormControl.prototype._anyControls=function(condition){return!1},FormControl.prototype._allControlsDisabled=function(){return this.disabled},FormControl.prototype.registerOnChange=function(fn){this._onChange.push(fn)},FormControl.prototype._clearChangeFns=function(){this._onChange=[],this._onDisabledChange=[],this._onCollectionChange=function(){}},FormControl.prototype.registerOnDisabledChange=function(fn){this._onDisabledChange.push(fn)},FormControl.prototype._forEachChild=function(cb){},FormControl.prototype._applyFormState=function(formState){this._isBoxedValue(formState)?(this._value=formState.value,formState.disabled?this.disable({onlySelf:!0,emitEvent:!1}):this.enable({onlySelf:!0,emitEvent:!1})):this._value=formState},FormControl}(AbstractControl),FormGroup=function(_super){function FormGroup(controls,validator,asyncValidator){void 0===validator&&(validator=null),void 0===asyncValidator&&(asyncValidator=null),_super.call(this,validator,asyncValidator),this.controls=controls,this._initObservables(),this._setUpControls(),this.updateValueAndValidity({onlySelf:!0,emitEvent:!1})}return __extends$6(FormGroup,_super),FormGroup.prototype.registerControl=function(name,control){return this.controls[name]?this.controls[name]:(this.controls[name]=control,control.setParent(this),control._registerOnCollectionChange(this._onCollectionChange),control)},FormGroup.prototype.addControl=function(name,control){this.registerControl(name,control),this.updateValueAndValidity(),this._onCollectionChange()},FormGroup.prototype.removeControl=function(name){this.controls[name]&&this.controls[name]._registerOnCollectionChange(function(){}),delete this.controls[name],this.updateValueAndValidity(),this._onCollectionChange()},FormGroup.prototype.setControl=function(name,control){this.controls[name]&&this.controls[name]._registerOnCollectionChange(function(){}),delete this.controls[name],control&&this.registerControl(name,control),this.updateValueAndValidity(),this._onCollectionChange()},FormGroup.prototype.contains=function(controlName){return this.controls.hasOwnProperty(controlName)&&this.controls[controlName].enabled},FormGroup.prototype.setValue=function(value,_a){var _this=this,_b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._checkAllValuesPresent(value),Object.keys(value).forEach(function(name){_this._throwIfControlMissing(name),_this.controls[name].setValue(value[name],{onlySelf:!0,emitEvent:emitEvent})}),this.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent})},FormGroup.prototype.patchValue=function(value,_a){var _this=this,_b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;Object.keys(value).forEach(function(name){_this.controls[name]&&_this.controls[name].patchValue(value[name],{onlySelf:!0,emitEvent:emitEvent})}),this.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent})},FormGroup.prototype.reset=function(value,_a){void 0===value&&(value={});var _b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._forEachChild(function(control,name){control.reset(value[name],{onlySelf:!0,emitEvent:emitEvent})}),this.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent}),this._updatePristine({onlySelf:onlySelf}),this._updateTouched({onlySelf:onlySelf})},FormGroup.prototype.getRawValue=function(){return this._reduceChildren({},function(acc,control,name){return acc[name]=control.value,acc})},FormGroup.prototype._throwIfControlMissing=function(name){if(!Object.keys(this.controls).length)throw new Error("\n        There are no form controls registered with this group yet.  If you're using ngModel,\n        you may want to check next tick (e.g. use setTimeout).\n      ");if(!this.controls[name])throw new Error("Cannot find form control with name: "+name+".")},FormGroup.prototype._forEachChild=function(cb){var _this=this;Object.keys(this.controls).forEach(function(k){return cb(_this.controls[k],k)})},FormGroup.prototype._setUpControls=function(){var _this=this;this._forEachChild(function(control){control.setParent(_this),control._registerOnCollectionChange(_this._onCollectionChange)})},FormGroup.prototype._updateValue=function(){this._value=this._reduceValue()},FormGroup.prototype._anyControls=function(condition){var _this=this,res=!1;return this._forEachChild(function(control,name){res=res||_this.contains(name)&&condition(control)}),res},FormGroup.prototype._reduceValue=function(){var _this=this;return this._reduceChildren({},function(acc,control,name){return(control.enabled||_this.disabled)&&(acc[name]=control.value),acc})},FormGroup.prototype._reduceChildren=function(initValue,fn){var res=initValue;return this._forEachChild(function(control,name){res=fn(res,control,name)}),res},FormGroup.prototype._allControlsDisabled=function(){for(var _i=0,_a=Object.keys(this.controls);_i<_a.length;_i++){var controlName=_a[_i];if(this.controls[controlName].enabled)return!1}return Object.keys(this.controls).length>0||this.disabled},FormGroup.prototype._checkAllValuesPresent=function(value){this._forEachChild(function(control,name){if(void 0===value[name])throw new Error("Must supply a value for form control with name: '"+name+"'.")})},FormGroup}(AbstractControl),FormArray=function(_super){function FormArray(controls,validator,asyncValidator){void 0===validator&&(validator=null),void 0===asyncValidator&&(asyncValidator=null),_super.call(this,validator,asyncValidator),this.controls=controls,this._initObservables(),this._setUpControls(),this.updateValueAndValidity({onlySelf:!0,emitEvent:!1})}return __extends$6(FormArray,_super),FormArray.prototype.at=function(index){return this.controls[index]},FormArray.prototype.push=function(control){this.controls.push(control),this._registerControl(control),this.updateValueAndValidity(),this._onCollectionChange()},FormArray.prototype.insert=function(index,control){this.controls.splice(index,0,control),this._registerControl(control),this.updateValueAndValidity(),this._onCollectionChange()},FormArray.prototype.removeAt=function(index){this.controls[index]&&this.controls[index]._registerOnCollectionChange(function(){}),this.controls.splice(index,1),this.updateValueAndValidity(),this._onCollectionChange()},FormArray.prototype.setControl=function(index,control){this.controls[index]&&this.controls[index]._registerOnCollectionChange(function(){}),this.controls.splice(index,1),control&&(this.controls.splice(index,0,control),this._registerControl(control)),this.updateValueAndValidity(),this._onCollectionChange()},Object.defineProperty(FormArray.prototype,"length",{get:function(){return this.controls.length},enumerable:!0,configurable:!0}),FormArray.prototype.setValue=function(value,_a){var _this=this,_b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._checkAllValuesPresent(value),value.forEach(function(newValue,index){_this._throwIfControlMissing(index),_this.at(index).setValue(newValue,{onlySelf:!0,emitEvent:emitEvent})}),this.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent})},FormArray.prototype.patchValue=function(value,_a){var _this=this,_b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;value.forEach(function(newValue,index){_this.at(index)&&_this.at(index).patchValue(newValue,{onlySelf:!0,emitEvent:emitEvent})}),this.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent})},FormArray.prototype.reset=function(value,_a){void 0===value&&(value=[]);var _b=void 0===_a?{}:_a,onlySelf=_b.onlySelf,emitEvent=_b.emitEvent;this._forEachChild(function(control,index){control.reset(value[index],{onlySelf:!0,emitEvent:emitEvent})}),this.updateValueAndValidity({onlySelf:onlySelf,emitEvent:emitEvent}),this._updatePristine({onlySelf:onlySelf}),this._updateTouched({onlySelf:onlySelf})},FormArray.prototype.getRawValue=function(){return this.controls.map(function(control){return control.value})},FormArray.prototype._throwIfControlMissing=function(index){if(!this.controls.length)throw new Error("\n        There are no form controls registered with this array yet.  If you're using ngModel,\n        you may want to check next tick (e.g. use setTimeout).\n      ");if(!this.at(index))throw new Error("Cannot find form control at index "+index)},FormArray.prototype._forEachChild=function(cb){this.controls.forEach(function(control,index){cb(control,index)})},FormArray.prototype._updateValue=function(){var _this=this;this._value=this.controls.filter(function(control){return control.enabled||_this.disabled}).map(function(control){return control.value})},FormArray.prototype._anyControls=function(condition){return this.controls.some(function(control){return control.enabled&&condition(control)})},FormArray.prototype._setUpControls=function(){var _this=this;this._forEachChild(function(control){return _this._registerControl(control)})},FormArray.prototype._checkAllValuesPresent=function(value){this._forEachChild(function(control,i){if(void 0===value[i])throw new Error("Must supply a value for form control at index: "+i+".")})},FormArray.prototype._allControlsDisabled=function(){for(var _i=0,_a=this.controls;_i<_a.length;_i++){var control=_a[_i];if(control.enabled)return!1}return this.controls.length>0||this.disabled},FormArray.prototype._registerControl=function(control){control.setParent(this),control._registerOnCollectionChange(this._onCollectionChange)},FormArray}(AbstractControl),__extends$4=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},formDirectiveProvider={provide:ControlContainer,useExisting:_angular_core.forwardRef(function(){return NgForm})},resolvedPromise=Promise.resolve(null),NgForm=function(_super){function NgForm(validators,asyncValidators){_super.call(this),this._submitted=!1,this.ngSubmit=new EventEmitter,this.form=new FormGroup({},composeValidators(validators),composeAsyncValidators(asyncValidators))}return __extends$4(NgForm,_super),Object.defineProperty(NgForm.prototype,"submitted",{get:function(){return this._submitted},enumerable:!0,configurable:!0}),Object.defineProperty(NgForm.prototype,"formDirective",{get:function(){return this},enumerable:!0,configurable:!0}),Object.defineProperty(NgForm.prototype,"control",{get:function(){return this.form},enumerable:!0,configurable:!0}),Object.defineProperty(NgForm.prototype,"path",{get:function(){return[]},enumerable:!0,configurable:!0}),Object.defineProperty(NgForm.prototype,"controls",{get:function(){return this.form.controls},enumerable:!0,configurable:!0}),NgForm.prototype.addControl=function(dir){var _this=this;resolvedPromise.then(function(){var container=_this._findContainer(dir.path);dir._control=container.registerControl(dir.name,dir.control),setUpControl(dir.control,dir),dir.control.updateValueAndValidity({emitEvent:!1})})},NgForm.prototype.getControl=function(dir){return this.form.get(dir.path)},NgForm.prototype.removeControl=function(dir){var _this=this;resolvedPromise.then(function(){var container=_this._findContainer(dir.path);container&&container.removeControl(dir.name)})},NgForm.prototype.addFormGroup=function(dir){var _this=this;resolvedPromise.then(function(){var container=_this._findContainer(dir.path),group=new FormGroup({});setUpFormContainer(group,dir),container.registerControl(dir.name,group),group.updateValueAndValidity({emitEvent:!1})})},NgForm.prototype.removeFormGroup=function(dir){var _this=this;resolvedPromise.then(function(){var container=_this._findContainer(dir.path);container&&container.removeControl(dir.name)})},NgForm.prototype.getFormGroup=function(dir){return this.form.get(dir.path)},NgForm.prototype.updateModel=function(dir,value){var _this=this;resolvedPromise.then(function(){var ctrl=_this.form.get(dir.path);ctrl.setValue(value)})},NgForm.prototype.setValue=function(value){this.control.setValue(value)},NgForm.prototype.onSubmit=function($event){return this._submitted=!0,this.ngSubmit.emit($event),!1},NgForm.prototype.onReset=function(){this.resetForm()},NgForm.prototype.resetForm=function(value){void 0===value&&(value=void 0),this.form.reset(value),this._submitted=!1},NgForm.prototype._findContainer=function(path){return path.pop(),path.length?this.form.get(path):this.form},NgForm.decorators=[{type:_angular_core.Directive,args:[{selector:"form:not([ngNoForm]):not([formGroup]),ngForm,[ngForm]",providers:[formDirectiveProvider],host:{"(submit)":"onSubmit($event)","(reset)":"onReset()"},outputs:["ngSubmit"],exportAs:"ngForm"}]}],NgForm.ctorParameters=function(){return[{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},NgForm}(ControlContainer),Examples={formControlName:'\n    <div [formGroup]="myGroup">\n      <input formControlName="firstName">\n    </div>\n\n    In your class:\n\n    this.myGroup = new FormGroup({\n       firstName: new FormControl()\n    });',formGroupName:'\n    <div [formGroup]="myGroup">\n       <div formGroupName="person">\n          <input formControlName="firstName">\n       </div>\n    </div>\n\n    In your class:\n\n    this.myGroup = new FormGroup({\n       person: new FormGroup({ firstName: new FormControl() })\n    });',formArrayName:'\n    <div [formGroup]="myGroup">\n      <div formArrayName="cities">\n        <div *ngFor="let city of cityArray.controls; let i=index">\n          <input [formControlName]="i">\n        </div>\n      </div>\n    </div>\n\n    In your class:\n\n    this.cityArray = new FormArray([new FormControl(\'SF\')]);\n    this.myGroup = new FormGroup({\n      cities: this.cityArray\n    });',ngModelGroup:'\n    <form>\n       <div ngModelGroup="person">\n          <input [(ngModel)]="person.name" name="firstName">\n       </div>\n    </form>',ngModelWithFormGroup:'\n    <div [formGroup]="myGroup">\n       <input formControlName="firstName">\n       <input [(ngModel)]="showMoreControls" [ngModelOptions]="{standalone: true}">\n    </div>\n  '},TemplateDrivenErrors=function(){function TemplateDrivenErrors(){}return TemplateDrivenErrors.modelParentException=function(){throw new Error('\n      ngModel cannot be used to register form controls with a parent formGroup directive.  Try using\n      formGroup\'s partner directive "formControlName" instead.  Example:\n\n      '+Examples.formControlName+"\n\n      Or, if you'd like to avoid registering this form control, indicate that it's standalone in ngModelOptions:\n\n      Example:\n\n      "+Examples.ngModelWithFormGroup)},TemplateDrivenErrors.formGroupNameException=function(){throw new Error("\n      ngModel cannot be used to register form controls with a parent formGroupName or formArrayName directive.\n\n      Option 1: Use formControlName instead of ngModel (reactive strategy):\n\n      "+Examples.formGroupName+"\n\n      Option 2:  Update ngModel's parent be ngModelGroup (template-driven strategy):\n\n      "+Examples.ngModelGroup)},TemplateDrivenErrors.missingNameException=function(){throw new Error('If ngModel is used within a form tag, either the name attribute must be set or the form\n      control must be defined as \'standalone\' in ngModelOptions.\n\n      Example 1: <input [(ngModel)]="person.firstName" name="first">\n      Example 2: <input [(ngModel)]="person.firstName" [ngModelOptions]="{standalone: true}">')},TemplateDrivenErrors.modelGroupParentException=function(){throw new Error("\n      ngModelGroup cannot be used with a parent formGroup directive.\n\n      Option 1: Use formGroupName instead of ngModelGroup (reactive strategy):\n\n      "+Examples.formGroupName+"\n\n      Option 2:  Use a regular form tag instead of the formGroup directive (template-driven strategy):\n\n      "+Examples.ngModelGroup)},TemplateDrivenErrors}(),__extends$8=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},modelGroupProvider={provide:ControlContainer,useExisting:_angular_core.forwardRef(function(){return NgModelGroup})},NgModelGroup=function(_super){function NgModelGroup(parent,validators,asyncValidators){_super.call(this),this._parent=parent,this._validators=validators,this._asyncValidators=asyncValidators}return __extends$8(NgModelGroup,_super),NgModelGroup.prototype._checkParentType=function(){this._parent instanceof NgModelGroup||this._parent instanceof NgForm||TemplateDrivenErrors.modelGroupParentException()},NgModelGroup.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngModelGroup]",providers:[modelGroupProvider],exportAs:"ngModelGroup"}]}],NgModelGroup.ctorParameters=function(){return[{type:ControlContainer,decorators:[{type:_angular_core.Host},{type:_angular_core.SkipSelf}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},NgModelGroup.propDecorators={name:[{type:_angular_core.Input,args:["ngModelGroup"]}]},NgModelGroup}(AbstractFormGroupDirective),__extends$7=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},formControlBinding={provide:NgControl,useExisting:_angular_core.forwardRef(function(){return NgModel})},resolvedPromise$1=Promise.resolve(null),NgModel=function(_super){function NgModel(parent,validators,asyncValidators,valueAccessors){_super.call(this),this._control=new FormControl,this._registered=!1,this.update=new EventEmitter,this._parent=parent,this._rawValidators=validators||[],this._rawAsyncValidators=asyncValidators||[],this.valueAccessor=selectValueAccessor(this,valueAccessors)}return __extends$7(NgModel,_super),NgModel.prototype.ngOnChanges=function(changes){this._checkForErrors(),this._registered||this._setUpControl(),"isDisabled"in changes&&this._updateDisabled(changes),isPropertyUpdated(changes,this.viewModel)&&(this._updateValue(this.model),this.viewModel=this.model)},NgModel.prototype.ngOnDestroy=function(){this.formDirective&&this.formDirective.removeControl(this)},Object.defineProperty(NgModel.prototype,"control",{get:function(){return this._control},enumerable:!0,configurable:!0}),Object.defineProperty(NgModel.prototype,"path",{get:function(){return this._parent?controlPath(this.name,this._parent):[this.name]},enumerable:!0,configurable:!0}),Object.defineProperty(NgModel.prototype,"formDirective",{get:function(){return this._parent?this._parent.formDirective:null},enumerable:!0,configurable:!0}),Object.defineProperty(NgModel.prototype,"validator",{get:function(){return composeValidators(this._rawValidators)},enumerable:!0,configurable:!0}),Object.defineProperty(NgModel.prototype,"asyncValidator",{get:function(){return composeAsyncValidators(this._rawAsyncValidators)},enumerable:!0,configurable:!0}),NgModel.prototype.viewToModelUpdate=function(newValue){this.viewModel=newValue,this.update.emit(newValue)},NgModel.prototype._setUpControl=function(){this._isStandalone()?this._setUpStandalone():this.formDirective.addControl(this),this._registered=!0},NgModel.prototype._isStandalone=function(){return!this._parent||this.options&&this.options.standalone},NgModel.prototype._setUpStandalone=function(){setUpControl(this._control,this),this._control.updateValueAndValidity({emitEvent:!1})},NgModel.prototype._checkForErrors=function(){this._isStandalone()||this._checkParentType(),this._checkName()},NgModel.prototype._checkParentType=function(){!(this._parent instanceof NgModelGroup)&&this._parent instanceof AbstractFormGroupDirective?TemplateDrivenErrors.formGroupNameException():this._parent instanceof NgModelGroup||this._parent instanceof NgForm||TemplateDrivenErrors.modelParentException()},NgModel.prototype._checkName=function(){this.options&&this.options.name&&(this.name=this.options.name),this._isStandalone()||this.name||TemplateDrivenErrors.missingNameException()},NgModel.prototype._updateValue=function(value){var _this=this;resolvedPromise$1.then(function(){_this.control.setValue(value,{emitViewToModelChange:!1})})},NgModel.prototype._updateDisabled=function(changes){var _this=this,disabledValue=changes.isDisabled.currentValue,isDisabled=""===disabledValue||disabledValue&&"false"!==disabledValue;resolvedPromise$1.then(function(){isDisabled&&!_this.control.disabled?_this.control.disable():!isDisabled&&_this.control.disabled&&_this.control.enable()})},NgModel.decorators=[{type:_angular_core.Directive,args:[{selector:"[ngModel]:not([formControlName]):not([formControl])",providers:[formControlBinding],exportAs:"ngModel"}]}],NgModel.ctorParameters=function(){return[{type:ControlContainer,decorators:[{type:_angular_core.Optional},{type:_angular_core.Host}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALUE_ACCESSOR]}]}]},NgModel.propDecorators={name:[{type:_angular_core.Input}],isDisabled:[{type:_angular_core.Input,args:["disabled"]}],model:[{type:_angular_core.Input,args:["ngModel"]}],options:[{type:_angular_core.Input,args:["ngModelOptions"]}],update:[{type:_angular_core.Output,args:["ngModelChange"]}]},NgModel}(NgControl),ReactiveErrors=function(){function ReactiveErrors(){}return ReactiveErrors.controlParentException=function(){throw new Error("formControlName must be used with a parent formGroup directive.  You'll want to add a formGroup\n       directive and pass it an existing FormGroup instance (you can create one in your class).\n\n      Example:\n\n      "+Examples.formControlName)},ReactiveErrors.ngModelGroupException=function(){throw new Error('formControlName cannot be used with an ngModelGroup parent. It is only compatible with parents\n       that also have a "form" prefix: formGroupName, formArrayName, or formGroup.\n\n       Option 1:  Update the parent to be formGroupName (reactive form strategy)\n\n        '+Examples.formGroupName+"\n\n        Option 2: Use ngModel instead of formControlName (template-driven strategy)\n\n        "+Examples.ngModelGroup)},ReactiveErrors.missingFormException=function(){throw new Error("formGroup expects a FormGroup instance. Please pass one in.\n\n       Example:\n\n       "+Examples.formControlName)},ReactiveErrors.groupParentException=function(){throw new Error("formGroupName must be used with a parent formGroup directive.  You'll want to add a formGroup\n      directive and pass it an existing FormGroup instance (you can create one in your class).\n\n      Example:\n\n      "+Examples.formGroupName)},ReactiveErrors.arrayParentException=function(){throw new Error("formArrayName must be used with a parent formGroup directive.  You'll want to add a formGroup\n       directive and pass it an existing FormGroup instance (you can create one in your class).\n\n        Example:\n\n        "+Examples.formArrayName);
},ReactiveErrors.disabledAttrWarning=function(){console.warn("\n      It looks like you're using the disabled attribute with a reactive form directive. If you set disabled to true\n      when you set up this control in your component class, the disabled attribute will actually be set in the DOM for\n      you. We recommend using this approach to avoid 'changed after checked' errors.\n       \n      Example: \n      form = new FormGroup({\n        first: new FormControl({value: 'Nancy', disabled: true}, Validators.required),\n        last: new FormControl('Drew', Validators.required)\n      });\n    ")},ReactiveErrors}(),__extends$9=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},formControlBinding$1={provide:NgControl,useExisting:_angular_core.forwardRef(function(){return FormControlDirective})},FormControlDirective=function(_super){function FormControlDirective(validators,asyncValidators,valueAccessors){_super.call(this),this.update=new EventEmitter,this._rawValidators=validators||[],this._rawAsyncValidators=asyncValidators||[],this.valueAccessor=selectValueAccessor(this,valueAccessors)}return __extends$9(FormControlDirective,_super),Object.defineProperty(FormControlDirective.prototype,"isDisabled",{set:function(isDisabled){ReactiveErrors.disabledAttrWarning()},enumerable:!0,configurable:!0}),FormControlDirective.prototype.ngOnChanges=function(changes){this._isControlChanged(changes)&&(setUpControl(this.form,this),this.control.disabled&&this.valueAccessor.setDisabledState&&this.valueAccessor.setDisabledState(!0),this.form.updateValueAndValidity({emitEvent:!1})),isPropertyUpdated(changes,this.viewModel)&&(this.form.setValue(this.model),this.viewModel=this.model)},Object.defineProperty(FormControlDirective.prototype,"path",{get:function(){return[]},enumerable:!0,configurable:!0}),Object.defineProperty(FormControlDirective.prototype,"validator",{get:function(){return composeValidators(this._rawValidators)},enumerable:!0,configurable:!0}),Object.defineProperty(FormControlDirective.prototype,"asyncValidator",{get:function(){return composeAsyncValidators(this._rawAsyncValidators)},enumerable:!0,configurable:!0}),Object.defineProperty(FormControlDirective.prototype,"control",{get:function(){return this.form},enumerable:!0,configurable:!0}),FormControlDirective.prototype.viewToModelUpdate=function(newValue){this.viewModel=newValue,this.update.emit(newValue)},FormControlDirective.prototype._isControlChanged=function(changes){return changes.hasOwnProperty("form")},FormControlDirective.decorators=[{type:_angular_core.Directive,args:[{selector:"[formControl]",providers:[formControlBinding$1],exportAs:"ngForm"}]}],FormControlDirective.ctorParameters=function(){return[{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALUE_ACCESSOR]}]}]},FormControlDirective.propDecorators={form:[{type:_angular_core.Input,args:["formControl"]}],model:[{type:_angular_core.Input,args:["ngModel"]}],update:[{type:_angular_core.Output,args:["ngModelChange"]}],isDisabled:[{type:_angular_core.Input,args:["disabled"]}]},FormControlDirective}(NgControl),__extends$11=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},formDirectiveProvider$1={provide:ControlContainer,useExisting:_angular_core.forwardRef(function(){return FormGroupDirective})},FormGroupDirective=function(_super){function FormGroupDirective(_validators,_asyncValidators){_super.call(this),this._validators=_validators,this._asyncValidators=_asyncValidators,this._submitted=!1,this.directives=[],this.form=null,this.ngSubmit=new EventEmitter}return __extends$11(FormGroupDirective,_super),FormGroupDirective.prototype.ngOnChanges=function(changes){this._checkFormPresent(),changes.hasOwnProperty("form")&&(this._updateValidators(),this._updateDomValue(),this._updateRegistrations())},Object.defineProperty(FormGroupDirective.prototype,"submitted",{get:function(){return this._submitted},enumerable:!0,configurable:!0}),Object.defineProperty(FormGroupDirective.prototype,"formDirective",{get:function(){return this},enumerable:!0,configurable:!0}),Object.defineProperty(FormGroupDirective.prototype,"control",{get:function(){return this.form},enumerable:!0,configurable:!0}),Object.defineProperty(FormGroupDirective.prototype,"path",{get:function(){return[]},enumerable:!0,configurable:!0}),FormGroupDirective.prototype.addControl=function(dir){var ctrl=this.form.get(dir.path);return setUpControl(ctrl,dir),ctrl.updateValueAndValidity({emitEvent:!1}),this.directives.push(dir),ctrl},FormGroupDirective.prototype.getControl=function(dir){return this.form.get(dir.path)},FormGroupDirective.prototype.removeControl=function(dir){ListWrapper.remove(this.directives,dir)},FormGroupDirective.prototype.addFormGroup=function(dir){var ctrl=this.form.get(dir.path);setUpFormContainer(ctrl,dir),ctrl.updateValueAndValidity({emitEvent:!1})},FormGroupDirective.prototype.removeFormGroup=function(dir){},FormGroupDirective.prototype.getFormGroup=function(dir){return this.form.get(dir.path)},FormGroupDirective.prototype.addFormArray=function(dir){var ctrl=this.form.get(dir.path);setUpFormContainer(ctrl,dir),ctrl.updateValueAndValidity({emitEvent:!1})},FormGroupDirective.prototype.removeFormArray=function(dir){},FormGroupDirective.prototype.getFormArray=function(dir){return this.form.get(dir.path)},FormGroupDirective.prototype.updateModel=function(dir,value){var ctrl=this.form.get(dir.path);ctrl.setValue(value)},FormGroupDirective.prototype.onSubmit=function($event){return this._submitted=!0,this.ngSubmit.emit($event),!1},FormGroupDirective.prototype.onReset=function(){this.resetForm()},FormGroupDirective.prototype.resetForm=function(value){void 0===value&&(value=void 0),this.form.reset(value),this._submitted=!1},FormGroupDirective.prototype._updateDomValue=function(){var _this=this;this.directives.forEach(function(dir){var newCtrl=_this.form.get(dir.path);dir._control!==newCtrl&&(cleanUpControl(dir._control,dir),newCtrl&&setUpControl(newCtrl,dir),dir._control=newCtrl)}),this.form._updateTreeValidity({emitEvent:!1})},FormGroupDirective.prototype._updateRegistrations=function(){var _this=this;this.form._registerOnCollectionChange(function(){return _this._updateDomValue()}),this._oldForm&&this._oldForm._registerOnCollectionChange(function(){}),this._oldForm=this.form},FormGroupDirective.prototype._updateValidators=function(){var sync=composeValidators(this._validators);this.form.validator=Validators.compose([this.form.validator,sync]);var async=composeAsyncValidators(this._asyncValidators);this.form.asyncValidator=Validators.composeAsync([this.form.asyncValidator,async])},FormGroupDirective.prototype._checkFormPresent=function(){this.form||ReactiveErrors.missingFormException()},FormGroupDirective.decorators=[{type:_angular_core.Directive,args:[{selector:"[formGroup]",providers:[formDirectiveProvider$1],host:{"(submit)":"onSubmit($event)","(reset)":"onReset()"},exportAs:"ngForm"}]}],FormGroupDirective.ctorParameters=function(){return[{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},FormGroupDirective.propDecorators={form:[{type:_angular_core.Input,args:["formGroup"]}],ngSubmit:[{type:_angular_core.Output}]},FormGroupDirective}(ControlContainer),__extends$12=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},formGroupNameProvider={provide:ControlContainer,useExisting:_angular_core.forwardRef(function(){return FormGroupName})},FormGroupName=function(_super){function FormGroupName(parent,validators,asyncValidators){_super.call(this),this._parent=parent,this._validators=validators,this._asyncValidators=asyncValidators}return __extends$12(FormGroupName,_super),FormGroupName.prototype._checkParentType=function(){_hasInvalidParent(this._parent)&&ReactiveErrors.groupParentException()},FormGroupName.decorators=[{type:_angular_core.Directive,args:[{selector:"[formGroupName]",providers:[formGroupNameProvider]}]}],FormGroupName.ctorParameters=function(){return[{type:ControlContainer,decorators:[{type:_angular_core.Optional},{type:_angular_core.Host},{type:_angular_core.SkipSelf}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},FormGroupName.propDecorators={name:[{type:_angular_core.Input,args:["formGroupName"]}]},FormGroupName}(AbstractFormGroupDirective),formArrayNameProvider={provide:ControlContainer,useExisting:_angular_core.forwardRef(function(){return FormArrayName})},FormArrayName=function(_super){function FormArrayName(parent,validators,asyncValidators){_super.call(this),this._parent=parent,this._validators=validators,this._asyncValidators=asyncValidators}return __extends$12(FormArrayName,_super),FormArrayName.prototype.ngOnInit=function(){this._checkParentType(),this.formDirective.addFormArray(this)},FormArrayName.prototype.ngOnDestroy=function(){this.formDirective&&this.formDirective.removeFormArray(this)},Object.defineProperty(FormArrayName.prototype,"control",{get:function(){return this.formDirective.getFormArray(this)},enumerable:!0,configurable:!0}),Object.defineProperty(FormArrayName.prototype,"formDirective",{get:function(){return this._parent?this._parent.formDirective:null},enumerable:!0,configurable:!0}),Object.defineProperty(FormArrayName.prototype,"path",{get:function(){return controlPath(this.name,this._parent)},enumerable:!0,configurable:!0}),Object.defineProperty(FormArrayName.prototype,"validator",{get:function(){return composeValidators(this._validators)},enumerable:!0,configurable:!0}),Object.defineProperty(FormArrayName.prototype,"asyncValidator",{get:function(){return composeAsyncValidators(this._asyncValidators)},enumerable:!0,configurable:!0}),FormArrayName.prototype._checkParentType=function(){_hasInvalidParent(this._parent)&&ReactiveErrors.arrayParentException()},FormArrayName.decorators=[{type:_angular_core.Directive,args:[{selector:"[formArrayName]",providers:[formArrayNameProvider]}]}],FormArrayName.ctorParameters=function(){return[{type:ControlContainer,decorators:[{type:_angular_core.Optional},{type:_angular_core.Host},{type:_angular_core.SkipSelf}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]}]},FormArrayName.propDecorators={name:[{type:_angular_core.Input,args:["formArrayName"]}]},FormArrayName}(ControlContainer),__extends$10=this&&this.__extends||function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},controlNameBinding={provide:NgControl,useExisting:_angular_core.forwardRef(function(){return FormControlName})},FormControlName=function(_super){function FormControlName(parent,validators,asyncValidators,valueAccessors){_super.call(this),this._added=!1,this.update=new EventEmitter,this._parent=parent,this._rawValidators=validators||[],this._rawAsyncValidators=asyncValidators||[],this.valueAccessor=selectValueAccessor(this,valueAccessors)}return __extends$10(FormControlName,_super),Object.defineProperty(FormControlName.prototype,"isDisabled",{set:function(isDisabled){ReactiveErrors.disabledAttrWarning()},enumerable:!0,configurable:!0}),FormControlName.prototype.ngOnChanges=function(changes){this._added||this._setUpControl(),isPropertyUpdated(changes,this.viewModel)&&(this.viewModel=this.model,this.formDirective.updateModel(this,this.model))},FormControlName.prototype.ngOnDestroy=function(){this.formDirective&&this.formDirective.removeControl(this)},FormControlName.prototype.viewToModelUpdate=function(newValue){this.viewModel=newValue,this.update.emit(newValue)},Object.defineProperty(FormControlName.prototype,"path",{get:function(){return controlPath(this.name,this._parent)},enumerable:!0,configurable:!0}),Object.defineProperty(FormControlName.prototype,"formDirective",{get:function(){return this._parent?this._parent.formDirective:null},enumerable:!0,configurable:!0}),Object.defineProperty(FormControlName.prototype,"validator",{get:function(){return composeValidators(this._rawValidators)},enumerable:!0,configurable:!0}),Object.defineProperty(FormControlName.prototype,"asyncValidator",{get:function(){return composeAsyncValidators(this._rawAsyncValidators)},enumerable:!0,configurable:!0}),Object.defineProperty(FormControlName.prototype,"control",{get:function(){return this._control},enumerable:!0,configurable:!0}),FormControlName.prototype._checkParentType=function(){!(this._parent instanceof FormGroupName)&&this._parent instanceof AbstractFormGroupDirective?ReactiveErrors.ngModelGroupException():this._parent instanceof FormGroupName||this._parent instanceof FormGroupDirective||this._parent instanceof FormArrayName||ReactiveErrors.controlParentException()},FormControlName.prototype._setUpControl=function(){this._checkParentType(),this._control=this.formDirective.addControl(this),this.control.disabled&&this.valueAccessor.setDisabledState&&this.valueAccessor.setDisabledState(!0),this._added=!0},FormControlName.decorators=[{type:_angular_core.Directive,args:[{selector:"[formControlName]",providers:[controlNameBinding]}]}],FormControlName.ctorParameters=function(){return[{type:ControlContainer,decorators:[{type:_angular_core.Optional},{type:_angular_core.Host},{type:_angular_core.SkipSelf}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_ASYNC_VALIDATORS]}]},{type:Array,decorators:[{type:_angular_core.Optional},{type:_angular_core.Self},{type:_angular_core.Inject,args:[NG_VALUE_ACCESSOR]}]}]},FormControlName.propDecorators={name:[{type:_angular_core.Input,args:["formControlName"]}],model:[{type:_angular_core.Input,args:["ngModel"]}],update:[{type:_angular_core.Output,args:["ngModelChange"]}],isDisabled:[{type:_angular_core.Input,args:["disabled"]}]},FormControlName}(NgControl),REQUIRED_VALIDATOR={provide:NG_VALIDATORS,useExisting:_angular_core.forwardRef(function(){return RequiredValidator}),multi:!0},RequiredValidator=function(){function RequiredValidator(){}return Object.defineProperty(RequiredValidator.prototype,"required",{get:function(){return this._required},set:function(value){this._required=null!=value&&value!==!1&&""+value!="false",this._onChange&&this._onChange()},enumerable:!0,configurable:!0}),RequiredValidator.prototype.validate=function(c){return this.required?Validators.required(c):null},RequiredValidator.prototype.registerOnValidatorChange=function(fn){this._onChange=fn},RequiredValidator.decorators=[{type:_angular_core.Directive,args:[{selector:"[required][formControlName],[required][formControl],[required][ngModel]",providers:[REQUIRED_VALIDATOR],host:{"[attr.required]":'required ? "" : null'}}]}],RequiredValidator.ctorParameters=function(){return[]},RequiredValidator.propDecorators={required:[{type:_angular_core.Input}]},RequiredValidator}(),MIN_LENGTH_VALIDATOR={provide:NG_VALIDATORS,useExisting:_angular_core.forwardRef(function(){return MinLengthValidator}),multi:!0},MinLengthValidator=function(){function MinLengthValidator(){}return MinLengthValidator.prototype.ngOnChanges=function(changes){"minlength"in changes&&(this._createValidator(),this._onChange&&this._onChange())},MinLengthValidator.prototype.validate=function(c){return null==this.minlength?null:this._validator(c)},MinLengthValidator.prototype.registerOnValidatorChange=function(fn){this._onChange=fn},MinLengthValidator.prototype._createValidator=function(){this._validator=Validators.minLength(parseInt(this.minlength,10))},MinLengthValidator.decorators=[{type:_angular_core.Directive,args:[{selector:"[minlength][formControlName],[minlength][formControl],[minlength][ngModel]",providers:[MIN_LENGTH_VALIDATOR],host:{"[attr.minlength]":"minlength ? minlength : null"}}]}],MinLengthValidator.ctorParameters=function(){return[]},MinLengthValidator.propDecorators={minlength:[{type:_angular_core.Input}]},MinLengthValidator}(),MAX_LENGTH_VALIDATOR={provide:NG_VALIDATORS,useExisting:_angular_core.forwardRef(function(){return MaxLengthValidator}),multi:!0},MaxLengthValidator=function(){function MaxLengthValidator(){}return MaxLengthValidator.prototype.ngOnChanges=function(changes){"maxlength"in changes&&(this._createValidator(),this._onChange&&this._onChange())},MaxLengthValidator.prototype.validate=function(c){return null!=this.maxlength?this._validator(c):null},MaxLengthValidator.prototype.registerOnValidatorChange=function(fn){this._onChange=fn},MaxLengthValidator.prototype._createValidator=function(){this._validator=Validators.maxLength(parseInt(this.maxlength,10))},MaxLengthValidator.decorators=[{type:_angular_core.Directive,args:[{selector:"[maxlength][formControlName],[maxlength][formControl],[maxlength][ngModel]",providers:[MAX_LENGTH_VALIDATOR],host:{"[attr.maxlength]":"maxlength ? maxlength : null"}}]}],MaxLengthValidator.ctorParameters=function(){return[]},MaxLengthValidator.propDecorators={maxlength:[{type:_angular_core.Input}]},MaxLengthValidator}(),PATTERN_VALIDATOR={provide:NG_VALIDATORS,useExisting:_angular_core.forwardRef(function(){return PatternValidator}),multi:!0},PatternValidator=function(){function PatternValidator(){}return PatternValidator.prototype.ngOnChanges=function(changes){"pattern"in changes&&(this._createValidator(),this._onChange&&this._onChange())},PatternValidator.prototype.validate=function(c){return this._validator(c)},PatternValidator.prototype.registerOnValidatorChange=function(fn){this._onChange=fn},PatternValidator.prototype._createValidator=function(){this._validator=Validators.pattern(this.pattern)},PatternValidator.decorators=[{type:_angular_core.Directive,args:[{selector:"[pattern][formControlName],[pattern][formControl],[pattern][ngModel]",providers:[PATTERN_VALIDATOR],host:{"[attr.pattern]":"pattern ? pattern : null"}}]}],PatternValidator.ctorParameters=function(){return[]},PatternValidator.propDecorators={pattern:[{type:_angular_core.Input}]},PatternValidator}(),FormBuilder=function(){function FormBuilder(){}return FormBuilder.prototype.group=function(controlsConfig,extra){void 0===extra&&(extra=null);var controls=this._reduceControls(controlsConfig),validator=isPresent(extra)?extra.validator:null,asyncValidator=isPresent(extra)?extra.asyncValidator:null;return new FormGroup(controls,validator,asyncValidator)},FormBuilder.prototype.control=function(formState,validator,asyncValidator){return void 0===validator&&(validator=null),void 0===asyncValidator&&(asyncValidator=null),new FormControl(formState,validator,asyncValidator)},FormBuilder.prototype.array=function(controlsConfig,validator,asyncValidator){var _this=this;void 0===validator&&(validator=null),void 0===asyncValidator&&(asyncValidator=null);var controls=controlsConfig.map(function(c){return _this._createControl(c)});return new FormArray(controls,validator,asyncValidator)},FormBuilder.prototype._reduceControls=function(controlsConfig){var _this=this,controls={};return Object.keys(controlsConfig).forEach(function(controlName){controls[controlName]=_this._createControl(controlsConfig[controlName])}),controls},FormBuilder.prototype._createControl=function(controlConfig){if(controlConfig instanceof FormControl||controlConfig instanceof FormGroup||controlConfig instanceof FormArray)return controlConfig;if(Array.isArray(controlConfig)){var value=controlConfig[0],validator=controlConfig.length>1?controlConfig[1]:null,asyncValidator=controlConfig.length>2?controlConfig[2]:null;return this.control(value,validator,asyncValidator)}return this.control(controlConfig)},FormBuilder.decorators=[{type:_angular_core.Injectable}],FormBuilder.ctorParameters=function(){return[]},FormBuilder}(),VERSION=new _angular_core.Version("2.3.0"),SHARED_FORM_DIRECTIVES=[NgSelectOption,NgSelectMultipleOption,DefaultValueAccessor,NumberValueAccessor,RangeValueAccessor,CheckboxControlValueAccessor,SelectControlValueAccessor,SelectMultipleControlValueAccessor,RadioControlValueAccessor,NgControlStatus,NgControlStatusGroup,RequiredValidator,MinLengthValidator,MaxLengthValidator,PatternValidator],TEMPLATE_DRIVEN_DIRECTIVES=[NgModel,NgModelGroup,NgForm],REACTIVE_DRIVEN_DIRECTIVES=[FormControlDirective,FormGroupDirective,FormControlName,FormGroupName,FormArrayName],InternalFormsSharedModule=function(){function InternalFormsSharedModule(){}return InternalFormsSharedModule.decorators=[{type:_angular_core.NgModule,args:[{declarations:SHARED_FORM_DIRECTIVES,exports:SHARED_FORM_DIRECTIVES}]}],InternalFormsSharedModule.ctorParameters=function(){return[]},InternalFormsSharedModule}(),FormsModule=function(){function FormsModule(){}return FormsModule.decorators=[{type:_angular_core.NgModule,args:[{declarations:TEMPLATE_DRIVEN_DIRECTIVES,providers:[RadioControlRegistry],exports:[InternalFormsSharedModule,TEMPLATE_DRIVEN_DIRECTIVES]}]}],FormsModule.ctorParameters=function(){return[]},FormsModule}(),ReactiveFormsModule=function(){function ReactiveFormsModule(){}return ReactiveFormsModule.decorators=[{type:_angular_core.NgModule,args:[{declarations:[REACTIVE_DRIVEN_DIRECTIVES],providers:[FormBuilder,RadioControlRegistry],exports:[InternalFormsSharedModule,REACTIVE_DRIVEN_DIRECTIVES]}]}],ReactiveFormsModule.ctorParameters=function(){return[]},ReactiveFormsModule}();exports.AbstractControlDirective=AbstractControlDirective,exports.AbstractFormGroupDirective=AbstractFormGroupDirective,exports.CheckboxControlValueAccessor=CheckboxControlValueAccessor,exports.ControlContainer=ControlContainer,exports.NG_VALUE_ACCESSOR=NG_VALUE_ACCESSOR,exports.DefaultValueAccessor=DefaultValueAccessor,exports.NgControl=NgControl,exports.NgControlStatus=NgControlStatus,exports.NgControlStatusGroup=NgControlStatusGroup,exports.NgForm=NgForm,exports.NgModel=NgModel,exports.NgModelGroup=NgModelGroup,exports.RadioControlValueAccessor=RadioControlValueAccessor,exports.FormControlDirective=FormControlDirective,exports.FormControlName=FormControlName,exports.FormGroupDirective=FormGroupDirective,exports.FormArrayName=FormArrayName,exports.FormGroupName=FormGroupName,exports.NgSelectOption=NgSelectOption,exports.SelectControlValueAccessor=SelectControlValueAccessor,exports.SelectMultipleControlValueAccessor=SelectMultipleControlValueAccessor,exports.MaxLengthValidator=MaxLengthValidator,exports.MinLengthValidator=MinLengthValidator,exports.PatternValidator=PatternValidator,exports.RequiredValidator=RequiredValidator,exports.FormBuilder=FormBuilder,exports.AbstractControl=AbstractControl,exports.FormArray=FormArray,exports.FormControl=FormControl,exports.FormGroup=FormGroup,exports.NG_ASYNC_VALIDATORS=NG_ASYNC_VALIDATORS,exports.NG_VALIDATORS=NG_VALIDATORS,exports.Validators=Validators,exports.VERSION=VERSION,exports.FormsModule=FormsModule,exports.ReactiveFormsModule=ReactiveFormsModule});