/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { RequestMethod } from './enums';
export function normalizeMethodName(method) {
    if (typeof method !== 'string')
        return method;
    switch (method.toUpperCase()) {
        case 'GET':
            return RequestMethod.Get;
        case 'POST':
            return RequestMethod.Post;
        case 'PUT':
            return RequestMethod.Put;
        case 'DELETE':
            return RequestMethod.Delete;
        case 'OPTIONS':
            return RequestMethod.Options;
        case 'HEAD':
            return RequestMethod.Head;
        case 'PATCH':
            return RequestMethod.Patch;
    }
    throw new Error("Invalid request method. The method \"" + method + "\" is not supported.");
}
export var isSuccess = function (status) { return (status >= 200 && status < 300); };
export function getResponseURL(xhr) {
    if ('responseURL' in xhr) {
        return xhr.responseURL;
    }
    if (/^X-Request-URL:/m.test(xhr.getAllResponseHeaders())) {
        return xhr.getResponseHeader('X-Request-URL');
    }
    return null;
}
export function stringToArrayBuffer8(input) {
    var view = new Uint8Array(input.length);
    for (var i = 0, strLen = input.length; i < strLen; i++) {
        view[i] = input.charCodeAt(i);
    }
    return view.buffer;
}
export function stringToArrayBuffer(input) {
    var view = new Uint16Array(input.length);
    for (var i = 0, strLen = input.length; i < strLen; i++) {
        view[i] = input.charCodeAt(i);
    }
    return view.buffer;
}
//# sourceMappingURL=data:application/json;base64,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