/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const __globalThis = typeof globalThis !== 'undefined' && globalThis;
const __window = typeof window !== 'undefined' && window;
const __self = typeof self !== 'undefined' && typeof WorkerGlobalScope !== 'undefined' &&
    self instanceof WorkerGlobalScope && self;
const __global = typeof global !== 'undefined' && global;
// Always use __globalThis if available; this is the spec-defined global variable across all
// environments.
// Then fallback to __global first; in Node tests both __global and __window may be defined.
export const _global = __globalThis || __global || __window || __self;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2xvYmFsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vLi4vcGFja2FnZXMvbG9jYWxpemUvc3JjL2xvY2FsaXplL3NyYy9nbG9iYWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7OztHQU1HO0FBb0JILE1BQU0sWUFBWSxHQUFHLE9BQU8sVUFBVSxLQUFLLFdBQVcsSUFBSSxVQUFVLENBQUM7QUFDckUsTUFBTSxRQUFRLEdBQUcsT0FBTyxNQUFNLEtBQUssV0FBVyxJQUFJLE1BQU0sQ0FBQztBQUN6RCxNQUFNLE1BQU0sR0FBRyxPQUFPLElBQUksS0FBSyxXQUFXLElBQUksT0FBTyxpQkFBaUIsS0FBSyxXQUFXO0lBQ2xGLElBQUksWUFBWSxpQkFBaUIsSUFBSSxJQUFJLENBQUM7QUFDOUMsTUFBTSxRQUFRLEdBQUcsT0FBTyxNQUFNLEtBQUssV0FBVyxJQUFJLE1BQU0sQ0FBQztBQUN6RCw0RkFBNEY7QUFDNUYsZ0JBQWdCO0FBQ2hCLDRGQUE0RjtBQUM1RixNQUFNLENBQUMsTUFBTSxPQUFPLEdBQVEsWUFBWSxJQUFJLFFBQVEsSUFBSSxRQUFRLElBQUksTUFBTSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbi8vICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKipcbi8vIFRoaXMgY29kZSB0byBhY2Nlc3MgdGhlIGdsb2JhbCBvYmplY3QgaXMgbW9zdGx5IGNvcGllZCBmcm9tIGBwYWNrYWdlcy9jb3JlL3NyYy91dGlsL2dsb2JhbC50c2BcblxuZGVjbGFyZSBnbG9iYWwge1xuICAvLyBUaGUgZGVmaW5pdGlvbiBvZiBgV29ya2VyR2xvYmFsU2NvcGVgIG11c3QgYmUgY29tcGF0aWJsZSB3aXRoIHRoZSBvbmUgaW4gYGxpYi53ZWJ3b3JrZXIuZC50c2AsXG4gIC8vIGJlY2F1c2UgYWxsIGZpbGVzIHVuZGVyIGBwYWNrYWdlcy9gIGFyZSBjb21waWxlZCB0b2dldGhlciBhcyBwYXJ0IG9mIHRoZVxuICAvLyBbbGVnYWN5LXVuaXQtdGVzdHMtc2F1Y2VsYWJzXVsxXSBDSSBqb2IsIGluY2x1ZGluZyB0aGUgYGxpYi53ZWJ3b3JrZXIuZC50c2AgdHlwaW5ncyBicm91Z2h0IGluXG4gIC8vIGJ5IFtzZXJ2aWNlLXdvcmtlci93b3JrZXIvc3JjL3NlcnZpY2Utd29ya2VyLmQudHNdWzJdLlxuICAvL1xuICAvLyBbMV06XG4gIC8vIGh0dHBzOi8vZ2l0aHViLmNvbS9hbmd1bGFyL2FuZ3VsYXIvYmxvYi9mZmVlYTYzZjQzZTZhN2ZkNDZiZTRhOGNkNWE1ZDI1NGM5OGRlYTA4Ly5jaXJjbGVjaS9jb25maWcueW1sI0w2ODFcbiAgLy8gWzJdOlxuICAvLyBodHRwczovL2dpdGh1Yi5jb20vYW5ndWxhci9hbmd1bGFyL2Jsb2IvMzE2ZGMyZjEyY2U4OTMxZjVmZjY2ZmE1ZjhkYTIxYzBkMjUxYTMzNy9wYWNrYWdlcy9zZXJ2aWNlLXdvcmtlci93b3JrZXIvc3JjL3NlcnZpY2Utd29ya2VyLmQudHMjTDlcbiAgaW50ZXJmYWNlIFdvcmtlckdsb2JhbFNjb3BlIGV4dGVuZHMgRXZlbnRUYXJnZXQsIFdpbmRvd09yV29ya2VyR2xvYmFsU2NvcGUge31cblxuICB2YXIgV29ya2VyR2xvYmFsU2NvcGU6IHtwcm90b3R5cGU6IFdvcmtlckdsb2JhbFNjb3BlOyBuZXcgKCk6IFdvcmtlckdsb2JhbFNjb3BlO307XG59XG5cbmNvbnN0IF9fZ2xvYmFsVGhpcyA9IHR5cGVvZiBnbG9iYWxUaGlzICE9PSAndW5kZWZpbmVkJyAmJiBnbG9iYWxUaGlzO1xuY29uc3QgX193aW5kb3cgPSB0eXBlb2Ygd2luZG93ICE9PSAndW5kZWZpbmVkJyAmJiB3aW5kb3c7XG5jb25zdCBfX3NlbGYgPSB0eXBlb2Ygc2VsZiAhPT0gJ3VuZGVmaW5lZCcgJiYgdHlwZW9mIFdvcmtlckdsb2JhbFNjb3BlICE9PSAndW5kZWZpbmVkJyAmJlxuICAgIHNlbGYgaW5zdGFuY2VvZiBXb3JrZXJHbG9iYWxTY29wZSAmJiBzZWxmO1xuY29uc3QgX19nbG9iYWwgPSB0eXBlb2YgZ2xvYmFsICE9PSAndW5kZWZpbmVkJyAmJiBnbG9iYWw7XG4vLyBBbHdheXMgdXNlIF9fZ2xvYmFsVGhpcyBpZiBhdmFpbGFibGU7IHRoaXMgaXMgdGhlIHNwZWMtZGVmaW5lZCBnbG9iYWwgdmFyaWFibGUgYWNyb3NzIGFsbFxuLy8gZW52aXJvbm1lbnRzLlxuLy8gVGhlbiBmYWxsYmFjayB0byBfX2dsb2JhbCBmaXJzdDsgaW4gTm9kZSB0ZXN0cyBib3RoIF9fZ2xvYmFsIGFuZCBfX3dpbmRvdyBtYXkgYmUgZGVmaW5lZC5cbmV4cG9ydCBjb25zdCBfZ2xvYmFsOiBhbnkgPSBfX2dsb2JhbFRoaXMgfHwgX19nbG9iYWwgfHwgX193aW5kb3cgfHwgX19zZWxmO1xuIl19