#!/usr/bin/env node
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/localize/src/tools/src/migrate/main", ["require", "exports", "@angular/compiler-cli/src/ngtsc/file_system", "@angular/compiler-cli/src/ngtsc/logging", "glob", "yargs", "@angular/localize/src/tools/src/migrate/migrate"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.migrateFiles = void 0;
    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var file_system_1 = require("@angular/compiler-cli/src/ngtsc/file_system");
    var logging_1 = require("@angular/compiler-cli/src/ngtsc/logging");
    var glob = require("glob");
    var yargs = require("yargs");
    var migrate_1 = require("@angular/localize/src/tools/src/migrate/migrate");
    if (require.main === module) {
        var args = process.argv.slice(2);
        var options = yargs
            .option('r', {
            alias: 'root',
            default: '.',
            describe: 'The root path for other paths provided in these options.\n' +
                'This should either be absolute or relative to the current working directory.',
            type: 'string',
        })
            .option('f', {
            alias: 'files',
            required: true,
            describe: 'A glob pattern indicating what files to migrate. This should be relative to the root path',
            type: 'string',
        })
            .option('m', {
            alias: 'mapFile',
            required: true,
            describe: 'Path to the migration mapping file generated by `localize-extract`. This should be relative to the root path.',
            type: 'string',
        })
            .strict()
            .help()
            .parse(args);
        var fs = new file_system_1.NodeJSFileSystem();
        file_system_1.setFileSystem(fs);
        var rootPath = options.r;
        var translationFilePaths = glob.sync(options.f, { cwd: rootPath, nodir: true });
        var logger = new logging_1.ConsoleLogger(logging_1.LogLevel.warn);
        migrateFiles({ rootPath: rootPath, translationFilePaths: translationFilePaths, mappingFilePath: options.m, logger: logger });
        process.exit(0);
    }
    /** Migrates the legacy message IDs based on the passed in configuration. */
    function migrateFiles(_a) {
        var rootPath = _a.rootPath, translationFilePaths = _a.translationFilePaths, mappingFilePath = _a.mappingFilePath, logger = _a.logger;
        var fs = file_system_1.getFileSystem();
        var absoluteMappingPath = fs.resolve(rootPath, mappingFilePath);
        var mapping = JSON.parse(fs.readFile(absoluteMappingPath));
        if (Object.keys(mapping).length === 0) {
            logger.warn("Mapping file at " + absoluteMappingPath + " is empty. Either there are no messages " +
                "that need to be migrated, or the extraction step failed to find them.");
        }
        else {
            translationFilePaths.forEach(function (path) {
                var absolutePath = fs.resolve(rootPath, path);
                var sourceCode = fs.readFile(absolutePath);
                fs.writeFile(absolutePath, migrate_1.migrateFile(sourceCode, mapping));
            });
        }
    }
    exports.migrateFiles = migrateFiles;
});
//# sourceMappingURL=data:application/json;base64,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