/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ContentContainerComponentHarness, HarnessPredicate } from '@angular/cdk/testing';
import { BottomSheetHarnessFilters } from './bottom-sheet-harness-filters';
/** Harness for interacting with a standard MatBottomSheet in tests. */
export declare class MatBottomSheetHarness extends ContentContainerComponentHarness<string> {
    static hostSelector: string;
    /**
     * Gets a `HarnessPredicate` that can be used to search for a bottom sheet with
     * specific attributes.
     * @param options Options for narrowing the search.
     * @return a `HarnessPredicate` configured with the given options.
     */
    static with(options?: BottomSheetHarnessFilters): HarnessPredicate<MatBottomSheetHarness>;
    /** Gets the value of the bottom sheet's "aria-label" attribute. */
    getAriaLabel(): Promise<string | null>;
    /**
     * Dismisses the bottom sheet by pressing escape. Note that this method cannot
     * be used if "disableClose" has been set to true via the config.
     */
    dismiss(): Promise<void>;
}
