/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { Constructor, AbstractConstructor } from './constructor';
import { CanDisable } from './disabled';
/** @docs-private */
export interface HasTabIndex {
    /** Tabindex of the component. */
    tabIndex: number;
    /** Tabindex to which to fall back to if no value is set. */
    defaultTabIndex: number;
}
/**
 * @docs-private
 * @deprecated No longer necessary to apply to mixin classes. To be made private.
 * @breaking-change 13.0.0
 */
export declare type HasTabIndexCtor = Constructor<HasTabIndex> & AbstractConstructor<HasTabIndex>;
/** Mixin to augment a directive with a `tabIndex` property. */
export declare function mixinTabIndex<T extends AbstractConstructor<CanDisable>>(base: T, defaultTabIndex?: number): HasTabIndexCtor & T;
