/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * Reference to a previously launched ripple element.
 */
export class RippleRef {
    constructor(_renderer, 
    /** Reference to the ripple HTML element. */
    element, 
    /** Ripple configuration used for the ripple. */
    config) {
        this._renderer = _renderer;
        this.element = element;
        this.config = config;
        /** Current state of the ripple. */
        this.state = 3 /* HIDDEN */;
    }
    /** Fades out the ripple element. */
    fadeOut() {
        this._renderer.fadeOutRipple(this);
    }
}
//# sourceMappingURL=data:application/json;base64,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