"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isMaterialExportDeclaration = exports.isMaterialImportDeclaration = exports.cdkModuleSpecifier = exports.materialModuleSpecifier = void 0;
const schematics_1 = require("@angular/cdk/schematics");
/** Name of the Angular Material module specifier. */
exports.materialModuleSpecifier = '@angular/material';
/** Name of the Angular CDK module specifier. */
exports.cdkModuleSpecifier = '@angular/cdk';
/** Whether the specified node is part of an Angular Material or CDK import declaration. */
function isMaterialImportDeclaration(node) {
    return isMaterialDeclaration(schematics_1.getImportDeclaration(node));
}
exports.isMaterialImportDeclaration = isMaterialImportDeclaration;
/** Whether the specified node is part of an Angular Material or CDK import declaration. */
function isMaterialExportDeclaration(node) {
    return isMaterialDeclaration(schematics_1.getExportDeclaration(node));
}
exports.isMaterialExportDeclaration = isMaterialExportDeclaration;
/** Whether the declaration is part of Angular Material. */
function isMaterialDeclaration(declaration) {
    if (!declaration.moduleSpecifier) {
        return false;
    }
    const moduleSpecifier = declaration.moduleSpecifier.getText();
    return moduleSpecifier.indexOf(exports.materialModuleSpecifier) !== -1 ||
        moduleSpecifier.indexOf(exports.cdkModuleSpecifier) !== -1;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9kdWxlLXNwZWNpZmllcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9zcmMvbWF0ZXJpYWwvc2NoZW1hdGljcy9uZy11cGRhdGUvdHlwZXNjcmlwdC9tb2R1bGUtc3BlY2lmaWVycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7Ozs7OztHQU1HOzs7QUFFSCx3REFBbUY7QUFHbkYscURBQXFEO0FBQ3hDLFFBQUEsdUJBQXVCLEdBQUcsbUJBQW1CLENBQUM7QUFFM0QsZ0RBQWdEO0FBQ25DLFFBQUEsa0JBQWtCLEdBQUcsY0FBYyxDQUFDO0FBRWpELDJGQUEyRjtBQUMzRixTQUFnQiwyQkFBMkIsQ0FBQyxJQUFhO0lBQ3ZELE9BQU8scUJBQXFCLENBQUMsaUNBQW9CLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztBQUMzRCxDQUFDO0FBRkQsa0VBRUM7QUFFRCwyRkFBMkY7QUFDM0YsU0FBZ0IsMkJBQTJCLENBQUMsSUFBYTtJQUN2RCxPQUFPLHFCQUFxQixDQUFDLGlDQUFvQixDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7QUFDM0QsQ0FBQztBQUZELGtFQUVDO0FBRUQsMkRBQTJEO0FBQzNELFNBQVMscUJBQXFCLENBQUMsV0FBc0Q7SUFDbkYsSUFBSSxDQUFDLFdBQVcsQ0FBQyxlQUFlLEVBQUU7UUFDaEMsT0FBTyxLQUFLLENBQUM7S0FDZDtJQUVELE1BQU0sZUFBZSxHQUFHLFdBQVcsQ0FBQyxlQUFlLENBQUMsT0FBTyxFQUFFLENBQUM7SUFDOUQsT0FBTyxlQUFlLENBQUMsT0FBTyxDQUFDLCtCQUF1QixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQzFELGVBQWUsQ0FBQyxPQUFPLENBQUMsMEJBQWtCLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztBQUN6RCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7Z2V0RXhwb3J0RGVjbGFyYXRpb24sIGdldEltcG9ydERlY2xhcmF0aW9ufSBmcm9tICdAYW5ndWxhci9jZGsvc2NoZW1hdGljcyc7XG5pbXBvcnQgKiBhcyB0cyBmcm9tICd0eXBlc2NyaXB0JztcblxuLyoqIE5hbWUgb2YgdGhlIEFuZ3VsYXIgTWF0ZXJpYWwgbW9kdWxlIHNwZWNpZmllci4gKi9cbmV4cG9ydCBjb25zdCBtYXRlcmlhbE1vZHVsZVNwZWNpZmllciA9ICdAYW5ndWxhci9tYXRlcmlhbCc7XG5cbi8qKiBOYW1lIG9mIHRoZSBBbmd1bGFyIENESyBtb2R1bGUgc3BlY2lmaWVyLiAqL1xuZXhwb3J0IGNvbnN0IGNka01vZHVsZVNwZWNpZmllciA9ICdAYW5ndWxhci9jZGsnO1xuXG4vKiogV2hldGhlciB0aGUgc3BlY2lmaWVkIG5vZGUgaXMgcGFydCBvZiBhbiBBbmd1bGFyIE1hdGVyaWFsIG9yIENESyBpbXBvcnQgZGVjbGFyYXRpb24uICovXG5leHBvcnQgZnVuY3Rpb24gaXNNYXRlcmlhbEltcG9ydERlY2xhcmF0aW9uKG5vZGU6IHRzLk5vZGUpIHtcbiAgcmV0dXJuIGlzTWF0ZXJpYWxEZWNsYXJhdGlvbihnZXRJbXBvcnREZWNsYXJhdGlvbihub2RlKSk7XG59XG5cbi8qKiBXaGV0aGVyIHRoZSBzcGVjaWZpZWQgbm9kZSBpcyBwYXJ0IG9mIGFuIEFuZ3VsYXIgTWF0ZXJpYWwgb3IgQ0RLIGltcG9ydCBkZWNsYXJhdGlvbi4gKi9cbmV4cG9ydCBmdW5jdGlvbiBpc01hdGVyaWFsRXhwb3J0RGVjbGFyYXRpb24obm9kZTogdHMuTm9kZSkge1xuICByZXR1cm4gaXNNYXRlcmlhbERlY2xhcmF0aW9uKGdldEV4cG9ydERlY2xhcmF0aW9uKG5vZGUpKTtcbn1cblxuLyoqIFdoZXRoZXIgdGhlIGRlY2xhcmF0aW9uIGlzIHBhcnQgb2YgQW5ndWxhciBNYXRlcmlhbC4gKi9cbmZ1bmN0aW9uIGlzTWF0ZXJpYWxEZWNsYXJhdGlvbihkZWNsYXJhdGlvbjogdHMuSW1wb3J0RGVjbGFyYXRpb258dHMuRXhwb3J0RGVjbGFyYXRpb24pIHtcbiAgaWYgKCFkZWNsYXJhdGlvbi5tb2R1bGVTcGVjaWZpZXIpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH1cblxuICBjb25zdCBtb2R1bGVTcGVjaWZpZXIgPSBkZWNsYXJhdGlvbi5tb2R1bGVTcGVjaWZpZXIuZ2V0VGV4dCgpO1xuICByZXR1cm4gbW9kdWxlU3BlY2lmaWVyLmluZGV4T2YobWF0ZXJpYWxNb2R1bGVTcGVjaWZpZXIpICE9PSAtMSB8fFxuICAgICAgbW9kdWxlU3BlY2lmaWVyLmluZGV4T2YoY2RrTW9kdWxlU3BlY2lmaWVyKSAhPT0gLTE7XG59XG4iXX0=