/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { InjectionToken } from '@angular/core';
/** Injection token to be used to override the default options for `mat-checkbox`. */
export const MAT_CHECKBOX_DEFAULT_OPTIONS = new InjectionToken('mat-checkbox-default-options', {
    providedIn: 'root',
    factory: MAT_CHECKBOX_DEFAULT_OPTIONS_FACTORY
});
/** @docs-private */
export function MAT_CHECKBOX_DEFAULT_OPTIONS_FACTORY() {
    return {
        color: 'accent',
        clickAction: 'check-indeterminate',
    };
}
//# sourceMappingURL=data:application/json;base64,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