/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @fileoverview
 * A module to facilitate use of a Trusted Types policy internally within
 * Angular Material. It lazily constructs the Trusted Types policy, providing
 * helper utilities for promoting strings to Trusted Types. When Trusted Types
 * are not available, strings are used as a fallback.
 * @security All use of this module is security-sensitive and should go through
 * security review.
 */
export declare interface TrustedHTML {
    __brand__: 'TrustedHTML';
}
export declare interface TrustedTypePolicyFactory {
    createPolicy(policyName: string, policyOptions: {
        createHTML?: (input: string) => string;
    }): TrustedTypePolicy;
}
export declare interface TrustedTypePolicy {
    createHTML(input: string): TrustedHTML;
}
/**
 * Unsafely promote a string to a TrustedHTML, falling back to strings when
 * Trusted Types are not available.
 * @security This is a security-sensitive function; any use of this function
 * must go through security review. In particular, it must be assured that the
 * provided string will never cause an XSS vulnerability if used in a context
 * that will be interpreted as HTML by a browser, e.g. when assigning to
 * element.innerHTML.
 */
export declare function trustedHTMLFromString(html: string): TrustedHTML;
