/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var _MatTestDialogOpenerBase_1, MatTestDialogOpener_1;
import { __decorate, __metadata } from "tslib";
import { ChangeDetectionStrategy, Directive, Component, NgModule, ViewEncapsulation, } from '@angular/core';
import { _MatDialogBase, MatDialog, MatDialogModule, } from '@angular/material/dialog';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
/** Base class for a component that immediately opens a dialog when created. */
let _MatTestDialogOpenerBase = _MatTestDialogOpenerBase_1 = class _MatTestDialogOpenerBase {
    constructor(dialog) {
        this.dialog = dialog;
        if (!_MatTestDialogOpenerBase_1.component) {
            throw new Error(`MatTestDialogOpener does not have a component provided.`);
        }
        this.dialogRef = this.dialog.open(_MatTestDialogOpenerBase_1.component, _MatTestDialogOpenerBase_1.config || {});
        this._afterClosedSubscription = this.dialogRef.afterClosed().subscribe(result => {
            this.closedResult = result;
        });
    }
    ngOnDestroy() {
        this._afterClosedSubscription.unsubscribe();
        _MatTestDialogOpenerBase_1.component = undefined;
        _MatTestDialogOpenerBase_1.config = undefined;
    }
};
_MatTestDialogOpenerBase = _MatTestDialogOpenerBase_1 = __decorate([
    Directive(),
    __metadata("design:paramtypes", [_MatDialogBase])
], _MatTestDialogOpenerBase);
export { _MatTestDialogOpenerBase };
/** Test component that immediately opens a dialog when created. */
let MatTestDialogOpener = MatTestDialogOpener_1 = class MatTestDialogOpener extends _MatTestDialogOpenerBase {
    constructor(dialog) {
        super(dialog);
    }
    /** Static method that prepares this class to open the provided component. */
    static withComponent(component, config) {
        _MatTestDialogOpenerBase.component = component;
        _MatTestDialogOpenerBase.config = config;
        return MatTestDialogOpener_1;
    }
};
MatTestDialogOpener = MatTestDialogOpener_1 = __decorate([
    Component({
        selector: 'mat-test-dialog-opener',
        template: '',
        changeDetection: ChangeDetectionStrategy.OnPush,
        encapsulation: ViewEncapsulation.None,
    }),
    __metadata("design:paramtypes", [MatDialog])
], MatTestDialogOpener);
export { MatTestDialogOpener };
let MatTestDialogOpenerModule = class MatTestDialogOpenerModule {
};
MatTestDialogOpenerModule = __decorate([
    NgModule({
        declarations: [MatTestDialogOpener],
        imports: [MatDialogModule, NoopAnimationsModule],
    })
], MatTestDialogOpenerModule);
export { MatTestDialogOpenerModule };
//# sourceMappingURL=data:application/json;base64,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