import { ModuleWithProviders, ElementRef, ViewContainerRef, AnimationTransitionEvent, NgZone } from '@angular/core';
import { Overlay, OverlayRef } from '../core';
import { Observable } from 'rxjs/Observable';
export declare type TooltipPosition = 'before' | 'after' | 'above' | 'below';
/** Time in ms to delay before changing the tooltip visibility to hidden */
export declare const TOOLTIP_HIDE_DELAY: number;
/**
 * Directive that attaches a material design tooltip to the host element. Animates the showing and
 * hiding of a tooltip provided position (defaults to below the element).
 *
 * https://material.google.com/components/tooltips.html
 */
export declare class MdTooltip {
    private _overlay;
    private _elementRef;
    private _viewContainerRef;
    private _ngZone;
    _overlayRef: OverlayRef;
    _tooltipInstance: TooltipComponent;
    /** Allows the user to define the position of the tooltip relative to the parent element */
    private _position;
    position: TooltipPosition;
    /** The message to be displayed in the tooltip */
    private _message;
    message: string;
    constructor(_overlay: Overlay, _elementRef: ElementRef, _viewContainerRef: ViewContainerRef, _ngZone: NgZone);
    /** Dispose the tooltip when destroyed */
    ngOnDestroy(): void;
    /** Shows the tooltip */
    show(): void;
    /**
     * Create the overlay config and position strategy
     * Hides the tooltip after the provided delay in ms. Defaults the delay to the material design
     * prescribed delay time
     */
    hide(delay?: number): void;
    /** Shows/hides the tooltip */
    toggle(): void;
    /** Returns true if the tooltip is currently visible to the user */
    _isTooltipVisible(): boolean;
    /** Create the tooltip to display */
    private _createTooltip();
    /** Create the overlay config and position strategy */
    private _createOverlay();
    /** Disposes the current tooltip and the overlay it is attached to */
    private _disposeTooltip();
    /** Returns the origin position based on the user's position preference */
    private _getOrigin();
    /** Returns the overlay position based on the user's preference */
    private _getOverlayPosition();
    /** Updates the tooltip message and repositions the overlay according to the new message length */
    private _setTooltipMessage(message);
}
export declare type TooltipVisibility = 'visible' | 'hidden';
export declare class TooltipComponent {
    /** Message to display in the tooltip */
    message: string;
    /** The timeout ID of any current timer set to hide the tooltip */
    _hideTimeoutId: number;
    /** Property watched by the animation framework to show or hide the tooltip */
    _visibility: TooltipVisibility;
    /** Whether interactions on the page should close the tooltip */
    _closeOnInteraction: boolean;
    /** The transform origin used in the animation for showing and hiding the tooltip */
    _transformOrigin: string;
    /** Subject for notifying that the tooltip has been hidden from the view */
    private _onHide;
    /** Shows the tooltip with an animation originating from the provided origin */
    show(position: TooltipPosition): void;
    /** Begins the animation to hide the tooltip after the provided delay in ms */
    hide(delay: number): void;
    /** Returns an observable that notifies when the tooltip has been hidden from view */
    afterHidden(): Observable<void>;
    /** Whether the tooltip is being displayed */
    isVisible(): boolean;
    /** Sets the tooltip transform origin according to the tooltip position */
    _setTransformOrigin(value: TooltipPosition): void;
    _afterVisibilityAnimation(e: AnimationTransitionEvent): void;
    /**
     * Interactions on the HTML body should close the tooltip immediately as defined in the
     * material design spec.
     * https://material.google.com/components/tooltips.html#tooltips-interaction
     */
    _handleBodyInteraction(): void;
}
export declare class MdTooltipModule {
    static forRoot(): ModuleWithProviders;
}
