import { ElementRef, OnInit, OnDestroy } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { ScrollDispatcher } from './scroll-dispatcher';
import 'rxjs/add/observable/fromEvent';
/**
 * Sends an event when the directive's element is scrolled. Registers itself with the
 * ScrollDispatcher service to include itself as part of its collection of scrolling events that it
 * can be listened to through the service.
 */
export declare class Scrollable implements OnInit, OnDestroy {
    private _elementRef;
    private _scroll;
    constructor(_elementRef: ElementRef, _scroll: ScrollDispatcher);
    ngOnInit(): void;
    ngOnDestroy(): void;
    /**
     * Returns observable that emits when a scroll event is fired on the host element.
     */
    elementScrolled(): Observable<any>;
    getElementRef(): ElementRef;
}
