/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/core"),require("@angular/forms"),require("@angular/material/core"),require("@angular/common"),require("@angular/cdk/observers")):"function"==typeof define&&define.amd?define(["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/core","@angular/forms","@angular/material/core","@angular/common","@angular/cdk/observers"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.checkbox=e.ng.material.checkbox||{}),e.ng.cdk.a11y,e.ng.cdk.coercion,e.ng.core,e.ng.forms,e.ng.material.core,e.ng.common,e.ng.cdk.observers)}(this,function(e,t,n,i,a,c,o,r){"use strict";function s(e,t){function n(){this.constructor=e}m(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}var m=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])},h=new i.InjectionToken("mat-checkbox-click-action"),d=0,k={provide:a.NG_VALUE_ACCESSOR,useExisting:i.forwardRef(function(){return f}),multi:!0},u={Init:0,Checked:1,Unchecked:2,Indeterminate:3};u[u.Init]="Init",u[u.Checked]="Checked",u[u.Unchecked]="Unchecked",u[u.Indeterminate]="Indeterminate";var l=function(){function e(){}return e}(),p=function(){function e(e){this._elementRef=e}return e}(),b=c.mixinTabIndex(c.mixinColor(c.mixinDisableRipple(c.mixinDisabled(p)),"accent")),f=function(e){function a(t,n,a,c,o){var r=e.call(this,t)||this;return r._changeDetectorRef=n,r._focusMonitor=a,r._clickAction=o,r.ariaLabel="",r.ariaLabelledby=null,r._uniqueId="mat-checkbox-"+ ++d,r.id=r._uniqueId,r.labelPosition="after",r.name=null,r.change=new i.EventEmitter,r.indeterminateChange=new i.EventEmitter,r._onTouched=function(){},r._currentAnimationClass="",r._currentCheckState=u.Init,r._controlValueAccessorChangeFn=function(){},r._checked=!1,r._indeterminate=!1,r.tabIndex=parseInt(c)||0,r}return s(a,e),Object.defineProperty(a.prototype,"inputId",{get:function(){return(this.id||this._uniqueId)+"-input"},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"required",{get:function(){return this._required},set:function(e){this._required=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"align",{get:function(){return"after"==this.labelPosition?"start":"end"},set:function(e){this.labelPosition="start"==e?"after":"before"},enumerable:!0,configurable:!0}),a.prototype.ngAfterViewInit=function(){var e=this;this._focusMonitor.monitor(this._inputElement.nativeElement).subscribe(function(t){return e._onInputFocusChange(t)})},a.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._inputElement.nativeElement)},Object.defineProperty(a.prototype,"checked",{get:function(){return this._checked},set:function(e){e!=this.checked&&(this._checked=e,this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"indeterminate",{get:function(){return this._indeterminate},set:function(e){var t=e!=this._indeterminate;this._indeterminate=e,t&&(this._indeterminate?this._transitionCheckState(u.Indeterminate):this._transitionCheckState(this.checked?u.Checked:u.Unchecked),this.indeterminateChange.emit(this._indeterminate))},enumerable:!0,configurable:!0}),a.prototype._isRippleDisabled=function(){return this.disableRipple||this.disabled},a.prototype._onLabelTextChange=function(){this._changeDetectorRef.markForCheck()},a.prototype.writeValue=function(e){this.checked=!!e},a.prototype.registerOnChange=function(e){this._controlValueAccessorChangeFn=e},a.prototype.registerOnTouched=function(e){this._onTouched=e},a.prototype.setDisabledState=function(e){this.disabled=e,this._changeDetectorRef.markForCheck()},a.prototype._getAriaChecked=function(){return this.checked?"true":this.indeterminate?"mixed":"false"},a.prototype._transitionCheckState=function(e){var t=this._currentCheckState,n=this._elementRef.nativeElement;t!==e&&(this._currentAnimationClass.length>0&&n.classList.remove(this._currentAnimationClass),this._currentAnimationClass=this._getAnimationClassForCheckStateTransition(t,e),this._currentCheckState=e,this._currentAnimationClass.length>0&&n.classList.add(this._currentAnimationClass))},a.prototype._emitChangeEvent=function(){var e=new l;e.source=this,e.checked=this.checked,this._controlValueAccessorChangeFn(this.checked),this.change.emit(e)},a.prototype._onInputFocusChange=function(e){this._focusRipple||"keyboard"!==e?e||(this._removeFocusRipple(),this._onTouched()):this._focusRipple=this.ripple.launch(0,0,{persistent:!0})},a.prototype.toggle=function(){this.checked=!this.checked},a.prototype._onInputClick=function(e){var t=this;e.stopPropagation(),this.disabled||"noop"===this._clickAction?this.disabled||"noop"!==this._clickAction||(this._inputElement.nativeElement.checked=this.checked,this._inputElement.nativeElement.indeterminate=this.indeterminate):(this.indeterminate&&"check"!==this._clickAction&&Promise.resolve().then(function(){t._indeterminate=!1,t.indeterminateChange.emit(t._indeterminate)}),this.toggle(),this._transitionCheckState(this._checked?u.Checked:u.Unchecked),this._emitChangeEvent())},a.prototype.focus=function(){this._focusMonitor.focusVia(this._inputElement.nativeElement,"keyboard")},a.prototype._onInteractionEvent=function(e){e.stopPropagation()},a.prototype._getAnimationClassForCheckStateTransition=function(e,t){var n="";switch(e){case u.Init:if(t===u.Checked)n="unchecked-checked";else{if(t!=u.Indeterminate)return"";n="unchecked-indeterminate"}break;case u.Unchecked:n=t===u.Checked?"unchecked-checked":"unchecked-indeterminate";break;case u.Checked:n=t===u.Unchecked?"checked-unchecked":"checked-indeterminate";break;case u.Indeterminate:n=t===u.Checked?"indeterminate-checked":"indeterminate-unchecked"}return"mat-checkbox-anim-"+n},a.prototype._removeFocusRipple=function(){this._focusRipple&&(this._focusRipple.fadeOut(),this._focusRipple=null)},a.decorators=[{type:i.Component,args:[{selector:"mat-checkbox",template:'<label [attr.for]="inputId" class="mat-checkbox-layout" #label><div class="mat-checkbox-inner-container" [class.mat-checkbox-inner-container-no-side-margin]="!checkboxLabel.textContent || !checkboxLabel.textContent.trim()"><input #input class="mat-checkbox-input cdk-visually-hidden" type="checkbox" [id]="inputId" [required]="required" [checked]="checked" [attr.value]="value" [disabled]="disabled" [attr.name]="name" [tabIndex]="tabIndex" [indeterminate]="indeterminate" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" [attr.aria-checked]="_getAriaChecked()" (change)="_onInteractionEvent($event)" (click)="_onInputClick($event)"><div matRipple class="mat-checkbox-ripple" [matRippleTrigger]="label" [matRippleDisabled]="_isRippleDisabled()" [matRippleRadius]="25" [matRippleCentered]="true" [matRippleAnimation]="{enterDuration: 300}"></div><div class="mat-checkbox-frame"></div><div class="mat-checkbox-background"><svg version="1.1" focusable="false" class="mat-checkbox-checkmark" viewBox="0 0 24 24" xml:space="preserve"><path class="mat-checkbox-checkmark-path" fill="none" stroke="white" d="M4.1,12.7 9,17.6 20.3,6.3"/></svg><div class="mat-checkbox-mixedmark"></div></div></div><span class="mat-checkbox-label" #checkboxLabel (cdkObserveContent)="_onLabelTextChange()"><span style="display:none">&nbsp;</span><ng-content></ng-content></span></label>',styles:["@keyframes mat-checkbox-fade-in-background{0%{opacity:0}50%{opacity:1}}@keyframes mat-checkbox-fade-out-background{0%,50%{opacity:1}100%{opacity:0}}@keyframes mat-checkbox-unchecked-checked-checkmark-path{0%,50%{stroke-dashoffset:22.91026}50%{animation-timing-function:cubic-bezier(0,0,.2,.1)}100%{stroke-dashoffset:0}}@keyframes mat-checkbox-unchecked-indeterminate-mixedmark{0%,68.2%{transform:scaleX(0)}68.2%{animation-timing-function:cubic-bezier(0,0,0,1)}100%{transform:scaleX(1)}}@keyframes mat-checkbox-checked-unchecked-checkmark-path{from{animation-timing-function:cubic-bezier(.4,0,1,1);stroke-dashoffset:0}to{stroke-dashoffset:-22.91026}}@keyframes mat-checkbox-checked-indeterminate-checkmark{from{animation-timing-function:cubic-bezier(0,0,.2,.1);opacity:1;transform:rotate(0)}to{opacity:0;transform:rotate(45deg)}}@keyframes mat-checkbox-indeterminate-checked-checkmark{from{animation-timing-function:cubic-bezier(.14,0,0,1);opacity:0;transform:rotate(45deg)}to{opacity:1;transform:rotate(360deg)}}@keyframes mat-checkbox-checked-indeterminate-mixedmark{from{animation-timing-function:cubic-bezier(0,0,.2,.1);opacity:0;transform:rotate(-45deg)}to{opacity:1;transform:rotate(0)}}@keyframes mat-checkbox-indeterminate-checked-mixedmark{from{animation-timing-function:cubic-bezier(.14,0,0,1);opacity:1;transform:rotate(0)}to{opacity:0;transform:rotate(315deg)}}@keyframes mat-checkbox-indeterminate-unchecked-mixedmark{0%{animation-timing-function:linear;opacity:1;transform:scaleX(1)}100%,32.8%{opacity:0;transform:scaleX(0)}}.mat-checkbox-checkmark,.mat-checkbox-mixedmark{width:calc(100% - 4px)}.mat-checkbox-background,.mat-checkbox-frame{top:0;left:0;right:0;bottom:0;position:absolute;border-radius:2px;box-sizing:border-box;pointer-events:none}.mat-checkbox{transition:background .4s cubic-bezier(.25,.8,.25,1),box-shadow 280ms cubic-bezier(.4,0,.2,1);cursor:pointer}.mat-checkbox-layout{cursor:inherit;align-items:baseline;vertical-align:middle;display:inline-flex;white-space:nowrap}.mat-checkbox-inner-container{display:inline-block;height:20px;line-height:0;margin:auto;margin-right:8px;order:0;position:relative;vertical-align:middle;white-space:nowrap;width:20px;flex-shrink:0}[dir=rtl] .mat-checkbox-inner-container{margin-left:8px;margin-right:auto}.mat-checkbox-inner-container-no-side-margin{margin-left:0;margin-right:0}.mat-checkbox-frame{background-color:transparent;transition:border-color 90ms cubic-bezier(0,0,.2,.1);border-width:2px;border-style:solid}.mat-checkbox-background{align-items:center;display:inline-flex;justify-content:center;transition:background-color 90ms cubic-bezier(0,0,.2,.1),opacity 90ms cubic-bezier(0,0,.2,.1)}.mat-checkbox-checkmark{top:0;left:0;right:0;bottom:0;position:absolute;width:100%}.mat-checkbox-checkmark-path{stroke-dashoffset:22.91026;stroke-dasharray:22.91026;stroke-width:2.66667px}.mat-checkbox-mixedmark{height:2px;opacity:0;transform:scaleX(0) rotate(0)}.mat-checkbox-label-before .mat-checkbox-inner-container{order:1;margin-left:8px;margin-right:auto}[dir=rtl] .mat-checkbox-label-before .mat-checkbox-inner-container{margin-left:auto;margin-right:8px}.mat-checkbox-checked .mat-checkbox-checkmark{opacity:1}.mat-checkbox-checked .mat-checkbox-checkmark-path{stroke-dashoffset:0}.mat-checkbox-checked .mat-checkbox-mixedmark{transform:scaleX(1) rotate(-45deg)}.mat-checkbox-indeterminate .mat-checkbox-checkmark{opacity:0;transform:rotate(45deg)}.mat-checkbox-indeterminate .mat-checkbox-checkmark-path{stroke-dashoffset:0}.mat-checkbox-indeterminate .mat-checkbox-mixedmark{opacity:1;transform:scaleX(1) rotate(0)}.mat-checkbox-unchecked .mat-checkbox-background{background-color:transparent}.mat-checkbox-disabled{cursor:default}.mat-checkbox-anim-unchecked-checked .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-in-background}.mat-checkbox-anim-unchecked-checked .mat-checkbox-checkmark-path{animation:180ms linear 0s mat-checkbox-unchecked-checked-checkmark-path}.mat-checkbox-anim-unchecked-indeterminate .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-in-background}.mat-checkbox-anim-unchecked-indeterminate .mat-checkbox-mixedmark{animation:90ms linear 0s mat-checkbox-unchecked-indeterminate-mixedmark}.mat-checkbox-anim-checked-unchecked .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-out-background}.mat-checkbox-anim-checked-unchecked .mat-checkbox-checkmark-path{animation:90ms linear 0s mat-checkbox-checked-unchecked-checkmark-path}.mat-checkbox-anim-checked-indeterminate .mat-checkbox-checkmark{animation:90ms linear 0s mat-checkbox-checked-indeterminate-checkmark}.mat-checkbox-anim-checked-indeterminate .mat-checkbox-mixedmark{animation:90ms linear 0s mat-checkbox-checked-indeterminate-mixedmark}.mat-checkbox-anim-indeterminate-checked .mat-checkbox-checkmark{animation:.5s linear 0s mat-checkbox-indeterminate-checked-checkmark}.mat-checkbox-anim-indeterminate-checked .mat-checkbox-mixedmark{animation:.5s linear 0s mat-checkbox-indeterminate-checked-mixedmark}.mat-checkbox-anim-indeterminate-unchecked .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-out-background}.mat-checkbox-anim-indeterminate-unchecked .mat-checkbox-mixedmark{animation:.3s linear 0s mat-checkbox-indeterminate-unchecked-mixedmark}.mat-checkbox-input{bottom:0;left:50%}.mat-checkbox-ripple{position:absolute;left:-15px;top:-15px;height:50px;width:50px;z-index:1;pointer-events:none}"],exportAs:"matCheckbox",host:{class:"mat-checkbox","[id]":"id","[class.mat-checkbox-indeterminate]":"indeterminate","[class.mat-checkbox-checked]":"checked","[class.mat-checkbox-disabled]":"disabled","[class.mat-checkbox-label-before]":'labelPosition == "before"'},providers:[k],inputs:["disabled","disableRipple","color","tabIndex"],encapsulation:i.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:i.ChangeDetectionStrategy.OnPush}]}],a.ctorParameters=function(){return[{type:i.ElementRef},{type:i.ChangeDetectorRef},{type:t.FocusMonitor},{type:void 0,decorators:[{type:i.Attribute,args:["tabindex"]}]},{type:void 0,decorators:[{type:i.Optional},{type:i.Inject,args:[h]}]}]},a.propDecorators={ariaLabel:[{type:i.Input,args:["aria-label"]}],ariaLabelledby:[{type:i.Input,args:["aria-labelledby"]}],id:[{type:i.Input}],required:[{type:i.Input}],align:[{type:i.Input}],labelPosition:[{type:i.Input}],name:[{type:i.Input}],change:[{type:i.Output}],indeterminateChange:[{type:i.Output}],value:[{type:i.Input}],_inputElement:[{type:i.ViewChild,args:["input"]}],ripple:[{type:i.ViewChild,args:[c.MatRipple]}],checked:[{type:i.Input}],indeterminate:[{type:i.Input}]},a}(b),x={provide:a.NG_VALIDATORS,useExisting:i.forwardRef(function(){return g}),multi:!0},g=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return s(t,e),t.decorators=[{type:i.Directive,args:[{selector:"mat-checkbox[required][formControlName],\n             mat-checkbox[required][formControl], mat-checkbox[required][ngModel]",providers:[x],host:{"[attr.required]":'required ? "" : null'}}]}],t.ctorParameters=function(){return[]},t}(a.CheckboxRequiredValidator),y=function(){function e(){}return e.decorators=[{type:i.NgModule,args:[{imports:[o.CommonModule,c.MatRippleModule,c.MatCommonModule,r.ObserversModule,t.A11yModule],exports:[f,g,c.MatCommonModule],declarations:[f,g]}]}],e.ctorParameters=function(){return[]},e}();e.MAT_CHECKBOX_CONTROL_VALUE_ACCESSOR=k,e.TransitionCheckState=u,e.MatCheckboxChange=l,e.MatCheckboxBase=p,e._MatCheckboxMixinBase=b,e.MatCheckbox=f,e.MAT_CHECKBOX_CLICK_ACTION=h,e.MatCheckboxModule=y,e.MAT_CHECKBOX_REQUIRED_VALIDATOR=x,e.MatCheckboxRequiredValidator=g,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-checkbox.umd.min.js.map
