/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/common"),require("@angular/core"),require("@angular/material/button"),require("@angular/material/select"),require("@angular/material/tooltip"),require("@angular/cdk/coercion"),require("rxjs/Subject")):"function"==typeof define&&define.amd?define(["exports","@angular/common","@angular/core","@angular/material/button","@angular/material/select","@angular/material/tooltip","@angular/cdk/coercion","rxjs/Subject"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.paginator=t.ng.material.paginator||{}),t.ng.common,t.ng.core,t.ng.material.button,t.ng.material.select,t.ng.material.tooltip,t.ng.cdk.coercion,t.Rx)}(this,function(t,e,a,i,n,r,o,s){"use strict";function g(t){return t||new p}var p=function(){function t(){this.changes=new s.Subject,this.itemsPerPageLabel="Items per page:",this.nextPageLabel="Next page",this.previousPageLabel="Previous page",this.firstPageLabel="First page",this.lastPageLabel="Last page",this.getRangeLabel=function(t,e,a){if(0==a||0==e)return"0 of "+a;a=Math.max(a,0);var i=t*e;return i+1+" - "+(i<a?Math.min(i+e,a):i+e)+" of "+a}}return t.decorators=[{type:a.Injectable}],t.ctorParameters=function(){return[]},t}(),l={provide:p,deps:[[new a.Optional,new a.SkipSelf,p]],useFactory:g},c=function(){function t(){}return t}(),u=function(){function t(t,e){var i=this;this._intl=t,this._changeDetectorRef=e,this._pageIndex=0,this._length=0,this._pageSizeOptions=[],this._hidePageSize=!1,this._showFirstLastButtons=!1,this.page=new a.EventEmitter,this._intlChanges=t.changes.subscribe(function(){return i._changeDetectorRef.markForCheck()})}return Object.defineProperty(t.prototype,"pageIndex",{get:function(){return this._pageIndex},set:function(t){this._pageIndex=o.coerceNumberProperty(t),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"length",{get:function(){return this._length},set:function(t){this._length=o.coerceNumberProperty(t),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"pageSize",{get:function(){return this._pageSize},set:function(t){this._pageSize=o.coerceNumberProperty(t),this._updateDisplayedPageSizeOptions()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"pageSizeOptions",{get:function(){return this._pageSizeOptions},set:function(t){this._pageSizeOptions=(t||[]).map(function(t){return o.coerceNumberProperty(t)}),this._updateDisplayedPageSizeOptions()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"hidePageSize",{get:function(){return this._hidePageSize},set:function(t){this._hidePageSize=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"showFirstLastButtons",{get:function(){return this._showFirstLastButtons},set:function(t){this._showFirstLastButtons=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),t.prototype.ngOnInit=function(){this._initialized=!0,this._updateDisplayedPageSizeOptions()},t.prototype.ngOnDestroy=function(){this._intlChanges.unsubscribe()},t.prototype.nextPage=function(){this.hasNextPage()&&(this.pageIndex++,this._emitPageEvent())},t.prototype.previousPage=function(){this.hasPreviousPage()&&(this.pageIndex--,this._emitPageEvent())},t.prototype.firstPage=function(){this.hasPreviousPage()&&(this.pageIndex=0,this._emitPageEvent())},t.prototype.lastPage=function(){this.hasNextPage()&&(this.pageIndex=this.getNumberOfPages(),this._emitPageEvent())},t.prototype.hasPreviousPage=function(){return this.pageIndex>=1&&0!=this.pageSize},t.prototype.hasNextPage=function(){var t=this.getNumberOfPages();return this.pageIndex<t&&0!=this.pageSize},t.prototype.getNumberOfPages=function(){return Math.ceil(this.length/this.pageSize)-1},t.prototype._changePageSize=function(t){var e=this.pageIndex*this.pageSize;this.pageIndex=Math.floor(e/t)||0,this.pageSize=t,this._emitPageEvent()},t.prototype._updateDisplayedPageSizeOptions=function(){this._initialized&&(this.pageSize||(this._pageSize=0!=this.pageSizeOptions.length?this.pageSizeOptions[0]:50),this._displayedPageSizeOptions=this.pageSizeOptions.slice(),-1==this._displayedPageSizeOptions.indexOf(this.pageSize)&&this._displayedPageSizeOptions.push(this.pageSize),this._displayedPageSizeOptions.sort(function(t,e){return t-e}),this._changeDetectorRef.markForCheck())},t.prototype._emitPageEvent=function(){this.page.emit({pageIndex:this.pageIndex,pageSize:this.pageSize,length:this.length})},t.decorators=[{type:a.Component,args:[{selector:"mat-paginator",exportAs:"matPaginator",template:'<div class="mat-paginator-container"><div class="mat-paginator-page-size" *ngIf="!hidePageSize"><div class="mat-paginator-page-size-label">{{_intl.itemsPerPageLabel}}</div><mat-form-field *ngIf="_displayedPageSizeOptions.length > 1" class="mat-paginator-page-size-select"><mat-select [value]="pageSize" [aria-label]="_intl.itemsPerPageLabel" (change)="_changePageSize($event.value)"><mat-option *ngFor="let pageSizeOption of _displayedPageSizeOptions" [value]="pageSizeOption">{{pageSizeOption}}</mat-option></mat-select></mat-form-field><div *ngIf="_displayedPageSizeOptions.length <= 1">{{pageSize}}</div></div><div class="mat-paginator-range-actions"><div class="mat-paginator-range-label">{{_intl.getRangeLabel(pageIndex, pageSize, length)}}</div><button mat-icon-button type="button" class="mat-paginator-navigation-first" (click)="firstPage()" [attr.aria-label]="_intl.firstPageLabel" [matTooltip]="_intl.firstPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasPreviousPage()" *ngIf="showFirstLastButtons"><div class="mat-paginator-first"></div><div class="mat-paginator-decrement"></div></button> <button mat-icon-button type="button" class="mat-paginator-navigation-previous" (click)="previousPage()" [attr.aria-label]="_intl.previousPageLabel" [matTooltip]="_intl.previousPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasPreviousPage()"><div class="mat-paginator-decrement"></div></button> <button mat-icon-button type="button" class="mat-paginator-navigation-next" (click)="nextPage()" [attr.aria-label]="_intl.nextPageLabel" [matTooltip]="_intl.nextPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasNextPage()"><div class="mat-paginator-increment"></div></button> <button mat-icon-button type="button" class="mat-paginator-navigation-last" (click)="lastPage()" [attr.aria-label]="_intl.lastPageLabel" [matTooltip]="_intl.lastPageLabel" [matTooltipPosition]="\'above\'" [disabled]="!hasNextPage()" *ngIf="showFirstLastButtons"><div class="mat-paginator-increment"></div><div class="mat-paginator-last"></div></button></div></div>',styles:[".mat-paginator{display:block}.mat-paginator-container{display:flex;align-items:center;justify-content:flex-end;min-height:56px;padding:0 8px;flex-wrap:wrap-reverse}.mat-paginator-page-size{display:flex;align-items:baseline;margin-right:8px}.mat-paginator-page-size-label{margin:0 4px}.mat-paginator-page-size-select{margin:6px 4px 0 4px;width:56px}.mat-paginator-range-label{margin:0 32px 0 24px}.mat-paginator-decrement-button+.mat-paginator-decrement-button{margin:0 0 0 8px}[dir=rtl] .mat-paginator-decrement-button+.mat-paginator-decrement-button{margin:0 8px 0 0}.mat-paginator-decrement,.mat-paginator-increment{width:8px;height:8px}.mat-paginator-increment,[dir=rtl] .mat-paginator-decrement{transform:rotate(45deg)}.mat-paginator-decrement,[dir=rtl] .mat-paginator-increment{transform:rotate(225deg)}.mat-paginator-increment{margin-left:12px}[dir=rtl] .mat-paginator-increment{margin-right:12px}.mat-paginator-decrement{margin-left:16px}[dir=rtl] .mat-paginator-decrement{margin-right:16px}.mat-paginator-first{transform:rotate(90deg);width:14px;height:8px;float:left;margin-left:3px}.mat-paginator-navigation-first .mat-paginator-decrement{margin-left:21px}.mat-paginator-navigation-last .mat-paginator-increment{float:left;margin-left:9px}.mat-paginator-last{transform:rotate(90deg);width:14px;height:8px;margin-left:15px}.mat-paginator-range-actions{display:flex;align-items:center;min-height:48px}"],host:{class:"mat-paginator"},changeDetection:a.ChangeDetectionStrategy.OnPush,encapsulation:a.ViewEncapsulation.None,preserveWhitespaces:!1}]}],t.ctorParameters=function(){return[{type:p},{type:a.ChangeDetectorRef}]},t.propDecorators={pageIndex:[{type:a.Input}],length:[{type:a.Input}],pageSize:[{type:a.Input}],pageSizeOptions:[{type:a.Input}],hidePageSize:[{type:a.Input}],showFirstLastButtons:[{type:a.Input}],page:[{type:a.Output}]},t}(),m=function(){function t(){}return t.decorators=[{type:a.NgModule,args:[{imports:[e.CommonModule,i.MatButtonModule,n.MatSelectModule,r.MatTooltipModule],exports:[u],declarations:[u],providers:[l]}]}],t.ctorParameters=function(){return[]},t}();t.MatPaginatorModule=m,t.PageEvent=c,t.MatPaginator=u,t.MatPaginatorIntl=p,t.MAT_PAGINATOR_INTL_PROVIDER_FACTORY=g,t.MAT_PAGINATOR_INTL_PROVIDER=l,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-paginator.umd.min.js.map
