/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/cdk/a11y"),require("@angular/cdk/bidi"),require("@angular/common"),require("@angular/core"),require("@angular/material/core"),require("@angular/platform-browser"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/forms"),require("rxjs/Subscription")):"function"==typeof define&&define.amd?define(["exports","@angular/cdk/a11y","@angular/cdk/bidi","@angular/common","@angular/core","@angular/material/core","@angular/platform-browser","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/forms","rxjs/Subscription"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.slider=t.ng.material.slider||{}),t.ng.cdk.a11y,t.ng.cdk.bidi,t.ng.common,t.ng.core,t.ng.material.core,t.ng.platformBrowser,t.ng.cdk.coercion,t.ng.cdk.keycodes,t.ng.forms,t.Rx)}(this,function(t,e,i,r,a,s,n,o,l,c,d){"use strict";function u(t,e){function i(){this.constructor=t}h(t,e),t.prototype=null===e?Object.create(e):(i.prototype=e.prototype,new i)}var h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var i in e)e.hasOwnProperty(i)&&(t[i]=e[i])},m={provide:c.NG_VALUE_ACCESSOR,useExisting:a.forwardRef(function(){return _}),multi:!0},p=function(){function t(){}return t}(),b=function(){function t(t){this._elementRef=t}return t}(),f=s.mixinTabIndex(s.mixinColor(s.mixinDisabled(b),"accent")),_=function(t){function r(e,i,r,s,n){var o=t.call(this,e)||this;return o._focusMonitor=i,o._changeDetectorRef=r,o._dir=s,o._invert=!1,o._max=100,o._min=0,o._step=1,o._thumbLabel=!1,o._tickInterval=0,o._value=null,o._vertical=!1,o.change=new a.EventEmitter,o.input=new a.EventEmitter,o.onTouched=function(){},o._percent=0,o._isSliding=!1,o._isActive=!1,o._tickIntervalPercent=0,o._sliderDimensions=null,o._controlValueAccessorChangeFn=function(){},o._dirChangeSubscription=d.Subscription.EMPTY,o.tabIndex=parseInt(n)||0,o}return u(r,t),Object.defineProperty(r.prototype,"invert",{get:function(){return this._invert},set:function(t){this._invert=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"max",{get:function(){return this._max},set:function(t){this._max=o.coerceNumberProperty(t,this._max),this._percent=this._calculatePercentage(this._value),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"min",{get:function(){return this._min},set:function(t){this._min=o.coerceNumberProperty(t,this._min),null===this._value&&(this.value=this._min),this._percent=this._calculatePercentage(this._value),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"step",{get:function(){return this._step},set:function(t){this._step=o.coerceNumberProperty(t,this._step),this._step%1!=0&&(this._roundLabelTo=this._step.toString().split(".").pop().length),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"thumbLabel",{get:function(){return this._thumbLabel},set:function(t){this._thumbLabel=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_thumbLabelDeprecated",{get:function(){return this._thumbLabel},set:function(t){this._thumbLabel=t},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"tickInterval",{get:function(){return this._tickInterval},set:function(t){this._tickInterval="auto"===t?"auto":"number"==typeof t||"string"==typeof t?o.coerceNumberProperty(t,this._tickInterval):0},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_tickIntervalDeprecated",{get:function(){return this.tickInterval},set:function(t){this.tickInterval=t},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"value",{get:function(){return null===this._value&&(this.value=this._min),this._value},set:function(t){t!==this._value&&(this._value=o.coerceNumberProperty(t,this._value||0),this._percent=this._calculatePercentage(this._value),this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"vertical",{get:function(){return this._vertical},set:function(t){this._vertical=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"displayValue",{get:function(){return this._roundLabelTo&&this.value&&this.value%1!=0?this.value.toFixed(this._roundLabelTo):this.value||0},enumerable:!0,configurable:!0}),r.prototype.focus=function(){this._focusHostElement()},r.prototype.blur=function(){this._blurHostElement()},Object.defineProperty(r.prototype,"percent",{get:function(){return this._clamp(this._percent)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_invertAxis",{get:function(){return this.vertical?!this.invert:this.invert},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_isMinValue",{get:function(){return 0===this.percent},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_thumbGap",{get:function(){return this.disabled?7:this._isMinValue&&!this.thumbLabel?this._isActive?10:7:0},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_trackBackgroundStyles",{get:function(){var t=this.vertical?"Y":"X";return{transform:"translate"+t+"("+(this._invertMouseCoords?"-":"")+this._thumbGap+"px) scale"+t+"("+(1-this.percent)+")"}},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_trackFillStyles",{get:function(){var t=this.vertical?"Y":"X";return{transform:"translate"+t+"("+(this._invertMouseCoords?"":"-")+this._thumbGap+"px) scale"+t+"("+this.percent+")"}},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_ticksContainerStyles",{get:function(){return{transform:"translate"+(this.vertical?"Y":"X")+"("+(this.vertical||"rtl"!=this._direction?"-":"")+this._tickIntervalPercent/2*100+"%)"}},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_ticksStyles",{get:function(){var t=100*this._tickIntervalPercent,e=this.vertical?"2px "+t+"%":t+"% 2px",i=this.vertical?"Y":"X",r=this.vertical||"rtl"!=this._direction?"":"-",a=this.vertical||"rtl"!=this._direction?"":" rotate(180deg)",s={backgroundSize:e,transform:"translateZ(0) translate"+i+"("+r+t/2+"%)"+a};if(this._isMinValue&&this._thumbGap){s["padding"+(this.vertical?this._invertAxis?"Bottom":"Top":this._invertAxis?"Right":"Left")]=this._thumbGap+"px"}return s},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_thumbContainerStyles",{get:function(){return{transform:"translate"+(this.vertical?"Y":"X")+"(-"+100*(("rtl"!=this._direction||this.vertical?this._invertAxis:!this._invertAxis)?this.percent:1-this.percent)+"%)"}},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_invertMouseCoords",{get:function(){return"rtl"!=this._direction||this.vertical?this._invertAxis:!this._invertAxis},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"_direction",{get:function(){return this._dir&&"rtl"==this._dir.value?"rtl":"ltr"},enumerable:!0,configurable:!0}),r.prototype.ngOnInit=function(){var t=this;this._focusMonitor.monitor(this._elementRef.nativeElement,!0).subscribe(function(e){t._isActive=!!e&&"keyboard"!==e,t._changeDetectorRef.detectChanges()}),this._dir&&(this._dirChangeSubscription=this._dir.change.subscribe(function(){t._changeDetectorRef.markForCheck()}))},r.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._elementRef.nativeElement),this._dirChangeSubscription.unsubscribe()},r.prototype._onMouseenter=function(){this.disabled||(this._sliderDimensions=this._getSliderDimensions(),this._updateTickIntervalPercent())},r.prototype._onClick=function(t){if(!this.disabled){var e=this.value;this._isSliding=!1,this._focusHostElement(),this._updateValueFromPosition({x:t.clientX,y:t.clientY}),e!=this.value&&(this._emitInputEvent(),this._emitChangeEvent())}},r.prototype._onSlide=function(t){if(!this.disabled){this._isSliding||this._onSlideStart(null),t.preventDefault();var e=this.value;this._updateValueFromPosition({x:t.center.x,y:t.center.y}),e!=this.value&&this._emitInputEvent()}},r.prototype._onSlideStart=function(t){this.disabled||this._isSliding||(this._onMouseenter(),this._isSliding=!0,this._focusHostElement(),this._valueOnSlideStart=this.value,t&&(this._updateValueFromPosition({x:t.center.x,y:t.center.y}),t.preventDefault()))},r.prototype._onSlideEnd=function(){this._isSliding=!1,this._valueOnSlideStart==this.value||this.disabled||this._emitChangeEvent(),this._valueOnSlideStart=null},r.prototype._onFocus=function(){this._sliderDimensions=this._getSliderDimensions(),this._updateTickIntervalPercent()},r.prototype._onBlur=function(){this.onTouched()},r.prototype._onKeydown=function(t){if(!this.disabled){var e=this.value;switch(t.keyCode){case l.PAGE_UP:this._increment(10);break;case l.PAGE_DOWN:this._increment(-10);break;case l.END:this.value=this.max;break;case l.HOME:this.value=this.min;break;case l.LEFT_ARROW:this._increment("rtl"==this._direction?1:-1);break;case l.UP_ARROW:this._increment(1);break;case l.RIGHT_ARROW:this._increment("rtl"==this._direction?-1:1);break;case l.DOWN_ARROW:this._increment(-1);break;default:return}e!=this.value&&(this._emitInputEvent(),this._emitChangeEvent()),this._isSliding=!0,t.preventDefault()}},r.prototype._onKeyup=function(){this._isSliding=!1},r.prototype._increment=function(t){this.value=this._clamp((this.value||0)+this.step*t,this.min,this.max)},r.prototype._updateValueFromPosition=function(t){if(this._sliderDimensions){var e=this.vertical?this._sliderDimensions.top:this._sliderDimensions.left,i=this.vertical?this._sliderDimensions.height:this._sliderDimensions.width,r=this.vertical?t.y:t.x,a=this._clamp((r-e)/i);this._invertMouseCoords&&(a=1-a);var s=this._calculateValue(a),n=Math.round((s-this.min)/this.step)*this.step+this.min;this.value=this._clamp(n,this.min,this.max)}},r.prototype._emitChangeEvent=function(){this._controlValueAccessorChangeFn(this.value),this.change.emit(this._createChangeEvent())},r.prototype._emitInputEvent=function(){this.input.emit(this._createChangeEvent())},r.prototype._updateTickIntervalPercent=function(){if(this.tickInterval&&this._sliderDimensions)if("auto"==this.tickInterval){var t=this.vertical?this._sliderDimensions.height:this._sliderDimensions.width,e=t*this.step/(this.max-this.min),i=Math.ceil(30/e),r=i*this.step;this._tickIntervalPercent=r/t}else this._tickIntervalPercent=this.tickInterval*this.step/(this.max-this.min)},r.prototype._createChangeEvent=function(t){void 0===t&&(t=this.value);var e=new p;return e.source=this,e.value=t,e},r.prototype._calculatePercentage=function(t){return((t||0)-this.min)/(this.max-this.min)},r.prototype._calculateValue=function(t){return this.min+t*(this.max-this.min)},r.prototype._clamp=function(t,e,i){return void 0===e&&(e=0),void 0===i&&(i=1),Math.max(e,Math.min(t,i))},r.prototype._getSliderDimensions=function(){return this._sliderWrapper?this._sliderWrapper.nativeElement.getBoundingClientRect():null},r.prototype._focusHostElement=function(){this._elementRef.nativeElement.focus()},r.prototype._blurHostElement=function(){this._elementRef.nativeElement.blur()},r.prototype.writeValue=function(t){this.value=t},r.prototype.registerOnChange=function(t){this._controlValueAccessorChangeFn=t},r.prototype.registerOnTouched=function(t){this.onTouched=t},r.prototype.setDisabledState=function(t){this.disabled=t},r.decorators=[{type:a.Component,args:[{selector:"mat-slider",exportAs:"matSlider",providers:[m],host:{"(focus)":"_onFocus()","(blur)":"_onBlur()","(click)":"_onClick($event)","(keydown)":"_onKeydown($event)","(keyup)":"_onKeyup()","(mouseenter)":"_onMouseenter()","(slide)":"_onSlide($event)","(slideend)":"_onSlideEnd()","(slidestart)":"_onSlideStart($event)",class:"mat-slider",role:"slider","[tabIndex]":"tabIndex","[attr.aria-disabled]":"disabled","[attr.aria-valuemax]":"max","[attr.aria-valuemin]":"min","[attr.aria-valuenow]":"value","[attr.aria-orientation]":'vertical ? "vertical" : "horizontal"',"[class.mat-slider-disabled]":"disabled","[class.mat-slider-has-ticks]":"tickInterval","[class.mat-slider-horizontal]":"!vertical","[class.mat-slider-axis-inverted]":"_invertAxis","[class.mat-slider-sliding]":"_isSliding","[class.mat-slider-thumb-label-showing]":"thumbLabel","[class.mat-slider-vertical]":"vertical","[class.mat-slider-min-value]":"_isMinValue","[class.mat-slider-hide-last-tick]":"disabled || _isMinValue && _thumbGap && _invertAxis"},template:'<div class="mat-slider-wrapper" #sliderWrapper><div class="mat-slider-track-wrapper"><div class="mat-slider-track-background" [ngStyle]="_trackBackgroundStyles"></div><div class="mat-slider-track-fill" [ngStyle]="_trackFillStyles"></div></div><div class="mat-slider-ticks-container" [ngStyle]="_ticksContainerStyles"><div class="mat-slider-ticks" [ngStyle]="_ticksStyles"></div></div><div class="mat-slider-thumb-container" [ngStyle]="_thumbContainerStyles"><div class="mat-slider-focus-ring"></div><div class="mat-slider-thumb"></div><div class="mat-slider-thumb-label"><span class="mat-slider-thumb-label-text">{{displayValue}}</span></div></div></div>',styles:[".mat-slider{display:inline-block;position:relative;box-sizing:border-box;padding:8px;outline:0;vertical-align:middle}.mat-slider-wrapper{position:absolute}.mat-slider-track-wrapper{position:absolute;top:0;left:0;overflow:hidden}.mat-slider-track-fill{position:absolute;transform-origin:0 0;transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-track-background{position:absolute;transform-origin:100% 100%;transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-ticks-container{position:absolute;left:0;top:0;overflow:hidden}.mat-slider-ticks{background-repeat:repeat;background-clip:content-box;box-sizing:border-box;opacity:0;transition:opacity .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-thumb-container{position:absolute;z-index:1;transition:transform .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-focus-ring{position:absolute;width:30px;height:30px;border-radius:50%;transform:scale(0);opacity:0;transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1),opacity .4s cubic-bezier(.25,.8,.25,1)}.cdk-keyboard-focused .mat-slider-focus-ring,.cdk-program-focused .mat-slider-focus-ring{transform:scale(1);opacity:1}.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb,.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb-label{cursor:-webkit-grab;cursor:grab}.mat-slider-sliding:not(.mat-slider-disabled) .mat-slider-thumb,.mat-slider-sliding:not(.mat-slider-disabled) .mat-slider-thumb-label,.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb-label:active,.mat-slider:not(.mat-slider-disabled) .mat-slider-thumb:active{cursor:-webkit-grabbing;cursor:grabbing}.mat-slider-thumb{position:absolute;right:-10px;bottom:-10px;box-sizing:border-box;width:20px;height:20px;border:3px solid transparent;border-radius:50%;transform:scale(.7);transition:transform .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1),border-color .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-thumb-label{display:none;align-items:center;justify-content:center;position:absolute;width:28px;height:28px;border-radius:50%;transition:transform .4s cubic-bezier(.25,.8,.25,1),border-radius .4s cubic-bezier(.25,.8,.25,1),background-color .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-thumb-label-text{z-index:1;opacity:0;transition:opacity .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-sliding .mat-slider-thumb-container,.mat-slider-sliding .mat-slider-track-background,.mat-slider-sliding .mat-slider-track-fill{transition-duration:0s}.mat-slider-has-ticks .mat-slider-wrapper::after{content:'';position:absolute;border-width:0;border-style:solid;opacity:0;transition:opacity .4s cubic-bezier(.25,.8,.25,1)}.mat-slider-has-ticks.cdk-focused:not(.mat-slider-hide-last-tick) .mat-slider-wrapper::after,.mat-slider-has-ticks:hover:not(.mat-slider-hide-last-tick) .mat-slider-wrapper::after{opacity:1}.mat-slider-has-ticks.cdk-focused:not(.mat-slider-disabled) .mat-slider-ticks,.mat-slider-has-ticks:hover:not(.mat-slider-disabled) .mat-slider-ticks{opacity:1}.mat-slider-thumb-label-showing .mat-slider-focus-ring{transform:scale(0);opacity:0}.mat-slider-thumb-label-showing .mat-slider-thumb-label{display:flex}.mat-slider-axis-inverted .mat-slider-track-fill{transform-origin:100% 100%}.mat-slider-axis-inverted .mat-slider-track-background{transform-origin:0 0}.mat-slider:not(.mat-slider-disabled).cdk-focused.mat-slider-thumb-label-showing .mat-slider-thumb{transform:scale(0)}.mat-slider:not(.mat-slider-disabled).cdk-focused .mat-slider-thumb-label{border-radius:50% 50% 0}.mat-slider:not(.mat-slider-disabled).cdk-focused .mat-slider-thumb-label-text{opacity:1}.mat-slider:not(.mat-slider-disabled).cdk-mouse-focused .mat-slider-thumb,.mat-slider:not(.mat-slider-disabled).cdk-program-focused .mat-slider-thumb,.mat-slider:not(.mat-slider-disabled).cdk-touch-focused .mat-slider-thumb{border-width:2px;transform:scale(1)}.mat-slider-disabled .mat-slider-focus-ring{transform:scale(0);opacity:0}.mat-slider-disabled .mat-slider-thumb{border-width:4px;transform:scale(.5)}.mat-slider-disabled .mat-slider-thumb-label{display:none}.mat-slider-horizontal{height:48px;min-width:128px}.mat-slider-horizontal .mat-slider-wrapper{height:2px;top:23px;left:8px;right:8px}.mat-slider-horizontal .mat-slider-wrapper::after{height:2px;border-left-width:2px;right:0;top:0}.mat-slider-horizontal .mat-slider-track-wrapper{height:2px;width:100%}.mat-slider-horizontal .mat-slider-track-fill{height:2px;width:100%;transform:scaleX(0)}.mat-slider-horizontal .mat-slider-track-background{height:2px;width:100%;transform:scaleX(1)}.mat-slider-horizontal .mat-slider-ticks-container{height:2px;width:100%}.mat-slider-horizontal .mat-slider-ticks{height:2px;width:100%}.mat-slider-horizontal .mat-slider-thumb-container{width:100%;height:0;top:50%}.mat-slider-horizontal .mat-slider-focus-ring{top:-15px;right:-15px}.mat-slider-horizontal .mat-slider-thumb-label{right:-14px;top:-40px;transform:translateY(26px) scale(.01) rotate(45deg)}.mat-slider-horizontal .mat-slider-thumb-label-text{transform:rotate(-45deg)}.mat-slider-horizontal.cdk-focused .mat-slider-thumb-label{transform:rotate(45deg)}.mat-slider-vertical{width:48px;min-height:128px}.mat-slider-vertical .mat-slider-wrapper{width:2px;top:8px;bottom:8px;left:23px}.mat-slider-vertical .mat-slider-wrapper::after{width:2px;border-top-width:2px;bottom:0;left:0}.mat-slider-vertical .mat-slider-track-wrapper{height:100%;width:2px}.mat-slider-vertical .mat-slider-track-fill{height:100%;width:2px;transform:scaleY(0)}.mat-slider-vertical .mat-slider-track-background{height:100%;width:2px;transform:scaleY(1)}.mat-slider-vertical .mat-slider-ticks-container{width:2px;height:100%}.mat-slider-vertical .mat-slider-focus-ring{bottom:-15px;left:-15px}.mat-slider-vertical .mat-slider-ticks{width:2px;height:100%}.mat-slider-vertical .mat-slider-thumb-container{height:100%;width:0;left:50%}.mat-slider-vertical .mat-slider-thumb{-webkit-backface-visibility:hidden;backface-visibility:hidden}.mat-slider-vertical .mat-slider-thumb-label{bottom:-14px;left:-40px;transform:translateX(26px) scale(.01) rotate(-45deg)}.mat-slider-vertical .mat-slider-thumb-label-text{transform:rotate(45deg)}.mat-slider-vertical.cdk-focused .mat-slider-thumb-label{transform:rotate(-45deg)}[dir=rtl] .mat-slider-wrapper::after{left:0;right:auto}[dir=rtl] .mat-slider-horizontal .mat-slider-track-fill{transform-origin:100% 100%}[dir=rtl] .mat-slider-horizontal .mat-slider-track-background{transform-origin:0 0}[dir=rtl] .mat-slider-horizontal.mat-slider-axis-inverted .mat-slider-track-fill{transform-origin:0 0}[dir=rtl] .mat-slider-horizontal.mat-slider-axis-inverted .mat-slider-track-background{transform-origin:100% 100%}"],inputs:["disabled","color","tabIndex"],encapsulation:a.ViewEncapsulation.None,preserveWhitespaces:!1,changeDetection:a.ChangeDetectionStrategy.OnPush}]}],r.ctorParameters=function(){return[{type:a.ElementRef},{type:e.FocusMonitor},{type:a.ChangeDetectorRef},{type:i.Directionality,decorators:[{type:a.Optional}]},{type:void 0,decorators:[{type:a.Attribute,args:["tabindex"]}]}]},r.propDecorators={invert:[{type:a.Input}],max:[{type:a.Input}],min:[{type:a.Input}],step:[{type:a.Input}],thumbLabel:[{type:a.Input}],_thumbLabelDeprecated:[{type:a.Input,args:["thumb-label"]}],tickInterval:[{type:a.Input}],_tickIntervalDeprecated:[{type:a.Input,args:["tick-interval"]}],value:[{type:a.Input}],vertical:[{type:a.Input}],change:[{type:a.Output}],input:[{type:a.Output}],_sliderWrapper:[{type:a.ViewChild,args:["sliderWrapper"]}]},r}(f),g=function(){function t(){}return t.decorators=[{type:a.NgModule,args:[{imports:[r.CommonModule,s.MatCommonModule,i.BidiModule,e.A11yModule],exports:[_,s.MatCommonModule],declarations:[_],providers:[{provide:n.HAMMER_GESTURE_CONFIG,useClass:s.GestureConfig}]}]}],t.ctorParameters=function(){return[]},t}();t.MatSliderModule=g,t.MAT_SLIDER_VALUE_ACCESSOR=m,t.MatSliderChange=p,t.MatSliderBase=b,t._MatSliderMixinBase=f,t.MatSlider=_,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-slider.umd.min.js.map
