import { Subject } from 'rxjs/Subject';
import { ChangeDetectorRef, ElementRef, EventEmitter, QueryList, InjectionToken, AfterViewChecked } from '@angular/core';
import { MatOptgroup } from './optgroup';
/** Event object emitted by MatOption when selected or deselected. */
export declare class MatOptionSelectionChange {
    /** Reference to the option that emitted the event. */
    source: MatOption;
    /** Whether the change in the option's value was a result of a user action. */
    isUserInput: boolean;
    constructor(
        /** Reference to the option that emitted the event. */
        source: MatOption, 
        /** Whether the change in the option's value was a result of a user action. */
        isUserInput?: boolean);
}
/**
 * Describes a parent component that manages a list of options.
 * Contains properties that the options can inherit.
 * @docs-private
 */
export interface MatOptionParentComponent {
    disableRipple?: boolean;
    multiple?: boolean;
}
/**
 * Injection token used to provide the parent component to options.
 */
export declare const MAT_OPTION_PARENT_COMPONENT: InjectionToken<MatOptionParentComponent>;
/**
 * Single option inside of a `<mat-select>` element.
 */
export declare class MatOption implements AfterViewChecked {
    private _element;
    private _changeDetectorRef;
    private _parent;
    readonly group: MatOptgroup;
    private _selected;
    private _active;
    private _disabled;
    private _id;
    private _mostRecentViewValue;
    /** Whether the wrapping component is in multiple selection mode. */
    readonly multiple: boolean | undefined;
    /** The unique ID of the option. */
    readonly id: string;
    /** Whether or not the option is currently selected. */
    readonly selected: boolean;
    /** The form value of the option. */
    value: any;
    /** Whether the option is disabled. */
    disabled: any;
    /** Whether ripples for the option are disabled. */
    readonly disableRipple: boolean | undefined;
    /** Event emitted when the option is selected or deselected. */
    readonly onSelectionChange: EventEmitter<MatOptionSelectionChange>;
    /** Emits when the state of the option changes and any parents have to be notified. */
    readonly _stateChanges: Subject<void>;
    constructor(_element: ElementRef, _changeDetectorRef: ChangeDetectorRef, _parent: MatOptionParentComponent, group: MatOptgroup);
    /**
     * Whether or not the option is currently active and ready to be selected.
     * An active option displays styles as if it is focused, but the
     * focus is actually retained somewhere else. This comes in handy
     * for components like autocomplete where focus must remain on the input.
     */
    readonly active: boolean;
    /**
     * The displayed value of the option. It is necessary to show the selected option in the
     * select's trigger.
     */
    readonly viewValue: string;
    /** Selects the option. */
    select(): void;
    /** Deselects the option. */
    deselect(): void;
    /** Sets focus onto this option. */
    focus(): void;
    /**
     * This method sets display styles on the option to make it appear
     * active. This is used by the ActiveDescendantKeyManager so key
     * events will display the proper options as active on arrow key events.
     */
    setActiveStyles(): void;
    /**
     * This method removes display styles on the option that made it appear
     * active. This is used by the ActiveDescendantKeyManager so key
     * events will display the proper options as active on arrow key events.
     */
    setInactiveStyles(): void;
    /** Gets the label to be used when determining whether the option should be focused. */
    getLabel(): string;
    /** Ensures the option is selected when activated from the keyboard. */
    _handleKeydown(event: KeyboardEvent): void;
    /**
     * `Selects the option while indicating the selection came from the user. Used to
     * determine if the select's view -> model callback should be invoked.`
     */
    _selectViaInteraction(): void;
    /** Returns the correct tabindex for the option depending on disabled state. */
    _getTabIndex(): string;
    /** Gets the host DOM element. */
    _getHostElement(): HTMLElement;
    ngAfterViewChecked(): void;
    /** Emits the selection change event. */
    private _emitSelectionChangeEvent(isUserInput?);
    /**
     * Counts the amount of option group labels that precede the specified option.
     * @param optionIndex Index of the option at which to start counting.
     * @param options Flat list of all of the options.
     * @param optionGroups Flat list of all of the option groups.
     */
    static countGroupLabelsBeforeOption(optionIndex: number, options: QueryList<MatOption>, optionGroups: QueryList<MatOptgroup>): number;
}
