/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/core"),require("@angular/cdk/keycodes"),require("rxjs"),require("rxjs/operators"),require("@angular/animations"),require("@angular/material/core"),require("@angular/cdk/portal"),require("@angular/cdk/layout"),require("@angular/common"),require("@angular/cdk/a11y"),require("@angular/cdk/overlay"),require("@angular/cdk/bidi")):"function"==typeof define&&define.amd?define("@angular/material/bottomSheet",["exports","@angular/core","@angular/cdk/keycodes","rxjs","rxjs/operators","@angular/animations","@angular/material/core","@angular/cdk/portal","@angular/cdk/layout","@angular/common","@angular/cdk/a11y","@angular/cdk/overlay","@angular/cdk/bidi"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.bottomSheet={}),t.ng.core,t.ng.cdk.keycodes,t.Rx,t.Rx.operators,t.ng.animations,t.ng.material.core,t.ng.cdk.portal,t.ng.cdk.layout,t.ng.common,t.ng.cdk.a11y,t.ng.cdk.overlay,t.ng.cdk.bidi)}(this,function(t,e,o,n,a,r,i,s,c,l,p,u,h){"use strict";function d(t,e){function o(){this.constructor=t}f(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}function m(t){return _({},new g,t)}var f=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])},_=Object.assign||function(t){for(var e,o=1,n=arguments.length;o<n;o++){e=arguments[o];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(t[a]=e[a])}return t},y=new e.InjectionToken("MatBottomSheetData"),g=function(){function t(){this.data=null,this.hasBackdrop=!0,this.disableClose=!1,this.ariaLabel=null}return t}(),b=function(){function t(t,e){var r=this;this._overlayRef=e,this._afterDismissed=new n.Subject,this._afterOpened=new n.Subject,this.containerInstance=t,t._animationStateChanged.pipe(a.filter(function(t){return"done"===t.phaseName&&"visible"===t.toState}),a.take(1)).subscribe(function(){r._afterOpened.next(),r._afterOpened.complete()}),t._animationStateChanged.pipe(a.filter(function(t){return"done"===t.phaseName&&"hidden"===t.toState}),a.take(1)).subscribe(function(){r._overlayRef.dispose(),r._afterDismissed.next(r._result),r._afterDismissed.complete()}),t.bottomSheetConfig.disableClose||n.merge(e.backdropClick(),e._keydownEvents.pipe(a.filter(function(t){return t.keyCode===o.ESCAPE}))).subscribe(function(){return r.dismiss()})}return t.prototype.dismiss=function(t){var e=this;this._afterDismissed.closed||(this.containerInstance._animationStateChanged.pipe(a.filter(function(t){return"start"===t.phaseName}),a.take(1)).subscribe(function(){return e._overlayRef.detachBackdrop()}),this._result=t,this.containerInstance.exit())},t.prototype.afterDismissed=function(){return this._afterDismissed.asObservable()},t.prototype.afterOpened=function(){return this._afterOpened.asObservable()},t.prototype.backdropClick=function(){return this._overlayRef.backdropClick()},t.prototype.keydownEvents=function(){return this._overlayRef.keydownEvents()},t}(),v={bottomSheetState:r.trigger("state",[r.state("void, hidden",r.style({transform:"translateY(100%)"})),r.state("visible",r.style({transform:"translateY(0%)"})),r.transition("visible => void, visible => hidden",r.animate(i.AnimationDurations.COMPLEX+" "+i.AnimationCurves.ACCELERATION_CURVE)),r.transition("void => visible",r.animate(i.AnimationDurations.EXITING+" "+i.AnimationCurves.DECELERATION_CURVE))])},S=function(t){function o(o,n,a,r,i,s){var l=t.call(this)||this;return l._elementRef=o,l._changeDetectorRef=n,l._focusTrapFactory=a,l.bottomSheetConfig=s,l._animationState="void",l._animationStateChanged=new e.EventEmitter,l._elementFocusedBeforeOpened=null,l._document=i,l._breakpointSubscription=r.observe([c.Breakpoints.Medium,c.Breakpoints.Large,c.Breakpoints.XLarge]).subscribe(function(){l._toggleClass("mat-bottom-sheet-container-medium",r.isMatched(c.Breakpoints.Medium)),l._toggleClass("mat-bottom-sheet-container-large",r.isMatched(c.Breakpoints.Large)),l._toggleClass("mat-bottom-sheet-container-xlarge",r.isMatched(c.Breakpoints.XLarge))}),l}return d(o,t),o.prototype.attachComponentPortal=function(t){return this._validatePortalAttached(),this._setPanelClass(),this._savePreviouslyFocusedElement(),this._portalOutlet.attachComponentPortal(t)},o.prototype.attachTemplatePortal=function(t){return this._validatePortalAttached(),this._setPanelClass(),this._savePreviouslyFocusedElement(),this._portalOutlet.attachTemplatePortal(t)},o.prototype.enter=function(){this._destroyed||(this._animationState="visible",this._changeDetectorRef.detectChanges())},o.prototype.exit=function(){this._destroyed||(this._animationState="hidden",this._changeDetectorRef.markForCheck())},o.prototype.ngOnDestroy=function(){this._breakpointSubscription.unsubscribe(),this._destroyed=!0},o.prototype._onAnimationDone=function(t){"visible"===t.toState?this._trapFocus():"hidden"===t.toState&&this._restoreFocus(),this._animationStateChanged.emit(t)},o.prototype._onAnimationStart=function(t){this._animationStateChanged.emit(t)},o.prototype._toggleClass=function(t,e){var o=this._elementRef.nativeElement.classList;e?o.add(t):o.remove(t)},o.prototype._validatePortalAttached=function(){if(this._portalOutlet.hasAttached())throw Error("Attempting to attach bottom sheet content after content is already attached")},o.prototype._setPanelClass=function(){var t=this._elementRef.nativeElement,e=this.bottomSheetConfig.panelClass;Array.isArray(e)?e.forEach(function(e){return t.classList.add(e)}):e&&t.classList.add(e)},o.prototype._trapFocus=function(){this._focusTrap||(this._focusTrap=this._focusTrapFactory.create(this._elementRef.nativeElement)),this._focusTrap.focusInitialElementWhenReady()},o.prototype._restoreFocus=function(){var t=this._elementFocusedBeforeOpened;t&&"function"==typeof t.focus&&t.focus(),this._focusTrap&&this._focusTrap.destroy()},o.prototype._savePreviouslyFocusedElement=function(){var t=this;this._elementFocusedBeforeOpened=this._document.activeElement,this._elementRef.nativeElement.focus&&Promise.resolve().then(function(){return t._elementRef.nativeElement.focus()})},o.decorators=[{type:e.Component,args:[{selector:"mat-bottom-sheet-container",template:"<ng-template cdkPortalOutlet></ng-template>",styles:[".mat-bottom-sheet-container{box-shadow:0 8px 10px -5px rgba(0,0,0,.2),0 16px 24px 2px rgba(0,0,0,.14),0 6px 30px 5px rgba(0,0,0,.12);padding:8px 16px;min-width:100vw;box-sizing:border-box;display:block;outline:0;max-height:80vh;overflow:auto}@media screen and (-ms-high-contrast:active){.mat-bottom-sheet-container{outline:1px solid}}.mat-bottom-sheet-container-medium{min-width:384px;max-width:calc(100vw - 128px)}.mat-bottom-sheet-container-large{min-width:512px;max-width:calc(100vw - 256px)}.mat-bottom-sheet-container-xlarge{min-width:576px;max-width:calc(100vw - 384px)}"],changeDetection:e.ChangeDetectionStrategy.OnPush,encapsulation:e.ViewEncapsulation.None,animations:[v.bottomSheetState],host:{class:"mat-bottom-sheet-container",tabindex:"-1",role:"dialog","[attr.aria-label]":"bottomSheetConfig?.ariaLabel","[@state]":"_animationState","(@state.start)":"_onAnimationStart($event)","(@state.done)":"_onAnimationDone($event)"}}]}],o.ctorParameters=function(){return[{type:e.ElementRef},{type:e.ChangeDetectorRef},{type:p.FocusTrapFactory},{type:c.BreakpointObserver},{type:void 0,decorators:[{type:e.Optional},{type:e.Inject,args:[l.DOCUMENT]}]},{type:g}]},o.propDecorators={_portalOutlet:[{type:e.ViewChild,args:[s.CdkPortalOutlet]}]},o}(s.BasePortalOutlet),C=function(){function t(t,e,o){this._overlay=t,this._injector=e,this._parentBottomSheet=o,this._bottomSheetRefAtThisLevel=null}return Object.defineProperty(t.prototype,"_openedBottomSheetRef",{get:function(){var t=this._parentBottomSheet;return t?t._openedBottomSheetRef:this._bottomSheetRefAtThisLevel},set:function(t){this._parentBottomSheet?this._parentBottomSheet._openedBottomSheetRef=t:this._bottomSheetRefAtThisLevel=t},enumerable:!0,configurable:!0}),t.prototype.open=function(t,o){var n=this,a=m(o),r=this._createOverlay(a),i=this._attachContainer(r,a),c=new b(i,r);if(t instanceof e.TemplateRef)i.attachTemplatePortal(new s.TemplatePortal(t,null,{$implicit:a.data,bottomSheetRef:c}));else{var l=new s.ComponentPortal(t,void 0,this._createInjector(a,c)),p=i.attachComponentPortal(l);c.instance=p.instance}return c.afterDismissed().subscribe(function(){n._openedBottomSheetRef==c&&(n._openedBottomSheetRef=null)}),this._openedBottomSheetRef?(this._openedBottomSheetRef.afterDismissed().subscribe(function(){return c.containerInstance.enter()}),this._openedBottomSheetRef.dismiss()):c.containerInstance.enter(),this._openedBottomSheetRef=c,c},t.prototype.dismiss=function(){this._openedBottomSheetRef&&this._openedBottomSheetRef.dismiss()},t.prototype._attachContainer=function(t,e){var o=e&&e.viewContainerRef&&e.viewContainerRef.injector,n=new s.PortalInjector(o||this._injector,new WeakMap([[g,e]])),a=new s.ComponentPortal(S,e.viewContainerRef,n);return t.attach(a).instance},t.prototype._createOverlay=function(t){var e=new u.OverlayConfig({direction:t.direction,hasBackdrop:t.hasBackdrop,maxWidth:"100%",scrollStrategy:this._overlay.scrollStrategies.block(),positionStrategy:this._overlay.position().global().centerHorizontally().bottom("0")});return t.backdropClass&&(e.backdropClass=t.backdropClass),this._overlay.create(e)},t.prototype._createInjector=function(t,e){var o=t&&t.viewContainerRef&&t.viewContainerRef.injector,a=new WeakMap([[b,e],[y,t.data]]);return!t.direction||o&&o.get(h.Directionality,null)||a.set(h.Directionality,{value:t.direction,change:n.of()}),new s.PortalInjector(o||this._injector,a)},t.decorators=[{type:e.Injectable}],t.ctorParameters=function(){return[{type:u.Overlay},{type:e.Injector},{type:t,decorators:[{type:e.Optional},{type:e.SkipSelf}]}]},t}(),k=function(){function t(){}return t.decorators=[{type:e.NgModule,args:[{imports:[l.CommonModule,u.OverlayModule,i.MatCommonModule,s.PortalModule],exports:[S,i.MatCommonModule],declarations:[S],entryComponents:[S],providers:[C]}]}],t}();t.MatBottomSheetModule=k,t.MatBottomSheet=C,t.MAT_BOTTOM_SHEET_DATA=y,t.MatBottomSheetConfig=g,t.MatBottomSheetContainer=S,t.matBottomSheetAnimations=v,t.MatBottomSheetRef=b,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-bottom-sheet.umd.min.js.map
