/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("rxjs"),require("rxjs/operators"),require("@angular/cdk/keycodes"),require("@angular/material/core"),require("@angular/cdk/bidi"),require("@angular/cdk/portal"),require("@angular/animations"),require("@angular/cdk/coercion"),require("@angular/cdk/overlay"),require("@angular/common"),require("@angular/material/dialog"),require("@angular/forms"),require("@angular/material/form-field"),require("@angular/material/input"),require("@angular/cdk/a11y"),require("@angular/material/button")):"function"==typeof define&&define.amd?define("@angular/material/datepicker",["exports","@angular/core","rxjs","rxjs/operators","@angular/cdk/keycodes","@angular/material/core","@angular/cdk/bidi","@angular/cdk/portal","@angular/animations","@angular/cdk/coercion","@angular/cdk/overlay","@angular/common","@angular/material/dialog","@angular/forms","@angular/material/form-field","@angular/material/input","@angular/cdk/a11y","@angular/material/button"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.datepicker={}),e.ng.core,e.Rx,e.Rx.operators,e.ng.cdk.keycodes,e.ng.material.core,e.ng.cdk.bidi,e.ng.cdk.portal,e.ng.animations,e.ng.cdk.coercion,e.ng.cdk.overlay,e.ng.common,e.ng.material.dialog,e.ng.forms,e.ng.material.formField,e.ng.material.input,e.ng.cdk.a11y,e.ng.material.button)}(this,function(e,t,a,i,r,n,o,s,d,l,c,p,h,u,_,m,f,g){"use strict";function y(e,t){function a(){this.constructor=e}v(e,t),e.prototype=null===t?Object.create(t):(a.prototype=t.prototype,new a)}function D(e){return Error("MatDatepicker: No provider found for "+e+". You must import one of the following modules at your application root: MatNativeDateModule, MatMomentDateModule, or provide a custom implementation.")}function b(e){return function(){return e.scrollStrategies.reposition()}}var v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var a in t)t.hasOwnProperty(a)&&(e[a]=t[a])},A=function(){function e(){this.changes=new a.Subject,this.calendarLabel="Calendar",this.openCalendarLabel="Open calendar",this.prevMonthLabel="Previous month",this.nextMonthLabel="Next month",this.prevYearLabel="Previous year",this.nextYearLabel="Next year",this.prevMultiYearLabel="Previous 20 years",this.nextMultiYearLabel="Next 20 years",this.switchToMonthViewLabel="Choose date",this.switchToMultiYearViewLabel="Choose month and year"}return e.decorators=[{type:t.Injectable,args:[{providedIn:"root"}]}],e.ngInjectableDef=t.defineInjectable({factory:function(){return new e},token:e,providedIn:"root"}),e}(),C=function(){function e(e,t,a,i){this.value=e,this.displayValue=t,this.ariaLabel=a,this.enabled=i}return e}(),w=function(){function e(e,a){this._elementRef=e,this._ngZone=a,this.numCols=7,this.allowDisabledSelection=!1,this.activeCell=0,this.cellAspectRatio=1,this.selectedValueChange=new t.EventEmitter}return e.prototype._cellClicked=function(e){(this.allowDisabledSelection||e.enabled)&&this.selectedValueChange.emit(e.value)},Object.defineProperty(e.prototype,"_firstRowOffset",{get:function(){return this.rows&&this.rows.length&&this.rows[0].length?this.numCols-this.rows[0].length:0},enumerable:!0,configurable:!0}),e.prototype._isActiveCell=function(e,t){var a=e*this.numCols+t;return e&&(a-=this._firstRowOffset),a==this.activeCell},e.prototype._focusActiveCell=function(){var e=this;this._ngZone.runOutsideAngular(function(){e._ngZone.onStable.asObservable().pipe(i.take(1)).subscribe(function(){e._elementRef.nativeElement.querySelector(".mat-calendar-body-active").focus()})})},e.decorators=[{type:t.Component,args:[{selector:"[mat-calendar-body]",template:'<tr *ngIf="_firstRowOffset < labelMinRequiredCells" aria-hidden="true"><td class="mat-calendar-body-label" [attr.colspan]="numCols" [style.paddingTop.%]="50 * cellAspectRatio / numCols" [style.paddingBottom.%]="50 * cellAspectRatio / numCols">{{label}}</td></tr><tr *ngFor="let row of rows; let rowIndex = index" role="row"><td *ngIf="rowIndex === 0 && _firstRowOffset" aria-hidden="true" class="mat-calendar-body-label" [attr.colspan]="_firstRowOffset" [style.paddingTop.%]="50 * cellAspectRatio / numCols" [style.paddingBottom.%]="50 * cellAspectRatio / numCols">{{_firstRowOffset >= labelMinRequiredCells ? label : \'\'}}</td><td *ngFor="let item of row; let colIndex = index" role="gridcell" class="mat-calendar-body-cell" [tabindex]="_isActiveCell(rowIndex, colIndex) ? 0 : -1" [class.mat-calendar-body-disabled]="!item.enabled" [class.mat-calendar-body-active]="_isActiveCell(rowIndex, colIndex)" [attr.aria-label]="item.ariaLabel" [attr.aria-disabled]="!item.enabled || null" (click)="_cellClicked(item)" [style.width.%]="100 / numCols" [style.paddingTop.%]="50 * cellAspectRatio / numCols" [style.paddingBottom.%]="50 * cellAspectRatio / numCols"><div class="mat-calendar-body-cell-content" [class.mat-calendar-body-selected]="selectedValue === item.value" [class.mat-calendar-body-today]="todayValue === item.value">{{item.displayValue}}</div></td></tr>',styles:[".mat-calendar-body{min-width:224px}.mat-calendar-body-label{height:0;line-height:0;text-align:left;padding-left:4.71429%;padding-right:4.71429%}.mat-calendar-body-cell{position:relative;height:0;line-height:0;text-align:center;outline:0;cursor:pointer}.mat-calendar-body-disabled{cursor:default}.mat-calendar-body-cell-content{position:absolute;top:5%;left:5%;display:flex;align-items:center;justify-content:center;box-sizing:border-box;width:90%;height:90%;line-height:1;border-width:1px;border-style:solid;border-radius:999px}@media screen and (-ms-high-contrast:active){.mat-calendar-body-cell-content{border:none}}@media screen and (-ms-high-contrast:active){.mat-calendar-body-selected,.mat-datepicker-popup{outline:solid 1px}.mat-calendar-body-today{outline:dotted 1px}}[dir=rtl] .mat-calendar-body-label{text-align:right}"],host:{class:"mat-calendar-body",role:"grid","attr.aria-readonly":"true"},exportAs:"matCalendarBody",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:t.ElementRef},{type:t.NgZone}]},e.propDecorators={label:[{type:t.Input}],rows:[{type:t.Input}],todayValue:[{type:t.Input}],selectedValue:[{type:t.Input}],labelMinRequiredCells:[{type:t.Input}],numCols:[{type:t.Input}],allowDisabledSelection:[{type:t.Input}],activeCell:[{type:t.Input}],cellAspectRatio:[{type:t.Input}],selectedValueChange:[{type:t.Output}]},e}(),k=function(){function e(e,a,i,r){if(this._changeDetectorRef=e,this._dateFormats=a,this._dateAdapter=i,this._dir=r,this.selectedChange=new t.EventEmitter,this._userSelection=new t.EventEmitter,this.activeDateChange=new t.EventEmitter,!this._dateAdapter)throw D("DateAdapter");if(!this._dateFormats)throw D("MAT_DATE_FORMATS");var n=this._dateAdapter.getFirstDayOfWeek(),o=this._dateAdapter.getDayOfWeekNames("narrow"),s=this._dateAdapter.getDayOfWeekNames("long"),d=s.map(function(e,t){return{long:e,narrow:o[t]}});this._weekdays=d.slice(n).concat(d.slice(0,n)),this._activeDate=this._dateAdapter.today()}return Object.defineProperty(e.prototype,"activeDate",{get:function(){return this._activeDate},set:function(e){var t=this._activeDate,a=this._getValidDateOrNull(this._dateAdapter.deserialize(e))||this._dateAdapter.today();this._activeDate=this._dateAdapter.clampDate(a,this.minDate,this.maxDate),this._hasSameMonthAndYear(t,this._activeDate)||this._init()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){return this._selected},set:function(e){this._selected=this._getValidDateOrNull(this._dateAdapter.deserialize(e)),this._selectedDate=this._getDateInCurrentMonth(this._selected)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"minDate",{get:function(){return this._minDate},set:function(e){this._minDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxDate",{get:function(){return this._maxDate},set:function(e){this._maxDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){this._init()},e.prototype._dateSelected=function(e){if(this._selectedDate!=e){var t=this._dateAdapter.getYear(this.activeDate),a=this._dateAdapter.getMonth(this.activeDate),i=this._dateAdapter.createDate(t,a,e);this.selectedChange.emit(i)}this._userSelection.emit()},e.prototype._handleCalendarBodyKeydown=function(e){var t=this._activeDate,a=this._isRtl();switch(e.keyCode){case r.LEFT_ARROW:this.activeDate=this._dateAdapter.addCalendarDays(this._activeDate,a?1:-1);break;case r.RIGHT_ARROW:this.activeDate=this._dateAdapter.addCalendarDays(this._activeDate,a?-1:1);break;case r.UP_ARROW:this.activeDate=this._dateAdapter.addCalendarDays(this._activeDate,-7);break;case r.DOWN_ARROW:this.activeDate=this._dateAdapter.addCalendarDays(this._activeDate,7);break;case r.HOME:this.activeDate=this._dateAdapter.addCalendarDays(this._activeDate,1-this._dateAdapter.getDate(this._activeDate));break;case r.END:this.activeDate=this._dateAdapter.addCalendarDays(this._activeDate,this._dateAdapter.getNumDaysInMonth(this._activeDate)-this._dateAdapter.getDate(this._activeDate));break;case r.PAGE_UP:this.activeDate=e.altKey?this._dateAdapter.addCalendarYears(this._activeDate,-1):this._dateAdapter.addCalendarMonths(this._activeDate,-1);break;case r.PAGE_DOWN:this.activeDate=e.altKey?this._dateAdapter.addCalendarYears(this._activeDate,1):this._dateAdapter.addCalendarMonths(this._activeDate,1);break;case r.ENTER:return void(this.dateFilter&&!this.dateFilter(this._activeDate)||(this._dateSelected(this._dateAdapter.getDate(this._activeDate)),this._userSelection.emit(),e.preventDefault()));default:return}this._dateAdapter.compareDate(t,this.activeDate)&&this.activeDateChange.emit(this.activeDate),this._focusActiveCell(),e.preventDefault()},e.prototype._init=function(){this._selectedDate=this._getDateInCurrentMonth(this.selected),this._todayDate=this._getDateInCurrentMonth(this._dateAdapter.today()),this._monthLabel=this._dateAdapter.getMonthNames("short")[this._dateAdapter.getMonth(this.activeDate)].toLocaleUpperCase();var e=this._dateAdapter.createDate(this._dateAdapter.getYear(this.activeDate),this._dateAdapter.getMonth(this.activeDate),1);this._firstWeekOffset=(7+this._dateAdapter.getDayOfWeek(e)-this._dateAdapter.getFirstDayOfWeek())%7,this._createWeekCells(),this._changeDetectorRef.markForCheck()},e.prototype._focusActiveCell=function(){this._matCalendarBody._focusActiveCell()},e.prototype._createWeekCells=function(){var e=this._dateAdapter.getNumDaysInMonth(this.activeDate),t=this._dateAdapter.getDateNames();this._weeks=[[]];for(var a=0,i=this._firstWeekOffset;a<e;a++,i++){7==i&&(this._weeks.push([]),i=0);var r=this._dateAdapter.createDate(this._dateAdapter.getYear(this.activeDate),this._dateAdapter.getMonth(this.activeDate),a+1),n=this._shouldEnableDate(r),o=this._dateAdapter.format(r,this._dateFormats.display.dateA11yLabel);this._weeks[this._weeks.length-1].push(new C(a+1,t[a],o,n))}},e.prototype._shouldEnableDate=function(e){return!!e&&(!this.dateFilter||this.dateFilter(e))&&(!this.minDate||this._dateAdapter.compareDate(e,this.minDate)>=0)&&(!this.maxDate||this._dateAdapter.compareDate(e,this.maxDate)<=0)},e.prototype._getDateInCurrentMonth=function(e){return e&&this._hasSameMonthAndYear(e,this.activeDate)?this._dateAdapter.getDate(e):null},e.prototype._hasSameMonthAndYear=function(e,t){return!(!e||!t||this._dateAdapter.getMonth(e)!=this._dateAdapter.getMonth(t)||this._dateAdapter.getYear(e)!=this._dateAdapter.getYear(t))},e.prototype._getValidDateOrNull=function(e){return this._dateAdapter.isDateInstance(e)&&this._dateAdapter.isValid(e)?e:null},e.prototype._isRtl=function(){return this._dir&&"rtl"===this._dir.value},e.decorators=[{type:t.Component,args:[{selector:"mat-month-view",template:'<table class="mat-calendar-table"><thead class="mat-calendar-table-header"><tr><th *ngFor="let day of _weekdays" [attr.aria-label]="day.long">{{day.narrow}}</th></tr><tr><th class="mat-calendar-table-header-divider" colspan="7" aria-hidden="true"></th></tr></thead><tbody mat-calendar-body [label]="_monthLabel" [rows]="_weeks" [todayValue]="_todayDate" [selectedValue]="_selectedDate" [labelMinRequiredCells]="3" [activeCell]="_dateAdapter.getDate(activeDate) - 1" (selectedValueChange)="_dateSelected($event)" (keydown)="_handleCalendarBodyKeydown($event)"></tbody></table>',exportAs:"matMonthView",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:t.ChangeDetectorRef},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[n.MAT_DATE_FORMATS]}]},{type:n.DateAdapter,decorators:[{type:t.Optional}]},{type:o.Directionality,decorators:[{type:t.Optional}]}]},e.propDecorators={activeDate:[{type:t.Input}],selected:[{type:t.Input}],minDate:[{type:t.Input}],maxDate:[{type:t.Input}],dateFilter:[{type:t.Input}],selectedChange:[{type:t.Output}],_userSelection:[{type:t.Output}],activeDateChange:[{type:t.Output}],_matCalendarBody:[{type:t.ViewChild,args:[w]}]},e}(),O=function(){function e(e,a,i){if(this._changeDetectorRef=e,this._dateAdapter=a,this._dir=i,this.selectedChange=new t.EventEmitter,this.yearSelected=new t.EventEmitter,!this._dateAdapter)throw D("DateAdapter");this._activeDate=this._dateAdapter.today()}return Object.defineProperty(e.prototype,"activeDate",{get:function(){return this._activeDate},set:function(e){var t=this._activeDate,a=this._getValidDateOrNull(this._dateAdapter.deserialize(e))||this._dateAdapter.today();this._activeDate=this._dateAdapter.clampDate(a,this.minDate,this.maxDate),Math.floor(this._dateAdapter.getYear(t)/24)!=Math.floor(this._dateAdapter.getYear(this._activeDate)/24)&&this._init()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){return this._selected},set:function(e){this._selected=this._getValidDateOrNull(this._dateAdapter.deserialize(e)),this._selectedYear=this._selected&&this._dateAdapter.getYear(this._selected)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"minDate",{get:function(){return this._minDate},set:function(e){this._minDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxDate",{get:function(){return this._maxDate},set:function(e){this._maxDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){this._init()},e.prototype._init=function(){var e=this;this._todayYear=this._dateAdapter.getYear(this._dateAdapter.today());var t=this._dateAdapter.getYear(this._activeDate),a=t%24;this._years=[];for(var i=0,r=[];i<24;i++)r.push(t-a+i),4==r.length&&(this._years.push(r.map(function(t){return e._createCellForYear(t)})),r=[]);this._changeDetectorRef.markForCheck()},e.prototype._yearSelected=function(e){this.yearSelected.emit(this._dateAdapter.createDate(e,0,1));var t=this._dateAdapter.getMonth(this.activeDate),a=this._dateAdapter.getNumDaysInMonth(this._dateAdapter.createDate(e,t,1));this.selectedChange.emit(this._dateAdapter.createDate(e,t,Math.min(this._dateAdapter.getDate(this.activeDate),a)))},e.prototype._handleCalendarBodyKeydown=function(e){var t=this._isRtl();switch(e.keyCode){case r.LEFT_ARROW:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,t?1:-1);break;case r.RIGHT_ARROW:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,t?-1:1);break;case r.UP_ARROW:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,-4);break;case r.DOWN_ARROW:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,4);break;case r.HOME:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,-this._dateAdapter.getYear(this._activeDate)%24);break;case r.END:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,24-this._dateAdapter.getYear(this._activeDate)%24-1);break;case r.PAGE_UP:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,e.altKey?-240:-24);break;case r.PAGE_DOWN:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,e.altKey?240:24);break;case r.ENTER:this._yearSelected(this._dateAdapter.getYear(this._activeDate));break;default:return}this._focusActiveCell(),e.preventDefault()},e.prototype._getActiveCell=function(){return this._dateAdapter.getYear(this.activeDate)%24},e.prototype._focusActiveCell=function(){this._matCalendarBody._focusActiveCell()},e.prototype._createCellForYear=function(e){var t=this._dateAdapter.getYearName(this._dateAdapter.createDate(e,0,1));return new C(e,t,t,this._shouldEnableYear(e))},e.prototype._shouldEnableYear=function(e){if(void 0===e||null===e||this.maxDate&&e>this._dateAdapter.getYear(this.maxDate)||this.minDate&&e<this._dateAdapter.getYear(this.minDate))return!1;if(!this.dateFilter)return!0;for(var t=this._dateAdapter.createDate(e,0,1),a=t;this._dateAdapter.getYear(a)==e;a=this._dateAdapter.addCalendarDays(a,1))if(this.dateFilter(a))return!0;return!1},e.prototype._getValidDateOrNull=function(e){return this._dateAdapter.isDateInstance(e)&&this._dateAdapter.isValid(e)?e:null},e.prototype._isRtl=function(){return this._dir&&"rtl"===this._dir.value},e.decorators=[{type:t.Component,args:[{selector:"mat-multi-year-view",template:'<table class="mat-calendar-table"><thead class="mat-calendar-table-header"><tr><th class="mat-calendar-table-header-divider" colspan="4"></th></tr></thead><tbody mat-calendar-body allowDisabledSelection="true" [rows]="_years" [todayValue]="_todayYear" [selectedValue]="_selectedYear" [numCols]="4" [cellAspectRatio]="4 / 7" [activeCell]="_getActiveCell()" (selectedValueChange)="_yearSelected($event)" (keydown)="_handleCalendarBodyKeydown($event)"></tbody></table>',exportAs:"matMultiYearView",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:t.ChangeDetectorRef},{type:n.DateAdapter,decorators:[{type:t.Optional}]},{type:o.Directionality,decorators:[{type:t.Optional}]}]},e.propDecorators={activeDate:[{type:t.Input}],selected:[{type:t.Input}],minDate:[{type:t.Input}],maxDate:[{type:t.Input}],dateFilter:[{type:t.Input}],selectedChange:[{type:t.Output}],yearSelected:[{type:t.Output}],_matCalendarBody:[{type:t.ViewChild,args:[w]}]},e}(),x=function(){function e(e,a,i,r){if(this._changeDetectorRef=e,this._dateFormats=a,this._dateAdapter=i,this._dir=r,this.selectedChange=new t.EventEmitter,this.monthSelected=new t.EventEmitter,!this._dateAdapter)throw D("DateAdapter");if(!this._dateFormats)throw D("MAT_DATE_FORMATS");this._activeDate=this._dateAdapter.today()}return Object.defineProperty(e.prototype,"activeDate",{get:function(){return this._activeDate},set:function(e){var t=this._activeDate,a=this._getValidDateOrNull(this._dateAdapter.deserialize(e))||this._dateAdapter.today();this._activeDate=this._dateAdapter.clampDate(a,this.minDate,this.maxDate),this._dateAdapter.getYear(t)!==this._dateAdapter.getYear(this._activeDate)&&this._init()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){return this._selected},set:function(e){this._selected=this._getValidDateOrNull(this._dateAdapter.deserialize(e)),this._selectedMonth=this._getMonthInCurrentYear(this._selected)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"minDate",{get:function(){return this._minDate},set:function(e){this._minDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxDate",{get:function(){return this._maxDate},set:function(e){this._maxDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){this._init()},e.prototype._monthSelected=function(e){var t=this._dateAdapter.createDate(this._dateAdapter.getYear(this.activeDate),e,1);this.monthSelected.emit(t);var a=this._dateAdapter.getNumDaysInMonth(t);this.selectedChange.emit(this._dateAdapter.createDate(this._dateAdapter.getYear(this.activeDate),e,Math.min(this._dateAdapter.getDate(this.activeDate),a)))},e.prototype._handleCalendarBodyKeydown=function(e){var t=this._isRtl();switch(e.keyCode){case r.LEFT_ARROW:this.activeDate=this._dateAdapter.addCalendarMonths(this._activeDate,t?1:-1);break;case r.RIGHT_ARROW:this.activeDate=this._dateAdapter.addCalendarMonths(this._activeDate,t?-1:1);break;case r.UP_ARROW:this.activeDate=this._dateAdapter.addCalendarMonths(this._activeDate,-4);break;case r.DOWN_ARROW:this.activeDate=this._dateAdapter.addCalendarMonths(this._activeDate,4);break;case r.HOME:this.activeDate=this._dateAdapter.addCalendarMonths(this._activeDate,-this._dateAdapter.getMonth(this._activeDate));break;case r.END:this.activeDate=this._dateAdapter.addCalendarMonths(this._activeDate,11-this._dateAdapter.getMonth(this._activeDate));break;case r.PAGE_UP:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,e.altKey?-10:-1);break;case r.PAGE_DOWN:this.activeDate=this._dateAdapter.addCalendarYears(this._activeDate,e.altKey?10:1);break;case r.ENTER:this._monthSelected(this._dateAdapter.getMonth(this._activeDate));break;default:return}this._focusActiveCell(),e.preventDefault()},e.prototype._init=function(){var e=this;this._selectedMonth=this._getMonthInCurrentYear(this.selected),this._todayMonth=this._getMonthInCurrentYear(this._dateAdapter.today()),this._yearLabel=this._dateAdapter.getYearName(this.activeDate);var t=this._dateAdapter.getMonthNames("short");this._months=[[0,1,2,3],[4,5,6,7],[8,9,10,11]].map(function(a){return a.map(function(a){return e._createCellForMonth(a,t[a])})}),this._changeDetectorRef.markForCheck()},e.prototype._focusActiveCell=function(){this._matCalendarBody._focusActiveCell()},e.prototype._getMonthInCurrentYear=function(e){return e&&this._dateAdapter.getYear(e)==this._dateAdapter.getYear(this.activeDate)?this._dateAdapter.getMonth(e):null},e.prototype._createCellForMonth=function(e,t){var a=this._dateAdapter.format(this._dateAdapter.createDate(this._dateAdapter.getYear(this.activeDate),e,1),this._dateFormats.display.monthYearA11yLabel);return new C(e,t.toLocaleUpperCase(),a,this._shouldEnableMonth(e))},e.prototype._shouldEnableMonth=function(e){var t=this._dateAdapter.getYear(this.activeDate);if(void 0===e||null===e||this._isYearAndMonthAfterMaxDate(t,e)||this._isYearAndMonthBeforeMinDate(t,e))return!1;if(!this.dateFilter)return!0;for(var a=this._dateAdapter.createDate(t,e,1),i=a;this._dateAdapter.getMonth(i)==e;i=this._dateAdapter.addCalendarDays(i,1))if(this.dateFilter(i))return!0;return!1},e.prototype._isYearAndMonthAfterMaxDate=function(e,t){if(this.maxDate){var a=this._dateAdapter.getYear(this.maxDate),i=this._dateAdapter.getMonth(this.maxDate);return e>a||e===a&&t>i}return!1},e.prototype._isYearAndMonthBeforeMinDate=function(e,t){if(this.minDate){var a=this._dateAdapter.getYear(this.minDate),i=this._dateAdapter.getMonth(this.minDate);return e<a||e===a&&t<i}return!1},e.prototype._getValidDateOrNull=function(e){return this._dateAdapter.isDateInstance(e)&&this._dateAdapter.isValid(e)?e:null},e.prototype._isRtl=function(){return this._dir&&"rtl"===this._dir.value},e.decorators=[{type:t.Component,args:[{selector:"mat-year-view",template:'<table class="mat-calendar-table"><thead class="mat-calendar-table-header"><tr><th class="mat-calendar-table-header-divider" colspan="4"></th></tr></thead><tbody mat-calendar-body allowDisabledSelection="true" [label]="_yearLabel" [rows]="_months" [todayValue]="_todayMonth" [selectedValue]="_selectedMonth" [labelMinRequiredCells]="2" [numCols]="4" [cellAspectRatio]="4 / 7" [activeCell]="_dateAdapter.getMonth(activeDate)" (selectedValueChange)="_monthSelected($event)" (keydown)="_handleCalendarBodyKeydown($event)"></tbody></table>',exportAs:"matYearView",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:t.ChangeDetectorRef},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[n.MAT_DATE_FORMATS]}]},{type:n.DateAdapter,decorators:[{type:t.Optional}]},{type:o.Directionality,decorators:[{type:t.Optional}]}]},e.propDecorators={activeDate:[{type:t.Input}],selected:[{type:t.Input}],minDate:[{type:t.Input}],maxDate:[{type:t.Input}],dateFilter:[{type:t.Input}],selectedChange:[{type:t.Output}],monthSelected:[{type:t.Output}],_matCalendarBody:[{type:t.ViewChild,args:[w]}]},e}(),M=function(){function e(e,t,a,i,r){this._intl=e,this.calendar=t,this._dateAdapter=a,this._dateFormats=i,this.calendar.stateChanges.subscribe(function(){return r.markForCheck()})}return Object.defineProperty(e.prototype,"periodButtonText",{get:function(){if("month"==this.calendar.currentView)return this._dateAdapter.format(this.calendar.activeDate,this._dateFormats.display.monthYearLabel).toLocaleUpperCase();if("year"==this.calendar.currentView)return this._dateAdapter.getYearName(this.calendar.activeDate);var e=this._dateAdapter.getYear(this.calendar.activeDate);return this._dateAdapter.getYearName(this._dateAdapter.createDate(e-e%24,0,1))+" – "+this._dateAdapter.getYearName(this._dateAdapter.createDate(e+24-1-e%24,0,1))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"periodButtonLabel",{get:function(){return"month"==this.calendar.currentView?this._intl.switchToMultiYearViewLabel:this._intl.switchToMonthViewLabel},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"prevButtonLabel",{get:function(){return{month:this._intl.prevMonthLabel,year:this._intl.prevYearLabel,"multi-year":this._intl.prevMultiYearLabel}[this.calendar.currentView]},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"nextButtonLabel",{get:function(){return{month:this._intl.nextMonthLabel,year:this._intl.nextYearLabel,"multi-year":this._intl.nextMultiYearLabel}[this.calendar.currentView]},enumerable:!0,configurable:!0}),e.prototype.currentPeriodClicked=function(){this.calendar.currentView="month"==this.calendar.currentView?"multi-year":"month"},e.prototype.previousClicked=function(){this.calendar.activeDate="month"==this.calendar.currentView?this._dateAdapter.addCalendarMonths(this.calendar.activeDate,-1):this._dateAdapter.addCalendarYears(this.calendar.activeDate,"year"==this.calendar.currentView?-1:-24)},e.prototype.nextClicked=function(){this.calendar.activeDate="month"==this.calendar.currentView?this._dateAdapter.addCalendarMonths(this.calendar.activeDate,1):this._dateAdapter.addCalendarYears(this.calendar.activeDate,"year"==this.calendar.currentView?1:24)},e.prototype.previousEnabled=function(){return!this.calendar.minDate||(!this.calendar.minDate||!this._isSameView(this.calendar.activeDate,this.calendar.minDate))},e.prototype.nextEnabled=function(){return!this.calendar.maxDate||!this._isSameView(this.calendar.activeDate,this.calendar.maxDate)},e.prototype._isSameView=function(e,t){return"month"==this.calendar.currentView?this._dateAdapter.getYear(e)==this._dateAdapter.getYear(t)&&this._dateAdapter.getMonth(e)==this._dateAdapter.getMonth(t):"year"==this.calendar.currentView?this._dateAdapter.getYear(e)==this._dateAdapter.getYear(t):Math.floor(this._dateAdapter.getYear(e)/24)==Math.floor(this._dateAdapter.getYear(t)/24)},e.decorators=[{type:t.Component,args:[{selector:"mat-calendar-header",template:'<div class="mat-calendar-header"><div class="mat-calendar-controls"><button mat-button type="button" class="mat-calendar-period-button" (click)="currentPeriodClicked()" [attr.aria-label]="periodButtonLabel">{{periodButtonText}}<div class="mat-calendar-arrow" [class.mat-calendar-invert]="calendar.currentView != \'month\'"></div></button><div class="mat-calendar-spacer"></div><button mat-icon-button type="button" class="mat-calendar-previous-button" [disabled]="!previousEnabled()" (click)="previousClicked()" [attr.aria-label]="prevButtonLabel"></button> <button mat-icon-button type="button" class="mat-calendar-next-button" [disabled]="!nextEnabled()" (click)="nextClicked()" [attr.aria-label]="nextButtonLabel"></button></div></div>',exportAs:"matCalendarHeader",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:A},{type:I,decorators:[{type:t.Inject,args:[t.forwardRef(function(){return I})]}]},{type:n.DateAdapter,decorators:[{type:t.Optional}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[n.MAT_DATE_FORMATS]}]},{type:t.ChangeDetectorRef}]},e}(),I=function(){function e(e,i,r,n){var o=this;if(this._dateAdapter=i,this._dateFormats=r,this._moveFocusOnNextTick=!1,this.startView="month",this.selectedChange=new t.EventEmitter,this.yearSelected=new t.EventEmitter,this.monthSelected=new t.EventEmitter,this._userSelection=new t.EventEmitter,this.stateChanges=new a.Subject,!this._dateAdapter)throw D("DateAdapter");if(!this._dateFormats)throw D("MAT_DATE_FORMATS");this._intlChanges=e.changes.subscribe(function(){n.markForCheck(),o.stateChanges.next()})}return Object.defineProperty(e.prototype,"startAt",{get:function(){return this._startAt},set:function(e){this._startAt=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){return this._selected},set:function(e){this._selected=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"minDate",{get:function(){return this._minDate},set:function(e){this._minDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"maxDate",{get:function(){return this._maxDate},set:function(e){this._maxDate=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"activeDate",{get:function(){return this._clampedActiveDate},set:function(e){this._clampedActiveDate=this._dateAdapter.clampDate(e,this.minDate,this.maxDate),this.stateChanges.next()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"currentView",{get:function(){return this._currentView},set:function(e){this._currentView=e,this._moveFocusOnNextTick=!0},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){this._calendarHeaderPortal=new s.ComponentPortal(this.headerComponent||M),this.activeDate=this.startAt||this._dateAdapter.today(),this._currentView=this.startView},e.prototype.ngAfterViewChecked=function(){this._moveFocusOnNextTick&&(this._moveFocusOnNextTick=!1,this.focusActiveCell())},e.prototype.ngOnDestroy=function(){this._intlChanges.unsubscribe(),this.stateChanges.complete()},e.prototype.ngOnChanges=function(e){var t=e.minDate||e.maxDate||e.dateFilter;if(t&&!t.firstChange){var a=this._getCurrentViewComponent();a&&a._init()}this.stateChanges.next()},e.prototype.focusActiveCell=function(){this._getCurrentViewComponent()._focusActiveCell()},e.prototype._dateSelected=function(e){this._dateAdapter.sameDate(e,this.selected)||this.selectedChange.emit(e)},e.prototype._yearSelectedInMultiYearView=function(e){this.yearSelected.emit(e)},e.prototype._monthSelectedInYearView=function(e){this.monthSelected.emit(e)},e.prototype._userSelected=function(){this._userSelection.emit()},e.prototype._goToDateInView=function(e,t){this.activeDate=e,this.currentView=t},e.prototype._getValidDateOrNull=function(e){return this._dateAdapter.isDateInstance(e)&&this._dateAdapter.isValid(e)?e:null},e.prototype._getCurrentViewComponent=function(){return this.monthView||this.yearView||this.multiYearView},e.decorators=[{type:t.Component,args:[{selector:"mat-calendar",
template:'<ng-template [cdkPortalOutlet]="_calendarHeaderPortal"></ng-template><div class="mat-calendar-content" [ngSwitch]="currentView" cdkMonitorSubtreeFocus tabindex="-1"><mat-month-view *ngSwitchCase="\'month\'" [(activeDate)]="activeDate" [selected]="selected" [dateFilter]="dateFilter" [maxDate]="maxDate" [minDate]="minDate" (selectedChange)="_dateSelected($event)" (_userSelection)="_userSelected()"></mat-month-view><mat-year-view *ngSwitchCase="\'year\'" [activeDate]="activeDate" [selected]="selected" [dateFilter]="dateFilter" [maxDate]="maxDate" [minDate]="minDate" (monthSelected)="_monthSelectedInYearView($event)" (selectedChange)="_goToDateInView($event, \'month\')"></mat-year-view><mat-multi-year-view *ngSwitchCase="\'multi-year\'" [activeDate]="activeDate" [selected]="selected" [dateFilter]="dateFilter" [maxDate]="maxDate" [minDate]="minDate" (yearSelected)="_yearSelectedInMultiYearView($event)" (selectedChange)="_goToDateInView($event, \'year\')"></mat-multi-year-view></div>',styles:[".mat-calendar{display:block}.mat-calendar-header{padding:8px 8px 0 8px}.mat-calendar-content{padding:0 8px 8px 8px;outline:0}.mat-calendar-controls{display:flex;margin:5% calc(33% / 7 - 16px)}.mat-calendar-spacer{flex:1 1 auto}.mat-calendar-period-button{min-width:0}.mat-calendar-arrow{display:inline-block;width:0;height:0;border-left:5px solid transparent;border-right:5px solid transparent;border-top-width:5px;border-top-style:solid;margin:0 0 0 5px;vertical-align:middle}.mat-calendar-arrow.mat-calendar-invert{transform:rotate(180deg)}[dir=rtl] .mat-calendar-arrow{margin:0 5px 0 0}.mat-calendar-next-button,.mat-calendar-previous-button{position:relative}.mat-calendar-next-button::after,.mat-calendar-previous-button::after{top:0;left:0;right:0;bottom:0;position:absolute;content:'';margin:15.5px;border:0 solid currentColor;border-top-width:2px}[dir=rtl] .mat-calendar-next-button,[dir=rtl] .mat-calendar-previous-button{transform:rotate(180deg)}.mat-calendar-previous-button::after{border-left-width:2px;transform:translateX(2px) rotate(-45deg)}.mat-calendar-next-button::after{border-right-width:2px;transform:translateX(-2px) rotate(45deg)}.mat-calendar-table{border-spacing:0;border-collapse:collapse;width:100%}.mat-calendar-table-header th{text-align:center;padding:0 0 8px 0}.mat-calendar-table-header-divider{position:relative;height:1px}.mat-calendar-table-header-divider::after{content:'';position:absolute;top:0;left:-8px;right:-8px;height:1px}"],host:{class:"mat-calendar"},exportAs:"matCalendar",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:A},{type:n.DateAdapter,decorators:[{type:t.Optional}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[n.MAT_DATE_FORMATS]}]},{type:t.ChangeDetectorRef}]},e.propDecorators={headerComponent:[{type:t.Input}],startAt:[{type:t.Input}],startView:[{type:t.Input}],selected:[{type:t.Input}],minDate:[{type:t.Input}],maxDate:[{type:t.Input}],dateFilter:[{type:t.Input}],selectedChange:[{type:t.Output}],yearSelected:[{type:t.Output}],monthSelected:[{type:t.Output}],_userSelection:[{type:t.Output}],monthView:[{type:t.ViewChild,args:[k]}],yearView:[{type:t.ViewChild,args:[x]}],multiYearView:[{type:t.ViewChild,args:[O]}]},e}(),V={transformPanel:d.trigger("transformPanel",[d.state("void",d.style({opacity:0,transform:"scale(1, 0)"})),d.state("enter",d.style({opacity:1,transform:"scale(1, 1)"})),d.transition("void => enter",d.group([d.query("@fadeInCalendar",d.animateChild()),d.animate("400ms cubic-bezier(0.25, 0.8, 0.25, 1)")])),d.transition("* => void",d.animate("100ms linear",d.style({opacity:0})))]),fadeInCalendar:d.trigger("fadeInCalendar",[d.state("void",d.style({opacity:0})),d.state("enter",d.style({opacity:1})),d.transition("void => *",d.animate("400ms 100ms cubic-bezier(0.55, 0, 0.55, 0.2)"))])},R=0,E=new t.InjectionToken("mat-datepicker-scroll-strategy"),S={provide:E,deps:[c.Overlay],useFactory:b},P=function(){function e(e){this._elementRef=e}return e}(),Y=n.mixinColor(P),T=function(e){function a(t){return e.call(this,t)||this}return y(a,e),a.prototype.ngAfterViewInit=function(){this._calendar.focusActiveCell()},a.decorators=[{type:t.Component,args:[{selector:"mat-datepicker-content",template:'<mat-calendar cdkTrapFocus [id]="datepicker.id" [ngClass]="datepicker.panelClass" [startAt]="datepicker.startAt" [startView]="datepicker.startView" [minDate]="datepicker._minDate" [maxDate]="datepicker._maxDate" [dateFilter]="datepicker._dateFilter" [headerComponent]="datepicker.calendarHeaderComponent" [selected]="datepicker._selected" [@fadeInCalendar]="\'enter\'" (selectedChange)="datepicker._select($event)" (yearSelected)="datepicker._selectYear($event)" (monthSelected)="datepicker._selectMonth($event)" (_userSelection)="datepicker.close()"></mat-calendar>',styles:[".mat-datepicker-content{box-shadow:0 5px 5px -3px rgba(0,0,0,.2),0 8px 10px 1px rgba(0,0,0,.14),0 3px 14px 2px rgba(0,0,0,.12);display:block;border-radius:2px}.mat-datepicker-content .mat-calendar{width:296px;height:354px}.mat-datepicker-content-touch{box-shadow:0 0 0 0 rgba(0,0,0,.2),0 0 0 0 rgba(0,0,0,.14),0 0 0 0 rgba(0,0,0,.12);display:block;max-height:80vh;overflow:auto;margin:-24px}.mat-datepicker-content-touch .mat-calendar{min-width:250px;min-height:312px;max-width:750px;max-height:788px}@media all and (orientation:landscape){.mat-datepicker-content-touch .mat-calendar{width:64vh;height:80vh}}@media all and (orientation:portrait){.mat-datepicker-content-touch .mat-calendar{width:80vw;height:100vw}}"],host:{class:"mat-datepicker-content","[@transformPanel]":'"enter"',"[class.mat-datepicker-content-touch]":"datepicker.touchUi"},animations:[V.transformPanel,V.fadeInCalendar],exportAs:"matDatepickerContent",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush,inputs:["color"]}]}],a.ctorParameters=function(){return[{type:t.ElementRef}]},a.propDecorators={_calendar:[{type:t.ViewChild,args:[I]}]},a}(Y),F=function(){function e(e,i,r,n,o,s,d,l){if(this._dialog=e,this._overlay=i,this._ngZone=r,this._viewContainerRef=n,this._scrollStrategy=o,this._dateAdapter=s,this._dir=d,this._document=l,this.startView="month",this._touchUi=!1,this.yearSelected=new t.EventEmitter,this.monthSelected=new t.EventEmitter,this.openedStream=new t.EventEmitter,this.closedStream=new t.EventEmitter,this._opened=!1,this.id="mat-datepicker-"+R++,this._validSelected=null,this._focusedElementBeforeOpen=null,this._inputSubscription=a.Subscription.EMPTY,this._disabledChange=new a.Subject,this._selectedChanged=new a.Subject,!this._dateAdapter)throw D("DateAdapter")}return Object.defineProperty(e.prototype,"startAt",{get:function(){return this._startAt||(this._datepickerInput?this._datepickerInput.value:null)},set:function(e){this._startAt=this._getValidDateOrNull(this._dateAdapter.deserialize(e))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"color",{get:function(){return this._color||(this._datepickerInput?this._datepickerInput._getThemePalette():void 0)},set:function(e){this._color=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"touchUi",{get:function(){return this._touchUi},set:function(e){this._touchUi=l.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"disabled",{get:function(){return void 0===this._disabled&&this._datepickerInput?this._datepickerInput.disabled:!!this._disabled},set:function(e){var t=l.coerceBooleanProperty(e);t!==this._disabled&&(this._disabled=t,this._disabledChange.next(t))},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"opened",{get:function(){return this._opened},set:function(e){e?this.open():this.close()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_selected",{get:function(){return this._validSelected},set:function(e){this._validSelected=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_minDate",{get:function(){return this._datepickerInput&&this._datepickerInput.min},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_maxDate",{get:function(){return this._datepickerInput&&this._datepickerInput.max},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"_dateFilter",{get:function(){return this._datepickerInput&&this._datepickerInput._dateFilter},enumerable:!0,configurable:!0}),e.prototype.ngOnDestroy=function(){this.close(),this._inputSubscription.unsubscribe(),this._disabledChange.complete(),this._popupRef&&(this._popupRef.dispose(),this._popupComponentRef=null)},e.prototype._select=function(e){var t=this._selected;this._selected=e,this._dateAdapter.sameDate(t,this._selected)||this._selectedChanged.next(e)},e.prototype._selectYear=function(e){this.yearSelected.emit(e)},e.prototype._selectMonth=function(e){this.monthSelected.emit(e)},e.prototype._registerInput=function(e){var t=this;if(this._datepickerInput)throw Error("A MatDatepicker can only be associated with a single input.");this._datepickerInput=e,this._inputSubscription=this._datepickerInput._valueChange.subscribe(function(e){return t._selected=e})},e.prototype.open=function(){if(!this._opened&&!this.disabled){if(!this._datepickerInput)throw Error("Attempted to open an MatDatepicker with no associated input.");this._document&&(this._focusedElementBeforeOpen=this._document.activeElement),this.touchUi?this._openAsDialog():this._openAsPopup(),this._opened=!0,this.openedStream.emit()}},e.prototype.close=function(){var e=this;if(this._opened){this._popupRef&&this._popupRef.hasAttached()&&this._popupRef.detach(),this._dialogRef&&(this._dialogRef.close(),this._dialogRef=null),this._calendarPortal&&this._calendarPortal.isAttached&&this._calendarPortal.detach();var t=function(){e._opened&&(e._opened=!1,e.closedStream.emit(),e._focusedElementBeforeOpen=null)};this._focusedElementBeforeOpen&&"function"==typeof this._focusedElementBeforeOpen.focus?(this._focusedElementBeforeOpen.focus(),setTimeout(t)):t()}},e.prototype._openAsDialog=function(){var e=this;this._dialogRef=this._dialog.open(T,{direction:this._getDirection(),viewContainerRef:this._viewContainerRef,panelClass:"mat-datepicker-dialog"}),this._dialogRef.afterClosed().subscribe(function(){return e.close()}),this._dialogRef.componentInstance.datepicker=this,this._setColor()},e.prototype._openAsPopup=function(){var e=this;this._calendarPortal||(this._calendarPortal=new s.ComponentPortal(T,this._viewContainerRef)),this._popupRef||this._createPopup(),this._popupRef.hasAttached()||(this._popupRef.setDirection(this._getDirection()),this._popupComponentRef=this._popupRef.attach(this._calendarPortal),this._popupComponentRef.instance.datepicker=this,this._setColor(),this._ngZone.onStable.asObservable().pipe(i.take(1)).subscribe(function(){e._popupRef.updatePosition()}))},e.prototype._createPopup=function(){var e=this,t=new c.OverlayConfig({positionStrategy:this._createPopupPositionStrategy(),hasBackdrop:!0,backdropClass:"mat-overlay-transparent-backdrop",direction:this._getDirection(),scrollStrategy:this._scrollStrategy(),panelClass:"mat-datepicker-popup"});this._popupRef=this._overlay.create(t),a.merge(this._popupRef.backdropClick(),this._popupRef.detachments(),this._popupRef.keydownEvents().pipe(i.filter(function(t){return t.keyCode===r.ESCAPE||e._datepickerInput&&t.altKey&&t.keyCode===r.UP_ARROW}))).subscribe(function(){return e.close()})},e.prototype._createPopupPositionStrategy=function(){return this._overlay.position().flexibleConnectedTo(this._datepickerInput.getPopupConnectionElementRef()).withTransformOriginOn(".mat-datepicker-content").withFlexibleDimensions(!1).withViewportMargin(8).withPush(!1).withPositions([{originX:"start",originY:"bottom",overlayX:"start",overlayY:"top"},{originX:"start",originY:"top",overlayX:"start",overlayY:"bottom"},{originX:"end",originY:"bottom",overlayX:"end",overlayY:"top"},{originX:"end",originY:"top",overlayX:"end",overlayY:"bottom"}])},e.prototype._getValidDateOrNull=function(e){return this._dateAdapter.isDateInstance(e)&&this._dateAdapter.isValid(e)?e:null},e.prototype._setColor=function(){var e=this.color;this._popupComponentRef&&(this._popupComponentRef.instance.color=e),this._dialogRef&&(this._dialogRef.componentInstance.color=e)},e.prototype._getDirection=function(){return this._dir?this._dir.value:"ltr"},e.decorators=[{type:t.Component,args:[{selector:"mat-datepicker",template:"",exportAs:"matDatepicker",changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None}]}],e.ctorParameters=function(){return[{type:h.MatDialog},{type:c.Overlay},{type:t.NgZone},{type:t.ViewContainerRef},{type:void 0,decorators:[{type:t.Inject,args:[E]}]},{type:n.DateAdapter,decorators:[{type:t.Optional}]},{type:o.Directionality,decorators:[{type:t.Optional}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[p.DOCUMENT]}]}]},e.propDecorators={calendarHeaderComponent:[{type:t.Input}],startAt:[{type:t.Input}],startView:[{type:t.Input}],color:[{type:t.Input}],touchUi:[{type:t.Input}],disabled:[{type:t.Input}],yearSelected:[{type:t.Output}],monthSelected:[{type:t.Output}],panelClass:[{type:t.Input}],openedStream:[{type:t.Output,args:["opened"]}],closedStream:[{type:t.Output,args:["closed"]}],opened:[{type:t.Input}]},e}(),N={provide:u.NG_VALUE_ACCESSOR,useExisting:t.forwardRef(function(){return B}),multi:!0},j={provide:u.NG_VALIDATORS,useExisting:t.forwardRef(function(){return B}),multi:!0},L=function(){function e(e,t){this.target=e,this.targetElement=t,this.value=this.target.value}return e}(),B=function(){function e(e,i,r,n){var o=this;if(this._elementRef=e,this._dateAdapter=i,this._dateFormats=r,this._formField=n,this.dateChange=new t.EventEmitter,this.dateInput=new t.EventEmitter,this._valueChange=new t.EventEmitter,this._disabledChange=new t.EventEmitter,this._onTouched=function(){},this._cvaOnChange=function(){},this._validatorOnChange=function(){},this._datepickerSubscription=a.Subscription.EMPTY,this._localeSubscription=a.Subscription.EMPTY,this._parseValidator=function(){return o._lastValueValid?null:{matDatepickerParse:{text:o._elementRef.nativeElement.value}}},this._minValidator=function(e){var t=o._getValidDateOrNull(o._dateAdapter.deserialize(e.value));return!o.min||!t||o._dateAdapter.compareDate(o.min,t)<=0?null:{matDatepickerMin:{min:o.min,actual:t}}},this._maxValidator=function(e){var t=o._getValidDateOrNull(o._dateAdapter.deserialize(e.value));return!o.max||!t||o._dateAdapter.compareDate(o.max,t)>=0?null:{matDatepickerMax:{max:o.max,actual:t}}},this._filterValidator=function(e){var t=o._getValidDateOrNull(o._dateAdapter.deserialize(e.value));return o._dateFilter&&t&&!o._dateFilter(t)?{matDatepickerFilter:!0}:null},this._validator=u.Validators.compose([this._parseValidator,this._minValidator,this._maxValidator,this._filterValidator]),this._lastValueValid=!1,!this._dateAdapter)throw D("DateAdapter");if(!this._dateFormats)throw D("MAT_DATE_FORMATS");this._localeSubscription=i.localeChanges.subscribe(function(){o.value=o.value})}return Object.defineProperty(e.prototype,"matDatepicker",{set:function(e){this.registerDatepicker(e)},enumerable:!0,configurable:!0}),e.prototype.registerDatepicker=function(e){e&&(this._datepicker=e,this._datepicker._registerInput(this))},Object.defineProperty(e.prototype,"matDatepickerFilter",{set:function(e){this._dateFilter=e,this._validatorOnChange()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"value",{get:function(){return this._value},set:function(e){e=this._dateAdapter.deserialize(e),this._lastValueValid=!e||this._dateAdapter.isValid(e),e=this._getValidDateOrNull(e);var t=this.value;this._value=e,this._formatValue(e),this._dateAdapter.sameDate(t,e)||this._valueChange.emit(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"min",{get:function(){return this._min},set:function(e){this._min=this._getValidDateOrNull(this._dateAdapter.deserialize(e)),this._validatorOnChange()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"max",{get:function(){return this._max},set:function(e){this._max=this._getValidDateOrNull(this._dateAdapter.deserialize(e)),this._validatorOnChange()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"disabled",{get:function(){return!!this._disabled},set:function(e){var t=l.coerceBooleanProperty(e),a=this._elementRef.nativeElement;this._disabled!==t&&(this._disabled=t,this._disabledChange.emit(t)),t&&a.blur&&a.blur()},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this._datepicker&&(this._datepickerSubscription=this._datepicker._selectedChanged.subscribe(function(t){e.value=t,e._cvaOnChange(t),e._onTouched(),e.dateInput.emit(new L(e,e._elementRef.nativeElement)),e.dateChange.emit(new L(e,e._elementRef.nativeElement))}))},e.prototype.ngOnDestroy=function(){this._datepickerSubscription.unsubscribe(),this._localeSubscription.unsubscribe(),this._valueChange.complete(),this._disabledChange.complete()},e.prototype.registerOnValidatorChange=function(e){this._validatorOnChange=e},e.prototype.validate=function(e){return this._validator?this._validator(e):null},e.prototype.getPopupConnectionElementRef=function(){return this.getConnectedOverlayOrigin()},e.prototype.getConnectedOverlayOrigin=function(){return this._formField?this._formField.getConnectedOverlayOrigin():this._elementRef},e.prototype.writeValue=function(e){this.value=e},e.prototype.registerOnChange=function(e){this._cvaOnChange=e},e.prototype.registerOnTouched=function(e){this._onTouched=e},e.prototype.setDisabledState=function(e){this.disabled=e},e.prototype._onKeydown=function(e){e.altKey&&e.keyCode===r.DOWN_ARROW&&(this._datepicker.open(),e.preventDefault())},e.prototype._onInput=function(e){var t=this._dateAdapter.parse(e,this._dateFormats.parse.dateInput);this._lastValueValid=!t||this._dateAdapter.isValid(t),t=this._getValidDateOrNull(t),this._dateAdapter.sameDate(t,this._value)||(this._value=t,this._cvaOnChange(t),this._valueChange.emit(t),this.dateInput.emit(new L(this,this._elementRef.nativeElement)))},e.prototype._onChange=function(){this.dateChange.emit(new L(this,this._elementRef.nativeElement))},e.prototype._getThemePalette=function(){return this._formField?this._formField.color:void 0},e.prototype._onBlur=function(){this.value&&this._formatValue(this.value),this._onTouched()},e.prototype._formatValue=function(e){this._elementRef.nativeElement.value=e?this._dateAdapter.format(e,this._dateFormats.display.dateInput):""},e.prototype._getValidDateOrNull=function(e){return this._dateAdapter.isDateInstance(e)&&this._dateAdapter.isValid(e)?e:null},e.decorators=[{type:t.Directive,args:[{selector:"input[matDatepicker]",providers:[N,j,{provide:m.MAT_INPUT_VALUE_ACCESSOR,useExisting:e}],host:{"[attr.aria-haspopup]":"true","[attr.aria-owns]":"(_datepicker?.opened && _datepicker.id) || null","[attr.min]":"min ? _dateAdapter.toIso8601(min) : null","[attr.max]":"max ? _dateAdapter.toIso8601(max) : null","[disabled]":"disabled","(input)":"_onInput($event.target.value)","(change)":"_onChange()","(blur)":"_onBlur()","(keydown)":"_onKeydown($event)"},exportAs:"matDatepickerInput"}]}],e.ctorParameters=function(){return[{type:t.ElementRef},{type:n.DateAdapter,decorators:[{type:t.Optional}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[n.MAT_DATE_FORMATS]}]},{type:_.MatFormField,decorators:[{type:t.Optional}]}]},e.propDecorators={matDatepicker:[{type:t.Input}],matDatepickerFilter:[{type:t.Input}],value:[{type:t.Input}],min:[{type:t.Input}],max:[{type:t.Input}],disabled:[{type:t.Input}],dateChange:[{type:t.Output}],dateInput:[{type:t.Output}]},e}(),z=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"[matDatepickerToggleIcon]"}]}],e}(),W=function(){function e(e,t){this._intl=e,this._changeDetectorRef=t,this._stateChanges=a.Subscription.EMPTY}return Object.defineProperty(e.prototype,"disabled",{get:function(){return void 0===this._disabled?this.datepicker.disabled:!!this._disabled},set:function(e){this._disabled=l.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),e.prototype.ngOnChanges=function(e){e.datepicker&&this._watchStateChanges()},e.prototype.ngOnDestroy=function(){this._stateChanges.unsubscribe()},e.prototype.ngAfterContentInit=function(){this._watchStateChanges()},e.prototype._open=function(e){this.datepicker&&!this.disabled&&(this.datepicker.open(),e.stopPropagation())},e.prototype._watchStateChanges=function(){var e=this,t=this.datepicker?this.datepicker._disabledChange:a.of(),i=this.datepicker&&this.datepicker._datepickerInput?this.datepicker._datepickerInput._disabledChange:a.of(),r=this.datepicker?a.merge(this.datepicker.openedStream,this.datepicker.closedStream):a.of();this._stateChanges.unsubscribe(),this._stateChanges=a.merge(this._intl.changes,t,i,r).subscribe(function(){return e._changeDetectorRef.markForCheck()})},e.decorators=[{type:t.Component,args:[{selector:"mat-datepicker-toggle",template:'<button mat-icon-button type="button" [attr.aria-label]="_intl.openCalendarLabel" [disabled]="disabled" (click)="_open($event)"><svg *ngIf="!_customIcon" class="mat-datepicker-toggle-default-icon" viewBox="0 0 24 24" width="24px" height="24px" fill="currentColor" focusable="false"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 3h-1V1h-2v2H8V1H6v2H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16H5V8h14v11zM7 10h5v5H7z"/></svg><ng-content select="[matDatepickerToggleIcon]"></ng-content></button>',styles:[".mat-form-field-appearance-legacy .mat-form-field-prefix .mat-datepicker-toggle-default-icon,.mat-form-field-appearance-legacy .mat-form-field-suffix .mat-datepicker-toggle-default-icon{width:1em}.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-prefix .mat-datepicker-toggle-default-icon,.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-suffix .mat-datepicker-toggle-default-icon{display:block;width:1.5em;height:1.5em}.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-prefix .mat-icon-button .mat-datepicker-toggle-default-icon,.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-suffix .mat-icon-button .mat-datepicker-toggle-default-icon{margin:auto}"],host:{class:"mat-datepicker-toggle","[class.mat-datepicker-toggle-active]":"datepicker && datepicker.opened","[class.mat-accent]":'datepicker && datepicker.color === "accent"',"[class.mat-warn]":'datepicker && datepicker.color === "warn"'},exportAs:"matDatepickerToggle",encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:A},{type:t.ChangeDetectorRef}]},e.propDecorators={datepicker:[{type:t.Input,args:["for"]}],disabled:[{type:t.Input}],_customIcon:[{type:t.ContentChild,args:[z]}]},e}(),q=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[p.CommonModule,g.MatButtonModule,h.MatDialogModule,c.OverlayModule,f.A11yModule,s.PortalModule],exports:[I,w,F,T,B,W,z,k,x,O,M],declarations:[I,w,F,T,B,W,z,k,x,O,M],providers:[A,S],entryComponents:[T,M]}]}],e}();e.MatDatepickerModule=q,e.MatCalendarHeader=M,e.MatCalendar=I,e.MatCalendarCell=C,e.MatCalendarBody=w,e.MAT_DATEPICKER_SCROLL_STRATEGY=E,e.MAT_DATEPICKER_SCROLL_STRATEGY_FACTORY=b,e.MAT_DATEPICKER_SCROLL_STRATEGY_FACTORY_PROVIDER=S,e.MatDatepickerContentBase=P,e._MatDatepickerContentMixinBase=Y,e.MatDatepickerContent=T,e.MatDatepicker=F,e.matDatepickerAnimations=V,e.MAT_DATEPICKER_VALUE_ACCESSOR=N,e.MAT_DATEPICKER_VALIDATORS=j,e.MatDatepickerInputEvent=L,e.MatDatepickerInput=B,e.MatDatepickerIntl=A,e.MatDatepickerToggleIcon=z,e.MatDatepickerToggle=W,e.MatMonthView=k,e.MatYearView=x,e.ɵa34=O,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-datepicker.umd.min.js.map
