/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/cdk/coercion"),require("@angular/cdk/accordion"),require("@angular/animations"),require("@angular/cdk/collections"),require("@angular/cdk/portal"),require("rxjs"),require("rxjs/operators"),require("@angular/cdk/a11y"),require("@angular/cdk/keycodes"),require("@angular/common")):"function"==typeof define&&define.amd?define("@angular/material/expansion",["exports","@angular/core","@angular/cdk/coercion","@angular/cdk/accordion","@angular/animations","@angular/cdk/collections","@angular/cdk/portal","rxjs","rxjs/operators","@angular/cdk/a11y","@angular/cdk/keycodes","@angular/common"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.expansion={}),e.ng.core,e.ng.cdk.coercion,e.ng.cdk.accordion,e.ng.animations,e.ng.cdk.collections,e.ng.cdk.portal,e.Rx,e.Rx.operators,e.ng.cdk.a11y,e.ng.cdk.keycodes,e.ng.common)}(this,function(e,t,n,a,o,i,r,p,s,d,c,l){"use strict";function g(e,t){function n(){this.constructor=e}u(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}var u=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])},h=function(e){function a(){var t=null!==e&&e.apply(this,arguments)||this;return t._hideToggle=!1,t.displayMode="default",t}return g(a,e),Object.defineProperty(a.prototype,"hideToggle",{get:function(){return this._hideToggle},set:function(e){this._hideToggle=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),a.decorators=[{type:t.Directive,args:[{selector:"mat-accordion",exportAs:"matAccordion",host:{class:"mat-accordion"}}]}],a.propDecorators={hideToggle:[{type:t.Input}],displayMode:[{type:t.Input}]},a}(a.CdkAccordion),m={indicatorRotate:o.trigger("indicatorRotate",[o.state("collapsed",o.style({transform:"rotate(0deg)"})),o.state("expanded",o.style({transform:"rotate(180deg)"})),o.transition("expanded <=> collapsed",o.animate("225ms cubic-bezier(0.4,0.0,0.2,1)"))]),expansionHeaderHeight:o.trigger("expansionHeight",[o.state("collapsed",o.style({height:"{{collapsedHeight}}"}),{params:{collapsedHeight:"48px"}}),o.state("expanded",o.style({height:"{{expandedHeight}}"}),{params:{expandedHeight:"64px"}}),o.transition("expanded <=> collapsed",o.group([o.query("@indicatorRotate",o.animateChild(),{optional:!0}),o.animate("225ms cubic-bezier(0.4,0.0,0.2,1)")]))]),bodyExpansion:o.trigger("bodyExpansion",[o.state("collapsed",o.style({height:"0px",visibility:"hidden"})),o.state("expanded",o.style({height:"*",visibility:"visible"})),o.transition("expanded <=> collapsed",o.animate("225ms cubic-bezier(0.4,0.0,0.2,1)"))])},x=function(){function e(e){this._template=e}return e.decorators=[{type:t.Directive,args:[{selector:"ng-template[matExpansionPanelContent]"}]}],e.ctorParameters=function(){return[{type:t.TemplateRef}]},e}(),y=0,f=function(e){function a(t,n,a,o){var i=e.call(this,t,n,a)||this;return i._viewContainerRef=o,i._hideToggle=!1,i._inputChanges=new p.Subject,i._headerId="mat-expansion-panel-header-"+y++,i.accordion=t,i}return g(a,e),Object.defineProperty(a.prototype,"hideToggle",{get:function(){return this._hideToggle},set:function(e){this._hideToggle=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),a.prototype._getHideToggle=function(){return this.accordion?this.accordion.hideToggle:this.hideToggle},a.prototype._hasSpacing=function(){return!!this.accordion&&"default"===(this.expanded?this.accordion.displayMode:this._getExpandedState())},a.prototype._getExpandedState=function(){return this.expanded?"expanded":"collapsed"},a.prototype.ngAfterContentInit=function(){var e=this;this._lazyContent&&this.opened.pipe(s.startWith(null),s.filter(function(){return e.expanded&&!e._portal}),s.take(1)).subscribe(function(){e._portal=new r.TemplatePortal(e._lazyContent._template,e._viewContainerRef)})},a.prototype.ngOnChanges=function(e){this._inputChanges.next(e)},a.prototype.ngOnDestroy=function(){e.prototype.ngOnDestroy.call(this),this._inputChanges.complete()},a.prototype._bodyAnimation=function(e){var t=e.element.classList,n=e.phaseName,a=e.toState;"done"===n&&"expanded"===a?t.add("mat-expanded"):"start"===n&&"collapsed"===a&&t.remove("mat-expanded")},a.decorators=[{type:t.Component,args:[{styles:[".mat-expansion-panel{transition:box-shadow 280ms cubic-bezier(.4,0,.2,1);box-sizing:content-box;display:block;margin:0;transition:margin 225ms cubic-bezier(.4,0,.2,1)}.mat-expansion-panel:not([class*=mat-elevation-z]){box-shadow:0 3px 1px -2px rgba(0,0,0,.2),0 2px 2px 0 rgba(0,0,0,.14),0 1px 5px 0 rgba(0,0,0,.12)}.mat-expansion-panel-content{overflow:hidden}.mat-expansion-panel-content.mat-expanded{overflow:visible}.mat-expansion-panel-body{padding:0 24px 16px}.mat-expansion-panel-spacing{margin:16px 0}.mat-accordion>.mat-expansion-panel-spacing:first-child,.mat-accordion>:first-child:not(.mat-expansion-panel) .mat-expansion-panel-spacing{margin-top:0}.mat-accordion>.mat-expansion-panel-spacing:last-child,.mat-accordion>:last-child:not(.mat-expansion-panel) .mat-expansion-panel-spacing{margin-bottom:0}.mat-action-row{border-top-style:solid;border-top-width:1px;display:flex;flex-direction:row;justify-content:flex-end;padding:16px 8px 16px 24px}.mat-action-row button.mat-button{margin-left:8px}[dir=rtl] .mat-action-row button.mat-button{margin-left:0;margin-right:8px}"],selector:"mat-expansion-panel",exportAs:"matExpansionPanel",template:'<ng-content select="mat-expansion-panel-header"></ng-content><div class="mat-expansion-panel-content" role="region" [@bodyExpansion]="_getExpandedState()" (@bodyExpansion.done)="_bodyAnimation($event)" (@bodyExpansion.start)="_bodyAnimation($event)" [attr.aria-labelledby]="_headerId" [id]="id" #body><div class="mat-expansion-panel-body"><ng-content></ng-content><ng-template [cdkPortalOutlet]="_portal"></ng-template></div><ng-content select="mat-action-row"></ng-content></div>',encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush,inputs:["disabled","expanded"],outputs:["opened","closed","expandedChange"],animations:[m.bodyExpansion],host:{class:"mat-expansion-panel","[class.mat-expanded]":"expanded","[class.mat-expansion-panel-spacing]":"_hasSpacing()"}}]}],a.ctorParameters=function(){return[{type:h,decorators:[{type:t.Optional}]},{type:t.ChangeDetectorRef},{type:i.UniqueSelectionDispatcher},{type:t.ViewContainerRef}]},a.propDecorators={hideToggle:[{type:t.Input}],_lazyContent:[{type:t.ContentChild,args:[x]}]},a}(a.CdkAccordionItem),b=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-action-row",host:{class:"mat-action-row"}}]}],e}(),_=function(){function e(e,t,n,a){var o=this;this.panel=e,this._element=t,this._focusMonitor=n,this._changeDetectorRef=a,this._parentChangeSubscription=p.Subscription.EMPTY,this._parentChangeSubscription=p.merge(e.opened,e.closed,e._inputChanges.pipe(s.filter(function(e){return!(!e.hideToggle&&!e.disabled)}))).subscribe(function(){return o._changeDetectorRef.markForCheck()}),n.monitor(t.nativeElement)}return e.prototype._toggle=function(){this.panel.toggle()},e.prototype._isExpanded=function(){return this.panel.expanded},e.prototype._getExpandedState=function(){return this.panel._getExpandedState()},e.prototype._getPanelId=function(){return this.panel.id},e.prototype._showToggle=function(){return!this.panel.hideToggle&&!this.panel.disabled},e.prototype._keydown=function(e){switch(e.keyCode){case c.SPACE:case c.ENTER:e.preventDefault(),this._toggle();break;default:return}},e.prototype.ngOnDestroy=function(){this._parentChangeSubscription.unsubscribe(),this._focusMonitor.stopMonitoring(this._element.nativeElement)},e.decorators=[{type:t.Component,args:[{selector:"mat-expansion-panel-header",styles:[".mat-expansion-panel-header{display:flex;flex-direction:row;align-items:center;padding:0 24px}.mat-expansion-panel-header:focus,.mat-expansion-panel-header:hover{outline:0}.mat-expansion-panel-header.mat-expanded:focus,.mat-expansion-panel-header.mat-expanded:hover{background:inherit}.mat-expansion-panel-header:not([aria-disabled=true]){cursor:pointer}.mat-content{display:flex;flex:1;flex-direction:row;overflow:hidden}.mat-expansion-panel-header-description,.mat-expansion-panel-header-title{display:flex;flex-grow:1;margin-right:16px}[dir=rtl] .mat-expansion-panel-header-description,[dir=rtl] .mat-expansion-panel-header-title{margin-right:0;margin-left:16px}.mat-expansion-panel-header-description{flex-grow:2}.mat-expansion-indicator::after{border-style:solid;border-width:0 2px 2px 0;content:'';display:inline-block;padding:3px;transform:rotate(45deg);vertical-align:middle}"],template:'<span class="mat-content"><ng-content select="mat-panel-title"></ng-content><ng-content select="mat-panel-description"></ng-content><ng-content></ng-content></span><span [@indicatorRotate]="_getExpandedState()" *ngIf="_showToggle()" class="mat-expansion-indicator"></span>',encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush,animations:[m.indicatorRotate,m.expansionHeaderHeight],host:{class:"mat-expansion-panel-header",role:"button","[attr.id]":"panel._headerId","[attr.tabindex]":"panel.disabled ? -1 : 0","[attr.aria-controls]":"_getPanelId()","[attr.aria-expanded]":"_isExpanded()","[attr.aria-disabled]":"panel.disabled","[class.mat-expanded]":"_isExpanded()","(click)":"_toggle()","(keydown)":"_keydown($event)","[@expansionHeight]":"{\n        value: _getExpandedState(),\n        params: {\n          collapsedHeight: collapsedHeight,\n          expandedHeight: expandedHeight\n        }\n    }"}}]}],e.ctorParameters=function(){return[{type:f,decorators:[{type:t.Host}]},{type:t.ElementRef},{type:d.FocusMonitor},{type:t.ChangeDetectorRef}]},e.propDecorators={expandedHeight:[{type:t.Input}],collapsedHeight:[{type:t.Input}]},e}(),v=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-panel-description",host:{class:"mat-expansion-panel-header-description"}}]}],e}(),k=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-panel-title",host:{class:"mat-expansion-panel-header-title"}}]}],e}(),E=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[l.CommonModule,a.CdkAccordionModule,r.PortalModule],exports:[h,f,b,_,k,v,x],declarations:[h,f,b,_,k,v,x]}]}],e}();e.MatExpansionModule=E,e.MatAccordion=h,e.MatExpansionPanel=f,e.MatExpansionPanelActionRow=b,e.MatExpansionPanelHeader=_,e.MatExpansionPanelDescription=v,e.MatExpansionPanelTitle=k,e.MatExpansionPanelContent=x,e.EXPANSION_PANEL_ANIMATION_TIMING="225ms cubic-bezier(0.4,0.0,0.2,1)",e.matExpansionAnimations=m,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-expansion.umd.min.js.map
