/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/animations"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/material/core"),require("rxjs"),require("rxjs/operators"),require("@angular/cdk/platform"),require("@angular/common")):"function"==typeof define&&define.amd?define("@angular/material/formField",["exports","@angular/core","@angular/animations","@angular/cdk/bidi","@angular/cdk/coercion","@angular/material/core","rxjs","rxjs/operators","@angular/cdk/platform","@angular/common"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.formField={}),e.ng.core,e.ng.animations,e.ng.cdk.bidi,e.ng.cdk.coercion,e.ng.material.core,e.Rx,e.Rx.operators,e.ng.cdk.platform,e.ng.common)}(this,function(e,t,a,i,r,n,o,l,s,f){"use strict";function d(e,t){function a(){this.constructor=e}u(e,t),e.prototype=null===t?Object.create(t):(a.prototype=t.prototype,new a)}function c(){return Error("Placeholder attribute and child element were both specified.")}function m(e){return Error("A hint was already declared for 'align=\""+e+"\"'.")}function p(){return Error("mat-form-field must contain a MatFormFieldControl.")}var u=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var a in t)t.hasOwnProperty(a)&&(e[a]=t[a])},h=0,g=function(){function e(){this.id="mat-error-"+h++}return e.decorators=[{type:t.Directive,args:[{selector:"mat-error",host:{class:"mat-error",role:"alert","[attr.id]":"id"}}]}],e.propDecorators={id:[{type:t.Input}]},e}(),b={transitionMessages:a.trigger("transitionMessages",[a.state("enter",a.style({opacity:1,transform:"translateY(0%)"})),a.transition("void => enter",[a.style({opacity:0,transform:"translateY(-100%)"}),a.animate("300ms cubic-bezier(0.55, 0, 0.55, 0.2)")])])},_=function(){function e(){}return e}(),y=0,v=function(){function e(){this.align="start",this.id="mat-hint-"+y++}return e.decorators=[{type:t.Directive,args:[{selector:"mat-hint",host:{class:"mat-hint","[class.mat-right]":'align == "end"',"[attr.id]":"id","[attr.align]":"null"}}]}],e.propDecorators={align:[{type:t.Input}],id:[{type:t.Input}]},e}(),w=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-label"}]}],e}(),x=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-placeholder"}]}],e}(),C=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"[matPrefix]"}]}],e}(),k=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"[matSuffix]"}]}],e}(),F=0,L=function(){function e(e){this._elementRef=e}return e}(),M=n.mixinColor(L,"primary"),D=new t.InjectionToken("MAT_FORM_FIELD_DEFAULT_OPTIONS"),O=function(e){function a(t,a,i,r,n,o){var l=e.call(this,t)||this;return l._elementRef=t,l._changeDetectorRef=a,l._dir=r,l._defaultOptions=n,l._platform=o,l._showAlwaysAnimate=!1,l._subscriptAnimationState="",l._hintLabel="",l._hintLabelId="mat-hint-"+F++,l._outlineGapWidth=0,l._outlineGapStart=0,l._initialGapCalculated=!1,l._labelOptions=i||{},l.floatLabel=l._labelOptions.float||"auto",l}return d(a,e),Object.defineProperty(a.prototype,"appearance",{get:function(){return this._appearance||this._defaultOptions&&this._defaultOptions.appearance||"legacy"},set:function(e){this._appearance=e},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"hideRequiredMarker",{get:function(){return this._hideRequiredMarker},set:function(e){this._hideRequiredMarker=r.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_shouldAlwaysFloat",{get:function(){return"always"===this.floatLabel&&!this._showAlwaysAnimate},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_canLabelFloat",{get:function(){return"never"!==this.floatLabel},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"hintLabel",{get:function(){return this._hintLabel},set:function(e){this._hintLabel=e,this._processHints()},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"floatLabel",{get:function(){return"legacy"!==this.appearance&&"never"===this._floatLabel?"auto":this._floatLabel},set:function(e){e!==this._floatLabel&&(this._floatLabel=e||this._labelOptions.float||"auto",this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),a.prototype.getConnectedOverlayOrigin=function(){return this._connectionContainerRef||this._elementRef},a.prototype.ngAfterContentInit=function(){var e=this;this._validateControlChild(),this._control.controlType&&this._elementRef.nativeElement.classList.add("mat-form-field-type-"+this._control.controlType),this._control.stateChanges.pipe(l.startWith(null)).subscribe(function(){e._validatePlaceholders(),e._syncDescribedByIds(),e._changeDetectorRef.markForCheck()});var t=this._control.ngControl&&this._control.ngControl.valueChanges||o.EMPTY;o.merge(t,this._prefixChildren.changes,this._suffixChildren.changes).subscribe(function(){return e._changeDetectorRef.markForCheck()}),this._hintChildren.changes.pipe(l.startWith(null)).subscribe(function(){e._processHints(),e._changeDetectorRef.markForCheck()}),this._errorChildren.changes.pipe(l.startWith(null)).subscribe(function(){e._syncDescribedByIds(),e._changeDetectorRef.markForCheck()})},a.prototype.ngAfterContentChecked=function(){var e=this;this._validateControlChild(),this._initialGapCalculated||Promise.resolve().then(function(){return e.updateOutlineGap()})},a.prototype.ngAfterViewInit=function(){this._subscriptAnimationState="enter",this._changeDetectorRef.detectChanges()},a.prototype._shouldForward=function(e){var t=this._control?this._control.ngControl:null;return t&&t[e]},a.prototype._hasPlaceholder=function(){return!!(this._control&&this._control.placeholder||this._placeholderChild)},a.prototype._hasLabel=function(){return!!this._labelChild},a.prototype._shouldLabelFloat=function(){return this._canLabelFloat&&(this._control.shouldLabelFloat||this._shouldAlwaysFloat)},a.prototype._hideControlPlaceholder=function(){return"legacy"===this.appearance&&!this._hasLabel()||this._hasLabel()&&!this._shouldLabelFloat()},a.prototype._hasFloatingLabel=function(){return this._hasLabel()||"legacy"===this.appearance&&this._hasPlaceholder()},a.prototype._getDisplayedMessages=function(){return this._errorChildren&&this._errorChildren.length>0&&this._control.errorState?"error":"hint"},a.prototype._animateAndLockLabel=function(){var e=this;this._hasFloatingLabel()&&this._canLabelFloat&&(this._showAlwaysAnimate=!0,this.floatLabel="always",o.fromEvent(this._label.nativeElement,"transitionend").pipe(l.take(1)).subscribe(function(){e._showAlwaysAnimate=!1}),this._changeDetectorRef.markForCheck())},a.prototype._validatePlaceholders=function(){if(this._control.placeholder&&this._placeholderChild)throw c()},a.prototype._processHints=function(){this._validateHints(),this._syncDescribedByIds()},a.prototype._validateHints=function(){var e=this;if(this._hintChildren){var t,a;this._hintChildren.forEach(function(i){if("start"===i.align){if(t||e.hintLabel)throw m("start");t=i}else if("end"===i.align){if(a)throw m("end");a=i}})}},a.prototype._syncDescribedByIds=function(){if(this._control){var e=[];if("hint"===this._getDisplayedMessages()){var t=this._hintChildren?this._hintChildren.find(function(e){return"start"===e.align}):null,a=this._hintChildren?this._hintChildren.find(function(e){return"end"===e.align}):null;t?e.push(t.id):this._hintLabel&&e.push(this._hintLabelId),a&&e.push(a.id)}else this._errorChildren&&(e=this._errorChildren.map(function(e){return e.id}));this._control.setDescribedByIds(e)}},a.prototype._validateControlChild=function(){if(!this._control)throw p()},a.prototype.updateOutlineGap=function(){if("outline"===this.appearance&&this._label&&this._label.nativeElement.children.length){if(this._platform&&!this._platform.isBrowser)return void(this._initialGapCalculated=!0);if(!document.documentElement.contains(this._elementRef.nativeElement))return;for(var e=this._getStartEnd(this._connectionContainerRef.nativeElement.getBoundingClientRect()),t=this._getStartEnd(this._label.nativeElement.children[0].getBoundingClientRect()),a=0,i=0,r=this._label.nativeElement.children;i<r.length;i++){a+=r[i].offsetWidth}this._outlineGapStart=t-e-5,this._outlineGapWidth=.75*a+10}else this._outlineGapStart=0,this._outlineGapWidth=0;this._initialGapCalculated=!0,this._changeDetectorRef.markForCheck()},a.prototype._getStartEnd=function(e){return this._dir&&"rtl"===this._dir.value?e.right:e.left},a.decorators=[{type:t.Component,args:[{selector:"mat-form-field",exportAs:"matFormField",template:'<div class="mat-form-field-wrapper"><div class="mat-form-field-flex" #connectionContainer (click)="_control.onContainerClick && _control.onContainerClick($event)"><div class="mat-form-field-prefix" *ngIf="_prefixChildren.length"><ng-content select="[matPrefix]"></ng-content></div><div class="mat-form-field-infix" #inputContainer><ng-content></ng-content><span class="mat-form-field-label-wrapper"><label class="mat-form-field-label" [attr.for]="_control.id" [attr.aria-owns]="_control.id" [class.mat-empty]="_control.empty && !_shouldAlwaysFloat" [class.mat-form-field-empty]="_control.empty && !_shouldAlwaysFloat" [class.mat-accent]="color == \'accent\'" [class.mat-warn]="color == \'warn\'" #label *ngIf="_hasFloatingLabel()" [ngSwitch]="_hasLabel()"><ng-container *ngSwitchCase="false"><ng-content select="mat-placeholder"></ng-content>{{_control.placeholder}}</ng-container><ng-content select="mat-label" *ngSwitchCase="true"></ng-content><span class="mat-placeholder-required mat-form-field-required-marker" aria-hidden="true" *ngIf="!hideRequiredMarker && _control.required && !_control.disabled">&nbsp;*</span></label></span></div><div class="mat-form-field-suffix" *ngIf="_suffixChildren.length"><ng-content select="[matSuffix]"></ng-content></div></div><div class="mat-form-field-underline" #underline *ngIf="appearance != \'outline\'"><span class="mat-form-field-ripple" [class.mat-accent]="color == \'accent\'" [class.mat-warn]="color == \'warn\'"></span></div><ng-container *ngIf="appearance == \'outline\'"><div class="mat-form-field-outline"><div class="mat-form-field-outline-start" [style.width.px]="_outlineGapStart"></div><div class="mat-form-field-outline-gap" [style.width.px]="_outlineGapWidth"></div><div class="mat-form-field-outline-end"></div></div><div class="mat-form-field-outline mat-form-field-outline-thick"><div class="mat-form-field-outline-start" [style.width.px]="_outlineGapStart"></div><div class="mat-form-field-outline-gap" [style.width.px]="_outlineGapWidth"></div><div class="mat-form-field-outline-end"></div></div></ng-container><div class="mat-form-field-subscript-wrapper" [ngSwitch]="_getDisplayedMessages()"><div *ngSwitchCase="\'error\'" [@transitionMessages]="_subscriptAnimationState"><ng-content select="mat-error"></ng-content></div><div class="mat-form-field-hint-wrapper" *ngSwitchCase="\'hint\'" [@transitionMessages]="_subscriptAnimationState"><div *ngIf="hintLabel" [id]="_hintLabelId" class="mat-hint">{{hintLabel}}</div><ng-content select="mat-hint:not([align=\'end\'])"></ng-content><div class="mat-form-field-hint-spacer"></div><ng-content select="mat-hint[align=\'end\']"></ng-content></div></div></div>',styles:[".mat-form-field{display:inline-block;position:relative;text-align:left}[dir=rtl] .mat-form-field{text-align:right}.mat-form-field-wrapper{position:relative}.mat-form-field-flex{display:inline-flex;align-items:baseline;box-sizing:border-box;width:100%}.mat-form-field-prefix,.mat-form-field-suffix{white-space:nowrap;flex:none;position:relative}.mat-form-field-infix{display:block;position:relative;flex:auto;min-width:0;width:180px}.mat-form-field-label-wrapper{position:absolute;left:0;box-sizing:content-box;width:100%;height:100%;overflow:hidden;pointer-events:none}.mat-form-field-label{position:absolute;left:0;font:inherit;pointer-events:none;width:100%;white-space:nowrap;text-overflow:ellipsis;overflow:hidden;transform-origin:0 0;transition:transform .4s cubic-bezier(.25,.8,.25,1),color .4s cubic-bezier(.25,.8,.25,1),width .4s cubic-bezier(.25,.8,.25,1);display:none}[dir=rtl] .mat-form-field-label{transform-origin:100% 0;left:auto;right:0}.mat-form-field-can-float.mat-form-field-should-float .mat-form-field-label,.mat-form-field-empty.mat-form-field-label{display:block}.mat-form-field-autofill-control:-webkit-autofill+.mat-form-field-label-wrapper .mat-form-field-label{display:none}.mat-form-field-can-float .mat-form-field-autofill-control:-webkit-autofill+.mat-form-field-label-wrapper .mat-form-field-label{display:block;transition:none}.mat-input-server:focus+.mat-form-field-label-wrapper .mat-form-field-label,.mat-input-server[placeholder]:not(:placeholder-shown)+.mat-form-field-label-wrapper .mat-form-field-label{display:none}.mat-form-field-can-float .mat-input-server:focus+.mat-form-field-label-wrapper .mat-form-field-label,.mat-form-field-can-float .mat-input-server[placeholder]:not(:placeholder-shown)+.mat-form-field-label-wrapper .mat-form-field-label{display:block}.mat-form-field-label:not(.mat-form-field-empty){transition:none}.mat-form-field-underline{position:absolute;width:100%;pointer-events:none;transform:scaleY(1.0001)}.mat-form-field-ripple{position:absolute;left:0;width:100%;transform-origin:50%;transform:scaleX(.5);opacity:0;transition:background-color .3s cubic-bezier(.55,0,.55,.2)}.mat-form-field.mat-focused .mat-form-field-ripple,.mat-form-field.mat-form-field-invalid .mat-form-field-ripple{opacity:1;transform:scaleX(1);transition:transform .3s cubic-bezier(.25,.8,.25,1),opacity .1s cubic-bezier(.25,.8,.25,1),background-color .3s cubic-bezier(.25,.8,.25,1)}.mat-form-field-subscript-wrapper{position:absolute;box-sizing:border-box;width:100%;overflow:hidden}.mat-form-field-label-wrapper .mat-icon,.mat-form-field-subscript-wrapper .mat-icon{width:1em;height:1em;font-size:inherit;vertical-align:baseline}.mat-form-field-hint-wrapper{display:flex}.mat-form-field-hint-spacer{flex:1 0 1em}.mat-error{display:block} .mat-form-field-appearance-fill .mat-form-field-flex{border-radius:4px 4px 0 0;padding:.75em .75em 0 .75em}.mat-form-field-appearance-fill .mat-form-field-underline::before{content:'';display:block;position:absolute;bottom:0;height:1px;width:100%}.mat-form-field-appearance-fill .mat-form-field-ripple{bottom:0;height:2px}.mat-form-field-appearance-fill:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-underline .mat-form-field-ripple{opacity:1;transform:none;transition:opacity .6s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-fill .mat-form-field-subscript-wrapper{padding:0 1em} .mat-form-field-appearance-legacy .mat-form-field-label{transform:perspective(100px);-ms-transform:none}.mat-form-field-appearance-legacy .mat-form-field-prefix .mat-icon,.mat-form-field-appearance-legacy .mat-form-field-suffix .mat-icon{width:1em}.mat-form-field-appearance-legacy .mat-form-field-prefix .mat-icon-button,.mat-form-field-appearance-legacy .mat-form-field-suffix .mat-icon-button{font:inherit;vertical-align:baseline}.mat-form-field-appearance-legacy .mat-form-field-prefix .mat-icon-button .mat-icon,.mat-form-field-appearance-legacy .mat-form-field-suffix .mat-icon-button .mat-icon{font-size:inherit}.mat-form-field-appearance-legacy .mat-form-field-underline{height:1px}.mat-form-field-appearance-legacy .mat-form-field-ripple{top:0;height:2px}.mat-form-field-appearance-legacy.mat-form-field-disabled .mat-form-field-underline{background-position:0;background-color:transparent}.mat-form-field-appearance-legacy.mat-form-field-invalid:not(.mat-focused) .mat-form-field-ripple{height:1px} .mat-form-field-appearance-outline .mat-form-field-wrapper{margin:.25em 0}.mat-form-field-appearance-outline .mat-form-field-flex{padding:0 .75em 0 .75em;margin-top:-.25em}.mat-form-field-appearance-outline .mat-form-field-prefix,.mat-form-field-appearance-outline .mat-form-field-suffix{top:.25em}.mat-form-field-appearance-outline .mat-form-field-outline{display:flex;position:absolute;top:0;left:0;right:0;pointer-events:none}.mat-form-field-appearance-outline .mat-form-field-outline-end,.mat-form-field-appearance-outline .mat-form-field-outline-start{border:1px solid currentColor;min-width:5px}.mat-form-field-appearance-outline .mat-form-field-outline-start{border-radius:5px 0 0 5px;border-right-style:none}[dir=rtl] .mat-form-field-appearance-outline .mat-form-field-outline-start{border-right-style:solid;border-left-style:none;border-radius:0 5px 5px 0}.mat-form-field-appearance-outline .mat-form-field-outline-end{border-radius:0 5px 5px 0;border-left-style:none;flex-grow:1}[dir=rtl] .mat-form-field-appearance-outline .mat-form-field-outline-end{border-left-style:solid;border-right-style:none;border-radius:5px 0 0 5px}.mat-form-field-appearance-outline .mat-form-field-outline-gap{border-radius:.000001px;border:1px solid currentColor;border-left-style:none;border-right-style:none}.mat-form-field-appearance-outline.mat-form-field-can-float.mat-form-field-should-float .mat-form-field-outline-gap{border-top-color:transparent}.mat-form-field-appearance-outline .mat-form-field-outline-thick{opacity:0}.mat-form-field-appearance-outline .mat-form-field-outline-thick .mat-form-field-outline-end,.mat-form-field-appearance-outline .mat-form-field-outline-thick .mat-form-field-outline-gap,.mat-form-field-appearance-outline .mat-form-field-outline-thick .mat-form-field-outline-start{border-width:2px;transition:border-color .3s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-outline.mat-focused .mat-form-field-outline,.mat-form-field-appearance-outline.mat-form-field-invalid .mat-form-field-outline{opacity:0;transition:opacity .1s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-outline.mat-focused .mat-form-field-outline-thick,.mat-form-field-appearance-outline.mat-form-field-invalid .mat-form-field-outline-thick{opacity:1}.mat-form-field-appearance-outline:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-outline{opacity:0;transition:opacity .6s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-outline:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-outline-thick{opacity:1}.mat-form-field-appearance-outline .mat-form-field-subscript-wrapper{padding:0 1em} .mat-form-field-appearance-standard .mat-form-field-flex{padding-top:.75em}.mat-form-field-appearance-standard .mat-form-field-underline{height:1px}.mat-form-field-appearance-standard .mat-form-field-ripple{bottom:0;height:2px}.mat-form-field-appearance-standard.mat-form-field-disabled .mat-form-field-underline{background-position:0;background-color:transparent}.mat-form-field-appearance-standard:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-underline .mat-form-field-ripple{opacity:1;transform:none;transition:opacity .6s cubic-bezier(.25,.8,.25,1)} .mat-input-element{font:inherit;background:0 0;color:currentColor;border:none;outline:0;padding:0;margin:0;width:100%;max-width:100%;vertical-align:bottom;text-align:inherit}.mat-input-element:-moz-ui-invalid{box-shadow:none}.mat-input-element::-ms-clear,.mat-input-element::-ms-reveal{display:none}.mat-input-element[type=date]::after,.mat-input-element[type=datetime-local]::after,.mat-input-element[type=datetime]::after,.mat-input-element[type=month]::after,.mat-input-element[type=time]::after,.mat-input-element[type=week]::after{content:' ';white-space:pre;width:1px}.mat-input-element::placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-input-element::-moz-placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-input-element::-webkit-input-placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-input-element:-ms-input-placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-form-field-hide-placeholder .mat-input-element::placeholder{color:transparent!important;transition:none}.mat-form-field-hide-placeholder .mat-input-element::-moz-placeholder{color:transparent!important;transition:none}.mat-form-field-hide-placeholder .mat-input-element::-webkit-input-placeholder{color:transparent!important;transition:none}.mat-form-field-hide-placeholder .mat-input-element:-ms-input-placeholder{color:transparent!important;transition:none}textarea.mat-input-element{resize:vertical;overflow:auto}textarea.mat-input-element.cdk-textarea-autosize{resize:none}textarea.mat-input-element{padding:2px 0;margin:-2px 0}"],animations:[b.transitionMessages],host:{class:"mat-form-field","[class.mat-form-field-appearance-standard]":'appearance == "standard"',"[class.mat-form-field-appearance-fill]":'appearance == "fill"',"[class.mat-form-field-appearance-outline]":'appearance == "outline"',"[class.mat-form-field-appearance-legacy]":'appearance == "legacy"',"[class.mat-form-field-invalid]":"_control.errorState","[class.mat-form-field-can-float]":"_canLabelFloat","[class.mat-form-field-should-float]":"_shouldLabelFloat()","[class.mat-form-field-hide-placeholder]":"_hideControlPlaceholder()","[class.mat-form-field-disabled]":"_control.disabled","[class.mat-form-field-autofilled]":"_control.autofilled","[class.mat-focused]":"_control.focused","[class.mat-accent]":'color == "accent"',"[class.mat-warn]":'color == "warn"',"[class.ng-untouched]":'_shouldForward("untouched")',"[class.ng-touched]":'_shouldForward("touched")',"[class.ng-pristine]":'_shouldForward("pristine")',"[class.ng-dirty]":'_shouldForward("dirty")',"[class.ng-valid]":'_shouldForward("valid")',"[class.ng-invalid]":'_shouldForward("invalid")',"[class.ng-pending]":'_shouldForward("pending")'},inputs:["color"],encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],a.ctorParameters=function(){return[{type:t.ElementRef},{type:t.ChangeDetectorRef},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[n.MAT_LABEL_GLOBAL_OPTIONS]}]},{type:i.Directionality,decorators:[{type:t.Optional}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[D]}]},{type:s.Platform}]},a.propDecorators={appearance:[{type:t.Input}],hideRequiredMarker:[{type:t.Input}],hintLabel:[{type:t.Input}],floatLabel:[{type:t.Input}],underlineRef:[{type:t.ViewChild,args:["underline"]}],_connectionContainerRef:[{type:t.ViewChild,args:["connectionContainer"]}],_inputContainerRef:[{type:t.ViewChild,args:["inputContainer"]}],_label:[{type:t.ViewChild,args:["label"]}],_control:[{type:t.ContentChild,args:[_]}],_placeholderChild:[{type:t.ContentChild,args:[x]}],_labelChild:[{type:t.ContentChild,args:[w]}],_errorChildren:[{type:t.ContentChildren,args:[g]}],_hintChildren:[{type:t.ContentChildren,args:[v]}],_prefixChildren:[{type:t.ContentChildren,args:[C]}],_suffixChildren:[{type:t.ContentChildren,args:[k]}]},a}(M),I=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{declarations:[g,O,v,w,x,C,k],imports:[f.CommonModule],exports:[g,O,v,w,x,C,k]}]}],e}();e.MatFormFieldModule=I,e.MatError=g,e.MatFormFieldBase=L,e._MatFormFieldMixinBase=M,e.MAT_FORM_FIELD_DEFAULT_OPTIONS=D,e.MatFormField=O,e.MatFormFieldControl=_,e.getMatFormFieldPlaceholderConflictError=c,e.getMatFormFieldDuplicatedHintError=m,e.getMatFormFieldMissingControlError=p,e.MatHint=v,e.MatPlaceholder=x,e.MatPrefix=C,e.MatSuffix=k,e.MatLabel=w,e.matFormFieldAnimations=b,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-form-field.umd.min.js.map
