/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/common"),require("@angular/common/http"),require("@angular/core"),require("@angular/platform-browser"),require("rxjs"),require("rxjs/operators"),require("@angular/material/core"),require("@angular/cdk/coercion")):"function"==typeof define&&define.amd?define("@angular/material/icon",["exports","@angular/common","@angular/common/http","@angular/core","@angular/platform-browser","rxjs","rxjs/operators","@angular/material/core","@angular/cdk/coercion"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.icon={}),t.ng.common,t.ng.common.http,t.ng.core,t.ng.platformBrowser,t.Rx,t.Rx.operators,t.ng.material.core,t.ng.cdk.coercion)}(this,function(t,e,n,o,r,i,s,a,c){"use strict";function u(t,e){function n(){this.constructor=t}v(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)}function l(t){return Error('Unable to find icon with the name "'+t+'"')}function p(){return Error("Could not find HttpClient provider for use with Angular Material icons. Please include the HttpClientModule from @angular/common/http in your app imports.")}function f(t){return Error("The URL provided to MatIconRegistry was not trusted as a resource URL via Angular's DomSanitizer. Attempted URL was \""+t+'".')}function g(t){return Error("The literal provided to MatIconRegistry was not trusted as safe HTML by Angular's DomSanitizer. Attempted literal was \""+t+'".')}function m(t,e,n,o){return t||new S(e,n,o)}function h(t){return t.cloneNode(!0)}function d(t,e){return t+":"+e}var v=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])},_=function(){function t(t){t.nodeName?this.svgElement=t:this.url=t}return t}(),S=function(){function t(t,e,n){this._httpClient=t,this._sanitizer=e,this._svgIconConfigs=new Map,this._iconSetConfigs=new Map,this._cachedIconsByUrl=new Map,this._inProgressUrlFetches=new Map,this._fontCssClassesByAlias=new Map,this._defaultFontSetClass="material-icons",this._document=n}return t.prototype.addSvgIcon=function(t,e){return this.addSvgIconInNamespace("",t,e)},t.prototype.addSvgIconLiteral=function(t,e){return this.addSvgIconLiteralInNamespace("",t,e)},t.prototype.addSvgIconInNamespace=function(t,e,n){return this._addSvgIconConfig(t,e,new _(n))},t.prototype.addSvgIconLiteralInNamespace=function(t,e,n){var r=this._sanitizer.sanitize(o.SecurityContext.HTML,n);if(!r)throw g(n);var i=this._createSvgElementForSingleIcon(r);return this._addSvgIconConfig(t,e,new _(i))},t.prototype.addSvgIconSet=function(t){return this.addSvgIconSetInNamespace("",t)},t.prototype.addSvgIconSetLiteral=function(t){return this.addSvgIconSetLiteralInNamespace("",t)},t.prototype.addSvgIconSetInNamespace=function(t,e){return this._addSvgIconSetConfig(t,new _(e))},t.prototype.addSvgIconSetLiteralInNamespace=function(t,e){var n=this._sanitizer.sanitize(o.SecurityContext.HTML,e);if(!n)throw g(e);var r=this._svgElementFromString(n);return this._addSvgIconSetConfig(t,new _(r))},t.prototype.registerFontClassAlias=function(t,e){return void 0===e&&(e=t),this._fontCssClassesByAlias.set(t,e),this},t.prototype.classNameForFontAlias=function(t){return this._fontCssClassesByAlias.get(t)||t},t.prototype.setDefaultFontSetClass=function(t){return this._defaultFontSetClass=t,this},t.prototype.getDefaultFontSetClass=function(){return this._defaultFontSetClass},t.prototype.getSvgIconFromUrl=function(t){var e=this,n=this._sanitizer.sanitize(o.SecurityContext.RESOURCE_URL,t);if(!n)throw f(t);var r=this._cachedIconsByUrl.get(n);return r?i.of(h(r)):this._loadSvgIconFromConfig(new _(t)).pipe(s.tap(function(t){return e._cachedIconsByUrl.set(n,t)}),s.map(function(t){return h(t)}))},t.prototype.getNamedSvgIcon=function(t,e){void 0===e&&(e="");var n=d(e,t),o=this._svgIconConfigs.get(n);if(o)return this._getSvgFromConfig(o);var r=this._iconSetConfigs.get(e);return r?this._getSvgFromIconSetConfigs(t,r):i.throwError(l(n))},t.prototype._getSvgFromConfig=function(t){return t.svgElement?i.of(h(t.svgElement)):this._loadSvgIconFromConfig(t).pipe(s.tap(function(e){return t.svgElement=e}),s.map(function(t){return h(t)}))},t.prototype._getSvgFromIconSetConfigs=function(t,e){var n=this,r=this._extractIconWithNameFromAnySet(t,e);if(r)return i.of(r);var a=e.filter(function(t){return!t.svgElement}).map(function(t){return n._loadSvgIconSetFromConfig(t).pipe(s.catchError(function(e){var r=n._sanitizer.sanitize(o.SecurityContext.RESOURCE_URL,t.url);return console.error("Loading icon set URL: "+r+" failed: "+e.message),i.of(null)}))});return i.forkJoin(a).pipe(s.map(function(){var o=n._extractIconWithNameFromAnySet(t,e);if(!o)throw l(t);return o}))},t.prototype._extractIconWithNameFromAnySet=function(t,e){for(var n=e.length-1;n>=0;n--){var o=e[n];if(o.svgElement){var r=this._extractSvgIconFromSet(o.svgElement,t);if(r)return r}}return null},t.prototype._loadSvgIconFromConfig=function(t){var e=this;return this._fetchUrl(t.url).pipe(s.map(function(t){return e._createSvgElementForSingleIcon(t)}))},t.prototype._loadSvgIconSetFromConfig=function(t){var e=this;return t.svgElement?i.of(t.svgElement):this._fetchUrl(t.url).pipe(s.map(function(n){return t.svgElement||(t.svgElement=e._svgElementFromString(n)),t.svgElement}))},t.prototype._createSvgElementForSingleIcon=function(t){var e=this._svgElementFromString(t);return this._setSvgAttributes(e),e},t.prototype._extractSvgIconFromSet=function(t,e){var n=t.querySelector("#"+e);if(!n)return null;var o=n.cloneNode(!0);if(o.removeAttribute("id"),"svg"===o.nodeName.toLowerCase())return this._setSvgAttributes(o);if("symbol"===o.nodeName.toLowerCase())return this._setSvgAttributes(this._toSvgElement(o));var r=this._svgElementFromString("<svg></svg>");return r.appendChild(o),this._setSvgAttributes(r)},t.prototype._svgElementFromString=function(t){var e=this._document.createElement("DIV");e.innerHTML=t;var n=e.querySelector("svg");if(!n)throw Error("<svg> tag not found");return n},t.prototype._toSvgElement=function(t){for(var e=this._svgElementFromString("<svg></svg>"),n=0;n<t.childNodes.length;n++)t.childNodes[n].nodeType===this._document.ELEMENT_NODE&&e.appendChild(t.childNodes[n].cloneNode(!0));return e},t.prototype._setSvgAttributes=function(t){return t.setAttribute("fit",""),t.setAttribute("height","100%"),t.setAttribute("width","100%"),t.setAttribute("preserveAspectRatio","xMidYMid meet"),t.setAttribute("focusable","false"),t},t.prototype._fetchUrl=function(t){var e=this;if(!this._httpClient)throw p();if(null==t)throw Error('Cannot fetch icon from URL "'+t+'".');var n=this._sanitizer.sanitize(o.SecurityContext.RESOURCE_URL,t);if(!n)throw f(t);var r=this._inProgressUrlFetches.get(n);if(r)return r;var i=this._httpClient.get(n,{responseType:"text"}).pipe(s.finalize(function(){return e._inProgressUrlFetches.delete(n)}),s.share());return this._inProgressUrlFetches.set(n,i),i},t.prototype._addSvgIconConfig=function(t,e,n){return this._svgIconConfigs.set(d(t,e),n),this},t.prototype._addSvgIconSetConfig=function(t,e){var n=this._iconSetConfigs.get(t);return n?n.push(e):this._iconSetConfigs.set(t,[e]),this},t.decorators=[{type:o.Injectable,args:[{providedIn:"root"}]}],t.ctorParameters=function(){return[{type:n.HttpClient,decorators:[{type:o.Optional}]},{type:r.DomSanitizer},{type:void 0,decorators:[{type:o.Optional},{type:o.Inject,args:[e.DOCUMENT]}]}]},t.ngInjectableDef=o.defineInjectable({factory:function(){return new t(o.inject(n.HttpClient,8),o.inject(r.DomSanitizer),o.inject(e.DOCUMENT,8))},token:t,providedIn:"root"}),t}(),y={provide:S,deps:[[new o.Optional,new o.SkipSelf,S],[new o.Optional,n.HttpClient],r.DomSanitizer,[new o.Optional,e.DOCUMENT]],useFactory:m},I=function(){function t(t){this._elementRef=t}return t}(),C=a.mixinColor(I),E=function(t){function e(e,n,o){var r=t.call(this,e)||this;return r._iconRegistry=n,r._inline=!1,o||e.nativeElement.setAttribute("aria-hidden","true"),r}return u(e,t),Object.defineProperty(e.prototype,"inline",{get:function(){return this._inline},set:function(t){this._inline=c.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fontSet",{get:function(){return this._fontSet},set:function(t){this._fontSet=this._cleanupFontValue(t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"fontIcon",{get:function(){return this._fontIcon},set:function(t){this._fontIcon=this._cleanupFontValue(t)},enumerable:!0,configurable:!0}),e.prototype._splitIconName=function(t){if(!t)return["",""];var e=t.split(":");switch(e.length){case 1:return["",e[0]];case 2:return e;default:throw Error('Invalid icon name: "'+t+'"')}},e.prototype.ngOnChanges=function(t){var e=this;if(t.svgIcon)if(this.svgIcon){var n=this._splitIconName(this.svgIcon),o=n[0],r=n[1];this._iconRegistry.getNamedSvgIcon(r,o).pipe(s.take(1)).subscribe(function(t){return e._setSvgElement(t)},function(t){return console.log("Error retrieving icon: "+t.message)})}else this._clearSvgElement();this._usingFontIcon()&&this._updateFontIconClasses()},e.prototype.ngOnInit=function(){this._usingFontIcon()&&this._updateFontIconClasses()},e.prototype._usingFontIcon=function(){return!this.svgIcon},e.prototype._setSvgElement=function(t){this._clearSvgElement(),this._elementRef.nativeElement.appendChild(t)},e.prototype._clearSvgElement=function(){for(var t=this._elementRef.nativeElement,e=t.childNodes.length,n=0;n<e;n++)t.removeChild(t.childNodes[n])},e.prototype._updateFontIconClasses=function(){if(this._usingFontIcon()){var t=this._elementRef.nativeElement,e=this.fontSet?this._iconRegistry.classNameForFontAlias(this.fontSet):this._iconRegistry.getDefaultFontSetClass();e!=this._previousFontSetClass&&(this._previousFontSetClass&&t.classList.remove(this._previousFontSetClass),e&&t.classList.add(e),this._previousFontSetClass=e),this.fontIcon!=this._previousFontIconClass&&(this._previousFontIconClass&&t.classList.remove(this._previousFontIconClass),this.fontIcon&&t.classList.add(this.fontIcon),this._previousFontIconClass=this.fontIcon)}},e.prototype._cleanupFontValue=function(t){return"string"==typeof t?t.trim().split(" ")[0]:t},e.decorators=[{type:o.Component,args:[{template:"<ng-content></ng-content>",selector:"mat-icon",exportAs:"matIcon",styles:[".mat-icon{background-repeat:no-repeat;display:inline-block;fill:currentColor;height:24px;width:24px}.mat-icon.mat-icon-inline{font-size:inherit;height:inherit;line-height:inherit;width:inherit}[dir=rtl] .mat-icon-rtl-mirror{transform:scale(-1,1)}.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-prefix .mat-icon,.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-suffix .mat-icon{display:block}.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-prefix .mat-icon-button .mat-icon,.mat-form-field:not(.mat-form-field-appearance-legacy) .mat-form-field-suffix .mat-icon-button .mat-icon{margin:auto}"],inputs:["color"],host:{role:"img",class:"mat-icon","[class.mat-icon-inline]":"inline"},encapsulation:o.ViewEncapsulation.None,changeDetection:o.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:o.ElementRef},{type:S},{type:void 0,decorators:[{type:o.Attribute,args:["aria-hidden"]}]}]},e.propDecorators={inline:[{type:o.Input}],svgIcon:[{type:o.Input}],fontSet:[{type:o.Input}],fontIcon:[{type:o.Input}]},e}(C),F=function(){function t(){}return t.decorators=[{type:o.NgModule,args:[{imports:[a.MatCommonModule],exports:[E,a.MatCommonModule],declarations:[E]}]}],t}();t.MatIconModule=F,t.MatIconBase=I,t._MatIconMixinBase=C,t.MatIcon=E,t.getMatIconNameNotFoundError=l,t.getMatIconNoHttpProviderError=p,t.getMatIconFailedToSanitizeUrlError=f,t.getMatIconFailedToSanitizeLiteralError=g,t.MatIconRegistry=S,t.ICON_REGISTRY_PROVIDER_FACTORY=m,t.ICON_REGISTRY_PROVIDER=y,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-icon.umd.min.js.map
