/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/cdk/portal"),require("@angular/common"),require("@angular/animations"),require("@angular/cdk/a11y"),require("@angular/material/core"),require("rxjs"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("rxjs/operators"),require("@angular/cdk/bidi"),require("@angular/cdk/overlay")):"function"==typeof define&&define.amd?define("@angular/material/menu",["exports","@angular/core","@angular/cdk/portal","@angular/common","@angular/animations","@angular/cdk/a11y","@angular/material/core","rxjs","@angular/cdk/coercion","@angular/cdk/keycodes","rxjs/operators","@angular/cdk/bidi","@angular/cdk/overlay"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.menu={}),e.ng.core,e.ng.cdk.portal,e.ng.common,e.ng.animations,e.ng.cdk.a11y,e.ng.material.core,e.Rx,e.ng.cdk.coercion,e.ng.cdk.keycodes,e.Rx.operators,e.ng.cdk.bidi,e.ng.cdk.overlay)}(this,function(e,t,n,i,o,r,s,a,u,p,c,l,m){"use strict";function h(e,t){function n(){this.constructor=e}b(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}function d(){throw Error('mat-menu-trigger: must pass in an mat-menu instance.\n\n    Example:\n      <mat-menu #menu="matMenu"></mat-menu>\n      <button [matMenuTriggerFor]="menu"></button>')}function g(){throw Error('x-position value must be either \'before\' or after\'.\n      Example: <mat-menu x-position="before" #menu="matMenu"></mat-menu>')}function f(){throw Error('y-position value must be either \'above\' or below\'.\n      Example: <mat-menu y-position="above" #menu="matMenu"></mat-menu>')}function _(){return{overlapTrigger:!0,xPosition:"after",yPosition:"below",backdropClass:"cdk-overlay-transparent-backdrop"}}function y(e){return function(){return e.scrollStrategies.reposition()}}var b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])},v=function(){function e(e,t,n,i,o,r){this._template=e,this._componentFactoryResolver=t,this._appRef=n,this._injector=i,this._viewContainerRef=o,this._document=r}return e.prototype.attach=function(e){void 0===e&&(e={}),this._portal||(this._portal=new n.TemplatePortal(this._template,this._viewContainerRef)),this.detach(),this._outlet||(this._outlet=new n.DomPortalOutlet(this._document.createElement("div"),this._componentFactoryResolver,this._appRef,this._injector));var t=this._template.elementRef.nativeElement;t.parentNode.insertBefore(this._outlet.outletElement,t),this._portal.attach(this._outlet,e)},e.prototype.detach=function(){this._portal.isAttached&&this._portal.detach()},e.prototype.ngOnDestroy=function(){this._outlet&&this._outlet.dispose()},e.decorators=[{type:t.Directive,args:[{selector:"ng-template[matMenuContent]"}]}],e.ctorParameters=function(){return[{type:t.TemplateRef},{type:t.ComponentFactoryResolver},{type:t.ApplicationRef},{type:t.Injector},{type:t.ViewContainerRef},{type:void 0,decorators:[{type:t.Inject,args:[i.DOCUMENT]}]}]},e}(),M={transformMenu:o.trigger("transformMenu",[o.state("void",o.style({opacity:0,transform:"scale(0.01, 0.01)"})),o.transition("void => enter",o.sequence([o.query(".mat-menu-content",o.style({opacity:0})),o.animate("100ms linear",o.style({opacity:1,transform:"scale(1, 0.5)"})),o.group([o.query(".mat-menu-content",o.animate("400ms cubic-bezier(0.55, 0, 0.55, 0.2)",o.style({opacity:1}))),o.animate("300ms cubic-bezier(0.25, 0.8, 0.25, 1)",o.style({transform:"scale(1, 1)"}))])])),o.transition("* => void",o.animate("150ms 50ms linear",o.style({opacity:0})))]),fadeInItems:o.trigger("fadeInItems",[o.state("showing",o.style({opacity:1})),o.transition("void => *",[o.style({opacity:0}),o.animate("400ms 100ms cubic-bezier(0.55, 0, 0.55, 0.2)")])])},O=M.fadeInItems,k=M.transformMenu,x=new t.InjectionToken("MAT_MENU_PANEL"),C=function(){function e(){}return e}(),w=s.mixinDisableRipple(s.mixinDisabled(C)),I=function(e){function n(t,n,i,o){var r=e.call(this)||this;return r._elementRef=t,r._focusMonitor=i,r._parentMenu=o,r._hovered=new a.Subject,r._highlighted=!1,r._triggersSubmenu=!1,i&&i.monitor(r._getHostElement(),!1),o&&o.addItem&&o.addItem(r),r._document=n,r}return h(n,e),n.prototype.focus=function(e){void 0===e&&(e="program"),this._focusMonitor?this._focusMonitor.focusVia(this._getHostElement(),e):this._getHostElement().focus()},n.prototype.ngOnDestroy=function(){this._focusMonitor&&this._focusMonitor.stopMonitoring(this._getHostElement()),this._parentMenu&&this._parentMenu.removeItem&&this._parentMenu.removeItem(this),this._hovered.complete()},n.prototype._getTabIndex=function(){return this.disabled?"-1":"0"},n.prototype._getHostElement=function(){return this._elementRef.nativeElement},n.prototype._checkDisabled=function(e){this.disabled&&(e.preventDefault(),e.stopPropagation())},n.prototype._handleMouseEnter=function(){this._hovered.next(this)},n.prototype.getLabel=function(){var e=this._elementRef.nativeElement,t=this._document?this._document.TEXT_NODE:3,n="";if(e.childNodes)for(var i=e.childNodes.length,o=0;o<i;o++)e.childNodes[o].nodeType===t&&(n+=e.childNodes[o].textContent);return n.trim()},n.decorators=[{type:t.Component,args:[{selector:"[mat-menu-item]",exportAs:"matMenuItem",inputs:["disabled","disableRipple"],host:{role:"menuitem",class:"mat-menu-item","[class.mat-menu-item-highlighted]":"_highlighted","[class.mat-menu-item-submenu-trigger]":"_triggersSubmenu","[attr.tabindex]":"_getTabIndex()","[attr.aria-disabled]":"disabled.toString()","[attr.disabled]":"disabled || null","(click)":"_checkDisabled($event)","(mouseenter)":"_handleMouseEnter()"},changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None,template:'<ng-content></ng-content><div class="mat-menu-ripple" matRipple [matRippleDisabled]="disableRipple || disabled" [matRippleTrigger]="_getHostElement()"></div>'}]}],n.ctorParameters=function(){return[{type:t.ElementRef},{type:void 0,decorators:[{type:t.Inject,args:[i.DOCUMENT]}]},{type:r.FocusMonitor},{type:void 0,decorators:[{type:t.Inject,args:[x]},{type:t.Optional}]}]},n}(w),R=new t.InjectionToken("mat-menu-default-options",{providedIn:"root",factory:_}),E=function(){function e(e,n,i){this._elementRef=e,this._ngZone=n,this._defaultOptions=i,this._xPosition=this._defaultOptions.xPosition,this._yPosition=this._defaultOptions.yPosition,this._items=[],this._itemChanges=new a.Subject,this._tabSubscription=a.Subscription.EMPTY,this._classList={},this._panelAnimationState="void",this._animationDone=new a.Subject,this.backdropClass=this._defaultOptions.backdropClass,this._overlapTrigger=this._defaultOptions.overlapTrigger,this._hasBackdrop=this._defaultOptions.hasBackdrop,this.closed=new t.EventEmitter,this.close=this.closed}return Object.defineProperty(e.prototype,"xPosition",{get:function(){return this._xPosition},set:function(e){"before"!==e&&"after"!==e&&g(),this._xPosition=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"yPosition",{get:function(){return this._yPosition},set:function(e){"above"!==e&&"below"!==e&&f(),this._yPosition=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"overlapTrigger",{get:function(){return this._overlapTrigger},set:function(e){this._overlapTrigger=u.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hasBackdrop",{get:function(){return this._hasBackdrop},set:function(e){this._hasBackdrop=u.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"panelClass",{set:function(e){e&&e.length&&(this._classList=e.split(" ").reduce(function(e,t){return e[t]=!0,e},{}),this._elementRef.nativeElement.className="")},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"classList",{get:function(){return this.panelClass},set:function(e){this.panelClass=e},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this._keyManager=new r.FocusKeyManager(this._items).withWrap().withTypeAhead(),this._tabSubscription=this._keyManager.tabOut.subscribe(function(){return e.close.emit("tab")})},e.prototype.ngOnDestroy=function(){this._tabSubscription.unsubscribe(),this.closed.complete()},e.prototype._hovered=function(){return this._itemChanges.pipe(c.startWith(this._items),c.switchMap(function(e){return a.merge.apply(void 0,e.map(function(e){return e._hovered}))}))},e.prototype._handleKeydown=function(e){var t=e.keyCode;switch(t){case p.ESCAPE:this.closed.emit("keydown"),e.stopPropagation();break;case p.LEFT_ARROW:this.parentMenu&&"ltr"===this.direction&&this.closed.emit("keydown");break;case p.RIGHT_ARROW:this.parentMenu&&"rtl"===this.direction&&this.closed.emit("keydown");break;default:t!==p.UP_ARROW&&t!==p.DOWN_ARROW||this._keyManager.setFocusOrigin("keyboard"),this._keyManager.onKeydown(e)}},e.prototype.focusFirstItem=function(e){var t=this;void 0===e&&(e="program"),this.lazyContent?this._ngZone.onStable.asObservable().pipe(c.take(1)).subscribe(function(){return t._keyManager.setFocusOrigin(e).setFirstItemActive()}):this._keyManager.setFocusOrigin(e).setFirstItemActive()},e.prototype.resetActiveItem=function(){this._keyManager.setActiveItem(-1)},e.prototype.setElevation=function(e){var t="mat-elevation-z"+(2+e),n=Object.keys(this._classList).find(function(e){return e.startsWith("mat-elevation-z")});n&&n!==this._previousElevation||(this._previousElevation&&(this._classList[this._previousElevation]=!1),this._classList[t]=!0,this._previousElevation=t)},e.prototype.addItem=function(e){-1===this._items.indexOf(e)&&(this._items.push(e),this._itemChanges.next(this._items))},e.prototype.removeItem=function(e){var t=this._items.indexOf(e);this._items.indexOf(e)>-1&&(this._items.splice(t,1),this._itemChanges.next(this._items))},e.prototype._startAnimation=function(){this._panelAnimationState="enter"},e.prototype._resetAnimation=function(){this._panelAnimationState="void"},e.prototype._onAnimationDone=function(e){this._animationDone.next(e),this._isAnimating=!1},e.decorators=[{type:t.Component,args:[{selector:"mat-menu",template:'<ng-template><div class="mat-menu-panel" [ngClass]="_classList" (keydown)="_handleKeydown($event)" (click)="closed.emit(\'click\')" [@transformMenu]="_panelAnimationState" (@transformMenu.start)="_isAnimating = true" (@transformMenu.done)="_onAnimationDone($event)" tabindex="-1" role="menu"><div class="mat-menu-content"><ng-content></ng-content></div></div></ng-template>',styles:[".mat-menu-panel{min-width:112px;max-width:280px;overflow:auto;-webkit-overflow-scrolling:touch;max-height:calc(100vh - 48px);border-radius:2px;outline:0}.mat-menu-panel:not([class*=mat-elevation-z]){box-shadow:0 3px 1px -2px rgba(0,0,0,.2),0 2px 2px 0 rgba(0,0,0,.14),0 1px 5px 0 rgba(0,0,0,.12)}@media screen and (-ms-high-contrast:active){.mat-menu-panel{outline:solid 1px}}.mat-menu-content{padding-top:8px;padding-bottom:8px}.mat-menu-item{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;cursor:pointer;outline:0;border:none;-webkit-tap-highlight-color:transparent;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;display:block;line-height:48px;height:48px;padding:0 16px;text-align:left;text-decoration:none;position:relative}.mat-menu-item[disabled]{cursor:default}[dir=rtl] .mat-menu-item{text-align:right}.mat-menu-item .mat-icon{margin-right:16px;vertical-align:middle}.mat-menu-item .mat-icon svg{vertical-align:top}[dir=rtl] .mat-menu-item .mat-icon{margin-left:16px;margin-right:0}.mat-menu-item-submenu-trigger{padding-right:32px}.mat-menu-item-submenu-trigger::after{width:0;height:0;border-style:solid;border-width:5px 0 5px 5px;border-color:transparent transparent transparent currentColor;content:'';display:inline-block;position:absolute;top:50%;right:16px;transform:translateY(-50%)}[dir=rtl] .mat-menu-item-submenu-trigger{padding-right:16px;padding-left:32px}[dir=rtl] .mat-menu-item-submenu-trigger::after{right:auto;left:16px;transform:rotateY(180deg) translateY(-50%)}.mat-menu-panel.ng-animating .mat-menu-item-submenu-trigger{pointer-events:none}button.mat-menu-item{width:100%}.mat-menu-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}"],changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None,exportAs:"matMenu",animations:[M.transformMenu,M.fadeInItems],providers:[{provide:x,useExisting:e}]}]}],e.ctorParameters=function(){return[{type:t.ElementRef},{type:t.NgZone},{type:void 0,decorators:[{type:t.Inject,args:[R]}]}]},e.propDecorators={backdropClass:[{type:t.Input}],xPosition:[{type:t.Input}],yPosition:[{type:t.Input}],templateRef:[{type:t.ViewChild,args:[t.TemplateRef]}],items:[{type:t.ContentChildren,args:[I]}],lazyContent:[{type:t.ContentChild,args:[v]}],overlapTrigger:[{type:t.Input}],hasBackdrop:[{type:t.Input}],panelClass:[{type:t.Input,args:["class"]}],classList:[{type:t.Input}],closed:[{type:t.Output}],close:[{type:t.Output}]},e}(),P=new t.InjectionToken("mat-menu-scroll-strategy"),S={provide:P,deps:[m.Overlay],useFactory:y},T=function(){function e(e,n,i,o,r,s,u,p){this._overlay=e,this._element=n,this._viewContainerRef=i,this._scrollStrategy=o,this._parentMenu=r,this._menuItemInstance=s,this._dir=u,this._focusMonitor=p,this._overlayRef=null,this._menuOpen=!1,this._closeSubscription=a.Subscription.EMPTY,this._hoverSubscription=a.Subscription.EMPTY,this._openedByMouse=!1,this.menuOpened=new t.EventEmitter,this.onMenuOpen=this.menuOpened,this.menuClosed=new t.EventEmitter,this.onMenuClose=this.menuClosed,s&&(s._triggersSubmenu=this.triggersSubmenu())}return Object.defineProperty(e.prototype,"_deprecatedMatMenuTriggerFor",{get:function(){return this.menu},set:function(e){this.menu=e},enumerable:!0,configurable:!0}),e.prototype.ngAfterContentInit=function(){var e=this;this._checkMenu(),this.menu.close.subscribe(function(t){e._destroyMenu(),"click"!==t&&"tab"!==t||!e._parentMenu||e._parentMenu.closed.emit(t)}),this._handleHover()},e.prototype.ngOnDestroy=function(){this._overlayRef&&(this._overlayRef.dispose(),this._overlayRef=null),this._cleanUpSubscriptions()},Object.defineProperty(e.prototype,"menuOpen",{get:function(){return this._menuOpen},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"dir",{get:function(){return this._dir&&"rtl"===this._dir.value?"rtl":"ltr"},enumerable:!0,configurable:!0}),e.prototype.triggersSubmenu=function(){return!(!this._menuItemInstance||!this._parentMenu)},e.prototype.toggleMenu=function(){return this._menuOpen?this.closeMenu():this.openMenu()},e.prototype.openMenu=function(){var e=this;if(!this._menuOpen){var t=this._createOverlay();t.setDirection(this.dir),t.attach(this._portal),this.menu.lazyContent&&this.menu.lazyContent.attach(this.menuData),this._closeSubscription=this._menuClosingActions().subscribe(function(){return e.closeMenu()}),this._initMenu(),this.menu instanceof E&&this.menu._startAnimation()}},e.prototype.closeMenu=function(){this.menu.close.emit()},e.prototype.focus=function(e){void 0===e&&(e="program"),this._focusMonitor?this._focusMonitor.focusVia(this._element.nativeElement,e):this._element.nativeElement.focus()},e.prototype._destroyMenu=function(){if(this._overlayRef&&this.menuOpen){var e=this.menu;this._resetMenu(),this._closeSubscription.unsubscribe(),this._overlayRef.detach(),e instanceof E?(e._resetAnimation(),e.lazyContent&&e._animationDone.pipe(c.take(1)).subscribe(function(){return e.lazyContent.detach()})):e.lazyContent&&e.lazyContent.detach()}},e.prototype._initMenu=function(){this.menu.parentMenu=this.triggersSubmenu()?this._parentMenu:void 0,this.menu.direction=this.dir,this._setMenuElevation(),this._setIsMenuOpen(!0),this.menu.focusFirstItem(this._openedByMouse?"mouse":"program")},e.prototype._setMenuElevation=function(){if(this.menu.setElevation){for(var e=0,t=this.menu.parentMenu;t;)e++,t=t.parentMenu;this.menu.setElevation(e)}},e.prototype._resetMenu=function(){this._setIsMenuOpen(!1),this._openedByMouse?this.triggersSubmenu()||this.focus("mouse"):this.focus(),this._openedByMouse=!1},e.prototype._setIsMenuOpen=function(e){this._menuOpen=e,this._menuOpen?this.menuOpened.emit():this.menuClosed.emit(),this.triggersSubmenu()&&(this._menuItemInstance._highlighted=e)},e.prototype._checkMenu=function(){this.menu||d()},e.prototype._createOverlay=function(){if(!this._overlayRef){this._portal=new n.TemplatePortal(this.menu.templateRef,this._viewContainerRef);var e=this._getOverlayConfig();this._subscribeToPositions(e.positionStrategy),this._overlayRef=this._overlay.create(e)}return this._overlayRef},e.prototype._getOverlayConfig=function(){return new m.OverlayConfig({positionStrategy:this._getPosition(),hasBackdrop:null==this.menu.hasBackdrop?!this.triggersSubmenu():this.menu.hasBackdrop,backdropClass:this.menu.backdropClass||"cdk-overlay-transparent-backdrop",scrollStrategy:this._scrollStrategy()})},e.prototype._subscribeToPositions=function(e){var t=this;this.menu.setPositionClasses&&e.positionChanges.subscribe(function(e){var n="start"===e.connectionPair.overlayX?"after":"before",i="top"===e.connectionPair.overlayY?"below":"above";t.menu.setPositionClasses(n,i)})},e.prototype._getPosition=function(){var e="before"===this.menu.xPosition?["end","start"]:["start","end"],t=e[0],n=e[1],i="above"===this.menu.yPosition?["bottom","top"]:["top","bottom"],o=i[0],r=i[1],s=[o,r],a=s[0],u=s[1],p=[t,n],c=p[0],l=p[1],m=0;return this.triggersSubmenu()?(l=t="before"===this.menu.xPosition?"start":"end",n=c="end"===t?"start":"end",m="bottom"===o?8:-8):this.menu.overlapTrigger||(a="top"===o?"bottom":"top",u="top"===r?"bottom":"top"),this._overlay.position().flexibleConnectedTo(this._element).withTransformOriginOn(".mat-menu-panel").withPositions([{originX:t,originY:a,overlayX:c,overlayY:o,offsetY:m},{originX:n,originY:a,overlayX:l,overlayY:o,offsetY:m},{originX:t,originY:u,overlayX:c,overlayY:r,offsetY:-m},{originX:n,originY:u,overlayX:l,overlayY:r,offsetY:-m}])},e.prototype._cleanUpSubscriptions=function(){this._closeSubscription.unsubscribe(),this._hoverSubscription.unsubscribe()},e.prototype._menuClosingActions=function(){var e=this,t=this._overlayRef.backdropClick(),n=this._overlayRef.detachments(),i=this._parentMenu?this._parentMenu.close:a.of(),o=this._parentMenu?this._parentMenu._hovered().pipe(c.filter(function(t){return t!==e._menuItemInstance}),c.filter(function(){return e._menuOpen})):a.of();return a.merge(t,i,o,n)},e.prototype._handleMousedown=function(e){r.isFakeMousedownFromScreenReader(e)||(this._openedByMouse=!0,this.triggersSubmenu()&&e.preventDefault())},e.prototype._handleKeydown=function(e){var t=e.keyCode;this.triggersSubmenu()&&(t===p.RIGHT_ARROW&&"ltr"===this.dir||t===p.LEFT_ARROW&&"rtl"===this.dir)&&this.openMenu()},e.prototype._handleClick=function(e){this.triggersSubmenu()?(e.stopPropagation(),this.openMenu()):this.toggleMenu()},e.prototype._handleHover=function(){var e=this;this.triggersSubmenu()&&(this._hoverSubscription=this._parentMenu._hovered().pipe(c.filter(function(t){return t===e._menuItemInstance&&!t.disabled}),c.delay(0,a.asapScheduler)).subscribe(function(){e._openedByMouse=!0,e.menu instanceof E&&e.menu._isAnimating?e.menu._animationDone.pipe(c.take(1),c.takeUntil(e._parentMenu._hovered())).subscribe(function(){return e.openMenu()}):e.openMenu()}))},e.decorators=[{type:t.Directive,args:[{selector:"[mat-menu-trigger-for], [matMenuTriggerFor]",host:{"aria-haspopup":"true","(mousedown)":"_handleMousedown($event)","(keydown)":"_handleKeydown($event)","(click)":"_handleClick($event)"},exportAs:"matMenuTrigger"}]}],e.ctorParameters=function(){return[{type:m.Overlay},{type:t.ElementRef},{type:t.ViewContainerRef},{type:void 0,decorators:[{type:t.Inject,args:[P]}]},{type:E,decorators:[{type:t.Optional}]},{type:I,decorators:[{type:t.Optional},{type:t.Self}]},{type:l.Directionality,decorators:[{type:t.Optional}]},{type:r.FocusMonitor}]},e.propDecorators={_deprecatedMatMenuTriggerFor:[{type:t.Input,args:["mat-menu-trigger-for"]}],menu:[{type:t.Input,args:["matMenuTriggerFor"]}],menuData:[{type:t.Input,args:["matMenuTriggerData"]}],menuOpened:[{type:t.Output}],onMenuOpen:[{type:t.Output}],menuClosed:[{type:t.Output}],onMenuClose:[{type:t.Output}]},e}(),A=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[i.CommonModule,s.MatCommonModule,s.MatRippleModule,m.OverlayModule],exports:[E,I,T,v,s.MatCommonModule],declarations:[E,I,T,v],providers:[S]}]}],e}();e.MAT_MENU_SCROLL_STRATEGY=P,e.MatMenuModule=A,e.MatMenu=E,e.MAT_MENU_DEFAULT_OPTIONS=R,e.MatMenuItem=I,e.MatMenuTrigger=T,e.matMenuAnimations=M,e.fadeInItems=O,e.transformMenu=k,e.MatMenuContent=v,e.ɵa24=_,e.ɵb24=C,e.ɵc24=w,e.ɵf24=x,e.ɵd24=y,e.ɵe24=S,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-menu.umd.min.js.map
