/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/cdk/platform"),require("@angular/core"),require("@angular/forms"),require("@angular/material/core"),require("@angular/cdk/observers"),require("@angular/platform-browser")):"function"==typeof define&&define.amd?define("@angular/material/slideToggle",["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/cdk/platform","@angular/core","@angular/forms","@angular/material/core","@angular/cdk/observers","@angular/platform-browser"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.slideToggle={}),e.ng.cdk.a11y,e.ng.cdk.coercion,e.ng.cdk.platform,e.ng.core,e.ng.forms,e.ng.material.core,e.ng.cdk.observers,e.ng.platformBrowser)}(this,function(e,t,i,n,a,r,o,l,s){"use strict";function g(e,t){function i(){this.constructor=e}d(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}var d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i])},c=0,u={provide:r.NG_VALUE_ACCESSOR,useExisting:a.forwardRef(function(){return b}),multi:!0},p=function(){function e(e,t){this.source=e,this.checked=t}return e}(),h=function(){function e(e){this._elementRef=e}return e}(),m=o.mixinTabIndex(o.mixinColor(o.mixinDisableRipple(o.mixinDisabled(h)),"accent")),b=function(e){function r(t,i,n,r,o,l){var s=e.call(this,t)||this;return s._focusMonitor=n,s._changeDetectorRef=r,s._ngZone=l,s.onChange=function(e){},s.onTouched=function(){},s._uniqueId="mat-slide-toggle-"+ ++c,s._required=!1,s._checked=!1,s._dragging=!1,s.name=null,s.id=s._uniqueId,s.labelPosition="after",s.ariaLabel=null,s.ariaLabelledby=null,s.change=new a.EventEmitter,s.tabIndex=parseInt(o)||0,s}return g(r,e),Object.defineProperty(r.prototype,"required",{get:function(){return this._required},set:function(e){this._required=i.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"checked",{get:function(){return this._checked},set:function(e){this._checked=i.coerceBooleanProperty(e),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(r.prototype,"inputId",{get:function(){return(this.id||this._uniqueId)+"-input"},enumerable:!0,configurable:!0}),r.prototype.ngAfterContentInit=function(){var e=this;this._focusMonitor.monitor(this._inputElement.nativeElement).subscribe(function(t){return e._onInputFocusChange(t)})},r.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._inputElement.nativeElement)},r.prototype._onChangeEvent=function(e){if(e.stopPropagation(),this._dragging)return void(this._inputElement.nativeElement.checked=this.checked);this.checked=this._inputElement.nativeElement.checked,this._emitChangeEvent()},r.prototype._onInputClick=function(e){e.stopPropagation()},r.prototype.writeValue=function(e){this.checked=!!e},r.prototype.registerOnChange=function(e){this.onChange=e},r.prototype.registerOnTouched=function(e){this.onTouched=e},r.prototype.setDisabledState=function(e){this.disabled=e,this._changeDetectorRef.markForCheck()},r.prototype.focus=function(){this._focusMonitor.focusVia(this._inputElement.nativeElement,"keyboard")},r.prototype.toggle=function(){this.checked=!this.checked},r.prototype._onInputFocusChange=function(e){this._focusRipple||"keyboard"!==e?e||(this.onTouched(),this._focusRipple&&(this._focusRipple.fadeOut(),this._focusRipple=null)):this._focusRipple=this._ripple.launch(0,0,{persistent:!0})},r.prototype._emitChangeEvent=function(){this.onChange(this.checked),this.change.emit(new p(this,this.checked))},r.prototype._getDragPercentage=function(e){var t=e/this._thumbBarWidth*100;return this._previousChecked&&(t+=100),Math.max(0,Math.min(t,100))},r.prototype._onDragStart=function(){if(!this.disabled&&!this._dragging){var e=this._thumbEl.nativeElement;this._thumbBarWidth=this._thumbBarEl.nativeElement.clientWidth-e.clientWidth,e.classList.add("mat-dragging"),this._previousChecked=this.checked,this._dragging=!0}},r.prototype._onDrag=function(e){if(this._dragging){this._dragPercentage=this._getDragPercentage(e.deltaX);var t=this._dragPercentage/100*this._thumbBarWidth;this._thumbEl.nativeElement.style.transform="translate3d("+t+"px, 0, 0)"}},r.prototype._onDragEnd=function(){var e=this;if(this._dragging){var t=this._dragPercentage>50;t!==this.checked&&(this.checked=t,this._emitChangeEvent()),this._ngZone.runOutsideAngular(function(){return setTimeout(function(){e._dragging&&(e._dragging=!1,e._thumbEl.nativeElement.classList.remove("mat-dragging"),e._thumbEl.nativeElement.style.transform="")})})}},r.prototype._onLabelTextChange=function(){this._changeDetectorRef.markForCheck()},r.decorators=[{type:a.Component,args:[{selector:"mat-slide-toggle",exportAs:"matSlideToggle",host:{class:"mat-slide-toggle","[id]":"id","[class.mat-checked]":"checked","[class.mat-disabled]":"disabled","[class.mat-slide-toggle-label-before]":'labelPosition == "before"'},template:'<label class="mat-slide-toggle-label" #label><div #toggleBar class="mat-slide-toggle-bar" [class.mat-slide-toggle-bar-no-side-margin]="!labelContent.textContent || !labelContent.textContent.trim()"><input #input class="mat-slide-toggle-input cdk-visually-hidden" type="checkbox" [id]="inputId" [required]="required" [tabIndex]="tabIndex" [checked]="checked" [disabled]="disabled" [attr.name]="name" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" (change)="_onChangeEvent($event)" (click)="_onInputClick($event)"><div class="mat-slide-toggle-thumb-container" #thumbContainer (slidestart)="_onDragStart()" (slide)="_onDrag($event)" (slideend)="_onDragEnd()"><div class="mat-slide-toggle-thumb"></div><div class="mat-slide-toggle-ripple" mat-ripple [matRippleTrigger]="label" [matRippleDisabled]="disableRipple || disabled" [matRippleCentered]="true" [matRippleRadius]="23" [matRippleAnimation]="{enterDuration: 150}"></div></div></div><span class="mat-slide-toggle-content" #labelContent (cdkObserveContent)="_onLabelTextChange()"><ng-content></ng-content></span></label>',styles:[".mat-slide-toggle{display:inline-block;height:24px;max-width:100%;line-height:24px;white-space:nowrap;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;outline:0}.mat-slide-toggle.mat-checked .mat-slide-toggle-thumb-container{transform:translate3d(16px,0,0)}.mat-slide-toggle.mat-disabled .mat-slide-toggle-label,.mat-slide-toggle.mat-disabled .mat-slide-toggle-thumb-container{cursor:default}.mat-slide-toggle-label{display:flex;flex:1;flex-direction:row;align-items:center;height:inherit;cursor:pointer}.mat-slide-toggle-content{white-space:nowrap;overflow:hidden;text-overflow:ellipsis}.mat-slide-toggle-label-before .mat-slide-toggle-label{order:1}.mat-slide-toggle-label-before .mat-slide-toggle-bar{order:2}.mat-slide-toggle-bar,[dir=rtl] .mat-slide-toggle-label-before .mat-slide-toggle-bar{margin-right:8px;margin-left:0}.mat-slide-toggle-label-before .mat-slide-toggle-bar,[dir=rtl] .mat-slide-toggle-bar{margin-left:8px;margin-right:0}.mat-slide-toggle-bar-no-side-margin{margin-left:0;margin-right:0}.mat-slide-toggle-thumb-container{position:absolute;z-index:1;width:20px;height:20px;top:-3px;left:0;transform:translate3d(0,0,0);transition:all 80ms linear;transition-property:transform;cursor:-webkit-grab;cursor:grab}.mat-slide-toggle-thumb-container.mat-dragging,.mat-slide-toggle-thumb-container:active{cursor:-webkit-grabbing;cursor:grabbing;transition-duration:0s}.mat-slide-toggle-thumb{height:20px;width:20px;border-radius:50%;box-shadow:0 2px 1px -1px rgba(0,0,0,.2),0 1px 1px 0 rgba(0,0,0,.14),0 1px 3px 0 rgba(0,0,0,.12)}@media screen and (-ms-high-contrast:active){.mat-slide-toggle-thumb{background:#fff;border:solid 1px #000}}.mat-slide-toggle-bar{position:relative;width:36px;height:14px;flex-shrink:0;border-radius:8px}@media screen and (-ms-high-contrast:active){.mat-slide-toggle-bar{background:#fff}}.mat-slide-toggle-input{bottom:0;left:10px}.mat-slide-toggle-bar,.mat-slide-toggle-thumb{transition:all 80ms linear;transition-property:background-color;transition-delay:50ms}.mat-slide-toggle-ripple{position:absolute;top:calc(50% - 23px);left:calc(50% - 23px);height:46px;width:46px;z-index:1;pointer-events:none}"],providers:[u],inputs:["disabled","disableRipple","color","tabIndex"],encapsulation:a.ViewEncapsulation.None,changeDetection:a.ChangeDetectionStrategy.OnPush}]}],r.ctorParameters=function(){return[{type:a.ElementRef},{type:n.Platform},{type:t.FocusMonitor},{type:a.ChangeDetectorRef},{type:void 0,decorators:[{type:a.Attribute,args:["tabindex"]}]},{type:a.NgZone}]},r.propDecorators={_thumbEl:[{type:a.ViewChild,args:["thumbContainer"]}],_thumbBarEl:[{type:a.ViewChild,args:["toggleBar"]}],name:[{type:a.Input}],id:[{type:a.Input}],labelPosition:[{type:a.Input}],ariaLabel:[{type:a.Input,args:["aria-label"]}],ariaLabelledby:[{type:a.Input,args:["aria-labelledby"]}],required:[{type:a.Input}],checked:[{type:a.Input}],change:[{type:a.Output}],_inputElement:[{type:a.ViewChild,args:["input"]}],_ripple:[{type:a.ViewChild,args:[o.MatRipple]}]},r}(m),f=function(){function e(){}return e.decorators=[{type:a.NgModule,args:[{imports:[o.MatRippleModule,o.MatCommonModule,l.ObserversModule],exports:[b,o.MatCommonModule],declarations:[b],providers:[{provide:s.HAMMER_GESTURE_CONFIG,useClass:o.GestureConfig}]}]}],e}();e.MatSlideToggleModule=f,e.MAT_SLIDE_TOGGLE_VALUE_ACCESSOR=u,e.MatSlideToggleChange=p,e.MatSlideToggleBase=h,e._MatSlideToggleMixinBase=m,e.MatSlideToggle=b,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-slide-toggle.umd.min.js.map
