/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("rxjs"),require("@angular/core"),require("@angular/animations"),require("@angular/material/core"),require("@angular/cdk/portal"),require("rxjs/operators"),require("@angular/cdk/a11y"),require("@angular/cdk/layout"),require("@angular/cdk/overlay"),require("@angular/common"),require("@angular/material/button")):"function"==typeof define&&define.amd?define("@angular/material/snackBar",["exports","rxjs","@angular/core","@angular/animations","@angular/material/core","@angular/cdk/portal","rxjs/operators","@angular/cdk/a11y","@angular/cdk/layout","@angular/cdk/overlay","@angular/common","@angular/material/button"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.snackBar={}),t.Rx,t.ng.core,t.ng.animations,t.ng.material.core,t.ng.cdk.portal,t.Rx.operators,t.ng.cdk.a11y,t.ng.cdk.layout,t.ng.cdk.overlay,t.ng.common,t.ng.material.button)}(this,function(t,e,n,a,o,i,r,s,c,p,l,u){"use strict";function d(t,e){function n(){this.constructor=t}h(t,e),t.prototype=null===e?Object.create(e):(n.prototype=e.prototype,new n)}function m(){return new k}var h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n])},f=Object.assign||function(t){for(var e,n=1,a=arguments.length;n<a;n++){e=arguments[n];for(var o in e)Object.prototype.hasOwnProperty.call(e,o)&&(t[o]=e[o])}return t},_=function(){function t(t,n){var a=this;this._overlayRef=n,this._afterDismissed=new e.Subject,this._afterOpened=new e.Subject,this._onAction=new e.Subject,this._dismissedByAction=!1,this.containerInstance=t,this.onAction().subscribe(function(){return a.dismiss()}),t._onExit.subscribe(function(){return a._finishDismiss()})}return t.prototype.dismiss=function(){this._afterDismissed.closed||this.containerInstance.exit(),clearTimeout(this._durationTimeoutId)},t.prototype.dismissWithAction=function(){this._onAction.closed||(this._dismissedByAction=!0,this._onAction.next(),this._onAction.complete())},t.prototype.closeWithAction=function(){this.dismissWithAction()},t.prototype._dismissAfter=function(t){var e=this;this._durationTimeoutId=setTimeout(function(){return e.dismiss()},t)},t.prototype._open=function(){this._afterOpened.closed||(this._afterOpened.next(),this._afterOpened.complete())},t.prototype._finishDismiss=function(){this._overlayRef.dispose(),this._onAction.closed||this._onAction.complete(),this._afterDismissed.next({dismissedByAction:this._dismissedByAction}),this._afterDismissed.complete(),this._dismissedByAction=!1},t.prototype.afterDismissed=function(){return this._afterDismissed.asObservable()},t.prototype.afterOpened=function(){return this.containerInstance._onEnter},t.prototype.onAction=function(){return this._onAction.asObservable()},t}(),y=new n.InjectionToken("MatSnackBarData"),k=function(){function t(){this.politeness="assertive",this.announcementMessage="",this.duration=0,this.data=null,this.horizontalPosition="center",this.verticalPosition="bottom"}return t}(),g={contentFade:a.trigger("contentFade",[a.transition(":enter",[a.style({opacity:"0"}),a.animate(o.AnimationDurations.COMPLEX+" "+o.AnimationCurves.STANDARD_CURVE)])]),snackBarState:a.trigger("state",[a.state("visible-top, visible-bottom",a.style({transform:"translateY(0%)"})),a.transition("visible-top => hidden-top, visible-bottom => hidden-bottom",a.animate(o.AnimationDurations.EXITING+" "+o.AnimationCurves.ACCELERATION_CURVE)),a.transition("void => visible-top, void => visible-bottom",a.animate(o.AnimationDurations.ENTERING+" "+o.AnimationCurves.DECELERATION_CURVE))])},b=function(){function t(t,e){this.snackBarRef=t,this.data=e}return t.prototype.action=function(){this.snackBarRef.dismissWithAction()},Object.defineProperty(t.prototype,"hasAction",{get:function(){return!!this.data.action},enumerable:!0,configurable:!0}),t.decorators=[{type:n.Component,args:[{selector:"simple-snack-bar",template:'{{data.message}}<div class="mat-simple-snackbar-action" *ngIf="hasAction"><button mat-button (click)="action()">{{data.action}}</button></div>',styles:[".mat-simple-snackbar{display:flex;justify-content:space-between;line-height:20px;opacity:1}.mat-simple-snackbar-action{display:flex;flex-direction:column;flex-shrink:0;justify-content:space-around;margin:-8px 0 -8px 8px}.mat-simple-snackbar-action button{flex:1;max-height:36px}[dir=rtl] .mat-simple-snackbar-action{margin-left:0;margin-right:8px}"],encapsulation:n.ViewEncapsulation.None,changeDetection:n.ChangeDetectionStrategy.OnPush,animations:[g.contentFade],host:{"[@contentFade]":"",class:"mat-simple-snackbar"}}]}],t.ctorParameters=function(){return[{type:_},{type:void 0,decorators:[{type:n.Inject,args:[y]}]}]},t}(),v=function(t){function a(n,a,o,i){var r=t.call(this)||this;return r._ngZone=n,r._elementRef=a,r._changeDetectorRef=o,r.snackBarConfig=i,r._destroyed=!1,r._onExit=new e.Subject,r._onEnter=new e.Subject,r._animationState="void",r}return d(a,t),a.prototype.attachComponentPortal=function(t){return this._assertNotAttached(),this._applySnackBarClasses(),this._portalOutlet.attachComponentPortal(t)},a.prototype.attachTemplatePortal=function(t){return this._assertNotAttached(),this._applySnackBarClasses(),this._portalOutlet.attachTemplatePortal(t)},a.prototype.onAnimationEnd=function(t){var e=t.fromState,n=t.toState;if(("void"===n&&"void"!==e||n.startsWith("hidden"))&&this._completeExit(),n.startsWith("visible")){var a=this._onEnter;this._ngZone.run(function(){a.next(),a.complete()})}},a.prototype.enter=function(){this._destroyed||(this._animationState="visible-"+this.snackBarConfig.verticalPosition,this._changeDetectorRef.detectChanges())},a.prototype.exit=function(){return this._animationState="hidden-"+this.snackBarConfig.verticalPosition,this._onExit},a.prototype.ngOnDestroy=function(){this._destroyed=!0,this._completeExit()},a.prototype._completeExit=function(){var t=this;this._ngZone.onMicrotaskEmpty.asObservable().pipe(r.take(1)).subscribe(function(){t._onExit.next(),t._onExit.complete()})},a.prototype._applySnackBarClasses=function(){var t=this._elementRef.nativeElement,e=this.snackBarConfig.panelClass;e&&(Array.isArray(e)?e.forEach(function(e){return t.classList.add(e)}):t.classList.add(e)),"center"===this.snackBarConfig.horizontalPosition&&t.classList.add("mat-snack-bar-center"),"top"===this.snackBarConfig.verticalPosition&&t.classList.add("mat-snack-bar-top")},a.prototype._assertNotAttached=function(){if(this._portalOutlet.hasAttached())throw Error("Attempting to attach snack bar content after content is already attached")},a.decorators=[{type:n.Component,args:[{selector:"snack-bar-container",template:"<ng-template cdkPortalOutlet></ng-template>",styles:[".mat-snack-bar-container{border-radius:2px;box-sizing:border-box;display:block;margin:24px;max-width:568px;min-width:288px;padding:14px 24px;transform:translateY(100%) translateY(24px)}.mat-snack-bar-container.mat-snack-bar-center{margin:0;transform:translateY(100%)}.mat-snack-bar-container.mat-snack-bar-top{transform:translateY(-100%) translateY(-24px)}.mat-snack-bar-container.mat-snack-bar-top.mat-snack-bar-center{transform:translateY(-100%)}@media screen and (-ms-high-contrast:active){.mat-snack-bar-container{border:solid 1px}}.mat-snack-bar-handset{width:100%}.mat-snack-bar-handset .mat-snack-bar-container{margin:0;max-width:inherit;width:100%}"],changeDetection:n.ChangeDetectionStrategy.OnPush,encapsulation:n.ViewEncapsulation.None,animations:[g.snackBarState],host:{role:"alert",class:"mat-snack-bar-container","[@state]":"_animationState","(@state.done)":"onAnimationEnd($event)"}}]}],a.ctorParameters=function(){return[{type:n.NgZone},{type:n.ElementRef},{type:n.ChangeDetectorRef},{type:k}]},a.propDecorators={_portalOutlet:[{type:n.ViewChild,args:[i.CdkPortalOutlet]}]},a}(i.BasePortalOutlet),A=new n.InjectionToken("mat-snack-bar-default-options",{providedIn:"root",factory:m}),B=function(){function t(t,e,n,a,o,i){this._overlay=t,this._live=e,this._injector=n,this._breakpointObserver=a,this._parentSnackBar=o,this._defaultConfig=i,this._snackBarRefAtThisLevel=null}return Object.defineProperty(t.prototype,"_openedSnackBarRef",{get:function(){var t=this._parentSnackBar;return t?t._openedSnackBarRef:this._snackBarRefAtThisLevel},set:function(t){this._parentSnackBar?this._parentSnackBar._openedSnackBarRef=t:this._snackBarRefAtThisLevel=t},enumerable:!0,configurable:!0}),t.prototype.openFromComponent=function(t,e){return this._attach(t,e)},t.prototype.openFromTemplate=function(t,e){return this._attach(t,e)},t.prototype.open=function(t,e,n){void 0===e&&(e="");var a=f({},this._defaultConfig,n);return a.data={message:t,action:e},a.announcementMessage=t,this.openFromComponent(b,a)},t.prototype.dismiss=function(){this._openedSnackBarRef&&this._openedSnackBarRef.dismiss()},t.prototype._attachSnackBarContainer=function(t,e){var n=e&&e.viewContainerRef&&e.viewContainerRef.injector,a=new i.PortalInjector(n||this._injector,new WeakMap([[k,e]])),o=new i.ComponentPortal(v,e.viewContainerRef,a),r=t.attach(o);return r.instance.snackBarConfig=e,r.instance},t.prototype._attach=function(t,e){var a=f({},new k,this._defaultConfig,e),o=this._createOverlay(a),s=this._attachSnackBarContainer(o,a),p=new _(s,o);if(t instanceof n.TemplateRef){var l=new i.TemplatePortal(t,null,{$implicit:a.data,snackBarRef:p});p.instance=s.attachTemplatePortal(l)}else{var u=this._createInjector(a,p),l=new i.ComponentPortal(t,void 0,u),d=s.attachComponentPortal(l);p.instance=d.instance}return this._breakpointObserver.observe(c.Breakpoints.Handset).pipe(r.takeUntil(o.detachments().pipe(r.take(1)))).subscribe(function(t){t.matches?o.overlayElement.classList.add("mat-snack-bar-handset"):o.overlayElement.classList.remove("mat-snack-bar-handset")}),this._animateSnackBar(p,a),this._openedSnackBarRef=p,this._openedSnackBarRef},t.prototype._animateSnackBar=function(t,e){var n=this;t.afterDismissed().subscribe(function(){n._openedSnackBarRef==t&&(n._openedSnackBarRef=null)}),this._openedSnackBarRef?(this._openedSnackBarRef.afterDismissed().subscribe(function(){t.containerInstance.enter()}),this._openedSnackBarRef.dismiss()):t.containerInstance.enter(),e.duration&&e.duration>0&&t.afterOpened().subscribe(function(){return t._dismissAfter(e.duration)}),e.announcementMessage&&this._live.announce(e.announcementMessage,e.politeness)},t.prototype._createOverlay=function(t){var e=new p.OverlayConfig;e.direction=t.direction;var n=this._overlay.position().global(),a="rtl"===t.direction,o="left"===t.horizontalPosition||"start"===t.horizontalPosition&&!a||"end"===t.horizontalPosition&&a,i=!o&&"center"!==t.horizontalPosition;return o?n.left("0"):i?n.right("0"):n.centerHorizontally(),"top"===t.verticalPosition?n.top("0"):n.bottom("0"),e.positionStrategy=n,this._overlay.create(e)},t.prototype._createInjector=function(t,e){var n=t&&t.viewContainerRef&&t.viewContainerRef.injector;return new i.PortalInjector(n||this._injector,new WeakMap([[_,e],[y,t.data]]))},t.decorators=[{type:n.Injectable}],t.ctorParameters=function(){return[{type:p.Overlay},{type:s.LiveAnnouncer},{type:n.Injector},{type:c.BreakpointObserver},{type:t,decorators:[{type:n.Optional},{type:n.SkipSelf}]},{type:k,decorators:[{type:n.Inject,args:[A]}]}]},t}(),C=function(){function t(){}return t.decorators=[{type:n.NgModule,args:[{imports:[p.OverlayModule,i.PortalModule,l.CommonModule,u.MatButtonModule,o.MatCommonModule],exports:[v,o.MatCommonModule],declarations:[v,b],entryComponents:[v,b],providers:[B]}]}],t}();t.MatSnackBarModule=C,t.MAT_SNACK_BAR_DEFAULT_OPTIONS=A,t.MAT_SNACK_BAR_DEFAULT_OPTIONS_FACTORY=m,t.MatSnackBar=B,t.MatSnackBarContainer=v,t.MAT_SNACK_BAR_DATA=y,t.MatSnackBarConfig=k,t.MatSnackBarRef=_,t.SimpleSnackBar=b,t.matSnackBarAnimations=g,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-snack-bar.umd.min.js.map
