/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/animations"),require("@angular/cdk/a11y"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/cdk/keycodes"),require("@angular/cdk/layout"),require("@angular/cdk/overlay"),require("@angular/cdk/platform"),require("@angular/cdk/portal"),require("rxjs/operators"),require("@angular/core"),require("rxjs"),require("@angular/common"),require("@angular/material/core")):"function"==typeof define&&define.amd?define("@angular/material/tooltip",["exports","@angular/animations","@angular/cdk/a11y","@angular/cdk/bidi","@angular/cdk/coercion","@angular/cdk/keycodes","@angular/cdk/layout","@angular/cdk/overlay","@angular/cdk/platform","@angular/cdk/portal","rxjs/operators","@angular/core","rxjs","@angular/common","@angular/material/core"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.tooltip={}),t.ng.animations,t.ng.cdk.a11y,t.ng.cdk.bidi,t.ng.cdk.coercion,t.ng.cdk.keycodes,t.ng.cdk.layout,t.ng.cdk.overlay,t.ng.cdk.platform,t.ng.cdk.portal,t.Rx.operators,t.ng.core,t.Rx,t.ng.common,t.ng.material.core)}(this,function(t,e,i,o,n,s,r,a,l,p,c,h,d,u,_){"use strict";function y(t){return Error('Tooltip position "'+t+'" is invalid.')}function m(t){return function(){return t.scrollStrategies.reposition({scrollThrottle:b})}}function f(){return{showDelay:0,hideDelay:0,touchendHideDelay:1500}}var g=Object.assign||function(t){for(var e,i=1,o=arguments.length;i<o;i++){e=arguments[i];for(var n in e)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])}return t},v={tooltipState:e.trigger("state",[e.state("initial, void, hidden",e.style({transform:"scale(0)"})),e.state("visible",e.style({transform:"scale(1)"})),e.transition("* => visible",e.animate("150ms cubic-bezier(0.0, 0.0, 0.2, 1)")),e.transition("* => hidden",e.animate("150ms cubic-bezier(0.4, 0.0, 1, 1)"))])},b=20,T=new h.InjectionToken("mat-tooltip-scroll-strategy"),O={provide:T,deps:[a.Overlay],useFactory:m},k=new h.InjectionToken("mat-tooltip-default-options",{providedIn:"root",factory:f}),I=function(){function t(t,e,i,o,n,s,r,a,l,p,h){var u=this;this._overlay=t,this._elementRef=e,this._scrollDispatcher=i,this._viewContainerRef=o,this._ngZone=n,this._platform=s,this._ariaDescriber=r,this._focusMonitor=a,this._scrollStrategy=l,this._dir=p,this._defaultOptions=h,this._position="below",this._disabled=!1,this.showDelay=this._defaultOptions.showDelay,this.hideDelay=this._defaultOptions.hideDelay,this._message="",this._manualListeners=new Map,this._destroyed=new d.Subject;var _=e.nativeElement;s.IOS?"INPUT"!==_.nodeName&&"TEXTAREA"!==_.nodeName||(_.style.webkitUserSelect=_.style.userSelect=""):(this._manualListeners.set("mouseenter",function(){return u.show()}),this._manualListeners.set("mouseleave",function(){return u.hide()}),this._manualListeners.forEach(function(t,i){return e.nativeElement.addEventListener(i,t)})),a.monitor(_).pipe(c.takeUntil(this._destroyed)).subscribe(function(t){t?"program"!==t&&n.run(function(){return u.show()}):n.run(function(){return u.hide(0)})})}return Object.defineProperty(t.prototype,"position",{get:function(){return this._position},set:function(t){t!==this._position&&(this._position=t,this._overlayRef&&(this._updatePosition(),this._tooltipInstance&&this._tooltipInstance.show(0),this._overlayRef.updatePosition()))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"disabled",{get:function(){return this._disabled},set:function(t){this._disabled=n.coerceBooleanProperty(t),this._disabled&&this.hide(0)},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"message",{get:function(){return this._message},set:function(t){this._ariaDescriber.removeDescription(this._elementRef.nativeElement,this._message),this._message=null!=t?(""+t).trim():"",!this._message&&this._isTooltipVisible()?this.hide(0):(this._updateTooltipMessage(),this._ariaDescriber.describe(this._elementRef.nativeElement,this.message))},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"tooltipClass",{get:function(){return this._tooltipClass},set:function(t){this._tooltipClass=t,this._tooltipInstance&&this._setTooltipClass(this._tooltipClass)},enumerable:!0,configurable:!0}),t.prototype.ngOnDestroy=function(){var t=this;this._overlayRef&&(this._overlayRef.dispose(),this._tooltipInstance=null),this._platform.IOS||(this._manualListeners.forEach(function(e,i){return t._elementRef.nativeElement.removeEventListener(i,e)}),this._manualListeners.clear()),this._destroyed.next(),this._destroyed.complete(),this._ariaDescriber.removeDescription(this._elementRef.nativeElement,this.message),this._focusMonitor.stopMonitoring(this._elementRef.nativeElement)},t.prototype.show=function(t){var e=this;if(void 0===t&&(t=this.showDelay),!this.disabled&&this.message){var i=this._createOverlay();this._detach(),i.setDirection(this._dir?this._dir.value:"ltr"),this._portal=this._portal||new p.ComponentPortal(C,this._viewContainerRef),this._tooltipInstance=i.attach(this._portal).instance,this._tooltipInstance.afterHidden().pipe(c.takeUntil(this._destroyed)).subscribe(function(){return e._detach()}),this._setTooltipClass(this._tooltipClass),this._updateTooltipMessage(),this._tooltipInstance.show(t)}},t.prototype.hide=function(t){void 0===t&&(t=this.hideDelay),this._tooltipInstance&&this._tooltipInstance.hide(t)},t.prototype.toggle=function(){this._isTooltipVisible()?this.hide():this.show()},t.prototype._isTooltipVisible=function(){return!!this._tooltipInstance&&this._tooltipInstance.isVisible()},t.prototype._handleKeydown=function(t){this._isTooltipVisible()&&t.keyCode===s.ESCAPE&&(t.stopPropagation(),this.hide(0))},t.prototype._handleTouchend=function(){this.hide(this._defaultOptions.touchendHideDelay)},t.prototype._createOverlay=function(){var t=this;if(this._overlayRef)return this._overlayRef;var e=this._overlay.position().flexibleConnectedTo(this._elementRef).withTransformOriginOn(".mat-tooltip").withFlexibleDimensions(!1).withViewportMargin(8),i=this._scrollDispatcher.getAncestorScrollContainers(this._elementRef);return e.withScrollableContainers(i),e.positionChanges.pipe(c.takeUntil(this._destroyed)).subscribe(function(e){t._tooltipInstance&&e.scrollableViewProperties.isOverlayClipped&&t._tooltipInstance.isVisible()&&t._ngZone.run(function(){return t.hide(0)})}),this._overlayRef=this._overlay.create({positionStrategy:e,panelClass:"mat-tooltip-panel",scrollStrategy:this._scrollStrategy()}),this._updatePosition(),this._overlayRef.detachments().pipe(c.takeUntil(this._destroyed)).subscribe(function(){return t._detach()}),this._overlayRef},t.prototype._detach=function(){this._overlayRef&&this._overlayRef.hasAttached()&&this._overlayRef.detach(),this._tooltipInstance=null},t.prototype._updatePosition=function(){var t=this._overlayRef.getConfig().positionStrategy,e=this._getOrigin(),i=this._getOverlayPosition();t.withPositions([g({},e.main,i.main),g({},e.fallback,i.fallback)])},t.prototype._getOrigin=function(){var t,e=!this._dir||"ltr"==this._dir.value,i=this.position;if("above"==i||"below"==i)t={originX:"center",originY:"above"==i?"top":"bottom"};else if("before"==i||"left"==i&&e||"right"==i&&!e)t={originX:"start",originY:"center"};else{if(!("after"==i||"right"==i&&e||"left"==i&&!e))throw y(i);t={originX:"end",originY:"center"}}var o=this._invertPosition(t.originX,t.originY);return{main:t,fallback:{originX:o.x,originY:o.y}}},t.prototype._getOverlayPosition=function(){var t,e=!this._dir||"ltr"==this._dir.value,i=this.position;if("above"==i)t={overlayX:"center",overlayY:"bottom"};else if("below"==i)t={overlayX:"center",overlayY:"top"};else if("before"==i||"left"==i&&e||"right"==i&&!e)t={overlayX:"end",overlayY:"center"};else{if(!("after"==i||"right"==i&&e||"left"==i&&!e))throw y(i);t={overlayX:"start",overlayY:"center"}}var o=this._invertPosition(t.overlayX,t.overlayY);return{main:t,fallback:{overlayX:o.x,overlayY:o.y}}},t.prototype._updateTooltipMessage=function(){var t=this;this._tooltipInstance&&(this._tooltipInstance.message=this.message,this._tooltipInstance._markForCheck(),this._ngZone.onMicrotaskEmpty.asObservable().pipe(c.take(1),c.takeUntil(this._destroyed)).subscribe(function(){t._tooltipInstance&&t._overlayRef.updatePosition()}))},t.prototype._setTooltipClass=function(t){this._tooltipInstance&&(this._tooltipInstance.tooltipClass=t,this._tooltipInstance._markForCheck())},t.prototype._invertPosition=function(t,e){return"above"===this.position||"below"===this.position?"top"===e?e="bottom":"bottom"===e&&(e="top"):"end"===t?t="start":"start"===t&&(t="end"),{x:t,y:e}},t.decorators=[{type:h.Directive,args:[{selector:"[matTooltip]",exportAs:"matTooltip",host:{"(longpress)":"show()","(keydown)":"_handleKeydown($event)","(touchend)":"_handleTouchend()"}}]}],t.ctorParameters=function(){return[{type:a.Overlay},{type:h.ElementRef},{type:a.ScrollDispatcher},{type:h.ViewContainerRef},{type:h.NgZone},{type:l.Platform},{type:i.AriaDescriber},{type:i.FocusMonitor},{type:void 0,decorators:[{type:h.Inject,args:[T]}]},{type:o.Directionality,decorators:[{type:h.Optional}]},{type:void 0,decorators:[{type:h.Optional},{type:h.Inject,args:[k]}]}]},t.propDecorators={position:[{type:h.Input,args:["matTooltipPosition"]}],disabled:[{type:h.Input,args:["matTooltipDisabled"]}],showDelay:[{type:h.Input,args:["matTooltipShowDelay"]}],hideDelay:[{type:h.Input,args:["matTooltipHideDelay"]}],message:[{type:h.Input,args:["matTooltip"]}],tooltipClass:[{type:h.Input,args:["matTooltipClass"]}]},t}(),C=function(){function t(t,e){this._changeDetectorRef=t,this._breakpointObserver=e,this._visibility="initial",this._closeOnInteraction=!1,this._onHide=new d.Subject,this._isHandset=this._breakpointObserver.observe(r.Breakpoints.Handset)}return t.prototype.show=function(t){var e=this;this._hideTimeoutId&&clearTimeout(this._hideTimeoutId),this._closeOnInteraction=!0,this._showTimeoutId=setTimeout(function(){e._visibility="visible",e._markForCheck()},t)},t.prototype.hide=function(t){var e=this;this._showTimeoutId&&clearTimeout(this._showTimeoutId),this._hideTimeoutId=setTimeout(function(){e._visibility="hidden",e._markForCheck()},t)},t.prototype.afterHidden=function(){return this._onHide.asObservable()},t.prototype.isVisible=function(){return"visible"===this._visibility},t.prototype._animationStart=function(){this._closeOnInteraction=!1},t.prototype._animationDone=function(t){var e=t.toState;"hidden"!==e||this.isVisible()||this._onHide.next(),"visible"!==e&&"hidden"!==e||(this._closeOnInteraction=!0)},t.prototype._handleBodyInteraction=function(){this._closeOnInteraction&&this.hide(0)},t.prototype._markForCheck=function(){this._changeDetectorRef.markForCheck()},t.decorators=[{type:h.Component,args:[{selector:"mat-tooltip-component",template:'<div class="mat-tooltip" [ngClass]="tooltipClass" [class.mat-tooltip-handset]="(_isHandset | async)!.matches" [@state]="_visibility" (@state.start)="_animationStart()" (@state.done)="_animationDone($event)">{{message}}</div>',styles:[".mat-tooltip-panel{pointer-events:none!important}.mat-tooltip{color:#fff;border-radius:2px;margin:14px;max-width:250px;padding-left:8px;padding-right:8px}@media screen and (-ms-high-contrast:active){.mat-tooltip{outline:solid 1px}}.mat-tooltip-handset{margin:24px;padding-left:16px;padding-right:16px}"],encapsulation:h.ViewEncapsulation.None,changeDetection:h.ChangeDetectionStrategy.OnPush,animations:[v.tooltipState],host:{"[style.zoom]":'_visibility === "visible" ? 1 : null',"(body:click)":"this._handleBodyInteraction()","aria-hidden":"true"}}]}],t.ctorParameters=function(){return[{type:h.ChangeDetectorRef},{type:r.BreakpointObserver}]},t}(),w=function(){function t(){}return t.decorators=[{type:h.NgModule,args:[{imports:[u.CommonModule,a.OverlayModule,_.MatCommonModule],exports:[I,C,_.MatCommonModule],declarations:[I,C],entryComponents:[C],providers:[O]}]}],t}();t.MatTooltipModule=w,t.SCROLL_THROTTLE_MS=b,t.TOOLTIP_PANEL_CLASS="mat-tooltip-panel",t.getMatTooltipInvalidPositionError=y,t.MAT_TOOLTIP_SCROLL_STRATEGY=T,t.MAT_TOOLTIP_SCROLL_STRATEGY_FACTORY=m,t.MAT_TOOLTIP_SCROLL_STRATEGY_FACTORY_PROVIDER=O,t.MAT_TOOLTIP_DEFAULT_OPTIONS=k,t.MAT_TOOLTIP_DEFAULT_OPTIONS_FACTORY=f,t.MatTooltip=I,t.TooltipComponent=C,t.matTooltipAnimations=v,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-tooltip.umd.min.js.map
