"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const imports_1 = require("../typescript/imports");
/** Name of the Angular Material module specifier. */
exports.materialModuleSpecifier = '@angular/material';
/** Name of the Angular CDK module specifier. */
exports.cdkModuleSpecifier = '@angular/cdk';
/** Whether the specified node is part of an Angular Material import declaration. */
function isMaterialImportDeclaration(node) {
    return isMaterialDeclaration(imports_1.getImportDeclaration(node));
}
exports.isMaterialImportDeclaration = isMaterialImportDeclaration;
/** Whether the specified node is part of an Angular Material export declaration. */
function isMaterialExportDeclaration(node) {
    return imports_1.getExportDeclaration(imports_1.getImportDeclaration(node));
}
exports.isMaterialExportDeclaration = isMaterialExportDeclaration;
/** Whether the declaration is part of Angular Material. */
function isMaterialDeclaration(declaration) {
    const moduleSpecifier = declaration.moduleSpecifier.getText();
    return moduleSpecifier.indexOf(exports.materialModuleSpecifier) !== -1 ||
        moduleSpecifier.indexOf(exports.cdkModuleSpecifier) !== -1;
}
//# sourceMappingURL=typescript-specifiers.js.map