/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/common"),require("@angular/core"),require("@angular/material/core")):"function"==typeof define&&define.amd?define("@angular/material/badge",["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/common","@angular/core","@angular/material/core"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.badge={}),e.ng.cdk.a11y,e.ng.cdk.coercion,e.ng.common,e.ng.core,e.ng.material.core)}(this,function(e,t,n,i,r,o){"use strict";var a=0,s=function(){function e(e,t,n,i){this._document=e,this._ngZone=t,this._elementRef=n,this._ariaDescriber=i,this._hasContent=!1,this._color="primary",this._overlap=!0,this.position="above after",this.size="medium",this._id=a++}return Object.defineProperty(e.prototype,"color",{get:function(){return this._color},set:function(e){this._setColor(e),this._color=e},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"overlap",{get:function(){return this._overlap},set:function(e){this._overlap=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"content",{get:function(){return this._content},set:function(e){this._content=e,this._hasContent=null!=e&&(""+e).trim().length>0,this._updateTextContent()},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"description",{get:function(){return this._description},set:function(e){e!==this._description&&(this._updateHostAriaDescription(e,this._description),this._description=e)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"hidden",{get:function(){return this._hidden},set:function(e){this._hidden=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),e.prototype.isAbove=function(){return-1===this.position.indexOf("below")},e.prototype.isAfter=function(){return-1===this.position.indexOf("before")},e.prototype.ngOnDestroy=function(){this.description&&this._badgeElement&&this._ariaDescriber.removeDescription(this._badgeElement,this.description)},e.prototype._updateTextContent=function(){return this._badgeElement?this._badgeElement.textContent=this.content:this._badgeElement=this._createBadgeElement(),this._badgeElement},e.prototype._createBadgeElement=function(){var e=this._document.createElement("span");return e.setAttribute("id","mat-badge-content-"+this._id),e.classList.add("mat-badge-content"),e.textContent=this.content,this.description&&e.setAttribute("aria-label",this.description),this._elementRef.nativeElement.appendChild(e),"function"==typeof requestAnimationFrame?this._ngZone.runOutsideAngular(function(){requestAnimationFrame(function(){e.classList.add("mat-badge-active")})}):e.classList.add("mat-badge-active"),e},e.prototype._updateHostAriaDescription=function(e,t){var n=this._updateTextContent();t&&this._ariaDescriber.removeDescription(n,t),e&&this._ariaDescriber.describe(n,e)},e.prototype._setColor=function(e){e!==this._color&&(this._color&&this._elementRef.nativeElement.classList.remove("mat-badge-"+this._color),e&&this._elementRef.nativeElement.classList.add("mat-badge-"+e))},e.decorators=[{type:r.Directive,args:[{selector:"[matBadge]",host:{class:"mat-badge","[class.mat-badge-overlap]":"overlap","[class.mat-badge-above]":"isAbove()","[class.mat-badge-below]":"!isAbove()","[class.mat-badge-before]":"!isAfter()","[class.mat-badge-after]":"isAfter()","[class.mat-badge-small]":'size === "small"',"[class.mat-badge-medium]":'size === "medium"',"[class.mat-badge-large]":'size === "large"',"[class.mat-badge-hidden]":"hidden || !_hasContent"}}]}],e.ctorParameters=function(){return[{type:void 0,decorators:[{type:r.Optional},{type:r.Inject,args:[i.DOCUMENT]}]},{type:r.NgZone},{type:r.ElementRef},{type:t.AriaDescriber}]},e.propDecorators={color:[{type:r.Input,args:["matBadgeColor"]}],overlap:[{type:r.Input,args:["matBadgeOverlap"]}],position:[{type:r.Input,args:["matBadgePosition"]}],content:[{type:r.Input,args:["matBadge"]}],description:[{type:r.Input,args:["matBadgeDescription"]}],size:[{type:r.Input,args:["matBadgeSize"]}],hidden:[{type:r.Input,args:["matBadgeHidden"]}]},e}(),c=function(){function e(){}return e.decorators=[{type:r.NgModule,args:[{imports:[t.A11yModule,o.MatCommonModule],exports:[s],declarations:[s]}]}],e}();e.MatBadgeModule=c,e.MatBadge=s,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-badge.umd.min.js.map
