/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/core"),require("@angular/forms"),require("@angular/material/core"),require("@angular/cdk/collections")):"function"==typeof define&&define.amd?define("@angular/material/buttonToggle",["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/core","@angular/forms","@angular/material/core","@angular/cdk/collections"],e):e((t.ng=t.ng||{},t.ng.material=t.ng.material||{},t.ng.material.buttonToggle={}),t.ng.cdk.a11y,t.ng.cdk.coercion,t.ng.core,t.ng.forms,t.ng.material.core,t.ng.cdk.collections)}(this,function(t,e,o,n,i,r,l){"use strict";function a(t,e){function o(){this.constructor=t}u(t,e),t.prototype=null===e?Object.create(e):(o.prototype=e.prototype,new o)}var u=function(t,e){return(u=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var o in e)e.hasOwnProperty(o)&&(t[o]=e[o])})(t,e)},c=function(){function t(){}return t}(),s=r.mixinDisabled(c),g={provide:i.NG_VALUE_ACCESSOR,useExisting:n.forwardRef(function(){return b}),multi:!0},p=function(){function t(){}return t}(),h=0,d=function(){function t(t,e){this.source=t,this.value=e}return t}(),b=function(t){function e(e){var o=t.call(this)||this;return o._changeDetector=e,o._vertical=!1,o._multiple=!1,o._controlValueAccessorChangeFn=function(){},o._onTouched=function(){},o._name="mat-button-toggle-group-"+h++,o.valueChange=new n.EventEmitter,o.change=new n.EventEmitter,o}return a(e,t),Object.defineProperty(e.prototype,"name",{get:function(){return this._name},set:function(t){var e=this;this._name=t,this._buttonToggles&&this._buttonToggles.forEach(function(t){return t.name=e._name})},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"vertical",{get:function(){return this._vertical},set:function(t){this._vertical=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"value",{get:function(){var t=this._selectionModel?this._selectionModel.selected:[];return this.multiple?t.map(function(t){return t.value}):t[0]?t[0].value:void 0},set:function(t){this._setSelectionByValue(t),this.valueChange.emit(this.value)},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"selected",{get:function(){var t=this._selectionModel.selected;return this.multiple?t:t[0]||null},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"multiple",{get:function(){return this._multiple},set:function(t){this._multiple=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),e.prototype.ngOnInit=function(){this._selectionModel=new l.SelectionModel(this.multiple,void 0,!1)},e.prototype.ngAfterContentInit=function(){(t=this._selectionModel).select.apply(t,this._buttonToggles.filter(function(t){return t.checked}));var t},e.prototype.writeValue=function(t){this.value=t,this._changeDetector.markForCheck()},e.prototype.registerOnChange=function(t){this._controlValueAccessorChangeFn=t},e.prototype.registerOnTouched=function(t){this._onTouched=t},e.prototype.setDisabledState=function(t){this.disabled=t,this._buttonToggles&&this._buttonToggles.forEach(function(t){return t._markForCheck()})},e.prototype._emitChangeEvent=function(){var t=this.selected,e=Array.isArray(t)?t[t.length-1]:t,o=new d(e,this.value);this._controlValueAccessorChangeFn(o.value),this.change.emit(o)},e.prototype._syncButtonToggle=function(t,e,o){void 0===o&&(o=!1),this.multiple||!this.selected||t.checked||(this.selected.checked=!1),e?this._selectionModel.select(t):this._selectionModel.deselect(t),o&&this._emitChangeEvent(),this.valueChange.emit(this.value)},e.prototype._isSelected=function(t){return this._selectionModel.isSelected(t)},e.prototype._isPrechecked=function(t){return void 0!==this._rawValue&&(this.multiple&&Array.isArray(this._rawValue)?this._rawValue.some(function(e){return null!=t.value&&e===t.value}):t.value===this._rawValue)},e.prototype._setSelectionByValue=function(t){var e=this;if(this._rawValue=t,this._buttonToggles)if(this.multiple&&t){if(!Array.isArray(t))throw Error("Value must be an array in multiple-selection mode.");this._clearSelection(),t.forEach(function(t){return e._selectValue(t)})}else this._clearSelection(),this._selectValue(t)},e.prototype._clearSelection=function(){this._selectionModel.clear(),this._buttonToggles.forEach(function(t){return t.checked=!1})},e.prototype._selectValue=function(t){var e=this._buttonToggles.find(function(e){return null!=e.value&&e.value===t});e&&(e.checked=!0,this._selectionModel.select(e))},e.decorators=[{type:n.Directive,args:[{selector:"mat-button-toggle-group",providers:[g,{provide:p,useExisting:e}],inputs:["disabled"],host:{role:"group",class:"mat-button-toggle-group","[class.mat-button-toggle-vertical]":"vertical"},exportAs:"matButtonToggleGroup"}]}],e.ctorParameters=function(){return[{type:n.ChangeDetectorRef}]},e.propDecorators={_buttonToggles:[{type:n.ContentChildren,args:[n.forwardRef(function(){return y})]}],name:[{type:n.Input}],vertical:[{type:n.Input}],value:[{type:n.Input}],valueChange:[{type:n.Output}],multiple:[{type:n.Input}],change:[{type:n.Output}]},e}(s),f=function(){function t(){}return t}(),m=r.mixinDisableRipple(f),y=function(t){function i(e,o,i,r,l){var a=t.call(this)||this;a._changeDetectorRef=o,a._elementRef=i,a._focusMonitor=r,a._isSingleSelector=!1,a._checked=!1,a.ariaLabelledby=null,a._disabled=!1,a.change=new n.EventEmitter;var u=Number(l);return a.tabIndex=u||0===u?u:null,a.buttonToggleGroup=e,a}return a(i,t),Object.defineProperty(i.prototype,"buttonId",{get:function(){return this.id+"-button"},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"checked",{get:function(){return this.buttonToggleGroup?this.buttonToggleGroup._isSelected(this):this._checked},set:function(t){var e=o.coerceBooleanProperty(t);e!==this._checked&&(this._checked=e,this.buttonToggleGroup&&this.buttonToggleGroup._syncButtonToggle(this,this._checked),this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"disabled",{get:function(){return this._disabled||this.buttonToggleGroup&&this.buttonToggleGroup.disabled},set:function(t){this._disabled=o.coerceBooleanProperty(t)},enumerable:!0,configurable:!0}),i.prototype.ngOnInit=function(){this._isSingleSelector=this.buttonToggleGroup&&!this.buttonToggleGroup.multiple,this._type=this._isSingleSelector?"radio":"checkbox",this.id=this.id||"mat-button-toggle-"+h++,this._isSingleSelector&&(this.name=this.buttonToggleGroup.name),this.buttonToggleGroup&&this.buttonToggleGroup._isPrechecked(this)&&(this.checked=!0),this._focusMonitor.monitor(this._elementRef.nativeElement,!0)},i.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._elementRef.nativeElement)},i.prototype.focus=function(){this._buttonElement.nativeElement.focus()},i.prototype._onButtonClick=function(){var t=!!this._isSingleSelector||!this._checked;t!==this._checked&&(this._checked=t,this.buttonToggleGroup&&(this.buttonToggleGroup._syncButtonToggle(this,this._checked,!0),this.buttonToggleGroup._onTouched())),this.change.emit(new d(this,this.value))},i.prototype._markForCheck=function(){this._changeDetectorRef.markForCheck()},i.decorators=[{type:n.Component,args:[{selector:"mat-button-toggle",template:'<button #button class="mat-button-toggle-button" type="button" [id]="buttonId" [attr.tabindex]="disabled ? -1 : tabIndex" [attr.aria-pressed]="checked" [disabled]="disabled || null" [attr.name]="name || null" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" (click)="_onButtonClick()"><div class="mat-button-toggle-label-content"><ng-content></ng-content></div></button><div class="mat-button-toggle-focus-overlay"></div><div class="mat-button-toggle-ripple" matRipple [matRippleTrigger]="button" [matRippleDisabled]="this.disableRipple || this.disabled"></div>',styles:[".mat-button-toggle-group,.mat-button-toggle-standalone{box-shadow:0 3px 1px -2px rgba(0,0,0,.2),0 2px 2px 0 rgba(0,0,0,.14),0 1px 5px 0 rgba(0,0,0,.12);position:relative;display:inline-flex;flex-direction:row;border-radius:2px;cursor:pointer;white-space:nowrap;overflow:hidden}@media screen and (-ms-high-contrast:active){.mat-button-toggle-group,.mat-button-toggle-standalone{outline:solid 1px}}.mat-button-toggle-vertical{flex-direction:column}.mat-button-toggle-vertical .mat-button-toggle-label-content{display:block}.mat-button-toggle-disabled .mat-button-toggle-label-content{cursor:default}.mat-button-toggle{white-space:nowrap;position:relative;-webkit-tap-highlight-color:transparent}.mat-button-toggle.cdk-keyboard-focused .mat-button-toggle-focus-overlay{opacity:1}@media screen and (-ms-high-contrast:active){.mat-button-toggle.cdk-keyboard-focused .mat-button-toggle-focus-overlay{opacity:.5}}.mat-button-toggle-label-content{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:inline-block;line-height:36px;padding:0 16px;cursor:pointer}.mat-button-toggle-label-content>*{vertical-align:middle}.mat-button-toggle-focus-overlay{border-radius:inherit;pointer-events:none;opacity:0;top:0;left:0;right:0;bottom:0;position:absolute}@media screen and (-ms-high-contrast:active){.mat-button-toggle-checked .mat-button-toggle-focus-overlay{opacity:.5;height:0;border-bottom:solid 36px}}.mat-button-toggle-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}.mat-button-toggle-button{border:0;background:0 0;color:inherit;padding:0;margin:0;font:inherit;outline:0}"],encapsulation:n.ViewEncapsulation.None,exportAs:"matButtonToggle",changeDetection:n.ChangeDetectionStrategy.OnPush,inputs:["disableRipple"],host:{"[class.mat-button-toggle-standalone]":"!buttonToggleGroup","[class.mat-button-toggle-checked]":"checked","[class.mat-button-toggle-disabled]":"disabled",class:"mat-button-toggle","[attr.tabindex]":"null","[attr.id]":"id"}}]}],i.ctorParameters=function(){return[{type:b,decorators:[{type:n.Optional}]},{type:n.ChangeDetectorRef},{type:n.ElementRef},{type:e.FocusMonitor},{type:void 0,decorators:[{type:n.Attribute,args:["tabindex"]}]}]},i.propDecorators={ariaLabel:[{type:n.Input,args:["aria-label"]}],ariaLabelledby:[{type:n.Input,args:["aria-labelledby"]}],_buttonElement:[{type:n.ViewChild,args:["button"]}],id:[{type:n.Input}],name:[{type:n.Input}],value:[{type:n.Input}],tabIndex:[{type:n.Input}],checked:[{type:n.Input}],disabled:[{type:n.Input}],change:[{type:n.Output}]},i}(m),_=function(){function t(){}return t.decorators=[{type:n.NgModule,args:[{imports:[r.MatCommonModule,r.MatRippleModule],exports:[r.MatCommonModule,b,y],declarations:[b,y]}]}],t}();t.MatButtonToggleGroupBase=c,t._MatButtonToggleGroupMixinBase=s,t.MAT_BUTTON_TOGGLE_GROUP_VALUE_ACCESSOR=g,t.MatButtonToggleGroupMultiple=p,t.MatButtonToggleChange=d,t.MatButtonToggleGroup=b,t.MatButtonToggleBase=f,t._MatButtonToggleMixinBase=m,t.MatButtonToggle=y,t.MatButtonToggleModule=_,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=material-button-toggle.umd.min.js.map
