/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/forms"),require("@angular/material/core"),require("@angular/platform-browser/animations"),require("@angular/cdk/observers"),require("@angular/common")):"function"==typeof define&&define.amd?define("@angular/material/checkbox",["exports","@angular/core","@angular/cdk/a11y","@angular/cdk/coercion","@angular/forms","@angular/material/core","@angular/platform-browser/animations","@angular/cdk/observers","@angular/common"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.checkbox={}),e.ng.core,e.ng.cdk.a11y,e.ng.cdk.coercion,e.ng.forms,e.ng.material.core,e.ng.platformBrowser.animations,e.ng.cdk.observers,e.ng.common)}(this,function(e,t,n,a,i,c,o,r,m){"use strict";function s(e,t){function n(){this.constructor=e}h(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}var h=function(e,t){return(h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},d=new t.InjectionToken("mat-checkbox-click-action"),k=0,l={provide:i.NG_VALUE_ACCESSOR,useExisting:t.forwardRef(function(){return x}),multi:!0},u={Init:0,Checked:1,Unchecked:2,Indeterminate:3};u[u.Init]="Init",u[u.Checked]="Checked",u[u.Unchecked]="Unchecked",u[u.Indeterminate]="Indeterminate";var b=function(){function e(){}return e}(),p=function(){function e(e){this._elementRef=e}return e}(),f=c.mixinTabIndex(c.mixinColor(c.mixinDisableRipple(c.mixinDisabled(p)),"accent")),x=function(e){function i(n,a,i,c,o,r,m){var s=e.call(this,n)||this;return s._changeDetectorRef=a,s._focusMonitor=i,s._ngZone=c,s._clickAction=r,s._animationMode=m,s.ariaLabel="",s.ariaLabelledby=null,s._uniqueId="mat-checkbox-"+ ++k,s.id=s._uniqueId,s.labelPosition="after",s.name=null,s.change=new t.EventEmitter,s.indeterminateChange=new t.EventEmitter,s._onTouched=function(){},s._currentAnimationClass="",s._currentCheckState=u.Init,s._controlValueAccessorChangeFn=function(){},s._checked=!1,s._disabled=!1,s._indeterminate=!1,s.tabIndex=parseInt(o)||0,s}return s(i,e),Object.defineProperty(i.prototype,"inputId",{get:function(){return(this.id||this._uniqueId)+"-input"},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"required",{get:function(){return this._required},set:function(e){this._required=a.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),i.prototype.ngAfterViewInit=function(){var e=this;this._focusMonitor.monitor(this._inputElement.nativeElement).subscribe(function(t){return e._onInputFocusChange(t)})},i.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._inputElement.nativeElement)},Object.defineProperty(i.prototype,"checked",{get:function(){return this._checked},set:function(e){e!=this.checked&&(this._checked=e,this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"disabled",{get:function(){return this._disabled},set:function(e){e!=this.disabled&&(this._disabled=e,this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(i.prototype,"indeterminate",{get:function(){return this._indeterminate},set:function(e){var t=e!=this._indeterminate;this._indeterminate=e,t&&(this._indeterminate?this._transitionCheckState(u.Indeterminate):this._transitionCheckState(this.checked?u.Checked:u.Unchecked),this.indeterminateChange.emit(this._indeterminate))},enumerable:!0,configurable:!0}),i.prototype._isRippleDisabled=function(){return this.disableRipple||this.disabled},i.prototype._onLabelTextChange=function(){this._changeDetectorRef.markForCheck()},i.prototype.writeValue=function(e){this.checked=!!e},i.prototype.registerOnChange=function(e){this._controlValueAccessorChangeFn=e},i.prototype.registerOnTouched=function(e){this._onTouched=e},i.prototype.setDisabledState=function(e){this.disabled=e},i.prototype._getAriaChecked=function(){return this.checked?"true":this.indeterminate?"mixed":"false"},i.prototype._transitionCheckState=function(e){var t=this._currentCheckState,n=this._elementRef.nativeElement;if(t!==e&&(this._currentAnimationClass.length>0&&n.classList.remove(this._currentAnimationClass),this._currentAnimationClass=this._getAnimationClassForCheckStateTransition(t,e),this._currentCheckState=e,this._currentAnimationClass.length>0)){n.classList.add(this._currentAnimationClass);var a=this._currentAnimationClass;this._ngZone.runOutsideAngular(function(){setTimeout(function(){n.classList.remove(a)},1e3)})}},i.prototype._emitChangeEvent=function(){var e=new b;e.source=this,e.checked=this.checked,this._controlValueAccessorChangeFn(this.checked),this.change.emit(e)},i.prototype._onInputFocusChange=function(e){var t=this;this._focusRipple||"keyboard"!==e?e||(this._focusRipple&&(this._focusRipple.fadeOut(),this._focusRipple=null),Promise.resolve().then(function(){return t._onTouched()})):this._focusRipple=this.ripple.launch(0,0,{persistent:!0})},i.prototype.toggle=function(){this.checked=!this.checked},i.prototype._onInputClick=function(e){var t=this;e.stopPropagation(),this.disabled||"noop"===this._clickAction?this.disabled||"noop"!==this._clickAction||(this._inputElement.nativeElement.checked=this.checked,this._inputElement.nativeElement.indeterminate=this.indeterminate):(this.indeterminate&&"check"!==this._clickAction&&Promise.resolve().then(function(){t._indeterminate=!1,t.indeterminateChange.emit(t._indeterminate)}),this.toggle(),this._transitionCheckState(this._checked?u.Checked:u.Unchecked),this._emitChangeEvent())},i.prototype.focus=function(){this._focusMonitor.focusVia(this._inputElement.nativeElement,"keyboard")},i.prototype._onInteractionEvent=function(e){e.stopPropagation()},i.prototype._getAnimationClassForCheckStateTransition=function(e,t){if("NoopAnimations"===this._animationMode)return"";var n="";switch(e){case u.Init:if(t===u.Checked)n="unchecked-checked";else{if(t!=u.Indeterminate)return"";n="unchecked-indeterminate"}break;case u.Unchecked:n=t===u.Checked?"unchecked-checked":"unchecked-indeterminate";break;case u.Checked:n=t===u.Unchecked?"checked-unchecked":"checked-indeterminate";break;case u.Indeterminate:n=t===u.Checked?"indeterminate-checked":"indeterminate-unchecked"}return"mat-checkbox-anim-"+n},i.decorators=[{type:t.Component,args:[{selector:"mat-checkbox",template:'<label [attr.for]="inputId" class="mat-checkbox-layout" #label><div class="mat-checkbox-inner-container" [class.mat-checkbox-inner-container-no-side-margin]="!checkboxLabel.textContent || !checkboxLabel.textContent.trim()"><input #input class="mat-checkbox-input cdk-visually-hidden" type="checkbox" [id]="inputId" [required]="required" [checked]="checked" [attr.value]="value" [disabled]="disabled" [attr.name]="name" [tabIndex]="tabIndex" [indeterminate]="indeterminate" [attr.aria-label]="ariaLabel || null" [attr.aria-labelledby]="ariaLabelledby" [attr.aria-checked]="_getAriaChecked()" (change)="_onInteractionEvent($event)" (click)="_onInputClick($event)"><div matRipple class="mat-checkbox-ripple" [matRippleTrigger]="label" [matRippleDisabled]="_isRippleDisabled()" [matRippleRadius]="25" [matRippleCentered]="true" [matRippleAnimation]="{enterDuration: 150}"></div><div class="mat-checkbox-frame"></div><div class="mat-checkbox-background"><svg version="1.1" focusable="false" class="mat-checkbox-checkmark" viewBox="0 0 24 24" xml:space="preserve"><path class="mat-checkbox-checkmark-path" fill="none" stroke="white" d="M4.1,12.7 9,17.6 20.3,6.3"/></svg><div class="mat-checkbox-mixedmark"></div></div></div><span class="mat-checkbox-label" #checkboxLabel (cdkObserveContent)="_onLabelTextChange()"><span style="display:none">&nbsp;</span><ng-content></ng-content></span></label>',styles:["@keyframes mat-checkbox-fade-in-background{0%{opacity:0}50%{opacity:1}}@keyframes mat-checkbox-fade-out-background{0%,50%{opacity:1}100%{opacity:0}}@keyframes mat-checkbox-unchecked-checked-checkmark-path{0%,50%{stroke-dashoffset:22.91026}50%{animation-timing-function:cubic-bezier(0,0,.2,.1)}100%{stroke-dashoffset:0}}@keyframes mat-checkbox-unchecked-indeterminate-mixedmark{0%,68.2%{transform:scaleX(0)}68.2%{animation-timing-function:cubic-bezier(0,0,0,1)}100%{transform:scaleX(1)}}@keyframes mat-checkbox-checked-unchecked-checkmark-path{from{animation-timing-function:cubic-bezier(.4,0,1,1);stroke-dashoffset:0}to{stroke-dashoffset:-22.91026}}@keyframes mat-checkbox-checked-indeterminate-checkmark{from{animation-timing-function:cubic-bezier(0,0,.2,.1);opacity:1;transform:rotate(0)}to{opacity:0;transform:rotate(45deg)}}@keyframes mat-checkbox-indeterminate-checked-checkmark{from{animation-timing-function:cubic-bezier(.14,0,0,1);opacity:0;transform:rotate(45deg)}to{opacity:1;transform:rotate(360deg)}}@keyframes mat-checkbox-checked-indeterminate-mixedmark{from{animation-timing-function:cubic-bezier(0,0,.2,.1);opacity:0;transform:rotate(-45deg)}to{opacity:1;transform:rotate(0)}}@keyframes mat-checkbox-indeterminate-checked-mixedmark{from{animation-timing-function:cubic-bezier(.14,0,0,1);opacity:1;transform:rotate(0)}to{opacity:0;transform:rotate(315deg)}}@keyframes mat-checkbox-indeterminate-unchecked-mixedmark{0%{animation-timing-function:linear;opacity:1;transform:scaleX(1)}100%,32.8%{opacity:0;transform:scaleX(0)}}.mat-checkbox-checkmark,.mat-checkbox-mixedmark{width:calc(100% - 4px)}.mat-checkbox-background,.mat-checkbox-frame{top:0;left:0;right:0;bottom:0;position:absolute;border-radius:2px;box-sizing:border-box;pointer-events:none}.mat-checkbox{transition:background .4s cubic-bezier(.25,.8,.25,1),box-shadow 280ms cubic-bezier(.4,0,.2,1);cursor:pointer;-webkit-tap-highlight-color:transparent}._mat-animation-noopable.mat-checkbox{transition:none;animation:none}.mat-checkbox-layout{cursor:inherit;align-items:baseline;vertical-align:middle;display:inline-flex;white-space:nowrap}.mat-checkbox-inner-container{display:inline-block;height:20px;line-height:0;margin:auto;margin-right:8px;order:0;position:relative;vertical-align:middle;white-space:nowrap;width:20px;flex-shrink:0}[dir=rtl] .mat-checkbox-inner-container{margin-left:8px;margin-right:auto}.mat-checkbox-inner-container-no-side-margin{margin-left:0;margin-right:0}.mat-checkbox-frame{background-color:transparent;transition:border-color 90ms cubic-bezier(0,0,.2,.1);border-width:2px;border-style:solid}._mat-animation-noopable .mat-checkbox-frame{transition:none}.mat-checkbox-background{align-items:center;display:inline-flex;justify-content:center;transition:background-color 90ms cubic-bezier(0,0,.2,.1),opacity 90ms cubic-bezier(0,0,.2,.1)}._mat-animation-noopable .mat-checkbox-background{transition:none}.mat-checkbox-checkmark{top:0;left:0;right:0;bottom:0;position:absolute;width:100%}.mat-checkbox-checkmark-path{stroke-dashoffset:22.91026;stroke-dasharray:22.91026;stroke-width:2.66667px}.mat-checkbox-mixedmark{height:2px;opacity:0;transform:scaleX(0) rotate(0)}@media screen and (-ms-high-contrast:active){.mat-checkbox-mixedmark{height:0;border-top:solid 2px;margin-top:2px}}.mat-checkbox-label-before .mat-checkbox-inner-container{order:1;margin-left:8px;margin-right:auto}[dir=rtl] .mat-checkbox-label-before .mat-checkbox-inner-container{margin-left:auto;margin-right:8px}.mat-checkbox-checked .mat-checkbox-checkmark{opacity:1}.mat-checkbox-checked .mat-checkbox-checkmark-path{stroke-dashoffset:0}.mat-checkbox-checked .mat-checkbox-mixedmark{transform:scaleX(1) rotate(-45deg)}.mat-checkbox-indeterminate .mat-checkbox-checkmark{opacity:0;transform:rotate(45deg)}.mat-checkbox-indeterminate .mat-checkbox-checkmark-path{stroke-dashoffset:0}.mat-checkbox-indeterminate .mat-checkbox-mixedmark{opacity:1;transform:scaleX(1) rotate(0)}.mat-checkbox-unchecked .mat-checkbox-background{background-color:transparent}.mat-checkbox-disabled{cursor:default}.mat-checkbox-anim-unchecked-checked .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-in-background}.mat-checkbox-anim-unchecked-checked .mat-checkbox-checkmark-path{animation:180ms linear 0s mat-checkbox-unchecked-checked-checkmark-path}.mat-checkbox-anim-unchecked-indeterminate .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-in-background}.mat-checkbox-anim-unchecked-indeterminate .mat-checkbox-mixedmark{animation:90ms linear 0s mat-checkbox-unchecked-indeterminate-mixedmark}.mat-checkbox-anim-checked-unchecked .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-out-background}.mat-checkbox-anim-checked-unchecked .mat-checkbox-checkmark-path{animation:90ms linear 0s mat-checkbox-checked-unchecked-checkmark-path}.mat-checkbox-anim-checked-indeterminate .mat-checkbox-checkmark{animation:90ms linear 0s mat-checkbox-checked-indeterminate-checkmark}.mat-checkbox-anim-checked-indeterminate .mat-checkbox-mixedmark{animation:90ms linear 0s mat-checkbox-checked-indeterminate-mixedmark}.mat-checkbox-anim-indeterminate-checked .mat-checkbox-checkmark{animation:.5s linear 0s mat-checkbox-indeterminate-checked-checkmark}.mat-checkbox-anim-indeterminate-checked .mat-checkbox-mixedmark{animation:.5s linear 0s mat-checkbox-indeterminate-checked-mixedmark}.mat-checkbox-anim-indeterminate-unchecked .mat-checkbox-background{animation:180ms linear 0s mat-checkbox-fade-out-background}.mat-checkbox-anim-indeterminate-unchecked .mat-checkbox-mixedmark{animation:.3s linear 0s mat-checkbox-indeterminate-unchecked-mixedmark}.mat-checkbox-input{bottom:0;left:50%}.mat-checkbox-ripple{position:absolute;left:calc(50% - 25px);top:calc(50% - 25px);height:50px;width:50px;z-index:1;pointer-events:none}"],exportAs:"matCheckbox",host:{class:"mat-checkbox","[id]":"id","[class.mat-checkbox-indeterminate]":"indeterminate","[class.mat-checkbox-checked]":"checked","[class.mat-checkbox-disabled]":"disabled","[class.mat-checkbox-label-before]":'labelPosition == "before"',"[class._mat-animation-noopable]":"_animationMode === 'NoopAnimations'"},providers:[l],inputs:["disableRipple","color","tabIndex"],encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],i.ctorParameters=function(){return[{type:t.ElementRef},{type:t.ChangeDetectorRef},{type:n.FocusMonitor},{type:t.NgZone},{type:void 0,decorators:[{type:t.Attribute,args:["tabindex"]}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[d]}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[o.ANIMATION_MODULE_TYPE]}]}]},i.propDecorators={ariaLabel:[{type:t.Input,args:["aria-label"]}],ariaLabelledby:[{type:t.Input,args:["aria-labelledby"]}],id:[{type:t.Input}],required:[{type:t.Input}],labelPosition:[{type:t.Input}],name:[{type:t.Input}],change:[{type:t.Output}],indeterminateChange:[{type:t.Output}],value:[{type:t.Input}],_inputElement:[{type:t.ViewChild,args:["input"]}],ripple:[{type:t.ViewChild,args:[c.MatRipple]}],checked:[{type:t.Input}],disabled:[{type:t.Input}],indeterminate:[{type:t.Input}]},i}(f),g={provide:i.NG_VALIDATORS,useExisting:t.forwardRef(function(){return y}),multi:!0},y=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return s(n,e),n.decorators=[{type:t.Directive,args:[{selector:"mat-checkbox[required][formControlName],\n             mat-checkbox[required][formControl], mat-checkbox[required][ngModel]",providers:[g],host:{"[attr.required]":'required ? "" : null'}}]}],n}(i.CheckboxRequiredValidator),_=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[m.CommonModule,c.MatRippleModule,c.MatCommonModule,r.ObserversModule],exports:[x,y,c.MatCommonModule],declarations:[x,y]}]}],e}();e.MAT_CHECKBOX_CONTROL_VALUE_ACCESSOR=l,e.TransitionCheckState=u,e.MatCheckboxChange=b,e.MatCheckboxBase=p,e._MatCheckboxMixinBase=f,e.MatCheckbox=x,e.MAT_CHECKBOX_CLICK_ACTION=d,e.MatCheckboxModule=_,e.MAT_CHECKBOX_REQUIRED_VALIDATOR=g,e.MatCheckboxRequiredValidator=y,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-checkbox.umd.min.js.map
