/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/animations"),require("@angular/cdk/bidi"),require("@angular/cdk/coercion"),require("@angular/material/core"),require("rxjs"),require("rxjs/operators"),require("@angular/cdk/platform"),require("@angular/platform-browser/animations"),require("@angular/common"),require("@angular/cdk/observers")):"function"==typeof define&&define.amd?define("@angular/material/formField",["exports","@angular/core","@angular/animations","@angular/cdk/bidi","@angular/cdk/coercion","@angular/material/core","rxjs","rxjs/operators","@angular/cdk/platform","@angular/platform-browser/animations","@angular/common","@angular/cdk/observers"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.formField={}),e.ng.core,e.ng.animations,e.ng.cdk.bidi,e.ng.cdk.coercion,e.ng.material.core,e.rxjs,e.rxjs.operators,e.ng.cdk.platform,e.ng.platformBrowser.animations,e.ng.common,e.ng.cdk.observers)}(this,function(e,t,a,i,r,n,o,l,f,m,d,s){"use strict";function c(e,t){function a(){this.constructor=e}b(e,t),e.prototype=null===t?Object.create(t):(a.prototype=t.prototype,new a)}function p(){return Error("Placeholder attribute and child element were both specified.")}function u(e){return Error("A hint was already declared for 'align=\""+e+"\"'.")}function h(){return Error("mat-form-field must contain a MatFormFieldControl.")}var b=function(e,t){return(b=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var a in t)t.hasOwnProperty(a)&&(e[a]=t[a])})(e,t)},g=0,_=function(){function e(){this.id="mat-error-"+g++}return e.decorators=[{type:t.Directive,args:[{selector:"mat-error",host:{class:"mat-error",role:"alert","[attr.id]":"id"}}]}],e.propDecorators={id:[{type:t.Input}]},e}(),y={transitionMessages:a.trigger("transitionMessages",[a.state("enter",a.style({opacity:1,transform:"translateY(0%)"})),a.transition("void => enter",[a.style({opacity:0,transform:"translateY(-100%)"}),a.animate("300ms cubic-bezier(0.55, 0, 0.55, 0.2)")])])},v=function(){function e(){}return e}(),w=0,x=function(){function e(){this.align="start",this.id="mat-hint-"+w++}return e.decorators=[{type:t.Directive,args:[{selector:"mat-hint",host:{class:"mat-hint","[class.mat-right]":'align == "end"',"[attr.id]":"id","[attr.align]":"null"}}]}],e.propDecorators={align:[{type:t.Input}],id:[{type:t.Input}]},e}(),C=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-label"}]}],e}(),k=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"mat-placeholder"}]}],e}(),F=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"[matPrefix]"}]}],e}(),L=function(){function e(){}return e.decorators=[{type:t.Directive,args:[{selector:"[matSuffix]"}]}],e}(),M=0,O=function(){function e(e){this._elementRef=e}return e}(),A=n.mixinColor(O,"primary"),I=new t.InjectionToken("MAT_FORM_FIELD_DEFAULT_OPTIONS"),D=function(e){function a(t,a,i,r,n,o,l,f){var m=e.call(this,t)||this;return m._elementRef=t,m._changeDetectorRef=a,m._dir=r,m._defaultOptions=n,m._platform=o,m._ngZone=l,m._showAlwaysAnimate=!1,m._subscriptAnimationState="",m._hintLabel="",m._hintLabelId="mat-hint-"+M++,m._labelId="mat-form-field-label-"+M++,m._labelOptions=i||{},m.floatLabel=m._labelOptions.float||"auto",m._animationsEnabled="NoopAnimations"!==f,m}return c(a,e),Object.defineProperty(a.prototype,"appearance",{get:function(){return this._appearance||this._defaultOptions&&this._defaultOptions.appearance||"legacy"},set:function(e){var t=this,a=this._appearance;this._appearance=e,"outline"===this._appearance&&a!==e&&(this._ngZone?this._ngZone.onStable.pipe(l.take(1)).subscribe(function(){t._ngZone.runOutsideAngular(function(){return t.updateOutlineGap()})}):Promise.resolve().then(function(){return t.updateOutlineGap()}))},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"hideRequiredMarker",{get:function(){return this._hideRequiredMarker},set:function(e){this._hideRequiredMarker=r.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_shouldAlwaysFloat",{get:function(){return"always"===this.floatLabel&&!this._showAlwaysAnimate},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"_canLabelFloat",{get:function(){return"never"!==this.floatLabel},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"hintLabel",{get:function(){return this._hintLabel},set:function(e){this._hintLabel=e,this._processHints()},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"floatLabel",{get:function(){return"legacy"!==this.appearance&&"never"===this._floatLabel?"auto":this._floatLabel},set:function(e){e!==this._floatLabel&&(this._floatLabel=e||this._labelOptions.float||"auto",this._changeDetectorRef.markForCheck())},enumerable:!0,configurable:!0}),a.prototype.getConnectedOverlayOrigin=function(){return this._connectionContainerRef||this._elementRef},a.prototype.ngAfterContentInit=function(){var e=this;this._validateControlChild(),this._control.controlType&&this._elementRef.nativeElement.classList.add("mat-form-field-type-"+this._control.controlType),this._control.stateChanges.pipe(l.startWith(null)).subscribe(function(){e._validatePlaceholders(),e._syncDescribedByIds(),e._changeDetectorRef.markForCheck()});var t=this._control.ngControl&&this._control.ngControl.valueChanges||o.EMPTY;o.merge(t,this._prefixChildren.changes,this._suffixChildren.changes).subscribe(function(){return e._changeDetectorRef.markForCheck()}),this._hintChildren.changes.pipe(l.startWith(null)).subscribe(function(){e._processHints(),e._changeDetectorRef.markForCheck()}),this._errorChildren.changes.pipe(l.startWith(null)).subscribe(function(){e._syncDescribedByIds(),e._changeDetectorRef.markForCheck()})},a.prototype.ngAfterContentChecked=function(){this._validateControlChild()},a.prototype.ngAfterViewInit=function(){this._subscriptAnimationState="enter",this._changeDetectorRef.detectChanges()},a.prototype._shouldForward=function(e){var t=this._control?this._control.ngControl:null;return t&&t[e]},a.prototype._hasPlaceholder=function(){return!!(this._control&&this._control.placeholder||this._placeholderChild)},a.prototype._hasLabel=function(){return!!this._labelChild},a.prototype._shouldLabelFloat=function(){return this._canLabelFloat&&(this._control.shouldLabelFloat||this._shouldAlwaysFloat)},a.prototype._hideControlPlaceholder=function(){return"legacy"===this.appearance&&!this._hasLabel()||this._hasLabel()&&!this._shouldLabelFloat()},a.prototype._hasFloatingLabel=function(){return this._hasLabel()||"legacy"===this.appearance&&this._hasPlaceholder()},a.prototype._getDisplayedMessages=function(){return this._errorChildren&&this._errorChildren.length>0&&this._control.errorState?"error":"hint"},a.prototype._animateAndLockLabel=function(){var e=this;this._hasFloatingLabel()&&this._canLabelFloat&&(this._animationsEnabled&&(this._showAlwaysAnimate=!0,o.fromEvent(this._label.nativeElement,"transitionend").pipe(l.take(1)).subscribe(function(){e._showAlwaysAnimate=!1})),this.floatLabel="always",this._changeDetectorRef.markForCheck())},a.prototype._validatePlaceholders=function(){if(this._control.placeholder&&this._placeholderChild)throw p()},a.prototype._processHints=function(){this._validateHints(),this._syncDescribedByIds()},a.prototype._validateHints=function(){var e=this;if(this._hintChildren){var t,a;this._hintChildren.forEach(function(i){if("start"===i.align){if(t||e.hintLabel)throw u("start");t=i}else if("end"===i.align){if(a)throw u("end");a=i}})}},a.prototype._syncDescribedByIds=function(){if(this._control){var e=[];if("hint"===this._getDisplayedMessages()){var t=this._hintChildren?this._hintChildren.find(function(e){return"start"===e.align}):null,a=this._hintChildren?this._hintChildren.find(function(e){return"end"===e.align}):null;t?e.push(t.id):this._hintLabel&&e.push(this._hintLabelId),a&&e.push(a.id)}else this._errorChildren&&(e=this._errorChildren.map(function(e){return e.id}));this._control.setDescribedByIds(e)}},a.prototype._validateControlChild=function(){if(!this._control)throw h()},a.prototype.updateOutlineGap=function(){if("outline"===this.appearance){var e=0,t=0,a=this._connectionContainerRef.nativeElement.querySelectorAll(".mat-form-field-outline-start"),i=this._connectionContainerRef.nativeElement.querySelectorAll(".mat-form-field-outline-gap");if(this._label&&this._label.nativeElement.children.length){if(this._platform&&!this._platform.isBrowser)return;if(!document.documentElement.contains(this._elementRef.nativeElement))return;for(var r=this._getStartEnd(this._connectionContainerRef.nativeElement.getBoundingClientRect()),n=this._getStartEnd(this._label.nativeElement.children[0].getBoundingClientRect()),o=0,l=0,f=this._label.nativeElement.children;l<f.length;l++){o+=f[l].offsetWidth}e=n-r-5,t=.75*o+10}for(var m=0;m<a.length;m++)a.item(m).style.width=e+"px";for(var m=0;m<i.length;m++)i.item(m).style.width=t+"px"}},a.prototype._getStartEnd=function(e){return this._dir&&"rtl"===this._dir.value?e.right:e.left},a.decorators=[{type:t.Component,args:[{selector:"mat-form-field",exportAs:"matFormField",template:'<div class="mat-form-field-wrapper"><div class="mat-form-field-flex" #connectionContainer (click)="_control.onContainerClick && _control.onContainerClick($event)"><ng-container *ngIf="appearance == \'outline\'"><div class="mat-form-field-outline"><div class="mat-form-field-outline-start"></div><div class="mat-form-field-outline-gap"></div><div class="mat-form-field-outline-end"></div></div><div class="mat-form-field-outline mat-form-field-outline-thick"><div class="mat-form-field-outline-start"></div><div class="mat-form-field-outline-gap"></div><div class="mat-form-field-outline-end"></div></div></ng-container><div class="mat-form-field-prefix" *ngIf="_prefixChildren.length"><ng-content select="[matPrefix]"></ng-content></div><div class="mat-form-field-infix" #inputContainer><ng-content></ng-content><span class="mat-form-field-label-wrapper"><label class="mat-form-field-label" (cdkObserveContent)="updateOutlineGap()" [id]="_labelId" [attr.for]="_control.id" [attr.aria-owns]="_control.id" [class.mat-empty]="_control.empty && !_shouldAlwaysFloat" [class.mat-form-field-empty]="_control.empty && !_shouldAlwaysFloat" [class.mat-accent]="color == \'accent\'" [class.mat-warn]="color == \'warn\'" #label *ngIf="_hasFloatingLabel()" [ngSwitch]="_hasLabel()"><ng-container *ngSwitchCase="false"><ng-content select="mat-placeholder"></ng-content>{{_control.placeholder}}</ng-container><ng-content select="mat-label" *ngSwitchCase="true"></ng-content><span class="mat-placeholder-required mat-form-field-required-marker" aria-hidden="true" *ngIf="!hideRequiredMarker && _control.required && !_control.disabled">&nbsp;*</span></label></span></div><div class="mat-form-field-suffix" *ngIf="_suffixChildren.length"><ng-content select="[matSuffix]"></ng-content></div></div><div class="mat-form-field-underline" #underline *ngIf="appearance != \'outline\'"><span class="mat-form-field-ripple" [class.mat-accent]="color == \'accent\'" [class.mat-warn]="color == \'warn\'"></span></div><div class="mat-form-field-subscript-wrapper" [ngSwitch]="_getDisplayedMessages()"><div *ngSwitchCase="\'error\'" [@transitionMessages]="_subscriptAnimationState"><ng-content select="mat-error"></ng-content></div><div class="mat-form-field-hint-wrapper" *ngSwitchCase="\'hint\'" [@transitionMessages]="_subscriptAnimationState"><div *ngIf="hintLabel" [id]="_hintLabelId" class="mat-hint">{{hintLabel}}</div><ng-content select="mat-hint:not([align=\'end\'])"></ng-content><div class="mat-form-field-hint-spacer"></div><ng-content select="mat-hint[align=\'end\']"></ng-content></div></div></div>',styles:[".mat-form-field{display:inline-block;position:relative;text-align:left}[dir=rtl] .mat-form-field{text-align:right}.mat-form-field-wrapper{position:relative}.mat-form-field-flex{display:inline-flex;align-items:baseline;box-sizing:border-box;width:100%}.mat-form-field-prefix,.mat-form-field-suffix{white-space:nowrap;flex:none;position:relative}.mat-form-field-infix{display:block;position:relative;flex:auto;min-width:0;width:180px}@media screen and (-ms-high-contrast:active){.mat-form-field-infix{border-image:linear-gradient(transparent,transparent)}}.mat-form-field-label-wrapper{position:absolute;left:0;box-sizing:content-box;width:100%;height:100%;overflow:hidden;pointer-events:none}.mat-form-field-label{position:absolute;left:0;font:inherit;pointer-events:none;width:100%;white-space:nowrap;text-overflow:ellipsis;overflow:hidden;transform-origin:0 0;transition:transform .4s cubic-bezier(.25,.8,.25,1),color .4s cubic-bezier(.25,.8,.25,1),width .4s cubic-bezier(.25,.8,.25,1);display:none}[dir=rtl] .mat-form-field-label{transform-origin:100% 0;left:auto;right:0}.mat-form-field-can-float.mat-form-field-should-float .mat-form-field-label,.mat-form-field-empty.mat-form-field-label{display:block}.mat-form-field-autofill-control:-webkit-autofill+.mat-form-field-label-wrapper .mat-form-field-label{display:none}.mat-form-field-can-float .mat-form-field-autofill-control:-webkit-autofill+.mat-form-field-label-wrapper .mat-form-field-label{display:block;transition:none}.mat-input-server:focus+.mat-form-field-label-wrapper .mat-form-field-label,.mat-input-server[placeholder]:not(:placeholder-shown)+.mat-form-field-label-wrapper .mat-form-field-label{display:none}.mat-form-field-can-float .mat-input-server:focus+.mat-form-field-label-wrapper .mat-form-field-label,.mat-form-field-can-float .mat-input-server[placeholder]:not(:placeholder-shown)+.mat-form-field-label-wrapper .mat-form-field-label{display:block}.mat-form-field-label:not(.mat-form-field-empty){transition:none}.mat-form-field-underline{position:absolute;width:100%;pointer-events:none;transform:scaleY(1.0001)}.mat-form-field-ripple{position:absolute;left:0;width:100%;transform-origin:50%;transform:scaleX(.5);opacity:0;transition:background-color .3s cubic-bezier(.55,0,.55,.2)}.mat-form-field.mat-focused .mat-form-field-ripple,.mat-form-field.mat-form-field-invalid .mat-form-field-ripple{opacity:1;transform:scaleX(1);transition:transform .3s cubic-bezier(.25,.8,.25,1),opacity .1s cubic-bezier(.25,.8,.25,1),background-color .3s cubic-bezier(.25,.8,.25,1)}.mat-form-field-subscript-wrapper{position:absolute;box-sizing:border-box;width:100%;overflow:hidden}.mat-form-field-label-wrapper .mat-icon,.mat-form-field-subscript-wrapper .mat-icon{width:1em;height:1em;font-size:inherit;vertical-align:baseline}.mat-form-field-hint-wrapper{display:flex}.mat-form-field-hint-spacer{flex:1 0 1em}.mat-error{display:block}.mat-form-field._mat-animation-noopable .mat-form-field-label,.mat-form-field._mat-animation-noopable .mat-form-field-ripple{transition:none} .mat-form-field-appearance-fill .mat-form-field-flex{border-radius:4px 4px 0 0;padding:.75em .75em 0 .75em}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-fill .mat-form-field-flex{outline:solid 1px}}.mat-form-field-appearance-fill .mat-form-field-underline::before{content:'';display:block;position:absolute;bottom:0;height:1px;width:100%}.mat-form-field-appearance-fill .mat-form-field-ripple{bottom:0;height:2px}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-fill .mat-form-field-ripple{height:0;border-top:solid 2px}}.mat-form-field-appearance-fill:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-underline .mat-form-field-ripple{opacity:1;transform:none;transition:opacity .6s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-fill._mat-animation-noopable:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-underline .mat-form-field-ripple{transition:none}.mat-form-field-appearance-fill .mat-form-field-subscript-wrapper{padding:0 1em} .mat-form-field-appearance-legacy .mat-form-field-label{transform:perspective(100px);-ms-transform:none}.mat-form-field-appearance-legacy .mat-form-field-prefix .mat-icon,.mat-form-field-appearance-legacy .mat-form-field-suffix .mat-icon{width:1em}.mat-form-field-appearance-legacy .mat-form-field-prefix .mat-icon-button,.mat-form-field-appearance-legacy .mat-form-field-suffix .mat-icon-button{font:inherit;vertical-align:baseline}.mat-form-field-appearance-legacy .mat-form-field-prefix .mat-icon-button .mat-icon,.mat-form-field-appearance-legacy .mat-form-field-suffix .mat-icon-button .mat-icon{font-size:inherit}.mat-form-field-appearance-legacy .mat-form-field-underline{height:1px}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-legacy .mat-form-field-underline{height:0;border-top:solid 1px}}.mat-form-field-appearance-legacy .mat-form-field-ripple{top:0;height:2px}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-legacy .mat-form-field-ripple{height:0;border-top:solid 2px}}.mat-form-field-appearance-legacy.mat-form-field-disabled .mat-form-field-underline{background-position:0;background-color:transparent}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-legacy.mat-form-field-disabled .mat-form-field-underline{border-top-style:dotted;border-top-width:2px}}.mat-form-field-appearance-legacy.mat-form-field-invalid:not(.mat-focused) .mat-form-field-ripple{height:1px} .mat-form-field-appearance-outline .mat-form-field-wrapper{margin:.25em 0}.mat-form-field-appearance-outline .mat-form-field-flex{padding:0 .75em 0 .75em;margin-top:-.25em;position:relative}.mat-form-field-appearance-outline .mat-form-field-prefix,.mat-form-field-appearance-outline .mat-form-field-suffix{top:.25em}.mat-form-field-appearance-outline .mat-form-field-outline{display:flex;position:absolute;top:.25em;left:0;right:0;bottom:0;pointer-events:none}.mat-form-field-appearance-outline .mat-form-field-outline-end,.mat-form-field-appearance-outline .mat-form-field-outline-start{border:1px solid currentColor;min-width:5px}.mat-form-field-appearance-outline .mat-form-field-outline-start{border-radius:5px 0 0 5px;border-right-style:none}[dir=rtl] .mat-form-field-appearance-outline .mat-form-field-outline-start{border-right-style:solid;border-left-style:none;border-radius:0 5px 5px 0}.mat-form-field-appearance-outline .mat-form-field-outline-end{border-radius:0 5px 5px 0;border-left-style:none;flex-grow:1}[dir=rtl] .mat-form-field-appearance-outline .mat-form-field-outline-end{border-left-style:solid;border-right-style:none;border-radius:5px 0 0 5px}.mat-form-field-appearance-outline .mat-form-field-outline-gap{border-radius:.000001px;border:1px solid currentColor;border-left-style:none;border-right-style:none}.mat-form-field-appearance-outline.mat-form-field-can-float.mat-form-field-should-float .mat-form-field-outline-gap{border-top-color:transparent}.mat-form-field-appearance-outline .mat-form-field-outline-thick{opacity:0}.mat-form-field-appearance-outline .mat-form-field-outline-thick .mat-form-field-outline-end,.mat-form-field-appearance-outline .mat-form-field-outline-thick .mat-form-field-outline-gap,.mat-form-field-appearance-outline .mat-form-field-outline-thick .mat-form-field-outline-start{border-width:2px;transition:border-color .3s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-outline.mat-focused .mat-form-field-outline,.mat-form-field-appearance-outline.mat-form-field-invalid .mat-form-field-outline{opacity:0;transition:opacity .1s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-outline.mat-focused .mat-form-field-outline-thick,.mat-form-field-appearance-outline.mat-form-field-invalid .mat-form-field-outline-thick{opacity:1}.mat-form-field-appearance-outline:not(.mat-form-field-disabled) .mat-form-field-flex:hover .mat-form-field-outline{opacity:0;transition:opacity .6s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-outline:not(.mat-form-field-disabled) .mat-form-field-flex:hover .mat-form-field-outline-thick{opacity:1}.mat-form-field-appearance-outline .mat-form-field-subscript-wrapper{padding:0 1em}.mat-form-field-appearance-outline._mat-animation-noopable .mat-form-field-outline,.mat-form-field-appearance-outline._mat-animation-noopable .mat-form-field-outline-end,.mat-form-field-appearance-outline._mat-animation-noopable .mat-form-field-outline-gap,.mat-form-field-appearance-outline._mat-animation-noopable .mat-form-field-outline-start,.mat-form-field-appearance-outline._mat-animation-noopable:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-outline{transition:none} .mat-form-field-appearance-standard .mat-form-field-flex{padding-top:.75em}.mat-form-field-appearance-standard .mat-form-field-underline{height:1px}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-standard .mat-form-field-underline{height:0;border-top:solid 1px}}.mat-form-field-appearance-standard .mat-form-field-ripple{bottom:0;height:2px}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-standard .mat-form-field-ripple{height:0;border-top:2px}}.mat-form-field-appearance-standard.mat-form-field-disabled .mat-form-field-underline{background-position:0;background-color:transparent}@media screen and (-ms-high-contrast:active){.mat-form-field-appearance-standard.mat-form-field-disabled .mat-form-field-underline{border-top-style:dotted;border-top-width:2px}}.mat-form-field-appearance-standard:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-underline .mat-form-field-ripple{opacity:1;transform:none;transition:opacity .6s cubic-bezier(.25,.8,.25,1)}.mat-form-field-appearance-standard._mat-animation-noopable:not(.mat-form-field-disabled) .mat-form-field-flex:hover~.mat-form-field-underline .mat-form-field-ripple{transition:none} .mat-input-element{font:inherit;background:0 0;color:currentColor;border:none;outline:0;padding:0;margin:0;width:100%;max-width:100%;vertical-align:bottom;text-align:inherit}.mat-input-element:-moz-ui-invalid{box-shadow:none}.mat-input-element::-ms-clear,.mat-input-element::-ms-reveal{display:none}.mat-input-element,.mat-input-element::-webkit-search-cancel-button,.mat-input-element::-webkit-search-decoration,.mat-input-element::-webkit-search-results-button,.mat-input-element::-webkit-search-results-decoration{-webkit-appearance:none}.mat-input-element::-webkit-caps-lock-indicator,.mat-input-element::-webkit-contacts-auto-fill-button,.mat-input-element::-webkit-credentials-auto-fill-button{visibility:hidden}.mat-input-element[type=date]::after,.mat-input-element[type=datetime-local]::after,.mat-input-element[type=datetime]::after,.mat-input-element[type=month]::after,.mat-input-element[type=time]::after,.mat-input-element[type=week]::after{content:' ';white-space:pre;width:1px}.mat-input-element::placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-input-element::-moz-placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-input-element::-webkit-input-placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-input-element:-ms-input-placeholder{transition:color .4s .133s cubic-bezier(.25,.8,.25,1)}.mat-form-field-hide-placeholder .mat-input-element::placeholder{color:transparent!important;-webkit-text-fill-color:transparent;transition:none}.mat-form-field-hide-placeholder .mat-input-element::-moz-placeholder{color:transparent!important;-webkit-text-fill-color:transparent;transition:none}.mat-form-field-hide-placeholder .mat-input-element::-webkit-input-placeholder{color:transparent!important;-webkit-text-fill-color:transparent;transition:none}.mat-form-field-hide-placeholder .mat-input-element:-ms-input-placeholder{color:transparent!important;-webkit-text-fill-color:transparent;transition:none}textarea.mat-input-element{resize:vertical;overflow:auto}textarea.mat-input-element.cdk-textarea-autosize{resize:none}textarea.mat-input-element{padding:2px 0;margin:-2px 0}"],animations:[y.transitionMessages],host:{class:"mat-form-field","[class.mat-form-field-appearance-standard]":'appearance == "standard"',"[class.mat-form-field-appearance-fill]":'appearance == "fill"',"[class.mat-form-field-appearance-outline]":'appearance == "outline"',"[class.mat-form-field-appearance-legacy]":'appearance == "legacy"',"[class.mat-form-field-invalid]":"_control.errorState","[class.mat-form-field-can-float]":"_canLabelFloat","[class.mat-form-field-should-float]":"_shouldLabelFloat()","[class.mat-form-field-hide-placeholder]":"_hideControlPlaceholder()","[class.mat-form-field-disabled]":"_control.disabled","[class.mat-form-field-autofilled]":"_control.autofilled","[class.mat-focused]":"_control.focused","[class.mat-accent]":'color == "accent"',"[class.mat-warn]":'color == "warn"',"[class.ng-untouched]":'_shouldForward("untouched")',"[class.ng-touched]":'_shouldForward("touched")',"[class.ng-pristine]":'_shouldForward("pristine")',"[class.ng-dirty]":'_shouldForward("dirty")',"[class.ng-valid]":'_shouldForward("valid")',"[class.ng-invalid]":'_shouldForward("invalid")',"[class.ng-pending]":'_shouldForward("pending")',"[class._mat-animation-noopable]":"!_animationsEnabled"},inputs:["color"],encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],a.ctorParameters=function(){return[{type:t.ElementRef},{type:t.ChangeDetectorRef},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[n.MAT_LABEL_GLOBAL_OPTIONS]}]},{type:i.Directionality,decorators:[{type:t.Optional}]},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[I]}]},{type:f.Platform},{type:t.NgZone},{type:void 0,decorators:[{type:t.Optional},{type:t.Inject,args:[m.ANIMATION_MODULE_TYPE]}]}]},a.propDecorators={appearance:[{type:t.Input}],hideRequiredMarker:[{type:t.Input}],hintLabel:[{type:t.Input}],floatLabel:[{type:t.Input}],underlineRef:[{type:t.ViewChild,args:["underline"]}],_connectionContainerRef:[{type:t.ViewChild,args:["connectionContainer"]}],_inputContainerRef:[{type:t.ViewChild,args:["inputContainer"]}],_label:[{type:t.ViewChild,args:["label"]}],_control:[{type:t.ContentChild,args:[v]}],_placeholderChild:[{type:t.ContentChild,args:[k]}],_labelChild:[{type:t.ContentChild,args:[C]}],_errorChildren:[{type:t.ContentChildren,args:[_]}],_hintChildren:[{type:t.ContentChildren,args:[x]}],_prefixChildren:[{type:t.ContentChildren,args:[F]}],_suffixChildren:[{type:t.ContentChildren,args:[L]}]},a}(A),E=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{declarations:[_,D,x,C,k,F,L],imports:[d.CommonModule,s.ObserversModule],exports:[_,D,x,C,k,F,L]}]}],e}();e.MatFormFieldModule=E,e.MatError=_,e.MatFormFieldBase=O,e._MatFormFieldMixinBase=A,e.MAT_FORM_FIELD_DEFAULT_OPTIONS=I,e.MatFormField=D,e.MatFormFieldControl=v,e.getMatFormFieldPlaceholderConflictError=p,e.getMatFormFieldDuplicatedHintError=u,e.getMatFormFieldMissingControlError=h,e.MatHint=x,e.MatPlaceholder=k,e.MatPrefix=F,e.MatSuffix=L,e.MatLabel=C,e.matFormFieldAnimations=y,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-form-field.umd.min.js.map
