/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/text-field"),require("@angular/core"),require("@angular/cdk/coercion"),require("@angular/cdk/platform"),require("@angular/forms"),require("@angular/material/core"),require("@angular/material/form-field"),require("rxjs"),require("@angular/common")):"function"==typeof define&&define.amd?define("@angular/material/input",["exports","@angular/cdk/text-field","@angular/core","@angular/cdk/coercion","@angular/cdk/platform","@angular/forms","@angular/material/core","@angular/material/form-field","rxjs","@angular/common"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.input={}),e.ng.cdk.textField,e.ng.core,e.ng.cdk.coercion,e.ng.cdk.platform,e.ng.forms,e.ng.material.core,e.ng.material.formField,e.rxjs,e.ng.common)}(this,function(e,t,r,n,o,i,a,u,s,p){"use strict";function l(e,t){function r(){this.constructor=e}d(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}function c(e){return Error('Input type "'+e+"\" isn't supported by matInput.")}var d=function(e,t){return(d=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])})(e,t)},f=function(e){function t(){return null!==e&&e.apply(this,arguments)||this}return l(t,e),Object.defineProperty(t.prototype,"matAutosizeMinRows",{get:function(){return this.minRows},set:function(e){this.minRows=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"matAutosizeMaxRows",{get:function(){return this.maxRows},set:function(e){this.maxRows=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"matAutosize",{get:function(){return this.enabled},set:function(e){this.enabled=e},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"matTextareaAutosize",{get:function(){return this.enabled},set:function(e){this.enabled=e},enumerable:!0,configurable:!0}),t.decorators=[{type:r.Directive,args:[{selector:"textarea[mat-autosize], textarea[matTextareaAutosize]",exportAs:"matTextareaAutosize",inputs:["cdkAutosizeMinRows","cdkAutosizeMaxRows"],host:{class:"cdk-textarea-autosize mat-autosize",rows:"1","(input)":"_noopInputHandler()"}}]}],t.propDecorators={matAutosizeMinRows:[{type:r.Input}],matAutosizeMaxRows:[{type:r.Input}],matAutosize:[{type:r.Input,args:["mat-autosize"]}],matTextareaAutosize:[{type:r.Input}]},t}(t.CdkTextareaAutosize),y=new r.InjectionToken("MAT_INPUT_VALUE_ACCESSOR"),m=["button","checkbox","file","hidden","image","radio","range","reset","submit"],h=0,g=function(){function e(e,t,r,n){this._defaultErrorStateMatcher=e,this._parentForm=t,this._parentFormGroup=r,this.ngControl=n}return e}(),_=a.mixinErrorState(g),b=function(e){function p(t,r,n,i,a,u,p,l,c){var d=e.call(this,u,i,a,n)||this;return d._elementRef=t,d._platform=r,d.ngControl=n,d._autofillMonitor=l,d._uid="mat-input-"+h++,d._isServer=!1,d.focused=!1,d.stateChanges=new s.Subject,d.controlType="mat-input",d.autofilled=!1,d._disabled=!1,d._required=!1,d._type="text",d._readonly=!1,d._neverEmptyInputTypes=["date","datetime","datetime-local","month","time","week"].filter(function(e){return o.getSupportedInputTypes().has(e)}),d._inputValueAccessor=p||d._elementRef.nativeElement,d._previousNativeValue=d.value,d.id=d.id,r.IOS&&c.runOutsideAngular(function(){t.nativeElement.addEventListener("keyup",function(e){var t=e.target;t.value||t.selectionStart||t.selectionEnd||(t.setSelectionRange(1,1),t.setSelectionRange(0,0))})}),d._isServer=!d._platform.isBrowser,d}return l(p,e),Object.defineProperty(p.prototype,"disabled",{get:function(){return this.ngControl&&null!==this.ngControl.disabled?this.ngControl.disabled:this._disabled},set:function(e){this._disabled=n.coerceBooleanProperty(e),this.focused&&(this.focused=!1,this.stateChanges.next())},enumerable:!0,configurable:!0}),Object.defineProperty(p.prototype,"id",{get:function(){return this._id},set:function(e){this._id=e||this._uid},enumerable:!0,configurable:!0}),Object.defineProperty(p.prototype,"required",{get:function(){return this._required},set:function(e){this._required=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(p.prototype,"type",{get:function(){return this._type},set:function(e){this._type=e||"text",this._validateType(),!this._isTextarea()&&o.getSupportedInputTypes().has(this._type)&&(this._elementRef.nativeElement.type=this._type)},enumerable:!0,configurable:!0}),Object.defineProperty(p.prototype,"value",{get:function(){return this._inputValueAccessor.value},set:function(e){e!==this.value&&(this._inputValueAccessor.value=e,this.stateChanges.next())},enumerable:!0,configurable:!0}),Object.defineProperty(p.prototype,"readonly",{get:function(){return this._readonly},set:function(e){this._readonly=n.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),p.prototype.ngOnInit=function(){var e=this;this._autofillMonitor.monitor(this._elementRef.nativeElement).subscribe(function(t){e.autofilled=t.isAutofilled,e.stateChanges.next()})},p.prototype.ngOnChanges=function(){this.stateChanges.next()},p.prototype.ngOnDestroy=function(){this.stateChanges.complete(),this._autofillMonitor.stopMonitoring(this._elementRef.nativeElement)},p.prototype.ngDoCheck=function(){this.ngControl&&this.updateErrorState(),this._dirtyCheckNativeValue()},p.prototype.focus=function(){this._elementRef.nativeElement.focus()},p.prototype._focusChanged=function(e){e===this.focused||this.readonly||(this.focused=e,this.stateChanges.next())},p.prototype._onInput=function(){},p.prototype._dirtyCheckNativeValue=function(){var e=this.value;this._previousNativeValue!==e&&(this._previousNativeValue=e,this.stateChanges.next())},p.prototype._validateType=function(){if(m.indexOf(this._type)>-1)throw c(this._type)},p.prototype._isNeverEmpty=function(){return this._neverEmptyInputTypes.indexOf(this._type)>-1},p.prototype._isBadInput=function(){var e=this._elementRef.nativeElement.validity;return e&&e.badInput},p.prototype._isTextarea=function(){return"textarea"===this._elementRef.nativeElement.nodeName.toLowerCase()},Object.defineProperty(p.prototype,"empty",{get:function(){return!(this._isNeverEmpty()||this._elementRef.nativeElement.value||this._isBadInput()||this.autofilled)},enumerable:!0,configurable:!0}),Object.defineProperty(p.prototype,"shouldLabelFloat",{get:function(){return this.focused||!this.empty},enumerable:!0,configurable:!0}),p.prototype.setDescribedByIds=function(e){this._ariaDescribedby=e.join(" ")},p.prototype.onContainerClick=function(){this.focus()},p.decorators=[{type:r.Directive,args:[{selector:"input[matInput], textarea[matInput]",exportAs:"matInput",host:{class:"mat-input-element mat-form-field-autofill-control","[class.mat-input-server]":"_isServer","[attr.id]":"id","[attr.placeholder]":"placeholder","[disabled]":"disabled","[required]":"required","[readonly]":"readonly","[attr.aria-describedby]":"_ariaDescribedby || null","[attr.aria-invalid]":"errorState","[attr.aria-required]":"required.toString()","(blur)":"_focusChanged(false)","(focus)":"_focusChanged(true)","(input)":"_onInput()"},providers:[{provide:u.MatFormFieldControl,useExisting:p}]}]}],p.ctorParameters=function(){return[{type:r.ElementRef},{type:o.Platform},{type:i.NgControl,decorators:[{type:r.Optional},{type:r.Self}]},{type:i.NgForm,decorators:[{type:r.Optional}]},{type:i.FormGroupDirective,decorators:[{type:r.Optional}]},{type:a.ErrorStateMatcher},{type:void 0,decorators:[{type:r.Optional},{type:r.Self},{type:r.Inject,args:[y]}]},{type:t.AutofillMonitor},{type:r.NgZone}]},p.propDecorators={disabled:[{type:r.Input}],id:[{type:r.Input}],placeholder:[{type:r.Input}],required:[{type:r.Input}],type:[{type:r.Input}],errorStateMatcher:[{type:r.Input}],value:[{type:r.Input}],readonly:[{type:r.Input}]},p}(_),v=function(){function e(){}return e.decorators=[{type:r.NgModule,args:[{declarations:[b,f],imports:[p.CommonModule,t.TextFieldModule,u.MatFormFieldModule],exports:[t.TextFieldModule,u.MatFormFieldModule,b,f],providers:[a.ErrorStateMatcher]}]}],e}();e.MatTextareaAutosize=f,e.MatInputBase=g,e._MatInputMixinBase=_,e.MatInput=b,e.getMatInputUnsupportedTypeError=c,e.MatInputModule=v,e.MAT_INPUT_VALUE_ACCESSOR=y,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-input.umd.min.js.map
