/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("rxjs"),require("@angular/cdk/coercion"),require("@angular/material/core"),require("@angular/common"),require("@angular/material/button"),require("@angular/material/select"),require("@angular/material/tooltip")):"function"==typeof define&&define.amd?define("@angular/material/paginator",["exports","@angular/core","rxjs","@angular/cdk/coercion","@angular/material/core","@angular/common","@angular/material/button","@angular/material/select","@angular/material/tooltip"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.paginator={}),e.ng.core,e.rxjs,e.ng.cdk.coercion,e.ng.material.core,e.ng.common,e.ng.material.button,e.ng.material.select,e.ng.material.tooltip)}(this,function(e,t,a,i,n,o,r,s,p){"use strict";function g(e,t){function a(){this.constructor=e}c(e,t),e.prototype=null===t?Object.create(t):(a.prototype=t.prototype,new a)}function l(e){return e||new u}var c=function(e,t){return(c=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var a in t)t.hasOwnProperty(a)&&(e[a]=t[a])})(e,t)},u=function(){function e(){this.changes=new a.Subject,this.itemsPerPageLabel="Items per page:",this.nextPageLabel="Next page",this.previousPageLabel="Previous page",this.firstPageLabel="First page",this.lastPageLabel="Last page",this.getRangeLabel=function(e,t,a){if(0==a||0==t)return"0 of "+a;a=Math.max(a,0);var i=e*t;return i+1+" - "+(i<a?Math.min(i+t,a):i+t)+" of "+a}}return e.decorators=[{type:t.Injectable,args:[{providedIn:"root"}]}],e.ngInjectableDef=t.defineInjectable({factory:function(){return new e},token:e,providedIn:"root"}),e}(),h={provide:u,deps:[[new t.Optional,new t.SkipSelf,u]],useFactory:l},d=function(){function e(){}return e}(),m=function(){function e(){}return e}(),f=n.mixinInitialized(m),P=function(e){function a(a,i){var n=e.call(this)||this;return n._intl=a,n._changeDetectorRef=i,n._pageIndex=0,n._length=0,n._pageSizeOptions=[],n._hidePageSize=!1,n._showFirstLastButtons=!1,n.page=new t.EventEmitter,n._intlChanges=a.changes.subscribe(function(){return n._changeDetectorRef.markForCheck()}),n}return g(a,e),Object.defineProperty(a.prototype,"pageIndex",{get:function(){return this._pageIndex},set:function(e){this._pageIndex=Math.max(i.coerceNumberProperty(e),0),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"length",{get:function(){return this._length},set:function(e){this._length=i.coerceNumberProperty(e),this._changeDetectorRef.markForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"pageSize",{get:function(){return this._pageSize},set:function(e){this._pageSize=Math.max(i.coerceNumberProperty(e),0),this._updateDisplayedPageSizeOptions()},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"pageSizeOptions",{get:function(){return this._pageSizeOptions},set:function(e){this._pageSizeOptions=(e||[]).map(function(e){return i.coerceNumberProperty(e)}),this._updateDisplayedPageSizeOptions()},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"hidePageSize",{get:function(){return this._hidePageSize},set:function(e){this._hidePageSize=i.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(a.prototype,"showFirstLastButtons",{get:function(){return this._showFirstLastButtons},set:function(e){this._showFirstLastButtons=i.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),a.prototype.ngOnInit=function(){this._initialized=!0,this._updateDisplayedPageSizeOptions(),this._markInitialized()},a.prototype.ngOnDestroy=function(){this._intlChanges.unsubscribe()},a.prototype.nextPage=function(){if(this.hasNextPage()){var e=this.pageIndex;this.pageIndex++,this._emitPageEvent(e)}},a.prototype.previousPage=function(){if(this.hasPreviousPage()){var e=this.pageIndex;this.pageIndex--,this._emitPageEvent(e)}},a.prototype.firstPage=function(){if(this.hasPreviousPage()){var e=this.pageIndex;this.pageIndex=0,this._emitPageEvent(e)}},a.prototype.lastPage=function(){if(this.hasNextPage()){var e=this.pageIndex;this.pageIndex=this.getNumberOfPages(),this._emitPageEvent(e)}},a.prototype.hasPreviousPage=function(){return this.pageIndex>=1&&0!=this.pageSize},a.prototype.hasNextPage=function(){var e=this.getNumberOfPages();return this.pageIndex<e&&0!=this.pageSize},a.prototype.getNumberOfPages=function(){return Math.ceil(this.length/this.pageSize)-1},a.prototype._changePageSize=function(e){var t=this.pageIndex*this.pageSize,a=this.pageIndex;this.pageIndex=Math.floor(t/e)||0,this.pageSize=e,this._emitPageEvent(a)},a.prototype._updateDisplayedPageSizeOptions=function(){this._initialized&&(this.pageSize||(this._pageSize=0!=this.pageSizeOptions.length?this.pageSizeOptions[0]:50),this._displayedPageSizeOptions=this.pageSizeOptions.slice(),-1===this._displayedPageSizeOptions.indexOf(this.pageSize)&&this._displayedPageSizeOptions.push(this.pageSize),this._displayedPageSizeOptions.sort(function(e,t){return e-t}),this._changeDetectorRef.markForCheck())},a.prototype._emitPageEvent=function(e){this.page.emit({previousPageIndex:e,pageIndex:this.pageIndex,pageSize:this.pageSize,length:this.length})},a.decorators=[{type:t.Component,args:[{selector:"mat-paginator",exportAs:"matPaginator",template:'<div class="mat-paginator-container"><div class="mat-paginator-page-size" *ngIf="!hidePageSize"><div class="mat-paginator-page-size-label">{{_intl.itemsPerPageLabel}}</div><mat-form-field *ngIf="_displayedPageSizeOptions.length > 1" class="mat-paginator-page-size-select"><mat-select [value]="pageSize" [aria-label]="_intl.itemsPerPageLabel" (selectionChange)="_changePageSize($event.value)"><mat-option *ngFor="let pageSizeOption of _displayedPageSizeOptions" [value]="pageSizeOption">{{pageSizeOption}}</mat-option></mat-select></mat-form-field><div *ngIf="_displayedPageSizeOptions.length <= 1">{{pageSize}}</div></div><div class="mat-paginator-range-actions"><div class="mat-paginator-range-label">{{_intl.getRangeLabel(pageIndex, pageSize, length)}}</div><button mat-icon-button type="button" class="mat-paginator-navigation-first" (click)="firstPage()" [attr.aria-label]="_intl.firstPageLabel" [matTooltip]="_intl.firstPageLabel" [matTooltipDisabled]="!hasPreviousPage()" [matTooltipPosition]="\'above\'" [disabled]="!hasPreviousPage()" *ngIf="showFirstLastButtons"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M18.41 16.59L13.82 12l4.59-4.59L17 6l-6 6 6 6zM6 6h2v12H6z"/></svg></button> <button mat-icon-button type="button" class="mat-paginator-navigation-previous" (click)="previousPage()" [attr.aria-label]="_intl.previousPageLabel" [matTooltip]="_intl.previousPageLabel" [matTooltipDisabled]="!hasPreviousPage()" [matTooltipPosition]="\'above\'" [disabled]="!hasPreviousPage()"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M15.41 7.41L14 6l-6 6 6 6 1.41-1.41L10.83 12z"/></svg></button> <button mat-icon-button type="button" class="mat-paginator-navigation-next" (click)="nextPage()" [attr.aria-label]="_intl.nextPageLabel" [matTooltip]="_intl.nextPageLabel" [matTooltipDisabled]="!hasNextPage()" [matTooltipPosition]="\'above\'" [disabled]="!hasNextPage()"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6z"/></svg></button> <button mat-icon-button type="button" class="mat-paginator-navigation-last" (click)="lastPage()" [attr.aria-label]="_intl.lastPageLabel" [matTooltip]="_intl.lastPageLabel" [matTooltipDisabled]="!hasNextPage()" [matTooltipPosition]="\'above\'" [disabled]="!hasNextPage()" *ngIf="showFirstLastButtons"><svg class="mat-paginator-icon" viewBox="0 0 24 24" focusable="false"><path d="M5.59 7.41L10.18 12l-4.59 4.59L7 18l6-6-6-6zM16 6h2v12h-2z"/></svg></button></div></div>',styles:[".mat-paginator{display:block}.mat-paginator-container{display:flex;align-items:center;justify-content:flex-end;min-height:56px;padding:0 8px;flex-wrap:wrap-reverse}.mat-paginator-page-size{display:flex;align-items:baseline;margin-right:8px}[dir=rtl] .mat-paginator-page-size{margin-right:0;margin-left:8px}.mat-paginator-page-size-label{margin:0 4px}.mat-paginator-page-size-select{margin:6px 4px 0 4px;width:56px}.mat-paginator-page-size-select.mat-form-field-appearance-outline{width:64px}.mat-paginator-page-size-select.mat-form-field-appearance-fill{width:64px}.mat-paginator-range-label{margin:0 32px 0 24px}.mat-paginator-range-actions{display:flex;align-items:center;min-height:48px}.mat-paginator-icon{width:28px;fill:currentColor}[dir=rtl] .mat-paginator-icon{transform:rotate(180deg)}"],host:{class:"mat-paginator"},changeDetection:t.ChangeDetectionStrategy.OnPush,encapsulation:t.ViewEncapsulation.None}]}],a.ctorParameters=function(){return[{type:u},{type:t.ChangeDetectorRef}]},a.propDecorators={pageIndex:[{type:t.Input}],length:[{type:t.Input}],pageSize:[{type:t.Input}],pageSizeOptions:[{type:t.Input}],hidePageSize:[{type:t.Input}],showFirstLastButtons:[{type:t.Input}],page:[{type:t.Output}]},a}(f),b=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[o.CommonModule,r.MatButtonModule,s.MatSelectModule,p.MatTooltipModule],exports:[P],declarations:[P],providers:[h]}]}],e}();e.MatPaginatorModule=b,e.PageEvent=d,e.MatPaginatorBase=m,e._MatPaginatorBase=f,e.MatPaginator=P,e.MatPaginatorIntl=u,e.MAT_PAGINATOR_INTL_PROVIDER_FACTORY=l,e.MAT_PAGINATOR_INTL_PROVIDER=h,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-paginator.umd.min.js.map
