/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/cdk/a11y"),require("@angular/cdk/coercion"),require("@angular/cdk/collections"),require("@angular/core"),require("@angular/forms"),require("@angular/material/core"),require("@angular/platform-browser/animations"),require("@angular/common")):"function"==typeof define&&define.amd?define("@angular/material/radio",["exports","@angular/cdk/a11y","@angular/cdk/coercion","@angular/cdk/collections","@angular/core","@angular/forms","@angular/material/core","@angular/platform-browser/animations","@angular/common"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.radio={}),e.ng.cdk.a11y,e.ng.cdk.coercion,e.ng.cdk.collections,e.ng.core,e.ng.forms,e.ng.material.core,e.ng.platformBrowser.animations,e.ng.common)}(this,function(e,t,i,o,r,n,a,s,c){"use strict";function l(e,t){function i(){this.constructor=e}u(e,t),e.prototype=null===t?Object.create(t):(i.prototype=t.prototype,new i)}var u=function(e,t){return(u=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var i in t)t.hasOwnProperty(i)&&(e[i]=t[i])})(e,t)},d=0,p={provide:n.NG_VALUE_ACCESSOR,useExisting:r.forwardRef(function(){return b}),multi:!0},h=function(){function e(e,t){this.source=e,this.value=t}return e}(),m=function(){function e(){}return e}(),f=a.mixinDisabled(m),b=function(e){function t(t){var i=e.call(this)||this;return i._changeDetector=t,i._value=null,i._name="mat-radio-group-"+d++,i._selected=null,i._isInitialized=!1,i._labelPosition="after",i._disabled=!1,i._required=!1,i._controlValueAccessorChangeFn=function(){},i.onTouched=function(){},i.change=new r.EventEmitter,i}return l(t,e),Object.defineProperty(t.prototype,"name",{get:function(){return this._name},set:function(e){this._name=e,this._updateRadioButtonNames()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"labelPosition",{get:function(){return this._labelPosition},set:function(e){this._labelPosition="before"===e?"before":"after",this._markRadiosForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"value",{get:function(){return this._value},set:function(e){this._value!==e&&(this._value=e,this._updateSelectedRadioFromValue(),this._checkSelectedRadioButton())},enumerable:!0,configurable:!0}),t.prototype._checkSelectedRadioButton=function(){this._selected&&!this._selected.checked&&(this._selected.checked=!0)},Object.defineProperty(t.prototype,"selected",{get:function(){return this._selected},set:function(e){this._selected=e,this.value=e?e.value:null,this._checkSelectedRadioButton()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"disabled",{get:function(){return this._disabled},set:function(e){this._disabled=i.coerceBooleanProperty(e),this._markRadiosForCheck()},enumerable:!0,configurable:!0}),Object.defineProperty(t.prototype,"required",{get:function(){return this._required},set:function(e){this._required=i.coerceBooleanProperty(e),this._markRadiosForCheck()},enumerable:!0,configurable:!0}),t.prototype.ngAfterContentInit=function(){this._isInitialized=!0},t.prototype._touch=function(){this.onTouched&&this.onTouched()},t.prototype._updateRadioButtonNames=function(){var e=this;this._radios&&this._radios.forEach(function(t){t.name=e.name})},t.prototype._updateSelectedRadioFromValue=function(){var e=this,t=null!==this._selected&&this._selected.value===this._value;this._radios&&!t&&(this._selected=null,this._radios.forEach(function(t){t.checked=e.value===t.value,t.checked&&(e._selected=t)}))},t.prototype._emitChangeEvent=function(){this._isInitialized&&this.change.emit(new h(this._selected,this._value))},t.prototype._markRadiosForCheck=function(){this._radios&&this._radios.forEach(function(e){return e._markForCheck()})},t.prototype.writeValue=function(e){this.value=e,this._changeDetector.markForCheck()},t.prototype.registerOnChange=function(e){this._controlValueAccessorChangeFn=e},t.prototype.registerOnTouched=function(e){this.onTouched=e},t.prototype.setDisabledState=function(e){this.disabled=e,this._changeDetector.markForCheck()},t.decorators=[{type:r.Directive,args:[{selector:"mat-radio-group",exportAs:"matRadioGroup",providers:[p],host:{role:"radiogroup",class:"mat-radio-group"},inputs:["disabled"]}]}],t.ctorParameters=function(){return[{type:r.ChangeDetectorRef}]},t.propDecorators={change:[{type:r.Output}],_radios:[{type:r.ContentChildren,args:[r.forwardRef(function(){return y}),{descendants:!0}]}],name:[{type:r.Input}],labelPosition:[{type:r.Input}],value:[{type:r.Input}],selected:[{type:r.Input}],disabled:[{type:r.Input}],required:[{type:r.Input}]},t}(f),_=function(){function e(e){this._elementRef=e}return e}(),g=a.mixinColor(a.mixinDisableRipple(a.mixinTabIndex(_)),"accent"),y=function(e){function n(t,i,o,n,a,s){var c=e.call(this,i)||this;return c._changeDetector=o,c._focusMonitor=n,c._radioDispatcher=a,c._animationMode=s,c._uniqueId="mat-radio-"+ ++d,c.id=c._uniqueId,c.change=new r.EventEmitter,c._checked=!1,c._value=null,c._removeUniqueSelectionListener=function(){},c.radioGroup=t,c._removeUniqueSelectionListener=a.listen(function(e,t){e!==c.id&&t===c.name&&(c.checked=!1)}),c}return l(n,e),Object.defineProperty(n.prototype,"checked",{get:function(){return this._checked},set:function(e){var t=i.coerceBooleanProperty(e);this._checked!==t&&(this._checked=t,t&&this.radioGroup&&this.radioGroup.value!==this.value?this.radioGroup.selected=this:!t&&this.radioGroup&&this.radioGroup.value===this.value&&(this.radioGroup.selected=null),t&&this._radioDispatcher.notify(this.id,this.name),this._changeDetector.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"value",{get:function(){return this._value},set:function(e){this._value!==e&&(this._value=e,null!==this.radioGroup&&(this.checked||(this.checked=this.radioGroup.value===e),this.checked&&(this.radioGroup.selected=this)))},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"labelPosition",{get:function(){return this._labelPosition||this.radioGroup&&this.radioGroup.labelPosition||"after"},set:function(e){this._labelPosition=e},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"disabled",{get:function(){return this._disabled||null!==this.radioGroup&&this.radioGroup.disabled},set:function(e){var t=i.coerceBooleanProperty(e);this._disabled!==t&&(this._disabled=t,this._changeDetector.markForCheck())},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"required",{get:function(){return this._required||this.radioGroup&&this.radioGroup.required},set:function(e){this._required=i.coerceBooleanProperty(e)},enumerable:!0,configurable:!0}),Object.defineProperty(n.prototype,"inputId",{get:function(){return(this.id||this._uniqueId)+"-input"},enumerable:!0,configurable:!0}),n.prototype.focus=function(){this._focusMonitor.focusVia(this._inputElement.nativeElement,"keyboard")},n.prototype._markForCheck=function(){this._changeDetector.markForCheck()},n.prototype.ngOnInit=function(){this.radioGroup&&(this.checked=this.radioGroup.value===this._value,this.name=this.radioGroup.name)},n.prototype.ngAfterViewInit=function(){var e=this;this._focusMonitor.monitor(this._inputElement.nativeElement).subscribe(function(t){return e._onInputFocusChange(t)})},n.prototype.ngOnDestroy=function(){this._focusMonitor.stopMonitoring(this._inputElement.nativeElement),this._removeUniqueSelectionListener()},n.prototype._emitChangeEvent=function(){this.change.emit(new h(this,this._value))},n.prototype._isRippleDisabled=function(){return this.disableRipple||this.disabled},n.prototype._onInputClick=function(e){e.stopPropagation()},n.prototype._onInputChange=function(e){e.stopPropagation();var t=this.radioGroup&&this.value!==this.radioGroup.value;this.checked=!0,this._emitChangeEvent(),this.radioGroup&&(this.radioGroup._controlValueAccessorChangeFn(this.value),this.radioGroup._touch(),t&&this.radioGroup._emitChangeEvent())},n.prototype._onInputFocusChange=function(e){this._focusRipple||"keyboard"!==e?e||(this.radioGroup&&this.radioGroup._touch(),this._focusRipple&&(this._focusRipple.fadeOut(),this._focusRipple=null)):this._focusRipple=this._ripple.launch(0,0,{persistent:!0})},n.decorators=[{type:r.Component,args:[{selector:"mat-radio-button",template:'<label [attr.for]="inputId" class="mat-radio-label" #label><div class="mat-radio-container"><div class="mat-radio-outer-circle"></div><div class="mat-radio-inner-circle"></div><div mat-ripple class="mat-radio-ripple" [matRippleTrigger]="label" [matRippleDisabled]="_isRippleDisabled()" [matRippleCentered]="true" [matRippleRadius]="23" [matRippleAnimation]="{enterDuration: 150}"></div></div><input #input class="mat-radio-input cdk-visually-hidden" type="radio" [id]="inputId" [checked]="checked" [disabled]="disabled" [tabIndex]="tabIndex" [attr.name]="name" [required]="required" [attr.aria-label]="ariaLabel" [attr.aria-labelledby]="ariaLabelledby" [attr.aria-describedby]="ariaDescribedby" (change)="_onInputChange($event)" (click)="_onInputClick($event)"><div class="mat-radio-label-content" [class.mat-radio-label-before]="labelPosition == \'before\'"><span style="display:none">&nbsp;</span><ng-content></ng-content></div></label>',styles:[".mat-radio-button{display:inline-block;-webkit-tap-highlight-color:transparent}.mat-radio-label{cursor:pointer;display:inline-flex;align-items:center;white-space:nowrap;vertical-align:middle}.mat-radio-container{box-sizing:border-box;display:inline-block;position:relative;width:20px;height:20px;flex-shrink:0}.mat-radio-outer-circle{box-sizing:border-box;height:20px;left:0;position:absolute;top:0;transition:border-color ease 280ms;width:20px;border-width:2px;border-style:solid;border-radius:50%}._mat-animation-noopable .mat-radio-outer-circle{transition:none}.mat-radio-inner-circle{border-radius:50%;box-sizing:border-box;height:20px;left:0;position:absolute;top:0;transition:transform ease 280ms,background-color ease 280ms;width:20px;transform:scale(.001)}._mat-animation-noopable .mat-radio-inner-circle{transition:none}.mat-radio-checked .mat-radio-inner-circle{transform:scale(.5)}@media screen and (-ms-high-contrast:active){.mat-radio-checked .mat-radio-inner-circle{border:solid 10px}}.mat-radio-label-content{display:inline-block;order:0;line-height:inherit;padding-left:8px;padding-right:0}[dir=rtl] .mat-radio-label-content{padding-right:8px;padding-left:0}.mat-radio-label-content.mat-radio-label-before{order:-1;padding-left:0;padding-right:8px}[dir=rtl] .mat-radio-label-content.mat-radio-label-before{padding-right:0;padding-left:8px}.mat-radio-disabled,.mat-radio-disabled .mat-radio-label{cursor:default}.mat-radio-ripple{position:absolute;left:calc(50% - 25px);top:calc(50% - 25px);height:50px;width:50px;z-index:1;pointer-events:none}"],inputs:["color","disableRipple","tabIndex"],encapsulation:r.ViewEncapsulation.None,exportAs:"matRadioButton",host:{class:"mat-radio-button","[class.mat-radio-checked]":"checked","[class.mat-radio-disabled]":"disabled","[class._mat-animation-noopable]":'_animationMode === "NoopAnimations"',"[attr.id]":"id","(focus)":"_inputElement.nativeElement.focus()"},changeDetection:r.ChangeDetectionStrategy.OnPush}]}],n.ctorParameters=function(){return[{type:b,decorators:[{type:r.Optional}]},{type:r.ElementRef},{type:r.ChangeDetectorRef},{type:t.FocusMonitor},{type:o.UniqueSelectionDispatcher},{type:void 0,decorators:[{type:r.Optional},{type:r.Inject,args:[s.ANIMATION_MODULE_TYPE]}]}]},n.propDecorators={id:[{type:r.Input}],name:[{type:r.Input}],ariaLabel:[{type:r.Input,args:["aria-label"]}],ariaLabelledby:[{type:r.Input,args:["aria-labelledby"]}],ariaDescribedby:[{type:r.Input,args:["aria-describedby"]}],checked:[{type:r.Input}],value:[{type:r.Input}],labelPosition:[{type:r.Input}],disabled:[{type:r.Input}],required:[{type:r.Input}],change:[{type:r.Output}],_ripple:[{type:r.ViewChild,args:[a.MatRipple]}],_inputElement:[{type:r.ViewChild,args:["input"]}]},n}(g),v=function(){function e(){}return e.decorators=[{type:r.NgModule,args:[{imports:[c.CommonModule,a.MatRippleModule,a.MatCommonModule],exports:[b,y,a.MatCommonModule],declarations:[b,y]}]}],e}();e.MatRadioModule=v,e.MAT_RADIO_GROUP_CONTROL_VALUE_ACCESSOR=p,e.MatRadioChange=h,e.MatRadioGroupBase=m,e._MatRadioGroupMixinBase=f,e.MatRadioGroup=b,e.MatRadioButtonBase=_,e._MatRadioButtonMixinBase=g,e.MatRadioButton=y,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-radio.umd.min.js.map
