/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@angular/core"),require("@angular/cdk/stepper"),require("rxjs"),require("@angular/cdk/a11y"),require("@angular/animations"),require("@angular/cdk/bidi"),require("@angular/material/core"),require("rxjs/operators"),require("@angular/cdk/portal"),require("@angular/common"),require("@angular/material/button"),require("@angular/material/icon")):"function"==typeof define&&define.amd?define("@angular/material/stepper",["exports","@angular/core","@angular/cdk/stepper","rxjs","@angular/cdk/a11y","@angular/animations","@angular/cdk/bidi","@angular/material/core","rxjs/operators","@angular/cdk/portal","@angular/common","@angular/material/button","@angular/material/icon"],t):t((e.ng=e.ng||{},e.ng.material=e.ng.material||{},e.ng.material.stepper={}),e.ng.core,e.ng.cdk.stepper,e.rxjs,e.ng.cdk.a11y,e.ng.animations,e.ng.cdk.bidi,e.ng.material.core,e.rxjs.operators,e.ng.cdk.portal,e.ng.common,e.ng.material.button,e.ng.material.icon)}(this,function(e,t,n,r,a,i,o,p,s,l,c,d,m){"use strict";function u(e,t){function n(){this.constructor=e}h(e,t),e.prototype=null===t?Object.create(t):(n.prototype=t.prototype,new n)}var h=function(e,t){return(h=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var n in t)t.hasOwnProperty(n)&&(e[n]=t[n])})(e,t)},g=function(e){function n(t){return e.call(this,t)||this}return u(n,e),n.decorators=[{type:t.Directive,args:[{selector:"[matStepLabel]"}]}],n.ctorParameters=function(){return[{type:t.TemplateRef}]},n}(n.CdkStepLabel),v=function(){function e(){this.changes=new r.Subject,this.optionalLabel="Optional"}return e.decorators=[{type:t.Injectable,args:[{providedIn:"root"}]}],e.ngInjectableDef=t.defineInjectable({factory:function(){return new e},token:e,providedIn:"root"}),e}(),f=function(){function e(e,t,n,r){this._intl=e,this._focusMonitor=t,this._element=n,t.monitor(n.nativeElement,!0),this._intlSubscription=e.changes.subscribe(function(){return r.markForCheck()})}return e.prototype.ngOnDestroy=function(){this._intlSubscription.unsubscribe(),this._focusMonitor.stopMonitoring(this._element.nativeElement)},e.prototype._stringLabel=function(){return this.label instanceof g?null:this.label},e.prototype._templateLabel=function(){return this.label instanceof g?this.label:null},e.prototype._getHostElement=function(){return this._element.nativeElement},e.prototype._getIconContext=function(){return{index:this.index,active:this.active,optional:this.optional}},e.prototype.focus=function(){this._getHostElement().focus()},e.decorators=[{type:t.Component,args:[{selector:"mat-step-header",template:'<div class="mat-step-header-ripple" mat-ripple [matRippleTrigger]="_getHostElement()"></div><div [class.mat-step-icon]="state !== \'number\' || selected" [class.mat-step-icon-not-touched]="state == \'number\' && !selected" [ngSwitch]="state"><ng-container *ngSwitchCase="\'number\'" [ngSwitch]="!!(iconOverrides && iconOverrides.number)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.number" [ngTemplateOutletContext]="_getIconContext()"></ng-container><span *ngSwitchDefault>{{index + 1}}</span></ng-container><ng-container *ngSwitchCase="\'edit\'" [ngSwitch]="!!(iconOverrides && iconOverrides.edit)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.edit" [ngTemplateOutletContext]="_getIconContext()"></ng-container><mat-icon *ngSwitchDefault>create</mat-icon></ng-container><ng-container *ngSwitchCase="\'done\'" [ngSwitch]="!!(iconOverrides && iconOverrides.done)"><ng-container *ngSwitchCase="true" [ngTemplateOutlet]="iconOverrides.done" [ngTemplateOutletContext]="_getIconContext()"></ng-container><mat-icon *ngSwitchDefault>done</mat-icon></ng-container></div><div class="mat-step-label" [class.mat-step-label-active]="active" [class.mat-step-label-selected]="selected"><ng-container *ngIf="_templateLabel()" [ngTemplateOutlet]="_templateLabel()!.template"></ng-container><div class="mat-step-text-label" *ngIf="_stringLabel()">{{label}}</div><div class="mat-step-optional" *ngIf="optional">{{_intl.optionalLabel}}</div></div>',styles:[".mat-step-header{overflow:hidden;outline:0;cursor:pointer;position:relative;box-sizing:content-box;-webkit-tap-highlight-color:transparent}.mat-step-optional{font-size:12px}.mat-step-icon,.mat-step-icon-not-touched{border-radius:50%;height:24px;width:24px;align-items:center;justify-content:center;display:flex;flex-shrink:0}.mat-step-icon .mat-icon{font-size:16px;height:16px;width:16px}.mat-step-label{display:inline-block;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;min-width:50px;vertical-align:middle}.mat-step-text-label{text-overflow:ellipsis;overflow:hidden}.mat-step-header-ripple{top:0;left:0;right:0;bottom:0;position:absolute;pointer-events:none}"],host:{class:"mat-step-header",role:"tab"},encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],e.ctorParameters=function(){return[{type:v},{type:a.FocusMonitor},{type:t.ElementRef},{type:t.ChangeDetectorRef}]},e.propDecorators={state:[{type:t.Input}],label:[{type:t.Input}],iconOverrides:[{type:t.Input}],index:[{type:t.Input}],selected:[{type:t.Input}],active:[{type:t.Input}],optional:[{type:t.Input}]},e}(),b={horizontalStepTransition:i.trigger("stepTransition",[i.state("previous",i.style({transform:"translate3d(-100%, 0, 0)",visibility:"hidden"})),i.state("current",i.style({transform:"none",visibility:"visible"})),i.state("next",i.style({transform:"translate3d(100%, 0, 0)",visibility:"hidden"})),i.transition("* => *",i.animate("500ms cubic-bezier(0.35, 0, 0.25, 1)"))]),verticalStepTransition:i.trigger("stepTransition",[i.state("previous",i.style({height:"0px",visibility:"hidden"})),i.state("next",i.style({height:"0px",visibility:"hidden"})),i.state("current",i.style({height:"*",visibility:"visible"})),i.transition("* <=> current",i.animate("225ms cubic-bezier(0.4, 0.0, 0.2, 1)"))])},x=function(){function e(e){this.templateRef=e}return e.decorators=[{type:t.Directive,args:[{selector:"ng-template[matStepperIcon]"}]}],e.ctorParameters=function(){return[{type:t.TemplateRef}]},e.propDecorators={name:[{type:t.Input,args:["matStepperIcon"]}]},e}(),y=function(e){function n(t,n){var r=e.call(this,t)||this;return r._errorStateMatcher=n,r}return u(n,e),n.prototype.isErrorState=function(e,t){var n=this._errorStateMatcher.isErrorState(e,t),r=!!(e&&e.invalid&&this.interacted);return n||r},n.decorators=[{type:t.Component,args:[{selector:"mat-step",template:"<ng-template><ng-content></ng-content></ng-template>",providers:[{provide:p.ErrorStateMatcher,useExisting:n}],encapsulation:t.ViewEncapsulation.None,exportAs:"matStep",changeDetection:t.ChangeDetectionStrategy.OnPush}]}],n.ctorParameters=function(){return[{type:S,decorators:[{type:t.Inject,args:[t.forwardRef(function(){return S})]}]},{type:p.ErrorStateMatcher,decorators:[{type:t.SkipSelf}]}]},n.propDecorators={stepLabel:[{type:t.ContentChild,args:[g]}]},n}(n.CdkStep),S=function(e){function n(){var n=null!==e&&e.apply(this,arguments)||this;return n.animationDone=new t.EventEmitter,n._iconOverrides={},n}return u(n,e),n.prototype.ngAfterContentInit=function(){var e=this,t=this._icons.toArray();["edit","done","number"].forEach(function(n){var r=t.find(function(e){return e.name===n});r&&(e._iconOverrides[n]=r.templateRef)}),this._steps.changes.pipe(s.takeUntil(this._destroyed)).subscribe(function(){return e._stateChanged()})},n.prototype._animationDone=function(e){"current"===e.toState&&this.animationDone.emit()},n.decorators=[{type:t.Directive,args:[{selector:"[matStepper]"}]}],n.propDecorators={_stepHeader:[{type:t.ViewChildren,args:[f]}],_steps:[{type:t.ContentChildren,args:[y]}],_icons:[{type:t.ContentChildren,args:[x]}],animationDone:[{type:t.Output}]},n}(n.CdkStepper),_=function(e){function n(){return null!==e&&e.apply(this,arguments)||this}return u(n,e),n.decorators=[{type:t.Component,args:[{selector:"mat-horizontal-stepper",exportAs:"matHorizontalStepper",template:'<div class="mat-horizontal-stepper-header-container"><ng-container *ngFor="let step of _steps; let i = index; let isLast = last"><mat-step-header class="mat-horizontal-stepper-header" (click)="step.select()" (keydown)="_onKeydown($event)" [tabIndex]="_getFocusIndex() === i ? 0 : -1" [id]="_getStepLabelId(i)" [attr.aria-posinset]="i + 1" [attr.aria-setsize]="_steps.length" [attr.aria-controls]="_getStepContentId(i)" [attr.aria-selected]="selectedIndex == i" [attr.aria-label]="step.ariaLabel || null" [attr.aria-labelledby]="(!step.ariaLabel && step.ariaLabelledby) ? step.ariaLabelledby : null" [index]="i" [state]="_getIndicatorType(i)" [label]="step.stepLabel || step.label" [selected]="selectedIndex === i" [active]="step.completed || selectedIndex === i || !linear" [optional]="step.optional" [iconOverrides]="_iconOverrides"></mat-step-header><div *ngIf="!isLast" class="mat-stepper-horizontal-line"></div></ng-container></div><div class="mat-horizontal-content-container"><div *ngFor="let step of _steps; let i = index" class="mat-horizontal-stepper-content" role="tabpanel" [@stepTransition]="_getAnimationDirection(i)" (@stepTransition.done)="_animationDone($event)" [id]="_getStepContentId(i)" [attr.aria-labelledby]="_getStepLabelId(i)" [attr.aria-expanded]="selectedIndex === i"><ng-container [ngTemplateOutlet]="step.content"></ng-container></div></div>',styles:[".mat-stepper-horizontal,.mat-stepper-vertical{display:block}.mat-horizontal-stepper-header-container{white-space:nowrap;display:flex;align-items:center}.mat-stepper-horizontal-line{border-top-width:1px;border-top-style:solid;flex:auto;height:0;margin:0 -16px;min-width:32px}.mat-horizontal-stepper-header{display:flex;height:72px;overflow:hidden;align-items:center;padding:0 24px}.mat-horizontal-stepper-header .mat-step-icon,.mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:8px;flex:none}[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon,[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:8px}.mat-vertical-stepper-header{display:flex;align-items:center;padding:24px;max-height:24px}.mat-vertical-stepper-header .mat-step-icon,.mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:12px}[dir=rtl] .mat-vertical-stepper-header .mat-step-icon,[dir=rtl] .mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:12px}.mat-horizontal-stepper-content[aria-expanded=false]{height:0;overflow:hidden}.mat-horizontal-content-container{overflow:hidden;padding:0 24px 24px 24px}.mat-vertical-content-container{margin-left:36px;border:0;position:relative}[dir=rtl] .mat-vertical-content-container{margin-left:0;margin-right:36px}.mat-stepper-vertical-line::before{content:'';position:absolute;top:-16px;bottom:-16px;left:0;border-left-width:1px;border-left-style:solid}[dir=rtl] .mat-stepper-vertical-line::before{left:auto;right:0}.mat-vertical-stepper-content{overflow:hidden}.mat-vertical-content{padding:0 24px 24px 24px}.mat-step:last-child .mat-vertical-content-container{border:none}"],inputs:["selectedIndex"],host:{class:"mat-stepper-horizontal","aria-orientation":"horizontal",role:"tablist"},animations:[b.horizontalStepTransition],providers:[{provide:S,useExisting:n}],encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],n}(S),w=function(e){function n(t,n){var r=e.call(this,t,n)||this;return r._orientation="vertical",r}return u(n,e),n.decorators=[{type:t.Component,args:[{selector:"mat-vertical-stepper",exportAs:"matVerticalStepper",template:'<div class="mat-step" *ngFor="let step of _steps; let i = index; let isLast = last"><mat-step-header class="mat-vertical-stepper-header" (click)="step.select()" (keydown)="_onKeydown($event)" [tabIndex]="_getFocusIndex() == i ? 0 : -1" [id]="_getStepLabelId(i)" [attr.aria-posinset]="i + 1" [attr.aria-setsize]="_steps.length" [attr.aria-controls]="_getStepContentId(i)" [attr.aria-selected]="selectedIndex === i" [attr.aria-label]="step.ariaLabel || null" [attr.aria-labelledby]="(!step.ariaLabel && step.ariaLabelledby) ? step.ariaLabelledby : null" [index]="i" [state]="_getIndicatorType(i)" [label]="step.stepLabel || step.label" [selected]="selectedIndex === i" [active]="step.completed || selectedIndex === i || !linear" [optional]="step.optional" [iconOverrides]="_iconOverrides"></mat-step-header><div class="mat-vertical-content-container" [class.mat-stepper-vertical-line]="!isLast"><div class="mat-vertical-stepper-content" role="tabpanel" [@stepTransition]="_getAnimationDirection(i)" (@stepTransition.done)="_animationDone($event)" [id]="_getStepContentId(i)" [attr.aria-labelledby]="_getStepLabelId(i)" [attr.aria-expanded]="selectedIndex === i"><div class="mat-vertical-content"><ng-container [ngTemplateOutlet]="step.content"></ng-container></div></div></div></div>',styles:[".mat-stepper-horizontal,.mat-stepper-vertical{display:block}.mat-horizontal-stepper-header-container{white-space:nowrap;display:flex;align-items:center}.mat-stepper-horizontal-line{border-top-width:1px;border-top-style:solid;flex:auto;height:0;margin:0 -16px;min-width:32px}.mat-horizontal-stepper-header{display:flex;height:72px;overflow:hidden;align-items:center;padding:0 24px}.mat-horizontal-stepper-header .mat-step-icon,.mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:8px;flex:none}[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon,[dir=rtl] .mat-horizontal-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:8px}.mat-vertical-stepper-header{display:flex;align-items:center;padding:24px;max-height:24px}.mat-vertical-stepper-header .mat-step-icon,.mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:12px}[dir=rtl] .mat-vertical-stepper-header .mat-step-icon,[dir=rtl] .mat-vertical-stepper-header .mat-step-icon-not-touched{margin-right:0;margin-left:12px}.mat-horizontal-stepper-content[aria-expanded=false]{height:0;overflow:hidden}.mat-horizontal-content-container{overflow:hidden;padding:0 24px 24px 24px}.mat-vertical-content-container{margin-left:36px;border:0;position:relative}[dir=rtl] .mat-vertical-content-container{margin-left:0;margin-right:36px}.mat-stepper-vertical-line::before{content:'';position:absolute;top:-16px;bottom:-16px;left:0;border-left-width:1px;border-left-style:solid}[dir=rtl] .mat-stepper-vertical-line::before{left:auto;right:0}.mat-vertical-stepper-content{overflow:hidden}.mat-vertical-content{padding:0 24px 24px 24px}.mat-step:last-child .mat-vertical-content-container{border:none}"],inputs:["selectedIndex"],host:{class:"mat-stepper-vertical","aria-orientation":"vertical",role:"tablist"},animations:[b.verticalStepTransition],providers:[{provide:S,useExisting:n}],encapsulation:t.ViewEncapsulation.None,changeDetection:t.ChangeDetectionStrategy.OnPush}]}],n.ctorParameters=function(){return[{type:o.Directionality,decorators:[{type:t.Optional}]},{type:t.ChangeDetectorRef}]},n}(S),I=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return u(r,e),r.decorators=[{type:t.Directive,args:[{selector:"button[matStepperNext]",host:{"(click)":"_stepper.next()","[type]":"type"},inputs:["type"],providers:[{provide:n.CdkStepper,useExisting:S}]}]}],r}(n.CdkStepperNext),C=function(e){function r(){return null!==e&&e.apply(this,arguments)||this}return u(r,e),r.decorators=[{type:t.Directive,args:[{selector:"button[matStepperPrevious]",host:{"(click)":"_stepper.previous()","[type]":"type"},inputs:["type"],providers:[{provide:n.CdkStepper,useExisting:S}]}]}],r}(n.CdkStepperPrevious),z=function(){function e(){}return e.decorators=[{type:t.NgModule,args:[{imports:[p.MatCommonModule,c.CommonModule,l.PortalModule,d.MatButtonModule,n.CdkStepperModule,m.MatIconModule,p.MatRippleModule],exports:[p.MatCommonModule,_,w,y,g,S,I,C,f,x],declarations:[_,w,y,g,S,I,C,f,x],providers:[v,p.ErrorStateMatcher]}]}],e}();e.MatStepperModule=z,e.MatStepLabel=g,e.MatStep=y,e.MatStepper=S,e.MatHorizontalStepper=_,e.MatVerticalStepper=w,e.MatStepperNext=I,e.MatStepperPrevious=C,e.MatStepHeader=f,e.MatStepperIntl=v,e.matStepperAnimations=b,e.MatStepperIcon=x,Object.defineProperty(e,"__esModule",{value:!0})});
//# sourceMappingURL=material-stepper.umd.min.js.map
